/*///////////////////////////////////////////////////////////////////////
Copyright (c) 1994-1999 Electrotechnical Laboratry (ETL), AIST, MITI
Copyright (c) 1994-1999 Yutaka Sato

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	mime.c (MIME header encoder/decoder)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	941008	extracted from nntp.c
	950312	encode/decode parts in a multipart message
//////////////////////////////////////////////////////////////////////#*/

#include "mime.h"
char *MimeKit_Version = "1.8";

#define FN_CTE		"Content-Transfer-Encoding"
#define FN_CTE_C	"Content-Transfer-Encoding:"

#define C_HEAD		0x00FF
#define C_HEAD_EW	0x0001
#define C_HEAD_CHAR	0x0002
#define C_HEAD_JREPAIR	0x0004

#define C_BODY		0xFF00
#define C_BODY_CTE	0x0100
#define C_BODY_CHAR	0x0200
#define C_MIME2PGP	0x1000

#define C_CHAR		(C_HEAD_CHAR | C_BODY_CHAR | C_HEAD_JREPAIR)

#define C_ALL		0xFFFFFFFF
#define C_DECODE(f)	(f)
#define C_ENCODE(f)	((f) << 16)

#ifndef MIMECONV
#define MIMECONV	C_DECODE(C_HEAD|C_BODY) | C_ENCODE(C_HEAD|C_BODY)
#endif
int MIME_CONV = MIMECONV;

#define DECODE(flag)	(MIME_CONV & flag)
#define ENCODE(flag)	(MIME_CONV & (flag<<16))

static int maybe_MIME;
static int maybe_NONASCII;
static int got_EOR;

#define DEBUG	syslog_DEBUG

#define O_HEAD	1
#define O_DELIM	2
#define O_BODY	4
#define O_EOR	8
#define O_ALL	0xF
#define O_MIME2PGP	0x100
#define O_TEXTONLY	0x200
#define O_MULTIPART	0x400

#define HEAD_ALSO(filter)	(filter & O_HEAD)
#define DELIM_ALSO(filter)	(filter & O_DELIM)
#define BODY_ALSO(filter)	(filter & O_BODY)
#define EOR_ALSO(filter)	(filter & O_EOR)

#define MIME2PGP(filter)	((filter& O_MIME2PGP) && (PGP_DECR()||PGP_VRFY()))
#define TEXTONLY(filter)	(filter & O_TEXTONLY)
#define MULTIPART(filter)	(filter & O_MULTIPART)

#define C_SIGNED		"multipart/signed"
#define C_ENCRYPTED		"multipart/encrypted"
#define C_PGPSIGN		"application/pgp-signature"
#define C_PGPENCR		"application/pgp-encrypted"

#define C_TEXT		"text/"
#define C_TEXT_PLAIN	"text/plain"
static is_text_plain(ctype)
	char *ctype;
{
	return strncasecmp(ctype,C_TEXT_PLAIN,strlen(C_TEXT_PLAIN))==0;
}
static is_text(ctype)
	char *ctype;
{
	return strncasecmp(ctype,C_TEXT,strlen(C_TEXT))==0;
}

static char *textorso[] = {
	"application/x-unknown-content-type",
	0
};
static tobe_charconv(ctype)
	char *ctype;
{	int ci;
	char *ctype1;

	if( is_text(ctype) )
		return 1;
	for( ci = 0; ctype1 = textorso[ci]; ci++ )
		if( strncasecmp(ctype,ctype1,strlen(ctype1)) == 0 )
			return 1;
	return 0;
}
static is8bitCharset(charset)
	char *charset;
{
	if( strcaseeq(charset,"x-sjis") )
		return 1;
	if( strcaseeq(charset,"Shift_JIS") )
		return 1;
	if( strcaseeq(charset,"x-euc-jp") )
		return 1;
	if( strcaseeq(charset,"EUC-JP") )
		return 1;
	return 0;
}

static conv1(spec)
	char *spec;
{
	if( streq(spec,"thru")) MIME_CONV = 0; else
	if( streq(spec,"all" )) MIME_CONV = C_ALL; else
	if( streq(spec,"enc" )) MIME_CONV |= C_ENCODE(C_HEAD|C_BODY); else 
	if( streq(spec,"dec" )) MIME_CONV |= C_DECODE(C_HEAD|C_BODY); else 
	if( streq(spec,"charcode") )
				MIME_CONV = C_DECODE(C_CHAR)|C_ENCODE(C_CHAR);
	else	syslog_ERROR("#### ERROR: unknown MIMECONV=%s\n",spec);
	return 0;
}
scan_MIMECONV(convspec)
	char *convspec;
{
	if( *convspec == 0 )
		MIME_CONV = C_ENCODE(C_HEAD|C_BODY) | C_DECODE(C_HEAD|C_BODY);
	else	scan_commaList(convspec,0,conv1);
}

static char *fgetsTee(buf,size,in,out,cache)
	char *buf;
	FILE *in,*out,*cache;
{	char *rcode;

	buf[0] = 0;
	if( rcode = fgets(buf,size,in) ){
		if( !isEOR(buf) ){
			if( out != NULL )
				fputs(buf,out);
			if( cache != NULL )
				fputs(buf,cache);
		}
	}
	return rcode;
}
#define MP_EOF	-1	/* real EOF */
#define MP_EOR	-2	/* .<CR><LF> */
#define MP_EOP	-3	/* --boundary-- */
#define MP_EOC	-4	/* --boundary */

static scan_boundary(hp,boundary,size)
	char *hp,*boundary;
{	char *bp;

	if( bp = strcasestr(hp,"boundary=") ){
		bp += strlen("boundary=");
		valuescanX(bp,boundary,size);
	}
}
static push_boundary(boundaries,boundary)
	char *boundaries[],*boundary;
{	int bi;
	for( bi = 0; boundaries[bi]; bi++);
	boundaries[bi] = strdup(boundary);
	boundaries[bi+1] = 0;
	return bi;
}
static top_boundary(boundaries)
	char *boundaries[];
{	int bi;
	for( bi = 0; boundaries[bi]; bi++);
	return bi;
}
static pop_boundary(boundaries,line)
	char *boundaries[],*line;
{	int blen,bi;
	char *b1,*tp;

	if( line[0] == '-' && line[1] == '-' ){
		for( bi = 0; b1 = boundaries[bi]; bi++ ){
			blen = strlen(b1);
			if( strncmp(line+2,b1,blen) == 0 ){
				tp = &line[2+blen];
				if( tp[0]=='-' && tp[1]=='-' ){
					free(b1);
					boundaries[bi] = 0;
					return MP_EOP;
				}else
				if( strchr(" \t\r\n",*tp) )
					return MP_EOC;
			}
		}
	}
	if( isEOR(line) )
		return MP_EOR;
	return 0;
}

static char *guess_charset(text)
	char *text;
{	char *sw;

	if( sw = strstr(text,"\033$") )
		if( sw[2] == '@' || sw[2] == 'B' )
			return "ISO-2022-JP";
	if( sw = strstr(text,"\033(") )
		if( sw[2] == 'J' )
			return "ISO-2022-JP";
	return 0;
}
extern int str_fromqp();
#define BASE64CH(ch) (isalpha(ch) || isdigit(ch) || ch=='+' || ch=='/' || ch=='=' )

str_from64_safe(src,leng,dst,size)
	char *src,*dst;
{	char ch;
	int sx,dx,Bx,cx,isB64,ls,ld,lb;

	Bx = -1;
	dx = 0;

	for( sx = 0; sx < leng; sx = cx ){
		isB64 = 1;
		for( cx = sx; cx < leng; ){
			ch = src[cx++];
			if( ch=='\n' || ch==0 )
				break;
			if( !BASE64CH(ch) && ch!='\r' && ch!=0 )
				isB64 = 0;
		}
		if( isB64 ){
			if( Bx == -1 )
				Bx = sx;
		}else{
			if( Bx != -1 ){
				lb = sx - Bx;
/* str_from64() before mimehead1.2.4 writes NULL at end of source string ... */
ch = src[Bx+lb];
				str_from64(&src[Bx],lb,&dst[dx],size);
src[Bx+lb] = ch;
				Bx = -1;
				ld = strlen(&dst[dx]);
				dx += ld;
				size -= ld;
			}
			ls = cx - sx;
			strncpy(&dst[dx],&src[sx],ls);
			dx += ls;
			dst[dx] = 0;
			size -= ls;
		}
	}
	if( Bx != -1 )
		str_from64(&src[Bx],leng-Bx,&dst[dx],size);
}

static decodeLine(line,dline,encoding)
	char *line,*dline,*encoding;
{	int (*conv)();
	int len;

	if( strcasecmp(encoding,"quoted-printable") == 0 )
		conv = str_fromqp;
	else
	if( strcasecmp(encoding,"base64") == 0 )
		conv = str_from64_safe;
	else	return 0;

	len = strlen(line);
	(*conv)(line,len,dline,len);

	{ /* bug of str_fromqp ? */
	unsigned char *sp;
	for( sp = (unsigned char*)dline; *sp; sp++ )
		if( *sp == 0xFF )
			strcpy((char*)sp,(char*)sp+1);
	}

	return 1;
}

static readHeader(fs,buf,size,cache,filter,ctype,ichset,boundaries,encoding,enHTML)
	FILE *fs,*cache;
	char *buf;
	char *ctype,*ichset,*boundaries[],*encoding;
{	char *hp,*hs,hc;
	int rem,len;
	char cur_field[256];
	int conv_field;
	char boundary[256];
	char tmp[LINESIZE];

	maybe_MIME = 0;
	maybe_NONASCII = 0;
	got_EOR = 0;
	strcpy(ctype,C_TEXT_PLAIN);
	ichset[0] = 0;
	boundary[0] = 0;
	encoding[0] = 0;

	hp = buf;
	buf[0] = 0;
	conv_field = 0;
	cur_field[0] = 0;

	for( rem = size; LINESIZE < rem; ){
		if( fgetsTee(hp,LINESIZE,fs,NULL,cache) == NULL )
			break;
		if( got_EOR = isEOR(hp) ){
			if( !EOR_ALSO(filter) )
				*hp = 0;
			break;
		}
		if( isEOH(hp) ){
			if( !DELIM_ALSO(filter) )
				*hp = 0;
			break;
		}

		if( hp[0] == ' ' || hp[0] == '\t' ){
			if( strcasecmp(cur_field,"Content-Type") == 0 ){
				scan_boundary(hp,boundary,sizeof(boundary));
			}
		}else{
			wordscanY(hp,cur_field,sizeof(cur_field),"^: \t\r\n");
			conv_field = strncasecmp(hp,"Subject:",8) == 0
				  || strncasecmp(hp,"From:",5) == 0;

			if( strncasecmp(hp,"Content-Type:",13) == 0 ){
				wordscanX(hp+13,ctype,128);
				scan_charset(hp,ichset,64);
				scan_boundary(hp,boundary,sizeof(boundary));
			}else
			if( strncasecmp(hp,FN_CTE_C,26)==0 )
				wordscanX(hp+26,encoding,128);
			else
			if( strncasecmp(hp,"Date:",5) == 0 )
				canon_date(hp+5);
		}

		if( enHTML && conv_field ){
			encode_entities(hp,tmp);
			strcpy(hp,tmp);
		}

		for(hs = buf; hc = *hs; hs++ ){
			if( hc == '=' && hs[1] == '?' )
				maybe_MIME = 1;
			if( hc == 033 || hc & 0x80 )
				maybe_NONASCII = 1;
			if( hc == '$' && (hs[1] == 'B' || hs[1] == '@') )
				maybe_NONASCII = 1;
			if( hc == '(' && (hs[1] == 'B' || hs[1] == 'J') )
				maybe_NONASCII = 1;
		}
		len = strlen(hp);
		rem -= len;
		hp += len;
	}
	if( boundary[0] )
		push_boundary(boundaries,boundary);
	return rem;
}

static
scan_multipart(boundaries,endline,size,func,src,dst,cache,filter,arg)
	char *boundaries[];
	char *endline;
	int (*func)();
	FILE *src,*dst,*cache;
	char *arg;
{	char line[LINESIZE];
	int rcode;
	int top;

	/* preamble */
	while( fgetsTee(line,size,src,NULL,cache) != NULL ){
		if( !MIME2PGP(filter) )
		if( !TEXTONLY(filter) )
		fputs(line,dst);
		if( rcode = pop_boundary(boundaries,line) )
			break;
	}

	top = top_boundary(boundaries);

	for(;;){
		if( feof(src) )
			rcode = MP_EOF;
		if( rcode==MP_EOF || rcode==MP_EOR || rcode==MP_EOP )
			break;
		if( top != top_boundary(boundaries) )
			break;
		rcode = (*func)(boundaries,src,dst,cache,filter,arg);
	}

	/*
	 * ``endline'' must return the closing line of the part,
	 * which must be empty in case of MP_EOR because it has been
	 * output already at (*func)(),  or it has really empty
	 * in case of MP_EOF, or ... ??
	 */
	endline[0] = 0;

	/* epilogue */
	if( rcode == MP_EOP ){
		for(;;){
			if( fgetsTee(endline,size,src,NULL,cache) == NULL ){
				rcode = MP_EOF;
				break;
			}
			if( isEOR(endline) ){
				rcode = MP_EOR;
				break;
			}
			if( !TEXTONLY(filter) )
			if( !MIME2PGP(filter) )
				fputs(endline,dst);
		}
	}
	return rcode;
}

static char *readPart(src,dst,cache,boundaries,line,codep,lengp)
	FILE *src,*dst,*cache;
	char *boundaries[];
	char *line;
	int *codep,*lengp;
{	int rcode;
	int leng,len1,reqsize;
	char buff[0x10000];
	FILE *bfile;
	char *tmp;

	rcode = 0;
	leng = 0;
	buff[0] = 0;
	bfile = NULL;

	for(;;){
		line[0] = 0;
		if( fgetsTee(line,LINESIZE,src,dst,cache) == NULL ){
			/*DEBUG("GotEOF: length=%d\n",leng);*/
			rcode = MP_EOF;
			break;
		}
		len1 = strlen(line);
		reqsize = leng + len1 + 1;

		if( rcode = pop_boundary(boundaries,line) )
			break;

		if( bfile == NULL && sizeof(buff) <= reqsize ){
			bfile = TMPFILE("readPart");
			fputs(buff,bfile);
		}
		if( bfile )
			fputs(line,bfile);
		else	strcpy(buff+leng,line);
		leng += len1;
	}
	*lengp = leng;
	*codep = rcode;
	if( bfile ){
		DEBUG("### readPart: got large message (%d)\n",leng);
		fflush(bfile);
		fseek(bfile,0,0);
		tmp = malloc(leng+1);
		fread(tmp,1,leng,bfile);
		tmp[leng] = 0;
		fclose(bfile);
		return tmp;
	}else{
		return strdup(buff);
	}
}

#define JBSIZE(leng)	(leng*2+128)

static scan_charset(header,chset,len)
	char *header,*chset;
{	char *cp;

	if( cp = strcasestr(header,"charset=") )
		valuescanX(cp+8,chset,len);
}
static external_charcode(src,dst,dlen,ichset)
	char *src,*dst,*ichset;
{	int ccx[32];

	CCXcreate(ichset,"ISO-2022-JP",ccx);
	CCXexec(ccx,src,strlen(src),dst,dlen);
}

static encodeBODYpart(fc,ts,ctype,ichset,boundaries,encoding,charsetp)
	FILE *fc,*ts;
	char *ctype,*ichset;
	char *boundaries[],*encoding,**charsetp;
{	unsigned char line[LINESIZE];
	char endline[LINESIZE];
	char *charset = 0;
	int rcode,leng;
	char *tmpa,*tmpb,*tmpc;

	tmpa = readPart(fc,NULL,NULL,boundaries,endline,&rcode,&leng);
	tmpb = malloc(JBSIZE(leng));
	tmpc = malloc(JBSIZE(leng));

DEBUG("BODY-LENG1:%d+%d\n",strlen(tmpa),strlen(endline));

	if( !ENCODE(C_BODY_CHAR) ){
		strcpy(tmpc,tmpa);
		goto OUT;
	}

	/* Decode C-T-E, convert charset, then identify charset.
	 * If the result charset is the one which can be
	 * transferred in "C-T-E: 7bit" (ISO-2022-JP in the current
	 * implementation) C-T-E will be replaced with "7bit".
	 * Otherwise the body is passed through as is.
	 */
	if( !decodeLine(tmpa,tmpb,encoding) )
		strcpy(tmpb,tmpa);

	if( ENCODE(C_BODY_CHAR) )
		external_charcode(tmpb,tmpc,JBSIZE(leng),ichset);
	else	strcpy(tmpc,tmpb);
	if( charset == 0 ){
		if( charset = guess_charset(tmpc) )
			DEBUG("encodeBDOY[charset=%s]\n",charset);
	}
	if( charset == NULL ) /* charset cannot be in "C-T-E: 7bit" */
		strcpy(tmpc,tmpa);
OUT:
/*
	if( strcmp(tmpb,tmpc) == 0 )
		fputs(tmpa,ts);
	else	fputs(tmpc,ts);
*/
	if( tmpc[0] ){
		fputs(tmpc,ts);
		if( *strtail(tmpc) != '\n' )
			fputs("\r\n",ts);
	}

	fputs(endline,ts);
	free(tmpa);
	free(tmpb);
	free(tmpc);

	*charsetp = charset;
	return rcode;
}
relayBODYpart(src,dst,boundaries,extract,endline)
	FILE *src,*dst;
	char *boundaries;
	char *endline;
{	char *tmpa,*ep;
	int rcode,leng;

	tmpa = readPart(src,NULL,NULL,boundaries,endline,&rcode,&leng);
	if( tmpa[0] && extract ){
		ep = &tmpa[strlen(tmpa)-1];
		if( *ep == '\n' ){
			*ep = 0;
			if( tmpa <= --ep && *ep == '\r' )
				*ep = 0;
		}
	}
	fputs(tmpa,dst);
	free(tmpa);
	return rcode;
}
static decodeBODYpart(fs,tc,cache,ctype,boundaries,encoding,decodeto,do_enHTML,endline)
	FILE *fs,*tc,*cache;
	char *ctype,*boundaries[];
	char *encoding,*decodeto;
	char *endline;
{	int rcode,leng;
	char *tmpa,*tmpb;
	int do_conv,plain2html;
	char *xcharset;
	int len,elen;
	char *eol = NULL, *beol = NULL;
	FILE *out_thru;

	do_conv = codeconv_get(ctype,&xcharset,&plain2html);

	*endline = 0;
	if( DECODE(C_BODY) == 0 )
		out_thru = tc;
	else	out_thru = NULL;
	tmpa = readPart(fs,out_thru,cache,boundaries,endline,&rcode,&leng);
	if( tmpa == NULL )
		return -1;
	if( leng == 0 )
		goto EXIT;

	/* guess the end-of-line character(string) of the message ... */
	if( beol = strpbrk(tmpa,"\r\n") ){
		if( *beol == '\r' )
			beol = "\r\n";
		else	beol = "\n";
	}
	if( out_thru ){
		/* message body was already relayed thru ... */
		/* end of body line (except EOR) was already put too */
		if( rcode != MP_EOR )
			endline[0] = 0;
		goto PUTEOL;
	}

	if( plain2html ){
		tmpa = realloc(tmpa,leng*10);
		tmpb = malloc(leng*10);
	}else{
		tmpa = realloc(tmpa,JBSIZE(leng));
		tmpb = malloc(JBSIZE(leng));
	}

	if( DECODE(C_BODY_CTE) && encoding != NULL && decodeto != NULL ){
		DEBUG("decode: %s -> %s\n",encoding,decodeto);
		if( decodeLine(tmpa,tmpb,encoding) )
			strcpy(tmpa,tmpb);
	}
	if( DECODE(C_BODY_CHAR) && do_conv ){
		codeconv_line(tmpa,tmpb,ctype,0);
		strcpy(tmpa,tmpb);
	}
	if( do_enHTML ){
		encode_entities(tmpa,tmpb);
		strcpy(tmpa,tmpb);
	}
	free(tmpb);
EXIT:
	fputs(tmpa,tc);

PUTEOL:
	if( endline[0] )
		eol = strpbrk(endline,"\r\n"); /* maybe .CRLF via NNTP */
	if( eol == NULL )
		eol = beol;
	if( eol && (elen = strlen(eol)) )
	if( len = strlen(tmpa) )
	if( len < elen || strcmp(&tmpa[len-elen],eol) != 0 ){
		fputs(eol,tc);
		DEBUG("supply missing <CR><LF> at the end of BODY part\n");
	}
	free(tmpa);
	return rcode;
}

decodeBODY(fs,tc,filter,encoding,decodeto,do_enHTML)
	FILE *fs,*tc;
	char *encoding,*decodeto;
{	char *boundaries[32];
	char *ctype = "text/plain";
	char endline[LINESIZE];
	int rcode;

	boundaries[0] = 0;
	rcode = decodeBODYpart(fs,tc,NULL,ctype,
			boundaries,encoding,decodeto,do_enHTML,endline);
	if( EOR_ALSO(filter) || endline[0] != '.' )
		fputs(endline,tc);
	return rcode;
}

typedef FILE *(*FFUNC)();
static FFUNC HEAD_filter;

FFUNC set_HEAD_filter(filter)
	FFUNC filter;
{	FFUNC ofilter;

	ofilter = HEAD_filter;
	HEAD_filter = filter;
	return ofilter;
}

extern FILE *NULLFP();

static
decodeMIMEpart(boundaries,fs,tc,cache,filter,enHTML)
	char *boundaries[];
	FILE *fs,*tc,*cache;
{	char head[2][0x10000];
	char ctype[128],ichset[64],encoding[128],*decodeto;
	int hi,nhi;
	int do_enHTML;
	int putPRE;
	int rcode;
	char endline[LINESIZE];
	int do_conv,plain2html;
	char *xcharset;
	FILE *ntc;

	do_conv = codeconv_get(NULL,&xcharset,&plain2html);
	readHeader(fs,head[0],sizeof(head[0]),
		cache,filter,ctype,ichset,boundaries,encoding,enHTML);

	if( got_EOR )
		rcode = MP_EOR;
	else	rcode = 0;

	if( HEAD_filter && boundaries[0] == NULL ){
		ntc = (*HEAD_filter)(head[0],tc,cache);
		if( ntc != NULL )
			tc = ntc;
		else{
			if( EOR_ALSO(filter) )
				fputs(".\r\n",tc);
			tc = NULLFP();
		}
	}

	hi = 0;
	if( DECODE(C_HEAD_EW) )
	if( maybe_MIME ){
		nhi = (hi + 1 ) % 2;
		MIME_strHeaderDecode(head[hi],head[nhi],sizeof(head[1]));
		hi = nhi;
		maybe_NONASCII = 1;
	}

	if( !plain2html )
	if( DECODE(C_HEAD_CHAR) )
	if( maybe_NONASCII && do_conv ){
		nhi = (hi + 1 ) % 2;
		codeconv_line(head[hi],head[nhi],C_TEXT_PLAIN,1);
		hi = nhi;
	}

	if( strncasecmp(ctype,"multipart/",10) == 0 ){
		FILE *mtc;
		int ofilter;
		int mask = 0;

		ofilter = filter;
		if( TEXTONLY(filter) ){
			replaceContentType(head[hi],"text/plain");
			filter |= O_MULTIPART;
			mask = O_HEAD | O_DELIM;
		}

		if( HEAD_ALSO(filter) )
		fputs(head[hi],tc);

		if( rcode == MP_EOR )
			return rcode;

		if( PGP_DECR() || PGP_VRFY() ){
			if( substr(ctype,C_SIGNED) ){
				filter |= O_MIME2PGP;
				filter &= ~O_EOR;
			}else
			if( substr(ctype,C_ENCRYPTED) ){
				filter = 0;
			}
		}

		if( BODY_ALSO(filter) ){
			mtc = tc;
		}else{
			mtc = NULLFP();
			filter = O_ALL;
		}

		filter &= ~mask;
		rcode = scan_multipart(boundaries,endline,sizeof(endline),
				decodeMIMEpart,fs,mtc,cache,filter,enHTML);
		filter = ofilter;
		goto EXIT;
	}

	putPRE = 0;
	if( is_text(ctype) ){ 
		do_enHTML = 0;
		if( is_text_plain(ctype) ){
			do_enHTML = enHTML;
			if( plain2html ){
				putPRE = 1;
				/*do_enHTML = 1;*/
				replaceContentType(head[hi],"text/html");
			}
		}

		if( DECODE(C_BODY_CHAR) && xcharset && is8bitCharset(xcharset)
		 || DECODE(C_BODY_CTE ) && strcaseeq(encoding,"quoted-printable")
	 	 || DECODE(C_BODY_CTE ) && strcaseeq(encoding,"base64") ){
			decodeto = "8bit";
			replaceFieldValue(head[hi],FN_CTE,decodeto);
			DEBUG("decodeMIME[encoding=%s]\n",decodeto);
		}else	decodeto = NULL;

		if( DECODE(C_BODY_CHAR) && xcharset ){
			replace_charset(head[hi],xcharset);
			DEBUG("decodeMIME[charset=%s]\n",xcharset);
		}
	}else{
		do_enHTML = 0;
		decodeto = NULL;
	}

	if( HEAD_ALSO(filter) ){
	if( MIME2PGP(filter) ){
		if( !substr(ctype,C_PGPSIGN) )
			fputsCRLF(head[hi],tc);
	}else
	fputs(head[hi],tc);
	}

	/* EOR is included in the header buffer, thus a EOR immediately
	 * follows a header is put with the header.
	 */
	if( rcode == MP_EOR )
		return MP_EOR;

	endline[0] = 0;
	if( TEXTONLY(filter)
	 && MULTIPART(filter)
	 && strncasecmp(ctype,"text/plain",10) != 0 ){
		DEBUG("## TEXTONLY skip non text/plain: %s\n",ctype);
		rcode = decodeBODYpart(fs,NULLFP(),cache,ctype,boundaries,
				encoding,decodeto,do_enHTML,endline);
	}else
	if( BODY_ALSO(filter) ){
		if( putPRE ) fprintf(tc,"<PRE>\n");

		if( MIME2PGP(filter) )
			if( substr(ctype,C_PGPSIGN) )
				rcode = relay_pgpSIGN(fs,tc,boundaries,endline);
			else	rcode = relay_pgpSIGNED(fs,tc,boundaries,endline);
		else
		rcode = decodeBODYpart(fs,tc,cache,ctype,boundaries,
				encoding,decodeto,do_enHTML,endline);
		if( putPRE ) fprintf(tc,"</PRE>\n");
	}else{
		if( fseek(fs,0,0) == -1 ){
			DEBUG("skip body from stream input.\n");
			RFC821_skipbody(fs,NULL,endline,sizeof(endline));
		}
	}
EXIT:
	if( TEXTONLY(filter) && (rcode == MP_EOP||rcode == MP_EOC) ){
	}else
	if( EOR_ALSO(filter) || endline[0] != '.' && !MIME2PGP(filter) )
		fputs(endline,tc);

	return rcode;
	/*
	 * Result (real) Encoding and Charcode should be set in the header
	 * after this decoding...
	 */
}

fputsCRLF(str,out)
	char *str;
	FILE *out;
{	char *bp;
	int ch,pch;

	pch = 0;
	for( bp = str; ch = *bp; bp++ ){
		if( ch == '\n' && pch != '\r' )
			putc('\r',out);
		putc(ch,out);
		if( ch == '\r' && bp[1] != '\n' )
			putc('\n',out);
		pch = ch;
	}
}

static
encodeMIMEpart(boundaries,fc,ts,cache,filter)
	char *boundaries[];
	FILE *fc,*ts,*cache;
{	char head[2][0x10000];
	int hi,nhi;
	FILE *tmp;
	char *charset,ctype[128],ichset[64],encoding[128];
	int rcode;
	char endline[LINESIZE];

	readHeader(fc,head[0],sizeof(head[0]),
		cache,filter,ctype,ichset,boundaries,encoding,0);
	if( got_EOR )
		rcode = MP_EOR;
	else	rcode = 0;

	hi = 0;
	if( maybe_NONASCII ){
		if( ENCODE(C_HEAD_CHAR) )
			external_charcode(head[0],head[1],0x10000,ichset);
		else	strcpy(head[1],head[0]);
		if( strcmp(head[0],head[1]) != 0 ){
			DEBUG("POST: code converted.\n");
		}
		if( ENCODE(C_HEAD_EW) )
			MIME_strHeaderEncode(head[1],head[0],sizeof(head[0]));
	}

	if( strncasecmp(ctype,"multipart/",10) == 0 ){
		fputs(head[hi],ts);
		rcode = scan_multipart(boundaries,endline,sizeof(endline),
				encodeMIMEpart,fc,ts,cache,filter,NULL);
		fputs(endline,ts);
		return rcode;
	}

	if( rcode == MP_EOR ){
		fputs(head[hi],ts);
	}else
	if( is_text(ctype) || tobe_charconv(ctype) ){
		tmp = TMPFILE("encodeMIMEpart");
		charset = 0;
		rcode = encodeBODYpart(fc,tmp,ctype,ichset,boundaries,encoding,&charset);
		if( charset ){
			replace_charset(head[hi],charset);
			if( findField(head[hi],FN_CTE,NULL) )
			replaceFieldValue(head[hi],FN_CTE,"7bit");
		}
		fflush(tmp);
		fseek(tmp,0,0);
		fputs(head[hi],ts);
		copyfile1(tmp,ts);
		fclose(tmp);
	}else{
		fputs(head[hi],ts);
		rcode = relayBODYpart(fc,ts,boundaries,0,endline);
		fputs(endline,ts);
	}
	return rcode;
}

thruRESP(fs,tc)
	FILE *fs,*tc;
{	char line[LINESIZE];

	relayRESPBODY(fs,tc,line,sizeof(line));
	fputs(line,tc);
}

static delWhites(str)
	char *str;
{	char ch,*sp,*dp;

	dp = str;
	for( sp = str; ch = *sp; sp++ ){
		if( ch != '\t' && ch != '\r' && ch != '\n' )
			*dp++ = ch;
	}
	*dp = 0;
}
decodeTERM1(line,xline)
	char *line,*xline;
{	char *xp,*tp,dc,*np;
	int do_conv,plain2html;
	char *xcharset;

	if( !DECODE(C_HEAD) ){
		strcpy(xline,line);
		return;
	}

	do_conv = codeconv_get(NULL,&xcharset,&plain2html);

	xp = xline;
	for( tp = line; *tp; tp = np ){
		if( np = strpbrk(tp,"\t\r\n") ){
			dc = *np;
			*np = 0;
		}
		if( *tp ){
			decodeHEAD1(tp,xp,
				DECODE(C_HEAD_EW),
				DECODE(C_HEAD_CHAR) && !plain2html);
			xp += strlen(xp);
		}
		if( np ){
			*np++ = dc;
			*xp++ = dc;
		}else	break;
	}
	*xp = 0;
}

decodeHEAD1(tp,xp,decode,cconv)
	char *tp,*xp;
{	int convert;
	char term[0x4000],xterm[0x4000];
	char *ts;

	convert = 0;
	for( ts = tp; *ts; ts++ ){
		if( ts[0] == '=' && ts[1] == '?'
		 || ts[0] == '$' &&(ts[1] == 'B' || ts[1] == '@')
		 || ts[0] == 033
		 || ts[0] & 0x80
		){
			convert = 1;
			break;
		}
	}
	if( convert ){
		if( decode )
			MIME_strHeaderDecode(tp,term,sizeof(term));
		else	strcpy(term,tp);

		/* remove possible white spaces
		 * insterted by MIME decoder (-_-; */
		delWhites(term);

		if( cconv ){
			codeconv_line(term,xterm,C_TEXT_PLAIN,1);
			strcpy(xp,xterm);
		}else	strcpy(xp,term);
	}else	strcpy(xp,tp);
}

decodeTERM(fs,tc,enHTML)
	FILE *fs,*tc;
{	char line[0x8000],xline[0x8000];

	while( fgets(line,sizeof(line),fs) != NULL){
		if( isEOR(line) ){
			fputs(line,tc);
			break;
		}
		if( DECODE(C_HEAD) ){
			decodeTERM1(line,xline);
			fputs(xline,tc);
		}else	fputs(line,tc);
	}
}

encodeMIME(fc,ts)
	FILE *fc,*ts;
{	char *boundaries[32];

	boundaries[0] = 0;
	encodeMIMEpart(boundaries,fc,ts,NULL,O_ALL);
}

decodeMIME(fs,tc,cache,filter,codeconv,enHTML)
	FILE *fs,*tc,*cache;
{	char *boundaries[32];
	int ssc;

	ssc = codeconv_set(codeconv,NULL,-1);
	boundaries[0] = 0;
	decodeMIMEpart(boundaries,fs,tc,cache,filter,enHTML);
	codeconv_set(ssc,NULL,-1);
}

deMime(ac,av)
	char *av[];
{
	decodeMIME(stdin,stdout,NULL,O_ALL,1,0);
}
enMime(ac,av)
	char *av[];
{
	encodeMIME(stdin,stdout);
}
