#include <stdio.h>
int LOOPCOUNT = 1000;

static char external[128] = "fromMime";

#define DUMMY	1
#define LINKED	2
#define TMPFILE	4
#define OVERW	8
#define VIAPIPE	16
#define EXTERN	(int)external

FILE *afp;
int flags;

scanarg(ac,av)
	char *av[];
{	int ai;
	char *arg,*af;

	for( ai = 1; ai < ac; ai++ ){
		arg = av[ai];
		if( *arg == '-' ){
			for( af = &arg[1]; *af; af++ )
			switch( *af ){
				case 'd': flags |= DUMMY;   break;
				case 'l': flags |= LINKED;  break;
				case 't': flags |= TMPFILE; break;
				case 'o': flags |= OVERW;   break;
				case 'p': flags |= VIAPIPE; break;
				case 'C':
					LOOPCOUNT = atoi(af+1);
					break;
			}
		}else{
			afp = fopen(arg,"r");
			if( afp == NULL ){
				perror(arg);
				exit(1);
			}
		}
	}
	if( flags == 0 )
		flags = 0xFF;
	if( afp == NULL )
		afp = fopen("README.jp","r");
	if( afp == NULL )
		exit(1);
}

main(ac,av)
	char *av[];
{	char line[1024];
	char head[4096];
	int i,startat;

	scanarg(ac,av);

	/*
	 *	load a sample header into "head"
	 */
	head[0] = 0;
	while( fgets(line,sizeof(line),afp) != NULL ){
		if( line[0] == '\n' )
			break;
		strcat(head,line);
	}

	/*
	 *	non decoded dead copy
	 */
	if( flags & DUMMY )
		decodes(DUMMY,LOOPCOUNT,head,0);

	/*
	 *	call the statically linked decoder
	 */
	if( flags & LINKED )
		decodes(LINKED,LOOPCOUNT,head,0);

	/*
	 *	feed header to the decoder(fromMime) via PIPE
	 */
	if( flags & VIAPIPE )
		decodes(EXTERN,LOOPCOUNT,head,0);

	/*
	 *
	 */
	fseek(afp,0,0);
	if( flags & OVERW )
		decodes(OVERW, LOOPCOUNT,head,afp);

	fseek(afp,0,0);
	if( flags & TMPFILE )
		decodes(TMPFILE, LOOPCOUNT,head,afp);
}

popen2(inout,command)
	FILE *inout[];
	char *command;
{	int to[2],from[2];
	register int cpid;
	char commandx[1024];

	pipe(to);
	pipe(from);
	if( (cpid = fork()) == 0 ){
		close(to[1]);  close(0); dup(to[0]);  close(to[0]);
		close(from[0]);close(1); dup(from[1]);close(from[1]);
		if( strncmp("exec ",command,5) != 0 ){
			sprintf(commandx,"exec %s",command);
			command = commandx;
		}
		system(command);
		exit(0);
	}else{
		inout[0] = fdopen(from[0],"r");
		inout[1] = fdopen(to[1],  "w");
		close(to[0]);
		close(from[1]);
	}
	return cpid;
}
MIME_openProc(io,decoder)
	FILE *io[];
{
	popen2(io,decoder);
}
#define FLUSH "\f\n"
MIME_decodeProc(io,art,dart,size)
	FILE *io[];
	char *art,*dart;
{	char *dp;

	fputs(art,io[1]);
	fputs(FLUSH,io[1]);
	fflush(io[1]);

	dp = dart;
	while( fgets(dp,256,io[0]) != NULL ){
		if( strcmp(dp,FLUSH) == 0 ){
			*dp = 0;
			break;
		}
		dp += strlen(dp);
	}
}


extern FILE *MIME_tmpHeaderDecode();
decodes(decoder,count,art,afp)
	char *art;
	FILE *afp;
{	FILE *io[2];
	char dart[4096];
	int i,startat;
	char *sdecoder;

	if( decoder == DUMMY  )	sdecoder = "DUMMY";  else
	if( decoder == LINKED )	sdecoder = "LINKED"; else
	if( decoder == OVERW  )	sdecoder = "OVERW";  else
	if( decoder == TMPFILE)	sdecoder = "TMPFILE";else
				sdecoder = "VIAPIPE";

	printf("%-8s insize = %d bytes, loop = %d   ",sdecoder,strlen(art),count);
	fflush(stdout);
	startat = time(0);

	if( decoder == EXTERN )
		MIME_openProc(io,decoder);

	for( i = 0; i < count; i++ ){
		if( i % 100 == 0 ){
			printf("%4d\b\b\b\b",i);
			fflush(stdout);
		}
		if( decoder == DUMMY )
			dummy_decoder(art,dart,sizeof(dart));
		else
		if( decoder == LINKED )
			MIME_strHeaderDecode(art,dart,sizeof(dart));
		else
		if( decoder == OVERW )
			MIME_headerDecodeOverwrite(afp);
		else
		if( decoder == TMPFILE ){
			fclose(MIME_tmpHeaderDecode(afp,0));
			fseek(afp,0,0);
		}else	MIME_decodeProc(io,art,dart);
	}
	printf(" %2d seconds  (out %d bytes)\n",time(0)-startat,strlen(dart));
}
dummy_decoder(head,dhead)
	char *head,*dhead;
{	char *lp,*np;
	char line[1024];

	*dhead = 0;
	for( lp = head; *lp; lp = np + 1 ){
		if( np = (char*)strchr(lp,'\n') ){
			*np = 0;
			strcpy(line,lp);
			*np = '\n';
		}else	strcpy(line,lp);
		strcat(dhead,line);
		if( np == 0 )
			break;
	}
}
