#include <io.h>
#include <sys/locking.h>

static Locking(fd,type,bytes)
{ 	int off,rcode;

	rcode = -1;
	if( 0 <= (off = tell(fd)) )
	if( 0 <= lseek(fd,0,0) ){
		rcode = locking(fd,type,bytes);
		lseek(fd,off,0);
	}
	if( rcode == -1 && !file_isregular(fd) ){
		/* treat as success, 
		 * mainly for lock_TIMEOUT not to wait non-lockable file ... ?
		 */
		rcode = 0;
	}
	return rcode;
}

SHlockB(fd){	return	Locking(fd,_LK_RLCK,1); }
SHlockNB(fd){	return	Locking(fd,_LK_NBRLCK,1); }
EXlockB(fd){	return	Locking(fd,_LK_LOCK,1); }
EXlockNB(fd){	return	Locking(fd,_LK_NBLCK,1); }
UNlock(fd){	return	Locking(fd,_LK_UNLCK,1); }
