/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2000 Peter Mattis and Spencer Kimball
 *
 * gimplayer.h
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GIMP_LAYER_H__
#define __GIMP_LAYER_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* For information look into the C source or the html documentation */

#define gimp_layer_get_mask_id               gimp_layer_mask
#define gimp_layer_get_image_id              gimp_drawable_image
#define gimp_layer_is_floating_selection     gimp_layer_is_floating_sel
#define gimp_layer_get_preserve_transparency gimp_layer_get_preserve_trans
#define gimp_layer_set_preserve_transparency gimp_layer_set_preserve_trans


gint32   gimp_layer_new  (gint32                image_ID,
			  gchar                *name,
			  gint                  width,
			  gint                  height,
			  GimpImageType         type,
			  gdouble               opacity,
			  GimpLayerModeEffects  mode);
gint32   gimp_layer_copy (gint32                layer_ID);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GIMP_LAYER_H__ */
