
=head1 NAME

PDL::Types - define fundamental PDL Datatypes

=head1 SYNOPSIS

 use PDL::Types;

 $pdl = ushort( 2.0, 3.0 );
 print "The actual c type used to store ushort's is '" .
    $pdl->type->realctype() . "'\n";
 The actual c type used to store ushort's is 'unsigned short'

=head1 DESCRIPTION

Internal module - holds all the PDL Type info.  This can be
accessed using the C<PDL::Type> object returned by
the L<type|PDL::Core/type> method.

=cut

### Generated from Types.pm.PL automatically - do not modify! ###

package PDL::Types;
require Exporter;

@EXPORT = qw( $PDL_B $PDL_S $PDL_US $PDL_L $PDL_F $PDL_D @pack %typehash );
@ISA    = qw( Exporter );

# Data types/sizes (bytes) [must be in order of complexity]

# Enum
( $PDL_B, $PDL_S, $PDL_US, $PDL_L, $PDL_F, $PDL_D ) = (0..5);

# Corresponding pack types
@PDL::Types::pack=("C*", "s*", "S*", "l*", "f*", "d*");
@PDL::Types::names= qw/PDL_B PDL_S PDL_US PDL_L PDL_F PDL_D/;

# should be usable in a couple of places, e.g. Dev.pm (how to locate
# during compilation?) and PDL::PP::PDLCode, also used in PDL::Dbg
#
%PDL::Types::typehash = (
   'PDL_B' => {
     numval => $PDL_B, sym => 'PDL_B', ctype => 'PDL_Byte',
     ppsym => 'B', realctype => 'unsigned char'
             },
   'PDL_S' => {
     numval => $PDL_S, sym => 'PDL_S', ctype => 'PDL_Short',
     ppsym => 'S', realctype => 'short'
             },
   'PDL_US' => {
     numval => $PDL_US, sym => 'PDL_US', ctype => 'PDL_Ushort',
     ppsym => 'U', realctype => 'unsigned short'
             },
   'PDL_L' => {
     numval => $PDL_L, sym => 'PDL_L', ctype => 'PDL_Long',
     ppsym => 'L', realctype => 'int'
             },
   'PDL_F' => {
     numval => $PDL_F, sym => 'PDL_F', ctype => 'PDL_Float',
     ppsym => 'F', realctype => 'float'
             },
   'PDL_D' => {
     numval => $PDL_D, sym => 'PDL_D', ctype => 'PDL_Double',
     ppsym => 'D', realctype => 'double'
             },
);


=head1 OBJECTS

This module declares one class - C<PDL::Type> - objects of this class
are returned by the L<type|PDL::Core/type> method of a piddle.  It has
several methods, listed below, which provide an easy way to access
type information:

Additionally, comparison and stringification are overloaded so that
you can compare and print type objects, e.g.

  $nofloat = 1 if $pdl->type < float;
  die "must be double" if $type != double;

For further examples check again the
L<type|PDL::Core/type> method.

=over 4

=item enum

Returns the number representing this datatype (see L<get_datatype|PDL::Core/PDL::get_datatype>).

=item symbol

Returns one of 'PDL_B', 'PDL_S', 'PDL_US', 'PDL_L', 'PDL_F' or 'PDL_D'. 

=item ctype

Returns the macro used to represent this type in C code (eg 'PDL_Long').

=item ppsym

The letter used to represent this type in PP code code (eg 'U' for L<ushort|PDL::Core/ushort>).

=item realctype

The actual C type used to store this type.

=item shortctype

The value returned by C<ctype> without the 'PDL_'.

=cut

{
    package PDL::Type;
    sub new {
        my($type,$val) = @_;
        if("PDL::Type" eq ref $val) { return bless [@$val],$type; }
        if(ref $val and $val->isa(PDL)) {
            if($val->getndims != 0) {
              PDL::Core::barf("Can't make a type out of non-scalar piddle $val!");
            }
            $val = $val->at;
        }
      PDL::Core::barf("Can't make a type out of non-scalar $val!".(ref $val)."!") if ref $val;
        return bless [$val],$type;
    }
 
sub enum   { return $_[0]->[0]; }
sub symbol { return $PDL::Types::names[ $_[0]->enum ]; }
sub ctype { return $PDL::Types::typehash{$_[0]->symbol}->{ctype}; }
sub ppsym { return $PDL::Types::typehash{$_[0]->symbol}->{ppsym}; }
sub realctype { return $PDL::Types::typehash{$_[0]->symbol}->{realctype}; }
sub shortctype { my $txt = $_[0]->ctype; $txt =~ s/PDL_//; return $txt; }      

# make life a bit easier
use overload (
	      "\"\""  => sub { lc $_[0]->shortctype },
	      "<=>"   => sub { $_[2] ? $_[1]->enum <=> $_[0]->enum :
	                               $_[0]->enum <=> $_[1]->enum },
	     );

} # package: PDL::Type                                                          

# Return
1;

