
#
# GENERATED WITH PDL::PP! Don't modify!
#
package PDL::Slices;

@EXPORT_OK  = qw( PDL::PP affineinternal PDL::PP identity PDL::PP index PDL::PP index2d PDL::PP rld PDL::PP rle PDL::PP flowconvert PDL::PP converttypei PDL::PP _clump_int PDL::PP xchg PDL::PP mv PDL::PP oneslice PDL::PP slice  using PDL::PP affine PDL::PP diagonalI PDL::PP lags PDL::PP splitdim PDL::PP rotate PDL::PP threadI PDL::PP identvaff PDL::PP unthread  dice dice_axis );
%EXPORT_TAGS = (Func=>[@EXPORT_OK]);

use PDL::Core;
use PDL::Exporter;
use DynaLoader;



   
   @ISA    = ( 'PDL::Exporter','DynaLoader' );
   push @PDL::Core::PP, __PACKAGE__;
   bootstrap PDL::Slices ;





=head1 NAME

PDL::Slices -- Stupid index tricks

=head1 SYNOPSIS

  use PDL;
  $a = ones(3,3);
  $b = $a->slice('-1:0,(1)');
  $c = $a->dummy(2);


=head1 DESCRIPTION

This package provides many of the powerful PerlDL core index
manipulation routines. These routines are usually two-way
so you can get a unit matrix by

 $a = zeroes(1000,1000);
 $a->diagonal(0,1) ++;

which is usually fairly efficient. See L<PDL::Indexing> and
L<PDL::Tips> for more examples.

These functions are usually two-way:

 $b = $a->slice("1:3");
 $b += 5;   		# $a is changed!

If you want to force a copy and no "flow" backwards, you need

 $b = $a->slice("1:3")->copy;
 $b += 5;		# $a is not changed.

alternatively, you can use

 $b = $a->slice("1:3")->sever;

which does not copy the struct but beware that after

 $b = $a->slice("1:3");
 $c = $b->sever;

the variables C<$b> and C<$c> point to the same object but with 
C<-E<gt>copy> they do not.

The fact that there is this kind of flow makes PDL a very
powerful language in many ways: since you can alter the original
data by altering some easier-to-use representation of it, many things are
much easier to accomplish, just like making the above unit matrix.

=cut

use PDL::Core ':Internal';







=head1 FUNCTIONS



=cut






*affineinternal = \&PDL::affineinternal;




*identity = \&PDL::identity;




=head2 index

=for sig

  Signature: (a(n); int ind(); [oca] c())

=for ref

These functions provide rudimentary index indirection.

=for example

 $c = a(ind());
 $c = a(ind1(),ind2());

It would be useful to have a more complete function for this
at some point, or at least a perl wrapper, that allows

 $c = $a->islice("1:2",$ind1,"3:4",$ind2);

with many dimensions.

This function is two-way, i.e. after

 $c = $a->index(pdl[0,5,8]);
 $c .= pdl [0,2,4];

the changes in C<$c> will flow back to C<$a>.





=cut






*index = \&PDL::index;




=head2 index2d

=for sig

  Signature: (a(na,nb); int inda(); int indb(); [oca] c())

=for ref

These functions provide rudimentary index indirection.

=for example

 $c = a(ind());
 $c = a(ind1(),ind2());

It would be useful to have a more complete function for this
at some point, or at least a perl wrapper, that allows

 $c = $a->islice("1:2",$ind1,"3:4",$ind2);

with many dimensions.

This function is two-way, i.e. after

 $c = $a->index(pdl[0,5,8]);
 $c .= pdl [0,2,4];

the changes in C<$c> will flow back to C<$a>.





=cut






*index2d = \&PDL::index2d;




=head2 rld

=for sig

  Signature: (int a(n); b(n); [o]c(m))

=for ref

Run-length decode a vector

Given a vector C<$a> of the numbers of instances of values C<$b>, run-length
decode to C<$c>.

=for example

 rld($a,$b,$c=null);





=cut




sub PDL::rld {
  my ($a,$b) = @_;
  my ($c);
  if ($#_ == 2) {
    $c = $_[2];
  } else {
# XXX Need to improve emulation of threading in auto-generating c
    my ($size) = $a->sumover->max;
    my (@dims) = $a->dims;
    shift @dims;
    $c = $b->zeroes($size,@dims);
  }
  &PDL::_rld_int($a,$b,$c);
  $c;
}


*rld = \&PDL::rld;




=head2 rle

=for sig

  Signature: (c(n); int [o]a(n); [o]b(n))

=for ref

Run-length encode a vector

Given vector C<$c>, generate a vector C<$a> with the number of each element,
and a vector C<$b> of the unique values.  Only the elements up to the
first instance of `0' in C<$a> should be considered.

=for example

 rle($c,$a=null,$b=null);





=cut






*rle = \&PDL::rle;




*flowconvert = \&PDL::flowconvert;




*converttypei = \&PDL::converttypei;




*_clump_int = \&PDL::_clump_int;




=head2 xchg

=for sig

  Signature: (P(); C(); int n1; int n2)

=for ref

exchange two dimensions

Negative dimension indices count from the end.

The command

=for example

 $b = $a->xchg(2,3);

creates C<$b> to be like C<$a> except that the dimensions 2 and 3
are exchanged with each other i.e.

 $b->at(5,3,2,8) == $a->at(5,3,8,2)





=cut






*xchg = \&PDL::xchg;



=head2 reorder

=for ref

Re-orders the dimensions of a PDL based on the supplied list.

Similar to the L<xchg|/xchg> method, this method re-orders the dimensions
of a PDL. While the L<xchg|/xchg> method swaps the position of two dimensions,
the reorder method can change the positions of many dimensions at
once.

=for usage

 # Completely reverse the dimension order of a 6-Dim array.
 $reOrderedPDL = $pdl->reorder(5,4,3,2,1,0); 

The argument to reorder is an array representing where the current dimensions
should go in the new array. In the above usage, the argument to reorder 
C<(5,4,3,2,1,0)>
indicates that the old dimensions (C<$pdl>'s dims) should be re-arranged to make the
new pdl (C<$reOrderPDL>) according to the following:

   Old Position   New Position
   ------------   ------------
   5              0
   4              1
   3 		  2
   2		  3
   1		  4
   0		  5

=for example 

Example:

 perldl> $a = sequence(5,3,2);	  # Create a 3-d Array
 perldl> p $a
 [
  [
   [ 0  1  2  3  4]
   [ 5  6  7  8  9]
   [10 11 12 13 14]
  ]
  [
   [15 16 17 18 19]
   [20 21 22 23 24]
   [25 26 27 28 29]
  ]
 ]
 perldl> p $a->reorder(2,1,0); # Reverse the order of the 3-D PDL
 [
  [
   [ 0 15]
   [ 5 20]
   [10 25]
  ]
  [
   [ 1 16]
   [ 6 21]
   [11 26]
  ]
  [
   [ 2 17]
   [ 7 22]
   [12 27]
  ]
  [
   [ 3 18]
   [ 8 23]
   [13 28]
  ]
  [
   [ 4 19]
   [ 9 24]
   [14 29]
  ]
 ]

The above is a simple example that could be duplicated by calling
C<$a-E<gt>xchg(0,2)>, but it demonstrates the basic functionality of reorder.

As this is an index function, any modifications to the
result PDL will change the parent.

=cut

sub PDL::reorder {
	my ($pdl,@newDimOrder) = @_;
	
	my $arrayMax = $#newDimOrder;
  
	#Error Checking:
	if( $pdl->getndims != scalar(@newDimOrder) ){
		my $errString = "PDL::reoderDims: Number of elements (".scalar(@newDimOrder).") in newDimOrder array doesn't\n";
		$errString .= "match the number of dims in the supplied PDL ($ndims)\n";
		barf($errString);
	}
	# a quicker way to do the reorder
	return $pdl->thread(@newDimOrder)->unthread(0);
}





=head2 mv

=for sig

  Signature: (P(); C(); int n1; int n2)

=for ref

move a dimension to another position

The command

=for example

 $b = $a->mv(4,1);

creates C<$b> to be like C<$a> except that the dimension 4 is moved to the
place 1, so:

 $b->at(1,2,3,4,5,6) == $a->at(1,5,2,3,4,6);

The other dimensions are moved accordingly.
Negative dimension indices count from the end.




=cut






*mv = \&PDL::mv;




=head2 oneslice

=for sig

  Signature: (P(); C(); int nth; int from; int step; int nsteps)

=for ref

experimental function - not for public use

=for example

 $a = oneslice();

This is not for public use currently. See the source if you have to.
This function can be used to accomplish run-time changing of
transformations i.e. changing the size of some piddle at run-time.

However, the mechanism is not yet finalized and this is just a demonstration.





=cut






*oneslice = \&PDL::oneslice;




=head2 slice

=for sig

  Signature: (P(); C(); char* str)

=for ref

Returns a rectangular slice of the original piddle

=for example

 $a->slice('1:3');  #  return the second to fourth elements of $a
 $a->slice('3:1');  #  reverse the above
 $a->slice('-2:1'); #  return last-but-one to second elements of $a

The argument string is a comma-separated list of what to do
for each dimension. The current formats include
the following, where I<a>, I<b> and I<c> are integers and can
take legal array index values (including -1 etc):

=over 8

=item :

takes the whole dimension intact.

=item ''

(nothing) is a synonym for ":"
(This means that C<$a-E<gt>slice(':,3')> is equal to C<$a-E<gt>slice(',3')>).

=item a

slices only this value out of the corresponding dimension.

=item (a)

means the same as "a" by itself except that the resulting
dimension of length one is deleted (so if C<$a> has dims C<(3,4,5)> then
C<$a-E<gt>slice(':,(2),:')> has dimensions C<(3,5)> whereas
C<$a-E<gt>slice(':,2,:')> has dimensions C<(3,1,5))>.

=item a:b

slices the range I<a> to I<b> inclusive out of the dimension.

=item a:b:c

slices the range I<a> to I<b>, with step I<c> (i.e. C<3:7:2> gives the indices
C<(3,5,7)>). This may be confusing to Matlab users but several other
packages already use this syntax.

=item '*'

inserts an extra dimension of width 1 and

=item '*a'

inserts an extra (dummy) dimension of width I<a>.

=back

An extension is planned for a later stage allowing
C<$a-E<gt>slice('(=1),(=1|5:8),3:6(=1),4:6')>
to express a multidimensional diagonal of C<$a>.





=cut






*slice = \&PDL::slice;



=head2 using

=for ref

Returns array of column numbers requested

=for usage

 line $pdl->using(1,2);

Plot, as a line, column 1 of C<$pdl> vs. column 2

=for example

 perldl> $pdl = rcols("file");
 perldl> line $pdl->using(1,2);

=cut

*using = \&PDL::using;
sub PDL::using {
  my ($x,@ind)=@_;
  @ind = list $ind[0] if (ref $ind[0] eq 'PDL');
  foreach (@ind) {
    $_ = $x->slice("($_)");
  }
  @ind;
}





*affine = \&PDL::affine;




=head2 diagonalI

=for sig

  Signature: (P(); C(); SV *list)

=for ref

Returns the multidimensional diagonal over the specified dimensions.

The diagonal is placed at the first (by number) dimension that is
diagonalized.
The other diagonalized dimensions are removed. So if C<$a> has dimensions
C<(5,3,5,4,6,5)> then after

=for example

 $b = $a->diagonal(0,2,5);

the piddle C<$b> has dimensions C<(5,3,4,6)> and 
C<$b-E<gt>at(2,1,0,1)> refers
to C<$a-E<gt>at(2,1,2,0,1,2)>.

NOTE: diagonal doesn't handle threadids correctly. XXX FIX





=cut






*diagonalI = \&PDL::diagonalI;




=head2 lags

=for sig

  Signature: (P(); C(); int nthdim; int step; int n)

=for ref

Returns a piddle of lags to parent.

Usage:

=for usage

  $lags = $a->lags($nthdim,$step,$nlags);

I.e. if C<$a> contains

 [0,1,2,3,4,5,6,7]

then

=for example

 $b = $a->lags(0,2,2);

is a (5,2) matrix

 [2,3,4,5,6,7]
 [0,1,2,3,4,5]

This order of returned indices is kept because the function is
called "lags" i.e. the nth lag is n steps behind the original.

C<$step> and C<$nlags> must be positive. C<$nthdim> can be
negative and will then be counted from the last dim backwards
in the usual way (-1 = last dim).





=cut






*lags = \&PDL::lags;




=head2 splitdim

=for sig

  Signature: (P(); C(); int nthdim; int nsp)

=for ref

Splits a dimension in the parent piddle (opposite of L<clump|/clump>)

After

=for example

 $b = $a->splitdim(2,3);

the expression

 $b->at(6,4,x,y,3,6) == $a->at(6,4,x+3*y)

is always true (C<x> has to be less than 3).





=cut






*splitdim = \&PDL::splitdim;




=head2 rotate

=for sig

  Signature: (x(n); int shift(); [oca]y(n))

=for ref

Shift vector elements along with wrap. Flows data back&forth.





=cut






*rotate = \&PDL::rotate;




=head2 threadI

=for sig

  Signature: (P(); C(); int id; SV *list)

=for ref

internal

Put some dimensions to a threadid.

=for example

 $b = $a->threadI(0,1,5); # thread over dims 1,5 in id 1





=cut






*threadI = \&PDL::threadI;




=head2 identvaff

=for sig

  Signature: (P(); C())

=for ref

A vaffine identity transformation (includes thread_id copying).

Mainly for internal use.





=cut






*identvaff = \&PDL::identvaff;




=head2 unthread

=for sig

  Signature: (P(); C(); int atind)

=for ref

All threaded dimensions are made real again.

See [TBD Doc] for details and examples.





=cut






*unthread = \&PDL::unthread;



=head2 dice

=for ref

Dice rows/columns/planes out of a PDL using indexes for
each dimension.

This function can be used to extract irregular subsets
along many dimension of a PDL, e.g. only certain rows in an image,
or planes in a cube. This can of course be done with
the usual dimension tricks but this saves having to
figure it out each time!

This method is similar in functionality to the L<slice|/slice>
method, but L<slice|/slice> requires that contiguous ranges or ranges
with constant offset be extracted. ( i.e. L<slice|/slice> requires 
ranges of the form C<1,2,3,4,5> or C<2,4,6,8,10>). Because of this
restriction, L<slice|/slice> is more memory efficient and slightly faster
than dice

=for usage

 $slice = $data->dice([0,2,6],[2,1,6]); # Dicing a 2-D array

The arguments to dice are arrays (or 1D PDLs) for each dimension
in the PDL. These arrays are used as indexes to which rows/columns/cubes,etc
to dice-out (or extract) from the C<$data> PDL. 

Use C<X> to select all indices along a given dimension (compare also
L<mslice|PDL::Core/mslice>). As usual (in slicing methods) trailing
dimensions can be omitted implying C<X>'es for those.

=for example 

 perldl> $a = sequence(10,4)
 perldl> p $a
 [
  [ 0  1  2  3  4  5  6  7  8  9]
  [10 11 12 13 14 15 16 17 18 19]
  [20 21 22 23 24 25 26 27 28 29]
  [30 31 32 33 34 35 36 37 38 39]
 ]
 perldl> p $a->dice([1,2],[0,3]) # Select columns 1,2 and rows 0,3
 [
  [ 1  2]
  [31 32]
 ]
 perldl> p $a->dice(X,[0,3])
 [
  [ 0  1  2  3  4  5  6  7  8  9]
  [30 31 32 33 34 35 36 37 38 39]
 ]
 perldl> p $a->dice([0,2,5])
 [
  [ 0  2  5]
  [10 12 15]
  [20 22 25]
  [30 32 35]
 ]

As this is an index function, any modifications to the
slice change the parent (use the C<.=> operator).

=cut

sub PDL::dice { 

	my $self = shift;
	my @dim_indexes = @_;  # array of dimension indexes
	
	# Check that the number of dim indexes <=
	#    number of dimensions in the PDL
	my $no_indexes = scalar(@dim_indexes);
	my $noDims = $self->getndims;
	barf("PDL::dice: Number of index arrays ($no_indexes) not equal to the dimensions of the PDL ($noDims")
			 if $no_indexes > $noDims;
	my $index;
	my $pdlIndex;
	my $outputPDL=$self;
	my $indexNo = 0;

	# Go thru each index array and dice the input PDL:
	foreach $index(@dim_indexes){

		$outputPDL = $outputPDL->dice_axis($indexNo,$index)
			unless !ref $index && $index eq 'X';

		$indexNo++;
	}

	return $outputPDL;
}  
*dice = \&PDL::dice;


=head2 dice_axis

=for ref

Dice rows/columns/planes from a single PDL axis (dimension)
using index along a specified axis

This function can be used to extract irregular subsets
along any dimension, e.g. only certain rows in an image,
or planes in a cube. This can of course be done with
the usual dimension tricks but this saves having to
figure it out each time!

=for usage

 $slice = $data->dice_axis($axis,$index);

=for example

 perldl> $a = sequence(10,4)
 perldl> $idx = pdl(1,2)
 perldl> p $a->dice_axis(0,$idx) # Select columns
 [
  [ 1  2]
  [11 12]
  [21 22]
  [31 32]
 ]
 perldl> $t = $a->dice_axis(1,$idx) # Select rows
 perldl> $t.=0
 perldl> p $a
 [
  [ 0  1  2  3  4  5  6  7  8  9]
  [ 0  0  0  0  0  0  0  0  0  0]
  [ 0  0  0  0  0  0  0  0  0  0]
  [30 31 32 33 34 35 36 37 38 39]
 ]

The trick to using this is that the index selects
elements along the dimensions specified, so if you
have a 2D image C<axis=0> will select certain C<X> values
- i.e. extract columns

As this is an index function, any modifications to the
slice change the parent.

=cut

sub PDL::dice_axis { 
  my($self,$axis,$idx) = @_;
  
  # Convert to PDLs: array refs using new, otherwise use topdl:
  my $ix = (ref($idx) eq 'ARRAY') ? ref($self)->new($idx) : ref($self)->topdl($idx);
  my $n = $self->getndims;
  my $a = $ix->getndims;
  barf("index_axis: index must be <=1D") if $a>1;
  for ($a..$n-1) {
     $ix = $ix->dummy(0);
  }
  return $self->mv($axis,0)->index($ix)->mv($n-1,$axis);
}  
*dice_axis = \&PDL::dice_axis;



;


=head1 AUTHOR

Copyright (C) 1997 Tuomas J. Lukka.
All rights reserved. There is no warranty. You are allowed
to redistribute this software / documentation under certain
conditions. For details, see the file COPYING in the PDL
distribution. If this file is separated from the PDL distribution,
the copyright notice should be included in the file.

=cut





# Exit with OK status

1;

		   