#ifndef RBIMPL_NEWOBJ_H                              /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_NEWOBJ_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines #NEWOBJ.
 */
#include "ruby/internal/attr/deprecated.h"
#include "ruby/internal/cast.h"
#include "ruby/internal/core/rbasic.h"
#include "ruby/internal/dllexport.h"
#include "ruby/internal/fl_type.h"
#include "ruby/internal/special_consts.h"
#include "ruby/internal/value.h"
#include "ruby/assert.h"

#define OBJSETUP   rb_obj_setup   /**< @old{rb_obj_setup} */
#define CLONESETUP rb_clone_setup /**< @old{rb_clone_setup} */
#define DUPSETUP   rb_dup_setup   /**< @old{rb_dup_setup} */

RBIMPL_SYMBOL_EXPORT_BEGIN()
/**
 * Fills common fields in the object.
 *
 * @param[in,out]  obj    A Ruby object to be set up.
 * @param[in]      klass  `obj` will belong to this class.
 * @param[in]      type   One of ::ruby_value_type.
 * @return         The passed object.
 *
 * @internal
 *
 * Historically, authors of  Ruby has described the `type` argument  as "one of
 * ::ruby_value_type".   In   reality  it  accepts   either  ::ruby_value_type,
 * ::ruby_fl_type,   or   any   combinations   of  the   two.    For   instance
 * `RUBY_T_STRING | RUBY_FL_FREEZE` is a valid  value that this function takes,
 * and means this is a frozen string.
 *
 * 3rd  party extension  libraries rarely  need to  allocate Strings  this way.
 * They normally only concern ::RUBY_T_DATA.   This argument is mainly used for
 * specifying flags, @shyouhei suspects.
 */
VALUE rb_obj_setup(VALUE obj, VALUE klass, VALUE type);

/**
 * Queries  the  class  of  an  object.    This  is  not  always  identical  to
 * `RBASIC_CLASS(obj)`.   It   searches  for  the  nearest   ancestor  skipping
 * singleton classes or included modules.
 *
 * @param[in]  obj  Object in question.
 * @return     The object's class, in a normal sense.
 */
VALUE rb_obj_class(VALUE obj);

/**
 * Clones a singleton class.  An object  can have its own singleton class.  OK.
 * Then what  happens when a program  clones such object?  The  singleton class
 * that is  attached to  the source  object must also  be cloned.   Otherwise a
 * singleton object gets shared with two objects, which breaks "singleton"-ness
 * of such class.
 *
 * This  is basically  an  implementation detail  of rb_clone_setup().   People
 * need not be aware of this working behind-the-scene.
 *
 * @param[in]  obj  The object that has its own singleton class.
 * @return     Cloned singleton class.
 */
VALUE rb_singleton_class_clone(VALUE obj);

/**
 * Attaches a singleton class to its corresponding object.
 *
 * This  is basically  an  implementation detail  of rb_clone_setup().   People
 * need not be aware of this working behind-the-scene.
 *
 * @param[in]   klass  The singleton class.
 * @param[out]  obj    The object to attach a class.
 * @pre         The passed two objects must  agree with each other that `klass`
 *              becomes a singleton class of `obj`.
 * @post        `klass` becomes the singleton class of `obj`.
 */
void rb_singleton_class_attached(VALUE klass, VALUE obj);

/**
 * Copies the list of instance variables.  3rd parties need not know, but there
 * are several ways  to store an object's instance variables,  depending on its
 * internal structure.   This function  makes sense when  either of  the passed
 * objects are using so-called "generic"  backend storage.  This distinction is
 * purely an  implementation detail  of rb_clone_setup().   People need  not be
 * aware of this working behind-the-scenes.
 *
 * @param[out]  clone  The destination object.
 * @param[in]   obj    The source object.
 */
void rb_copy_generic_ivar(VALUE clone, VALUE obj);
RBIMPL_SYMBOL_EXPORT_END()

#endif /* RBIMPL_NEWOBJ_H */
