= ARGF

スクリプトに指定した引数 (((<組み込み定数/ARGV>)) を参照) をファイル名と
みなして、それらのファイルを連結した 1 つの仮想ファイルを表すオブジェ
クトです。(({ARGV})) が空なら標準入力を対象とします。(({ARGV})) を変更
すればこのオブジェクトの動作に影響します。

        while line = ARGF.gets
          ..
        end

は、

        while argv = ARGV.shift
          File.open(argv) {|file|
            while line = file.gets
              ..
            end
          }
        end

のように動作します。

(({ARGF})) を処理するごとに (({ARGV})) の要素は一つずつ取り除かれます。
最後まで (({ARGF})) を読み込んだ後、再度 (({ARGF})) から内容を読むと
((({ARGV})) が空なので)標準入力からの読み込みとなります。

    ARGV.replace %w(/tmp/foo /tmp/bar)
    ARGF.each {|line|
        # 処理中の ARGV の内容を表示
        p [ARGF.filename, ARGV];
        ARGF.skip
    }
    # 最後まで読んだ後(ARGVが空)の動作
    p ARGF.gets
    p ARGF.filename

    # => ["/tmp/foo", ["/tmp/bar"]]
         ["/tmp/bar", []]
         nil
         "-"

((<組み込み関数/gets>)) など一部の((<組み込み関数>))は (({ARGF.gets})) な
どこのオブジェクトをレシーバとしたメソッドの省略形です。

== メソッド:

((<IO>)) オブジェクトのメソッドに加えて、以下のメソッドを持ちます。

--- ARGF.to_s
--- ARGF.filename
--- ARGF.path   ((<ruby 1.8 feature>))

    処理対象のファイル名を返します。標準入力に対しては (({-})) を返し
    ます。組み込み変数 ((<組み込み変数/$FILENAME>)) と同じです。

    ((<ruby 1.8 feature>)):
    to_s は、常に文字列 "ARGF" を返します。

--- ARGF.file

    処理対象の ((<File>)) オブジェクト(または ((<IO>)) オブジェクト)を
    返します。

--- ARGF.lineno

    全引数ファイルを一つのファイルとみなしたときの現在の行番号を返しま
    す。個々の引数ファイル毎の行番号を得るには (({ARGF.file.lineno})) 
    とします。

--- ARGF.skip

    処理対象のファイルをクローズします。次回の読み込みは次の引数が処理
    対象になります。(({self})) を返します。
