###reject nonref

= 機能別索引

((<機能別索引/配列生成>))/
((<機能別索引/配列要素の参照>))/
((<機能別索引/配列要素の追加、置き換え>))/
((<機能別索引/配列要素の削除>))/
((<機能別索引/配列の重複した要素の削除>))/
((<機能別索引/配列による集合演算>))/
((<機能別索引/配列の比較>))/
((<機能別索引/配列要素の最大値、最小値を求める>))/
((<機能別索引/配列のソート>))/
((<機能別索引/バイナリデータを扱う>))/
((<機能別索引/配列の要素の数を数える>))/
((<機能別索引/文字列生成>))/
((<機能別索引/文字列の比較>))/
((<機能別索引/数値、文字列変換>))/
((<機能別索引/書式出力>))/
((<機能別索引/文字列の大文字、小文字変換>))/
((<機能別索引/正規表現の生成>))/
((<機能別索引/正規表現マッチ>))/
((<機能別索引/ハッシュの生成>))/
((<機能別索引/コマンド実行、子プロセスの生成>))/
((<機能別索引/プロセスの終了を待ち合わせる>))/
((<機能別索引/プロセスの終了ステータスを得る>))/
((<機能別索引/ファイルをオープンする>))/
((<機能別索引/ファイルを読む>))/
((<機能別索引/画面出力する>))/
((<機能別索引/ファイルに書く>))/
((<機能別索引/ファイル名の操作>))/
((<機能別索引/ファイルの時刻>))/
((<機能別索引/ファイルのモード、属性>))/
((<機能別索引/数値演算>))/
((<機能別索引/変数を削除する>))/
((<機能別索引/メソッドを削除する>))/
((<機能別索引/メソッド定義のフック>))/
((<機能別索引/変数の一覧を得る>))/
((<機能別索引/メソッドの一覧を得る>))/
((<機能別索引/ruby を終了させる>))/
((<機能別索引/終了時に処理を実行する>))/
((<機能別索引/未分類>))/

((-あらい 2002-02-06: 思い付き。やめるかも-))

: 配列生成
  ((<リテラル/配列式>)),
  ((<Array/Array[]>)), ((<Array/Array.new>)),
  ((<Array/*>)),
  ((<Array/clone>)),
  ((<Array/dup>)),
  ((<組み込み関数/Array>)),

: 配列要素の参照
  ((<Array/[]>)), ((<Array/at>)), ((<Array/fetch>)),
  ((<Array/assoc>)),
  ((<Array/rassoc>)),
  ((<Array/slice>)),
  ((<Array/first>)),
  ((<Array/last>)),

: 配列要素の追加、置き換え
  ((<Array/[]=>)), ((<Array/+>)),
  ((<Array/<<>)),
  ((<Array/concat>)),
  ((<Array/insert>)),
  ((<Array/push>)),
  ((<Array/unshift>)),

: 配列要素の削除

  ((<Array/delete>)),
  ((<Array/delete_at>)),
  ((<Array/delete_if>)),
  ((<Array/reject!>)),
  ((<Array/clear>)),
  ((<Array/pop>)),
  ((<Array/shift>)),
  ((<Array/slice!>)),

: 配列の重複した要素の削除
  ((<Array/uniq>)),
  ((<Array/uniq!>)),

: 配列による集合演算
  ((<Array/->)),
  ((<Array/&>)),
  ((<Array/"|">)),

: 配列の比較
  ((<Array/<=>>)),
  ((<Array/==>)),
  ((<Array/eql?>)),

: 配列要素の最大値、最小値を求める
  ((<Enumerable/max>)),
  ((<Enumerable/min>)),

: 配列のソート
  ((<Array/sort>)),
  ((<Array/sort!>)),
  ((<Enumerable/sort>)),
  ((<Enumerable/sort_by>)),

: バイナリデータを扱う
  ((<Array/pack>)),
  ((<String/unpack>)),

: 配列の要素の数を数える
  ((<Array/length>)),
  ((<Array/size>)),
  ((<Array/nitems>)),

: 文字列生成
  ((<リテラル/文字列リテラル>)),
  ((<リテラル/コマンド出力>)),
  ((<リテラル/ヒアドキュメント (行指向文字列リテラル)>)),
  ((<String/String.new>)),
  ((<String/+>)),
  ((<String/*>)),
  ((<組み込み関数/String>)),

: 文字列の比較
  ((<String/==>)),
  ((<String/>>)),
  ((<String/>=>)),
  ((<String/<>)),
  ((<String/<=>)),
  ((<String/<=>>)),
  ((<String/casecmp>)),

: 数値、文字列変換
  ((<String/hex>)),
  ((<String/oct>)),
  ((<String/to_f>)),
  ((<String/to_i>)),
  ((<組み込み関数/Float>)),
  ((<組み込み関数/Integer>)),
  ((<組み込み関数/String>)),
  ((<Integer/chr>)),

: 書式出力
  ((<組み込み関数/printf>)),
  ((<組み込み関数/sprintf>)),
  ((<組み込み関数/format>)),
  ((<String/%>)),

: 文字列の大文字、小文字変換
  ((<String/capitalize>)),
  ((<String/capitalize!>)),
  ((<String/upcase>)),
  ((<String/upcase!>)),
  ((<String/downcase>)),
  ((<String/downcase!>)),
  ((<String/swapcase>)),
  ((<String/swapcase!>)),

: 正規表現の生成

  ((<リテラル/正規表現リテラル>)),
  ((<Regexp/Regexp.compile>)),
  ((<Regexp/Regexp.new>)),

: 正規表現マッチ
  ((<Regexp/=~>)),
  ((<Regexp/===>)),
  ((<Regexp/~>)),
  ((<Regexp/match>)),
  ((<String/=~>)),
  ((<String/~>)),
  ((<String/[]>)),
  ((<String/[]=>)),
  ((<String/match>)),
  ((<String/scan>)),
  ((<組み込み関数/scan>)),
  ((<String/split>)),
  ((<組み込み関数/split>)),
  ((<String/sub>)),
  ((<String/sub!>)),
  ((<組み込み関数/sub>)),
  ((<組み込み関数/sub!>)),
  ((<String/gsub>)),
  ((<String/gsub!>)),
  ((<組み込み関数/gsub>)),
  ((<組み込み関数/gsub!>)),
  ((<Enumerable/grep>)),

: ハッシュの生成

  ((<リテラル/ハッシュ式>)),
  ((<Hash/Hash[]>)),
  ((<Hash/Hash.new>)),
  ((<ENV/ENV.to_hash>)),

: コマンド実行、子プロセスの生成

  ((<組み込み関数/`>)),
  ((<組み込み関数/exec>)),
  ((<組み込み関数/fork>)),
  ((<組み込み関数/open>)),
  ((<IO/IO.popen>)),
  ((<組み込み関数/system>)),
  ((<Process/Process.fork>)),

: プロセスの終了を待ち合わせる

  ((<Process/Process.wait>)),
  ((<Process/Process.wait2>)),
  ((<Process/Process.waitall>)),
  ((<Process/Process.waitpid>)),
  ((<Process/Process.waitpid2>)),

: プロセスの終了ステータスを得る

  ((<組み込み変数/$?>)),
  ((<Process::Status/exited?>)),
  ((<Process::Status/exitstatus>)),
  ((<Process::Status/stopped?>)),
  ((<Process::Status/stopsig>)),
  ((<Process::Status/signaled?>)),
  ((<Process::Status/termsig>)),
  ((<Process::Status/coredump?>)),
  ((<SystemExit/status>)),

: ファイルをオープンする
: ファイルを読む
  ((<組み込み関数/open>)),
  ((<組み込み関数/readlines>)),
  ((<IO/IO.foreach>)),
  ((<IO/IO.read>)),
  ((<IO/IO.readlines>)),
  ((<IO/each>)),
  ((<IO/each_line>)),
  ((<IO/each_byte>)),
  ((<IO/getc>)),
  ((<IO/gets>)),
  ((<IO/read>)),
  ((<IO/readchar>)),
  ((<IO/readline>)),
  ((<IO/readlines>)),
  ((<IO/sysread>)),
  ((<File/File.new>)),
  ((<File/File.open>)),
  ((<Marshal/Marshal.load>)),

: 画面出力する
: ファイルに書く
  ((<組み込み関数/p>)),
  ((<組み込み関数/print>)),
  ((<組み込み関数/printf>)),
  ((<組み込み関数/putc>)),
  ((<組み込み関数/puts>)),
  ((<IO/<<>)),
  ((<IO/print>)),
  ((<IO/printf>)),
  ((<IO/putc>)),
  ((<IO/puts>)),
  ((<IO/syswrite>)),
  ((<IO/write>)),
  ((<Marshal/Marshal.dump>)),

: ファイル名の操作
  ((<File/File.basename>)),
  ((<File/File.dirname>)),
  ((<File/File.expand_path>)),
  ((<File/File.extname>)),
  ((<File/File.fnmatch>)),
  ((<File/File.fnmatch?>)),
  ((<File/File.join>)),
  ((<File/File.readlink>)),
  ((<File/File.split>)),
  ((<File/path>)),
  ((<File/ALT_SEPARATOR>)),
  ((<File/PATH_SEPARATOR>)),
  ((<File/SEPARATOR>)),
  ((<File/Separator>)),

: ファイルの時刻
  ((<File/File.atime>)),
  ((<File/File.ctime>)),
  ((<File/File.mtime>)),
  ((<File/File.utime>)),
  ((<File/atime>)),
  ((<File/ctime>)),
  ((<File/mtime>)),
  ((<File::Stat/<=>>)),
  ((<File::Stat/atime>)),
  ((<File::Stat/mtime>)),
  ((<File::Stat/ctime>)),
  ((<組み込み関数/test>)),

: ファイルのモード、属性
  ((<File/File.chmod>)),
  ((<File/File.lchmod>)),
  ((<File/File.chown>)),
  ((<File/File.lchown>)),
  ((<File/File.ftype>)),
  ((<File/File.stat>)),
  ((<File/File.lstat>)),
  ((<File/chmod>)),
  ((<File/chown>)),
  ((<File/lstat>)),
  ((<File::Stat/File::Stat.new>)),
  ((<File::Stat/ftype>)),
  ((<File::Stat/dev>)),
  ((<File::Stat/ino>)),
  ((<File::Stat/mode>)),
  ((<File::Stat/nlink>)),
  ((<File::Stat/uid>)),
  ((<File::Stat/gid>)),
  ((<File::Stat/rdev>)),
  ((<File::Stat/size>)),
  ((<File::Stat/blksize>)),
  ((<File::Stat/blocks>)),
  ((<File::Stat/rdev_major>)),
  ((<File::Stat/rdev_minor>)),
  ((<File::Stat/directory?>)),
  ((<File::Stat/readable?>)),
  ((<File::Stat/readable_real?>)),
  ((<File::Stat/writable?>)),
  ((<File::Stat/writable_real?>)),
  ((<File::Stat/executable?>)),
  ((<File::Stat/executable_real?>)),
  ((<File::Stat/file?>)),
  ((<File::Stat/zero?>)),
  ((<File::Stat/size?>)),
  ((<File::Stat/owned?>)),
  ((<File::Stat/grpowned?>)),
  ((<File::Stat/pipe?>)),
  ((<File::Stat/symlink?>)),
  ((<File::Stat/socket?>)),
  ((<File::Stat/blockdev?>)),
  ((<File::Stat/chardev?>)),
  ((<File::Stat/setuid?>)),
  ((<File::Stat/setgid?>)),
  ((<File::Stat/sticky?>)),
  ((<組み込み関数/test>)),
  ((<FileTest/FileTest.blockdev?>)),
  ((<FileTest/FileTest.chardev?>)),
  ((<FileTest/FileTest.executable?>)),
  ((<FileTest/FileTest.executable_real?>)),
  ((<FileTest/FileTest.exist?>)),
  ((<FileTest/FileTest.grpowned?>)),
  ((<FileTest/FileTest.directory?>)),
  ((<FileTest/FileTest.file?>)),
  ((<FileTest/FileTest.pipe?>)),
  ((<FileTest/FileTest.socket?>)),
  ((<FileTest/FileTest.owned?>)),
  ((<FileTest/FileTest.readable?>)),
  ((<FileTest/FileTest.readable_real?>)),
  ((<FileTest/FileTest.setuid?>)),
  ((<FileTest/FileTest.setgid?>)),
  ((<FileTest/FileTest.size>)),
  ((<FileTest/FileTest.size?>)),
  ((<FileTest/FileTest.sticky?>)),
  ((<FileTest/FileTest.symlink?>)),
  ((<FileTest/FileTest.writable?>)),
  ((<FileTest/FileTest.writable_real?>)),
  ((<FileTest/FileTest.zero?>)),

: 数値演算

  ((<Numeric/+>)),
  ((<Numeric/->)),
  ((<Numeric/"/">)),
  ((<Numeric/abs>)),
  ((<Numeric/ceil>)),
  ((<Numeric/div>)),
  ((<Numeric/divmod>)),
  ((<Numeric/floor>)),
  ((<Numeric/modulo>)),
  ((<Numeric/remainder>)),
  ((<Numeric/round>)),
  ((<Numeric/truncate>)),
  ((<Integer/+>)),
  ((<Integer/->)),
  ((<Integer/*>)),
  ((<Integer/"/">)),
  ((<Integer/%>)),
  ((<Integer/**>)),
  ((<Float/+>)),
  ((<Float/->)),
  ((<Float/*>)),
  ((<Float/"/">)),
  ((<Float/%>)),
  ((<Float/**>)),
  ((<Float/truncate>)),
  ((<Math/Math.acos>)),
  ((<Math/Math.asin>)),
  ((<Math/Math.atan>)),
  ((<Math/Math.atan2>)),
  ((<Math/Math.acosh>)),
  ((<Math/Math.asinh>)),
  ((<Math/Math.atanh>)),
  ((<Math/Math.cos>)),
  ((<Math/Math.sin>)),
  ((<Math/Math.tan>)),
  ((<Math/Math.cosh>)),
  ((<Math/Math.sinh>)),
  ((<Math/Math.tanh>)),
  ((<Math/Math.exp>)),
  ((<Math/Math.frexp>)),
  ((<Math/Math.hypot>)),
  ((<Math/Math.ldexp>)),
  ((<Math/Math.log>)),
  ((<Math/Math.log10>)),
  ((<Math/Math.sqrt>)),
  ((<Math/E>)),
  ((<Math/PI>)),

: 変数を削除する
  ((<Object/remove_instance_variable>)),
  ((<Module/remove_class_variable>)),
  ((<Module/remove_const>)),

: メソッドを削除する
  ((<クラス／メソッドの定義/undef>)),
  ((<Module/remove_method>)),
  ((<Module/undef_method>)),

: メソッド定義のフック

  ((<Object/singleton_method_added>)),
  ((<Object/singleton_method_removed>)),
  ((<Object/singleton_method_undefined>)),
  ((<Module/method_added>)),
  ((<Module/method_removed>)),
  ((<Module/method_undefined>)),

: 変数の一覧を得る

  ((<組み込み関数/local_variables>)),
  ((<組み込み関数/global_variables>)),
  ((<Object/instance_variables>)),
  ((<Module/Module.constants>)),
  ((<Module/constants>)),
  ((<Module/class_variables>)),

: メソッドの一覧を得る

  ((<Object/methods>)),
  ((<Object/public_methods>)),
  ((<Object/private_methods>)),
  ((<Object/protected_methods>)),
  ((<Object/singleton_methods>)),
  ((<Module/public_instance_methods>)),
  ((<Module/instance_methods>)),
  ((<Module/private_instance_methods>)),
  ((<Module/protected_instance_methods>)),

: ruby を終了させる

  ((<組み込み関数/abort>)),
  ((<組み込み関数/exit>)),
  ((<組み込み関数/exit!>)),
  ((<Thread/Thread.exit>)),
  ((<Thread/Thread.kill>)),
  ((<Thread/exit>)),
  ((<Thread/kill>)),
  ((<Process/Process.exit!>)),
  ((<組み込み関数/trap>)),
  ((<組み込み関数/raise>)),
  ((<組み込み関数/fail>)),
  ((<Thread/raise>)),

: 終了時に処理を実行する

  ((<組み込み関数/at_exit>)),
  ((<制御構造/END>)),
  ((<ObjectSpace/ObjectSpace.define_finalizer>)),
  ((<ObjectSpace/ObjectSpace.add_finalizer>)),

: 未分類

# Rubyの文法

  ((<字句構造/コメント>)),
  ((<字句構造/埋め込みドキュメント>)),
  ((<リテラル/数値リテラル>)),
  ((<リテラル/文字列リテラル>)),
  ((<リテラル/バックスラッシュ記法>)),
  ((<リテラル/式展開>)),
  ((<リテラル/コマンド出力>)),
  ((<リテラル/ヒアドキュメント (行指向文字列リテラル)>)),
  ((<リテラル/正規表現>)),
  ((<リテラル/配列式>)),
  ((<リテラル/ハッシュ式>)),
  ((<リテラル/範囲オブジェクト>)),
  ((<リテラル/シンボル>)),
  ((<演算子式/代入>)),
  ((<演算子式/自己代入>)),
  ((<演算子式/多重代入>)),
  ((<演算子式/範囲式>)),
  ((<演算子式/and>)),
  ((<演算子式/or>)),
  ((<演算子式/not>)),
  ((<演算子式/条件演算子>)),
  ((<制御構造/if>)),
  ((<制御構造/if 修飾子>)),
  ((<制御構造/unless>)),
  ((<制御構造/unless 修飾子>)),
  ((<制御構造/case>)),
  ((<制御構造/繰り返し>)),
  ((<制御構造/while>)),
  ((<制御構造/while 修飾子>)),
  ((<制御構造/until>)),
  ((<制御構造/until修飾子>)),
  ((<制御構造/for>)),
  ((<制御構造/break>)),
  ((<制御構造/next>)),
  ((<制御構造/redo>)),
  ((<制御構造/retry>)),
  ((<制御構造/raise>)),
  ((<制御構造/begin>)),
  ((<制御構造/rescue修飾子>)),
  ((<制御構造/return>)),
  ((<制御構造/BEGIN>)),
  ((<制御構造/END>)),
  ((<メソッド呼び出し/super>)),
  ((<メソッド呼び出し/yield>)),
  ((<クラス／メソッドの定義/クラス定義>)),
  ((<クラス／メソッドの定義/特異クラス定義>)),
  ((<クラス／メソッドの定義/モジュール定義>)),
  ((<クラス／メソッドの定義/メソッド定義>)),
  ((<クラス／メソッドの定義/特異メソッド定義>)),
  ((<クラス／メソッドの定義/クラスメソッドの定義>)),
  ((<クラス／メソッドの定義/alias>)),
  ((<クラス／メソッドの定義/undef>)),
  ((<クラス／メソッドの定義/defined?>)),

# 配列

  ((<Array/collect!>)),
  ((<Array/map!>)),
  ((<Array/compact>)),
  ((<Array/compact!>)),
  ((<Array/each>)),
  ((<Array/each_index>)),
  ((<Array/empty?>)),
  ((<Array/fill>)),
  ((<Array/flatten>)),
  ((<Array/flatten!>)),
  ((<Array/include?>)),
  ((<Array/index>)),
  ((<Array/indexes>)),
  ((<Array/join>)),
  ((<Array/replace>)),
  ((<Array/reverse>)),
  ((<Array/reverse!>)),
  ((<Array/reverse_each>)),
  ((<Array/rindex>)),
  ((<Array/select>)),
  ((<Array/to_a>)),
  ((<Array/to_ary>)),
  ((<Array/to_s>)),

  ((<Enumerable/all?>)),
  ((<Enumerable/any?>)),
  ((<Enumerable/collect>)),
  ((<Enumerable/map>)),
  ((<Enumerable/each_with_index>)),
  ((<Enumerable/find>)),
  ((<Enumerable/detect>)),
  ((<Enumerable/find_all>)),
  ((<Enumerable/select>)),
  ((<Enumerable/grep>)),
  ((<Enumerable/inject>)),
  ((<Enumerable/member?>)),
  ((<Enumerable/include?>)),
  ((<Enumerable/reject>)),
  ((<Enumerable/entries>)),

# 文字列

  ((<String/<<>)),
  ((<String/concat>)),
  ((<String/[]>)),
  ((<String/[]=>)),
  ((<String/center>)),
  ((<String/ljust>)),
  ((<String/rjust>)),
  ((<String/chomp>)),
  ((<String/chomp!>)),
  ((<String/chop>)),
  ((<String/chop!>)),
  ((<String/clone>)),
  ((<String/dup>)),
  ((<String/count>)),
  ((<String/crypt>)),
  ((<String/delete>)),
  ((<String/delete!>)),
  ((<String/dump>)),
  ((<String/each>)),
  ((<String/each_line>)),
  ((<String/each_byte>)),
  ((<String/empty?>)),
  ((<String/include?>)),
  ((<String/index>)),
  ((<String/insert>)),
  ((<String/intern>)),
  ((<String/length>)),
  ((<String/size>)),
  ((<String/next>)),
  ((<String/next!>)),
  ((<String/succ>)),
  ((<String/succ!>)),
  ((<String/replace>)),
  ((<String/reverse>)),
  ((<String/reverse!>)),
  ((<String/rindex>)),
  ((<String/scan>)),
  ((<String/slice>)),
  ((<String/slice>)),
  ((<String/slice!>)),
  ((<String/split>)),
  ((<String/squeeze>)),
  ((<String/squeeze!>)),
  ((<String/strip>)),
  ((<String/strip!>)),
  ((<String/lstrip>)),
  ((<String/lstrip!>)),
  ((<String/rstrip>)),
  ((<String/rstrip!>)),
  ((<String/sum>)),
  ((<String/to_s>)),
  ((<String/to_str>)),
  ((<String/tr>)),
  ((<String/tr!>)),
  ((<String/tr_s>)),
  ((<String/tr_s!>)),
  ((<String/upto>)),

# 組み込み関数

  ((<組み込み関数/autoload>)),
  ((<組み込み関数/binding>)),
  ((<組み込み関数/caller>)),
  ((<組み込み関数/callcc>)),
  ((<組み込み関数/catch>)),
  ((<組み込み関数/chop>)),
  ((<組み込み関数/chop!>)),
  ((<組み込み関数/chomp>)),
  ((<組み込み関数/chomp!>)),
  ((<組み込み関数/eval>)),
  ((<組み込み関数/gets>)),
  ((<組み込み関数/readline>)),
  ((<組み込み関数/gsub>)),
  ((<組み込み関数/gsub!>)),
  ((<組み込み関数/block_given?>)),
  ((<組み込み関数/load>)),
  ((<組み込み関数/loop>)),
  ((<組み込み関数/proc>)),
  ((<組み込み関数/lambda>)),
  ((<組み込み関数/raise>)),
  ((<組み込み関数/fail>)),
  ((<組み込み関数/rand>)),
  ((<組み込み関数/require>)),
  ((<組み込み関数/scan>)),
  ((<組み込み関数/select>)),
  ((<組み込み関数/set_trace_func>)),
  ((<組み込み関数/sleep>)),
  ((<組み込み関数/split>)),
  ((<組み込み関数/srand>)),
  ((<組み込み関数/sub>)),
  ((<組み込み関数/sub!>)),
  ((<組み込み関数/syscall>)),
  ((<組み込み関数/test>)),
  ((<組み込み関数/throw>)),
  ((<組み込み関数/trace_var>)),
  ((<組み込み関数/trap>)),
  ((<組み込み関数/untrace_var>)),

# 組み込み変数

  ((<組み込み変数/$_>)),
  ((<組み込み変数/$&>)),
  ((<組み込み変数/$~>)),
  ((<組み込み変数/$`>)),
  ((<組み込み変数/$'>)),
  ((<組み込み変数/$+>)),
  ((<組み込み変数/$1>)),
  ((<組み込み変数/$!>)),
  ((<組み込み変数/$@>)),
  ((<組み込み変数/$SAFE>)),
  ((<組み込み変数/$=>)),
  ((<組み込み変数/"$/">)),
  ((<組み込み変数/$\>)),
  ((<組み込み変数/$,>)),
  ((<組み込み変数/$;>)),
  ((<組み込み変数/$.>)),
  ((<組み込み変数/$<>)),
  ((<組み込み変数/$>>)),
  ((<組み込み変数/$defout>)),
  ((<組み込み変数/$0>)),
  ((<組み込み変数/$*>)),
  ((<組み込み変数/$$>)),
  ((<組み込み変数/$:>)),
  ((<組み込み変数/$">)),
  ((<組み込み変数/$DEBUG>)),
  ((<組み込み変数/$FILENAME>)),
  ((<組み込み変数/$LOAD_PATH>)),
  ((<組み込み変数/$stdin>)),
  ((<組み込み変数/$stdout>)),
  ((<組み込み変数/$stderr>)),
  ((<組み込み変数/$VERBOSE>)),
  ((<組み込み変数/$KCODE>)),
  ((<組み込み変数/$-0>)),
  ((<組み込み変数/$-a>)),
  ((<組み込み変数/$-d>)),
  ((<組み込み変数/$-F>)),
  ((<組み込み変数/$-i>)),
  ((<組み込み変数/$-I>)),
  ((<組み込み変数/$-K>)),
  ((<組み込み変数/$-l>)),
  ((<組み込み変数/$-p>)),
  ((<組み込み変数/$-v>)),
  ((<組み込み変数/$-w>)),

# Object

  ((<Object/==>)),
  ((<Object/=~>)),
  ((<Object/===>)),
  ((<Object/class>)),
  ((<Object/type>)),
  ((<Object/clone>)),
  ((<Object/dup>)),
  ((<Object/display>)),
  ((<Object/eql?>)),
  ((<Object/equal?>)),
  ((<Object/extend>)),
  ((<Object/freeze>)),
  ((<Object/frozen?>)),
  ((<Object/hash>)),
  ((<Object/id>)),
  ((<Object/__id__>)),
  ((<Object/inspect>)),
  ((<Object/instance_eval>)),
  ((<Object/instance_of?>)),
  ((<Object/is_a?>)),
  ((<Object/kind_of?>)),
  ((<Object/method>)),
  ((<Object/method_missing>)),
  ((<Object/nil?>)),
  ((<Object/respond_to?>)),
  ((<Object/send>)),
  ((<Object/__send__>)),
  ((<Object/taint>)),
  ((<Object/tainted?>)),
  ((<Object/to_a>)),
  ((<Object/to_ary>)),
  ((<Object/to_hash>)),
  ((<Object/to_int>)),
  ((<Object/to_s>)),
  ((<Object/to_str>)),
  ((<Object/untaint>)),
  ((<Object/initialize>)),

# Continuation

  ((<Continuation/call>))

# Exception

  ((<Exception/Exception.new>)),
  ((<Exception/Exception.exception>)),
  ((<Exception/backtrace>)),
  ((<Exception/exception>)),
  ((<Exception/message>)),
  ((<Exception/to_s>)),
  ((<Exception/to_str>)),
  ((<Exception/set_backtrace>)),

# Dir

  ((<Dir/Dir[]>)),
  ((<Dir/Dir.glob>)),
  ((<Dir/Dir.chdir>)),
  ((<Dir/Dir.chroot>)),
  ((<Dir/Dir.delete>)),
  ((<Dir/Dir.rmdir>)),
  ((<Dir/Dir.unlink>)),
  ((<Dir/Dir.entries>)),
  ((<Dir/Dir.foreach>)),
  ((<Dir/Dir.getwd>)),
  ((<Dir/Dir.pwd>)),
  ((<Dir/Dir.mkdir>)),
  ((<Dir/Dir.new>)),
  ((<Dir/Dir.open>)),
  ((<Dir/close>)),
  ((<Dir/each>)),
  ((<Dir/pos>)),
  ((<Dir/tell>)),
  ((<Dir/pos=>)),
  ((<Dir/seek>)),
  ((<Dir/read>)),
  ((<Dir/rewind>)),

# FalseClass

  ((<FalseClass/&>)),
  ((<FalseClass/"|">)),
  ((<FalseClass/^>)),

# Hash

  ((<Hash/[]>)),
  ((<Hash/[]=>)),
  ((<Hash/store>)),
  ((<Hash/clear>)),
  ((<Hash/clone>)),
  ((<Hash/dup>)),
  ((<Hash/default>)),
  ((<Hash/default=>)),
  ((<Hash/delete>)),
  ((<Hash/reject>)),
  ((<Hash/delete_if>)),
  ((<Hash/reject!>)),
  ((<Hash/each>)),
  ((<Hash/each_pair>)),
  ((<Hash/each_key>)),
  ((<Hash/each_value>)),
  ((<Hash/empty?>)),
  ((<Hash/fetch>)),
  ((<Hash/has_key?>)),
  ((<Hash/include?>)),
  ((<Hash/key?>)),
  ((<Hash/member?>)),
  ((<Hash/has_value?>)),
  ((<Hash/value?>)),
  ((<Hash/index>)),
  ((<Hash/indexes>)),
  ((<Hash/indices>)),
  ((<Hash/invert>)),
  ((<Hash/keys>)),
  ((<Hash/length>)),
  ((<Hash/size>)),
  ((<Hash/rehash>)),
  ((<Hash/replace>)),
  ((<Hash/select>)),
  ((<Hash/shift>)),
  ((<Hash/to_a>)),
  ((<Hash/to_hash>)),
  ((<Hash/update>)),
  ((<Hash/values>)),

# IO

  ((<IO/IO.new>)),
  ((<IO/IO.for_fd>)),
  ((<IO/IO.pipe>)),
  ((<IO/IO.popen>)),
  ((<IO/IO.select>)),
  ((<IO/binmode>)),
  ((<IO/clone>)),
  ((<IO/dup>)),
  ((<IO/close>)),
  ((<IO/close_read>)),
  ((<IO/close_write>)),
  ((<IO/closed?>)),
  ((<IO/eof>)),
  ((<IO/eof?>)),
  ((<IO/fcntl>)),
  ((<IO/fileno>)),
  ((<IO/to_i>)),
  ((<IO/flush>)),
  ((<IO/ioctl>)),
  ((<IO/isatty>)),
  ((<IO/tty?>)),
  ((<IO/lineno>)),
  ((<IO/lineno=>)),
  ((<IO/pid>)),
  ((<IO/pos>)),
  ((<IO/tell>)),
  ((<IO/pos=>)),
  ((<IO/reopen>)),
  ((<IO/rewind>)),
  ((<IO/seek>)),
  ((<IO/stat>)),
  ((<IO/sync>)),
  ((<IO/sync=>)),
  ((<IO/to_io>)),
  ((<IO/ungetc>)),

# File

  ((<File/File.delete>)),
  ((<File/File.unlink>)),
  ((<File/File.link>)),
  ((<File/File.rename>)),
  ((<File/File.symlink>)),
  ((<File/File.truncate>)),
  ((<File/File.umask>)),
  ((<File/flock>)),
  ((<File/truncate>)),

# MatchData

  ((<MatchData/[]>)),
  ((<MatchData/begin>)),
  ((<MatchData/end>)),
  ((<MatchData/length>)),
  ((<MatchData/size>)),
  ((<MatchData/offset>)),
  ((<MatchData/post_match>)),
  ((<MatchData/pre_match>)),
  ((<MatchData/string>)),
  ((<MatchData/to_a>)),
  ((<MatchData/to_ary>)),
  ((<MatchData/to_s>)),

# Method

  ((<Method/[]>)),
  ((<Method/call>)),
  ((<Method/arity>)),
  ((<Method/inspect>)),
  ((<Method/to_proc>)),
  ((<Method/unbind>)),

# UnboundMethod

  ((<UnboundMethod/[]>)),
  ((<UnboundMethod/call>)),
  ((<UnboundMethod/bind>)),
  ((<UnboundMethod/to_proc>)),
  ((<UnboundMethod/unbind>)),

# Module

  ((<Module/Module.nesting>)),
  ((<Module/Module.new>)),
  ((<Module/<=>>)),
  ((<Module/<>)),
  ((<Module/<=>)),
  ((<Module/>>)),
  ((<Module/>=>)),
  ((<Module/===>)),
  ((<Module/ancestors>)),
  ((<Module/class_eval>)),
  ((<Module/const_defined?>)),
  ((<Module/const_get>)),
  ((<Module/const_set>)),
  ((<Module/include?>)),
  ((<Module/included_modules>)),
  ((<Module/instance_method>)),
  ((<Module/method_defined?>)),
  ((<Module/module_eval>)),
  ((<Module/name>)),
  ((<Module/private_class_method>)),
  ((<Module/public_class_method>)),
  ((<Module/alias_method>)),
  ((<Module/append_features>)),
  ((<Module/attr>)),
  ((<Module/attr_accessor>)),
  ((<Module/attr_reader>)),
  ((<Module/attr_writer>)),
  ((<Module/define_method>)),
  ((<Module/extend_object>)),
  ((<Module/include>)),
  ((<Module/included>)),
  ((<Module/module_function>)),
  ((<Module/private>)),
  ((<Module/protected>)),
  ((<Module/public>)),

# Class

  ((<Class/Class.new>)),
  ((<Class/allocate>)),
  ((<Class/new>)),
  ((<Class/superclass>)),
  ((<Class/inherited>)),

# Numeric

  ((<Numeric/clone>)),
  ((<Numeric/dup>)),
  ((<Numeric/coerce>)),
  ((<Numeric/integer?>)),
  ((<Numeric/nonzero?>)),
  ((<Numeric/zero?>)),

# Integer

  ((<Integer/Integer.induced_from>)),
  ((<Integer/[]>)),
  ((<Integer/<=>>)),
  ((<Integer/==>)),
  ((<Integer/<>)),
  ((<Integer/<=>)),
  ((<Integer/>>)),
  ((<Integer/>=>)),
  ((<Integer/~>)),
  ((<Integer/"|">)),
  ((<Integer/&>)),
  ((<Integer/^>)),
  ((<Integer/<<>)),
  ((<Integer/>>>)),
  ((<Integer/downto>)),
  ((<Integer/next>)),
  ((<Integer/succ>)),
  ((<Integer/step>)),
  ((<Integer/times>)),
  ((<Integer/to_i>)),
  ((<Integer/to_int>)),
  ((<Integer/size>)),
  ((<Integer/to_f>)),
  ((<Integer/to_s>)),
  ((<Integer/upto>)),

# Fixnum

  ((<Fixnum/id2name>)),

# Float

  ((<Float/Float.induced_from>)),
  ((<Float/<=>>)),
  ((<Float/==>)),
  ((<Float/<>)),
  ((<Float/<=>)),
  ((<Float/>>)),
  ((<Float/>=>)),
  ((<Float/finite?>)),
  ((<Float/infinite?>)),
  ((<Float/nan?>)),
  ((<Float/to_f>)),
  ((<Float/to_i>)),

# Proc

  ((<Proc/Proc.new>)),
  ((<Proc/[]>)),
  ((<Proc/call>)),
  ((<Proc/arity>)),
  ((<Proc/yield>)),

# Process::Status

  ((<Process::Status/==>)),
  ((<Process::Status/&>)),
  ((<Process::Status/to_i>)),
  ((<Process::Status/to_int>)),
  ((<Process::Status/to_s>)),

# Range

  ((<Range/Range.new>)),
  ((<Range/===>)),
  ((<Range/begin>)),
  ((<Range/first>)),
  ((<Range/each>)),
  ((<Range/end>)),
  ((<Range/last>)),
  ((<Range/exclude_end?>)),
  ((<Range/length>)),
  ((<Range/size>)),
  ((<Range/step>)),
  ((<Range/to_ary>)),

# Regexp

  ((<Regexp/Regexp.escape>)),
  ((<Regexp/Regexp.quote>)),
  ((<Regexp/Regexp.last_match>)),
  ((<Regexp/casefold?>)),
  ((<Regexp/kcode>)),
  ((<Regexp/options>)),
  ((<Regexp/source>)),
  ((<Regexp/EXTENDED>)),
  ((<Regexp/IGNORECASE>)),
  ((<Regexp/MULTILINE>)),

# Struct

  ((<Struct/Struct.new>)),
  ((<Struct/Struct::XXX.new>)),
  ((<Struct/Struct::XXX[]>)),
  ((<Struct/Struct::XXX.members>)),
  ((<Struct/[]>)),
  ((<Struct/[]=>)),
  ((<Struct/each>)),
  ((<Struct/each_pair>)),
  ((<Struct/length>)),
  ((<Struct/size>)),
  ((<Struct/members>)),
  ((<Struct/values>)),
  ((<Struct/to_a>)),

# Symbol

  ((<Symbol/Symbol.all_symbols>)),
  ((<Symbol/intern>)),
  ((<Symbol/id2name>)),
  ((<Symbol/to_s>)),
  ((<Symbol/to_i>)),

# Thread

  ((<Thread/Thread.abort_on_exception>)),
  ((<Thread/Thread.critical>)),
  ((<Thread/Thread.current>)),
  ((<Thread/Thread.exit>)),
  ((<Thread/Thread.kill>)),
  ((<Thread/Thread.list>)),
  ((<Thread/Thread.main>)),
  ((<Thread/Thread.new>)),
  ((<Thread/Thread.start>)),
  ((<Thread/Thread.fork>)),
  ((<Thread/Thread.pass>)),
  ((<Thread/Thread.stop>)),
  ((<Thread/[]>)),
  ((<Thread/abort_on_exception>)),
  ((<Thread/abort_on_exception=>)),
  ((<Thread/alive?>)),
  ((<Thread/exit>)),
  ((<Thread/kill>)),
  ((<Thread/join>)),
  ((<Thread/key?>)),
  ((<Thread/keys>)),
  ((<Thread/priority>)),
  ((<Thread/priority=>)),
  ((<Thread/raise>)),
  ((<Thread/run>)),
  ((<Thread/safe_level>)),
  ((<Thread/status>)),
  ((<Thread/stop?>)),
  ((<Thread/value>)),
  ((<Thread/wakeup>)),

# ThreadGroup

  ((<ThreadGroup/ThreadGroup.new>)),
  ((<ThreadGroup/add>)),
  ((<ThreadGroup/list>)),
  ((<ThreadGroup/Default>)),

# Time

  ((<Time/Time.at>)),
  ((<Time/Time.gm>)),
  ((<Time/Time.utc>)),
  ((<Time/Time.local>)),
  ((<Time/Time.mktime>)),
  ((<Time/Time.new>)),
  ((<Time/Time.now>)),
  ((<Time/Time.times>)),
  ((<Time/+>)),
  ((<Time/->)),
  ((<Time/<=>>)),
  ((<Time/asctime>)),
  ((<Time/ctime>)),
  ((<Time/gmt?>)),
  ((<Time/utc?>)),
  ((<Time/getgm>)),
  ((<Time/getutc>)),
  ((<Time/getlocal>)),
  ((<Time/gmtime>)),
  ((<Time/utc>)),
  ((<Time/localtime>)),
  ((<Time/strftime>)),
  ((<Time/sec>)),
  ((<Time/min>)),
  ((<Time/hour>)),
  ((<Time/mday>)),
  ((<Time/day>)),
  ((<Time/mon>)),
  ((<Time/month>)),
  ((<Time/year>)),
  ((<Time/wday>)),
  ((<Time/yday>)),
  ((<Time/zone>)),
  ((<Time/isdst>)),
  ((<Time/dst?>)),
  ((<Time/utc_offset>)),
  ((<Time/gmt_offset>)),
  ((<Time/gmtoff>)),
  ((<Time/to_a>)),
  ((<Time/to_f>)),
  ((<Time/to_i>)),
  ((<Time/tv_sec>)),
  ((<Time/to_s>)),
  ((<Time/usec>)),
  ((<Time/tv_usec>)),

# TrueClass

  ((<TrueClass/&>)),
  ((<TrueClass/"|">)),
  ((<TrueClass/^>)),

# NilClass

  ((<NilClass/&>)),
  ((<NilClass/"|">)),
  ((<NilClass/^>)),
  ((<NilClass/nil?>)),
  ((<NilClass/to_a>)),
  ((<NilClass/to_i>)),
  ((<NilClass/to_s>)),

# Comparable

  ((<Comparable/==>)),
  ((<Comparable/>>)),
  ((<Comparable/>=>)),
  ((<Comparable/<>)),
  ((<Comparable/<=>)),
  ((<Comparable/between?>)),

# GC

  ((<GC/GC.disable>)),
  ((<GC/GC.enable>)),
  ((<GC/GC.start>)),
  ((<GC/garbage_collect>)),

# Marshal

  ((<Marshal/Marshal.dump>)),
  ((<Marshal/Marshal.load>)),
  ((<Marshal/Marshal.restore>)),
  ((<Marshal/MAJOR_VERSION>)),
  ((<Marshal/MINOR_VERSION>)),
# 違うけど、触れているページに飛ばすため
  ((<_dump|Marshal>)),
  ((<_load|Marshal>)),

# ObjectSpace

  ((<ObjectSpace/ObjectSpace._id2ref>)),
  ((<ObjectSpace/ObjectSpace.define_finalizer>)),
  ((<ObjectSpace/ObjectSpace.each_object>)),
  ((<ObjectSpace/ObjectSpace.garbage_collect>)),
  ((<ObjectSpace/ObjectSpace.undefine_finalizer>)),
  ((<ObjectSpace/ObjectSpace.add_finalizer>)),
  ((<ObjectSpace/ObjectSpace.call_finalizer>)),
  ((<ObjectSpace/ObjectSpace.finalizers>)),
  ((<ObjectSpace/ObjectSpace.remove_finalizer>)),

# Precision

  ((<Precision/Precision.included>)),
  ((<Precision/Precision.induced_from>)),
  ((<Precision/prec>)),
  ((<Precision/prec_i>)),
  ((<Precision/prec_f>)),

# Process

  ((<Process/Process.exit!>)),
  ((<Process/Process.egid>)),
  ((<Process/Process.egid=gid>)),
  ((<Process/Process.euid>)),
  ((<Process/Process.euid=uid>)),
  ((<Process/Process.gid>)),
  ((<Process/Process.gid=gid>)),
  ((<Process/Process.pid>)),
  ((<Process/Process.ppid>)),
  ((<Process/Process.uid>)),
  ((<Process/Process.uid=uid>)),
  ((<Process/Process.getpgid>)),
  ((<Process/Process.getpgrp>)),
  ((<Process/Process.getpriority>)),
  ((<Process/Process.kill>)),
  ((<Process/Process.setpgrp>)),
  ((<Process/Process.setpgid>)),
  ((<Process/Process.setpriority>)),
  ((<Process/Process.setsid>)),
  ((<Process/Process.times>)),
  ((<Process/PRIO_PROCESS>)),
  ((<Process/PRIO_PGRP>)),
  ((<Process/PRIO_USER>)),
  ((<Process/WNOHANG>)),
  ((<Process/WUNTRACED>)),
  ((<Process/Status>)),

# Signal

  ((<Signal/Signal.list>)),
  ((<Signal/Signal.trap>)),

# SystemCallError

  ((<SystemCallError/SystemCallError===>)),
  ((<SystemCallError/errno>)),
