= shim
* ((<URL:http://www.ruby-lang.org/~knu/cgi-bin/cvsweb.cgi/shim/>))
* 古いバージョンの Ruby に新しいバージョンで導入された新機能や
  新モジュールを付加・提供するものです。ちょうど詰め木の役割をする
  ことから、「Ruby Shim」と名付けられました。

== 背景

巷の声を聞くに曰く:

「こんな機能が欲しい、と要望したら、開発版ではこう実現されている、
と教えてもらった。でも、安定版で使えないんじゃ救われない！」

「結局、便利だから開発版の機能を安定版でも実装して使うことにした。
でも、きっとみんな同じようなことをやっているんだろうな。。」

「開発版の追っかけをしていて、自分用のプログラムやライブラリでは
新機能をどんどん使っている。でも安定版じゃ動かないから、人には
使ってもらいにくい。」

「開発版にしかないモジュールをいくつか使いたいが、個別に入手して
インストールするのは大変。それに、開発版にしかないこのモジュール、
そのままじゃ安定版で動かないよね。。」

== 目的

(1) Ruby 開発版の新機能のうち、安定版でも実現・追加可能なものを
    実装する。また新規追加モジュール群も安定版用にアレンジし、
    これらをすべて一まとめにして配布する。

(2) 1. により、開発版の新機能の早期のテスト・評価・利用を促進し、
    来たる次期安定版の品質の向上を図りつつ、ユーザのスムーズな
    版の移行をサポートする。

(3) 各拡張ごとの独立性を確保し、テスト済みの実装を提供することで、
    部分的に切り取っての利用にも対応する。(段階的な移行に役立つ)

== 名前

「Ruby Shim」 shim : 隙間に入れる詰め木の意

== 方針

=== 互換レイヤについて

(1) 安定版の挙動は極力変えない。追加や拡張にとどめる。名前空間も
    むやみに汚染しない。これにより、動いていたものが動かなくなる
    という心配をせずに Shim を使える。

(2) Shim で追加・拡張された部分の後方互換性は追わない。開発版の
    仕様に追随する。

(3) できるだけ、(だいたいクラス・モジュール単位で見て)拡張同士が
    依存しないようにして、部分的な利用も可能にしておく。

(4) 完璧は目指さない。無理もしない。Shim で実装されないことが我慢
    できないほど開発版の機能に浸かってしまった人には、少々の追加
    リスクとコストを負って移行してもらえばいい。

=== 追加モジュールについて

(1) 各モジュールのメンテナに一任。開発版と同期するもよし、安定版
    向けリリースということで慎重に保守するもよし。

(2) メンテナが、安定版用のものは保守するつもりがないという場合、
    Shim の committer が適宜開発版と同期する。(意思の表明がない
    場合のデフォルト - 負担は強いません)

== その他

開発版で廃止・変更された機能を使うと警告を出すようなオプション
またはツールを作ると、移行に大いに役立つかもしれない。余力が出て
きたら考えよう。

あまりに違いが大きかったり、実装が難しいクラス・モジュールは、
場合によってはまるごと拡張モジュールとして(クラス名の頭に Ruby18
などと付けて)提供する手もあるかも。ただし、需要と余力次第。
