= YAML

((<ruby 1.8 feature>)):
((<執筆者募集>))

* ((<YAML::Store>))
* ((<YAML::Stream>))

== 参考

=== YAML.rb
*((<URL:http://yaml4r.sourceforge.net/>))
*((<URL:http://yaml4r.sourceforge.net/cookbook/>))
*((<URL:http://yaml4r.sourceforge.net/doc/>))

=== Ruby with YAML
: ((<Ruby with YAML|URL:http://www.namikilab.tuat.ac.jp/~sasada/prog/yaml.html>))

=== るびま 記事
* ((<プログラマーのための YAML 入門 (初級編)|URL:http://jp.rubyist.net/magazine/?0009-YAML>)) 
* ((<プログラマーのための YAML 入門 (中級編)|URL:http://jp.rubyist.net/magazine/?0010-YAML>))

=== YAML Specification
* ((<URL:http://www.yaml.org/spec/>))
* ((<URL:http://www.yaml.org/type/>))

== モジュールメソッド

--- YAML.add_builtin_type
--- YAML.add_domain_type
--- YAML.add_private_type
--- YAML.add_ruby_type
    ((<執筆者募集>))

--- YAML.dump( obj, io = nil )
    与えられた obj を YAML フォーマットに変換し、io に書き込みます。
    io が与えられていない場合は、YAML フォーマットの文字列を返します。

      YAML.dump( ['badger', 'elephant', 'tiger'],
                 File.open('sample.yml', 'w')    )

--- YAML.dump_stream(*objs)
    与えられた objs を順に YAML フォーマットに変換していき、一つの文字列にまとめたものを返します。

      require "yaml"
      puts YAML.dump_stream( "hoge\nfoo", [1,2], {"foo" => "bar"} )
      --- |-
      hoge
      foo
      ---
      - 1
      - 2
      ---
      foo: bar

--- YAML.each_document(io){|obj| ...}
--- YAML.load_documents(io){|obj| ...}
    与えられた io から YAML フォーマットの文書をすべて順に読み込み Ruby のオブジェクトに変換し、
    生成したオブジェクトを引数としてブロックを評価していきます。
    
      # sample.yml
      - apple 
      - banana 
      - carrot 
      ---
      foo: bar

      #!/usr/bin/env ruby
      require "yaml"
      File.open( 'sample.yml' ) do |io|
        YAML.load_documents(io){|y|
          p y
        }
      end
      #=>   ["apple", "banana", "carrot"]
      #=>   {"foo"=>"bar"}

--- YAML.each_node
    ((<執筆者募集>))

--- YAML.load(io)
--- YAML.load(str)
    YAML フォーマットの文書を読み込み Ruby のオブジェクトを生成して返します。
    引数として IO オブジェクトと文字列を受け付けます。
    io や 文字列が複数の YAML ドキュメントを含んでいても、最初のものしか
    Ruby のオブジェクトに変換しません。
    
      $ ruby-1.8 -ryaml -e '
      p YAML.load(<<HERE)
      - apple
      - banana
      - carrot
      --- 
      foo: bar
      HERE
      '
      ["apple", "banana", "carrot"]

--- YAML.load_file( file )
    与えられた名前のファイルから YAML フォーマットの文書を読み込み Ruby のオブジェクトを生成して返します。
    ファイルが複数の YAML ドキュメントを含んでいても、最初のものしか Ruby のオブジェクトに変換しません。

--- YAML.load_stream(io) 
    与えられた io から YAML フォーマットの文書をすべて順に読み込んで Ruby のオブジェクトに変換していき、
    それらオブジェクトを含んだ ((<YAML::Stream>)) を返します。

--- YAML.parse
--- YAML.parse_documents
--- YAML.parse_file
    ((<執筆者募集>))
