= SyncEnumerator

複数の ((<Enumerable>)) オブジェクトを並行して yield するためのクラスです。

== 例

   require 'generator'

   s = SyncEnumerator.new([1,2,3], ['a', 'b', 'c'])

   # Yields [1, 'a'], [2, 'b'], and [3,'c']
   s.each { |row| puts row.join(', ') }

== クラスメソッド

--- SyncEnumerator.new(*enums)
    SyncEnumerator オブジェクトを生成します。
    複数の ((<Enumerable>)) オブジェクトを与えます。
    Enumerable オブジェクトのサイズは異なっていても構いません。

== メソッド

--- each{|row| ... }
    与えられた Enumerable オブジェクトのそれぞれの要素の配列を引数として
    ブロックを評価します。self を返します。
    
    要素がある Enumerable オブジェクトがひとつでもあれば、評価を続けます。
    要素のなくなった Enumerable オブジェクトの代わりに nil を配列の要素とします。
    全ての Enumerable オブジェクトの要素がなくなるとそこで、ブロックの評価を止めます。

      s = SyncEnumerator.new([1, 2, 3], ['a', 'b'], ['X'])
      s.each{|arry| p arry}
      
      # => 結果
      [1, "a", "X"]
      [2, "b", nil]
      [3, nil, nil]
      
--- end?(i = nil)
    SyncEnumerator が終わりに達している場合は真を返します。
    ((|i|)) を与えた場合は、((|i|)) 番目の Enumerable オブジェクトが終わりに
    達している場合、真を返します。

--- length
--- size
    与えられた Enumerable オブジェクトの数を返します。

