= ENV

環境変数を表すオブジェクト。((<Hash>)) と同様のインターフェースを持ち
ます。ただし、(({Hash})) と異なり、(({ENV})) のキーと値には文字列しか
とることができません。

(({ENV})) で得られる文字列は (({ENV['PATH']})) を除いて汚染されていま
す。(オブジェクトの汚染に関しては((<セキュリティモデル>))を参照のこと)
(({ENV['PATH']})) はその要素が誰でも書き込み可能なディレクトリを含ん
でいる場合に限り汚染されます。

        p ENV['TERM'].tainted?
        # => true
        p path = ENV['PATH']
        # => "/usr/local/bin:/usr/bin:/bin:/usr/X11/bin"
        p path.tainted?
        # => false

((<ruby 1.8 feature>)):
また、(({ENV})) で得られる文字列は ((<Object/freeze>)) されています。

        p ENV['TERM'].frozen?
        # => true

== インクルードされているモジュール:

* ((<Enumerable>))

== メソッド:

--- ENV[key]

    ((|key|)) に対応する環境変数の値を返します。該当する環境変数が存在
    しない時には (({nil})) を返します。

--- ENV[key]=value
--- ENV.store(key, value)

    ((|key|)) に対応する環境変数の値を ((|value|)) にします。
    ((|value|)) が (({nil})) の時、((|key|)) に対応する環境変数を取り
    除きます。

--- ENV.clear

    ((<ruby 1.8 feature>))

    環境変数をすべてクリアします。(({self})) を返します。

--- ENV.delete(key)
--- ENV.delete(key) {|key| ... }

    ((|key|)) に対応する環境変数を取り除きます。取り除かれた環境変数の
    値を返 しますが、((|key|)) に対応する環境変数が存在しない時には 
    (({nil})) を返します。

    ブロックが与えられた時には ((|key|)) にマッチするものがなかった時
    に評価されます。

--- ENV.reject{|key, value| ... }

    ブロックを評価した値が真である時、要素を削除します。
    ((<Enumerable#reject|Enumerable/reject>)) と異なり (({Hash})) を返
    します。

--- ENV.delete_if {|key, value| ... }
--- ENV.reject!{|key, value| ... }

    ((|key|)) と ((|value|)) を引数としてブロックを評価した値が真であ
    る時、環境変数を削除します。

    (({reject!})) は要素に変化がなければ (({nil})) を返します。

--- ENV.each {|key, value| ... }
--- ENV.each_pair {|key, value| ... }

    ((|key|)) と ((|value|)) を引数としてブロックを評価します。

--- ENV.each_key {|key| ... }

    ((|key|)) を引数としてブロックを評価します。

--- ENV.each_value {|value| ... }

    ((|value|)) を引数としてブロックを評価します。

--- ENV.empty?

    環境変数がひとつも定義されていない時真を返します。

--- ENV.fetch(key,[default])
--- ENV.fetch(key) {|key| ... }

    ((|key|)) に関連づけられた値を返します。該当するキーが登録されてい
    ない時には、引数 ((|default|)) が与えられていればその値を、ブロッ
    クが与えられていればそのブロックを評価した値を返します。そのいずれ
    でもなければ例外 ((<IndexError>)) が発生します。

--- ENV.has_key?(val)
--- ENV.include?(val)
--- ENV.key?(val)
--- ENV.member?(val)

    ((|val|)) で指定される環境変数が存在する時真を返します。

--- ENV.has_value?(value)
--- ENV.value?(value)

    ((|value|)) を値として持つ環境変数が存在する時真を返します。

--- ENV.index(val)
--- ENV.key(val)      ((<ruby 1.9 feature>))

    ((|val|)) に対応するキーを返します。対応する要素が存在しない時には 
    (({nil})) を返します。

    ((<ruby 1.9 feature|ruby 1.9 feature/2005-04-02>)):
    ENV.index は version 1.9 では、((<obsolete>)) です。
    使用すると警告メッセージが表示されます。

--- ENV.indexes(key_1, ... , key_n)     ((<obsolete>))
--- ENV.indices(key_1, ... , key_n)     ((<obsolete>))

    引数で指定された名前の環境変数の値の配列を返します。

    ((<ruby 1.8 feature>)):
    このメソッドは version 1.8 では、((<obsolete>)) です。
    使用すると警告メッセージが表示されます。
    代わりに ((<ENV/ENV.values_at>)) を使用します。

--- ENV.invert

    ((<ruby 1.8 feature>))

    環境変数の値をキー、名前を値とした ((<Hash>)) を生成して返します。

--- ENV.keys

    全環境変数の名前の配列を返します。

--- ENV.length
--- ENV.size

    環境変数の数を返します。

--- ENV.rehash

    何もしません。nilを返します。

--- ENV.replace(hash)

    ((<ruby 1.8 feature>))

    環境変数を ((|hash|)) に設定します。(({self})) を返します。

--- ENV.shift

    ((<ruby 1.8 feature>))

    環境変数を一つ取り除いて、それを名前と値の組の配列で返します。
    環境変数が一つも設定されていなければ nil を返します。

--- ENV.to_a

    環境変数から (({[key,value]})) なる 2 要素の配列の配列を生成します。

--- ENV.to_hash

    環境変数の名前と値のハッシュを返します。

--- ENV.update(other)

    ((<ruby 1.8 feature>))

    ハッシュ ((|other|)) の内容を環境変数にマージします。重複するキー
    に対応する値は other の内容で上書きされます。

    (({self})) を返します。

--- ENV.values

    環境変数の全値の配列を返します。

--- ENV.values_at(key_1, ..., key_n)

    ((<ruby 1.8 feature>))

    引数で指定されたキー(環境変数名)に対応する値の配列を返します。存在
    しないキーに対しては nil が対応します。((<ENV/ENV.indexes>)) と 
    ((<ENV/ENV.indices>)) と同じです。

        ENV.update({'FOO','foo', 'BAR','bar'})
        p ENV.values_at(*%w(FOO BAR BAZ))   # => ["foo", "bar", nil]
