= Digest::Base

すべての Digest::XXX クラスの基底クラス。

例えば、MD5 値を得るには以下のようにする。

        require 'digest/md5'
        p Digest::MD5.hexdigest(File.read("ruby-1.8.0.tar.gz"))

        # => "582a65e52598a4a1e9fce523e16e67d6"

あるいは(大きな文字列を生成しない方法)

        require 'digest/md5'

        class Digest::Base
          def self.open(path)
            obj = new

            File.open(path) {|f|
              buf = ""
              while f.read(256, buf)
                obj << buf
              end
            }
            obj
          end
        end

        p Digest::MD5.open("ruby-1.8.0.tar.gz").hexdigest

        # => "582a65e52598a4a1e9fce523e16e67d6"

すべての Digest::XXX クラスは以下の共通インタフェースを持つ。

== スーパークラス:

* ((<Digest::Base>))

== クラスメソッド:

--- Digest::Base.new([str])

    新しいダイジェストオブジェクトを生成する。文字列引数が与えられると
    それを追加する(((<digest.so/update>)) 参照)。

--- Digest::Base.digest(str)

    与えられた文字列に対するハッシュ値を文字列で返す。
    new(str).((<digest.so/digest>)) と等価。

--- Digest::Base.hexdigest(str)

    与えられた文字列に対するハッシュ値を、ASCIIコードを使って
    16進数の列を示す文字列にエンコードして返す。
    new(str).((<digest.so/hexdigest>)) と等価。

== メソッド:

--- dup
--- clone

    ダイジェストオブジェクトの複製を作る。

--- digest

    今までに追加した文字列に対するハッシュ値を文字列で返す。MD5では
    16バイト長、SHA1およびRMD160では20バイト長、SHA256では32バイト長、
    SHA384では48バイト長、SHA512では64バイト長となる。

--- hexdigest
--- to_s

    今までに追加した文字列に対するハッシュ値を、ASCIIコードを使って
    16進数の列を示す文字列にエンコードして返す。MD5では32バイト長、
    SHA1およびRMD160では40バイト長、SHA256では64バイト長、SHA384では
    96バイト長、SHA512では128バイト長となる。Rubyで書くと以下と同じ。

        def hexdigest
          digest.unpack("H*")[0]
        end

--- update(str)
--- self << str

    文字列を追加する。複数回updateを呼ぶことは文字列を連結して
    updateを呼ぶことと等しい。すなわち m.update(a); m.update(b) は
    m.update(a + b) と、 m << a << b は m << a + b とそれぞれ等価
    である。

--- self == md

    与えられたダイジェストオブジェクトと比較する。

--- self == str

    与えられた文字列を digest 値、もしくは hexdigest 値と比較する。
    いずれの値と見るかは与えられた文字列の長さによって自動判別
    される。
