###nonref

= 添付ライブラリ

Ruby は、ライブラリによるクラスやモジュール、メソッドの追加などの拡張
を行うことができます。以下は、標準で添付・配布されているライブラリの一
覧です。ライブラリの読み込みには ((<require|組み込み関数>)) を使用します。

== 添付ライブラリ一覧

((<添付ライブラリ/テキスト>))
/ ((<添付ライブラリ/ファイルフォーマット>))
/ ((<添付ライブラリ/ファイル>))
/ ((<添付ライブラリ/ネットワーク>))
/ ((<添付ライブラリ/入出力>))
/ ((<添付ライブラリ/文字コード>))
/ ((<添付ライブラリ/数学>))
/ ((<添付ライブラリ/データベース>))
/ ((<添付ライブラリ/画面制御・CUI>))
/ ((<添付ライブラリ/GUI>))
/ ((<添付ライブラリ/日付・時間>))
/ ((<添付ライブラリ/マルチスレッド・同期>))
/ ((<添付ライブラリ/Unix>))
/ ((<添付ライブラリ/MS Windows>))
/ ((<添付ライブラリ/GC>))
/ ((<添付ライブラリ/デザインパターン>))
/ ((<添付ライブラリ/開発ツール>))
/ ((<添付ライブラリ/コマンドライン>))
/ ((<添付ライブラリ/その他>))

=== テキスト

* ((<stringio|StringIO>))       文字列を IO にみせかける ((<ruby 1.7 feature>))
* ((<digest|digest.so>))        メッセージダイジェストライブラリ (MD5, RMD160, SHA1, SHA256, SHA384, SHA512) ((<ruby 1.6 feature>))
* ((<erb|ERB>))                 埋め込み Ruby (ERB) ((<ruby 1.8 feature>))
* ((<shellwords|Shellwords>))   シェルに似たトークン分割をするライブラリ
* ((<strscan|strscan.so>))      高速スキャナ ((<ruby 1.7 feature>))
* ((<ripper|Ripper>))           Ruby プログラムのパーサ ((<ruby 1.9 feature>))

=== ファイルフォーマット

* ((<yaml|YAML>))               YAML (YAML Ain't Markup Language) ((<ruby 1.8 feature>))
* ((<rexml|REXML>))             XML (The Extensible Markup Language) ((<ruby 1.8 feature>))
* ((<rss>))                     RSS ((<ruby 1.8.2 feature>))
* ((<zlib|zlib.so>))            gzip, deflate 圧縮・伸張 ((<ruby 1.8 feature>))
* ((<mailread|Mail>))           Unix mbox なメールから情報を得る
* ((<csv|csv.rb>))              CSV (Comma Separated Values) ((<ruby 1.8 feature>))

=== ファイル

* ((<fileutils|fileutils.rb>))  ファイル操作ユーティリティ ((<ruby 1.7 feature>))
* ((<find|Find>))               ファイル探索モジュール
* ((<pathname|pathname.rb>))    パス名クラス ((<ruby 1.8 feature>))
* ((<tempfile|Tempfile>))       テンポラリファイル生成
* ((<tmpdir|tmpdir.rb>))        テンポラリディレクトリを返す ((<ruby 1.8 feature>))
* ((<un|un.rb>))                Unixコマンド like なファイル操作ユーティリティ ((<ruby 1.8 feature>))

=== ネットワーク

* ((<open-uri|open-uri.rb>))    open() の URI サポート拡張 ((<ruby 1.8 feature>))
* ((<socket|socket.so>))        ソケット拡張ライブラリ
* ((<uri|URI>))                 URI ライブラリ ((<ruby 1.6 feature>))
* ((<cgi|CGI>))                 CGI作成支援
* ((<"cgi/session"|CGI::Session>)) CGIセッション管理
* ((<webrick|webrick.rb>))      WEB server toolkit ((<ruby 1.8 feature>))
* ((<drb|drb.rb>))              分散 Ruby (dRuby) ((<ruby 1.8 feature>))
* ((<rinda|Rinda>))                   A Ruby implementation of the Linda distributed computing paradigm ((<ruby 1.8 feature>))
* ((<"net/ftp"|"net/ftp.rb">))  FTP クライアントライブラリ
* ((<"net/ftptls">))            SSL/TLS 拡張 FTP クライアントライブラリ ((<ruby 1.8 feature>))
* ((<"net/http"|"net/http.rb">)) HTTP クライアントライブラリ
* ((<"net/https"|"net/https.rb">)) SSL/TLS 拡張 HTTP クライアントライブラリ ((<ruby 1.8 feature>))
* ((<"net/imap"|"net/imap.rb">)) IMAP クライアントライブラリ ((<ruby 1.6 feature>))
* ((<"net/pop"|"net/pop.rb">))  POP クライアントライブラリ
* ((<"net/smtp"|"net/smtp.rb">)) SMTP クライアントライブラリ
* ((<"net/telnet"|Net::Telnet>)) TELNET クライアントライブラリ
* ((<"net/telnets">))           SSL/TLS 拡張 TELNET クライアントライブラリ ((<ruby 1.8 feature>))
* ((<openssl|openssl.rb>))      Ruby/OpenSSL  ((<ruby 1.8 feature>))
* ((<resolv-replace|resolv-replace.rb>)) 名前解決に resolv.rb を使用する ((<ruby 1.6 feature>))
* ((<resolv|Resolv>))           Ruby版 リゾルバ ((<ruby 1.6 feature>))
* ((<xmlrpc|XMLRPC>))           XML-RPC (remote procedure calls over HTTP using XML) ((<ruby 1.8 feature>))
* ((<gserver|GServer>))         Ruby Generic Server ((<ruby 1.8 feature>))
* ((<soap|"soap/soap.rb">))     SOAP4R ((<ruby 1.8 feature>))
* ((<wsdl|"wsdl/wsdl.rb">))     WSDL4R ((<ruby 1.8 feature>))
* ((<ping|Ping>))               ホストに対するパケット到達の検証
* ((<ipaddr|IPAddr>))           IPアドレスクラス(IPAddr) ((<ruby 1.8 feature>))

=== 入出力

* ((<fcntl|Fcntl>))             ((<fcntl(2)|manual page>)) で使用する定数を集めたモジュール
* ((<open3|Open3>))             外部プログラムと標準入力・標準出力・標準エラー出力で通信するライブラリ
* ((<readbytes|readbytes.rb>))  IO に指定した長さを確実に読むメソッドを追加するライブラリ
* ((<scanf|scanf.rb>))          C の scanf のようなライブラリ ((<ruby 1.8 feature>))
* ((<"io/nonblock"|"io/nonblock.rb">)) IO クラスの拡張 (nonblockモードに関するメソッドの追加) ((<ruby 1.8 feature>))
* ((<"io/wait"|"io/wait.so">))  IO クラスの拡張 (IO の入力待ちを行うメソッドの追加) ((<ruby 1.8 feature>))

=== 文字コード

* ((<iconv|Iconv>))             文字列エンコーディング変換ライブラリ ((<ruby 1.7 feature>))
* ((<jcode|jcode.rb>))          Stringクラスを日本語対応に変更する
* ((<kconv|kconv.rb>))          漢字コード変換
* ((<nkf|NKF>))                 日本語文字コードエンコーディング変換

=== 数学

* ((<complex|complex.rb>))      複素数クラス
* ((<rational|rational.rb>))    有理数クラス
* ((<matrix|matrix.rb>))        行列・ベクトルクラス
* ((<mathn|mathn.rb>))          数値演算メソッドを数学的に正しく変更するライブラリ ((-るびきち：未完成の部分あり-))
* ((<set|Set>))                 有限集合 ((<ruby 1.7 feature>))
* ((<tsort|TSort>))             トポロジカルソートと強連結成分 ((<ruby 1.7 feature>))
* ((<bigdecimal|bigdecimal.so>)) 可変長浮動小数点演算 ((<ruby 1.8 feature>))

=== データベース

* ((<dbm|DBM>))                 ndbm をハッシュのように使うためのライブラリ
* ((<gdbm|GDBM>))               gdbm (GNU dbm) をハッシュのように使うためのライブラリ
* ((<sdbm|SDBM>))               sdbm ハッシュライブラリ
* ((<pstore|PStore>))           オブジェクト永続化

=== 画面制御・CUI

* ((<curses|curses.so>))        端末操作ライブラリ curses のインターフェイス
* ((<expect|expect.rb>))        対話プログラムをスクリプトから制御する
* ((<pty|PTY>))                 疑似端末(Pseudo tTY)を扱うモジュール
* ((<readline|Readline>))       GNU Readline インタフェース
* ((<shell|Shell>))             シェルに似たインターフェースを提供するライブラリ

=== GUI

* ((<tk>))                      Tcl/Tk ライブラリ

=== 日付・時間

* ((<date|date.rb>))            日付クラス
* ((<time|time.rb>))            文字列とTimeオブジェクトの変換 ((<ruby 1.6 feature>))
* ((<parsedate|ParseDate>))     日付・時刻フォーマットの解析

=== マルチスレッド・同期

* ((<thread|thread.rb>))        Mutex, Queue などのスレッド関連ユーティリティ
* ((<timeout|timeout.rb>))      タイムアウトを行うメソッド timeout
* ((<monitor|monitor.rb>))      モニタライブラリ (並行処理プリミティブ)
* ((<mutex_m|mutex_m.rb>))      Mutexのモジュール版
* ((<sync|sync.rb>))            Mix-inにより再入可能なreader/writerロック機能を提供するライブラリ
* ((<thwait|ThreadsWait>))      thread synchronization class

=== Unix

* ((<etc|Etc>))                 (({/etc/passwd})) などの情報を取得するライブラリ
* ((<syslog|Syslog>))           UNIXのsyslogのラッパーモジュール ((<ruby 1.6 feature>))

=== MS Windows

* ((<Win32API>))                Win32 API をコールするクラス (win32 専用) 将来 dl/win32.rb で置き換えられる予定
* ((<WIN32OLE>))                Win32OLE 拡張モジュール ((<ruby 1.7 feature>))
* ((<"win32/registry"|"win32/registry.rb">)) Win32 レジストリ I/F ((<ruby 1.7 feature>))

=== GC

* ((<weakref|weakref.rb>))      GC される「弱い」リファレンスを作成する
* ((<finalize|Finalizer>))      オブジェクトがGCされる時にある依存オブジェクトに対してメッセージを送るライブラリ

=== デザインパターン

* ((<delegate|delegate.rb>))    委譲を支援するクラス
* ((<forwardable|forwardable.rb>)) クラスに対してメソッドの委譲機能を定義するライブラリ
* ((<observable|Observable>))   Observer パターンの Ruby 実装
* ((<singleton|Singleton>))     Singleton パターンの Ruby 実装

=== 開発ツール

* ((<"test/unit"|Test::Unit>))  ユニットテストライブラリ ((<ruby 1.8 feature>))
* ((<pp|pp.rb>))                Pretty-printer ((<ruby 1.7 feature>))
* ((<benchmark|benchmark.rb>))  ベンチマークライブラリ ((<ruby 1.7 feature>))
* ((<debug|debug.rb>))          Ruby デバッガ
* ((<tracer|tracer.rb>))        Ruby のトレーサ
* ((<profiler|profiler.rb>))    プロファイラライブラリ ((<ruby 1.7 feature>))
* ((<profile|profile.rb>))      require するだけで使えるプロファイラ
* ((<mkmf|mkmf.rb>))            拡張ライブラリ作成用ツール
* ((<rbconfig|Config>))         Ruby インタプリタの設定情報
* ((<rubyunit|rubyunit.rb>))    RubyUnit互換ライブラリ ((<ruby 1.8 feature>))

=== コマンドライン

* ((<optparse|OptionParser>))    コマンドラインオプションの解析 ((<ruby 1.7 feature>))
* ((<getoptlong|getoptlong.rb>)) コマンドラインオプションの解析

=== その他

* ((<dl|dl.so>))                ダイナミックリンカへのインタフェース ((<ruby 1.7 feature>))
* ((<enumerator|enumerator.so>)) each 以外のメソッドも enumerate できるようにするライブラリ ((<ruby 1.8 feature>))
* ((<generator|Generator>))     内部イテレータから外部イテレータへ変換するライブラリ ((<ruby 1.8 feature>))
* ((<abbrev|Abbrev>))           Calculate the set of unique abbreviations for a given set of strings ((<ruby 1.8 feature>))
* ((<prettyprint|PrettyPrint>)) PrettyPrint ((<ruby 1.7 feature>))
* ((<ostruct|OpenStruct>))      Python 風の「attr on write」Struct
* ((<e2mmap|e2mmap.rb>))        例外クラスとメッセージのマッピング
* ((<English|English.rb>))      特殊変数 $! などに英語名の別名($ERROR_INFO など)をつける
* ((<logger|Logger>))           a simple but sophisticated logging utility ((<ruby 1.8 feature>))
* ((<eregex|eregex.rb>))        正規表現の `|', `&' 演算子による結合を可能にする
* ((<racc runtime|racc>))       ((<Racc|URL:http://www.ruby-lang.org/en/raa-list.rhtml?name=Racc>)) ランタイムライブラリ ((<ruby 1.7 feature>))

=== 添付コマンド
# このページにあるのは不適切?

* ((<irb|irb.rb>))              Interactive Ruby (Ruby の対話インタフェース)
* ((<rdoc|"rdoc/rdoc.rb">))     RDoc ((<ruby 1.8 feature>))
* ((<ri>))                      RDoc で書かれた Ruby のドキュメントをコマンドラインから参照

=== obsolete
* ((<Env|Env.rb>))              ((*このライブラリはobsoleteです*))
* ((<importenv|importenv.rb>))  環境変数をグローバル変数で操作
* ((<cgi-lib|cgi-lib.rb>))      ((*このライブラリはobsoleteです*))(((<cgi|cgi.rb>))を使ってください)
* ((<date2|date2.rb>))          ((*このライブラリはobsoleteです*))(((<date|date.rb>))を使ってください)
* ((<final|final.rb>))          ((*このライブラリはobsoleteです*))(本体組み込みになりました。1.8 ではこのライブラリはなくなりました)
* ftplib                        ((*このライブラリはobsoleteです*))(代わりに ((<"net/ftp"|"net/ftp.rb">)) を使用します。1.8 ではこのライブラリはなくなりました)
* ((<getopts|getopts.rb>))      コマンドラインオプションの解析
* ((<parsearg|parsearg.rb>))    コマンドラインオプションの解析(((<getopts|getopts.rb>))も参照)
* ((<md5|md5.rb>))              ((*このライブラリはobsoleteです*))(((<"digest/md5"|"digest/md5.so">))を使ってください)
* ((<sha1|sha1.rb>))            ((*このライブラリはobsoleteです*))(((<"digest/sha1"|"digest/sha1.so">))を使ってください)
* telnet                        ((*このライブラリはobsoleteです*))(((<"net/telnet"|"net/telnet.rb">))を使ってください。1.8 ではこのライブラリはなくなりました)
* ((<ftools|ftools.rb>))        1.8 以降では、ftools.rb の利用は推奨しません。((<fileutils|fileutils.rb>))を使ってください。
* ((<base64|base64.rb>))        Base64 エンコーディングを扱う操作を集めたモジュール (((<String#unpack|String/unpack>))、((<Array#pack|Array/pack>))で同等の処理ができます。((<packテンプレート文字列>))の'm'、'M'を参照してください)
