= socket.so

== クラス

* ((<IO>))
  * ((<BasicSocket>))
    * ((<IPSocket>))
      * ((<TCPSocket>))
        * ((<TCPServer>))
        * ((<SOCKSSocket>))
      * ((<UDPSocket>))
    * ((<UNIXSocket>))
      * ((<UNIXServer>))
    * ((<Socket>))

== モジュール

* ((<Socket::Constants>))

== ホスト指定形式

AF_INETなソケットにおいてホストを指定するには以下のいずれか
の形式を指定します。

* IPアドレスを表す 32bit の整数 (例: 0x7f000001)

* ホスト名 (例: "localhost")

* octet decimalによるIPアドレス(文字列) (例: "127.0.0.1")

* 空文字列 ("") - (({INADDR_ANY}))に相当

* 文字列 (({"<broadcast>"})) - (({INADDR_BROADCAST}))に相当

== サービス指定形式

サービスを指定するには以下のいずれかの形式を指定します。

* ポート番号(整数または文字列) (例: 21, "21")
* サービス名 (例: "ftp")

== ソケットアドレス構造体を pack した文字列

ソケットアドレス構造体とは、C 言語の構造体 struct sockaddr_in (IPv4) 
や struct sockaddr_un (Unix ドメイン)を指します。
((<Socket>)) クラスなどソケットの低レベルインタフェースで利用されます。

((<ruby 1.7 feature>)):
((<Socket/Socket.pack_sockaddr_in>)),
((<Socket/Socket.unpack_sockaddr_in>)) といったメソッドにより、
例えば、以下のようにしてこの文字列を得ることが出来ます

    require 'socket'
    p Socket.pack_sockaddr_in("echo", "127.0.0.1")
    => "\002\000\000\a\177\000\000\001\000\000\000\000\000\000\000\000"

また、ruby 1.6 以前では、以下のように ((<Array/pack>)) を使用できます。

    require 'socket'
    p [Socket::AF_INET,
       Socket.getservbyname('echo'),
       127, 0, 0, 1].pack("s n C4 x8")
    => "\002\000\000\a\177\000\000\001\000\000\000\000\000\000\000\000"
