= mathn.rb
[2001/02/20] ((<るびきち|URL:mailto:rubikitch@ruby-lang.org>)) ((-参考：((<ruby-list:1174>))-))

((<rational.rb>))と((<complex.rb>))を補助する関数群。

本来 Floatとは異なり, Rationalは誤差がないので, 

  1/2 -> 1/2 (Rational)
  2 * Rational(1,2) -> 1 (Fixnum)

となってほしいこともあるかと思います. あるいは、Complexにつき、

  Complex(0,-1)**2 -> -1 (Fixnum)
  Complex(1,-1) - Complex(0,-1) -> 1 (Fixnum)

となってほしいこともあるかと思います. つまり, rubyのBignumとFixnumとの様
な関係ですね(rubyではこれらの型変換は勝手に行なっています). 

mathn.rbをインクルードすると上の様な動作を行なうようになります. つまり, 
Rational(やRationalを含むComplex)とInteger(FixnumとBignum)との
間の関係を、ちょうどBignumとFixnumとの間のような関係にします。
具体的には、Rationalのインスタンスが整数ならば、それは自動的にInteger
(FixnumまたはBignum)となり、また、((|Integer/Integer|))の結果、割り
切れない時はRationalが返るようになります。後者は、整数のメソッド「/」が
整商(.div)でなく、商(.quo)を返すようになる、ということを意味します。

なお、この挙動は、グローバルに影響を与えます。つまり、(Rubyで書かれた)
汎用ライブラリをrequireしていた場合、ライブラリ中の動作も、上のように
変更されることになります。他人の書いたライブラリを使う時は、ご注意
下さい(逆に、汎用ライブラリの作者の方々は、この((<mathn.rb>))がrequire
される可能性を留意して書いて下されば、親切だと思います)。


== Integer
=== クラスメソッド:
--- Integer.from_prime_division(pd)
      素因数分解の配列((|pd|))から数を求める。
      ((|pd|))は(({[素因数, 指数]}))組の配列である。
        例:
        Integer.from_prime_division [[2,3],[3,2]]
        -> 72 # == 2**3 * 3**2

=== メソッド:
--- Integer#gcd2(int)
      ((|self|))と((|int|))の最大公約数を求める。
        例:
        12.gcd2 8
        -> 4
      
--- Integer#prime_division
      ((|self|))の素因数分解(の配列)を求める。
        例:
        72.prime_division
        -> [[2, 3], [3, 2]]

== Prime
=== インクルードしているモジュール:
* ((<Enumerable>))

=== クラスメソッド:
--- Prime.new
      素数を生成するクラスを作る。

=== メソッド:
--- Prime#succ
--- Prime#next
      次の素数を返す。
        例:
        pp = Prime.new
        pp.succ # => 2
        pp.succ # => 3
        pp.succ # => 5

--- Prime#each
      素数について繰り返し。
      これは((*無限ループ*))になるので必ずbreakを入れること。
        例:
        > pp=Prime.new; i = 0; pp.each  {|x| break if i > 5; puts x; i+=1;}
        2
        3
        5
        7
        11
        13

== Fixnum
* Fixnum#divmodの商が小数点以下まで求まるようになる。
* もともとのFixnum#divmodはFixnum#divmod!となる。
* Fixnum#/がFixnum#quoと同じ働きをするようになる(有理数または整数を返す)。

== Bignum
* もともとのBignum#divmodはBignum#divmod!となる。
* Bignum#/がBignum#quoと同じ働きをするようになる(有理数または整数を返す)。

== Rational
--- Rational#**
      べき乗。 RationalになるようであればRationalで返す。
--- Rational#power2
      作りかけ(^^;;
--- Rational#inspect
      「3/5」などの形で返す。

== Math
--- Math.sqrt(a)
      aの正の平方根。
      aがComplexの時は、Complexを返す。
      aが負の時は、aを正にして、その平方根をComplexの虚数部に入れて返す。
      それ以外は、Math.rsqrtに丸投げ。
--- Math.rsqrt(a)
      複素数を考慮しないので、負の数やComplexをあたえてはいけない。
      
      aがFloatの時は、Floatを返す。
      それ以外の時、平方根が有理数であれば、RationalまたはIntergerを返す。
      無理数であれば、Floatを返す。
