= UNIXSocket

UNIXドメインのストリーム型ソケットのクラス。通常の
((<IO>))クラスのサブクラスと同様の
入出力ができます。

== スーパークラス:

* ((<BasicSocket>))

== クラスメソッド:

--- UNIXSocket.open(path)
--- UNIXSocket.new(path)
    ((|path|))で指定したパス名を用いて接続したソケットを返
    します。

--- UNIXSocket.pair([type[, protocol]])  ((<ruby 1.7 feature>))
--- UNIXSocket.socketpair([type[, protocol]])  ((<ruby 1.7 feature>))
    相互に結合されたUNIXソケットのペアを含む2要素の配列を返します。
    ((|type|)) が省略された場合、Socket::SOCK_STREAM が使われます。
    ((|protocol|)) が省略された場合、0 が使われます。

== メソッド:

--- addr
    ソケットの接続情報を表す配列を返します。配列の各要素は第1要
    素が文字列 "AF_UNIX"、第2要素がパスを表す文字列です。

--- path
    UNIXソケットのパスを返します。

--- peeraddr
    接続相手先ソケットの情報を表す配列を返します。配列の各要素は
    ((<IPSocket#addr|IPSocket/addr>))メソッドが返す配列
    と同じです。

--- recvfrom(len[, flags])
    (({recv}))と同様にソケットからデータを受け取りますが、
    戻り値は文字列と相手ソケットのパスのペアです。引数につい
    てはrecvと同様です。

--- recv_io([klass[, mode]])  ((<ruby 1.7 feature>))
    ファイルディスクリプタを受け取ります。

    ((|klass|)) が nil の場合、ファイルディスクリプタが Fixnum として
    返されます。

    ((|klass|)) が nil でない場合、
    (({((|klass|)).for_fd(fd[, ((|mode|))])})) が呼ばれ、その値が返されます。
    ((|klass|)) が省略された場合は (({IO})) が指定されたものとみなされ、
    (({IO.for_fd(fd[, ((|mode|))])})) が呼ばれます。

--- send_io(io)  ((<ruby 1.7 feature>))
    IO や Fixnum に対応するファイルディスクリプタを送ります。
