= Resolv
Rubyで書かれたリゾルバ(名前解決)ライブラリ。
Rubyで書かれているためthread-awareであり、
並列に多くのホスト名を解決することができます。

DNSモジュールを使うことで、さまざまなリソースを直接ルックアップできます。

((<執筆者募集>))

== 例:
  Resolv.getaddress("www.ruby-lang.org")
  Resolv.getname("210.251.121.214").to_s
  Resolv::DNS.new.getresources("www.ruby-lang.org", Resolv::DNS::Resource::IN::A).collect {|r| r.address}
  Resolv::DNS.new.getresources("ruby-lang.org", Resolv::DNS::Resource::IN::MX).collect {|r| [r.exchange.to_s, r.preference]}

== クラスメソッド:
--- Resolv.getaddress(name)
--- Resolv.getaddresses(name)
--- Resolv.each_address(name) {|address| ...}
    Stringのホスト名 ((|name|)) のIPアドレスをルックアップします

    getaddress はルックアップ結果の最初のアドレスを返します。
    getaddresses はルックアップ結果のアドレスリストを返します。
    each_address はルックアップ結果のアドレスに対するイテレータ

    例:
      Resolv.getaddress("www.ruby-lang.org").to_s #=> "210.251.121.214"

--- Resolv.getname(address)
--- Resolv.getnames(address)
--- Resolv.each_name(address) {|name| ...}
    StringのIPアドレス ((|address|)) のホスト名をルックアップします。

    getname はルックアップ結果の最初のホスト名を返します。
    getnames はルックアップ結果のホスト名リストを返します。
    each_names はルックアップ結果のアドレスに対するイテレータ

    例:
      Resolv.getname("210.251.121.214").to_s #=> "helium.ruby-lang.org"


== Resolv::Hosts
/etc/hosts を使用するホスト名リゾルバです。

=== クラスメソッド:
--- Resolv::Hosts.new(hosts='/etc/hosts')

=== メソッド:
--- Resolv::Hosts#getaddress(name)
--- Resolv::Hosts#getaddresses(name)
--- Resolv::Hosts#each_address(name) {|address| ...}
    address lookup methods.

--- Resolv::Hosts#getname(address)
--- Resolv::Hosts#getnames(address)
--- Resolv::Hosts#each_name(address) {|name| ...}
    hostnames lookup methods.

== Resolv::DNS
DNS stub resolver.

=== クラスメソッド:
--- Resolv::DNS.new(resolv_conf='/etc/resolv.conf')

=== メソッド:
--- Resolv::DNS#getaddress(name)
--- Resolv::DNS#getaddresses(name)
--- Resolv::DNS#each_address(name) {|address| ...}
    address lookup methods.

    ((|name|)) は Resolv::Name または String でなければなりません。
    ルックアップ結果は Resolv::IPv4 または Resolv::IPv6 のインスタンスとなります。

--- Resolv::DNS#getname(address)
--- Resolv::DNS#getnames(address)
--- Resolv::DNS#each_name(address) {|name| ...}
    hostnames lookup methods.

    ((|address|)) は Resolv::IPv4, Resolv::IPv6, String のいずれかでなければなりません。
    ルックアップ結果は Resolv::Name のインスタンスとなります。

--- Resolv::DNS#getresource(name, typeclass)
--- Resolv::DNS#getresources(name, typeclass)
--- Resolv::DNS#each_resource(name, typeclass) {|resource| ...}
    They lookup DNS resources of ((|name|)).
    ((|name|)) は Resolv::Name または String でなければなりません。

    ((|typeclass|)) は以下のいずれかです。
    * Resolv::DNS::Resource::IN::ANY
    * Resolv::DNS::Resource::IN::NS
    * Resolv::DNS::Resource::IN::CNAME
    * Resolv::DNS::Resource::IN::SOA
    * Resolv::DNS::Resource::IN::HINFO
    * Resolv::DNS::Resource::IN::MINFO
    * Resolv::DNS::Resource::IN::MX
    * Resolv::DNS::Resource::IN::TXT
    * Resolv::DNS::Resource::IN::ANY
    * Resolv::DNS::Resource::IN::A
    * Resolv::DNS::Resource::IN::WKS
    * Resolv::DNS::Resource::IN::PTR
    * Resolv::DNS::Resource::IN::AAAA

    ルックアップ結果は Resolv::DNS::Resource （のサブクラス）のインスタンスとなります。

== Resolv::DNS::Resource::IN::NS
--- name
== Resolv::DNS::Resource::IN::CNAME
--- name
== Resolv::DNS::Resource::IN::SOA
--- mname
--- rname
--- serial
--- refresh
--- retry
--- expire
--- minimum
== Resolv::DNS::Resource::IN::HINFO
--- cpu
--- os
== Resolv::DNS::Resource::IN::MINFO
--- rmailbx
--- emailbx
== Resolv::DNS::Resource::IN::MX
--- preference
--- exchange
== Resolv::DNS::Resource::IN::TXT
--- data
== Resolv::DNS::Resource::IN::A
--- address
== Resolv::DNS::Resource::IN::WKS
--- address
--- protocol
--- bitmap
== Resolv::DNS::Resource::IN::PTR
--- name
== Resolv::DNS::Resource::IN::AAAA
--- address

== Resolv::DNS::Name
=== クラスメソッド:
--- Resolv::DNS::Name.create(name)

=== メソッド:
--- Resolv::DNS::Name#to_s

== Resolv::DNS::Resource

== Resolv::IPv4
=== クラスメソッド:
--- Resolv::IPv4.create(address)

=== メソッド:
--- Resolv::IPv4#to_s
--- Resolv::IPv4#to_name

=== 定数:
--- Resolv::IPv4::Regex
#    regular expression for IPv4 address.
    IPv4のアドレスの正規表現。

== Resolv::IPv6
=== クラスメソッド:
--- Resolv::IPv6.create(address)

=== メソッド:
--- Resolv::IPv6#to_s
--- Resolv::IPv6#to_name

=== 定数:
--- Resolv::IPv6::Regex
#    regular expression for IPv6 address.
    IPv6のアドレスの正規表現。

== Bugs
#NIS is not supported.
NISはサポートされていません。
