= PStore
Rubyのオブジェクトを外部ファイルに格納するためのクラス。
内部で((<Marshal>))を使っている。

== 使い方
  db = PStore.new("/tmp/foo")
  db.transaction do
    p db.roots
    ary = db["root"] = [1,2,3,4]
    ary[0] = [1,1.5]
  end

  db.transaction do
    p db["root"]
  end

データベースにアクセスするためには、transactionの((*ブロック内*))である必要がある。
インターフェースはHashライクである。

== クラスメソッド
--- PStore.new(file)
      ファイル名 ((|file|)) に対してデータベースを読み書きする。
      ((|file|)) のあるディレクトリは書き込み可能である必要がある。
      データベースを更新するときにバックアップファイルが作成されるため。

      ((<ruby 1.8.2 feature>)): データベースの更新が成功すると、バックアップファイルは削除される。バックアップファイル名は
      ファイル名に ".tmp" および ".new" を付けたもの。
      
      ruby 1.8.1 まで: バックアップファイルは削除されずに残る。バックアップファイル名はファイル名の後に "~" を付けたもの。

== メソッド
--- transaction {|pstore| ... }
--- transaction(read_only=false) {|pstore| ... }    ((<ruby 1.7 feature>))
      トランザクションに入る。
      このブロックの中でしかデータベースの読み書きはできない。

      ((<ruby 1.7 feature>)): 1.7では読み込み専用のトランザクションが使用可能。

--- [](name)
      ルート((|name|))に対応する値を得る。
      (({Hash#[]}))に相当。

--- []=(name, value)
      ルート((|name|))に対応する値((|value|))をセットする。
      (({Hash#[]=}))に相当。

--- fetch(name[, default]) ((<ruby 1.8 feature>))
      ルート((|name|))に対応する値を得る。
      該当するルートが登録されていない時には、
      引数 ((|default|)) が与えられていればその値を返し、
      与えられていなければ例外 ((<PStore::Error>)) が発生します。
      (({Hash#fetch}))に相当。

--- delete(name)
      ルート((|name|))に対応する値を削除する。
      (({Hash#delete}))に相当。

--- roots
      ルートの集合を配列で返す。
      (({Hash#keys}))に相当。

--- root?(name)
      ((|name|))がルートであるかどうか。
      (({Hash#key?}))に相当。

--- path
      データベースのファイル名を得る。

--- commit
      データベースの読み書きを終了する。
      すなわち、transactionブロックから抜ける。
      データベースの変更が反映される。

--- abort
      データベースの読み書きを終了する。
      transactionブロックから抜けるが、データベースの変更は反映されない。

== プライベートメソッド
--- in_transaction
      トランザクションの中でなければ例外を発生させる。
