###nonref

= 4. 構文

* ((<FAQ::構文/4.1 (({:exit}))等の(({:}))のついた識別子は何ですか>))
* ((<FAQ::構文/4.2 シンボルと同名の変数の値を取り出すにはどうすればいいですか>))
* ((<FAQ::構文/4.3 (({loop}))は制御構造ですか>))
* ((<FAQ::構文/4.4 (({a +b}))がエラーになりますが>))
* ((<FAQ::構文/4.5 (({s = "x"; puts s *10})) がエラーになりますが>))
* ((<FAQ::構文/4.6 (({p {}}))で何も表示されません>))
* ((<FAQ::構文/4.7 pos=() という setter メソッドがあるのに、pos = 1 としてもなにも起こっていないように見える>))
* ((<FAQ::構文/4.8 (({'\1'}))と(({'\\1'}))はどう違いますか>))
* ((<FAQ::構文/4.9 (({p true or true and false}))は(({true}))を表示するのに、(({a=true if true or true and false}))では、(({a}))に(({true}))が代入されません。>))
* ((<FAQ::構文/4.10 (({p(nil || "")})) はなんでもないのに、 (({p(nil or "")})) はパースエラーだと言われます>))

== 4.1 (({:exit}))等の(({:}))のついた識別子は何ですか

シンボルと呼ばれる、識別子と1対1対応するオブジェクトです
((-version 1.4 以前はシンボルは整数(Fixnum)で実装されていました。現在はSymbolクラスのインスタンスです-))。
"exit".internとしても求められます。catch, throw, autoloadなどでは、
引数として文字列もシンボルも使えます。

== 4.2 シンボルと同名の変数の値を取り出すにはどうすればいいですか

(({symbol}))のスコープで(({eval( (:symbol).id2name)}))とすると、
値が取り出せます。

  a = 'This is the content of "a"'
  b = eval(:a.id2name)
  a.id == b.id

== 4.3 (({loop}))は制御構造ですか

メソッドです。ブロックは新しいローカル変数のスコープを導入します。

== 4.4 (({a +b}))がエラーになりますが

(({a(+b)}))と解析されています。(({+}))の両側の空白をなくすか、いれるか
のどちらかにしてください。

== 4.5 (({s = "x"; puts s *10})) がエラーになりますが

(({puts s *10})) のところが、s(*10)というメソッド呼び出しと解析されて
しまいます。(({s*10}))にするか、(({s * 10}))にしてください。

((<ruby 1.8 feature>)): 1.8(?) 以降ではエラーになりません。

== 4.6 (({p {}}))で何も表示されません

{}がハッシュのコンストラクタではなく、ブロックと解析されています。
p({}) か p Hash.new のようにして回避してください。

== 4.7 pos=() という setter メソッドがあるのに、pos = 1 としてもなにも起こっていないように見える

これは以下のような例です。

  class C
    attr_reader :pos
    def pos=(n)
      @pos = n * 3
    end

    def set
      pos = 1   #A
    end
  end

  a = C.new
  a.set
  p a.pos    #=> nil (3 を期待していた)

最後の行で 3 を期待しても、実際には nil になります。
Ruby は A の行をローカル変数への代入と解釈するからです。
pos=() の呼びだしにするには (({self.pos = 1})) としてください。

== 4.8 (({'\1'}))と(({'\\1'}))はどう違いますか

同じです。シングルクォートの中では、(({\'}))と(({\\}))、行末の(({\}))
(改行を無効にします)だけが解釈され、それ以外は解釈されません。
((-((<ruby 1.8 feature>)): 1.8.1(?) 以降ではシングルクォートで囲まれ
た文字列では行末の\は \ そのものとして解釈されます。((<ruby-dev:21339>))-))

== 4.9 (({p true or true and false}))は(({true}))を表示するのに、(({a=true if true or true and false}))では、(({a}))に(({true}))が代入されません。

最初の式は、(({(p true) or true and false}))と解釈されます。
(({and/or}))は
文の構成要素として解釈され、(({p}))の引数を結ぶ演算子としては解釈され
ません。

2番目のは、(({a=true if (true or true and false)}))と解釈されています。
(({if}))の方が(({and/or}))より優先順位が低いこと、
(({or}))と(({and}))の優先順位が同じなので、
左から順に解釈されることによります。

== 4.10 (({p(nil || "")})) はなんでもないのに、 (({p(nil or "")})) はパースエラーだと言われます

|| は引数を結ぶことができますが、or は文と文を結ぶことしかできず、
引数を結ぶことができないからです。この違いは、たとえば以下のふたつの
式の結果がどうなるか試してみればわかります。

    p nil || ""
    p nil or ""
