= Errno::EXXX

各 (({errno})) に対応する例外クラスです。実際のクラス名については 
((<Errno>)) モジュールとシステムのマニュアル ((<errno(3)|manual page>)) 
を参照してください。

== スーパークラス:

* ((<SystemCallError>))

== 定数:

--- Errno

    各クラスに対応する (({errno})) の値です。

    (({Errno::EXXX::Errno})) 定数は、対応する値が常に設定されています
    が、((<SystemCallError#errno|SystemCallError/errno>)) メソッドは実
    際にエラーが発生してなければ (({nil})) を返します。

    ((<ruby 1.8 feature>)): Errno::EXXX では対応する errno 値がオブジェ
    クト生成時に設定されています。下記の例を参照。

    : 例:

      (({Errno::EAGAIN})) と (({Errno::EWOULDBLOCK})) はシステムによっ
      ては同じ (({errno})) 値を持つ例外クラスです。以下は (({Errno})) 
      定数によりこのことを調べています。

        p Errno::EAGAIN::Errno            # => 11
        p Errno::EWOULDBLOCK::Errno       # => 11

        p Errno::EAGAIN.new.errno         # => nil
        p Errno::EWOULDBLOCK.new.errno    # => nil

      ((<ruby 1.8 feature>))

        p Errno::EAGAIN.new.errno         # => 11
        p Errno::EWOULDBLOCK.new.errno    # => 11
