= Dir

ディレクトリ内の要素を順に返すディレクトリストリーム操作のためのクラス。

== スーパークラス:

* ((<Object>))

== インクルードしているモジュール:

* ((<Enumerable>))

== クラスメソッド:

--- Dir[pattern]
--- Dir.glob(pattern)
--- Dir.glob(pattern) {|file| ...}
--- Dir.glob(pattern[, flags])                  ((<ruby 1.7 feature>))
--- Dir.glob(pattern[, flags]) {|file| ...}     ((<ruby 1.7 feature>))

    ワイルドカードの展開を行った結果を文字列の配列として返します。
    ブロックが与えられたときはワイルドカードにマッチしたファイルを
    引数にそのブロックを 1 つずつ評価して (({nil})) を返します

    パターンを空白(スペース、タブ、改行)あるいは "\0" で区切って 1 度
    に複数のパターンを指定することもできます。

        p Dir.glob("f* b*")
        => ["foo", "bar"]

    ワイルドカードには以下のものがあります。

    * (({*}))

      空文字列を含む任意の文字列と一致します。
    * (({?}))

      任意の一文字と一致します。
    * (({[ ]}))

      鈎括弧内のいずれかの文字と一致します。(({-})) でつな
      がれた文字は範囲を表します。鈎括弧の中の最初の文字が
      (({^})) である時には含まれない文字と一致します。
      ((({^})) の代わりに ksh や POSIX shell のように (({!})) も同じ意
      味で使えます。)

    * (({{ }}))

      コンマで区切られた文字列の組合せに展開します。例えば、
      (({foo{a,b,c}}))は(({fooa})), (({foob})),
      (({fooc}))に展開されそれぞれに対してマッチ判定を行います。

      括弧は入れ子にすることができます。例えば、
      (({{foo,bar{foo,bar}}})) は (({foo})), (({barfoo})), (({barbar}))
      のそれぞれにマッチします。

    * (({**/}))

      ワイルドカード (({*/})) の0回以上の繰り返しを意味し、
      ディレクトリを再帰的にたどってマッチを行います。
      例えば,
      (({foo/**/bar})) は (({foo/bar})), (({foo/*/bar})),
      (({foo/*/*/bar})) ... (以下無限に続く)に対してそれぞれ
      マッチ判定を行います。

    ((<ruby 1.7 feature>)):
    ワイルドカードはバックスラッシュによりエスケープすることがで
    きます。(ダブルクォートの文字列中では 2 重にエスケープする必要がある
    ことに注意してください)
    また、空白類に特殊な意味はなくなりました((({"\0"}))の効果は残っています)。
    1.6と同様の処理を期待する場合は、不要な空白は(({String#chomp}))などで
    適切に除去するか、(({gsub(/[ \t\n]/, "\0")}))で変換しておく必要が
    あります。

    ((<ruby 1.7 feature>)):
    省略可能な第二引数には ((<File/File.fnmatch>)) に指定できるフラグ
    と同様のフラグを指定できます。このフラグを指定することでマッチの挙
    動を変更することができます。

--- Dir.chdir([path])
--- Dir.chdir([path]) {|path| ... }  ((<ruby 1.7 feature>))

    カレントディレクトリを ((|path|)) に変更します。
    ((|path|)) を省略した場合、環境変数 (({HOME})) または (({LOGDIR})) 
    が設定されていればそのディレクトリに移動します。

    カレントディレクトリの変更に成功すれば 0 を返します。失敗した場合
    は例外 ((<Errno::EXXX>)) が発生します。

    ((<ruby 1.7 feature>)):
    ブロックが指定された場合、ディレクトリの変更はブロックの実行中に限
    られます。これは以下と等価です。

        savedir = Dir.pwd
        Dir.chdir(newdir)
        begin
          ...
        ensure
          Dir.chdir(savedir)
        end

    ブロックが指定されたときのこのメソッドの戻り値はブロックの実行結果
    です。

--- Dir.chroot(path)

    ルートディレクトリを ((|path|)) に変更します。
    ((<chroot(2)|manual page>)) を参照のこと。スーパーユーザだけがルー
    トディレクトリを変更できます。

    元のルートディレクトリに戻る方法はありません。

    ルートディレクトリの変更に成功すれば 0 を返します。失敗した場合は
    例外 ((<Errno::EXXX>)) が発生します。

--- Dir.delete(path)
--- Dir.rmdir(path)
--- Dir.unlink(path)

    ディレクトリを削除します。ディレクトリは空でなければいけませ
    ん。

    ディレクトリの削除に成功すれば 0 を返します。失敗した場合は例外 
    ((<Errno::EXXX>)) が発生します。

--- Dir.entries(path)

    ディレクトリ ((|path|)) に含まれるファイルエントリ名の
    配列を返します。以下と同じです。

        def dir_s_entries( path )
          Dir.open(path) {|d|
            return d.to_a
          }
        end

--- Dir.foreach(path) {|file| ...}

    ((|path|))のディレクトリの要素に対して繰り返すイテレー
    タ。このメソッドは以下と同じ働きをします。

      dir = Dir.open(path)
      begin
        dir.each {|file|
           ...
        }
      ensure
        dir.close
      end

    (({nil})) を返します。

--- Dir.getwd
--- Dir.pwd

    カレントディレクトリのフルパスを返します。

    カレントディレクトリの取得に失敗した場合は例外 ((<Errno::EXXX>)) 
    が発生します(が、普通は失敗することはありません)。

--- Dir.mkdir(path[, mode])

    ((|path|)) という新しいディレクトリを作ります。パーミッションは 
    ((|mode|)) で指定された値(デフォルトは 0777)に umask をかけた 
    ((({mode & ~umask}))) 値になります(((<mkdir(2)|manual page>))) を
    参照)。

    ディレクトリの作成に成功すれば 0 を返します。失敗した場合は例外 
    ((<Errno::EXXX>)) が発生します。

--- Dir.new(path)
--- Dir.open(path)
--- Dir.open(path) {|dir| ...}

    ((|path|))に対するディレクトリストリームをオープンして返します。
    オープンに失敗した場合は例外 ((<Errno::EXXX>)) が発生します。

    (({open()}))はブロックを指定することができます。
    ブロックを指定して呼び出した場合は、ディレクトリストリームを
    与えられてブロックが実行されます。ブロックの実行が終了すると、
    ディレクトリは自動的にクローズされます。

    ((<ruby 1.7 feature>)):
    ブロックが指定されたときのこのメソッドの戻り値はブロックの実行結果
    です。version 1.6 では (({nil})) 固定です。

== メソッド:

--- close

    ディレクトリストリームをクローズします。以降のディレクトリに
    対する操作は例外 ((<IOError>)) を発生させます。

    クローズに成功すれば (({nil})) を返します。失敗した場合は例外 
    ((<IOError>)) が発生します。

--- each {|item| ... }
    ディレクトリの各要素に対してブロックを評価します。
    (({self})) を返します。

--- path        ((<ruby 1.7 feature>))

    オープンしているディレクトリのパス名を文字列で返します。

--- pos
--- tell

    ディレクトリストリームの現在の位置を整数で返します。

        Dir.open("/tmp") {|d|
            d.each {|f|
              p d.pos
            }
        }

--- pos=(pos)
--- seek(pos)

    ディレクトリストリームの読み込み位置を ((|pos|)) に移動させます。
    ((|pos|))は((<Dir#tell|Dir/tell>)) で与えられた値でなければなりま
    せん。

    (({pos=})) は右辺を返します。(({seek})) は (({self})) を返します。

--- read

    ディレクトリストリームから次の要素を読み出して返します。最後の要素
    まで読み出していれば (({nil})) を返します。

    ディレクトリの読み出しに失敗した場合は例外 ((<Errno::EXXX>)) が発
    生します。

--- rewind

    ディレクトリストリームの読み込み位置を先頭に移動させます。
    (({self})) を返します。
