###nonref

= リテラル

  * ((<リテラル/数値リテラル>))
  * ((<リテラル/文字列リテラル>))
    * ((<リテラル/バックスラッシュ記法>))
    * ((<リテラル/式展開>))
  * ((<リテラル/コマンド出力>))
  * ((<リテラル/ヒアドキュメント (行指向文字列リテラル)>))
  * ((<リテラル/正規表現リテラル>))
  * ((<リテラル/配列式>))
  * ((<リテラル/ハッシュ式>))
  * ((<リテラル/範囲オブジェクト>))
  * ((<リテラル/シンボル>))
  * ((<リテラル/%記法>))

数字の1や文字列"hello world"のようにRubyのプログラムの中に直接
記述できる値の事をリテラルといいます。

== 数値リテラル

: (({123}))
: (({0d123}))           ((<ruby 1.7 feature>))

  整数
: (({-123}))

  符号つき整数 ((<trap::Numeric>))

: (({123.45}))

  浮動小数点数
  ((<ruby 1.8 feature>)):
  .1 など "." で始まる浮動小数点数は許されなくなりました。0.1 と書く必
  要があります。

: (({1.2e-3}))

  浮動小数点数
: (({0xffff}))

  16進整数
: (({0b1011}))

  2進整数
: (({0377}))
: (({0o377}))           ((<ruby 1.7 feature>))

  8進整数
: (({?a}))

  文字(({a}))のコード(97)

  ((<ruby 1.7 feature>)): 空白類を指定する場合は、?\s, ?\t などとする
  必要があります。

: (({?\C-a}))

  コントロール a のコード(1)
: (({?\M-a}))

  メタ a のコード(225)
: (({?\M-\C-a}))

  メタ-コントロール a のコード(129)

(({?})) 表現では全ての((<リテラル/バックスラッシュ記法>))が有効です。

文字コード以外の数値リテラルには、`(({_}))' を含めることができます。
ruby インタプリタは `(({_}))' を単に無視し、特別な解釈は何もしません。
これは、大きな数値の桁数がひと目でわかるように記述するのに便利です。
リテラルの最初と、最後には (({_})) を書くことはできません。(リテラルの
前(符号(+,-)の直後を含む)に (({_}))を置くとローカル変数やメソッド呼び
出しと解釈されます)
((-((<ruby 1.6 feature>)): 1.6.7 から (({_})) は、0x などの prefix の
直後にも書けなくなりました。また、(({_})) を連続して書いてもエラーにな
ります。他、細かい部分でこのあたりの規則は見直され統一されました-))

        1_000_000_000  => 1000000000
        0xffff_ffff  => 0xffffffff

== 文字列リテラル

例:

          "this is a string expression\n"
          'this is a string expression\n'
          %q!I said, "You said, 'She said it.'"!
          %!I said, "You said, 'She said it.'"!
          %Q('This is it.'\n)
          "this is multi line
          string"

文字列はダブルクォートまたはシングルクォートで囲まれています。
ダブルクォートで囲まれた文字列では((<リテラル/バックスラッシュ記法>))
と((<リテラル/式展開>))(後述)が有効になります。シングルクォートで囲ま
れた文字列では、(({\\}))(バックスラッシュそのもの)と
(({\'}))(シングルクォート)、行末の(({\}))(改行を無視します)
を除いて文字列の中身の解釈は行われません。
((-((<ruby 1.8 feature>)): 1.8.1(?) 以降ではシングルクォートで囲まれた文
字列では行末の\は \ そのものとして解釈されます。((<ruby-dev:21339>))-))

複数行にわたって書くこともできます。
この場合含まれる改行文字は常に(({\n}))になります。
実際のソースファイルの改行コードとは無関係です。

空白を間に挟んだ文字列リテラルは、コンパイル時に1つの文字列
リテラルと見倣されます。

          p "foo" "bar"
          => "foobar"

((<リテラル/%記法>)) による別形式の文字列表現もあります。

文字列式は評価されるたびに毎回新しい文字列オブジェクトを生成します。

=== バックスラッシュ記法

((-例えあなたが "\" がバックスラッシュに見えなかったとしてもこれはバックスラッ
シュ記法です;-)-))

: (({\t}))
  タブ(0x09)

: (({\n}))
  改行(0x0a)

: (({\r}))
  キャリッジリターン(0x0d)

: (({\f}))
  改ページ(0x0c)

: (({\b}))
  バックスペース (0x08)

: (({\a}))
  ベル (0x07)

: (({\e}))
  エスケープ (0x1b)

: (({\s}))
  空白 (0x20)

: (({\nnn}))
  8 進数表記 (n は 0-7)

: (({\xnn}))
  16 進数表記 (n は 0-9,a-f)

: (({\cx}))
: (({\C-x}))
  コントロール文字 (x は ASCII 文字)

: (({\M-x}))
  メタ x (c | 0x80)

: (({\M-\C-x}))
  メタ コントロール x

: (({\x}))
  文字 x そのもの

=== 式展開

例:
       ($ruby = "RUBY"の場合)

          "my name is #{$ruby}" #=> "my name is RUBY"
          'my name is #{$ruby}' #=> "my name is #{$ruby}"

ダブルクォート((({"})))で囲まれた文字列式、コマンド文
字列および正規表現の中では(({#{式}}))という形式で式
の内容(を文字列化したもの)を埋め込むことができます。式が変数
記号((({$})),(({@})))で始まる変数の場合には
(({{}}))を省略して、(({#変数名}))という形式で
も展開できます。文字(({#}))に続く文字が
(({{})),(({$})),(({@}))でなければ、その
まま文字(({#}))として解釈されます。明示的に式展開を止
めるには(({#}))の前にバックスラッシュを置きます。

式展開中の式は、ダブルクォートなども含めて Ruby の式をそのまま書くこと
ができます。コメントも許されます。

        p "#{ "string" # comment }"   # => "string"

((<ruby 1.7 feature>)): version 1.7 では、式展開中のコメントは、
(({#})) から (({}})) まででなく改行までです。上記の例は

        p "#{ "string" # comment
          }"                          # => "string"

と書く必要があります。

== コマンド出力

例:

          `date`
          %x{ date }

バッククォート((({`})))で囲まれた文字列は、ダブルクォー
トで囲まれた文字列と同様に((<リテラル/バックスラッシュ記法>))
の解釈と((<リテラル/式展開>))
が行なわれた後、コマンドとして実行され、その標準出力が文字列
として与えられます。コマンドは評価されるたびに実行されます。
コマンドの終了ステータスを得るには、((<組み込み変数/$?>)) を
参照します。

((<リテラル/%記法>)) による別形式のコマンド出力もあります。

== ヒアドキュメント (行指向文字列リテラル)

文法:

        <<[-]["'`]識別子["'`]
           ...
        識別子

普通の((<リテラル/文字列リテラル>))はデリミタ(", ', ` など)で囲まれた
文字列ですが、ヒアドキュメントは `<<識別子' を含む行の次の行から `識別
子' だけの行の直前までを文字列とする行指向のリテラルです。例えば、

        print <<EOS      # 識別子 EOS までがリテラルになる
          the string
          next line
        EOS

これは以下と同じです。

        print "  the string\n  next line\n"

ヒアドキュメントでは、開始ラベル `(({<<識別子}))' が文法要素としての式
にあたります。これは、開始ラベルを使ってヒアドキュメント全体を引数に渡
したりレシーバにしたりすることができるということを意味します。

        # 式の中に開始ラベルを書く
        # method の第二引数には "    ヒアドキュメント\n" が渡される
        method(arg1, <<LABEL, arg2)
            ヒアドキュメント
        LABEL

        # ヒアドキュメントをレシーバにメソッドを呼ぶ
        p  <<LABEL.upcase
        the lower case string
        LABEL

        # => "THE LOWER CASE STRING"

開始ラベルの次の行は常にヒアドキュメントとなります。例えば、以下のよう
な記述は文法エラーになります

        printf('%s%d',
               <<EOS,
               3055 * 2 / 5)   # <- この行はヒアドキュメントに含まれてしまう
        This line is a here document.
        EOS

開始ラベルを `(({<<-識別子}))' のように `(({-}))' を付けて書くことで終端
行をインデントすることができます。これ以外では、終端行に、余
分な空白やコメントさえも書くことはできません。

        if need_define_foo
          eval <<-EOS   # '<<-' を使うと……
            def foo
              print "foo\n"
            end
          EOS
          #↑終端行をインデントできます。
        end

一行に複数のヒアドキュメントを書くこともできます。

        print <<FIRST, <<SECOND
           これは一つめのヒアドキュメントです。
           まだ一つめです。
        FIRST
           この行からは二つめのヒアドキュメントです。
           この行で終わります。
        SECOND

開始ラベル `(({<<識別子}))' の `識別子' を(""、''、``)のいずれかで囲む
ことで、ヒアドキュメントとなる文字列リテラルの性質は対応する文字列リテ
ラルと同じ扱いになります((-ただし、文字列中に " や ' はバックスラッシュ
エスケープせずにそのまま書ける(エスケープする必要がない)。シングルクォー
トで囲ったヒアドキュメントの場合、' をエスケープする必要がないというこ
とは、\の特別扱いも必要ないということになる。つまり、シングルクォート
で囲ったヒアドキュメントは完全に書いたままの文字列になる-))。以下の例
を参照してください。`識別子' がクォートで囲まれていないときはダブルクォー
トでくくられているのと同じです。

        # バックスラッシュ記法、式展開が有効
        print <<"EOS"
        The price is #{$price}.
        EOS

        # 上のものと同じ結果
        print <<EOS
        The price is #{$price}.
        EOS

        # 式展開はできない
        print <<'EOS'
        The price is #{$price}.
        EOS

        # コマンドを実行
        print <<`EOC`
        date
        diff test.c.org test.c
        EOC

文字列リテラルのそれぞれの性質に関しては
((<リテラル/文字列リテラル>))、
((<リテラル/式展開>))、
((<リテラル/バックスラッシュ記法>))、
((<リテラル/コマンド出力>))
を参照してください。

== 正規表現リテラル

例:

          /^Ruby the OOPL/
          /Ruby/i
          /my name is #{myname}/o
          %r|Ruby|

(({/}))で囲まれた文字列は正規表現です。正規表現として解釈される
メタ文字については((<正規表現>))を参照してください。

終りの(({/}))の直後の文字は正規表現に対するオプションになります。
オプションの機能は以下の通りです。


: (({i}))

  正規表現はマッチ時に大文字小文字の区別を行わない

: (({o}))

  一番最初に正規表現の評価が行われた時に
  一度だけ((<リテラル/式展開>))を行う

: (({x}))

  正規表現中の空白(改行も含む)を無視する。また、バックスラッシュでエス
  ケープしない`(({#}))' から改行までをコメントとみなして無視する(ただ
  し、コメント中に (({/})) を含めると構文解析に失敗するので注意)
     /foo        # コメント
      bar/x
  これは (({/foobar/})) と同じ。

  空白を含めるには (({\ })) のようにエスケープします。

: (({m}))

  複数行モード。正規表現 "." が改行にもマッチするようになる

Ruby は日本語化されているので、((<組み込み変数/$KCODE>)) の値に従って正
規表現中の日本語文字を正しく扱います。(({$KCODE = "n"})) の場合、日本
語文字を一切認識せずにバイト列として扱います。これはデフォルトの動作で
す。

オプションとして (({n})), (({e})), (({s})), (({u})) のいずれかを指定す
ることで正規表現の文字コードを ((<組み込み変数/$KCODE>)) の値に関係なく
個々の正規表現リテラルに指定することもできます。

((<リテラル/%記法>)) による別形式の正規表現も指定できます。

正規表現の中では文字列と同じ((<リテラル/バックスラッシュ記法>))や
((<リテラル/式展開>))も有効です。

正規表現リテラルはその中に((<リテラル/式展開>))を含まなければ、何度評
価されても同一の正規表現オブジェクトを返します。
((<リテラル/式展開>))を含む場合は評価のたびに(式展開の結果を元に)正規
表現がコンパイルされ正規表現オブジェクトが生成されます(ただし上記の 
o オプションを指定すれば、同一の正規表現オブジェクトを返します)

== 配列式

例:

          [1, 2, 3]
          %w(a b c)
          %W(a b c)             ((<ruby 1.7 feature>))

文法:

          `[' 式`,' ... `]'

それぞれの式を評価した結果を含む配列を返します。
配列は((<Array>))クラスのインスタンスです。

要素が文字列リテラルの場合に限り、((<リテラル/%記法>)) による別形式の
配列表現も指定できます。

配列式は評価されるたびに毎回新しい配列オブジェクトを生成します。

== ハッシュ式

例:

          {1=>2, 2=>4, 3=>6}

文法:

          `{' 式 `=>' 式 `,' ... `}'
          `{' 式 `,' 式 `,' ... `}'

それぞれの式を評価した結果をキーと値とするハッシュオブジェク
トを返します。ハッシュとは任意のオブジェクトをキー(添字)として持
つ配列で、((<Hash>))クラスのインスタンスです。

メソッドの引数の末尾に要素が1つ以上のハッシュを渡す場合は、(({{})),
(({}}))を省略することができます。ただし、(({obj[...]}))  形式のメソッ
ド呼び出しと((<リテラル/配列式>))では、要素全体がハッシュの場合に限り、
(({{})), (({}}))を省略することができます。

例:

        method(1,2,3=>4)      # method(1,2,{3=>4})
        obj[1=>2,3=>4]        # obj[{1=>2,3=>4}]
        [1=>2,3=>4]           # [{1=>2, 3=>4}]

ハッシュ式は評価されるたびに毎回新しいハッシュオブジェクトを生成します。

== 範囲オブジェクト

((<演算子式/範囲式>))を参照

範囲式はその両端が数値リテラルであれば、何度評価されても同じオブジェク
トを返します。そうでなければ評価されるたびに新しい範囲オブジェクトを生
成します。

== シンボル

例:

    (シンボルの例)

          :class
          :lvar
          :method!
          :andthisis?
          :$gvar
          :@ivar
          :@@cvar
          :+

文法:

          `:' 識別子
          `:' 変数名
          `:' 演算子

((<Symbol>))クラスのインスタンス。
ある文字列と(({Symbol}))オブジェクトは一対一に対応します。

Symbol リテラルに指定できる演算子はメソッドとして再定義できる演算子だ
けです。((<演算子式>)) を参照して下さい。

((<ruby 1.7 feature>)):
1.7では以下の記法も使えます。
  p :'foo-bar' #=> :"foo-bar"
  p :"foo-bar" #=> :"foo-bar"
  p %s{foo-bar} #=> :"foo-bar"

この記法では、任意のシンボルを定義することができます(ただし、"\0" を含
めることはできません)。

(({:"..."})) の形式は、((<リテラル/バックスラッシュ記法>))や
((<リテラル/式展開>))が有効です。

シンボルは常に一意のオブジェクトで、(式展開を含んでいてもその結果が同
じ文字列であれば)何度評価されても同じオブジェクトを返します。

== %記法

((<リテラル/文字列リテラル>))、
((<リテラル/コマンド出力>))、
((<リテラル/正規表現リテラル>))、
((<リテラル/配列式>))、
((<リテラル/シンボル>))
では、(({%}))で始まる形式の記法を用いることができます。
文字列や正規表現では、`"', `/' など(通常のリテラルの区切り文字)を要素
に含めたい場合にバックスラッシュの数をコードから減らす効果があります。
また配列式では文字列の配列を簡単に表現できます。それぞれ以下のように対
応します。

  * (({%!STRING!}))  : ダブルクォート文字列
  * (({%Q!STRING!})) : 同上
  * (({%q!STRING!})) : シングルクォート文字列
  * (({%x!STRING!})) : コマンド出力
  * (({%r!STRING!})) : 正規表現
  * (({%w!STRING!})) : 要素が文字列の配列(空白区切り)
  * (({%W!STRING!})) : 要素が文字列の配列(空白区切り)。式展開、バックスラッシュ記法が有効(((<ruby 1.7 feature>)))
  * (({%s!STRING!})) : シンボル。式展開、バックスラッシュ記法は無効(((<ruby 1.7 feature>)))

(({!}))の部分には改行を含めた任意の非英数字を使うことができます。始ま
りの区切り文字が括弧(`(',`[',`{',`<')である時には、終りの区切り文字は
対応する括弧になります。括弧を区切り文字にした場合、対応が取れていれば
区切り文字と同じ括弧を要素に含めることができます。

            %(()) => "()"

配列式の%記法はシングルクォートで囲んだ文字列を空白文字で分割したのと
同じです。たとえば、

          %w(foo bar baz)

は(({['foo', 'bar', 'baz']}))と等価です。

バックスラッシュを使って空白を要素に含むこともできます。

          %w(foo\ bar baz)

          => ["foo bar", "baz"]

((<ruby 1.7 feature>)):
%W は、%w と同様ですが、ダブルクォートで囲んだ文字列のように、式展開、
バックスラッシュ記法が使用できます。空白による分割は式展開を評価する前
に行われます。

          v = "c d"
          %W(a\ b #{v}e\sf #{})

          => ["a b", "c de f", ""]
