= URI

Universal Resource Identifier support library for Ruby

== Ϣ RFC

    * ((<RFC:1738>)) Uniform Resource Locators (URL)
    * ((<RFC:1808>)) Relative Uniform Resource Locators
    * ((<RFC:2255>)) The LDAP URL Format
    * ((<RFC:2368>)) The mailto URL scheme
    * ((<RFC:2373>)) IP Version 6 Addressing Architecture
    * ((<RFC:2396>)) Uniform Resource Identifiers (URI): Generic Syntax
    * ((<RFC:2732>)) Format for Literal IPv6 Addresses in URL's

== 饹

  * ((<URI>)) Module

  * ((<URI/URI::Generic>)) Class
    * ((<URI/URI::FTP>)) Class
    * ((<URI/URI::HTTP>)) Class
      * ((<URI/URI::HTTPS>)) Class
    * ((<URI/URI::LDAP>)) Class
    * ((<URI/URI::MailTo>)) Class

=== 饹ѿ

--- @@schemes

    ⥸塼ؿ (({parse})) ˤäǽʥ饹ͤȤϥå塣
    ϥʸɽʸ
    (({URI::Generic}))ѾˤΥϥå˥ȥɲä
    Υ饹 (({URI::parse})) ˤäƥݡȤޤ

=== ⥸塼᥽å:

--- URI.split(url)

    URI ʲǤʬ䤷֤ޤ

      * scheme
      * userinfo
      * host
      * port
      * registry
      * path
      * opaque
      * query
      * fragment

    :
        require 'uri'
        p URI.split("http://www.ruby-lang.org/")
        # => ["http", nil, "www.ruby-lang.org", nil, nil, "/", nil, nil, nil]

--- URI.parse(uri_str)

    Ϳ줿 URI 鳺 URI ֥饹Υ󥹥󥹤
    ֤ޤ

        require 'uri'
        p uri = URI.parse("http://www.ruby-lang.org/")

        # => #<URI::HTTP:0x201002a6 URL:http://www.ruby-lang.org/>
        p uri.scheme    # => "http"
        p uri.host      # => "www.ruby-lang.org"
        p uri.port      # => 80
        p uri.path      # => "/"

--- URI.join(uri_str[, str, ...])

    ʸ ((|uri_str|))  ((|str|)) ... URIȤϢ뤷
    URI֥Ȥ֤ޤ

    ʲǤ

        URI.parse(uri_str) + str + ....
#    URI ХѥĤʤޤ((-餤 2002-09-24: ɽʤʡ-))

    

        require 'uri'
        p URI.join('http://www.ruby-lang.org/', '/ja/man-1.6/')
        => #<URI::HTTP:0x2010017a URL:http://www.ruby-lang.org/ja/man-1.6/>

--- URI.extract(str[, schemes])
--- URI.extract(str[, schemes]) {|uri_str| ... }

#    ʸ ((|str|))  URI(ʸ) Фơ֤ޤ
#    ֥åͿȤФURI(ʸ)Ȥ˥֥å¹Ԥ
#    ޤ

#     ((|schemes|)) Ϳϳ륹URI
#    Фޤ

    ʸ ((|str|)) Фƥѥޥå󥰤ߡ
    URI˥ޥåʬʸ󤫤ʤȤ֤ޤ
    Ф URI ʤ (({nil})) ֤ޤ

    2ʸ ((|schemes|)) Ϳ줿
    Υ򸡺ޤ

    ֥åͿ줿 (({String#scan})) Ʊͤǡ
    ޥåʬߤĤ뤿Ӥ ((|uri_str|)) 
    ʬƥ֥åɾޤ
    ΤȤͤ (({nil})) Ǥ

        # Ĥޤ󥵥ץ
        require 'uri'
        str = "
                http://www.ruby-lang.org/
                http://www.ruby-lang.org/man-1.6/
        "
        p URI.extract(str, %w(http))
        => ["http://www.ruby-lang.org/", "http://www.ruby-lang.org/man-1.6/"]

--- URI.regexp([match_schemes])

    (ruby 1.8.1 ʹߤΤ)

    URI˥ޥåɽ֤ޤ

     2 ʸ match_schemes Ϳϡ
    ʸǻꤵ륹 URI Τߤ˥ޥå
    ɽ֤ޤ

    ξ֤ͤɽɽ롼
    () ޤߤޤγ̤οϥСˤäư
    ǽΤǡ˰¸ɤ񤯤٤Ǥ
    ޤ

--- URI.escape(str[, unsafe])
--- URI.encode(str[, unsafe])

    URI ʸ򥨥󥳡ɤʸ֤ޤ((|unsafe|)) ˤϡURI 
    ȤƻǤʤʸɽʸǻꤷޤ(ǥեȤϡ
     URI::UNSAFE
        /[^-_.!~*'()a-zA-Z\d;\/?:@&=+$,\[\]]/n
    Ǥ)

        require 'uri'
        $KCODE = 'EUC'
        p URI.escape('http://www.ruby-lang.org/ja/man-1.6/?cmd=view;name=Rubyե󥹥ޥ˥奢')

        => "http://www.ruby-lang.org/ja/man-1.6/?cmd=view;name=Ruby%A5%EA%A5%D5%A5%A1%A5%EC%A5%F3%A5%B9%A5%DE%A5%CB%A5%E5%A5%A2%A5%EB"

--- URI.unescape(str)
--- URI.decode(str)

    URI ʸǥɤʸ֤ޤ

        require 'uri'
        $KCODE = 'EUC'
        p URI.unescape('http://www.ruby-lang.org/ja/man-1.6/?cmd=view;name=Ruby%A5%EA%A5%D5%A5%A1%A5%EC%A5%F3%A5%B9%A5%DE%A5%CB%A5%E5%A5%A2%A5%EB')

        => "http://www.ruby-lang.org/ja/man-1.6/?cmd=view;name=Rubyե󥹥ޥ˥奢"


== URI::Generic

٤Ƥ URI 饹δ쥯饹Ǥ

=== 饹᥽å:

--- URI::Generic.default_port

    бǥեȤΥݡֹ֤ޤ

        require 'uri'
        p URI::Generic.default_port     # => nil
        p URI::HTTP.default_port        # => 80

--- URI::Generic.component

    URI ιǤ֤ޤ

        require 'uri'
        p URI::Generic.component
        p URI::MailTo.component

        # => [:scheme, :userinfo, :host, :port, :registry, :path, :opaque, :query, :fragment]
        # => [:scheme, :to, :headers]

--- URI::Generic.use_registry

#     registry դʤ true ֤ޤ(URI::Generic 
#    饹Ǥ false)
    (({registry})) Ѥ뤫ݤɽ͡
    ͤΤȤ(({new})) ˵Ǥʤ (({registry})) Ϳ
    㳰 (({URI::InvalidURIError})) ޤ

--- URI::Generic.build2(ary)
--- URI::Generic.build2(hash)

    URI::Generic.build ƱǤ㳰 URI::InvalidComponentError 
    ȯˡγǤ URI.escape ƺ build 
    ޤ

--- URI::Generic.build(ary)
--- URI::Generic.build(hash)

    Ϳ줿 URI Ǥ URI::Generic ֥Ȥޤ
    Ǥϡ
      [scheme, userinfo, host, port, registry, path, opaque, query, fragment]
    󤫥ϥåͿޤ

--- URI::Generic.new(scheme, userinfo, host, port, registry, path, opaque, query, fragment[, arg_check])

#    ŪʹǤ URI::Generic ֥Ȥޤbuild 
#    Ȱۤʤꡢ򸡺ޤ
    ưʬȤURI֥Ȥ֤ޤ

    (({use_registry})) ΤȤ(({new})) ˵Ǥʤ (({registry})) 
    Ϳ㳰 (({URI::InvalidURIError})) ޤ

    10((|arg_check|))ȤƿͿ줿ϡ
    ֤ͤ˳ư絬§Ŭ礷Ƥ뤫ݤ򸡺
    Ŭ礷ʤ㳰 (({URI::InvalidComponentError})) ޤ

=== ᥽å:

--- URI::Generic#default_port

    (({self.class.default_port})) Ǥ

--- URI::Generic#component

    (({self.class.component})) Ǥ

--- URI::Generic#scheme
--- URI::Generic#scheme=(v)
--- URI::Generic#userinfo
--- URI::Generic#userinfo=(v)
--- URI::Generic#user
--- URI::Generic#user=(v)
--- URI::Generic#password
--- URI::Generic#password=(v)
--- URI::Generic#host
--- URI::Generic#host=(v)
--- URI::Generic#port
--- URI::Generic#port=(v)
--- URI::Generic#registry
--- URI::Generic#registry=(v)
--- URI::Generic#path
--- URI::Generic#path=(v)
--- URI::Generic#query
--- URI::Generic#query=(v)
--- URI::Generic#opaque
--- URI::Generic#opaque=(v)
--- URI::Generic#fragment
--- URI::Generic#fragment=(v)

    ƹǤ°᥽åɤǤ°Ǥϡå
    ʰФ㳰 URI::InvalidComponentError ȯޤ
    ((-餤 2002-09-24: InvalidURIError 򵯤Τ⤢ΤϤ虜ȡ-))

--- URI::Generic#hierarchical?

    path ʤ鿿Ǥ

--- URI::Generic#absolute?

    scheme ʤ鿿Ǥ

--- URI::Generic#relative?

    scheme ʤ鿿Ǥ

--- URI::Generic#merge(rel)
--- URI::Generic#+(rel)

    (({rel})) Ϣ뤹롣
    (({rel})) ʸξ (({URI::parse(}))((|rel|))(({)})) ˤäơ
    URI ѴƤϢ뤹롣

        require 'uri'
        p URI.parse('http://www.ruby-lang.org/') + '/en/raa.html'
        => #<URI::HTTP:0x201001c0 URL:http://www.ruby-lang.org/en/raa.html>

--- URI::Generic#route_from(src)
--- URI::Generic#-(src)

    ((|src|))Хѥ֤ޤ

        require 'uri'
        p URI.parse('http://www.ruby-lang.org/en/raa.html') - 'http://www.ruby-lang.org/'
        => #<URI::Generic:0x20100256 URL:en/raa.html>

--- URI::Generic#route_to(dst)

    ((|dst|))ؤХѥ֤ޤ

        require 'uri'
        p URI.parse('http://www.ruby-lang.org/').route_to('http://www.ruby-lang.org/en/raa.html')

        => #<URI::Generic:0x20100198 URL:en/raa.html>

--- URI::Generic#normalize
--- URI::Generic#normalize!

    URI ֥Ȥ֤ޤۥ̾ʸˤpath 
    Ǥʤ '/' 򥻥åȤޤ

--- URI::Generic#to_s
--- URI::Generic#to_str

    URI ֤ޤ

--- URI::Generic#==(uri)

    ˻ꤷ URI (ʸޤURI֥)ȤΰȽԤ
    ޤURI Ӥޤ

--- URI::Generic#to_a
--- URI::Generic#to_ary

    URI ֥ȤιǤ֤ޤ

== URI::FTP

=== ѡ饹:

((<URI/URI::Generic>))

=== 饹᥽å:

--- URI::FTP.build(ary)
--- URI::FTP.build(hash)

    Ϳ줿 URI Ǥ URI::FTP ֥Ȥޤ
    Ǥϡ
      [userinfo, host, port, path, typecode]
    󤫥ϥåͿޤtypecode ϡ"a""i" 뤤 "d" Ǥ
    "a" ϥƥȡ"i" ϥХʥꡢ"d" ϥǥ쥯ȥɽޤ
    "a" ƥȤǡ"i" ХʥʤΤϡ줾Υǡפ
    FTPΥץȥ ASCII  IMAGE ȸƤФƤǤ

--- URI::FTP.new(scheme, userinfo, host, port, registry, path, opaque, query, fragment[, arg_check])

    ŪʹǤ URI::FTP ֥Ȥޤbuild
    Ȱۤʤꡢ򸡺ޤ

      require 'uri'
      p ftp = URI.parse("ftp://ftp.ruby-lang.org/pub/ruby/;type=d")
      p ftp.typecode
      => #<URI::FTP:0x2010029c URL:ftp://ftp.ruby-lang.org/pub/ruby/;type=d>
         "d"

--- URI::FTP#typecode
--- URI::FTP#typecode=(v)

    ƹǤ°᥽åɤǤ°Ǥϡå
    ʰФ㳰 URI::InvalidComponentError ȯޤ

== URI::HTTP
=== ѡ饹:

((<URI/URI::Generic>))

=== 饹᥽å:

--- URI::HTTP.build(ary)
--- URI::HTTP.build(hash)

    Ϳ줿 URI Ǥ URI::HTTP ֥Ȥޤ
    Ǥϡ
      [userinfo, host, port, path, query, fragment]
    󤫥ϥåͿޤ

--- URI::HTTP.new(scheme, userinfo, host, port, registry, path, opaque, query, fragment[, arg_check])

    ŪʹǤ URI::HTTP ֥Ȥޤbuild
    Ȱۤʤꡢ򸡺ޤ

=== ᥽å:

--- URI::HTTP#request_uri

    (({path + '?' + query})) ֤ޤ

== URI::HTTPS
=== ѡ饹:

((<URI/URI::HTTP>))

== URI::LDAP

LDAP URI SCHEMA (described in ((<RFC:2255>)))

  ldap://<host>/<dn>[?<attrs>[?<scope>[?<filter>[?<extensions>]]]]

=== ѡ饹:

((<URI/URI::Generic>))

=== 饹᥽å:

--- URI::LDAP.build(ary)
--- URI::LDAP.build(hash)

--- URI::LDAP.new(scheme, userinfo, host, port, registry, path, opaque, query, fragment[, arg_check])

=== ᥽å:

--- URI::LDAP#dn

--- URI::LDAP#dn=(v)

--- URI::LDAP#attributes

--- URI::LDAP#attributes=(v)

--- URI::LDAP#scope

--- URI::LDAP#scope=(v)

--- URI::LDAP#filter

--- URI::LDAP#filter=(v)

--- URI::LDAP#extensions

--- URI::LDAP#extensions=(v)

== URI::MailTo

((<RFC:2368>)), The mailto URL scheme

=== ѡ饹:

((<URI/URI::Generic>))

=== 饹᥽å:

--- URI::MailTo.build(ary)
--- URI::MailTo.build(hash)

    Ϳ줿 URI Ǥ URI::MailTo ֥Ȥޤ
    Ǥϡ
      [to, headers]
    󤫥ϥåͿޤheaders ϡʲΤ褦ʸ
    Ϳޤ

      "subject=subscribe&cc=addr"

      [["subject", "subscribe"], ["cc", "addr"]]

--- URI::MailTo.new(scheme, userinfo, host, port, registry, path, opaque, query, fragment[, arg_check])

    ŪʹǤ URI::MailTo ֥Ȥޤbuild 
    Ȱۤʤꡢ򸡺ޤ

=== ᥽å:

--- URI::MailTo#to
--- URI::MailTo#to=(v)
--- URI::MailTo#headers
--- URI::MailTo#headers=(v)

    ƹǤ°᥽åɤǤ°Ǥϡå
    ʰФ㳰 URI::InvalidComponentError ȯޤ

--- URI::MailTo#to_mailtext
--- URI::MailTo#to_rfc822text

    URI ֥Ȥ᡼ƥʸޤ

      require 'uri'
      p mailto = URI.parse("mailto:ruby-list@ruby-lang.org?subject=subscribe&cc=myaddr")
      print mailto.to_mailtext

      => #<URI::MailTo:0x20104a0e URL:mailto:ruby-list@ruby-lang.org?subject=subscribe&cc=myaddr>
         To: ruby-list@ruby-lang.org
         Subject: subscribe
         Cc: myaddr

== 㳰饹

* URI::Error
  * URI::InvalidURIError
  * URI::InvalidComponentError
  * URI::BadURIError

--- URI::Error

    ٤Ƥ URI 㳰饹δ쥯饹Ǥ

--- URI::InvalidURIError

     URI ꤷȤȯޤ

--- URI::InvalidComponentError

    ʹǤꤷȤȯޤ

--- URI::BadURIError

    URI ȤȤȤȯޤ
