= net/http.rb version 1.2.1

== Υ饤֥ˤĤ

ѥǡžץȥ HTTP 򰷤饤֥Ǥ
 [RFC2616] ((<URL:http://www.ietf.org/rfc/rfc2616.txt>)) 
𤤤Ƥޤ

== 

=== ֥ФɥȤ (GET)

    require 'net/http'
    Net::HTTP.start( 'some.www.server', 80 ) {|http|
      response , = http.get('/index.html')
      puts response.body
    }

ޤʲƱ̣û񤤤ΤǤ

    require 'net/http'
    Net::HTTP.get_print 'some.www.server', '/index.html'

=== եξ (POST)

    require 'net/http'
    Net::HTTP.start( 'some.www.server', 80 ) {|http|
      response , = http.post( '/cgi-bin/any.rhtml',
                              'querytype=subject&target=ruby' )
    }

=== ץͳΥ

Net::HTTP Υ饹᥽å Net::HTTP.Proxy ϡ˥ץͳ
³褦ư򤹤롢饹֤ޤΥ饹
Net::HTTP ѾƤΤ Net::HTTP Ʊ褦˻Ȥޤ

    require 'net/http'

    $proxy_addr = 'your.proxy.addr'
    $proxy_port = 8080
          :
    Net::HTTP::Proxy($proxy_addr, $proxy_port).start( 'some.www.server' ) {|http|
      # always connect to your.proxy.addr:8080
          :
    }

ޤ Net::HTTP.Proxy  nil  Net::HTTP Ȥ֤Τ
ΥɤΤ褦˽񤤤ƤХץʤξˤбǤޤ

=== 쥯Ȥб

    require 'net/http'
    Net::HTTP.version_1_1

    host = 'www.ruby-lang.org'
    path = '/'
    begin
      Net::HTTP.start( host, 80 ) {|http|
	response , = http.get(path)
        print response.body
      }
    rescue Net::ProtoRetriableError => err
      if m = %r<http://([^/]+)>.match( err.response['location'] ) then
	host = m[1].strip
	path = m.post_match
	retry
      end
    end

Ǥ URL ۥ̾ΤˤˡȤäƤޤ
 URI 饹ɸźդˤʤФäȴñˤʤϤǤ

=== Basic ǧ

    require 'net/http'

    Net::HTTP.start( 'auth.some.domain' ) {|http|
      response , = http.get( '/need-auth.cgi',
              'Authentication' => ["#{account}:#{password}"].pack('m').strip )
      print response.body
    }

С 1.2 (Ruby 1.7 ʹߤź) ǤϼΤ褦˽񤱤ޤ

    require 'net/http'

    req = Net::HTTP::Get.new('/need-auth.cgi')
    req.basic_auth 'account', 'password'
    Net::HTTP.start( 'auth.some.domain' ) {|http|
      response = http.request( req )
      print response.body
    }

== ͤؤѹȰܹ֤ˤĤ

Ruby 1.6 äƤΤ http.rb 1.1  1.7 ʹߤ 1.2 Ǥ
δ֤ǤϤʤ礭ͤѤޤ˻ͤѹ
ΤǤʤξμ¸ߤ뤳Ȥˤޤ

᥽å HTTP.version_1_2HTTP.version_1_1 Ƥ֤
ΤȤ Net::HTTP ֥ȤϤ줾
Сλͤư褦ˤʤޤʲϻǤ

    # example
    Net::HTTP.start {|http1| ...(http1 has 1.2 features)... }

    Net::HTTP.version_1_1
    Net::HTTP.start {|http2| ...(http2 has 1.1 features)... }

    Net::HTTP.version_1_2
    Net::HTTP.start {|http3| ...(http3 has 1.2 features)... }

εǽϥåɥդǤϤޤ

== class Net::HTTP

=== 饹᥽å

: new( address = 'localhost', port = 80, proxy_addr = nil, proxy_port = nil )
     HTTP ֥Ȥޤaddress  HTTP С FQDN ǡ
    port ³ݡֹǤΥ᥽åɤǤϤޤ³Ϥޤ

    proxy_addr Ϳȥץ𤷤³륪֥Ȥޤ

: start( address = 'localhost', port = 80, proxy_addr = nil, proxy_port = nil )
: start( address = 'localhost', port = 80, proxy_addr = nil, proxy_port = nil ) {|http| .... }
    ʲƱǤ

        Net::HTTP.new(address, port, proxy_addr, proxy_port).start(&block)

: get( address, path, port = 80 )
    ۥ address  port ֥ݡȤ³ path ɽ
    ƥƥʸ֤ޤ

: get_print( address, path, port = 80 )
    ۥ address  port ֥ݡȤ³ path ɽ
    ƥƥ$stdout  << ǽϤޤ

: Proxy( address, port = 80 )
    ˻ꤵ줿ץ³륯饹֤ޤ
    Υ饹 Net::HTTP ѾƤΤ Net::HTTP 
    Ʊ褦˻Ȥޤ

    address  nil ΤȤ Net::HTTP 饹򤽤Τޤ֤ޤ

        # example
        proxy_class = Net::HTTP::Proxy( 'proxy.foo.org', 8080 )
          :
        proxy_class.start( 'www.ruby-lang.org' ) do |http|
          # connecting proxy.foo.org:8080
          :
        end

: proxy_class?
    Ȥ (Proxy ᥽åɤˤäƺ줿) ץѤΥ饹ʤп

: port
    HTTP Υǥեȥݡ (80)

=== ᥽å

: start
: start {|http| .... }
    TCP ͥĥꡢHTTP å򳫻Ϥޤ
    Ǥ˥å󤬳ϤƤ鲿⤻ false ֤ޤ

    ƥ졼ȤƸƤФ줿ϥ֥åδ֤å³
    ֥åλȤȤ˼ưŪ˥åĤޤ

: active?
    HTTP å󤬳ϤƤ鿿

: address
    ³륢ɥ쥹

: port
    ³ݡֹ

: open_timeout
: open_timeout=(n)
    ³ԤĺÿÿäƤ⥳ͥ
    ʤ㳰 TimeoutError ȯޤ

: read_timeout
: read_timeout=(n)
    ɤߤ (read(1) ) ǥ֥åƤ褤ÿ
    ÿäƤɤߤʤ㳰 TimeoutError ȯޤ

: finish
    HTTP åλޤå󳫻ˤΥ᥽åɤ
    ƤФ줿Ϥʤˤ⤻ false ֤ޤ

: proxy?
    ץ𤷤³ʤ鿿

: proxy_address
    ץͳ³ HTTP ֥ȤʤץΥɥ쥹
    Ǥʤʤ nil

: proxy_port
    ץͳ³ HTTP ֥ȤʤץΥݡȡ
    Ǥʤʤ nil

: get( path, header = nil, dest = '' )
: get( path, header = nil ) {|str| .... }
    о path ˤ륨ƥƥdest  << ᥽åɤ
    Ȥäƽ񤭤ߤޤޤ header  nil ǤʤХꥯȤ
    ȤˤƤ HTTP إåȤƽ񤭤ߤޤheader ϥϥåǡ
    ֥إå̾ => ơפΤ褦ʷǤʤФޤ

    ֤ͤϡС 1.1 Ǥ HTTPResponse  dest ǤǤ
    1.2 Ǥ HTTPResponse ҤȤĤΤߤǤ

    ƥ졼ȤƸƤФ줿ϥƥƥܥǥ򾯤Ťĥ֥å
    Ϳޤ

    1.1 Ǥ 3xx (ƻԲǽʥ顼)ФƤ㳰ȯޤξ
    HTTPResponse 㳰֥Ȥ err.response 뤳ȤǤޤ
     1.2 Ǥ㳰ȯޤ

        # version 1.1 (bundled with Ruby 1.6)
        response, body = http.get( '/index.html' )

        # version 1.2 (bundled with Ruby 1.7 or later)
        response = http.get( '/index.html' )

        # compatible in both version
        response , = http.get( '/index.html' )
        response.body
        
        # using block
        File.open( 'save.txt', 'w' ) {|f|
          http.get( '/~foo/', nil ) do |str|
            f.write str
          end
        }
        # same effect
        File.open( 'save.txt', 'w' ) {|f|
          http.get '/~foo/', nil, f
        }

: head( path, header = nil )
    о path ˤ륨ƥƥΥإåΤߤޤ
    ޤ header  nil ǤʤХꥯȤȤˤƤ
    HTTP إåȤƽ񤭤ߤޤheader ϥϥåǡ
    ֥إå̾ => ơפΤ褦ʷǤʤФޤ

    HTTPResponse ֥Ȥ֤ޤ

    1.1 Ǥ 3xx (ƻԲǽʥ顼)ФƤ㳰ȯޤξ
    HTTPResponse 㳰֥Ȥ err.response 뤳ȤǤޤ
     1.2 Ǥ㳰ȯޤ

        response = nil
        Net::HTTP.start( 'some.www.server', 80 ) {|http|
          response = http.head( '/index.html' )
        }
        response['content-length']   #-> '2554'
        response['content-type']     #-> 'text/html'
        response['Content-Type']     #-> 'text/html'
        response['CoNtEnT-tYpe']     #-> 'text/html'

: post( path, data, header = nil, dest = '' )
: post( path, data, header = nil ) {|str| .... }
    о path ˤ륨ƥƥФʸ data 
    ޤ쥹ݥ󥹤 << ᥽åɤȤä dest ˽
    ޤޤheader  get ᥽åɤƱǤ
    HTTPResponse ֥Ȥ dest ֤ޤ

    ƥ졼ȤƸƤӤ줿Ȥϥƥƥܥǥ򾯤Ť
    ֥åͿޤ

    1.1 Ǥ 3xx (ƻԲǽʥ顼)ФƤ㳰ȯޤξ
    HTTPResponse 㳰֥Ȥ err.response 뤳ȤǤޤ
     1.2 Ǥ㳰ȯޤ

        # version 1.1
        response, body = http.post( '/index.html', 'querytype=subject&target=ruby' )
        # version 1.2
        response = http.post( '/index.html', 'querytype=subject&target=ruby' )
        # compatible for both version
        response , = http.post( '/index.html', 'querytype=subject&target=ruby' )

        # using block
        File.open( 'save.html', 'w' ) {|f|
          http.post( '/index.html', 'querytype=subject&target=ruby' ) do |str|
            f.write str
          end
        }
        # same effect
        File.open( 'save.html', 'w' ) {|f|
          http.post '/index.html', 'querytype=subject&target=ruby', nil, f
        }

: request( request [, data] )
: request( request [, data] ) {|response| .... }
    ꥯȥ֥ request ޤPOST λ data 
    Ϳޤ(POST ʳ data Ϳ ArgumentError ȯޤ)

    ֥åȤȤ˸ƤӤ줿Ȥ³ݻޤ HTTPResponse
    ֥Ȥ֥åͿޤ

== class Net::HTTP::Get, Head, Post

HTTP ꥯȤݲ륯饹key Ϥ٤ʸʸ
̤ޤ

=== 饹᥽å

: new
    HTTP ꥯȥ֥Ȥޤ

=== ᥽å

: self[ key ]
    key إåեɤʸ
    key ʸʸ̤ޤ

: self[ key ] = val
    key إåեɤ val 򥻥åȤޤ
    key ʸʸ̤ޤ

: each {|name, val| .... }
    إå̾ȤͤФ뤯꤫إå̾Ͼʸ줵ޤ

: basic_auth( account, password )
    Authrization: إå basic auth Ѥ˥åȤޤ

: range
    Range: إåμϰϤ Range ֥Ȥ֤ޤ

: range = r
: set_range( i, len )
    ϰϤꤷƥƥƥ뤿Υإå Range: 򥻥åȤޤ
    r  Range ֥ȡi, len ϻĹǤ

: content_length
    Content-Length: إå ()

: content_range
    Content-Range: إå (Range)

== class Net::HTTPResponse

HTTP 쥹ݥ󥹤Υ饹Ǥ
إåե̾Ǥ硢ʸʸ̤ޤ

=== ᥽å

: self[ key ]
    key إåե(ʸ)ǤȤХ 'content-length'
    ФƤ '2048' Τ褦ʸޤ
    key ʸʸ̤ޤ

: self[ key ] = val
    key إåեɤ value ꤷޤ
    key ʸʸ̤ޤ

: key?( key )
    key Ȥإåեɤп
    key ʸʸ̤ޤ

: each {|name,value| .... }
    ٤ƤΥإåե̾ȤͤΥڥФ뤯꤫

: canonical_each {|name,value| .... }
    إåեɤ̾ȤͤΥڥФƷ֤ޤ

: code
    HTTP ΥꥶȥɤǤ㤨 '302' ʤɤǤ

: message
    HTTP Фꥶȥɤղä֤åǤ
    㤨 'Not Found' ʤɤǤ

: read_body( dest = '' )
    ƥƥܥǥ dest  << ᥽åɤȤäƽ񤭤ߤޤ
    Ʊ HTTPResponse ֥ȤФʾƤФ줿硢
    ܤϤʤˤ⤻˰ܤ֤ͤ򤽤Τޤ֤ޤ

: read_body {|str| .... }
    ƥƥܥǥ򾯤Ťļƽ缡֥åͿޤ

: body
    ƥƥܥǥǤread_body ƤǤФΰ dest
    ƤǤʤХƥƥܥǥʸȤɤߤ֤ޤ
