#! /usr/bin/env ruby
=begin
= rmi2html.rb
format from rmi(RD Method Index) file to HTML
NOTE: experimental
=end

require "rd/rdvisitor"

# const
METACHAR = { "<" => "&lt;", ">" => "&gt;", "&" => "&amp;" }

# global var
$method_index = []

def kind_comp(i, j)
  kind2num(i) <=> kind2num(j)
end

def kind2num(str)
  case str
  when '::'
    0
  when '.'
    1
  when '#'
    2
  end
end

def meta_char_escape(str)
  str.gsub(/[<>&]/) {
    METACHAR[$&]
  }
end

    
ARGV.each do |i|
  load i
end

$method_index.sort! do |i, j|
  (i[0] <=> j[0]).nonzero? || kind_comp(i[1], j[1]).nonzero? || i[2] <=> j[2]
end

STDOUT << <<"EOS"
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<HTML>
<HEAD>
<TITLE>Method Index --- #{ARGV[0]} </TITLE>
</HEAD>
<BODY>
<H1>Method Index -- #{ARGV[0]}</H1>
<HR>
<DL>
EOS

klass = ""

$method_index.each do |i|
  if i[0] == klass
    STDOUT << %Q[<LI><A HREF="#{i[3]}.html\##{i[4]}">#{i[0]+i[1]+meta_char_escape(i[2])}</A>\n]
  else
    klass = i[0]
    STDOUT << "</UL></DD>\n"
    STDOUT << "<DT>#{klass}\n"
    STDOUT << "<DD><UL>\n"
    STDOUT << %Q[<LI><A HREF="#{i[3]}.html\##{i[4]}">#{i[0]+i[1]+meta_char_escape(i[2])}</A>\n]
  end
end

STDOUT << "</DD>\n</DL>\n</BODY>\n</HTML>\n"
