require "test/unit/testcase"

require 'rexml/pullparser'

class PullParserTester < Test::Unit::TestCase
	include REXML
	def test_basics
		source = '<?xml version="1.0"?>
		<!DOCTYPE blah>
		<a>foo &lt;<b attribute="value">bar</b> nooo</a>'
		parser = PullParser.new(source)
		res = { :text=>0 }
		until parser.empty?
			results = parser.next
			res[ :xmldecl ] = true if results.xmldecl?
			res[ :doctype ] = true if results.doctype?
			res[ :a ] = true if results.start_element? and results[0] == 'a'
			if results.start_element? and results[0] == 'b'
				res[ :b ] = true
				assert_equal 'value', results[1]['attribute']
			end
			res[ :text ] += 1 if results.text?
		end
		[ :xmldecl, :doctype, :a, :b ].each { |tag| 
			assert res[tag] , "#{tag} wasn't processed"
		}
		assert_equal 3, res[ :text ]	
	rescue ParseException 
		puts $!
	end

	def test_bad_document
		source = "<a><b></a>"
		parser = PullParser.new(source)
		assert_raises(ParseException, "Parsing should have failed") { 
			results = parser.next while parser.has_next? 
		}
	end

	def test_entity_replacement
		source = '<!DOCTYPE foo [
		<!ENTITY la "1234">
		<!ENTITY lala "--&la;--">
		<!ENTITY lalal "&la;&la;">
		]><a><la>&la;</la><lala>&lala;</lala></a>'
		pp = PullParser.new( source )
		el_name = ''
		while pp.has_next?
			event = pp.next
			case event.event_type
			when :start_element
				el_name = event[0]
			when :text
				case el_name
				when 'la'
					assert_equal '1234', event[1]
				when 'lala'
					assert_equal '--1234--', event[1]
				end
			end
		end
	end

	def test_peek_unshift
		source = "<a><b/></a>"
		pp = PullParser.new(source)
		# FINISH ME!
	end
end
