require "misen/expand"
require "misen/parse"
require "misen/style"

module Misen
  class << self
    def expand_text(style, source, data)
      parser = Misen.new_parser(style)
      parsed = parser.parse_text(source)
      Misen.expand_nodes(parsed, data)
    end

    def expand_sgml(sgml, data)
      expand_text(Misen::STYLE_SGML, sgml, data)
    end
  end #/<< self
end #/Misen
