require "dpklib/interop"

module Dpklib
  WebUtils = Object.new
  class << WebUtils
    def cgi_normalize_newline(string)
      Dpklib.normalize_string_newline(string)
    end

    def cgi_normalize_encoding(string)
      Dpklib.normalize_string_encoding(string)
    end

    def escape_html(string)
      string = string.dup
      string.gsub!('&', '&amp;')
      string.gsub!('<', '&lt;')
      string.gsub!('>', '&gt;')
      string.gsub!('"', '&quot;')
      string
    end

    def encode_url(string)
      string.gsub(/([^ a-zA-Z0-9_.-]+)/n) do
	'%' + $1.unpack('H2' * $1.size).join('%').upcase
      end.tr(' ', '+')
    end
    alias string_to_url encode_url

    def decode_url(string)
      string.tr('+', ' ').gsub(/((?:%[0-9a-fA-F]{2})+)/n) do
        [$1.delete('%')].pack('H*')
      end
    end

    def query_string(hash)
      query_strings = []

      make_query_strings = proc { |param_hash, prefix|
	ary = prefix + [nil]
	param_hash.each do |param, value|
	  next unless value
	  ary[-1] = string_to_url(param.to_s)

	  if value.kind_of?(Hash) then
	    make_query_strings[value, ary]
	  else
	    param = ary.join(".")
            param = string_to_url(param)
	    value = string_to_url(value.to_s)
	    query_strings << "#{param}=#{value}"
	  end
	end
      }
      make_query_strings[hash, []]
      query_strings.join("&")
    end

    def parameterize_url(url, hash)
      qstr = query_string(hash)
      url = url.clone
      unless qstr.empty? then
	if url.include?("?") then
	  url << "&"
	else
	  url << "?"
	end
	url << qstr
      end
      url
    end

  end #/WebUtils
end #/Dpklib
