require 'dpklib/dpkstd'

module Dpklib
  class Supervisor
    NoProcedureGivenError = Class.new(ArgumentError)

    attr_accessor(:thread,
                  :restart_on_abort,
                  :restart_on_quit,
                  :restart_interval,
                  :stacktrace_on_abort,
                  :name,
                  :verbose,
                  :procedure)

    def initialize(name = "unnamed", &procedure)
      @restart_on_abort = false
      @restart_on_quit = false
      @restart_interval = 60
      @stacktrace_on_abort = false
      @name = name
      @verbose = false
      @procedure = procedure
      init
    end

    def init

    end

    def respawn=(bool)
      @restart_on_quit = @restart_on_abort = bool
    end

    def start(name = nil, &procedure)
      name && @name = name
      procedure && @procedure = procedure

      @procedure || raise(NoProcedureGivenError)
      status = nil
      while true do
        begin
          logv "START"
          @procedure.call
          logv "END"
          status = true
        rescue Exception
          logv "ABORT"
          @stacktrace_on_abort && log(Dpklib.stacktrace_message)
          status = false
        end
        @restart_on_abort || (status || break)
        @restart_on_quit || (status && break)
        logv "RESPAWN (#{@restart_interval} sec later)"
        (@restart_interval > 0) && sleep(@restart_interval)
      end
      status
    end

    def start_thread(*args, &block)
      Thread.start do
        start(*args, &block)
      end
    end

    def logv(msg)
      @verbose && log(msg)
    end

    def log(msg)
      STDERR.puts("supervise(#{name}): #{msg}")
      STDERR.flush
    end
  end #/Supervisor

  class VerboseSupervisor < Supervisor
    def init
      super
      self.stacktrace_on_abort = true
      self.verbose = true
    end
  end #/VerboseSupervisor

end #/Dpklib
