module Dpklib
  class MethodCallChain
    class ModuleAndMethod < Struct.new(:mod, :method_name)
      def to_s
        "#{mod}##{method_name}"
      end
    end #/ModuleAndMethod
    
    attr_reader :module_and_methods, :method_name
    def initialize(instance, method_name)
      @method_name = method_name.to_s
      @module_and_methods = []

      singleton = find_singleton_method(instance, @method_name)
      singleton && (@module_and_methods << singleton)
      instance.type.ancestors.each do |mod|
        mam = find_module_method(mod, @method_name)
        mam && (@module_and_methods << mam)
      end
    end

    def to_s
      mod_and_mets = module_and_methods.collect { |mod_and_met|
        mod_and_met.to_s
      }
      if mod_and_mets.empty? then
        "UNDEFINED: #{@method_name}"
      else
        mod_and_mets.join(" => ")
      end
    end
    alias inspect to_s

    protected
    def find_singleton_method(instance, method_name)
      find_method(instance.inspect, method_name,
                  instance.singleton_methods)
    end
    
    def find_module_method(mod, method_name)
      defined_methods = []
      defined_methods.concat mod.public_instance_methods
      defined_methods.concat mod.protected_instance_methods
      
      find_method(mod, method_name, defined_methods)
    end

    def find_method(mod, name_to_find, method_names)
      found = method_names.find { |mname|
        name_to_find == mname
      }
      found && ModuleAndMethod.new(mod, found)
    end

  end #/MethodCallOrder
end #/Dpklib

class << Dpklib
  def inspect_array(enum)
    lines = []
    enum.each_with_index do |obj, idx|
      lines << "#{idx}: #{obj.inspect}"
    end
    lines.join("\n")
  end

  def inspect_hash(hash, key_align = 20)
    str = ""
    format = "%-#{key_align}s%s\n"
    hash.each { |key, value|
      str << sprintf(format, key.inspect, value.inspect)
    }
    str
  end
end #/<< Dpklib
