
module Dpklib
  module InstallClassModule
    def append_features(klass)
      super
      klass.extend(class_module_to_append)
    end
  end #/InstallClassModule
end #/Dpklib

class << Dpklib
  def install_class_module(yourself, classmod = nil, &defination)
    unless classmod
      classmod = Module.new
      classmod.module_eval(&defination)
    end
    
    appendmod = Module.new
    appendmod.module_eval do
      include Dpklib::InstallClassModule
      define_method(:class_module_to_append) do
        classmod
      end
    end
    yourself.extend appendmod
    yourself.const_set(:ClassModule, classmod)
    classmod
  end

  # NOTE: install_singleton_new is deprecated because it prevents
  # subclass's new method.

  def install_singleton_instance(klass, instance = nil, &block)
    if instance
      install_singleton_method(klass, :instance) {
        instance
      }
    else
      block ||= proc {
        klass.new
      }
      class << klass
        def instance
          @instance ? @instance : (@instance = instance_new)
        end
      end
      install_singleton_method(klass, :instance_new, &block)
    end
    nil
  end

  def install_singleton_method(object, name, &block)
    defmethod = class << object
                  method(:define_method)
                end
    defmethod.call(name, &block)
    nil
  end
end #/<< Dpklib

module Dpklib
  module EachargMethod
    Dpklib.install_class_module(self) do
      def eacharg_method(name)
        orig_name = "__dpkeach_#{name}"
        module_eval(<<-EOF, __FILE__, __LINE__ + 1)
        alias #{orig_name} #{name}
        def #{name}(*args, &block)
          for arg in args
            #{orig_name}(arg, &block)
          end
          nil
        end
        EOF
      end
      extend self
      eacharg_method :eacharg_method
    end #/install_class_module
  end #/EachargMethod

  module OnceMethod
    Dpklib.install_class_module(self) do
      include Dpklib::EachargMethod
      def once_method(name)
        varname = "@__dpkonce_#{name}"
        orig_name = "__dpkonce_#{name}"
        module_eval(<<-EOF, __FILE__, __LINE__ + 1)
        alias #{orig_name} #{name}
        def #{name}(*args, &block)
          (#{varname} ||= [#{orig_name}(*args, &block)])[0]
        end
        EOF
      end
      eacharg_method :once_method
    end #/install_class_module
  end #/OnceMethod

  module AliasAccessor
    Dpklib.install_class_module(self) do
      def alias_accessor(newname, oldname)
        alias_method_if_defined(newname, oldname)
        alias_method_if_defined("#{newname}=", "#{oldname}=")
        nil
      end

      private
      def alias_method_if_defined(newname, oldname)
        if method_defined?(oldname)
          alias_method(newname, oldname)
        end
      end
    end #/install_class_module
  end #/AliasAccessor

  module BacktraceRewriteMethod
    Dpklib.install_class_module(self) do
      def backtrace_rewrite_method(error_class, name)
        orig_name = "__dpkbtrw_#{name}"
        errclass_const_name = "DPKBTRW_ERRCLASS_#{name}"
        const_set(errclass_const_name, error_class)
        module_eval(<<-EOF, __FILE__, __LINE__ + 1)
        alias #{orig_name} #{name}
        def #{name}(*args, &block)
          begin
            #{orig_name}(*args, &block)
          rescue #{errclass_const_name}
            $!.set_backtrace(caller)
            raise
          end
        end
        EOF
        nil
      end
    end #/install_class_module
  end #/BacktraceRewriteMethod

  AbstractMethodCalledError = Class.new(Exception)
  module AbstractMethod
    Dpklib.install_class_module(self) do
      include Dpklib::EachargMethod
      
      def abstract_method(name)
        module_eval(<<-EOF, __FILE__, __LINE__ + 1)
        def #{name}(*args, &block)
          raise(Dpklib::AbstractMethodCalledError,
                "#{self}##{name} must be written at subclass.")
        end
        EOF
        
        include Dpklib::BacktraceRewriteMethod
        backtrace_rewrite_method(Dpklib::AbstractMethodCalledError, name)
      end
      eacharg_method :abstract_method
    end #/install_class_module
  end #/AbstractMethod

  class << self
    include Dpklib::BacktraceRewriteMethod
    def implemented_by_subclass
      raise(Dpklib::AbstractMethodCalledError,
            "This method must be implemented by subclass.")
    end
    backtrace_rewrite_method(Dpklib::AbstractMethodCalledError,
                             :implemented_by_subclass)
  end #/<< self
end #/Dpklib
