require 'rubyunit'

require 'dpklib/monthday'

class TESTCASE_MonthDay < RUNIT::TestCase
  def test_it
    monthday = Dpklib::MonthDay[1, 3]
    assert_equals 1, monthday.month
    assert_equals 3, monthday.day
  end

  def test_compare
    lhs = Dpklib::MonthDay[4, 1]
    
    rhs = Dpklib::MonthDay[4, 1]
    assert (lhs == rhs)
    assert (lhs === rhs)
    date = rhs.to_date(2002)
    assert (lhs === date)

    rhs = Dpklib::MonthDay[5, 7]
    assert (lhs < rhs)
    date = rhs.to_date(2002)
    assert (lhs < date)

    rhs = Dpklib::MonthDay[3, 15]
    assert (lhs > rhs)
    date = rhs.to_date(2002)
    assert (lhs > date)

    another = Object.new
    assert (lhs != another)

  end

  def test_parse
    monthday = Dpklib::MonthDay.parse("1/2")
    assert_equals Dpklib::MonthDay[1, 2], monthday

    assert_parse_error ""
    assert_parse_error "11"
    assert_parse_error "A/B"
    assert_parse_error "/"
    assert_parse_error "1/2/3"
  end

  def assert_parse_error(str)
    assert_exception(Dpklib::MonthDay::ParseError) do
      Dpklib::MonthDay.parse(str)
    end
  end

end #/TESTCASE_MonthDay

