require 'rubyunit'

require 'dpklib/dpkstd'

class TESTCASE_LocalLoad < RUNIT::TestCase
  def test_require
    Dpklib.local_require(__FILE__, 'test')
    assert_not_nil defined?("LOCALLOAD_SUCCEED")
  end

  def test_path
    localdir = Dpklib.local_dir(__FILE__)
    testrb_path = File.expand_path("test.rb", localdir)
    assert File.exist?( testrb_path )
    assert_equals testrb_path, Dpklib.local_file("test.rb", __FILE__)    
  end

#   def test_it
#     Dpklib.local_load(__FILE__) { |localdir|
#       require 'test'
#       assert_not_nil defined?("LOCALLOAD_SUCCEED")
#
#       testrb_path = File.expand_path("test.rb", localdir)
#       assert File.exist?( testrb_path )
#       assert_equals testrb_path, Dpklib.local_file("test.rb", __FILE__)
#     }
#   end
end

class TESTCASE_DpkStd < RUNIT::TestCase
  def test_decimal_integer
    assert_equals 8543, Dpklib.decimal_integer("08543")
    assert_equals 22, Dpklib.decimal_integer("+22")
    assert_equals -69, Dpklib.decimal_integer("-69")
    assert_exception(ArgumentError) do
      Dpklib.decimal_integer(nil)
    end
    assert_exception(ArgumentError) do
      Dpklib.decimal_integer("0x1f")
    end

  end

  def test_force_range
    assert_equals 0, Dpklib.force_range(-1, 0..2)
    assert_equals 0, Dpklib.force_range(0, 0..2)
    assert_equals 1, Dpklib.force_range(1, 0..2)
    assert_equals 2, Dpklib.force_range(2, 0..2)
    assert_equals 2, Dpklib.force_range(3, 0..2)
  end
end #/TESTCASE_DpkStd
