require 'rubyunit'
require 'date'
require 'dpklib/hour'

require 'dpklib/crontab'

class TESTCASE_CronTab < RUNIT::TestCase
  def test_include
    crontab = Dpklib::CronTab["* * * 1,3-4,5-7/2 *"]

    assert crontab === Time.local(2002, 01)
    assert !( crontab === Time.local(2002, 2) )
    assert crontab === Time.local(2002, 3)
    assert crontab === Time.local(2002, 4)
    assert crontab === Time.local(2002, 5)
    assert !( crontab === Time.local(2002, 6) )
    assert crontab === Time.local(2002, 7)
    assert !( crontab === Time.local(2002, 8) )
  end

  def test_include_date
    crontab = Dpklib::CronTab["* * * 1 sun-sat"]
    assert crontab === Date.new(2002, 1)
    assert !( crontab === Date.new(2002, 2) )
  end

  def test_include_hour
    crontab = Dpklib::CronTab["2 5 * * *"]
    assert crontab === Dpklib::Hour[5, 2]
    assert !( crontab === Dpklib::Hour[5, 3] )
  end

  def test_nexttime
    nowtime = Time.local(2002, 6, 17, 10, 30, 30)

    check = proc { |crontab_str, nexttime|
      crontab = Dpklib::CronTab[crontab_str]
      assert_equals nexttime, crontab.nexttime(nowtime)
    }

    check["0 * * * *", Time.local(2002,6,17,11,0,0)]
    check["* * 1 1 *", Time.local(2003,1,1,0,0,0)]
    check["* * * * *", Time.local(2002,6,17,10,31,0)]

    # this test is miraculously passed.
    # because NextSeeker#succ often give invalid date. 
    #  ( such mday=31 for every month )
    nowtime = Time.local(2002, 6, 30, 16, 0, 0)
    check["0 0 * * *", Time.local(2002,7,1,0,0,0)]

    # [todo] wday check
  end

end #/TESTCASE_CronTab

