require 'runit/testcase'
require 'runit/cui/testrunner'

require 'rbconfig.rb'

class TestTestFailure < RUNIT::TestCase
  ExpectResult = <<STR
F.E.F.
FAILURES!!!
Test Results:
 Run: 3/3(2 asserts) Failures: 2 Errors: 1
Failures: 2
except.rb:12:in `test_bar'(RaiseException): The condition is <nil:NilClass> (RUNIT::AssertionFailedError)
	from except.rb:20
except.rb:9:in `test_foo'(RaiseException): The condition is <false:FalseClass> (RUNIT::AssertionFailedError)
	from except.rb:20
Errors: 1
except.rb:6:in `check_baz'(RaiseException): StandardError (StandardError)
	from except.rb:15:in `test_baz'
	from except.rb:20
STR
  def test_except_result
    ruby =  Config::CONFIG["ruby_install_name"]
    Dir.chdir 'tests'
    result = `#{ruby} -I.. except.rb`
    Dir.chdir '..'
    i = 0
    result.each do |l|
      next if /^Time:/ =~ l
      assert_equal(ExpectResult.split(/\n/)[i], l.chomp)
      i += 1
    end
  end
end

if $0 == __FILE__
  if ARGV.size == 0
    suite = TestTestFailure.suite
  else
    suite = RUNIT::TestSuite.new
    ARGV.each do |testmethod|
      suite.add(TestTestFailure.new(testmethod))
    end
  end
  RUNIT::CUI::TestRunner.run(suite)
end
