require 'runit/testcase'
require 'runit/cui/testrunner'

require 'runit/testresult'

require 'dummytestcase'

class TestRUNIT__TestResult < RUNIT::TestCase

  def setup
    @result = RUNIT::TestResult.new
    @suite = DummyTestCaseNormal.suite
    @suite2 = DummyTestCaseFailure.suite
    @suite3 = DummyTestCaseError.suite
  end

  def test_error_size
    DummyTestCaseNormal.suite.run(@result)
    assert_equal(0, @result.error_size)
    DummyTestCaseWithError.suite.run(@result)
    assert_equal(1, @result.error_size)
    DummyTestCaseWithMultiError.suite.run(@result)
    assert_equal(4, @result.error_size)
  end

  def test_errors
    DummyTestCaseNormal.suite.run(@result)
    assert_equal(0, @result.errors.size)
  end

  def setup_failure
    @failcase = DummyTestCaseFailure.suite
    @mfailcase = DummyTestCaseWithMultiFailure.suite
  end

  def test_failure_size
    DummyTestCaseNormal.suite.run(@result)
    assert_equal(0, @result.failure_size)
    @failcase.run(@result)
    assert_equal(1, @result.failure_size)
    @mfailcase.run(@result)
    assert_equal(4, @result.failure_size)
  end

  def test_failures
    @suite.run(@result)
    assert_equal(0, @result.failures.size)
    @failcase.run(@result)
    assert_equal(1, @result.failures.size)
    @mfailcase.run(@result)
    assert_equal(4, @result.failures.size)
  end
  attach_setup :setup_failure, :test_failure_size, :test_failures

  def test_run_no_exception
    assert_no_exception {
      @suite3.run(@result)
    }
  end

  def test_run_asserts
    @suite.run(@result)
    assert_equal(2, @result.run_asserts)
  end

  def test_run_asserts2
    @suite2.run(@result)
    assert_equal(2, @result.run_asserts)
  end

  def test_run_tests
    assert_equal(0, @result.run_tests)
    @suite.run(@result)
    assert_equal(1, @result.run_tests)
    DummyTestCaseMultiTest.suite.run(@result) 
    assert_equal(4, @result.run_tests)
  end

  def test_succeed?
    @suite.run(@result)
    assert(@result.succeed?)
  end

  def test_update
#    assert(false, "untested")
  end

  def test_running_time
    tm = Time.now
    result = RUNIT::TestResult.new
    DummyTestCaseTestRunningTime.suite.run(result)
    assert_equal_float(1.0, result.running_time, 0.1)
    DummyTestCaseTestRunningTime.suite.run(result)
    assert_equal_float(2.0, result.running_time, 0.1)

    result = RUNIT::TestResult.new
    DummyTestCaseTestRunningTimeEmptyTest.suite.run(result)
    assert_equal(0, result.running_time)
  end
end

if $0 == __FILE__
  testrunner = RUNIT::CUI::TestRunner.new
  if ARGV.size == 0
    suite = TestRUNIT__TestResult.suite
  else
    suite = RUNIT::TestSuite.new
    ARGV.each do |testmethod|
      suite.add(TestRUNIT__TestResult.new(testmethod))
    end
  end
  testrunner.run(suite)
end
