=begin
= Ruby/JS Javascript engine for Ruby

This is Ruby Extension for Using NJS Javascript Interpreter ((<URL:http://www.bbassett.net/njs/>))

current Version(0.0.4) feature this:

  % ruby -rjs -e 'p JS::evaluate(%!true!)'
  true
  % ruby -rjs -e 'p JS::evaluate(%!Math.PI!)'
  3.141592654
  % ruby -rjs -e 'p JS::evaluate(%q!new Date().toString()!)'
  "Mon Feb 24 12:39:15 2003"
  % ruby -r./js -e \
     'js = JS.new;p js.eval("a = new Array(5); a.length;"); \
      p js.eval("a.toString()")'
  5
  "undefined,undefined,undefined,undefined,undefined"
  % ruby -r./js -e \
     'js = JS.new;p js.eval(%q!a = new Array("a","b","cc",new Array(1,2,3.1414));!)' 
  ["a", "b", "cc", [1, 2, 3.1414]]


I reference
* examples/simple.c
* w3m-js((<URL:http://abe.nwr.jp/w3m/w3m-js.html>))
* njsmodule ((<URL:http://www.itee.uq.edu.au/~leonard/personal/software/>))

== Install

Require NJS(tested 0.2.5). and
 % ruby extconf.rb
 % make
 % sudo make install

== Reference

=== JS class
==== Class Method:
--- JS.evaluate(code)
    eval Javascript code and return value.
    raise JSError exception when error.

--- JS.new()
    create Javascript Interpreter.
--- JS#eval(code)
    eval code and return value by Interpreter instance.
    raise JSError exception when error.

==== Constants:
--- JS::LIB_VERSION
    NJS's Version string return.

=== JSError class
--- sub class of StandardError.

== Copying

No warranties, GPL2 license. see js.c

== ChangeLog

Sat Mar 11 00:00:00 2003 
        * Version 0.0.4 release.
        * Add shim16to18.h
        * tested ruby-1.8.0-preview2
        * use SafeStringValue at rb_js_evalcode
        * rb_obj_taint() as result  at rb_js_evalcode

Sat Feb 29 00:00:00 2003 
        * Version 0.0.4rc.
        * rb_js_evaluate() change module_method to singleton_method
        * Add JS::new,JS#eval,rb_js_evalcode()
        * Add rb_js_convertvalue() recognize JS_TYPE_ARRAY
        * Add secure check in rb_js_evalcode() [$SAFE: 1]

Wed Feb 26 18:00:00 2003 
        * Version 0.0.3 released.
        * js.c(rb_js_evaluate): Add Check_Type()
        * README.rd.ja: rd2 strict.(thanx ZnZ.)
        * Add README.rd

Mon Feb 24 18:00:00 2003 
        * Version 0.0.2(RAA:ruby-js/[ruby-list:37169])
        * Add JS::evaluate
        * Add README.rd.ja

Sun Feb 23 18:00:00 2003 
        * Version 0.0.1(just start.)

TAMURA.Kenichi ((<tamura@ruby-lang.org|URL:mailto:tamura@ruby-lang.org>))
=end
