# -*- mode: makefile-gmake; indent-tabs-mode: t -*-

bin: $(PROGRAM) $(WPROGRAM)
lib: $(LIBRUBY)
dll: $(LIBRUBY_SO)

.SUFFIXES: .rbinc .rb .inc .h .c .y .i .$(ASMEXT) .$(DTRACE_EXT)

# V=0 quiet, V=1 verbose.  other values don't work.
V = 0
V0 = $(V:0=)
Q1 = $(V:1=)
Q = $(Q1:0=@)
ECHO0 = $(ECHO1:0=echo)
ECHO = @$(ECHO0)

mflags = $(MFLAGS)
gnumake_recursive =
enable_shared = $(ENABLE_SHARED:no=)

UNICODE_VERSION = 15.0.0
UNICODE_EMOJI_VERSION_0 = $(UNICODE_VERSION)///
UNICODE_EMOJI_VERSION_1 = $(UNICODE_EMOJI_VERSION_0:.0///=)
UNICODE_EMOJI_VERSION = $(UNICODE_EMOJI_VERSION_1:///=)
UNICODE_BETA = NO

### set the following environment variable or uncomment the line if
### the Unicode data files should be updated completely on every update ('make up',...).
# ALWAYS_UPDATE_UNICODE = yes
UNICODE_DATA_DIR = enc/unicode/data/$(UNICODE_VERSION)/ucd
UNICODE_SRC_DATA_DIR = $(srcdir)/$(UNICODE_DATA_DIR)
UNICODE_SRC_EMOJI_DATA_DIR = $(srcdir)/enc/unicode/data/emoji/$(UNICODE_EMOJI_VERSION)
UNICODE_HDR_DIR = $(srcdir)/enc/unicode/$(UNICODE_VERSION)
UNICODE_DATA_HEADERS = \
	$(UNICODE_HDR_DIR)/casefold.h \
	$(UNICODE_HDR_DIR)/name2ctype.h \
	$(empty)

RUBY_RELEASE_DATE = $(RUBY_RELEASE_YEAR)-$(RUBY_RELEASE_MONTH)-$(RUBY_RELEASE_DAY)
RUBYLIB       = $(PATH_SEPARATOR)
RUBYOPT       = -
RUN_OPTS      = --disable-gems

# GITPULLOPTIONS = --no-tags

INCFLAGS = -I. -I$(arch_hdrdir) -I$(hdrdir) -I$(srcdir) -I$(UNICODE_HDR_DIR)

GEM_HOME =
GEM_PATH =
GEM_VENDOR =

BENCHMARK_DRIVER_GIT_URL = https://github.com/benchmark-driver/benchmark-driver
BENCHMARK_DRIVER_GIT_REF = v0.16.0
SIMPLECOV_GIT_URL = https://github.com/colszowka/simplecov.git
SIMPLECOV_GIT_REF = v0.17.0
SIMPLECOV_HTML_GIT_URL = https://github.com/colszowka/simplecov-html.git
SIMPLECOV_HTML_GIT_REF = v0.10.2
DOCLIE_GIT_URL = https://github.com/ms-ati/docile.git
DOCLIE_GIT_REF = v1.3.2

STATIC_RUBY   = static-ruby

TIMESTAMPDIR  = $(EXTOUT)/.timestamp
RUBYCOMMONDIR = $(EXTOUT)/common
EXTCONF       = extconf.rb
LIBRUBY_EXTS  = ./.libruby-with-ext.time
REVISION_H    = ./.revision.time
PLATFORM_D    = $(TIMESTAMPDIR)/.$(PLATFORM_DIR).time
ENC_TRANS_D   = $(TIMESTAMPDIR)/.enc-trans.time
RDOC          = $(XRUBY) "$(srcdir)/libexec/rdoc" --root "$(srcdir)" --encoding=UTF-8 --all
RDOCOUT       = $(EXTOUT)/rdoc
HTMLOUT       = $(EXTOUT)/html
CAPIOUT       = doc/capi
INSTALL_DOC_OPTS = --rdoc-output="$(RDOCOUT)" --html-output="$(HTMLOUT)"
RDOC_GEN_OPTS = --page-dir "$(srcdir)/doc" --no-force-update \
	--title "Documentation for Ruby $(RUBY_API_VERSION)" \
	--main README.md

INITOBJS      = dmyext.$(OBJEXT) dmyenc.$(OBJEXT)
NORMALMAINOBJ = main.$(OBJEXT)
MAINOBJ       = $(NORMALMAINOBJ)
DLDOBJS	      = $(INITOBJS)
EXTSOLIBS     =
MINIOBJS      = $(ARCHMINIOBJS) miniinit.$(OBJEXT) dmyext.$(OBJEXT)
ENC_MK        = enc.mk
MAKE_ENC      = -f $(ENC_MK) V="$(V)" UNICODE_HDR_DIR="$(UNICODE_HDR_DIR)" \
		RUBY="$(BOOTSTRAPRUBY)" MINIRUBY="$(BOOTSTRAPRUBY)" $(mflags)

COMMONOBJS    = array.$(OBJEXT) \
		ast.$(OBJEXT) \
		bignum.$(OBJEXT) \
		class.$(OBJEXT) \
		compar.$(OBJEXT) \
		compile.$(OBJEXT) \
		complex.$(OBJEXT) \
		cont.$(OBJEXT) \
		debug.$(OBJEXT) \
		debug_counter.$(OBJEXT) \
		dir.$(OBJEXT) \
		dln_find.$(OBJEXT) \
		encoding.$(OBJEXT) \
		enum.$(OBJEXT) \
		enumerator.$(OBJEXT) \
		error.$(OBJEXT) \
		eval.$(OBJEXT) \
		file.$(OBJEXT) \
		gc.$(OBJEXT) \
		hash.$(OBJEXT) \
		inits.$(OBJEXT) \
		io.$(OBJEXT) \
		io_buffer.$(OBJEXT) \
		iseq.$(OBJEXT) \
		load.$(OBJEXT) \
		marshal.$(OBJEXT) \
		math.$(OBJEXT) \
		memory_view.$(OBJEXT) \
		mjit.$(OBJEXT) \
		mjit_c.$(OBJEXT) \
		node.$(OBJEXT) \
		numeric.$(OBJEXT) \
		object.$(OBJEXT) \
		pack.$(OBJEXT) \
		parse.$(OBJEXT) \
		proc.$(OBJEXT) \
		process.$(OBJEXT) \
		ractor.$(OBJEXT) \
		random.$(OBJEXT) \
		range.$(OBJEXT) \
		rational.$(OBJEXT) \
		re.$(OBJEXT) \
		regcomp.$(OBJEXT) \
		regenc.$(OBJEXT) \
		regerror.$(OBJEXT) \
		regexec.$(OBJEXT) \
		regparse.$(OBJEXT) \
		regsyntax.$(OBJEXT) \
		ruby.$(OBJEXT) \
		scheduler.$(OBJEXT) \
		shape.$(OBJEXT) \
		signal.$(OBJEXT) \
		sprintf.$(OBJEXT) \
		st.$(OBJEXT) \
		strftime.$(OBJEXT) \
		string.$(OBJEXT) \
		struct.$(OBJEXT) \
		symbol.$(OBJEXT) \
		thread.$(OBJEXT) \
		time.$(OBJEXT) \
		transcode.$(OBJEXT) \
		transient_heap.$(OBJEXT) \
		util.$(OBJEXT) \
		variable.$(OBJEXT) \
		version.$(OBJEXT) \
		vm.$(OBJEXT) \
		vm_backtrace.$(OBJEXT) \
		vm_dump.$(OBJEXT) \
		vm_sync.$(OBJEXT) \
		vm_trace.$(OBJEXT) \
		$(YJIT_OBJ) \
		$(COROUTINE_OBJ) \
		$(DTRACE_OBJ) \
		$(BUILTIN_ENCOBJS) \
		$(BUILTIN_TRANSOBJS) \
		$(MISSING)

EXPORTOBJS    = $(DLNOBJ) \
		localeinit.$(OBJEXT) \
		loadpath.$(OBJEXT) \
		$(COMMONOBJS)

OBJS          = $(EXPORTOBJS) builtin.$(OBJEXT)
ALLOBJS       = $(NORMALMAINOBJ) $(MINIOBJS) $(COMMONOBJS) $(INITOBJS)

GOLFOBJS      = goruby.$(OBJEXT)

DEFAULT_PRELUDES = $(GEM_PRELUDE)
PRELUDE_SCRIPTS = $(DEFAULT_PRELUDES)
GEM_PRELUDE   =
PRELUDES      = {$(srcdir)}miniprelude.c
GOLFPRELUDES  = {$(srcdir)}golf_prelude.c

SCRIPT_ARGS   =	--dest-dir="$(DESTDIR)" \
		--extout="$(EXTOUT)" \
		--ext-build-dir="./ext" \
		--mflags="$(MFLAGS)" \
		--make-flags="$(MAKEFLAGS)"
EXTMK_ARGS    =	$(SCRIPT_ARGS) --extension $(EXTS) --extstatic $(EXTSTATIC) \
		--make-flags="V=$(V) MINIRUBY='$(MINIRUBY)'" \
		--gnumake=$(gnumake) --extflags="$(EXTLDFLAGS)" \
		--
INSTRUBY      =	$(SUDO) $(INSTRUBY_ENV) $(RUNRUBY) -r./$(arch)-fake $(tooldir)/rbinstall.rb
INSTRUBY_ARGS =	$(SCRIPT_ARGS) \
		--data-mode=$(INSTALL_DATA_MODE) \
		--prog-mode=$(INSTALL_PROG_MODE) \
		--installed-list $(INSTALLED_LIST) \
		--mantype="$(MANTYPE)" \
		$(INSTRUBY_OPTS)
INSTALL_PROG_MODE = 0755
INSTALL_DATA_MODE = 0644

BOOTSTRAPRUBY_COMMAND = $(BOOTSTRAPRUBY) $(BOOTSTRAPRUBY_OPT)
TESTSDIR      = $(srcdir)/test
TOOL_TESTSDIR = $(tooldir)/test
TEST_EXCLUDES = --excludes-dir=$(TESTSDIR)/excludes --name=!/memory_leak/
TESTWORKDIR   = testwork
TESTOPTS      = $(RUBY_TESTOPTS)

TESTRUN_SCRIPT = $(srcdir)/test.rb

COMPILE_PRELUDE = $(tooldir)/generic_erb.rb $(srcdir)/template/prelude.c.tmpl \
	$(tooldir)/ruby_vm/helpers/c_escape.rb

SHOWFLAGS = $(no_silence:no=showflags)

MAKE_LINK = $(MINIRUBY) -rfileutils -e "include FileUtils::Verbose" \
	  -e "src, dest = ARGV" \
	  -e "exit if File.identical?(src, dest) or cmp(src, dest) rescue nil" \
	  -e "def noraise; yield; rescue; rescue NotImplementedError; end" \
	  -e "noraise {ln_sf('../'*dest.count('/')+src, dest)} or" \
	  -e "noraise {ln(src, dest)} or" \
	  -e "cp(src, dest)"

# For release builds
YJIT_RUSTC_ARGS = --crate-name=yjit \
	--crate-type=staticlib \
	--edition=2021 \
	-C opt-level=3 \
	-C overflow-checks=on \
	'--out-dir=$(CARGO_TARGET_DIR)/release/' \
	$(top_srcdir)/yjit/src/lib.rs

all: $(SHOWFLAGS) main docs

main: $(SHOWFLAGS) exts $(ENCSTATIC:static=lib)encs
	@$(NULLCMD)

main: $(srcdir)/lib/mjit/instruction.rb
srcs: $(srcdir)/lib/mjit/instruction.rb
$(srcdir)/lib/mjit/instruction.rb: $(tooldir)/insns2vm.rb $(tooldir)/ruby_vm/views/lib/mjit/instruction.rb.erb $(srcdir)/insns.def
	$(ECHO) generating $@
	$(Q) $(BASERUBY) -Ku $(tooldir)/insns2vm.rb --basedir="$(srcdir)" $(INSNS2VMOPT) $@

mjit-headers: $(MJIT_SUPPORT)-mjit-headers
no-mjit-headers: PHONY
yes-mjit-headers: mjit_config.h PHONY

mjit.$(OBJEXT): mjit_config.h
mjit_config.h: Makefile

.PHONY: mjit-bindgen
mjit-bindgen:
	$(Q) $(BASERUBY) -rrubygems -C $(srcdir)/tool/mjit bindgen.rb $(CURDIR)

# These rules using MJIT_HEADER_SUFFIX must be in common.mk, not
# Makefile.in, in order to override the macro in defs/universal.mk.

# Other `-Dxxx`s preceding `-DMJIT_HEADER` will be removed in transform_mjit_header.rb.
# So `-DMJIT_HEADER` should be passed first when rb_mjit_header.h is generated.
$(TIMESTAMPDIR)/$(MJIT_HEADER:.h=)$(MJIT_HEADER_SUFFIX).time: probes.h vm.$(OBJEXT) \
		$(TIMESTAMPDIR)/$(arch)/.time $(tooldir)/mjit_tabs.rb $(PREP) $(RBCONFIG)
	$(ECHO) building $(@F:.time=.h)
	$(Q)$(MINIRUBY) $(tooldir)/mjit_tabs.rb "$(MJIT_TABS)" \
		$(CPP) -DMJIT_HEADER $(MJIT_HEADER_FLAGS) $(CFLAGS) $(XCFLAGS) $(CPPFLAGS) $(srcdir)/vm.c $(CPPOUTFLAG)$(@F:.time=.h).new
	$(Q) $(IFCHANGE) "--timestamp=$@" $(@F:.time=.h) $(@F:.time=.h).new

$(MJIT_HEADER:.h=)$(MJIT_HEADER_SUFFIX).h: $(TIMESTAMPDIR)/$(MJIT_HEADER:.h=)$(MJIT_HEADER_SUFFIX).time

$(MJIT_MIN_HEADER:.h=)$(MJIT_HEADER_SUFFIX).h: \
		$(TIMESTAMPDIR)/$(MJIT_HEADER:.h=)$(MJIT_HEADER_SUFFIX).time \
		$(tooldir)/transform_mjit_header.rb $(PREP) \
		$(MJIT_HEADER:.h=)$(MJIT_HEADER_SUFFIX).h
	$(ECHO) building $@
	$(Q)$(MINIRUBY) $(tooldir)/transform_mjit_header.rb "$(CC) $(CFLAGS) -w" $(MJIT_HEADER:.h=)$(MJIT_HEADER_ARCH).h $@
	$(Q) $(MAKEDIRS) $(MJIT_HEADER_INSTALL_DIR)
	$(Q) $(MAKE_LINK) $@ $(MJIT_HEADER_INSTALL_DIR)/$(@F)

.PHONY: showflags
exts enc trans: $(SHOWFLAGS)
showflags:
	$(MESSAGE_BEGIN) \
	"	BASERUBY = $(BASERUBY)" \
	"	CC = $(CC)" \
	"	LD = $(LD)" \
	"	LDSHARED = $(LDSHARED)" \
	"	CFLAGS = $(CFLAGS)" \
	"	XCFLAGS = $(XCFLAGS)" \
	"	CPPFLAGS = $(CPPFLAGS)" \
	"	DLDFLAGS = $(DLDFLAGS)" \
	"	SOLIBS = $(SOLIBS)" \
	"	LANG = $(LANG)" \
	"	LC_ALL = $(LC_ALL)" \
	"	LC_CTYPE = $(LC_CTYPE)" \
	"	MFLAGS = $(MFLAGS)" \
	"	RUSTC = $(RUSTC)" \
	"	YJIT_RUSTC_ARGS = $(YJIT_RUSTC_ARGS)" \
	$(MESSAGE_END)
	-@$(CC_VERSION)

.PHONY: showconfig
showconfig:
	@$(ECHO_BEGIN) \
	$(configure_args) \
	$(ECHO_END)

EXTS_NOTE = -f $(EXTS_MK) $(mflags) RUBY="$(MINIRUBY)" top_srcdir="$(srcdir)" note

exts: build-ext

EXTS_MK = exts.mk
$(EXTS_MK): ext/configure-ext.mk $(srcdir)/template/exts.mk.tmpl \
	    $(TIMESTAMPDIR)/$(arch)/.time $(TIMESTAMPDIR)/.RUBYCOMMONDIR.time
	$(Q)$(MAKE) -f ext/configure-ext.mk $(mflags) V=$(V) EXTSTATIC=$(EXTSTATIC) \
		gnumake=$(gnumake) MINIRUBY="$(MINIRUBY)" \
		EXTLDFLAGS="$(EXTLDFLAGS)" srcdir="$(srcdir)"
	$(ECHO) generating makefile $@
	$(Q)$(MINIRUBY) $(tooldir)/generic_erb.rb -o $@ -c \
	    $(srcdir)/template/exts.mk.tmpl --gnumake=$(gnumake) --configure-exts=ext/configure-ext.mk

ext/configure-ext.mk: $(PREP) all-incs $(MKFILES) $(RBCONFIG) $(LIBRUBY) \
		$(srcdir)/template/configure-ext.mk.tmpl
	$(ECHO) generating makefiles $@
	$(Q)$(MAKEDIRS) $(@D)
	$(Q)$(MINIRUBY) $(tooldir)/generic_erb.rb -o $@ -c \
	    $(srcdir)/template/$(@F).tmpl --srcdir="$(srcdir)" \
	    --miniruby="$(MINIRUBY)" --script-args='$(SCRIPT_ARGS)'

configure-ext: $(EXTS_MK)

build-ext: $(EXTS_MK)
	$(Q)$(MAKE) -f $(EXTS_MK) $(mflags) libdir="$(libdir)" LIBRUBY_EXTS=$(LIBRUBY_EXTS) \
	    EXTENCS="$(ENCOBJS)" MINIRUBY="$(MINIRUBY)" UPDATE_LIBRARIES=no $(EXTSTATIC)
	$(Q)$(MAKE) $(EXTS_NOTE)

exts-note: $(EXTS_MK)
	$(Q)$(MAKE) $(EXTS_NOTE)

ext/extinit.c: $(srcdir)/template/extinit.c.tmpl $(PREP)
	$(MAKEDIRS) $(@D)
	$(Q)$(MINIRUBY) $(tooldir)/generic_erb.rb -o $@ -c \
	    $(srcdir)/template/extinit.c.tmpl $(EXTINITS)

prog: program wprogram
programs: $(PROGRAM) $(WPROGRAM) $(arch)-fake.rb

$(PREP): $(MKFILES)

miniruby$(EXEEXT): config.status $(ALLOBJS) $(ARCHFILE)

objs: $(ALLOBJS)

GORUBY = go$(RUBY_INSTALL_NAME)
GOLF = $(GORUBY)
golf: $(GOLF)
$(GOLF): $(LIBRUBY) $(GOLFOBJS) PHONY
	$(Q) $(MAKE) $(mflags) \
		GOLF=_dummy_golf_target_to_avoid_conflict_just_in_case_ \
		MAINOBJ=goruby.$(OBJEXT) \
		PROGRAM=$(GORUBY)$(EXEEXT) \
		V=$(V) \
	program
capi: $(CAPIOUT)/.timestamp PHONY

$(CAPIOUT)/.timestamp: Doxyfile $(PREP)
	$(Q) $(MAKEDIRS) "$(@D)"
	$(ECHO) generating capi
	-$(Q) $(DOXYGEN) -b
	$(Q) $(MINIRUBY) -e 'File.open(ARGV[0], "w"){'"|f|"' f.puts(Time.now)}' "$@"

Doxyfile: $(srcdir)/template/Doxyfile.tmpl $(PREP) $(tooldir)/generic_erb.rb $(RBCONFIG)
	$(ECHO) generating $@
	$(Q) $(MINIRUBY) $(tooldir)/generic_erb.rb -o $@ $(srcdir)/template/Doxyfile.tmpl \
	--srcdir="$(srcdir)" --miniruby="$(MINIRUBY)"

program: $(SHOWFLAGS) $(PROGRAM)
wprogram: $(SHOWFLAGS) $(WPROGRAM)
mini: PHONY miniruby$(EXEEXT)

$(PROGRAM) $(WPROGRAM): $(LIBRUBY) $(MAINOBJ) $(OBJS) $(EXTOBJS) $(SETUP) $(PREP)

$(LIBRUBY_A):	$(LIBRUBY_A_OBJS) $(MAINOBJ) $(INITOBJS) $(ARCHFILE)

$(LIBRUBY_SO):	$(OBJS) $(DLDOBJS) $(LIBRUBY_A) $(PREP) $(BUILTIN_ENCOBJS)

$(LIBRUBY_EXTS):
	@$(NULLCMD) > $@

$(STATIC_RUBY)$(EXEEXT): $(MAINOBJ) $(DLDOBJS) $(EXTOBJS) $(LIBRUBY_A)
	$(Q)$(RM) $@
	$(PURIFY) $(CC) $(MAINOBJ) $(DLDOBJS) $(LIBRUBY_A) $(MAINLIBS) $(EXTLIBS) $(LIBS) $(OUTFLAG)$@ $(LDFLAGS) $(XLDFLAGS)

ruby.imp: $(COMMONOBJS)
	$(Q){ \
	$(NM) -Pgp $(COMMONOBJS) | \
	awk 'BEGIN{print "#!"}; $$2~/^[A-TV-Z]$$/&&$$1!~/^$(SYMBOL_PREFIX)(Init_|InitVM_|ruby_static_id_|.*_threadptr_|rb_ec_)|^\./{print $$1}'; \
	($(CHDIR) $(srcdir) && \
	 exec sed -n '/^MJIT_FUNC_EXPORTED/!d;N;s/.*\n\(rb_[a-zA-Z_0-9]*\).*/$(SYMBOL_PREFIX)\1/p' cont.c gc.c thread*c vm*.c) \
	} | \
	sort -u -o $@

install: install-$(INSTALLDOC)
docs: $(DOCTARGETS)
pkgconfig-data: $(ruby_pc)
$(ruby_pc): $(srcdir)/template/ruby.pc.in config.status

install-all: docs pre-install-all do-install-all post-install-all
pre-install-all:: all pre-install-local pre-install-ext pre-install-gem pre-install-doc
do-install-all: pre-install-all
	$(INSTRUBY) --make="$(MAKE)" $(INSTRUBY_ARGS) --install=all $(INSTALL_DOC_OPTS)
post-install-all:: post-install-local post-install-ext post-install-gem post-install-doc
	@$(NULLCMD)

install-nodoc: pre-install-nodoc do-install-nodoc post-install-nodoc
pre-install-nodoc:: pre-install-local pre-install-ext pre-install-gem
do-install-nodoc: main pre-install-nodoc
	$(INSTRUBY) --make="$(MAKE)" $(INSTRUBY_ARGS) --install=all --exclude=doc
post-install-nodoc:: post-install-local post-install-ext post-install-gem

install-local: pre-install-local do-install-local post-install-local
pre-install-local:: pre-install-bin pre-install-lib pre-install-man
do-install-local: $(PROGRAM) pre-install-local
	$(INSTRUBY) --make="$(MAKE)" $(INSTRUBY_ARGS) --install=local
post-install-local:: post-install-bin post-install-lib post-install-man

install-ext: pre-install-ext do-install-ext post-install-ext
pre-install-ext:: pre-install-ext-arch pre-install-ext-comm
do-install-ext: exts pre-install-ext
	$(INSTRUBY) --make="$(MAKE)" $(INSTRUBY_ARGS) --install=ext
post-install-ext:: post-install-ext-arch post-install-ext-comm

install-arch: pre-install-arch do-install-arch post-install-arch
pre-install-arch:: pre-install-bin pre-install-ext-arch
do-install-arch: main do-install-arch
	$(INSTRUBY) --make="$(MAKE)" $(INSTRUBY_ARGS) --install=arch
post-install-arch:: post-install-bin post-install-ext-arch

install-comm: pre-install-comm do-install-comm post-install-comm
pre-install-comm:: pre-install-lib pre-install-ext-comm pre-install-man
do-install-comm: $(PREP) pre-install-comm
	$(INSTRUBY) --make="$(MAKE)" $(INSTRUBY_ARGS) --install=lib --install=ext-comm --install=man
post-install-comm:: post-install-lib post-install-ext-comm post-install-man

install-bin: pre-install-bin do-install-bin post-install-bin
pre-install-bin:: install-prereq
do-install-bin: $(PROGRAM) pre-install-bin
	$(INSTRUBY) --make="$(MAKE)" $(INSTRUBY_ARGS) --install=bin
post-install-bin::
	@$(NULLCMD)

install-lib: pre-install-lib do-install-lib post-install-lib
pre-install-lib:: install-prereq
do-install-lib: $(PREP) pre-install-lib
	$(INSTRUBY) --make="$(MAKE)" $(INSTRUBY_ARGS) --install=lib
post-install-lib::
	@$(NULLCMD)

install-ext-comm: pre-install-ext-comm do-install-ext-comm post-install-ext-comm
pre-install-ext-comm:: install-prereq
do-install-ext-comm: exts pre-install-ext-comm
	$(INSTRUBY) --make="$(MAKE)" $(INSTRUBY_ARGS) --install=ext-comm
post-install-ext-comm::
	@$(NULLCMD)

install-ext-arch: pre-install-ext-arch do-install-ext-arch post-install-ext-arch
pre-install-ext-arch:: install-prereq
do-install-ext-arch: exts pre-install-ext-arch
	$(INSTRUBY) --make="$(MAKE)" $(INSTRUBY_ARGS) --install=ext-arch
post-install-ext-arch::
	@$(NULLCMD)

install-man: pre-install-man do-install-man post-install-man
pre-install-man:: install-prereq
do-install-man: $(PREP) pre-install-man
	$(INSTRUBY) --make="$(MAKE)" $(INSTRUBY_ARGS) --install=man
post-install-man::
	@$(NULLCMD)

install-capi: capi pre-install-capi do-install-capi post-install-capi
pre-install-capi:: install-prereq
do-install-capi: $(PREP) pre-install-capi
	$(INSTRUBY) --make="$(MAKE)" $(INSTRUBY_ARGS) --install=capi
post-install-capi::
	@$(NULLCMD)

what-where: no-install
no-install: no-install-$(INSTALLDOC)
what-where-all: no-install-all
no-install-all: pre-no-install-all dont-install-all post-no-install-all
pre-no-install-all:: pre-no-install-local pre-no-install-ext pre-no-install-doc
dont-install-all: $(PROGRAM)
	$(INSTRUBY) -n --make="$(MAKE)" $(INSTRUBY_ARGS) --install=all $(INSTALL_DOC_OPTS)
post-no-install-all:: post-no-install-local post-no-install-ext post-no-install-doc
	@$(NULLCMD)

uninstall: $(INSTALLED_LIST) sudo-precheck
	$(Q)$(SUDO) $(MINIRUBY) $(tooldir)/rbuninstall.rb --destdir=$(DESTDIR) $(INSTALLED_LIST)

reinstall: all uninstall install

what-where-nodoc: no-install-nodoc
no-install-nodoc: pre-no-install-nodoc dont-install-nodoc post-no-install-nodoc
pre-no-install-nodoc:: pre-no-install-local pre-no-install-ext
dont-install-nodoc:  $(PREP)
	$(INSTRUBY) -n --make="$(MAKE)" $(INSTRUBY_ARGS) --exclude=doc
post-no-install-nodoc:: post-no-install-local post-no-install-ext

what-where-local: no-install-local
no-install-local: pre-no-install-local dont-install-local post-no-install-local
pre-no-install-local:: pre-no-install-bin pre-no-install-lib pre-no-install-man
dont-install-local: $(PREP)
	$(INSTRUBY) -n --make="$(MAKE)" $(INSTRUBY_ARGS) --install=local
post-no-install-local:: post-no-install-bin post-no-install-lib post-no-install-man

what-where-ext: no-install-ext
no-install-ext: pre-no-install-ext dont-install-ext post-no-install-ext
pre-no-install-ext:: pre-no-install-ext-arch pre-no-install-ext-comm
dont-install-ext: $(PREP)
	$(INSTRUBY) -n --make="$(MAKE)" $(INSTRUBY_ARGS) --install=ext
post-no-install-ext:: post-no-install-ext-arch post-no-install-ext-comm

what-where-arch: no-install-arch
no-install-arch: pre-no-install-arch dont-install-arch post-no-install-arch
pre-no-install-arch:: pre-no-install-bin pre-no-install-ext-arch
dont-install-arch: $(PREP)
	$(INSTRUBY) -n --make="$(MAKE)" $(INSTRUBY_ARGS) --install=bin --install=ext-arch
post-no-install-arch:: post-no-install-lib post-no-install-man post-no-install-ext-arch

what-where-comm: no-install-comm
no-install-comm: pre-no-install-comm dont-install-comm post-no-install-comm
pre-no-install-comm:: pre-no-install-lib pre-no-install-ext-comm pre-no-install-man
dont-install-comm: $(PREP)
	$(INSTRUBY) -n --make="$(MAKE)" $(INSTRUBY_ARGS) --install=lib --install=ext-comm --install=man
post-no-install-comm:: post-no-install-lib post-no-install-ext-comm post-no-install-man

what-where-bin: no-install-bin
no-install-bin: pre-no-install-bin dont-install-bin post-no-install-bin
pre-no-install-bin:: install-prereq
dont-install-bin: $(PREP)
	$(INSTRUBY) -n --make="$(MAKE)" $(INSTRUBY_ARGS) --install=bin
post-no-install-bin::
	@$(NULLCMD)

what-where-lib: no-install-lib
no-install-lib: pre-no-install-lib dont-install-lib post-no-install-lib
pre-no-install-lib:: install-prereq
dont-install-lib: $(PREP)
	$(INSTRUBY) -n --make="$(MAKE)" $(INSTRUBY_ARGS) --install=lib
post-no-install-lib::
	@$(NULLCMD)

what-where-ext-comm: no-install-ext-comm
no-install-ext-comm: pre-no-install-ext-comm dont-install-ext-comm post-no-install-ext-comm
pre-no-install-ext-comm:: install-prereq
dont-install-ext-comm: $(PREP)
	$(INSTRUBY) -n --make="$(MAKE)" $(INSTRUBY_ARGS) --install=ext-comm
post-no-install-ext-comm::
	@$(NULLCMD)

what-where-ext-arch: no-install-ext-arch
no-install-ext-arch: pre-no-install-ext-arch dont-install-ext-arch post-no-install-ext-arch
pre-no-install-ext-arch:: install-prereq
dont-install-ext-arch: $(PREP)
	$(INSTRUBY) -n --make="$(MAKE)" $(INSTRUBY_ARGS) --install=ext-arch
post-no-install-ext-arch::
	@$(NULLCMD)

what-where-man: no-install-man
no-install-man: pre-no-install-man dont-install-man post-no-install-man
pre-no-install-man:: install-prereq
dont-install-man: $(PREP)
	$(INSTRUBY) -n --make="$(MAKE)" $(INSTRUBY_ARGS) --install=man
post-no-install-man::
	@$(NULLCMD)

install-doc: rdoc pre-install-doc do-install-doc post-install-doc
pre-install-doc:: install-prereq
do-install-doc: $(PROGRAM) pre-install-doc
	$(INSTRUBY) --make="$(MAKE)" $(INSTRUBY_ARGS) --install=rdoc $(INSTALL_DOC_OPTS)
post-install-doc::
	@$(NULLCMD)

install-gem: pre-install-gem do-install-gem post-install-gem
pre-install-gem:: prepare-gems pre-install-bin pre-install-lib pre-install-man
do-install-gem: $(PROGRAM) pre-install-gem
	$(INSTRUBY) --make="$(MAKE)" $(INSTRUBY_ARGS) --install=gem
post-install-gem::
	@$(NULLCMD)

install-dbg: pre-install-dbg do-install-dbg post-install-dbg
pre-install-dbg::
do-install-dbg: $(PROGRAM) pre-install-dbg
	$(INSTRUBY) --make="$(MAKE)" $(INSTRUBY_ARGS) --install=dbg
post-install-dbg::
	@$(NULLCMD)

rdoc: PHONY main
	@echo Generating RDoc documentation
	$(Q) $(RDOC) --ri --op "$(RDOCOUT)" $(RDOC_GEN_OPTS) $(RDOCFLAGS) "$(srcdir)"

html: PHONY main
	@echo Generating RDoc HTML files
	$(Q) $(RDOC) --op "$(HTMLOUT)" $(RDOC_GEN_OPTS) $(RDOCFLAGS) "$(srcdir)"

rdoc-coverage: PHONY main
	@echo Generating RDoc coverage report
	$(Q) $(RDOC) --quiet -C $(RDOCFLAGS) "$(srcdir)"

RDOCBENCHOUT=/tmp/rdocbench

GCBENCH_ITEM=null

gcbench: PHONY
	$(Q) $(XRUBY) "$(srcdir)/benchmark/gc/gcbench.rb" $(GCBENCH_ITEM)

gcbench-rdoc: PHONY
	$(Q) $(XRUBY) "$(srcdir)/benchmark/gc/gcbench.rb" rdoc

nodoc: PHONY

what-where-doc: no-install-doc
no-install-doc: pre-no-install-doc dont-install-doc post-no-install-doc
pre-no-install-doc:: install-prereq
dont-install-doc:: $(PREP)
	$(INSTRUBY) -n --make="$(MAKE)" $(INSTRUBY_ARGS) --install=rdoc $(INSTALL_DOC_OPTS)
post-no-install-doc::
	@$(NULLCMD)

CLEAR_INSTALLED_LIST = clear-installed-list

install-prereq: $(CLEAR_INSTALLED_LIST) yes-fake sudo-precheck PHONY

clear-installed-list: PHONY
	@> $(INSTALLED_LIST) set MAKE="$(MAKE)"

clean: clean-ext clean-enc clean-golf clean-docs clean-extout clean-local clean-platform clean-spec
clean-local:: clean-runnable
	$(Q)$(RM) $(OBJS) $(MINIOBJS) $(INITOBJS) $(MAINOBJ) $(LIBRUBY_A) $(LIBRUBY_SO) $(LIBRUBY) $(LIBRUBY_ALIASES)
	$(Q)$(RM) $(PROGRAM) $(WPROGRAM) miniruby$(EXEEXT) dmyext.$(OBJEXT) dmyenc.$(OBJEXT) $(ARCHFILE) .*.time
	$(Q)$(RM) y.tab.c y.output encdb.h transdb.h config.log rbconfig.rb $(ruby_pc) $(COROUTINE_H:/Context.h=/.time)
	$(Q)$(RM) probes.h probes.$(OBJEXT) probes.stamp ruby-glommed.$(OBJEXT) ruby.imp ChangeLog $(STATIC_RUBY)$(EXEEXT)
	$(Q)$(RM) GNUmakefile.old Makefile.old $(arch)-fake.rb bisect.sh $(ENC_TRANS_D) builtin_binary.inc
	-$(Q)$(RMALL) yjit/target
	-$(Q) $(RMDIR) enc/jis enc/trans enc $(COROUTINE_H:/Context.h=) coroutine 2> $(NULL) || $(NULLCMD)

bin/clean-runnable:: PHONY
	$(Q)$(CHDIR) bin 2>$(NULL) && $(RM) $(PROGRAM) $(WPROGRAM) $(GORUBY)$(EXEEXT) bin/*.$(DLEXT) 2>$(NULL) || $(NULLCMD)
lib/clean-runnable:: PHONY
	$(Q)$(CHDIR) lib 2>$(NULL) && $(RM) $(LIBRUBY_A) $(LIBRUBY) $(LIBRUBY_ALIASES) $(RUBY_BASE_NAME)/$(RUBY_PROGRAM_VERSION) $(RUBY_BASE_NAME)/vendor_ruby 2>$(NULL) || $(NULLCMD)
clean-runnable:: bin/clean-runnable lib/clean-runnable PHONY
	$(Q)$(RMDIR) lib/$(RUBY_BASE_NAME) lib bin 2>$(NULL) || $(NULLCMD)
clean-ext:: PHONY
clean-golf: PHONY
	$(Q)$(RM) $(GORUBY)$(EXEEXT) $(GOLFOBJS)
clean-rdoc: PHONY
clean-html: PHONY
clean-capi: PHONY
clean-platform: PHONY
clean-extout: PHONY
	-$(Q)$(RMDIR) $(EXTOUT)/$(arch) $(RUBYCOMMONDIR) $(EXTOUT) 2> $(NULL) || $(NULLCMD)
clean-docs: clean-rdoc clean-html clean-capi
clean-spec: PHONY
clean-rubyspec: clean-spec

distclean: distclean-ext distclean-enc distclean-golf distclean-docs distclean-extout distclean-local distclean-platform distclean-spec
distclean-local:: clean-local
	$(Q)$(RM) $(MKFILES) yasmdata.rb *.inc $(PRELUDES) *.rbinc
	$(Q)$(RM) config.cache config.status config.status.lineno
	$(Q)$(RM) *~ *.bak *.stackdump core *.core gmon.out $(PREP)
	-$(Q)$(RMALL) $(srcdir)/autom4te.cache
distclean-ext:: PHONY
distclean-golf: clean-golf
distclean-rdoc: clean-rdoc
distclean-html: clean-html
distclean-capi: clean-capi
distclean-docs: clean-docs
distclean-extout: clean-extout
distclean-platform: clean-platform
distclean-spec: clean-spec
distclean-rubyspec: distclean-spec

realclean:: realclean-ext realclean-local realclean-enc realclean-golf realclean-extout
realclean-local:: distclean-local realclean-srcs-local

clean-srcs:: clean-srcs-local clean-srcs-ext
realclean-srcs:: realclean-srcs-local realclean-srcs-ext

clean-srcs-local::
	$(Q)$(RM) parse.c parse.h lex.c enc/trans/newline.c revision.h
	$(Q)$(RM) id.c id.h probes.dmyh probes.h
	$(Q)$(RM) encdb.h transdb.h verconf.h ruby-runner.h
	$(Q)$(RM) mjit_config.h rb_mjit_header.h
	$(Q)$(RM) $(MJIT_MIN_HEADER) $(MJIT_MIN_HEADER:.h=)$(MJIT_HEADER_SUFFIX:%=*).h

realclean-srcs-local:: clean-srcs-local
	$(Q)$(CHDIR) $(srcdir) && $(RM) \
	  parse.c parse.h lex.c enc/trans/newline.c $(PRELUDES) revision.h \
	  id.c id.h probes.dmyh configure aclocal.m4 tool/config.guess tool/config.sub gems/*.gem \
	|| $(NULLCMD)

clean-srcs-ext::
realclean-srcs-ext:: clean-srcs-ext

realclean-ext:: PHONY
realclean-golf: distclean-golf
	$(Q)$(RM) $(GOLFPRELUDES)
realclean-rdoc: distclean-rdoc
realclean-html: distclean-html
realclean-capi: distclean-capi
realclean-docs: distclean-docs
realclean-extout: distclean-extout
realclean-platform: distclean-platform
realclean-spec: distclean-spec
realclean-rubyspec: realclean-spec

clean-ext:: ext/clean .bundle/clean timestamp/clean
distclean-ext:: ext/distclean .bundle/distclean timestamp/distclean
realclean-ext:: ext/realclean .bundle/realclean timestamp/realclean

ext/clean.mk ext/distclean.mk ext/realclean.mk::
ext/clean:: ext/clean.mk
ext/distclean:: ext/distclean.mk
ext/realclean:: ext/realclean.mk

timestamp/clean:: ext/clean .bundle/clean
timestamp/distclean:: ext/distclean .bundle/distclean
timestamp/realclean:: ext/realclean .bundle/realclean

timestamp/clean timestamp/distclean timestamp/realclean::
	$(Q)$(RM) $(TIMESTAMPDIR)/.*.time $(TIMESTAMPDIR)/$(arch)/.time
	$(Q)$(RMDIRS) $(TIMESTAMPDIR)/$(arch) $(TIMESTAMPDIR) 2> $(NULL) || $(NULLCMD)

clean-ext::
	-$(Q)$(RM) ext/extinit.$(OBJEXT)

distclean-ext realclean-ext::
	-$(Q)$(RM) $(EXTS_MK) ext/extinit.* ext/configure-ext.mk
	-$(Q)$(RMDIR) ext 2> $(NULL) || $(NULLCMD)

clean-enc distclean-enc realclean-enc: PHONY

clean-enc: clean-enc.d

clean-enc.d: PHONY
	$(Q)$(RM) $(ENC_TRANS_D)
	-$(Q) $(RMDIR) enc/jis enc/trans enc 2> $(NULL) || $(NULLCMD)

clean-rdoc distclean-rdoc realclean-rdoc:
	@echo $(@:-rdoc=ing) rdoc
	$(Q)$(RMALL) $(RDOCOUT)

clean-html distclean-html realclean-html:
	@echo $(@:-html=ing) HTML
	$(Q)$(RMALL) $(HTMLOUT)

clean-capi distclean-capi realclean-capi:
	@echo $(@:-capi=ing) capi
	$(Q)$(RMALL) $(CAPIOUT)

clean-platform distclean-platform realclean-platform:
	$(Q) $(RM) $(PLATFORM_D)
	-$(Q) $(RMDIR) $(PLATFORM_DIR) 2> $(NULL) || $(NULLCMD)

RUBYSPEC_CAPIEXT = spec/ruby/optional/capi/ext
clean-spec: PHONY
	-$(Q) $(RM) $(RUBYSPEC_CAPIEXT)/*.$(OBJEXT) $(RUBYSPEC_CAPIEXT)/*.$(DLEXT)
	-$(Q) $(RMDIRS) $(RUBYSPEC_CAPIEXT) 2> $(NULL) || $(NULLCMD)
	-$(Q) $(RMALL) rubyspec_temp

check: main $(DOT_WAIT) test $(DOT_WAIT) test-tool $(DOT_WAIT) test-all $(DOT_WAIT) test-spec
	$(ECHO) check succeeded
	-$(Q) : : "run only on sh"; \
	if [ x"$(GIT)" != x ] && $(CHDIR) "$(srcdir)" && \
	    b=`$(GIT) symbolic-ref --short HEAD 2>&1` && \
	    u=`$(GIT) branch --list --format='%(upstream:short)' $$b`; then \
	  set -x; $(GIT) --no-pager log --format=oneline -G '^ *# *include *("|<ruby)' $$u..HEAD --; \
	fi
check-ruby: test test-ruby

fake: $(CROSS_COMPILING)-fake
yes-fake: $(arch)-fake.rb $(RBCONFIG) PHONY
no-fake -fake: PHONY

$(HAVE_BASERUBY:no=)$(arch)-fake.rb: miniruby$(EXEEXT)

# actually depending on other headers more.
$(arch:noarch=ignore)-fake.rb: $(top_srcdir)/revision.h $(top_srcdir)/version.h $(srcdir)/version.c
$(arch:noarch=ignore)-fake.rb: {$(VPATH)}id.h {$(VPATH)}vm_opts.h

$(arch:noarch=ignore)-fake.rb: $(srcdir)/template/fake.rb.in $(tooldir)/generic_erb.rb
	$(ECHO) generating $@
	$(Q) $(CPP) -DRUBY_EXPORT $(INCFLAGS) $(CPPFLAGS) "$(srcdir)/version.c" | \
	$(BOOTSTRAPRUBY) "$(tooldir)/generic_erb.rb" -o $@ "$(srcdir)/template/fake.rb.in" \
		i=- srcdir="$(srcdir)" BASERUBY="$(BASERUBY)"

noarch-fake.rb: # prerequisite of yes-fake
	touch $@

btest: $(TEST_RUNNABLE)-btest
no-btest: PHONY
yes-btest: yes-fake miniruby$(EXEEXT) PHONY
	$(ACTIONS_GROUP)
	$(Q)$(gnumake_recursive)$(exec) $(BOOTSTRAPRUBY) "$(srcdir)/bootstraptest/runner.rb" --ruby="$(BTESTRUBY) $(RUN_OPTS)" $(OPTS) $(TESTOPTS) $(BTESTS)
	$(ACTIONS_ENDGROUP)

btest-ruby: $(TEST_RUNNABLE)-btest-ruby
no-btest-ruby: PHONY
yes-btest-ruby: prog PHONY
	$(ACTIONS_GROUP)
	$(Q)$(gnumake_recursive)$(exec) $(RUNRUBY) "$(srcdir)/bootstraptest/runner.rb" --ruby="$(PROGRAM) -I$(srcdir)/lib $(RUN_OPTS)" $(OPTS) $(TESTOPTS) $(BTESTS)
	$(ACTIONS_ENDGROUP)

rtest: yes-fake miniruby$(EXEEXT) PHONY
	$(ACTIONS_GROUP)
	$(Q)$(exec) $(BOOTSTRAPRUBY) "$(srcdir)/bootstraptest/runner.rb" --ruby="$(BTESTRUBY) $(RUN_OPTS)" --sets=ractor -v
	$(ACTIONS_ENDGROUP)

test-basic: $(TEST_RUNNABLE)-test-basic
no-test-basic: PHONY
yes-test-basic: prog PHONY
	$(ACTIONS_GROUP)
	$(Q)$(exec) $(RUNRUBY) "$(srcdir)/basictest/runner.rb" --run-opt=$(RUN_OPTS) $(OPTS) $(TESTOPTS)
	$(ACTIONS_ENDGROUP)

test-knownbugs: test-knownbug
test-knownbug: $(TEST_RUNNABLE)-test-knownbug
no-test-knownbug: PHONY
yes-test-knownbug: prog PHONY
	$(ACTIONS_GROUP)
	-$(exec) $(RUNRUBY) "$(srcdir)/bootstraptest/runner.rb" --ruby="$(PROGRAM) $(RUN_OPTS)" $(OPTS) $(TESTOPTS) $(srcdir)/KNOWNBUGS.rb
	$(ACTIONS_ENDGROUP)

test-testframework: $(TEST_RUNNABLE)-test-testframework
yes-test-testframework: prog PHONY
	$(ACTIONS_GROUP)
	$(gnumake_recursive)$(Q)$(exec) $(RUNRUBY) "$(TOOL_TESTSDIR)/runner.rb" --ruby="$(RUNRUBY)" $(TESTOPTS) testunit
	$(ACTIONS_ENDGROUP)
no-test-testframework: PHONY

test-tool: $(TEST_RUNNABLE)-test-tool
yes-test-tool: prog PHONY
	$(ACTIONS_GROUP)
	$(gnumake_recursive)$(Q)$(exec) $(RUNRUBY) "$(TOOL_TESTSDIR)/runner.rb" --ruby="$(RUNRUBY)" $(TESTOPTS)
	$(ACTIONS_ENDGROUP)
no-test-tool: PHONY

test-sample: test-basic # backward compatibility for mswin-build
test-short: btest-ruby $(DOT_WAIT) test-knownbug $(DOT_WAIT) test-basic
test: test-short

# $ make test-all TESTOPTS="--help" displays more detail
# for example, make test-all TESTOPTS="-j2 -v -n test-name -- test-file-name"
test-all: $(TEST_RUNNABLE)-test-all
yes-test-all: programs PHONY
	$(ACTIONS_GROUP)
	$(gnumake_recursive)$(Q)$(exec) $(RUNRUBY) "$(TESTSDIR)/runner.rb" --ruby="$(RUNRUBY)" $(TEST_EXCLUDES) $(TESTOPTS) $(TESTS)
	$(ACTIONS_ENDGROUP)
TESTS_BUILD = mkmf
no-test-all: PHONY
	$(gnumake_recursive)$(MINIRUBY) -I"$(srcdir)/lib" "$(TESTSDIR)/runner.rb" $(TESTOPTS) $(TESTS_BUILD)

test-almost: test-all
yes-test-almost: yes-test-all
no-test-almost: no-test-all

test-ruby: $(TEST_RUNNABLE)-test-ruby
no-test-ruby: PHONY
yes-test-ruby: prog encs PHONY
	$(gnumake_recursive)$(RUNRUBY) "$(TESTSDIR)/runner.rb" $(TEST_EXCLUDES) $(TESTOPTS) -- ruby -ext-

extconf: $(PREP)
	$(Q) $(MAKEDIRS) "$(EXTCONFDIR)"
	$(RUNRUBY) -C "$(EXTCONFDIR)" $(EXTCONF) $(EXTCONFARGS)

rbconfig.rb: $(RBCONFIG)

$(HAVE_BASERUBY:no=)$(RBCONFIG)$(HAVE_BASERUBY:no=): $(PREP)
$(RBCONFIG): $(tooldir)/mkconfig.rb config.status $(srcdir)/version.h $(srcdir)/common.mk
	$(Q)$(BOOTSTRAPRUBY) -n \
	-e 'BEGIN{version=ARGV.shift;mis=ARGV.dup}' \
	-e 'END{abort "UNICODE version mismatch: #{mis}" unless mis.empty?}' \
	-e '(mis.delete(ARGF.path); ARGF.close) if /ONIG_UNICODE_VERSION_STRING +"#{Regexp.quote(version)}"/o' \
	$(UNICODE_VERSION) $(UNICODE_DATA_HEADERS)
	$(Q)$(BOOTSTRAPRUBY) $(tooldir)/mkconfig.rb \
		-arch=$(arch) -version=$(RUBY_PROGRAM_VERSION) \
		-install_name=$(RUBY_INSTALL_NAME) \
		-so_name=$(RUBY_SO_NAME) \
		-unicode_version=$(UNICODE_VERSION) \
		-unicode_emoji_version=$(UNICODE_EMOJI_VERSION) \
	> rbconfig.tmp
	$(IFCHANGE) "--timestamp=$@" rbconfig.rb rbconfig.tmp

test-rubyspec: test-spec
yes-test-rubyspec: yes-test-spec

test-spec-precheck: programs yes-fake

test-spec: $(TEST_RUNNABLE)-test-spec
yes-test-spec: test-spec-precheck
	$(ACTIONS_GROUP)
	$(gnumake_recursive)$(Q) \
	$(RUNRUBY) -r./$(arch)-fake $(srcdir)/spec/mspec/bin/mspec run -B $(srcdir)/spec/default.mspec $(MSPECOPT) $(SPECOPTS)
	$(ACTIONS_ENDGROUP)
no-test-spec:

RUNNABLE = $(LIBRUBY_RELATIVE:no=un)-runnable
runnable: $(RUNNABLE) prog $(tooldir)/mkrunnable.rb PHONY
	$(Q) $(MINIRUBY) $(tooldir)/mkrunnable.rb -v $(EXTOUT)
yes-runnable: PHONY

encs: enc trans
libencs: libenc libtrans
encs enc trans libencs libenc libtrans: $(SHOWFLAGS) $(ENC_MK) $(LIBRUBY) $(PREP) PHONY
	$(ECHO) making $@
	$(Q) $(MAKE) $(MAKE_ENC) $@


libenc enc: {$(VPATH)}encdb.h
libtrans trans: {$(VPATH)}transdb.h

ENC_HEADERS = $(srcdir)/enc/jis/props.h
# Use MINIRUBY which loads fake.rb for cross compiling
$(ENC_MK): $(srcdir)/enc/make_encmake.rb $(srcdir)/enc/Makefile.in $(srcdir)/enc/depend \
	   $(srcdir)/enc/encinit.c.erb $(ENC_HEADERS) $(srcdir)/lib/mkmf.rb $(RBCONFIG) $(HAVE_BASERUBY)-fake
	$(ECHO) generating $@
	$(Q) $(BOOTSTRAPRUBY_COMMAND) $(srcdir)/enc/make_encmake.rb \
	  --builtin-encs="$(BUILTIN_ENCOBJS)" --builtin-transes="$(BUILTIN_TRANSOBJS)" --module$(ENCSTATIC) $(ENCS) $@

.PRECIOUS: $(MKFILES)

.PHONY: PHONY all fake prereq incs srcs preludes help
.PHONY: test install install-nodoc install-doc dist
.PHONY: loadpath golf capi rdoc install-prereq clear-installed-list
.PHONY: clean clean-ext clean-local clean-enc clean-golf clean-rdoc clean-html clean-extout
.PHONY: distclean distclean-ext distclean-local distclean-enc distclean-golf distclean-extout
.PHONY: realclean realclean-ext realclean-local realclean-enc realclean-golf realclean-extout
.PHONY: exam check test test-short test-all btest btest-ruby test-basic test-knownbug
.PHONY: run runruby parse benchmark gdb gdb-ruby
.PHONY: update-mspec update-rubyspec test-rubyspec test-spec
.PHONY: touch-unicode-files

PHONY:

{$(VPATH)}parse.c: {$(VPATH)}parse.y $(tooldir)/ytab.sed {$(VPATH)}id.h
{$(VPATH)}parse.h: {$(VPATH)}parse.c

{$(srcdir)}.y.c:
	$(ECHO) generating $@
	$(Q)$(BASERUBY) $(tooldir)/id2token.rb $(SRC_FILE) > parse.tmp.y
	$(Q)$(YACC) -d $(YFLAGS) -o y.tab.c parse.tmp.y
	$(Q)$(RM) parse.tmp.y
	$(Q)sed -f $(tooldir)/ytab.sed -e "/^#/s|parse\.tmp\.[iy]|$(SRC_FILE)|" -e "/^#/s!y\.tab\.c!$@!" y.tab.c > $@.new
	$(Q)$(MV) $@.new $@
	$(Q)sed -e "/^#line.*y\.tab\.h/d;/^#line.*parse.*\.y/d" y.tab.h > $(@:.c=.h)
	$(Q)$(RM) y.tab.c y.tab.h

$(PLATFORM_D):
	$(Q) $(MAKEDIRS) $(PLATFORM_DIR) $(@D)
	@$(NULLCMD) > $@

exe/$(PROGRAM): ruby-runner.c ruby-runner.h exe/.time $(PREP) {$(VPATH)}config.h
	$(Q) $(CC) $(CFLAGS) $(INCFLAGS) $(CPPFLAGS) -DRUBY_INSTALL_NAME=$(@F) $(COUTFLAG)ruby-runner.$(OBJEXT) -c $(CSRCFLAG)$(srcdir)/ruby-runner.c
	$(Q) $(PURIFY) $(CC) $(CFLAGS) $(LDFLAGS) $(OUTFLAG)$@ ruby-runner.$(OBJEXT) $(LIBS)
	$(Q) $(POSTLINK)
	$(Q) $(BOOTSTRAPRUBY) \
	    -e 'prog, dest, inst = ARGV; dest += "/ruby"' \
	    -e 'exit unless prog==inst' \
	    -e 'unless prog=="ruby"' \
	    -e '  begin File.unlink(dest); rescue Errno::ENOENT; end' \
	    -e '  File.symlink(prog, dest)' \
	    -e 'end' \
	$(@F) $(@D) $(RUBY_INSTALL_NAME)$(EXEEXT)

exe/.time:
	$(Q) $(MAKEDIRS) $(@D)
	@$(NULLCMD) > $@

$(BUILTIN_ENCOBJS) $(BUILTIN_TRANSOBJS): $(ENC_TRANS_D)

$(ENC_TRANS_D):
	$(Q) $(MAKEDIRS) enc/trans $(@D)
	@$(NULLCMD) > $@

$(TIMESTAMPDIR)/$(arch)/.time:
	$(Q)$(MAKEDIRS) $(@D) $(EXTOUT)/$(arch)
	@$(NULLCMD) > $@

$(TIMESTAMPDIR)/.RUBYCOMMONDIR.time:
	$(Q)$(MAKEDIRS) $(@D) $(RUBYCOMMONDIR)
	@$(NULLCMD) > $@

###
CCAN_DIR = {$(VPATH)}ccan

RUBY_H_INCLUDES    = {$(VPATH)}ruby.h {$(VPATH)}config.h {$(VPATH)}defines.h \
		     {$(VPATH)}intern.h {$(VPATH)}missing.h {$(VPATH)}st.h \
		     {$(VPATH)}assert.h {$(VPATH)}subst.h

###

acosh.$(OBJEXT): {$(VPATH)}acosh.c
alloca.$(OBJEXT): {$(VPATH)}alloca.c {$(VPATH)}config.h
cbrt.$(OBJEXT): {$(VPATH)}cbrt.c
close.$(OBJEXT): {$(VPATH)}close.c
crypt.$(OBJEXT): {$(VPATH)}crypt.c {$(VPATH)}crypt.h {$(VPATH)}missing/des_tables.c
erf.$(OBJEXT): {$(VPATH)}erf.c
explicit_bzero.$(OBJEXT): {$(VPATH)}explicit_bzero.c
ffs.$(OBJEXT): {$(VPATH)}ffs.c
flock.$(OBJEXT): {$(VPATH)}flock.c
hypot.$(OBJEXT): {$(VPATH)}hypot.c
langinfo.$(OBJEXT): {$(VPATH)}langinfo.c
lgamma_r.$(OBJEXT): {$(VPATH)}lgamma_r.c
memcmp.$(OBJEXT): {$(VPATH)}memcmp.c
memmove.$(OBJEXT): {$(VPATH)}memmove.c
nan.$(OBJEXT): {$(VPATH)}nan.c
nextafter.$(OBJEXT): {$(VPATH)}nextafter.c
procstat_vm.$(OBJEXT): {$(VPATH)}procstat_vm.c
setproctitle.$(OBJEXT): {$(VPATH)}setproctitle.c
strchr.$(OBJEXT): {$(VPATH)}strchr.c
strerror.$(OBJEXT): {$(VPATH)}strerror.c
strlcat.$(OBJEXT): {$(VPATH)}strlcat.c
strlcpy.$(OBJEXT): {$(VPATH)}strlcpy.c
strstr.$(OBJEXT): {$(VPATH)}strstr.c
tgamma.$(OBJEXT): {$(VPATH)}tgamma.c

.coroutine_obj $(COROUTINE_OBJ): \
	{$(VPATH)}$(COROUTINE_SRC) \
	$(COROUTINE_H:/Context.h=/.time)
$(COROUTINE_H:/Context.h=/.time):
	$(Q) $(MAKEDIRS) $(@D)
	@$(NULLCMD) > $@

###

# dependencies for generated C sources.
parse.$(OBJEXT): {$(VPATH)}parse.c
miniprelude.$(OBJEXT): {$(VPATH)}miniprelude.c

# dependencies for optional sources.
compile.$(OBJEXT): {$(VPATH)}opt_sc.inc {$(VPATH)}optunifs.inc

win32/win32.$(OBJEXT): {$(VPATH)}win32/win32.c {$(VPATH)}win32/file.h \
  {$(VPATH)}dln.h {$(VPATH)}dln_find.c {$(VPATH)}encindex.h \
  {$(VPATH)}internal.h {$(VPATH)}util.h $(RUBY_H_INCLUDES) \
  {$(VPATH)}vm.h $(PLATFORM_D)
win32/file.$(OBJEXT): {$(VPATH)}win32/file.c {$(VPATH)}win32/file.h \
  $(RUBY_H_INCLUDES) $(PLATFORM_D)

$(NEWLINE_C): $(srcdir)/enc/trans/newline.trans $(tooldir)/transcode-tblgen.rb
	$(Q) $(MAKEDIRS) $(@D)
	$(Q) $(BASERUBY) "$(tooldir)/transcode-tblgen.rb" -vo $@ $(srcdir)/enc/trans/newline.trans
enc/trans/newline.$(OBJEXT): $(NEWLINE_C)

verconf.h: $(srcdir)/template/verconf.h.tmpl $(tooldir)/generic_erb.rb $(RBCONFIG)
	$(ECHO) creating $@
	$(Q) $(BOOTSTRAPRUBY) "$(tooldir)/generic_erb.rb" -o $@ $(srcdir)/template/verconf.h.tmpl

ruby-glommed.$(OBJEXT): $(OBJS)

$(OBJS):  {$(VPATH)}config.h {$(VPATH)}missing.h

INSNS2VMOPT = --srcdir="$(srcdir)"

srcs_vpath = {$(VPATH)}

inc_common_headers = $(tooldir)/ruby_vm/views/_copyright.erb $(tooldir)/ruby_vm/views/_notice.erb
$(srcs_vpath)opt_sc.inc: $(tooldir)/ruby_vm/views/opt_sc.inc.erb $(inc_common_headers)
$(srcs_vpath)optinsn.inc: $(tooldir)/ruby_vm/views/optinsn.inc.erb $(inc_common_headers)
$(srcs_vpath)optunifs.inc: $(tooldir)/ruby_vm/views/optunifs.inc.erb $(inc_common_headers)
$(srcs_vpath)insns.inc: $(tooldir)/ruby_vm/views/insns.inc.erb $(inc_common_headers)
$(srcs_vpath)insns_info.inc: $(tooldir)/ruby_vm/views/insns_info.inc.erb $(inc_common_headers) \
  $(tooldir)/ruby_vm/views/_insn_type_chars.erb $(tooldir)/ruby_vm/views/_insn_name_info.erb \
  $(tooldir)/ruby_vm/views/_insn_len_info.erb $(tooldir)/ruby_vm/views/_insn_operand_info.erb \
  $(tooldir)/ruby_vm/views/_attributes.erb $(tooldir)/ruby_vm/views/_comptime_insn_stack_increase.erb \
  $(tooldir)/ruby_vm/views/_insn_sp_pc_dependency.erb
$(srcs_vpath)vmtc.inc: $(tooldir)/ruby_vm/views/vmtc.inc.erb $(inc_common_headers)
$(srcs_vpath)vm.inc: $(tooldir)/ruby_vm/views/vm.inc.erb $(inc_common_headers) \
  $(tooldir)/ruby_vm/views/_insn_entry.erb $(tooldir)/ruby_vm/views/_trace_instruction.erb
$(srcs_vpath)mjit_sp_inc.inc: $(tooldir)/ruby_vm/views/mjit_sp_inc.inc.erb

BUILTIN_RB_SRCS = \
		$(srcdir)/ast.rb \
		$(srcdir)/dir.rb \
		$(srcdir)/gc.rb \
		$(srcdir)/numeric.rb \
		$(srcdir)/io.rb \
		$(srcdir)/marshal.rb \
		$(srcdir)/mjit.rb \
		$(srcdir)/mjit_c.rb \
		$(srcdir)/pack.rb \
		$(srcdir)/trace_point.rb \
		$(srcdir)/warning.rb \
		$(srcdir)/array.rb \
		$(srcdir)/kernel.rb \
		$(srcdir)/ractor.rb \
		$(srcdir)/symbol.rb \
		$(srcdir)/timev.rb \
		$(srcdir)/thread_sync.rb \
		$(srcdir)/nilclass.rb \
		$(srcdir)/prelude.rb \
		$(srcdir)/gem_prelude.rb \
		$(srcdir)/yjit.rb \
		$(empty)
BUILTIN_RB_INCS = $(BUILTIN_RB_SRCS:.rb=.rbinc)

common-srcs: $(srcs_vpath)parse.c $(srcs_vpath)lex.c $(srcs_vpath)enc/trans/newline.c $(srcs_vpath)id.c \
	     $(BUILTIN_RB_INCS) \
	     srcs-lib srcs-ext incs preludes

missing-srcs: $(srcdir)/missing/des_tables.c

srcs: common-srcs missing-srcs srcs-enc

EXT_SRCS = $(srcdir)/ext/ripper/ripper.c \
	   $(srcdir)/ext/rbconfig/sizeof/sizes.c \
	   $(srcdir)/ext/rbconfig/sizeof/limits.c \
	   $(srcdir)/ext/socket/constdefs.c \
	   $(srcdir)/ext/etc/constdefs.h \
	   # EXT_SRCS

srcs-ext: $(EXT_SRCS)
realclean-srcs-ext::
	$(Q)$(RM) $(EXT_SRCS)

EXTRA_SRCS = $(srcdir)/ext/json/parser/parser.c \
	     $(srcdir)/ext/date/zonetab.h \
	     $(empty)

srcs-extra: $(EXTRA_SRCS)
realclean-srcs-extra::
	$(Q)$(RM) $(EXTRA_SRCS)

LIB_SRCS = $(srcdir)/lib/unicode_normalize/tables.rb

srcs-lib: $(LIB_SRCS)

srcs-enc: $(ENC_MK)
	$(ECHO) making srcs under enc
	$(Q) $(MAKE) $(MAKE_ENC) srcs

all-incs: incs {$(VPATH)}encdb.h {$(VPATH)}transdb.h
incs: $(INSNS) {$(VPATH)}node_name.inc {$(VPATH)}known_errors.inc \
      {$(VPATH)}vm_call_iseq_optimized.inc $(srcdir)/revision.h \
      $(REVISION_H) \
      $(UNICODE_DATA_HEADERS) $(ENC_HEADERS) \
      {$(VPATH)}id.h {$(VPATH)}probes.dmyh

insns: $(INSNS)

id.h: $(tooldir)/generic_erb.rb $(srcdir)/template/id.h.tmpl $(srcdir)/defs/id.def
	$(ECHO) generating $@
	$(Q) $(BASERUBY) $(tooldir)/generic_erb.rb --output=$@ \
		$(srcdir)/template/id.h.tmpl

id.c: $(tooldir)/generic_erb.rb $(srcdir)/template/id.c.tmpl $(srcdir)/defs/id.def
	$(ECHO) generating $@
	$(Q) $(BASERUBY) $(tooldir)/generic_erb.rb --output=$@ \
		$(srcdir)/template/id.c.tmpl

node_name.inc: $(tooldir)/node_name.rb $(srcdir)/node.h
	$(ECHO) generating $@
	$(Q) $(BASERUBY) -n $(tooldir)/node_name.rb < $(srcdir)/node.h > $@

encdb.h: $(RBCONFIG) $(tooldir)/generic_erb.rb $(srcdir)/template/encdb.h.tmpl
	$(ECHO) generating $@
	$(Q) $(BOOTSTRAPRUBY) $(tooldir)/generic_erb.rb -c -o $@ $(srcdir)/template/encdb.h.tmpl $(srcdir)/enc enc

transdb.h: $(RBCONFIG) srcs-enc $(tooldir)/generic_erb.rb $(srcdir)/template/transdb.h.tmpl
	$(ECHO) generating $@
	$(Q) $(BOOTSTRAPRUBY) $(tooldir)/generic_erb.rb -c -o $@ $(srcdir)/template/transdb.h.tmpl $(srcdir)/enc/trans enc/trans

enc/encinit.c: $(ENC_MK) $(srcdir)/enc/encinit.c.erb

known_errors.inc: $(srcdir)/template/known_errors.inc.tmpl $(srcdir)/defs/known_errors.def
	$(ECHO) generating $@
	$(Q) $(BASERUBY) $(tooldir)/generic_erb.rb -c -o $@ $(srcdir)/template/known_errors.inc.tmpl $(srcdir)/defs/known_errors.def

vm_call_iseq_optimized.inc: $(srcdir)/template/call_iseq_optimized.inc.tmpl
	$(ECHO) generating $@
	$(Q) $(BASERUBY) $(tooldir)/generic_erb.rb -c -o $@ $(srcdir)/template/call_iseq_optimized.inc.tmpl

$(MINIPRELUDE_C): $(COMPILE_PRELUDE) $(BUILTIN_RB_SRCS)
	$(ECHO) generating $@
	$(Q) $(BASERUBY) $(tooldir)/generic_erb.rb -I$(srcdir) -o $@ \
		$(srcdir)/template/prelude.c.tmpl $(BUILTIN_RB_SRCS)

$(GOLF_PRELUDE_C): $(COMPILE_PRELUDE) {$(srcdir)}golf_prelude.rb
	$(ECHO) generating $@
	$(Q) $(BASERUBY) $(tooldir)/generic_erb.rb -I$(srcdir) -c -o $@ \
		$(srcdir)/template/prelude.c.tmpl golf_prelude.rb

MAINCPPFLAGS = $(ENABLE_DEBUG_ENV:yes=-DRUBY_DEBUG_ENV=1)

$(MAINOBJ): $(srcdir)/$(MAINSRC)
	$(ECHO) compiling $(srcdir)/$(MAINSRC)
	$(Q) $(CC) $(MAINCPPFLAGS) $(CFLAGS) $(XCFLAGS) $(CPPFLAGS) $(COUTFLAG)$@ -c $(CSRCFLAG)$(srcdir)/$(MAINSRC)

{$(VPATH)}probes.dmyh: {$(srcdir)}probes.d $(tooldir)/gen_dummy_probes.rb

probes.dmyh:
	$(BASERUBY) $(tooldir)/gen_dummy_probes.rb $(srcdir)/probes.d > $@

probes.h: {$(VPATH)}probes.$(DTRACE_EXT)

prereq: incs srcs preludes PHONY

preludes: {$(VPATH)}miniprelude.c
preludes: {$(srcdir)}golf_prelude.c

{$(srcdir)}.rb.rbinc:
	$(ECHO) making $@
	$(Q) $(BASERUBY) $(tooldir)/mk_builtin_loader.rb $<

builtin_binary.inc: $(PREP) $(BUILTIN_RB_SRCS) $(srcdir)/template/builtin_binary.inc.tmpl
	$(Q) $(MINIRUBY) $(tooldir)/generic_erb.rb -o $@ \
		$(srcdir)/template/builtin_binary.inc.tmpl -- --cross=$(CROSS_COMPILING)

$(BUILTIN_RB_INCS): $(top_srcdir)/tool/mk_builtin_loader.rb

$(srcdir)/revision.h$(no_baseruby:no=~disabled~): $(REVISION_H)

$(REVISION_H)$(no_baseruby:no=~disabled~):
	$(Q) $(BASERUBY) $(tooldir)/file2lastrev.rb -q --revision.h --srcdir="$(srcdir)" --output=revision.h --timestamp=$@
$(REVISION_H)$(yes_baseruby:yes=~disabled~):
	$(Q) touch $@

$(srcdir)/ext/ripper/ripper.c: $(srcdir)/ext/ripper/tools/preproc.rb $(srcdir)/parse.y $(srcdir)/defs/id.def $(srcdir)/ext/ripper/depend
	$(ECHO) generating $@
	$(Q) $(CHDIR) $(@D) && \
	$(CAT_DEPEND) depend | \
	$(exec) $(MAKE) -f - $(mflags) \
		Q=$(Q) ECHO=$(ECHO) RM="$(RM1)" BISON="$(YACC)" top_srcdir=../.. srcdir=. VPATH=../.. \
		RUBY="$(BASERUBY)" PATH_SEPARATOR="$(PATH_SEPARATOR)" LANG=C

$(srcdir)/ext/json/parser/parser.c: $(srcdir)/ext/json/parser/parser.rl $(srcdir)/ext/json/parser/prereq.mk
	$(ECHO) generating $@
	$(Q) $(CHDIR) $(@D) && $(exec) $(MAKE) -f prereq.mk $(mflags) \
		Q=$(Q) ECHO=$(ECHO) top_srcdir=../../.. srcdir=. VPATH=../../.. BASERUBY="$(BASERUBY)"

$(srcdir)/ext/date/zonetab.h: $(srcdir)/ext/date/zonetab.list $(srcdir)/ext/date/prereq.mk
	$(ECHO) generating $@
	$(Q) $(CHDIR) $(@D) && $(exec) $(MAKE) -f prereq.mk $(mflags) \
		Q=$(Q) ECHO=$(ECHO) top_srcdir=../.. srcdir=. VPATH=../.. BASERUBY="$(BASERUBY)"

$(srcdir)/ext/rbconfig/sizeof/sizes.c: $(srcdir)/ext/rbconfig/sizeof/depend \
		$(tooldir)/generic_erb.rb $(srcdir)/template/sizes.c.tmpl $(srcdir)/configure.ac
	$(ECHO) generating $@
	$(Q) $(CHDIR) $(@D) && \
	$(CAT_DEPEND) depend | \
	$(exec) $(MAKE) -f - $(mflags) \
		Q=$(Q) ECHO=$(ECHO) top_srcdir=../../.. srcdir=. VPATH=../../.. RUBY="$(BASERUBY)" $(@F)

$(srcdir)/ext/rbconfig/sizeof/limits.c: $(srcdir)/ext/rbconfig/sizeof/depend \
		$(tooldir)/generic_erb.rb $(srcdir)/template/limits.c.tmpl
	$(ECHO) generating $@
	$(Q) $(CHDIR) $(@D) && \
	$(CAT_DEPEND) depend | \
	$(exec) $(MAKE) -f - $(mflags) \
		Q=$(Q) ECHO=$(ECHO) top_srcdir=../../.. srcdir=. VPATH=../../.. RUBY="$(BASERUBY)" $(@F)

$(srcdir)/ext/socket/constdefs.c: $(srcdir)/ext/socket/depend
	$(Q) $(CHDIR) $(@D) && \
	$(CAT_DEPEND) depend | \
	$(exec) $(MAKE) -f - $(mflags) \
		Q=$(Q) ECHO=$(ECHO) top_srcdir=../.. srcdir=. VPATH=../.. RUBY="$(BASERUBY)"

$(srcdir)/ext/etc/constdefs.h: $(srcdir)/ext/etc/depend
	$(Q) $(CHDIR) $(@D) && \
	$(CAT_DEPEND) depend | \
	$(exec) $(MAKE) -f - $(mflags) \
		Q=$(Q) ECHO=$(ECHO) top_srcdir=../.. srcdir=. VPATH=../.. RUBY="$(BASERUBY)"

##

run: yes-fake miniruby$(EXEEXT) PHONY
	$(BTESTRUBY) $(RUNOPT0) $(TESTRUN_SCRIPT) $(RUNOPT)

runruby: $(PROGRAM) PHONY
	RUBY_ON_BUG='gdb -x $(srcdir)/.gdbinit -p' $(RUNRUBY) $(RUNOPT0) $(TESTRUN_SCRIPT) $(RUNOPT)

runirb: $(PROGRAM) PHONY
	RUBY_ON_BUG='gdb -x $(srcdir)/.gdbinit -p' $(RUNRUBY) $(RUNOPT0) -r irb -e 'IRB.start("make runirb")' $(RUNOPT)

parse: yes-fake miniruby$(EXEEXT) PHONY
	$(BTESTRUBY) --dump=parsetree_with_comment,insns $(TESTRUN_SCRIPT)

bisect: PHONY
	$(tooldir)/bisect.sh miniruby $(srcdir)

bisect-ruby: PHONY
	$(tooldir)/bisect.sh ruby $(srcdir)

COMPARE_RUBY = $(BASERUBY)
BENCH_RUBY = $(RUNRUBY)
BENCH_OPTS = --output=markdown --output-compare -v
ITEM =
ARGS = $$(find $(srcdir)/benchmark -maxdepth 1 -name '$(ITEM)' -o -name '*$(ITEM)*.yml' -o -name '*$(ITEM)*.rb' | sort)
OPTS =

# See benchmark/README.md for details.
benchmark: miniruby$(EXEEXT) update-benchmark-driver PHONY
	$(BASERUBY) -rrubygems -I$(srcdir)/benchmark/lib $(srcdir)/benchmark/benchmark-driver/exe/benchmark-driver \
	            --executables="compare-ruby::$(COMPARE_RUBY) -I$(EXTOUT)/common --disable-gem" \
	            --executables="built-ruby::$(BENCH_RUBY) --disable-gem" \
	            $(BENCH_OPTS) $(ARGS) $(OPTS)

run.gdb:
	echo set breakpoint pending on         > run.gdb
	echo b rb_assert_failure              >> run.gdb
	echo b rb_bug                         >> run.gdb
	echo b ruby_debug_breakpoint          >> run.gdb
	echo '# handle SIGINT nostop'         >> run.gdb
	echo '# handle SIGPIPE nostop'        >> run.gdb
	echo '# b rb_longjmp'                 >> run.gdb
	echo source $(srcdir)/breakpoints.gdb >> run.gdb
	echo source $(srcdir)/.gdbinit        >> run.gdb
	echo 'set $$_exitcode = -999'         >> run.gdb
	echo run                              >> run.gdb
	echo 'if $$_exitcode != -999'         >> run.gdb
	echo '  quit'                         >> run.gdb
	echo end                              >> run.gdb


gdb: miniruby$(EXEEXT) run.gdb PHONY
	gdb -x run.gdb --quiet --args $(MINIRUBY) $(RUNOPT0) $(TESTRUN_SCRIPT) $(RUNOPT)

gdb-ruby: $(PROGRAM) run.gdb PHONY
	$(Q) $(RUNRUBY_COMMAND) $(RUNRUBY_DEBUGGER) -- $(RUNOPT0) $(TESTRUN_SCRIPT) $(RUNOPT)

LLDB_INIT = command script import -r $(srcdir)/misc/lldb_cruby.py

lldb: miniruby$(EXEEXT) PHONY
	lldb -o '$(LLDB_INIT)' miniruby$(EXEEXT) -- $(RUNOPT0) $(TESTRUN_SCRIPT) $(RUNOPT)

lldb-ruby: $(PROGRAM) PHONY
	lldb $(enable_shared:yes=-o 'target modules add ${LIBRUBY_SO}') -o '$(LLDB_INIT)' $(PROGRAM) -- $(RUNOPT0) $(TESTRUN_SCRIPT) $(RUNOPT)

DISTPKGS = gzip,zip,all
PKGSDIR = tmp
dist:
	$(BASERUBY) $(V0:1=-v) $(tooldir)/make-snapshot \
	-srcdir=$(srcdir) -packages=$(DISTPKGS) \
	-unicode-version=$(UNICODE_VERSION) \
	$(DISTOPTS) $(PKGSDIR) $(RELNAME)

up:: update-remote

up::
	-$(Q)$(MAKE) $(mflags) Q=$(Q) REVISION_FORCE=PHONY ALWAYS_UPDATE_UNICODE= after-update

yes::
no::

after-update:: common-srcs
after-update:: $(REVISION_H)
after-update:: extract-extlibs
after-update:: extract-gems

update-src::
	$(Q) $(RM) $(REVISION_H) revision.h "$(srcdir)/$(REVISION_H)" "$(srcdir)/revision.h"
	$(Q) touch "$(srcdir)/revision.h"

update-remote:: update-src update-download
update-download:: $(ALWAYS_UPDATE_UNICODE:yes=update-unicode)
update-download:: update-gems
update-download:: download-extlibs

update-mspec:
update-rubyspec:

update-config_files: PHONY
	$(Q) $(BASERUBY) -C "$(srcdir)" tool/downloader.rb -d tool --cache-dir=$(CACHE_DIR) -e gnu \
	    config.guess config.sub

refresh-gems: update-bundled_gems prepare-gems
prepare-gems: $(HAVE_BASERUBY:yes=update-gems) $(HAVE_BASERUBY:yes=extract-gems)
prepare-gems: $(DOT_WAIT) $(HAVE_BASERUBY:yes=outdate-bundled-gems)
extract-gems: $(HAVE_BASERUBY:yes=update-gems)

update-gems$(gnumake:yes=-sequential): PHONY
	$(ECHO) Downloading bundled gem files...
	$(Q) $(BASERUBY) -C "$(srcdir)" \
	    -I./tool -rdownloader -answ \
	    -e 'gem, ver = *$$F' \
	    -e 'next if !ver or /^#/=~gem' \
	    -e 'old = Dir.glob("gems/#{gem}-*.gem")' \
	    -e 'gem = "#{gem}-#{ver}.gem"' \
	    -e 'Downloader::RubyGems.download(gem, "gems", nil) and' \
	    -e '(old.delete("gems/#{gem}"); !old.empty?) and' \
	    -e 'File.unlink(*old) and' \
	    -e 'FileUtils.rm_rf(old.map{'"|n|"'n.chomp(".gem")})' \
	    gems/bundled_gems

extract-gems$(gnumake:yes=-sequential): PHONY
	$(ECHO) Extracting bundled gem files...
	$(Q) $(BASERUBY) -C "$(srcdir)" \
	    -Itool/lib -rfileutils -rbundled_gem -answ \
	    -e 'BEGIN {d = ".bundle/gems"}' \
	    -e 'gem, ver, _, rev = *$$F' \
	    -e 'next if !ver or /^#/=~gem' \
	    -e 'g = "#{gem}-#{ver}"' \
	    -e 'if File.directory?("#{d}/#{g}")' \
	    -e 'elsif rev and File.exist?(gs = "gems/src/#{gem}/#{gem}.gemspec")' \
	    -e   'BundledGem.copy(gs, ".bundle")' \
	    -e 'else' \
	    -e   'BundledGem.unpack("gems/#{g}.gem", ".bundle")' \
	    -e 'end' \
	    gems/bundled_gems

outdate-bundled-gems: PHONY
	$(Q) $(BASERUBY) $(tooldir)/$@.rb --make="$(MAKE)" --mflags="$(MFLAGS)" "$(srcdir)"

update-bundled_gems: PHONY
	$(Q) $(RUNRUBY) -rrubygems \
	     $(tooldir)/update-bundled_gems.rb \
	     "$(srcdir)/gems/bundled_gems" | \
	$(IFCHANGE) "$(srcdir)/gems/bundled_gems" -
	$(GIT) -C "$(srcdir)" diff --no-ext-diff --ignore-submodules --exit-code || \
	$(GIT) -C "$(srcdir)" commit -m "Update bundled_gems" gems/bundled_gems

PRECHECK_BUNDLED_GEMS = test-bundled-gems-precheck
test-bundled-gems-precheck: $(TEST_RUNNABLE)-test-bundled-gems-precheck
yes-test-bundled-gems-precheck: main
no-test-bundled-gems-precheck:

test-bundled-gems-fetch: yes-test-bundled-gems-fetch
yes-test-bundled-gems-fetch:
	$(ACTIONS_GROUP)
	$(Q) $(BASERUBY) -C $(srcdir)/gems ../tool/fetch-bundled_gems.rb src bundled_gems
	$(ACTIONS_ENDGROUP)
no-test-bundled-gems-fetch:

test-bundled-gems-prepare: $(PRECHECK_BUNDLED_GEMS) test-bundled-gems-fetch
test-bundled-gems-prepare: $(TEST_RUNNABLE)-test-bundled-gems-prepare
no-test-bundled-gems-prepare: no-test-bundled-gems-precheck
yes-test-bundled-gems-prepare: yes-test-bundled-gems-precheck
	$(ACTIONS_GROUP)
	$(XRUBY) -C "$(srcdir)" bin/gem install --no-document \
		--install-dir .bundle --conservative "bundler" "minitest:~> 5" "test-unit" "rake" "hoe" "yard" "pry" "packnga" "rexml" "json-schema" "test-unit-rr"
	$(ACTIONS_ENDGROUP)

PREPARE_BUNDLED_GEMS = test-bundled-gems-prepare
test-bundled-gems: $(TEST_RUNNABLE)-test-bundled-gems
yes-test-bundled-gems: test-bundled-gems-run
no-test-bundled-gems:

# Override this to allow failure of specific gems on CI
# TEST_BUNDLED_GEMS_ALLOW_FAILURES =

BUNDLED_GEMS =
test-bundled-gems-run: $(PREPARE_BUNDLED_GEMS)
	$(gnumake_recursive)$(Q) $(XRUBY) $(tooldir)/test-bundled-gems.rb $(BUNDLED_GEMS)

test-syntax-suggest-precheck: $(TEST_RUNNABLE)-test-syntax-suggest-precheck
no-test-syntax-suggest-precheck:
yes-test-syntax-suggest-precheck: main

no-test-syntax-suggest-prepare: no-test-syntax-suggest-precheck
yes-test-syntax-suggest-prepare: yes-test-syntax-suggest-precheck
	$(ACTIONS_GROUP)
	$(XRUBY) -C "$(srcdir)" bin/gem install --no-document \
		--install-dir .bundle --conservative "bundler" "rake" "rspec:~> 3" #"ruby-prof"
	$(ACTIONS_ENDGROUP)

RSPECOPTS =
SYNTAX_SUGGEST_SPECS =
test-syntax-suggest: $(TEST_RUNNABLE)-test-syntax-suggest
yes-test-syntax-suggest: yes-test-syntax-suggest-prepare
	$(XRUBY) -C $(srcdir) -Ispec/syntax_suggest .bundle/bin/rspec \
		--require spec_helper $(RSPECOPTS) spec/syntax_suggest/$(SYNTAX_SUGGEST_SPECS)
no-test-syntax-suggest:

test-bundler-precheck: $(TEST_RUNNABLE)-test-bundler-precheck
no-test-bundler-precheck:
yes-test-bundler-precheck: main $(arch)-fake.rb

no-test-bundler-prepare: no-test-bundler-precheck
yes-test-bundler-prepare: yes-test-bundler-precheck
	$(ACTIONS_GROUP)
	$(XRUBY) -C $(srcdir) -Ilib \
		-e 'ENV["GEM_HOME"] = File.expand_path(".bundle")' \
		-e 'ENV["BUNDLE_APP_CONFIG"] = File.expand_path(".bundle")' \
		-e 'ENV["BUNDLE_PATH__SYSTEM"] = "true"' \
		-e 'ENV["BUNDLE_WITHOUT"] = "lint doc"' \
		-e 'load "spec/bundler/support/bundle.rb"' -- install --gemfile=tool/bundler/dev_gems.rb
	$(ACTIONS_ENDGROUP)

RSPECOPTS =
BUNDLER_SPECS =
test-bundler: $(TEST_RUNNABLE)-test-bundler
yes-test-bundler: yes-test-bundler-prepare
	$(gnumake_recursive)$(XRUBY) \
		-r./$(arch)-fake \
		-e "exec(*ARGV)" -- \
		$(XRUBY) -C $(srcdir) -Ispec/bundler .bundle/bin/rspec \
		--require spec_helper $(RSPECOPTS) spec/bundler/$(BUNDLER_SPECS)
no-test-bundler:

PARALLELRSPECOPTS = --runtime-log $(srcdir)/tmp/parallel_runtime_rspec.log
test-bundler-parallel: $(TEST_RUNNABLE)-test-bundler-parallel
yes-test-bundler-parallel: yes-test-bundler-prepare
	$(gnumake_recursive)$(XRUBY) \
		-r./$(arch)-fake \
		-e "ARGV[-1] = File.expand_path(ARGV[-1])" \
		-e "exec(*ARGV)" -- \
		$(XRUBY) -I$(srcdir)/spec/bundler \
		-e "ENV['PARALLEL_TESTS_EXECUTABLE'] = ARGV.shift" \
		-e "load ARGV.shift" \
		"$(XRUBY) -C $(srcdir) -Ispec/bundler .bundle/bin/rspec" \
		$(srcdir)/.bundle/bin/parallel_rspec \
		-o "--require spec_helper" \
		$(PARALLELRSPECOPTS) $(srcdir)/spec/bundler/$(BUNDLER_SPECS)
no-test-bundler-parallel:

# The annocheck supports ELF format binaries compiled for any OS and for any
# architecture. It is designed to be independent of the host OS and the
# architecture. The test-annocheck.sh requires docker or podman.
test-annocheck: $(PROGRAM)
	$(tooldir)/test-annocheck.sh $(PROGRAM)

GEM = up
sync-default-gems:
	$(Q) $(XRUBY) -C "$(srcdir)" tool/sync_default_gems.rb $(GEM)

UNICODE_FILES = $(UNICODE_SRC_DATA_DIR)/UnicodeData.txt \
		$(UNICODE_SRC_DATA_DIR)/CompositionExclusions.txt \
		$(UNICODE_SRC_DATA_DIR)/NormalizationTest.txt \
		$(UNICODE_SRC_DATA_DIR)/CaseFolding.txt \
		$(UNICODE_SRC_DATA_DIR)/SpecialCasing.txt \
		$(empty)

UNICODE_PROPERTY_FILES =  \
		$(UNICODE_SRC_DATA_DIR)/Blocks.txt \
		$(UNICODE_SRC_DATA_DIR)/DerivedAge.txt \
		$(UNICODE_SRC_DATA_DIR)/DerivedCoreProperties.txt \
		$(UNICODE_SRC_DATA_DIR)/PropList.txt \
		$(UNICODE_SRC_DATA_DIR)/PropertyAliases.txt \
		$(UNICODE_SRC_DATA_DIR)/PropertyValueAliases.txt \
		$(UNICODE_SRC_DATA_DIR)/Scripts.txt \
		$(empty)

UNICODE_AUXILIARY_FILES =  \
		$(UNICODE_SRC_DATA_DIR)/auxiliary/GraphemeBreakProperty.txt \
		$(UNICODE_SRC_DATA_DIR)/auxiliary/GraphemeBreakTest.txt \
		$(empty)

UNICODE_UCD_EMOJI_FILES = \
		$(UNICODE_SRC_DATA_DIR)/emoji/emoji-data.txt \
		$(UNICODE_SRC_DATA_DIR)/emoji/emoji-variation-sequences.txt \
		$(empty)

UNICODE_EMOJI_FILES = \
		$(UNICODE_SRC_EMOJI_DATA_DIR)/emoji-sequences.txt \
		$(UNICODE_SRC_EMOJI_DATA_DIR)/emoji-test.txt \
		$(UNICODE_SRC_EMOJI_DATA_DIR)/emoji-zwj-sequences.txt \
		$(empty)

update-unicode: $(UNICODE_FILES) $(UNICODE_PROPERTY_FILES) \
		$(UNICODE_AUXILIARY_FILES) $(UNICODE_UCD_EMOJI_FILES) $(UNICODE_EMOJI_FILES)

CACHE_DIR = $(srcdir)/.downloaded-cache
UNICODE_DOWNLOADER_ALWAYS_UPDATE = $(ALWAYS_UPDATE_UNICODE:yes=--always)
UNICODE_DOWNLOADER = \
	$(BASERUBY) $(tooldir)/downloader.rb \
	    --cache-dir=$(CACHE_DIR) \
	    --exist $(UNICODE_DOWNLOADER_ALWAYS_UPDATE:no=) \
	    unicode --unicode-beta=$(UNICODE_BETA)
UNICODE_DOWNLOAD = \
	$(UNICODE_DOWNLOADER) \
	    -d $(UNICODE_SRC_DATA_DIR) \
	    -p $(UNICODE_VERSION)/ucd
UNICODE_AUXILIARY_DOWNLOAD = \
	$(UNICODE_DOWNLOADER) \
	    -d $(UNICODE_SRC_DATA_DIR)/auxiliary \
	    -p $(UNICODE_VERSION)/ucd/auxiliary
UNICODE_UCD_EMOJI_DOWNLOAD = \
	$(UNICODE_DOWNLOADER) \
	    -d $(UNICODE_SRC_DATA_DIR)/emoji \
	    -p $(UNICODE_VERSION)/ucd/emoji
UNICODE_EMOJI_DOWNLOAD = \
	$(UNICODE_DOWNLOADER) \
	    -d $(UNICODE_SRC_EMOJI_DATA_DIR) \
	    -p emoji/$(UNICODE_EMOJI_VERSION)

$(UNICODE_FILES) $(UNICODE_PROPERTY_FILES): update-unicode-files
update-unicode-files:
	$(ECHO) Downloading Unicode $(UNICODE_VERSION) data and property files...
	$(Q) $(MAKEDIRS) "$(UNICODE_SRC_DATA_DIR)"
	$(Q) $(UNICODE_DOWNLOAD) $(UNICODE_FILES) $(UNICODE_PROPERTY_FILES)

$(UNICODE_AUXILIARY_FILES): update-unicode-auxiliary-files
update-unicode-auxiliary-files:
	$(ECHO) Downloading Unicode $(UNICODE_VERSION) auxiliary files...
	$(Q) $(MAKEDIRS) "$(UNICODE_SRC_DATA_DIR)/auxiliary"
	$(Q) $(UNICODE_AUXILIARY_DOWNLOAD) $(UNICODE_AUXILIARY_FILES)

$(UNICODE_UCD_EMOJI_FILES): update-unicode-ucd-emoji-files
update-unicode-ucd-emoji-files:
	$(ECHO) Downloading Unicode UCD emoji $(UNICODE_EMOJI_VERSION) files...
	$(Q) $(MAKEDIRS) "$(UNICODE_SRC_DATA_DIR)/emoji"
	$(Q) $(UNICODE_UCD_EMOJI_DOWNLOAD) $(UNICODE_UCD_EMOJI_FILES)

$(UNICODE_EMOJI_FILES): update-unicode-emoji-files
update-unicode-emoji-files:
	$(ECHO) Downloading Unicode emoji $(UNICODE_EMOJI_VERSION) files...
	$(Q) $(MAKEDIRS) "$(UNICODE_SRC_EMOJI_DATA_DIR)"
	$(Q) $(UNICODE_EMOJI_DOWNLOAD) $(UNICODE_EMOJI_FILES)

$(srcdir)/lib/unicode_normalize/$(ALWAYS_UPDATE_UNICODE:yes=tables.rb): \
	$(UNICODE_SRC_DATA_DIR)/$(HAVE_BASERUBY:yes=.unicode-tables.time)

$(UNICODE_SRC_DATA_DIR)/$(ALWAYS_UPDATE_UNICODE:yes=.unicode-tables.time): \
	$(UNICODE_FILES) $(UNICODE_PROPERTY_FILES) \
	$(UNICODE_AUXILIARY_FILES) $(UNICODE_UCD_EMOJI_FILES) $(UNICODE_EMOJI_FILES)

touch-unicode-files:
	$(MAKEDIRS) $(UNICODE_SRC_DATA_DIR)
	touch $(UNICODE_SRC_DATA_DIR)/.unicode-tables.time $(UNICODE_DATA_HEADERS)

UNICODE_TABLES_TIMESTAMP = yes
$(UNICODE_SRC_DATA_DIR)/.unicode-tables.time: $(tooldir)/generic_erb.rb \
		$(srcdir)/template/unicode_norm_gen.tmpl \
		$(ALWAYS_UPDATE_UNICODE:yes=update-unicode)
	$(Q) $(MAKE) $(@D)
	$(Q) $(BASERUBY) $(tooldir)/generic_erb.rb \
		-c $(UNICODE_TABLES_TIMESTAMP:yes=-t$@) \
		-o $(srcdir)/lib/unicode_normalize/tables.rb \
		-I $(srcdir) \
		$(srcdir)/template/unicode_norm_gen.tmpl \
		$(UNICODE_DATA_DIR) lib/unicode_normalize

$(UNICODE_SRC_DATA_DIR):
	$(gnumake_recursive)$(Q) $(MAKEDIRS) $@

$(UNICODE_HDR_DIR)/$(ALWAYS_UPDATE_UNICODE:yes=name2ctype.h): \
		$(tooldir)/enc-unicode.rb \
		$(UNICODE_SRC_DATA_DIR)/UnicodeData.txt \
		$(UNICODE_AUXILIARY_FILES) \
		$(UNICODE_PROPERTY_FILES) \
		$(UNICODE_UCD_EMOJI_FILES) \
		$(UNICODE_EMOJI_FILES)

$(UNICODE_HDR_DIR)/name2ctype.h:
	$(MAKEDIRS) $(@D)
	$(BOOTSTRAPRUBY) $(tooldir)/enc-unicode.rb --header \
		$(UNICODE_SRC_DATA_DIR) $(UNICODE_SRC_EMOJI_DATA_DIR) > $@.new
	$(MV) $@.new $@

# the next non-comment line was:
# $(UNICODE_HDR_DIR)/casefold.h: $(tooldir)/enc-case-folding.rb \
# but was changed to make sure CI works on systems that don't have gperf
unicode-up: $(UNICODE_DATA_HEADERS)

$(UNICODE_HDR_DIR)/$(ALWAYS_UPDATE_UNICODE:yes=casefold.h): \
		$(tooldir)/enc-case-folding.rb \
		$(UNICODE_SRC_DATA_DIR)/UnicodeData.txt \
		$(UNICODE_SRC_DATA_DIR)/SpecialCasing.txt \
		$(UNICODE_SRC_DATA_DIR)/CaseFolding.txt

$(UNICODE_HDR_DIR)/casefold.h:
	$(MAKEDIRS) $(@D)
	$(Q) $(BASERUBY) $(tooldir)/enc-case-folding.rb \
		--output-file=$@ \
		--mapping-data-directory=$(UNICODE_SRC_DATA_DIR)

download-extlibs:
	$(Q) $(BASERUBY) -C $(srcdir) -w tool/extlibs.rb --download ext

extract-extlibs:
	$(Q) $(BASERUBY) -C $(srcdir) -w tool/extlibs.rb --all ext

clean-extlibs:
	$(Q) $(RMALL) $(srcdir)/.downloaded-cache

clean-gems:
	$(Q) $(RM) gems/*.gem

CLEAN_CACHE = clean-extlibs

info: info-program info-libruby_a info-libruby_so info-arch
info-program: PHONY
	@echo PROGRAM=$(PROGRAM)
info-libruby_a: PHONY
	@echo LIBRUBY_A=$(LIBRUBY_A)
info-libruby_so: PHONY
	@echo LIBRUBY_SO=$(LIBRUBY_SO)
info-arch: PHONY
	@echo arch=$(arch)

exam: check

love: sudo-precheck up all test exam install
	@echo love is all you need

great: exam

yes-test-all no-test-all: sudo-precheck

sudo-precheck: PHONY
	@$(SUDO) echo > $(NULL)

update-man-date: PHONY
	-$(Q) $(BASERUBY) -I"$(tooldir)/lib" -rvcs -i -p \
	-e 'BEGIN{@vcs=VCS.detect(ARGV.shift)}' \
	-e '$$_.sub!(/^(\.Dd ).*/){$$1+@vcs.modified(ARGF.path).strftime("%B %d, %Y")}' \
	"$(srcdir)" "$(srcdir)"/man/*.1

.PHONY: ChangeLog
ChangeLog:
	$(ECHO) Generating $@
	-$(Q) $(BASERUBY) -I"$(tooldir)/lib" -rvcs \
	-e 'VCS.detect(ARGV[0]).export_changelog("@", nil, nil, ARGV[1])' \
	"$(srcdir)" $@

HELP_EXTRA_TASKS = ""

help: PHONY
	$(MESSAGE_BEGIN) \
	"                Makefile of Ruby" \
	"" \
	"targets:" \
	"  all (default):         builds all of below" \
	"  miniruby:              builds only miniruby" \
	"  encs:                  builds encodings" \
	"  exts:                  builds extensions" \
	"  main:                  builds encodings, extensions and ruby" \
	"  docs:                  builds documents" \
	"  install-capi:          builds C API documents" \
	"  run:                   runs test.rb by miniruby" \
	"  runruby:               runs test.rb by ruby you just built" \
	"  gdb:                   runs test.rb by miniruby under gdb" \
	"  gdb-ruby:              runs test.rb by ruby under gdb" \
	"  check:                 equals make test test-tool test-all test-spec" \
	"  test:                  ruby core tests [BTESTS=<bootstraptest files>]" \
	"  test-all:              all ruby tests [TESTOPTS=-j4 TESTS=<test files>]" \
	"  test-spec:             run the Ruby spec suite [SPECOPTS=<specs, opts>]" \
	"  test-bundler:          run the Bundler spec" \
	"  test-bundler-parallel: run the Bundler spec with parallel" \
	"  test-bundled-gems:     run the test suite of bundled gems" \
	"  test-tool:             tests under the tool/test" \
	"  update-gems:           download files of the bundled gems" \
	"  update-bundled_gems:   update the latest version of bundled gems" \
	"  sync-default-gems:     sync default gems from upstream [GEM=<gem_name git_ref>]" \
	"  up:                    update local copy and autogenerated files" \
	"  benchmark:             benchmark this ruby and COMPARE_RUBY." \
	"  gcbench:               gc benchmark [GCBENCH_ITEM=<item_name>]" \
	"  install:               install all ruby distributions" \
	"  install-nodoc:         install without rdoc" \
	"  install-cross:         install cross compiling stuff" \
	"  clean:                 clean for tarball" \
	"  distclean:             clean for repository" \
	"  golf:                  build goruby for golfers" \
	$(HELP_EXTRA_TASKS) \
	"see DeveloperHowto for more detail: " \
	"  https://bugs.ruby-lang.org/projects/ruby/wiki/DeveloperHowto" \
	$(MESSAGE_END)

$(CROSS_COMPILING:yes=)builtin.$(OBJEXT): {$(VPATH)}mini_builtin.c
$(CROSS_COMPILING:yes=)builtin.$(OBJEXT): {$(VPATH)}miniprelude.c

# AUTOGENERATED DEPENDENCIES START
addr2line.$(OBJEXT): {$(VPATH)}addr2line.c
addr2line.$(OBJEXT): {$(VPATH)}addr2line.h
addr2line.$(OBJEXT): {$(VPATH)}assert.h
addr2line.$(OBJEXT): {$(VPATH)}backward/2/assume.h
addr2line.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
addr2line.$(OBJEXT): {$(VPATH)}backward/2/bool.h
addr2line.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
addr2line.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
addr2line.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
addr2line.$(OBJEXT): {$(VPATH)}config.h
addr2line.$(OBJEXT): {$(VPATH)}defines.h
addr2line.$(OBJEXT): {$(VPATH)}internal/assume.h
addr2line.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
addr2line.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
addr2line.$(OBJEXT): {$(VPATH)}internal/attr/const.h
addr2line.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
addr2line.$(OBJEXT): {$(VPATH)}internal/attr/error.h
addr2line.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
addr2line.$(OBJEXT): {$(VPATH)}internal/attr/format.h
addr2line.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
addr2line.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
addr2line.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
addr2line.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
addr2line.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
addr2line.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
addr2line.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
addr2line.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
addr2line.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
addr2line.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
addr2line.$(OBJEXT): {$(VPATH)}internal/cast.h
addr2line.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
addr2line.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
addr2line.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
addr2line.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
addr2line.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
addr2line.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
addr2line.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
addr2line.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
addr2line.$(OBJEXT): {$(VPATH)}internal/config.h
addr2line.$(OBJEXT): {$(VPATH)}internal/dllexport.h
addr2line.$(OBJEXT): {$(VPATH)}internal/dosish.h
addr2line.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
addr2line.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
addr2line.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
addr2line.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
addr2line.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
addr2line.$(OBJEXT): {$(VPATH)}internal/has/extension.h
addr2line.$(OBJEXT): {$(VPATH)}internal/has/feature.h
addr2line.$(OBJEXT): {$(VPATH)}internal/has/warning.h
addr2line.$(OBJEXT): {$(VPATH)}internal/stdalign.h
addr2line.$(OBJEXT): {$(VPATH)}internal/stdbool.h
addr2line.$(OBJEXT): {$(VPATH)}internal/warning_push.h
addr2line.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
addr2line.$(OBJEXT): {$(VPATH)}missing.h
array.$(OBJEXT): $(hdrdir)/ruby/ruby.h
array.$(OBJEXT): $(top_srcdir)/internal/array.h
array.$(OBJEXT): $(top_srcdir)/internal/bignum.h
array.$(OBJEXT): $(top_srcdir)/internal/bits.h
array.$(OBJEXT): $(top_srcdir)/internal/class.h
array.$(OBJEXT): $(top_srcdir)/internal/compar.h
array.$(OBJEXT): $(top_srcdir)/internal/compilers.h
array.$(OBJEXT): $(top_srcdir)/internal/enum.h
array.$(OBJEXT): $(top_srcdir)/internal/fixnum.h
array.$(OBJEXT): $(top_srcdir)/internal/gc.h
array.$(OBJEXT): $(top_srcdir)/internal/hash.h
array.$(OBJEXT): $(top_srcdir)/internal/numeric.h
array.$(OBJEXT): $(top_srcdir)/internal/object.h
array.$(OBJEXT): $(top_srcdir)/internal/proc.h
array.$(OBJEXT): $(top_srcdir)/internal/rational.h
array.$(OBJEXT): $(top_srcdir)/internal/serial.h
array.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
array.$(OBJEXT): $(top_srcdir)/internal/variable.h
array.$(OBJEXT): $(top_srcdir)/internal/vm.h
array.$(OBJEXT): $(top_srcdir)/internal/warnings.h
array.$(OBJEXT): {$(VPATH)}array.c
array.$(OBJEXT): {$(VPATH)}array.rbinc
array.$(OBJEXT): {$(VPATH)}assert.h
array.$(OBJEXT): {$(VPATH)}backward/2/assume.h
array.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
array.$(OBJEXT): {$(VPATH)}backward/2/bool.h
array.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
array.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
array.$(OBJEXT): {$(VPATH)}backward/2/limits.h
array.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
array.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
array.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
array.$(OBJEXT): {$(VPATH)}builtin.h
array.$(OBJEXT): {$(VPATH)}config.h
array.$(OBJEXT): {$(VPATH)}constant.h
array.$(OBJEXT): {$(VPATH)}debug_counter.h
array.$(OBJEXT): {$(VPATH)}defines.h
array.$(OBJEXT): {$(VPATH)}encoding.h
array.$(OBJEXT): {$(VPATH)}id.h
array.$(OBJEXT): {$(VPATH)}id_table.h
array.$(OBJEXT): {$(VPATH)}intern.h
array.$(OBJEXT): {$(VPATH)}internal.h
array.$(OBJEXT): {$(VPATH)}internal/abi.h
array.$(OBJEXT): {$(VPATH)}internal/anyargs.h
array.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
array.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
array.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
array.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
array.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
array.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
array.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
array.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
array.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
array.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
array.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
array.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
array.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
array.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
array.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
array.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
array.$(OBJEXT): {$(VPATH)}internal/assume.h
array.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
array.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
array.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
array.$(OBJEXT): {$(VPATH)}internal/attr/const.h
array.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
array.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
array.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
array.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
array.$(OBJEXT): {$(VPATH)}internal/attr/error.h
array.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
array.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
array.$(OBJEXT): {$(VPATH)}internal/attr/format.h
array.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
array.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
array.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
array.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
array.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
array.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
array.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
array.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
array.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
array.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
array.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
array.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
array.$(OBJEXT): {$(VPATH)}internal/cast.h
array.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
array.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
array.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
array.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
array.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
array.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
array.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
array.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
array.$(OBJEXT): {$(VPATH)}internal/config.h
array.$(OBJEXT): {$(VPATH)}internal/constant_p.h
array.$(OBJEXT): {$(VPATH)}internal/core.h
array.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
array.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
array.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
array.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
array.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
array.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
array.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
array.$(OBJEXT): {$(VPATH)}internal/core/robject.h
array.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
array.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
array.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
array.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
array.$(OBJEXT): {$(VPATH)}internal/ctype.h
array.$(OBJEXT): {$(VPATH)}internal/dllexport.h
array.$(OBJEXT): {$(VPATH)}internal/dosish.h
array.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
array.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
array.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
array.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
array.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
array.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
array.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
array.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
array.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
array.$(OBJEXT): {$(VPATH)}internal/error.h
array.$(OBJEXT): {$(VPATH)}internal/eval.h
array.$(OBJEXT): {$(VPATH)}internal/event.h
array.$(OBJEXT): {$(VPATH)}internal/fl_type.h
array.$(OBJEXT): {$(VPATH)}internal/gc.h
array.$(OBJEXT): {$(VPATH)}internal/glob.h
array.$(OBJEXT): {$(VPATH)}internal/globals.h
array.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
array.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
array.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
array.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
array.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
array.$(OBJEXT): {$(VPATH)}internal/has/extension.h
array.$(OBJEXT): {$(VPATH)}internal/has/feature.h
array.$(OBJEXT): {$(VPATH)}internal/has/warning.h
array.$(OBJEXT): {$(VPATH)}internal/intern/array.h
array.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
array.$(OBJEXT): {$(VPATH)}internal/intern/class.h
array.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
array.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
array.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
array.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
array.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
array.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
array.$(OBJEXT): {$(VPATH)}internal/intern/error.h
array.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
array.$(OBJEXT): {$(VPATH)}internal/intern/file.h
array.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
array.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
array.$(OBJEXT): {$(VPATH)}internal/intern/io.h
array.$(OBJEXT): {$(VPATH)}internal/intern/load.h
array.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
array.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
array.$(OBJEXT): {$(VPATH)}internal/intern/object.h
array.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
array.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
array.$(OBJEXT): {$(VPATH)}internal/intern/process.h
array.$(OBJEXT): {$(VPATH)}internal/intern/random.h
array.$(OBJEXT): {$(VPATH)}internal/intern/range.h
array.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
array.$(OBJEXT): {$(VPATH)}internal/intern/re.h
array.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
array.$(OBJEXT): {$(VPATH)}internal/intern/select.h
array.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
array.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
array.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
array.$(OBJEXT): {$(VPATH)}internal/intern/string.h
array.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
array.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
array.$(OBJEXT): {$(VPATH)}internal/intern/time.h
array.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
array.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
array.$(OBJEXT): {$(VPATH)}internal/interpreter.h
array.$(OBJEXT): {$(VPATH)}internal/iterator.h
array.$(OBJEXT): {$(VPATH)}internal/memory.h
array.$(OBJEXT): {$(VPATH)}internal/method.h
array.$(OBJEXT): {$(VPATH)}internal/module.h
array.$(OBJEXT): {$(VPATH)}internal/newobj.h
array.$(OBJEXT): {$(VPATH)}internal/rgengc.h
array.$(OBJEXT): {$(VPATH)}internal/scan_args.h
array.$(OBJEXT): {$(VPATH)}internal/special_consts.h
array.$(OBJEXT): {$(VPATH)}internal/static_assert.h
array.$(OBJEXT): {$(VPATH)}internal/stdalign.h
array.$(OBJEXT): {$(VPATH)}internal/stdbool.h
array.$(OBJEXT): {$(VPATH)}internal/symbol.h
array.$(OBJEXT): {$(VPATH)}internal/value.h
array.$(OBJEXT): {$(VPATH)}internal/value_type.h
array.$(OBJEXT): {$(VPATH)}internal/variable.h
array.$(OBJEXT): {$(VPATH)}internal/warning_push.h
array.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
array.$(OBJEXT): {$(VPATH)}missing.h
array.$(OBJEXT): {$(VPATH)}onigmo.h
array.$(OBJEXT): {$(VPATH)}oniguruma.h
array.$(OBJEXT): {$(VPATH)}probes.dmyh
array.$(OBJEXT): {$(VPATH)}probes.h
array.$(OBJEXT): {$(VPATH)}ruby_assert.h
array.$(OBJEXT): {$(VPATH)}shape.h
array.$(OBJEXT): {$(VPATH)}st.h
array.$(OBJEXT): {$(VPATH)}subst.h
array.$(OBJEXT): {$(VPATH)}transient_heap.h
array.$(OBJEXT): {$(VPATH)}util.h
ast.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
ast.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
ast.$(OBJEXT): $(CCAN_DIR)/list/list.h
ast.$(OBJEXT): $(CCAN_DIR)/str/str.h
ast.$(OBJEXT): $(hdrdir)/ruby.h
ast.$(OBJEXT): $(hdrdir)/ruby/ruby.h
ast.$(OBJEXT): $(top_srcdir)/internal/array.h
ast.$(OBJEXT): $(top_srcdir)/internal/compilers.h
ast.$(OBJEXT): $(top_srcdir)/internal/gc.h
ast.$(OBJEXT): $(top_srcdir)/internal/imemo.h
ast.$(OBJEXT): $(top_srcdir)/internal/parse.h
ast.$(OBJEXT): $(top_srcdir)/internal/serial.h
ast.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
ast.$(OBJEXT): $(top_srcdir)/internal/symbol.h
ast.$(OBJEXT): $(top_srcdir)/internal/variable.h
ast.$(OBJEXT): $(top_srcdir)/internal/vm.h
ast.$(OBJEXT): $(top_srcdir)/internal/warnings.h
ast.$(OBJEXT): {$(VPATH)}assert.h
ast.$(OBJEXT): {$(VPATH)}ast.c
ast.$(OBJEXT): {$(VPATH)}ast.rbinc
ast.$(OBJEXT): {$(VPATH)}atomic.h
ast.$(OBJEXT): {$(VPATH)}backward/2/assume.h
ast.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
ast.$(OBJEXT): {$(VPATH)}backward/2/bool.h
ast.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
ast.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
ast.$(OBJEXT): {$(VPATH)}backward/2/limits.h
ast.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
ast.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
ast.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
ast.$(OBJEXT): {$(VPATH)}builtin.h
ast.$(OBJEXT): {$(VPATH)}config.h
ast.$(OBJEXT): {$(VPATH)}constant.h
ast.$(OBJEXT): {$(VPATH)}defines.h
ast.$(OBJEXT): {$(VPATH)}encoding.h
ast.$(OBJEXT): {$(VPATH)}id.h
ast.$(OBJEXT): {$(VPATH)}id_table.h
ast.$(OBJEXT): {$(VPATH)}intern.h
ast.$(OBJEXT): {$(VPATH)}internal.h
ast.$(OBJEXT): {$(VPATH)}internal/abi.h
ast.$(OBJEXT): {$(VPATH)}internal/anyargs.h
ast.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
ast.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
ast.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
ast.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
ast.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
ast.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
ast.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
ast.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
ast.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
ast.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
ast.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
ast.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
ast.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
ast.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
ast.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
ast.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
ast.$(OBJEXT): {$(VPATH)}internal/assume.h
ast.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
ast.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
ast.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
ast.$(OBJEXT): {$(VPATH)}internal/attr/const.h
ast.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
ast.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
ast.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
ast.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
ast.$(OBJEXT): {$(VPATH)}internal/attr/error.h
ast.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
ast.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
ast.$(OBJEXT): {$(VPATH)}internal/attr/format.h
ast.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
ast.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
ast.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
ast.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
ast.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
ast.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
ast.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
ast.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
ast.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
ast.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
ast.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
ast.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
ast.$(OBJEXT): {$(VPATH)}internal/cast.h
ast.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
ast.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
ast.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
ast.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
ast.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
ast.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
ast.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
ast.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
ast.$(OBJEXT): {$(VPATH)}internal/config.h
ast.$(OBJEXT): {$(VPATH)}internal/constant_p.h
ast.$(OBJEXT): {$(VPATH)}internal/core.h
ast.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
ast.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
ast.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
ast.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
ast.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
ast.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
ast.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
ast.$(OBJEXT): {$(VPATH)}internal/core/robject.h
ast.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
ast.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
ast.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
ast.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
ast.$(OBJEXT): {$(VPATH)}internal/ctype.h
ast.$(OBJEXT): {$(VPATH)}internal/dllexport.h
ast.$(OBJEXT): {$(VPATH)}internal/dosish.h
ast.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
ast.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
ast.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
ast.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
ast.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
ast.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
ast.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
ast.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
ast.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
ast.$(OBJEXT): {$(VPATH)}internal/error.h
ast.$(OBJEXT): {$(VPATH)}internal/eval.h
ast.$(OBJEXT): {$(VPATH)}internal/event.h
ast.$(OBJEXT): {$(VPATH)}internal/fl_type.h
ast.$(OBJEXT): {$(VPATH)}internal/gc.h
ast.$(OBJEXT): {$(VPATH)}internal/glob.h
ast.$(OBJEXT): {$(VPATH)}internal/globals.h
ast.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
ast.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
ast.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
ast.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
ast.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
ast.$(OBJEXT): {$(VPATH)}internal/has/extension.h
ast.$(OBJEXT): {$(VPATH)}internal/has/feature.h
ast.$(OBJEXT): {$(VPATH)}internal/has/warning.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/array.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/class.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/error.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/file.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/io.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/load.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/object.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/process.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/random.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/range.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/re.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/select.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/string.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/time.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
ast.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
ast.$(OBJEXT): {$(VPATH)}internal/interpreter.h
ast.$(OBJEXT): {$(VPATH)}internal/iterator.h
ast.$(OBJEXT): {$(VPATH)}internal/memory.h
ast.$(OBJEXT): {$(VPATH)}internal/method.h
ast.$(OBJEXT): {$(VPATH)}internal/module.h
ast.$(OBJEXT): {$(VPATH)}internal/newobj.h
ast.$(OBJEXT): {$(VPATH)}internal/rgengc.h
ast.$(OBJEXT): {$(VPATH)}internal/scan_args.h
ast.$(OBJEXT): {$(VPATH)}internal/special_consts.h
ast.$(OBJEXT): {$(VPATH)}internal/static_assert.h
ast.$(OBJEXT): {$(VPATH)}internal/stdalign.h
ast.$(OBJEXT): {$(VPATH)}internal/stdbool.h
ast.$(OBJEXT): {$(VPATH)}internal/symbol.h
ast.$(OBJEXT): {$(VPATH)}internal/value.h
ast.$(OBJEXT): {$(VPATH)}internal/value_type.h
ast.$(OBJEXT): {$(VPATH)}internal/variable.h
ast.$(OBJEXT): {$(VPATH)}internal/warning_push.h
ast.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
ast.$(OBJEXT): {$(VPATH)}iseq.h
ast.$(OBJEXT): {$(VPATH)}method.h
ast.$(OBJEXT): {$(VPATH)}missing.h
ast.$(OBJEXT): {$(VPATH)}node.h
ast.$(OBJEXT): {$(VPATH)}onigmo.h
ast.$(OBJEXT): {$(VPATH)}oniguruma.h
ast.$(OBJEXT): {$(VPATH)}ruby_assert.h
ast.$(OBJEXT): {$(VPATH)}ruby_atomic.h
ast.$(OBJEXT): {$(VPATH)}shape.h
ast.$(OBJEXT): {$(VPATH)}st.h
ast.$(OBJEXT): {$(VPATH)}subst.h
ast.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
ast.$(OBJEXT): {$(VPATH)}thread_native.h
ast.$(OBJEXT): {$(VPATH)}util.h
ast.$(OBJEXT): {$(VPATH)}vm_core.h
ast.$(OBJEXT): {$(VPATH)}vm_opts.h
bignum.$(OBJEXT): $(hdrdir)/ruby/ruby.h
bignum.$(OBJEXT): $(top_srcdir)/internal/bignum.h
bignum.$(OBJEXT): $(top_srcdir)/internal/bits.h
bignum.$(OBJEXT): $(top_srcdir)/internal/class.h
bignum.$(OBJEXT): $(top_srcdir)/internal/compilers.h
bignum.$(OBJEXT): $(top_srcdir)/internal/complex.h
bignum.$(OBJEXT): $(top_srcdir)/internal/fixnum.h
bignum.$(OBJEXT): $(top_srcdir)/internal/gc.h
bignum.$(OBJEXT): $(top_srcdir)/internal/numeric.h
bignum.$(OBJEXT): $(top_srcdir)/internal/object.h
bignum.$(OBJEXT): $(top_srcdir)/internal/sanitizers.h
bignum.$(OBJEXT): $(top_srcdir)/internal/serial.h
bignum.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
bignum.$(OBJEXT): $(top_srcdir)/internal/variable.h
bignum.$(OBJEXT): $(top_srcdir)/internal/vm.h
bignum.$(OBJEXT): $(top_srcdir)/internal/warnings.h
bignum.$(OBJEXT): {$(VPATH)}assert.h
bignum.$(OBJEXT): {$(VPATH)}backward/2/assume.h
bignum.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
bignum.$(OBJEXT): {$(VPATH)}backward/2/bool.h
bignum.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
bignum.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
bignum.$(OBJEXT): {$(VPATH)}backward/2/limits.h
bignum.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
bignum.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
bignum.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
bignum.$(OBJEXT): {$(VPATH)}bignum.c
bignum.$(OBJEXT): {$(VPATH)}config.h
bignum.$(OBJEXT): {$(VPATH)}constant.h
bignum.$(OBJEXT): {$(VPATH)}defines.h
bignum.$(OBJEXT): {$(VPATH)}id.h
bignum.$(OBJEXT): {$(VPATH)}id_table.h
bignum.$(OBJEXT): {$(VPATH)}intern.h
bignum.$(OBJEXT): {$(VPATH)}internal.h
bignum.$(OBJEXT): {$(VPATH)}internal/abi.h
bignum.$(OBJEXT): {$(VPATH)}internal/anyargs.h
bignum.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
bignum.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
bignum.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
bignum.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
bignum.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
bignum.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
bignum.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
bignum.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
bignum.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
bignum.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
bignum.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
bignum.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
bignum.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
bignum.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
bignum.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
bignum.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
bignum.$(OBJEXT): {$(VPATH)}internal/assume.h
bignum.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
bignum.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
bignum.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
bignum.$(OBJEXT): {$(VPATH)}internal/attr/const.h
bignum.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
bignum.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
bignum.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
bignum.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
bignum.$(OBJEXT): {$(VPATH)}internal/attr/error.h
bignum.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
bignum.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
bignum.$(OBJEXT): {$(VPATH)}internal/attr/format.h
bignum.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
bignum.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
bignum.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
bignum.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
bignum.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
bignum.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
bignum.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
bignum.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
bignum.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
bignum.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
bignum.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
bignum.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
bignum.$(OBJEXT): {$(VPATH)}internal/cast.h
bignum.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
bignum.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
bignum.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
bignum.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
bignum.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
bignum.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
bignum.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
bignum.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
bignum.$(OBJEXT): {$(VPATH)}internal/config.h
bignum.$(OBJEXT): {$(VPATH)}internal/constant_p.h
bignum.$(OBJEXT): {$(VPATH)}internal/core.h
bignum.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
bignum.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
bignum.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
bignum.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
bignum.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
bignum.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
bignum.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
bignum.$(OBJEXT): {$(VPATH)}internal/core/robject.h
bignum.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
bignum.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
bignum.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
bignum.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
bignum.$(OBJEXT): {$(VPATH)}internal/ctype.h
bignum.$(OBJEXT): {$(VPATH)}internal/dllexport.h
bignum.$(OBJEXT): {$(VPATH)}internal/dosish.h
bignum.$(OBJEXT): {$(VPATH)}internal/error.h
bignum.$(OBJEXT): {$(VPATH)}internal/eval.h
bignum.$(OBJEXT): {$(VPATH)}internal/event.h
bignum.$(OBJEXT): {$(VPATH)}internal/fl_type.h
bignum.$(OBJEXT): {$(VPATH)}internal/gc.h
bignum.$(OBJEXT): {$(VPATH)}internal/glob.h
bignum.$(OBJEXT): {$(VPATH)}internal/globals.h
bignum.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
bignum.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
bignum.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
bignum.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
bignum.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
bignum.$(OBJEXT): {$(VPATH)}internal/has/extension.h
bignum.$(OBJEXT): {$(VPATH)}internal/has/feature.h
bignum.$(OBJEXT): {$(VPATH)}internal/has/warning.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/array.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/class.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/error.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/file.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/io.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/load.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/object.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/process.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/random.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/range.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/re.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/select.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/string.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/time.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
bignum.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
bignum.$(OBJEXT): {$(VPATH)}internal/interpreter.h
bignum.$(OBJEXT): {$(VPATH)}internal/iterator.h
bignum.$(OBJEXT): {$(VPATH)}internal/memory.h
bignum.$(OBJEXT): {$(VPATH)}internal/method.h
bignum.$(OBJEXT): {$(VPATH)}internal/module.h
bignum.$(OBJEXT): {$(VPATH)}internal/newobj.h
bignum.$(OBJEXT): {$(VPATH)}internal/rgengc.h
bignum.$(OBJEXT): {$(VPATH)}internal/scan_args.h
bignum.$(OBJEXT): {$(VPATH)}internal/special_consts.h
bignum.$(OBJEXT): {$(VPATH)}internal/static_assert.h
bignum.$(OBJEXT): {$(VPATH)}internal/stdalign.h
bignum.$(OBJEXT): {$(VPATH)}internal/stdbool.h
bignum.$(OBJEXT): {$(VPATH)}internal/symbol.h
bignum.$(OBJEXT): {$(VPATH)}internal/value.h
bignum.$(OBJEXT): {$(VPATH)}internal/value_type.h
bignum.$(OBJEXT): {$(VPATH)}internal/variable.h
bignum.$(OBJEXT): {$(VPATH)}internal/warning_push.h
bignum.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
bignum.$(OBJEXT): {$(VPATH)}missing.h
bignum.$(OBJEXT): {$(VPATH)}ruby_assert.h
bignum.$(OBJEXT): {$(VPATH)}shape.h
bignum.$(OBJEXT): {$(VPATH)}st.h
bignum.$(OBJEXT): {$(VPATH)}subst.h
bignum.$(OBJEXT): {$(VPATH)}thread.h
bignum.$(OBJEXT): {$(VPATH)}util.h
builtin.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
builtin.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
builtin.$(OBJEXT): $(CCAN_DIR)/list/list.h
builtin.$(OBJEXT): $(CCAN_DIR)/str/str.h
builtin.$(OBJEXT): $(hdrdir)/ruby/ruby.h
builtin.$(OBJEXT): $(top_srcdir)/internal/array.h
builtin.$(OBJEXT): $(top_srcdir)/internal/compilers.h
builtin.$(OBJEXT): $(top_srcdir)/internal/gc.h
builtin.$(OBJEXT): $(top_srcdir)/internal/imemo.h
builtin.$(OBJEXT): $(top_srcdir)/internal/serial.h
builtin.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
builtin.$(OBJEXT): $(top_srcdir)/internal/variable.h
builtin.$(OBJEXT): $(top_srcdir)/internal/vm.h
builtin.$(OBJEXT): $(top_srcdir)/internal/warnings.h
builtin.$(OBJEXT): {$(VPATH)}assert.h
builtin.$(OBJEXT): {$(VPATH)}atomic.h
builtin.$(OBJEXT): {$(VPATH)}backward/2/assume.h
builtin.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
builtin.$(OBJEXT): {$(VPATH)}backward/2/bool.h
builtin.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
builtin.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
builtin.$(OBJEXT): {$(VPATH)}backward/2/limits.h
builtin.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
builtin.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
builtin.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
builtin.$(OBJEXT): {$(VPATH)}builtin.c
builtin.$(OBJEXT): {$(VPATH)}builtin.h
builtin.$(OBJEXT): {$(VPATH)}builtin_binary.inc
builtin.$(OBJEXT): {$(VPATH)}config.h
builtin.$(OBJEXT): {$(VPATH)}constant.h
builtin.$(OBJEXT): {$(VPATH)}defines.h
builtin.$(OBJEXT): {$(VPATH)}id.h
builtin.$(OBJEXT): {$(VPATH)}id_table.h
builtin.$(OBJEXT): {$(VPATH)}intern.h
builtin.$(OBJEXT): {$(VPATH)}internal.h
builtin.$(OBJEXT): {$(VPATH)}internal/abi.h
builtin.$(OBJEXT): {$(VPATH)}internal/anyargs.h
builtin.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
builtin.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
builtin.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
builtin.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
builtin.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
builtin.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
builtin.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
builtin.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
builtin.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
builtin.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
builtin.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
builtin.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
builtin.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
builtin.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
builtin.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
builtin.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
builtin.$(OBJEXT): {$(VPATH)}internal/assume.h
builtin.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
builtin.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
builtin.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
builtin.$(OBJEXT): {$(VPATH)}internal/attr/const.h
builtin.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
builtin.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
builtin.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
builtin.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
builtin.$(OBJEXT): {$(VPATH)}internal/attr/error.h
builtin.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
builtin.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
builtin.$(OBJEXT): {$(VPATH)}internal/attr/format.h
builtin.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
builtin.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
builtin.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
builtin.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
builtin.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
builtin.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
builtin.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
builtin.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
builtin.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
builtin.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
builtin.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
builtin.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
builtin.$(OBJEXT): {$(VPATH)}internal/cast.h
builtin.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
builtin.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
builtin.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
builtin.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
builtin.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
builtin.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
builtin.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
builtin.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
builtin.$(OBJEXT): {$(VPATH)}internal/config.h
builtin.$(OBJEXT): {$(VPATH)}internal/constant_p.h
builtin.$(OBJEXT): {$(VPATH)}internal/core.h
builtin.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
builtin.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
builtin.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
builtin.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
builtin.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
builtin.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
builtin.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
builtin.$(OBJEXT): {$(VPATH)}internal/core/robject.h
builtin.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
builtin.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
builtin.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
builtin.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
builtin.$(OBJEXT): {$(VPATH)}internal/ctype.h
builtin.$(OBJEXT): {$(VPATH)}internal/dllexport.h
builtin.$(OBJEXT): {$(VPATH)}internal/dosish.h
builtin.$(OBJEXT): {$(VPATH)}internal/error.h
builtin.$(OBJEXT): {$(VPATH)}internal/eval.h
builtin.$(OBJEXT): {$(VPATH)}internal/event.h
builtin.$(OBJEXT): {$(VPATH)}internal/fl_type.h
builtin.$(OBJEXT): {$(VPATH)}internal/gc.h
builtin.$(OBJEXT): {$(VPATH)}internal/glob.h
builtin.$(OBJEXT): {$(VPATH)}internal/globals.h
builtin.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
builtin.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
builtin.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
builtin.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
builtin.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
builtin.$(OBJEXT): {$(VPATH)}internal/has/extension.h
builtin.$(OBJEXT): {$(VPATH)}internal/has/feature.h
builtin.$(OBJEXT): {$(VPATH)}internal/has/warning.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/array.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/class.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/error.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/file.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/io.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/load.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/object.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/process.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/random.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/range.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/re.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/select.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/string.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/time.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
builtin.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
builtin.$(OBJEXT): {$(VPATH)}internal/interpreter.h
builtin.$(OBJEXT): {$(VPATH)}internal/iterator.h
builtin.$(OBJEXT): {$(VPATH)}internal/memory.h
builtin.$(OBJEXT): {$(VPATH)}internal/method.h
builtin.$(OBJEXT): {$(VPATH)}internal/module.h
builtin.$(OBJEXT): {$(VPATH)}internal/newobj.h
builtin.$(OBJEXT): {$(VPATH)}internal/rgengc.h
builtin.$(OBJEXT): {$(VPATH)}internal/scan_args.h
builtin.$(OBJEXT): {$(VPATH)}internal/special_consts.h
builtin.$(OBJEXT): {$(VPATH)}internal/static_assert.h
builtin.$(OBJEXT): {$(VPATH)}internal/stdalign.h
builtin.$(OBJEXT): {$(VPATH)}internal/stdbool.h
builtin.$(OBJEXT): {$(VPATH)}internal/symbol.h
builtin.$(OBJEXT): {$(VPATH)}internal/value.h
builtin.$(OBJEXT): {$(VPATH)}internal/value_type.h
builtin.$(OBJEXT): {$(VPATH)}internal/variable.h
builtin.$(OBJEXT): {$(VPATH)}internal/warning_push.h
builtin.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
builtin.$(OBJEXT): {$(VPATH)}iseq.h
builtin.$(OBJEXT): {$(VPATH)}method.h
builtin.$(OBJEXT): {$(VPATH)}missing.h
builtin.$(OBJEXT): {$(VPATH)}node.h
builtin.$(OBJEXT): {$(VPATH)}ruby_assert.h
builtin.$(OBJEXT): {$(VPATH)}ruby_atomic.h
builtin.$(OBJEXT): {$(VPATH)}shape.h
builtin.$(OBJEXT): {$(VPATH)}st.h
builtin.$(OBJEXT): {$(VPATH)}subst.h
builtin.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
builtin.$(OBJEXT): {$(VPATH)}thread_native.h
builtin.$(OBJEXT): {$(VPATH)}vm_core.h
builtin.$(OBJEXT): {$(VPATH)}vm_opts.h
class.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
class.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
class.$(OBJEXT): $(CCAN_DIR)/list/list.h
class.$(OBJEXT): $(CCAN_DIR)/str/str.h
class.$(OBJEXT): $(hdrdir)/ruby/ruby.h
class.$(OBJEXT): $(top_srcdir)/internal/array.h
class.$(OBJEXT): $(top_srcdir)/internal/class.h
class.$(OBJEXT): $(top_srcdir)/internal/compilers.h
class.$(OBJEXT): $(top_srcdir)/internal/eval.h
class.$(OBJEXT): $(top_srcdir)/internal/gc.h
class.$(OBJEXT): $(top_srcdir)/internal/hash.h
class.$(OBJEXT): $(top_srcdir)/internal/imemo.h
class.$(OBJEXT): $(top_srcdir)/internal/object.h
class.$(OBJEXT): $(top_srcdir)/internal/serial.h
class.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
class.$(OBJEXT): $(top_srcdir)/internal/string.h
class.$(OBJEXT): $(top_srcdir)/internal/variable.h
class.$(OBJEXT): $(top_srcdir)/internal/vm.h
class.$(OBJEXT): $(top_srcdir)/internal/warnings.h
class.$(OBJEXT): {$(VPATH)}assert.h
class.$(OBJEXT): {$(VPATH)}atomic.h
class.$(OBJEXT): {$(VPATH)}backward/2/assume.h
class.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
class.$(OBJEXT): {$(VPATH)}backward/2/bool.h
class.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
class.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
class.$(OBJEXT): {$(VPATH)}backward/2/limits.h
class.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
class.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
class.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
class.$(OBJEXT): {$(VPATH)}class.c
class.$(OBJEXT): {$(VPATH)}config.h
class.$(OBJEXT): {$(VPATH)}constant.h
class.$(OBJEXT): {$(VPATH)}debug_counter.h
class.$(OBJEXT): {$(VPATH)}defines.h
class.$(OBJEXT): {$(VPATH)}encoding.h
class.$(OBJEXT): {$(VPATH)}id.h
class.$(OBJEXT): {$(VPATH)}id_table.h
class.$(OBJEXT): {$(VPATH)}intern.h
class.$(OBJEXT): {$(VPATH)}internal.h
class.$(OBJEXT): {$(VPATH)}internal/abi.h
class.$(OBJEXT): {$(VPATH)}internal/anyargs.h
class.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
class.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
class.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
class.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
class.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
class.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
class.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
class.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
class.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
class.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
class.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
class.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
class.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
class.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
class.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
class.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
class.$(OBJEXT): {$(VPATH)}internal/assume.h
class.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
class.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
class.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
class.$(OBJEXT): {$(VPATH)}internal/attr/const.h
class.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
class.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
class.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
class.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
class.$(OBJEXT): {$(VPATH)}internal/attr/error.h
class.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
class.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
class.$(OBJEXT): {$(VPATH)}internal/attr/format.h
class.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
class.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
class.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
class.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
class.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
class.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
class.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
class.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
class.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
class.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
class.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
class.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
class.$(OBJEXT): {$(VPATH)}internal/cast.h
class.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
class.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
class.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
class.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
class.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
class.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
class.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
class.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
class.$(OBJEXT): {$(VPATH)}internal/config.h
class.$(OBJEXT): {$(VPATH)}internal/constant_p.h
class.$(OBJEXT): {$(VPATH)}internal/core.h
class.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
class.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
class.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
class.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
class.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
class.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
class.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
class.$(OBJEXT): {$(VPATH)}internal/core/robject.h
class.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
class.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
class.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
class.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
class.$(OBJEXT): {$(VPATH)}internal/ctype.h
class.$(OBJEXT): {$(VPATH)}internal/dllexport.h
class.$(OBJEXT): {$(VPATH)}internal/dosish.h
class.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
class.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
class.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
class.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
class.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
class.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
class.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
class.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
class.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
class.$(OBJEXT): {$(VPATH)}internal/error.h
class.$(OBJEXT): {$(VPATH)}internal/eval.h
class.$(OBJEXT): {$(VPATH)}internal/event.h
class.$(OBJEXT): {$(VPATH)}internal/fl_type.h
class.$(OBJEXT): {$(VPATH)}internal/gc.h
class.$(OBJEXT): {$(VPATH)}internal/glob.h
class.$(OBJEXT): {$(VPATH)}internal/globals.h
class.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
class.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
class.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
class.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
class.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
class.$(OBJEXT): {$(VPATH)}internal/has/extension.h
class.$(OBJEXT): {$(VPATH)}internal/has/feature.h
class.$(OBJEXT): {$(VPATH)}internal/has/warning.h
class.$(OBJEXT): {$(VPATH)}internal/intern/array.h
class.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
class.$(OBJEXT): {$(VPATH)}internal/intern/class.h
class.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
class.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
class.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
class.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
class.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
class.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
class.$(OBJEXT): {$(VPATH)}internal/intern/error.h
class.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
class.$(OBJEXT): {$(VPATH)}internal/intern/file.h
class.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
class.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
class.$(OBJEXT): {$(VPATH)}internal/intern/io.h
class.$(OBJEXT): {$(VPATH)}internal/intern/load.h
class.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
class.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
class.$(OBJEXT): {$(VPATH)}internal/intern/object.h
class.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
class.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
class.$(OBJEXT): {$(VPATH)}internal/intern/process.h
class.$(OBJEXT): {$(VPATH)}internal/intern/random.h
class.$(OBJEXT): {$(VPATH)}internal/intern/range.h
class.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
class.$(OBJEXT): {$(VPATH)}internal/intern/re.h
class.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
class.$(OBJEXT): {$(VPATH)}internal/intern/select.h
class.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
class.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
class.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
class.$(OBJEXT): {$(VPATH)}internal/intern/string.h
class.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
class.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
class.$(OBJEXT): {$(VPATH)}internal/intern/time.h
class.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
class.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
class.$(OBJEXT): {$(VPATH)}internal/interpreter.h
class.$(OBJEXT): {$(VPATH)}internal/iterator.h
class.$(OBJEXT): {$(VPATH)}internal/memory.h
class.$(OBJEXT): {$(VPATH)}internal/method.h
class.$(OBJEXT): {$(VPATH)}internal/module.h
class.$(OBJEXT): {$(VPATH)}internal/newobj.h
class.$(OBJEXT): {$(VPATH)}internal/rgengc.h
class.$(OBJEXT): {$(VPATH)}internal/scan_args.h
class.$(OBJEXT): {$(VPATH)}internal/special_consts.h
class.$(OBJEXT): {$(VPATH)}internal/static_assert.h
class.$(OBJEXT): {$(VPATH)}internal/stdalign.h
class.$(OBJEXT): {$(VPATH)}internal/stdbool.h
class.$(OBJEXT): {$(VPATH)}internal/symbol.h
class.$(OBJEXT): {$(VPATH)}internal/value.h
class.$(OBJEXT): {$(VPATH)}internal/value_type.h
class.$(OBJEXT): {$(VPATH)}internal/variable.h
class.$(OBJEXT): {$(VPATH)}internal/warning_push.h
class.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
class.$(OBJEXT): {$(VPATH)}method.h
class.$(OBJEXT): {$(VPATH)}missing.h
class.$(OBJEXT): {$(VPATH)}node.h
class.$(OBJEXT): {$(VPATH)}onigmo.h
class.$(OBJEXT): {$(VPATH)}oniguruma.h
class.$(OBJEXT): {$(VPATH)}ruby_assert.h
class.$(OBJEXT): {$(VPATH)}ruby_atomic.h
class.$(OBJEXT): {$(VPATH)}shape.h
class.$(OBJEXT): {$(VPATH)}st.h
class.$(OBJEXT): {$(VPATH)}subst.h
class.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
class.$(OBJEXT): {$(VPATH)}thread_native.h
class.$(OBJEXT): {$(VPATH)}vm_core.h
class.$(OBJEXT): {$(VPATH)}vm_opts.h
compar.$(OBJEXT): $(hdrdir)/ruby/ruby.h
compar.$(OBJEXT): $(top_srcdir)/internal/compar.h
compar.$(OBJEXT): $(top_srcdir)/internal/compilers.h
compar.$(OBJEXT): $(top_srcdir)/internal/error.h
compar.$(OBJEXT): $(top_srcdir)/internal/serial.h
compar.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
compar.$(OBJEXT): $(top_srcdir)/internal/string.h
compar.$(OBJEXT): $(top_srcdir)/internal/vm.h
compar.$(OBJEXT): {$(VPATH)}assert.h
compar.$(OBJEXT): {$(VPATH)}backward/2/assume.h
compar.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
compar.$(OBJEXT): {$(VPATH)}backward/2/bool.h
compar.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
compar.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
compar.$(OBJEXT): {$(VPATH)}backward/2/limits.h
compar.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
compar.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
compar.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
compar.$(OBJEXT): {$(VPATH)}compar.c
compar.$(OBJEXT): {$(VPATH)}config.h
compar.$(OBJEXT): {$(VPATH)}defines.h
compar.$(OBJEXT): {$(VPATH)}encoding.h
compar.$(OBJEXT): {$(VPATH)}id.h
compar.$(OBJEXT): {$(VPATH)}intern.h
compar.$(OBJEXT): {$(VPATH)}internal.h
compar.$(OBJEXT): {$(VPATH)}internal/abi.h
compar.$(OBJEXT): {$(VPATH)}internal/anyargs.h
compar.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
compar.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
compar.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
compar.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
compar.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
compar.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
compar.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
compar.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
compar.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
compar.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
compar.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
compar.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
compar.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
compar.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
compar.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
compar.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
compar.$(OBJEXT): {$(VPATH)}internal/assume.h
compar.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
compar.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
compar.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
compar.$(OBJEXT): {$(VPATH)}internal/attr/const.h
compar.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
compar.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
compar.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
compar.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
compar.$(OBJEXT): {$(VPATH)}internal/attr/error.h
compar.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
compar.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
compar.$(OBJEXT): {$(VPATH)}internal/attr/format.h
compar.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
compar.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
compar.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
compar.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
compar.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
compar.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
compar.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
compar.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
compar.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
compar.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
compar.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
compar.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
compar.$(OBJEXT): {$(VPATH)}internal/cast.h
compar.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
compar.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
compar.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
compar.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
compar.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
compar.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
compar.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
compar.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
compar.$(OBJEXT): {$(VPATH)}internal/config.h
compar.$(OBJEXT): {$(VPATH)}internal/constant_p.h
compar.$(OBJEXT): {$(VPATH)}internal/core.h
compar.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
compar.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
compar.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
compar.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
compar.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
compar.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
compar.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
compar.$(OBJEXT): {$(VPATH)}internal/core/robject.h
compar.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
compar.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
compar.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
compar.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
compar.$(OBJEXT): {$(VPATH)}internal/ctype.h
compar.$(OBJEXT): {$(VPATH)}internal/dllexport.h
compar.$(OBJEXT): {$(VPATH)}internal/dosish.h
compar.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
compar.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
compar.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
compar.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
compar.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
compar.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
compar.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
compar.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
compar.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
compar.$(OBJEXT): {$(VPATH)}internal/error.h
compar.$(OBJEXT): {$(VPATH)}internal/eval.h
compar.$(OBJEXT): {$(VPATH)}internal/event.h
compar.$(OBJEXT): {$(VPATH)}internal/fl_type.h
compar.$(OBJEXT): {$(VPATH)}internal/gc.h
compar.$(OBJEXT): {$(VPATH)}internal/glob.h
compar.$(OBJEXT): {$(VPATH)}internal/globals.h
compar.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
compar.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
compar.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
compar.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
compar.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
compar.$(OBJEXT): {$(VPATH)}internal/has/extension.h
compar.$(OBJEXT): {$(VPATH)}internal/has/feature.h
compar.$(OBJEXT): {$(VPATH)}internal/has/warning.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/array.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/class.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/error.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/file.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/io.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/load.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/object.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/process.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/random.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/range.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/re.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/select.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/string.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/time.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
compar.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
compar.$(OBJEXT): {$(VPATH)}internal/interpreter.h
compar.$(OBJEXT): {$(VPATH)}internal/iterator.h
compar.$(OBJEXT): {$(VPATH)}internal/memory.h
compar.$(OBJEXT): {$(VPATH)}internal/method.h
compar.$(OBJEXT): {$(VPATH)}internal/module.h
compar.$(OBJEXT): {$(VPATH)}internal/newobj.h
compar.$(OBJEXT): {$(VPATH)}internal/rgengc.h
compar.$(OBJEXT): {$(VPATH)}internal/scan_args.h
compar.$(OBJEXT): {$(VPATH)}internal/special_consts.h
compar.$(OBJEXT): {$(VPATH)}internal/static_assert.h
compar.$(OBJEXT): {$(VPATH)}internal/stdalign.h
compar.$(OBJEXT): {$(VPATH)}internal/stdbool.h
compar.$(OBJEXT): {$(VPATH)}internal/symbol.h
compar.$(OBJEXT): {$(VPATH)}internal/value.h
compar.$(OBJEXT): {$(VPATH)}internal/value_type.h
compar.$(OBJEXT): {$(VPATH)}internal/variable.h
compar.$(OBJEXT): {$(VPATH)}internal/warning_push.h
compar.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
compar.$(OBJEXT): {$(VPATH)}missing.h
compar.$(OBJEXT): {$(VPATH)}onigmo.h
compar.$(OBJEXT): {$(VPATH)}oniguruma.h
compar.$(OBJEXT): {$(VPATH)}st.h
compar.$(OBJEXT): {$(VPATH)}subst.h
compile.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
compile.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
compile.$(OBJEXT): $(CCAN_DIR)/list/list.h
compile.$(OBJEXT): $(CCAN_DIR)/str/str.h
compile.$(OBJEXT): $(hdrdir)/ruby/ruby.h
compile.$(OBJEXT): $(top_srcdir)/internal/array.h
compile.$(OBJEXT): $(top_srcdir)/internal/bignum.h
compile.$(OBJEXT): $(top_srcdir)/internal/bits.h
compile.$(OBJEXT): $(top_srcdir)/internal/class.h
compile.$(OBJEXT): $(top_srcdir)/internal/compile.h
compile.$(OBJEXT): $(top_srcdir)/internal/compilers.h
compile.$(OBJEXT): $(top_srcdir)/internal/complex.h
compile.$(OBJEXT): $(top_srcdir)/internal/encoding.h
compile.$(OBJEXT): $(top_srcdir)/internal/error.h
compile.$(OBJEXT): $(top_srcdir)/internal/fixnum.h
compile.$(OBJEXT): $(top_srcdir)/internal/gc.h
compile.$(OBJEXT): $(top_srcdir)/internal/hash.h
compile.$(OBJEXT): $(top_srcdir)/internal/imemo.h
compile.$(OBJEXT): $(top_srcdir)/internal/numeric.h
compile.$(OBJEXT): $(top_srcdir)/internal/object.h
compile.$(OBJEXT): $(top_srcdir)/internal/rational.h
compile.$(OBJEXT): $(top_srcdir)/internal/re.h
compile.$(OBJEXT): $(top_srcdir)/internal/serial.h
compile.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
compile.$(OBJEXT): $(top_srcdir)/internal/string.h
compile.$(OBJEXT): $(top_srcdir)/internal/symbol.h
compile.$(OBJEXT): $(top_srcdir)/internal/thread.h
compile.$(OBJEXT): $(top_srcdir)/internal/variable.h
compile.$(OBJEXT): $(top_srcdir)/internal/vm.h
compile.$(OBJEXT): $(top_srcdir)/internal/warnings.h
compile.$(OBJEXT): {$(VPATH)}assert.h
compile.$(OBJEXT): {$(VPATH)}atomic.h
compile.$(OBJEXT): {$(VPATH)}backward/2/assume.h
compile.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
compile.$(OBJEXT): {$(VPATH)}backward/2/bool.h
compile.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
compile.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
compile.$(OBJEXT): {$(VPATH)}backward/2/limits.h
compile.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
compile.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
compile.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
compile.$(OBJEXT): {$(VPATH)}builtin.h
compile.$(OBJEXT): {$(VPATH)}compile.c
compile.$(OBJEXT): {$(VPATH)}config.h
compile.$(OBJEXT): {$(VPATH)}constant.h
compile.$(OBJEXT): {$(VPATH)}debug_counter.h
compile.$(OBJEXT): {$(VPATH)}defines.h
compile.$(OBJEXT): {$(VPATH)}encindex.h
compile.$(OBJEXT): {$(VPATH)}encoding.h
compile.$(OBJEXT): {$(VPATH)}gc.h
compile.$(OBJEXT): {$(VPATH)}id.h
compile.$(OBJEXT): {$(VPATH)}id_table.h
compile.$(OBJEXT): {$(VPATH)}insns.def
compile.$(OBJEXT): {$(VPATH)}insns.inc
compile.$(OBJEXT): {$(VPATH)}insns_info.inc
compile.$(OBJEXT): {$(VPATH)}intern.h
compile.$(OBJEXT): {$(VPATH)}internal.h
compile.$(OBJEXT): {$(VPATH)}internal/abi.h
compile.$(OBJEXT): {$(VPATH)}internal/anyargs.h
compile.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
compile.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
compile.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
compile.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
compile.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
compile.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
compile.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
compile.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
compile.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
compile.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
compile.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
compile.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
compile.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
compile.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
compile.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
compile.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
compile.$(OBJEXT): {$(VPATH)}internal/assume.h
compile.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
compile.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
compile.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
compile.$(OBJEXT): {$(VPATH)}internal/attr/const.h
compile.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
compile.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
compile.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
compile.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
compile.$(OBJEXT): {$(VPATH)}internal/attr/error.h
compile.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
compile.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
compile.$(OBJEXT): {$(VPATH)}internal/attr/format.h
compile.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
compile.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
compile.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
compile.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
compile.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
compile.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
compile.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
compile.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
compile.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
compile.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
compile.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
compile.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
compile.$(OBJEXT): {$(VPATH)}internal/cast.h
compile.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
compile.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
compile.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
compile.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
compile.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
compile.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
compile.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
compile.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
compile.$(OBJEXT): {$(VPATH)}internal/config.h
compile.$(OBJEXT): {$(VPATH)}internal/constant_p.h
compile.$(OBJEXT): {$(VPATH)}internal/core.h
compile.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
compile.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
compile.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
compile.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
compile.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
compile.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
compile.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
compile.$(OBJEXT): {$(VPATH)}internal/core/rmatch.h
compile.$(OBJEXT): {$(VPATH)}internal/core/robject.h
compile.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
compile.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
compile.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
compile.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
compile.$(OBJEXT): {$(VPATH)}internal/ctype.h
compile.$(OBJEXT): {$(VPATH)}internal/dllexport.h
compile.$(OBJEXT): {$(VPATH)}internal/dosish.h
compile.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
compile.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
compile.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
compile.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
compile.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
compile.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
compile.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
compile.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
compile.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
compile.$(OBJEXT): {$(VPATH)}internal/error.h
compile.$(OBJEXT): {$(VPATH)}internal/eval.h
compile.$(OBJEXT): {$(VPATH)}internal/event.h
compile.$(OBJEXT): {$(VPATH)}internal/fl_type.h
compile.$(OBJEXT): {$(VPATH)}internal/gc.h
compile.$(OBJEXT): {$(VPATH)}internal/glob.h
compile.$(OBJEXT): {$(VPATH)}internal/globals.h
compile.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
compile.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
compile.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
compile.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
compile.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
compile.$(OBJEXT): {$(VPATH)}internal/has/extension.h
compile.$(OBJEXT): {$(VPATH)}internal/has/feature.h
compile.$(OBJEXT): {$(VPATH)}internal/has/warning.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/array.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/class.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/error.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/file.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/io.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/load.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/object.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/process.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/random.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/range.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/re.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/select.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/string.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/time.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
compile.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
compile.$(OBJEXT): {$(VPATH)}internal/interpreter.h
compile.$(OBJEXT): {$(VPATH)}internal/iterator.h
compile.$(OBJEXT): {$(VPATH)}internal/memory.h
compile.$(OBJEXT): {$(VPATH)}internal/method.h
compile.$(OBJEXT): {$(VPATH)}internal/module.h
compile.$(OBJEXT): {$(VPATH)}internal/newobj.h
compile.$(OBJEXT): {$(VPATH)}internal/rgengc.h
compile.$(OBJEXT): {$(VPATH)}internal/scan_args.h
compile.$(OBJEXT): {$(VPATH)}internal/special_consts.h
compile.$(OBJEXT): {$(VPATH)}internal/static_assert.h
compile.$(OBJEXT): {$(VPATH)}internal/stdalign.h
compile.$(OBJEXT): {$(VPATH)}internal/stdbool.h
compile.$(OBJEXT): {$(VPATH)}internal/symbol.h
compile.$(OBJEXT): {$(VPATH)}internal/value.h
compile.$(OBJEXT): {$(VPATH)}internal/value_type.h
compile.$(OBJEXT): {$(VPATH)}internal/variable.h
compile.$(OBJEXT): {$(VPATH)}internal/warning_push.h
compile.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
compile.$(OBJEXT): {$(VPATH)}iseq.h
compile.$(OBJEXT): {$(VPATH)}method.h
compile.$(OBJEXT): {$(VPATH)}missing.h
compile.$(OBJEXT): {$(VPATH)}node.h
compile.$(OBJEXT): {$(VPATH)}onigmo.h
compile.$(OBJEXT): {$(VPATH)}oniguruma.h
compile.$(OBJEXT): {$(VPATH)}optinsn.inc
compile.$(OBJEXT): {$(VPATH)}re.h
compile.$(OBJEXT): {$(VPATH)}regex.h
compile.$(OBJEXT): {$(VPATH)}ruby_assert.h
compile.$(OBJEXT): {$(VPATH)}ruby_atomic.h
compile.$(OBJEXT): {$(VPATH)}shape.h
compile.$(OBJEXT): {$(VPATH)}st.h
compile.$(OBJEXT): {$(VPATH)}subst.h
compile.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
compile.$(OBJEXT): {$(VPATH)}thread_native.h
compile.$(OBJEXT): {$(VPATH)}util.h
compile.$(OBJEXT): {$(VPATH)}vm_callinfo.h
compile.$(OBJEXT): {$(VPATH)}vm_core.h
compile.$(OBJEXT): {$(VPATH)}vm_debug.h
compile.$(OBJEXT): {$(VPATH)}vm_opts.h
complex.$(OBJEXT): $(hdrdir)/ruby/ruby.h
complex.$(OBJEXT): $(top_srcdir)/internal/array.h
complex.$(OBJEXT): $(top_srcdir)/internal/bignum.h
complex.$(OBJEXT): $(top_srcdir)/internal/bits.h
complex.$(OBJEXT): $(top_srcdir)/internal/class.h
complex.$(OBJEXT): $(top_srcdir)/internal/compilers.h
complex.$(OBJEXT): $(top_srcdir)/internal/complex.h
complex.$(OBJEXT): $(top_srcdir)/internal/fixnum.h
complex.$(OBJEXT): $(top_srcdir)/internal/gc.h
complex.$(OBJEXT): $(top_srcdir)/internal/math.h
complex.$(OBJEXT): $(top_srcdir)/internal/numeric.h
complex.$(OBJEXT): $(top_srcdir)/internal/object.h
complex.$(OBJEXT): $(top_srcdir)/internal/rational.h
complex.$(OBJEXT): $(top_srcdir)/internal/serial.h
complex.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
complex.$(OBJEXT): $(top_srcdir)/internal/variable.h
complex.$(OBJEXT): $(top_srcdir)/internal/vm.h
complex.$(OBJEXT): $(top_srcdir)/internal/warnings.h
complex.$(OBJEXT): {$(VPATH)}assert.h
complex.$(OBJEXT): {$(VPATH)}backward/2/assume.h
complex.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
complex.$(OBJEXT): {$(VPATH)}backward/2/bool.h
complex.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
complex.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
complex.$(OBJEXT): {$(VPATH)}backward/2/limits.h
complex.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
complex.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
complex.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
complex.$(OBJEXT): {$(VPATH)}complex.c
complex.$(OBJEXT): {$(VPATH)}config.h
complex.$(OBJEXT): {$(VPATH)}constant.h
complex.$(OBJEXT): {$(VPATH)}defines.h
complex.$(OBJEXT): {$(VPATH)}id.h
complex.$(OBJEXT): {$(VPATH)}id_table.h
complex.$(OBJEXT): {$(VPATH)}intern.h
complex.$(OBJEXT): {$(VPATH)}internal.h
complex.$(OBJEXT): {$(VPATH)}internal/abi.h
complex.$(OBJEXT): {$(VPATH)}internal/anyargs.h
complex.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
complex.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
complex.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
complex.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
complex.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
complex.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
complex.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
complex.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
complex.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
complex.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
complex.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
complex.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
complex.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
complex.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
complex.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
complex.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
complex.$(OBJEXT): {$(VPATH)}internal/assume.h
complex.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
complex.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
complex.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
complex.$(OBJEXT): {$(VPATH)}internal/attr/const.h
complex.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
complex.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
complex.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
complex.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
complex.$(OBJEXT): {$(VPATH)}internal/attr/error.h
complex.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
complex.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
complex.$(OBJEXT): {$(VPATH)}internal/attr/format.h
complex.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
complex.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
complex.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
complex.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
complex.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
complex.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
complex.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
complex.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
complex.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
complex.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
complex.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
complex.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
complex.$(OBJEXT): {$(VPATH)}internal/cast.h
complex.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
complex.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
complex.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
complex.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
complex.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
complex.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
complex.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
complex.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
complex.$(OBJEXT): {$(VPATH)}internal/config.h
complex.$(OBJEXT): {$(VPATH)}internal/constant_p.h
complex.$(OBJEXT): {$(VPATH)}internal/core.h
complex.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
complex.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
complex.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
complex.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
complex.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
complex.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
complex.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
complex.$(OBJEXT): {$(VPATH)}internal/core/robject.h
complex.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
complex.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
complex.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
complex.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
complex.$(OBJEXT): {$(VPATH)}internal/ctype.h
complex.$(OBJEXT): {$(VPATH)}internal/dllexport.h
complex.$(OBJEXT): {$(VPATH)}internal/dosish.h
complex.$(OBJEXT): {$(VPATH)}internal/error.h
complex.$(OBJEXT): {$(VPATH)}internal/eval.h
complex.$(OBJEXT): {$(VPATH)}internal/event.h
complex.$(OBJEXT): {$(VPATH)}internal/fl_type.h
complex.$(OBJEXT): {$(VPATH)}internal/gc.h
complex.$(OBJEXT): {$(VPATH)}internal/glob.h
complex.$(OBJEXT): {$(VPATH)}internal/globals.h
complex.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
complex.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
complex.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
complex.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
complex.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
complex.$(OBJEXT): {$(VPATH)}internal/has/extension.h
complex.$(OBJEXT): {$(VPATH)}internal/has/feature.h
complex.$(OBJEXT): {$(VPATH)}internal/has/warning.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/array.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/class.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/error.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/file.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/io.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/load.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/object.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/process.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/random.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/range.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/re.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/select.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/string.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/time.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
complex.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
complex.$(OBJEXT): {$(VPATH)}internal/interpreter.h
complex.$(OBJEXT): {$(VPATH)}internal/iterator.h
complex.$(OBJEXT): {$(VPATH)}internal/memory.h
complex.$(OBJEXT): {$(VPATH)}internal/method.h
complex.$(OBJEXT): {$(VPATH)}internal/module.h
complex.$(OBJEXT): {$(VPATH)}internal/newobj.h
complex.$(OBJEXT): {$(VPATH)}internal/rgengc.h
complex.$(OBJEXT): {$(VPATH)}internal/scan_args.h
complex.$(OBJEXT): {$(VPATH)}internal/special_consts.h
complex.$(OBJEXT): {$(VPATH)}internal/static_assert.h
complex.$(OBJEXT): {$(VPATH)}internal/stdalign.h
complex.$(OBJEXT): {$(VPATH)}internal/stdbool.h
complex.$(OBJEXT): {$(VPATH)}internal/symbol.h
complex.$(OBJEXT): {$(VPATH)}internal/value.h
complex.$(OBJEXT): {$(VPATH)}internal/value_type.h
complex.$(OBJEXT): {$(VPATH)}internal/variable.h
complex.$(OBJEXT): {$(VPATH)}internal/warning_push.h
complex.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
complex.$(OBJEXT): {$(VPATH)}missing.h
complex.$(OBJEXT): {$(VPATH)}ruby_assert.h
complex.$(OBJEXT): {$(VPATH)}shape.h
complex.$(OBJEXT): {$(VPATH)}st.h
complex.$(OBJEXT): {$(VPATH)}subst.h
cont.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
cont.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
cont.$(OBJEXT): $(CCAN_DIR)/list/list.h
cont.$(OBJEXT): $(CCAN_DIR)/str/str.h
cont.$(OBJEXT): $(hdrdir)/ruby.h
cont.$(OBJEXT): $(hdrdir)/ruby/ruby.h
cont.$(OBJEXT): $(top_srcdir)/internal/array.h
cont.$(OBJEXT): $(top_srcdir)/internal/compilers.h
cont.$(OBJEXT): $(top_srcdir)/internal/cont.h
cont.$(OBJEXT): $(top_srcdir)/internal/gc.h
cont.$(OBJEXT): $(top_srcdir)/internal/imemo.h
cont.$(OBJEXT): $(top_srcdir)/internal/proc.h
cont.$(OBJEXT): $(top_srcdir)/internal/sanitizers.h
cont.$(OBJEXT): $(top_srcdir)/internal/serial.h
cont.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
cont.$(OBJEXT): $(top_srcdir)/internal/variable.h
cont.$(OBJEXT): $(top_srcdir)/internal/vm.h
cont.$(OBJEXT): $(top_srcdir)/internal/warnings.h
cont.$(OBJEXT): {$(VPATH)}$(COROUTINE_H)
cont.$(OBJEXT): {$(VPATH)}assert.h
cont.$(OBJEXT): {$(VPATH)}atomic.h
cont.$(OBJEXT): {$(VPATH)}backward/2/assume.h
cont.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
cont.$(OBJEXT): {$(VPATH)}backward/2/bool.h
cont.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
cont.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
cont.$(OBJEXT): {$(VPATH)}backward/2/limits.h
cont.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
cont.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
cont.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
cont.$(OBJEXT): {$(VPATH)}config.h
cont.$(OBJEXT): {$(VPATH)}constant.h
cont.$(OBJEXT): {$(VPATH)}cont.c
cont.$(OBJEXT): {$(VPATH)}debug_counter.h
cont.$(OBJEXT): {$(VPATH)}defines.h
cont.$(OBJEXT): {$(VPATH)}eval_intern.h
cont.$(OBJEXT): {$(VPATH)}fiber/scheduler.h
cont.$(OBJEXT): {$(VPATH)}gc.h
cont.$(OBJEXT): {$(VPATH)}id.h
cont.$(OBJEXT): {$(VPATH)}id_table.h
cont.$(OBJEXT): {$(VPATH)}intern.h
cont.$(OBJEXT): {$(VPATH)}internal.h
cont.$(OBJEXT): {$(VPATH)}internal/abi.h
cont.$(OBJEXT): {$(VPATH)}internal/anyargs.h
cont.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
cont.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
cont.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
cont.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
cont.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
cont.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
cont.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
cont.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
cont.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
cont.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
cont.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
cont.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
cont.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
cont.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
cont.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
cont.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
cont.$(OBJEXT): {$(VPATH)}internal/assume.h
cont.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
cont.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
cont.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
cont.$(OBJEXT): {$(VPATH)}internal/attr/const.h
cont.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
cont.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
cont.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
cont.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
cont.$(OBJEXT): {$(VPATH)}internal/attr/error.h
cont.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
cont.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
cont.$(OBJEXT): {$(VPATH)}internal/attr/format.h
cont.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
cont.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
cont.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
cont.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
cont.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
cont.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
cont.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
cont.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
cont.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
cont.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
cont.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
cont.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
cont.$(OBJEXT): {$(VPATH)}internal/cast.h
cont.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
cont.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
cont.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
cont.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
cont.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
cont.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
cont.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
cont.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
cont.$(OBJEXT): {$(VPATH)}internal/config.h
cont.$(OBJEXT): {$(VPATH)}internal/constant_p.h
cont.$(OBJEXT): {$(VPATH)}internal/core.h
cont.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
cont.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
cont.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
cont.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
cont.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
cont.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
cont.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
cont.$(OBJEXT): {$(VPATH)}internal/core/robject.h
cont.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
cont.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
cont.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
cont.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
cont.$(OBJEXT): {$(VPATH)}internal/ctype.h
cont.$(OBJEXT): {$(VPATH)}internal/dllexport.h
cont.$(OBJEXT): {$(VPATH)}internal/dosish.h
cont.$(OBJEXT): {$(VPATH)}internal/error.h
cont.$(OBJEXT): {$(VPATH)}internal/eval.h
cont.$(OBJEXT): {$(VPATH)}internal/event.h
cont.$(OBJEXT): {$(VPATH)}internal/fl_type.h
cont.$(OBJEXT): {$(VPATH)}internal/gc.h
cont.$(OBJEXT): {$(VPATH)}internal/glob.h
cont.$(OBJEXT): {$(VPATH)}internal/globals.h
cont.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
cont.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
cont.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
cont.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
cont.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
cont.$(OBJEXT): {$(VPATH)}internal/has/extension.h
cont.$(OBJEXT): {$(VPATH)}internal/has/feature.h
cont.$(OBJEXT): {$(VPATH)}internal/has/warning.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/array.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/class.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/error.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/file.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/io.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/load.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/object.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/process.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/random.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/range.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/re.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/select.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/string.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/time.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
cont.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
cont.$(OBJEXT): {$(VPATH)}internal/interpreter.h
cont.$(OBJEXT): {$(VPATH)}internal/iterator.h
cont.$(OBJEXT): {$(VPATH)}internal/memory.h
cont.$(OBJEXT): {$(VPATH)}internal/method.h
cont.$(OBJEXT): {$(VPATH)}internal/module.h
cont.$(OBJEXT): {$(VPATH)}internal/newobj.h
cont.$(OBJEXT): {$(VPATH)}internal/rgengc.h
cont.$(OBJEXT): {$(VPATH)}internal/scan_args.h
cont.$(OBJEXT): {$(VPATH)}internal/special_consts.h
cont.$(OBJEXT): {$(VPATH)}internal/static_assert.h
cont.$(OBJEXT): {$(VPATH)}internal/stdalign.h
cont.$(OBJEXT): {$(VPATH)}internal/stdbool.h
cont.$(OBJEXT): {$(VPATH)}internal/symbol.h
cont.$(OBJEXT): {$(VPATH)}internal/value.h
cont.$(OBJEXT): {$(VPATH)}internal/value_type.h
cont.$(OBJEXT): {$(VPATH)}internal/variable.h
cont.$(OBJEXT): {$(VPATH)}internal/warning_push.h
cont.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
cont.$(OBJEXT): {$(VPATH)}iseq.h
cont.$(OBJEXT): {$(VPATH)}method.h
cont.$(OBJEXT): {$(VPATH)}missing.h
cont.$(OBJEXT): {$(VPATH)}mjit.h
cont.$(OBJEXT): {$(VPATH)}node.h
cont.$(OBJEXT): {$(VPATH)}ractor.h
cont.$(OBJEXT): {$(VPATH)}ractor_core.h
cont.$(OBJEXT): {$(VPATH)}ruby_assert.h
cont.$(OBJEXT): {$(VPATH)}ruby_atomic.h
cont.$(OBJEXT): {$(VPATH)}shape.h
cont.$(OBJEXT): {$(VPATH)}st.h
cont.$(OBJEXT): {$(VPATH)}subst.h
cont.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
cont.$(OBJEXT): {$(VPATH)}thread_native.h
cont.$(OBJEXT): {$(VPATH)}vm_core.h
cont.$(OBJEXT): {$(VPATH)}vm_debug.h
cont.$(OBJEXT): {$(VPATH)}vm_opts.h
cont.$(OBJEXT): {$(VPATH)}vm_sync.h
cont.$(OBJEXT): {$(VPATH)}yjit.h
debug.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
debug.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
debug.$(OBJEXT): $(CCAN_DIR)/list/list.h
debug.$(OBJEXT): $(CCAN_DIR)/str/str.h
debug.$(OBJEXT): $(hdrdir)/ruby/ruby.h
debug.$(OBJEXT): $(top_srcdir)/internal/array.h
debug.$(OBJEXT): $(top_srcdir)/internal/class.h
debug.$(OBJEXT): $(top_srcdir)/internal/compilers.h
debug.$(OBJEXT): $(top_srcdir)/internal/gc.h
debug.$(OBJEXT): $(top_srcdir)/internal/imemo.h
debug.$(OBJEXT): $(top_srcdir)/internal/serial.h
debug.$(OBJEXT): $(top_srcdir)/internal/signal.h
debug.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
debug.$(OBJEXT): $(top_srcdir)/internal/variable.h
debug.$(OBJEXT): $(top_srcdir)/internal/vm.h
debug.$(OBJEXT): $(top_srcdir)/internal/warnings.h
debug.$(OBJEXT): {$(VPATH)}assert.h
debug.$(OBJEXT): {$(VPATH)}atomic.h
debug.$(OBJEXT): {$(VPATH)}backward/2/assume.h
debug.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
debug.$(OBJEXT): {$(VPATH)}backward/2/bool.h
debug.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
debug.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
debug.$(OBJEXT): {$(VPATH)}backward/2/limits.h
debug.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
debug.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
debug.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
debug.$(OBJEXT): {$(VPATH)}config.h
debug.$(OBJEXT): {$(VPATH)}constant.h
debug.$(OBJEXT): {$(VPATH)}debug.c
debug.$(OBJEXT): {$(VPATH)}debug_counter.h
debug.$(OBJEXT): {$(VPATH)}defines.h
debug.$(OBJEXT): {$(VPATH)}encindex.h
debug.$(OBJEXT): {$(VPATH)}encoding.h
debug.$(OBJEXT): {$(VPATH)}eval_intern.h
debug.$(OBJEXT): {$(VPATH)}gc.h
debug.$(OBJEXT): {$(VPATH)}id.h
debug.$(OBJEXT): {$(VPATH)}id_table.h
debug.$(OBJEXT): {$(VPATH)}intern.h
debug.$(OBJEXT): {$(VPATH)}internal.h
debug.$(OBJEXT): {$(VPATH)}internal/abi.h
debug.$(OBJEXT): {$(VPATH)}internal/anyargs.h
debug.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
debug.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
debug.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
debug.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
debug.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
debug.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
debug.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
debug.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
debug.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
debug.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
debug.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
debug.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
debug.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
debug.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
debug.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
debug.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
debug.$(OBJEXT): {$(VPATH)}internal/assume.h
debug.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
debug.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
debug.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
debug.$(OBJEXT): {$(VPATH)}internal/attr/const.h
debug.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
debug.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
debug.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
debug.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
debug.$(OBJEXT): {$(VPATH)}internal/attr/error.h
debug.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
debug.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
debug.$(OBJEXT): {$(VPATH)}internal/attr/format.h
debug.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
debug.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
debug.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
debug.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
debug.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
debug.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
debug.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
debug.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
debug.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
debug.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
debug.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
debug.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
debug.$(OBJEXT): {$(VPATH)}internal/cast.h
debug.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
debug.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
debug.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
debug.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
debug.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
debug.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
debug.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
debug.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
debug.$(OBJEXT): {$(VPATH)}internal/config.h
debug.$(OBJEXT): {$(VPATH)}internal/constant_p.h
debug.$(OBJEXT): {$(VPATH)}internal/core.h
debug.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
debug.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
debug.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
debug.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
debug.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
debug.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
debug.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
debug.$(OBJEXT): {$(VPATH)}internal/core/robject.h
debug.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
debug.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
debug.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
debug.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
debug.$(OBJEXT): {$(VPATH)}internal/ctype.h
debug.$(OBJEXT): {$(VPATH)}internal/dllexport.h
debug.$(OBJEXT): {$(VPATH)}internal/dosish.h
debug.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
debug.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
debug.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
debug.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
debug.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
debug.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
debug.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
debug.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
debug.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
debug.$(OBJEXT): {$(VPATH)}internal/error.h
debug.$(OBJEXT): {$(VPATH)}internal/eval.h
debug.$(OBJEXT): {$(VPATH)}internal/event.h
debug.$(OBJEXT): {$(VPATH)}internal/fl_type.h
debug.$(OBJEXT): {$(VPATH)}internal/gc.h
debug.$(OBJEXT): {$(VPATH)}internal/glob.h
debug.$(OBJEXT): {$(VPATH)}internal/globals.h
debug.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
debug.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
debug.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
debug.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
debug.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
debug.$(OBJEXT): {$(VPATH)}internal/has/extension.h
debug.$(OBJEXT): {$(VPATH)}internal/has/feature.h
debug.$(OBJEXT): {$(VPATH)}internal/has/warning.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/array.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/class.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/error.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/file.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/io.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/load.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/object.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/process.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/random.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/range.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/re.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/select.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/string.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/time.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
debug.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
debug.$(OBJEXT): {$(VPATH)}internal/interpreter.h
debug.$(OBJEXT): {$(VPATH)}internal/iterator.h
debug.$(OBJEXT): {$(VPATH)}internal/memory.h
debug.$(OBJEXT): {$(VPATH)}internal/method.h
debug.$(OBJEXT): {$(VPATH)}internal/module.h
debug.$(OBJEXT): {$(VPATH)}internal/newobj.h
debug.$(OBJEXT): {$(VPATH)}internal/rgengc.h
debug.$(OBJEXT): {$(VPATH)}internal/scan_args.h
debug.$(OBJEXT): {$(VPATH)}internal/special_consts.h
debug.$(OBJEXT): {$(VPATH)}internal/static_assert.h
debug.$(OBJEXT): {$(VPATH)}internal/stdalign.h
debug.$(OBJEXT): {$(VPATH)}internal/stdbool.h
debug.$(OBJEXT): {$(VPATH)}internal/symbol.h
debug.$(OBJEXT): {$(VPATH)}internal/value.h
debug.$(OBJEXT): {$(VPATH)}internal/value_type.h
debug.$(OBJEXT): {$(VPATH)}internal/variable.h
debug.$(OBJEXT): {$(VPATH)}internal/warning_push.h
debug.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
debug.$(OBJEXT): {$(VPATH)}io.h
debug.$(OBJEXT): {$(VPATH)}method.h
debug.$(OBJEXT): {$(VPATH)}missing.h
debug.$(OBJEXT): {$(VPATH)}node.h
debug.$(OBJEXT): {$(VPATH)}onigmo.h
debug.$(OBJEXT): {$(VPATH)}oniguruma.h
debug.$(OBJEXT): {$(VPATH)}ractor.h
debug.$(OBJEXT): {$(VPATH)}ractor_core.h
debug.$(OBJEXT): {$(VPATH)}ruby_assert.h
debug.$(OBJEXT): {$(VPATH)}ruby_atomic.h
debug.$(OBJEXT): {$(VPATH)}shape.h
debug.$(OBJEXT): {$(VPATH)}st.h
debug.$(OBJEXT): {$(VPATH)}subst.h
debug.$(OBJEXT): {$(VPATH)}symbol.h
debug.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
debug.$(OBJEXT): {$(VPATH)}thread_native.h
debug.$(OBJEXT): {$(VPATH)}util.h
debug.$(OBJEXT): {$(VPATH)}vm_callinfo.h
debug.$(OBJEXT): {$(VPATH)}vm_core.h
debug.$(OBJEXT): {$(VPATH)}vm_debug.h
debug.$(OBJEXT): {$(VPATH)}vm_opts.h
debug_counter.$(OBJEXT): $(hdrdir)/ruby/ruby.h
debug_counter.$(OBJEXT): {$(VPATH)}assert.h
debug_counter.$(OBJEXT): {$(VPATH)}backward/2/assume.h
debug_counter.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
debug_counter.$(OBJEXT): {$(VPATH)}backward/2/bool.h
debug_counter.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
debug_counter.$(OBJEXT): {$(VPATH)}backward/2/limits.h
debug_counter.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
debug_counter.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
debug_counter.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
debug_counter.$(OBJEXT): {$(VPATH)}config.h
debug_counter.$(OBJEXT): {$(VPATH)}debug_counter.c
debug_counter.$(OBJEXT): {$(VPATH)}debug_counter.h
debug_counter.$(OBJEXT): {$(VPATH)}defines.h
debug_counter.$(OBJEXT): {$(VPATH)}intern.h
debug_counter.$(OBJEXT): {$(VPATH)}internal.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/abi.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/anyargs.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/assume.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/attr/const.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/attr/error.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/attr/format.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/cast.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/config.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/constant_p.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/core.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/core/robject.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/ctype.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/dllexport.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/dosish.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/error.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/eval.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/event.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/fl_type.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/gc.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/glob.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/globals.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/has/extension.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/has/feature.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/has/warning.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/array.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/class.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/error.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/file.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/io.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/load.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/object.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/process.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/random.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/range.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/re.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/select.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/string.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/time.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/interpreter.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/iterator.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/memory.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/method.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/module.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/newobj.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/rgengc.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/scan_args.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/special_consts.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/static_assert.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/stdalign.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/stdbool.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/symbol.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/value.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/value_type.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/variable.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/warning_push.h
debug_counter.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
debug_counter.$(OBJEXT): {$(VPATH)}missing.h
debug_counter.$(OBJEXT): {$(VPATH)}st.h
debug_counter.$(OBJEXT): {$(VPATH)}subst.h
debug_counter.$(OBJEXT): {$(VPATH)}thread_native.h
dir.$(OBJEXT): $(hdrdir)/ruby/ruby.h
dir.$(OBJEXT): $(top_srcdir)/internal/array.h
dir.$(OBJEXT): $(top_srcdir)/internal/class.h
dir.$(OBJEXT): $(top_srcdir)/internal/compilers.h
dir.$(OBJEXT): $(top_srcdir)/internal/dir.h
dir.$(OBJEXT): $(top_srcdir)/internal/encoding.h
dir.$(OBJEXT): $(top_srcdir)/internal/error.h
dir.$(OBJEXT): $(top_srcdir)/internal/file.h
dir.$(OBJEXT): $(top_srcdir)/internal/gc.h
dir.$(OBJEXT): $(top_srcdir)/internal/io.h
dir.$(OBJEXT): $(top_srcdir)/internal/object.h
dir.$(OBJEXT): $(top_srcdir)/internal/serial.h
dir.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
dir.$(OBJEXT): $(top_srcdir)/internal/string.h
dir.$(OBJEXT): $(top_srcdir)/internal/variable.h
dir.$(OBJEXT): $(top_srcdir)/internal/vm.h
dir.$(OBJEXT): $(top_srcdir)/internal/warnings.h
dir.$(OBJEXT): {$(VPATH)}assert.h
dir.$(OBJEXT): {$(VPATH)}backward/2/assume.h
dir.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
dir.$(OBJEXT): {$(VPATH)}backward/2/bool.h
dir.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
dir.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
dir.$(OBJEXT): {$(VPATH)}backward/2/limits.h
dir.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
dir.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
dir.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
dir.$(OBJEXT): {$(VPATH)}builtin.h
dir.$(OBJEXT): {$(VPATH)}config.h
dir.$(OBJEXT): {$(VPATH)}constant.h
dir.$(OBJEXT): {$(VPATH)}defines.h
dir.$(OBJEXT): {$(VPATH)}dir.c
dir.$(OBJEXT): {$(VPATH)}dir.rbinc
dir.$(OBJEXT): {$(VPATH)}encindex.h
dir.$(OBJEXT): {$(VPATH)}encoding.h
dir.$(OBJEXT): {$(VPATH)}id.h
dir.$(OBJEXT): {$(VPATH)}id_table.h
dir.$(OBJEXT): {$(VPATH)}intern.h
dir.$(OBJEXT): {$(VPATH)}internal.h
dir.$(OBJEXT): {$(VPATH)}internal/abi.h
dir.$(OBJEXT): {$(VPATH)}internal/anyargs.h
dir.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
dir.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
dir.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
dir.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
dir.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
dir.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
dir.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
dir.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
dir.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
dir.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
dir.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
dir.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
dir.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
dir.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
dir.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
dir.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
dir.$(OBJEXT): {$(VPATH)}internal/assume.h
dir.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
dir.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
dir.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
dir.$(OBJEXT): {$(VPATH)}internal/attr/const.h
dir.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
dir.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
dir.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
dir.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
dir.$(OBJEXT): {$(VPATH)}internal/attr/error.h
dir.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
dir.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
dir.$(OBJEXT): {$(VPATH)}internal/attr/format.h
dir.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
dir.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
dir.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
dir.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
dir.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
dir.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
dir.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
dir.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
dir.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
dir.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
dir.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
dir.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
dir.$(OBJEXT): {$(VPATH)}internal/cast.h
dir.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
dir.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
dir.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
dir.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
dir.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
dir.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
dir.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
dir.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
dir.$(OBJEXT): {$(VPATH)}internal/config.h
dir.$(OBJEXT): {$(VPATH)}internal/constant_p.h
dir.$(OBJEXT): {$(VPATH)}internal/core.h
dir.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
dir.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
dir.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
dir.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
dir.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
dir.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
dir.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
dir.$(OBJEXT): {$(VPATH)}internal/core/robject.h
dir.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
dir.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
dir.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
dir.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
dir.$(OBJEXT): {$(VPATH)}internal/ctype.h
dir.$(OBJEXT): {$(VPATH)}internal/dllexport.h
dir.$(OBJEXT): {$(VPATH)}internal/dosish.h
dir.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
dir.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
dir.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
dir.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
dir.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
dir.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
dir.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
dir.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
dir.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
dir.$(OBJEXT): {$(VPATH)}internal/error.h
dir.$(OBJEXT): {$(VPATH)}internal/eval.h
dir.$(OBJEXT): {$(VPATH)}internal/event.h
dir.$(OBJEXT): {$(VPATH)}internal/fl_type.h
dir.$(OBJEXT): {$(VPATH)}internal/gc.h
dir.$(OBJEXT): {$(VPATH)}internal/glob.h
dir.$(OBJEXT): {$(VPATH)}internal/globals.h
dir.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
dir.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
dir.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
dir.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
dir.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
dir.$(OBJEXT): {$(VPATH)}internal/has/extension.h
dir.$(OBJEXT): {$(VPATH)}internal/has/feature.h
dir.$(OBJEXT): {$(VPATH)}internal/has/warning.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/array.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/class.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/error.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/file.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/io.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/load.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/object.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/process.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/random.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/range.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/re.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/select.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/string.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/time.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
dir.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
dir.$(OBJEXT): {$(VPATH)}internal/interpreter.h
dir.$(OBJEXT): {$(VPATH)}internal/iterator.h
dir.$(OBJEXT): {$(VPATH)}internal/memory.h
dir.$(OBJEXT): {$(VPATH)}internal/method.h
dir.$(OBJEXT): {$(VPATH)}internal/module.h
dir.$(OBJEXT): {$(VPATH)}internal/newobj.h
dir.$(OBJEXT): {$(VPATH)}internal/rgengc.h
dir.$(OBJEXT): {$(VPATH)}internal/scan_args.h
dir.$(OBJEXT): {$(VPATH)}internal/special_consts.h
dir.$(OBJEXT): {$(VPATH)}internal/static_assert.h
dir.$(OBJEXT): {$(VPATH)}internal/stdalign.h
dir.$(OBJEXT): {$(VPATH)}internal/stdbool.h
dir.$(OBJEXT): {$(VPATH)}internal/symbol.h
dir.$(OBJEXT): {$(VPATH)}internal/value.h
dir.$(OBJEXT): {$(VPATH)}internal/value_type.h
dir.$(OBJEXT): {$(VPATH)}internal/variable.h
dir.$(OBJEXT): {$(VPATH)}internal/warning_push.h
dir.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
dir.$(OBJEXT): {$(VPATH)}io.h
dir.$(OBJEXT): {$(VPATH)}missing.h
dir.$(OBJEXT): {$(VPATH)}onigmo.h
dir.$(OBJEXT): {$(VPATH)}oniguruma.h
dir.$(OBJEXT): {$(VPATH)}shape.h
dir.$(OBJEXT): {$(VPATH)}st.h
dir.$(OBJEXT): {$(VPATH)}subst.h
dir.$(OBJEXT): {$(VPATH)}thread.h
dir.$(OBJEXT): {$(VPATH)}util.h
dln.$(OBJEXT): $(hdrdir)/ruby/ruby.h
dln.$(OBJEXT): $(top_srcdir)/internal/compilers.h
dln.$(OBJEXT): $(top_srcdir)/internal/warnings.h
dln.$(OBJEXT): {$(VPATH)}assert.h
dln.$(OBJEXT): {$(VPATH)}backward/2/assume.h
dln.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
dln.$(OBJEXT): {$(VPATH)}backward/2/bool.h
dln.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
dln.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
dln.$(OBJEXT): {$(VPATH)}backward/2/limits.h
dln.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
dln.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
dln.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
dln.$(OBJEXT): {$(VPATH)}config.h
dln.$(OBJEXT): {$(VPATH)}defines.h
dln.$(OBJEXT): {$(VPATH)}dln.c
dln.$(OBJEXT): {$(VPATH)}dln.h
dln.$(OBJEXT): {$(VPATH)}intern.h
dln.$(OBJEXT): {$(VPATH)}internal.h
dln.$(OBJEXT): {$(VPATH)}internal/abi.h
dln.$(OBJEXT): {$(VPATH)}internal/anyargs.h
dln.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
dln.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
dln.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
dln.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
dln.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
dln.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
dln.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
dln.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
dln.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
dln.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
dln.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
dln.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
dln.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
dln.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
dln.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
dln.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
dln.$(OBJEXT): {$(VPATH)}internal/assume.h
dln.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
dln.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
dln.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
dln.$(OBJEXT): {$(VPATH)}internal/attr/const.h
dln.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
dln.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
dln.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
dln.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
dln.$(OBJEXT): {$(VPATH)}internal/attr/error.h
dln.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
dln.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
dln.$(OBJEXT): {$(VPATH)}internal/attr/format.h
dln.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
dln.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
dln.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
dln.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
dln.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
dln.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
dln.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
dln.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
dln.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
dln.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
dln.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
dln.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
dln.$(OBJEXT): {$(VPATH)}internal/cast.h
dln.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
dln.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
dln.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
dln.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
dln.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
dln.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
dln.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
dln.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
dln.$(OBJEXT): {$(VPATH)}internal/config.h
dln.$(OBJEXT): {$(VPATH)}internal/constant_p.h
dln.$(OBJEXT): {$(VPATH)}internal/core.h
dln.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
dln.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
dln.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
dln.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
dln.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
dln.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
dln.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
dln.$(OBJEXT): {$(VPATH)}internal/core/robject.h
dln.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
dln.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
dln.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
dln.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
dln.$(OBJEXT): {$(VPATH)}internal/ctype.h
dln.$(OBJEXT): {$(VPATH)}internal/dllexport.h
dln.$(OBJEXT): {$(VPATH)}internal/dosish.h
dln.$(OBJEXT): {$(VPATH)}internal/error.h
dln.$(OBJEXT): {$(VPATH)}internal/eval.h
dln.$(OBJEXT): {$(VPATH)}internal/event.h
dln.$(OBJEXT): {$(VPATH)}internal/fl_type.h
dln.$(OBJEXT): {$(VPATH)}internal/gc.h
dln.$(OBJEXT): {$(VPATH)}internal/glob.h
dln.$(OBJEXT): {$(VPATH)}internal/globals.h
dln.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
dln.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
dln.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
dln.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
dln.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
dln.$(OBJEXT): {$(VPATH)}internal/has/extension.h
dln.$(OBJEXT): {$(VPATH)}internal/has/feature.h
dln.$(OBJEXT): {$(VPATH)}internal/has/warning.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/array.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/class.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/error.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/file.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/io.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/load.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/object.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/process.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/random.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/range.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/re.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/select.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/string.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/time.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
dln.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
dln.$(OBJEXT): {$(VPATH)}internal/interpreter.h
dln.$(OBJEXT): {$(VPATH)}internal/iterator.h
dln.$(OBJEXT): {$(VPATH)}internal/memory.h
dln.$(OBJEXT): {$(VPATH)}internal/method.h
dln.$(OBJEXT): {$(VPATH)}internal/module.h
dln.$(OBJEXT): {$(VPATH)}internal/newobj.h
dln.$(OBJEXT): {$(VPATH)}internal/rgengc.h
dln.$(OBJEXT): {$(VPATH)}internal/scan_args.h
dln.$(OBJEXT): {$(VPATH)}internal/special_consts.h
dln.$(OBJEXT): {$(VPATH)}internal/static_assert.h
dln.$(OBJEXT): {$(VPATH)}internal/stdalign.h
dln.$(OBJEXT): {$(VPATH)}internal/stdbool.h
dln.$(OBJEXT): {$(VPATH)}internal/symbol.h
dln.$(OBJEXT): {$(VPATH)}internal/value.h
dln.$(OBJEXT): {$(VPATH)}internal/value_type.h
dln.$(OBJEXT): {$(VPATH)}internal/variable.h
dln.$(OBJEXT): {$(VPATH)}internal/warning_push.h
dln.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
dln.$(OBJEXT): {$(VPATH)}missing.h
dln.$(OBJEXT): {$(VPATH)}st.h
dln.$(OBJEXT): {$(VPATH)}subst.h
dln_find.$(OBJEXT): $(hdrdir)/ruby/ruby.h
dln_find.$(OBJEXT): {$(VPATH)}assert.h
dln_find.$(OBJEXT): {$(VPATH)}backward/2/assume.h
dln_find.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
dln_find.$(OBJEXT): {$(VPATH)}backward/2/bool.h
dln_find.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
dln_find.$(OBJEXT): {$(VPATH)}backward/2/limits.h
dln_find.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
dln_find.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
dln_find.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
dln_find.$(OBJEXT): {$(VPATH)}config.h
dln_find.$(OBJEXT): {$(VPATH)}defines.h
dln_find.$(OBJEXT): {$(VPATH)}dln.h
dln_find.$(OBJEXT): {$(VPATH)}dln_find.c
dln_find.$(OBJEXT): {$(VPATH)}intern.h
dln_find.$(OBJEXT): {$(VPATH)}internal/abi.h
dln_find.$(OBJEXT): {$(VPATH)}internal/anyargs.h
dln_find.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
dln_find.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
dln_find.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
dln_find.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
dln_find.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
dln_find.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
dln_find.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
dln_find.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
dln_find.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
dln_find.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
dln_find.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
dln_find.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
dln_find.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
dln_find.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
dln_find.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
dln_find.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
dln_find.$(OBJEXT): {$(VPATH)}internal/assume.h
dln_find.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
dln_find.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
dln_find.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
dln_find.$(OBJEXT): {$(VPATH)}internal/attr/const.h
dln_find.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
dln_find.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
dln_find.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
dln_find.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
dln_find.$(OBJEXT): {$(VPATH)}internal/attr/error.h
dln_find.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
dln_find.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
dln_find.$(OBJEXT): {$(VPATH)}internal/attr/format.h
dln_find.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
dln_find.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
dln_find.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
dln_find.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
dln_find.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
dln_find.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
dln_find.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
dln_find.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
dln_find.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
dln_find.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
dln_find.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
dln_find.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
dln_find.$(OBJEXT): {$(VPATH)}internal/cast.h
dln_find.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
dln_find.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
dln_find.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
dln_find.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
dln_find.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
dln_find.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
dln_find.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
dln_find.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
dln_find.$(OBJEXT): {$(VPATH)}internal/config.h
dln_find.$(OBJEXT): {$(VPATH)}internal/constant_p.h
dln_find.$(OBJEXT): {$(VPATH)}internal/core.h
dln_find.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
dln_find.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
dln_find.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
dln_find.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
dln_find.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
dln_find.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
dln_find.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
dln_find.$(OBJEXT): {$(VPATH)}internal/core/robject.h
dln_find.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
dln_find.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
dln_find.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
dln_find.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
dln_find.$(OBJEXT): {$(VPATH)}internal/ctype.h
dln_find.$(OBJEXT): {$(VPATH)}internal/dllexport.h
dln_find.$(OBJEXT): {$(VPATH)}internal/dosish.h
dln_find.$(OBJEXT): {$(VPATH)}internal/error.h
dln_find.$(OBJEXT): {$(VPATH)}internal/eval.h
dln_find.$(OBJEXT): {$(VPATH)}internal/event.h
dln_find.$(OBJEXT): {$(VPATH)}internal/fl_type.h
dln_find.$(OBJEXT): {$(VPATH)}internal/gc.h
dln_find.$(OBJEXT): {$(VPATH)}internal/glob.h
dln_find.$(OBJEXT): {$(VPATH)}internal/globals.h
dln_find.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
dln_find.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
dln_find.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
dln_find.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
dln_find.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
dln_find.$(OBJEXT): {$(VPATH)}internal/has/extension.h
dln_find.$(OBJEXT): {$(VPATH)}internal/has/feature.h
dln_find.$(OBJEXT): {$(VPATH)}internal/has/warning.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/array.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/class.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/error.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/file.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/io.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/load.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/object.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/process.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/random.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/range.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/re.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/select.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/string.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/time.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
dln_find.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
dln_find.$(OBJEXT): {$(VPATH)}internal/interpreter.h
dln_find.$(OBJEXT): {$(VPATH)}internal/iterator.h
dln_find.$(OBJEXT): {$(VPATH)}internal/memory.h
dln_find.$(OBJEXT): {$(VPATH)}internal/method.h
dln_find.$(OBJEXT): {$(VPATH)}internal/module.h
dln_find.$(OBJEXT): {$(VPATH)}internal/newobj.h
dln_find.$(OBJEXT): {$(VPATH)}internal/rgengc.h
dln_find.$(OBJEXT): {$(VPATH)}internal/scan_args.h
dln_find.$(OBJEXT): {$(VPATH)}internal/special_consts.h
dln_find.$(OBJEXT): {$(VPATH)}internal/static_assert.h
dln_find.$(OBJEXT): {$(VPATH)}internal/stdalign.h
dln_find.$(OBJEXT): {$(VPATH)}internal/stdbool.h
dln_find.$(OBJEXT): {$(VPATH)}internal/symbol.h
dln_find.$(OBJEXT): {$(VPATH)}internal/value.h
dln_find.$(OBJEXT): {$(VPATH)}internal/value_type.h
dln_find.$(OBJEXT): {$(VPATH)}internal/variable.h
dln_find.$(OBJEXT): {$(VPATH)}internal/warning_push.h
dln_find.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
dln_find.$(OBJEXT): {$(VPATH)}missing.h
dln_find.$(OBJEXT): {$(VPATH)}st.h
dln_find.$(OBJEXT): {$(VPATH)}subst.h
dmydln.$(OBJEXT): $(hdrdir)/ruby/ruby.h
dmydln.$(OBJEXT): {$(VPATH)}assert.h
dmydln.$(OBJEXT): {$(VPATH)}backward/2/assume.h
dmydln.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
dmydln.$(OBJEXT): {$(VPATH)}backward/2/bool.h
dmydln.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
dmydln.$(OBJEXT): {$(VPATH)}backward/2/limits.h
dmydln.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
dmydln.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
dmydln.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
dmydln.$(OBJEXT): {$(VPATH)}config.h
dmydln.$(OBJEXT): {$(VPATH)}defines.h
dmydln.$(OBJEXT): {$(VPATH)}dmydln.c
dmydln.$(OBJEXT): {$(VPATH)}intern.h
dmydln.$(OBJEXT): {$(VPATH)}internal/abi.h
dmydln.$(OBJEXT): {$(VPATH)}internal/anyargs.h
dmydln.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
dmydln.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
dmydln.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
dmydln.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
dmydln.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
dmydln.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
dmydln.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
dmydln.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
dmydln.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
dmydln.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
dmydln.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
dmydln.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
dmydln.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
dmydln.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
dmydln.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
dmydln.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
dmydln.$(OBJEXT): {$(VPATH)}internal/assume.h
dmydln.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
dmydln.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
dmydln.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
dmydln.$(OBJEXT): {$(VPATH)}internal/attr/const.h
dmydln.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
dmydln.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
dmydln.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
dmydln.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
dmydln.$(OBJEXT): {$(VPATH)}internal/attr/error.h
dmydln.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
dmydln.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
dmydln.$(OBJEXT): {$(VPATH)}internal/attr/format.h
dmydln.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
dmydln.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
dmydln.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
dmydln.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
dmydln.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
dmydln.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
dmydln.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
dmydln.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
dmydln.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
dmydln.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
dmydln.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
dmydln.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
dmydln.$(OBJEXT): {$(VPATH)}internal/cast.h
dmydln.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
dmydln.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
dmydln.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
dmydln.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
dmydln.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
dmydln.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
dmydln.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
dmydln.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
dmydln.$(OBJEXT): {$(VPATH)}internal/config.h
dmydln.$(OBJEXT): {$(VPATH)}internal/constant_p.h
dmydln.$(OBJEXT): {$(VPATH)}internal/core.h
dmydln.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
dmydln.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
dmydln.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
dmydln.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
dmydln.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
dmydln.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
dmydln.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
dmydln.$(OBJEXT): {$(VPATH)}internal/core/robject.h
dmydln.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
dmydln.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
dmydln.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
dmydln.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
dmydln.$(OBJEXT): {$(VPATH)}internal/ctype.h
dmydln.$(OBJEXT): {$(VPATH)}internal/dllexport.h
dmydln.$(OBJEXT): {$(VPATH)}internal/dosish.h
dmydln.$(OBJEXT): {$(VPATH)}internal/error.h
dmydln.$(OBJEXT): {$(VPATH)}internal/eval.h
dmydln.$(OBJEXT): {$(VPATH)}internal/event.h
dmydln.$(OBJEXT): {$(VPATH)}internal/fl_type.h
dmydln.$(OBJEXT): {$(VPATH)}internal/gc.h
dmydln.$(OBJEXT): {$(VPATH)}internal/glob.h
dmydln.$(OBJEXT): {$(VPATH)}internal/globals.h
dmydln.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
dmydln.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
dmydln.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
dmydln.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
dmydln.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
dmydln.$(OBJEXT): {$(VPATH)}internal/has/extension.h
dmydln.$(OBJEXT): {$(VPATH)}internal/has/feature.h
dmydln.$(OBJEXT): {$(VPATH)}internal/has/warning.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/array.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/class.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/error.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/file.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/io.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/load.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/object.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/process.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/random.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/range.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/re.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/select.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/string.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/time.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
dmydln.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
dmydln.$(OBJEXT): {$(VPATH)}internal/interpreter.h
dmydln.$(OBJEXT): {$(VPATH)}internal/iterator.h
dmydln.$(OBJEXT): {$(VPATH)}internal/memory.h
dmydln.$(OBJEXT): {$(VPATH)}internal/method.h
dmydln.$(OBJEXT): {$(VPATH)}internal/module.h
dmydln.$(OBJEXT): {$(VPATH)}internal/newobj.h
dmydln.$(OBJEXT): {$(VPATH)}internal/rgengc.h
dmydln.$(OBJEXT): {$(VPATH)}internal/scan_args.h
dmydln.$(OBJEXT): {$(VPATH)}internal/special_consts.h
dmydln.$(OBJEXT): {$(VPATH)}internal/static_assert.h
dmydln.$(OBJEXT): {$(VPATH)}internal/stdalign.h
dmydln.$(OBJEXT): {$(VPATH)}internal/stdbool.h
dmydln.$(OBJEXT): {$(VPATH)}internal/symbol.h
dmydln.$(OBJEXT): {$(VPATH)}internal/value.h
dmydln.$(OBJEXT): {$(VPATH)}internal/value_type.h
dmydln.$(OBJEXT): {$(VPATH)}internal/variable.h
dmydln.$(OBJEXT): {$(VPATH)}internal/warning_push.h
dmydln.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
dmydln.$(OBJEXT): {$(VPATH)}missing.h
dmydln.$(OBJEXT): {$(VPATH)}st.h
dmydln.$(OBJEXT): {$(VPATH)}subst.h
dmyenc.$(OBJEXT): {$(VPATH)}dmyenc.c
dmyext.$(OBJEXT): {$(VPATH)}dmyext.c
enc/ascii.$(OBJEXT): $(hdrdir)/ruby/ruby.h
enc/ascii.$(OBJEXT): {$(VPATH)}assert.h
enc/ascii.$(OBJEXT): {$(VPATH)}backward/2/assume.h
enc/ascii.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
enc/ascii.$(OBJEXT): {$(VPATH)}backward/2/bool.h
enc/ascii.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
enc/ascii.$(OBJEXT): {$(VPATH)}backward/2/limits.h
enc/ascii.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
enc/ascii.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
enc/ascii.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
enc/ascii.$(OBJEXT): {$(VPATH)}config.h
enc/ascii.$(OBJEXT): {$(VPATH)}defines.h
enc/ascii.$(OBJEXT): {$(VPATH)}enc/ascii.c
enc/ascii.$(OBJEXT): {$(VPATH)}encindex.h
enc/ascii.$(OBJEXT): {$(VPATH)}encoding.h
enc/ascii.$(OBJEXT): {$(VPATH)}intern.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/anyargs.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/assume.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/attr/const.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/attr/error.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/attr/format.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/cast.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/config.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/constant_p.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/core.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/core/robject.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/ctype.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/dllexport.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/dosish.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/error.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/eval.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/event.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/fl_type.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/gc.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/glob.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/globals.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/has/extension.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/has/feature.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/has/warning.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/array.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/class.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/error.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/file.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/io.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/load.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/object.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/process.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/random.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/range.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/re.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/select.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/string.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/time.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/interpreter.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/iterator.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/memory.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/method.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/module.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/newobj.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/rgengc.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/scan_args.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/special_consts.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/static_assert.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/stdalign.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/stdbool.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/symbol.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/value.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/value_type.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/variable.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/warning_push.h
enc/ascii.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
enc/ascii.$(OBJEXT): {$(VPATH)}missing.h
enc/ascii.$(OBJEXT): {$(VPATH)}onigmo.h
enc/ascii.$(OBJEXT): {$(VPATH)}oniguruma.h
enc/ascii.$(OBJEXT): {$(VPATH)}regenc.h
enc/ascii.$(OBJEXT): {$(VPATH)}st.h
enc/ascii.$(OBJEXT): {$(VPATH)}subst.h
enc/trans/newline.$(OBJEXT): $(hdrdir)/ruby/ruby.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}assert.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}backward/2/assume.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}backward/2/bool.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}backward/2/limits.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}config.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}defines.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}enc/trans/newline.c
enc/trans/newline.$(OBJEXT): {$(VPATH)}intern.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/anyargs.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/assume.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/attr/const.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/attr/error.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/attr/format.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/cast.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/config.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/constant_p.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/core.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/core/robject.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/ctype.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/dllexport.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/dosish.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/error.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/eval.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/event.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/fl_type.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/gc.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/glob.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/globals.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/has/extension.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/has/feature.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/has/warning.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/array.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/class.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/error.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/file.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/io.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/load.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/object.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/process.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/random.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/range.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/re.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/select.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/string.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/time.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/interpreter.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/iterator.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/memory.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/method.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/module.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/newobj.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/rgengc.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/scan_args.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/special_consts.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/static_assert.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/stdalign.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/stdbool.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/symbol.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/value.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/value_type.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/variable.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/warning_push.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}missing.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}st.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}subst.h
enc/trans/newline.$(OBJEXT): {$(VPATH)}transcode_data.h
enc/unicode.$(OBJEXT): $(UNICODE_HDR_DIR)/casefold.h
enc/unicode.$(OBJEXT): $(UNICODE_HDR_DIR)/name2ctype.h
enc/unicode.$(OBJEXT): $(hdrdir)/ruby/ruby.h
enc/unicode.$(OBJEXT): {$(VPATH)}assert.h
enc/unicode.$(OBJEXT): {$(VPATH)}backward/2/assume.h
enc/unicode.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
enc/unicode.$(OBJEXT): {$(VPATH)}backward/2/bool.h
enc/unicode.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
enc/unicode.$(OBJEXT): {$(VPATH)}backward/2/limits.h
enc/unicode.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
enc/unicode.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
enc/unicode.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
enc/unicode.$(OBJEXT): {$(VPATH)}config.h
enc/unicode.$(OBJEXT): {$(VPATH)}defines.h
enc/unicode.$(OBJEXT): {$(VPATH)}enc/unicode.c
enc/unicode.$(OBJEXT): {$(VPATH)}intern.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/anyargs.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/assume.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/attr/const.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/attr/error.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/attr/format.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/cast.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/config.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/constant_p.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/core.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/core/robject.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/ctype.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/dllexport.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/dosish.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/error.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/eval.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/event.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/fl_type.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/gc.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/glob.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/globals.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/has/extension.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/has/feature.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/has/warning.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/array.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/class.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/error.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/file.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/io.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/load.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/object.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/process.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/random.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/range.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/re.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/select.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/string.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/time.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/interpreter.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/iterator.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/memory.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/method.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/module.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/newobj.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/rgengc.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/scan_args.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/special_consts.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/static_assert.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/stdalign.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/stdbool.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/symbol.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/value.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/value_type.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/variable.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/warning_push.h
enc/unicode.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
enc/unicode.$(OBJEXT): {$(VPATH)}missing.h
enc/unicode.$(OBJEXT): {$(VPATH)}onigmo.h
enc/unicode.$(OBJEXT): {$(VPATH)}regenc.h
enc/unicode.$(OBJEXT): {$(VPATH)}regint.h
enc/unicode.$(OBJEXT): {$(VPATH)}st.h
enc/unicode.$(OBJEXT): {$(VPATH)}subst.h
enc/us_ascii.$(OBJEXT): $(hdrdir)/ruby/ruby.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}assert.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}backward/2/assume.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}backward/2/bool.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}backward/2/limits.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}config.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}defines.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}enc/us_ascii.c
enc/us_ascii.$(OBJEXT): {$(VPATH)}encindex.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}encoding.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}intern.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/anyargs.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/assume.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/attr/const.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/attr/error.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/attr/format.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/cast.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/config.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/constant_p.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/core.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/core/robject.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/ctype.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/dllexport.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/dosish.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/error.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/eval.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/event.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/fl_type.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/gc.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/glob.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/globals.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/has/extension.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/has/feature.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/has/warning.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/array.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/class.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/error.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/file.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/io.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/load.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/object.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/process.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/random.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/range.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/re.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/select.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/string.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/time.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/interpreter.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/iterator.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/memory.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/method.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/module.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/newobj.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/rgengc.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/scan_args.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/special_consts.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/static_assert.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/stdalign.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/stdbool.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/symbol.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/value.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/value_type.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/variable.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/warning_push.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}missing.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}onigmo.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}oniguruma.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}regenc.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}st.h
enc/us_ascii.$(OBJEXT): {$(VPATH)}subst.h
enc/utf_8.$(OBJEXT): $(hdrdir)/ruby/ruby.h
enc/utf_8.$(OBJEXT): {$(VPATH)}assert.h
enc/utf_8.$(OBJEXT): {$(VPATH)}backward/2/assume.h
enc/utf_8.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
enc/utf_8.$(OBJEXT): {$(VPATH)}backward/2/bool.h
enc/utf_8.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
enc/utf_8.$(OBJEXT): {$(VPATH)}backward/2/limits.h
enc/utf_8.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
enc/utf_8.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
enc/utf_8.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
enc/utf_8.$(OBJEXT): {$(VPATH)}config.h
enc/utf_8.$(OBJEXT): {$(VPATH)}defines.h
enc/utf_8.$(OBJEXT): {$(VPATH)}enc/utf_8.c
enc/utf_8.$(OBJEXT): {$(VPATH)}encindex.h
enc/utf_8.$(OBJEXT): {$(VPATH)}encoding.h
enc/utf_8.$(OBJEXT): {$(VPATH)}intern.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/anyargs.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/assume.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/attr/const.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/attr/error.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/attr/format.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/cast.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/config.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/constant_p.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/core.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/core/robject.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/ctype.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/dllexport.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/dosish.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/error.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/eval.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/event.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/fl_type.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/gc.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/glob.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/globals.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/has/extension.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/has/feature.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/has/warning.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/array.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/class.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/error.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/file.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/io.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/load.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/object.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/process.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/random.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/range.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/re.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/select.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/string.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/time.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/interpreter.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/iterator.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/memory.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/method.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/module.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/newobj.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/rgengc.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/scan_args.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/special_consts.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/static_assert.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/stdalign.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/stdbool.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/symbol.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/value.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/value_type.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/variable.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/warning_push.h
enc/utf_8.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
enc/utf_8.$(OBJEXT): {$(VPATH)}missing.h
enc/utf_8.$(OBJEXT): {$(VPATH)}onigmo.h
enc/utf_8.$(OBJEXT): {$(VPATH)}oniguruma.h
enc/utf_8.$(OBJEXT): {$(VPATH)}regenc.h
enc/utf_8.$(OBJEXT): {$(VPATH)}st.h
enc/utf_8.$(OBJEXT): {$(VPATH)}subst.h
encoding.$(OBJEXT): $(hdrdir)/ruby.h
encoding.$(OBJEXT): $(hdrdir)/ruby/ruby.h
encoding.$(OBJEXT): $(top_srcdir)/internal/class.h
encoding.$(OBJEXT): $(top_srcdir)/internal/compilers.h
encoding.$(OBJEXT): $(top_srcdir)/internal/enc.h
encoding.$(OBJEXT): $(top_srcdir)/internal/encoding.h
encoding.$(OBJEXT): $(top_srcdir)/internal/error.h
encoding.$(OBJEXT): $(top_srcdir)/internal/gc.h
encoding.$(OBJEXT): $(top_srcdir)/internal/inits.h
encoding.$(OBJEXT): $(top_srcdir)/internal/load.h
encoding.$(OBJEXT): $(top_srcdir)/internal/object.h
encoding.$(OBJEXT): $(top_srcdir)/internal/serial.h
encoding.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
encoding.$(OBJEXT): $(top_srcdir)/internal/string.h
encoding.$(OBJEXT): $(top_srcdir)/internal/variable.h
encoding.$(OBJEXT): $(top_srcdir)/internal/vm.h
encoding.$(OBJEXT): $(top_srcdir)/internal/warnings.h
encoding.$(OBJEXT): {$(VPATH)}assert.h
encoding.$(OBJEXT): {$(VPATH)}backward/2/assume.h
encoding.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
encoding.$(OBJEXT): {$(VPATH)}backward/2/bool.h
encoding.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
encoding.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
encoding.$(OBJEXT): {$(VPATH)}backward/2/limits.h
encoding.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
encoding.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
encoding.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
encoding.$(OBJEXT): {$(VPATH)}config.h
encoding.$(OBJEXT): {$(VPATH)}constant.h
encoding.$(OBJEXT): {$(VPATH)}debug_counter.h
encoding.$(OBJEXT): {$(VPATH)}defines.h
encoding.$(OBJEXT): {$(VPATH)}encindex.h
encoding.$(OBJEXT): {$(VPATH)}encoding.c
encoding.$(OBJEXT): {$(VPATH)}encoding.h
encoding.$(OBJEXT): {$(VPATH)}id_table.h
encoding.$(OBJEXT): {$(VPATH)}intern.h
encoding.$(OBJEXT): {$(VPATH)}internal.h
encoding.$(OBJEXT): {$(VPATH)}internal/abi.h
encoding.$(OBJEXT): {$(VPATH)}internal/anyargs.h
encoding.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
encoding.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
encoding.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
encoding.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
encoding.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
encoding.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
encoding.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
encoding.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
encoding.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
encoding.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
encoding.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
encoding.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
encoding.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
encoding.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
encoding.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
encoding.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
encoding.$(OBJEXT): {$(VPATH)}internal/assume.h
encoding.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
encoding.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
encoding.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
encoding.$(OBJEXT): {$(VPATH)}internal/attr/const.h
encoding.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
encoding.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
encoding.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
encoding.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
encoding.$(OBJEXT): {$(VPATH)}internal/attr/error.h
encoding.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
encoding.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
encoding.$(OBJEXT): {$(VPATH)}internal/attr/format.h
encoding.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
encoding.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
encoding.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
encoding.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
encoding.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
encoding.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
encoding.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
encoding.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
encoding.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
encoding.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
encoding.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
encoding.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
encoding.$(OBJEXT): {$(VPATH)}internal/cast.h
encoding.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
encoding.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
encoding.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
encoding.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
encoding.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
encoding.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
encoding.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
encoding.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
encoding.$(OBJEXT): {$(VPATH)}internal/config.h
encoding.$(OBJEXT): {$(VPATH)}internal/constant_p.h
encoding.$(OBJEXT): {$(VPATH)}internal/core.h
encoding.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
encoding.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
encoding.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
encoding.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
encoding.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
encoding.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
encoding.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
encoding.$(OBJEXT): {$(VPATH)}internal/core/robject.h
encoding.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
encoding.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
encoding.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
encoding.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
encoding.$(OBJEXT): {$(VPATH)}internal/ctype.h
encoding.$(OBJEXT): {$(VPATH)}internal/dllexport.h
encoding.$(OBJEXT): {$(VPATH)}internal/dosish.h
encoding.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
encoding.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
encoding.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
encoding.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
encoding.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
encoding.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
encoding.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
encoding.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
encoding.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
encoding.$(OBJEXT): {$(VPATH)}internal/error.h
encoding.$(OBJEXT): {$(VPATH)}internal/eval.h
encoding.$(OBJEXT): {$(VPATH)}internal/event.h
encoding.$(OBJEXT): {$(VPATH)}internal/fl_type.h
encoding.$(OBJEXT): {$(VPATH)}internal/gc.h
encoding.$(OBJEXT): {$(VPATH)}internal/glob.h
encoding.$(OBJEXT): {$(VPATH)}internal/globals.h
encoding.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
encoding.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
encoding.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
encoding.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
encoding.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
encoding.$(OBJEXT): {$(VPATH)}internal/has/extension.h
encoding.$(OBJEXT): {$(VPATH)}internal/has/feature.h
encoding.$(OBJEXT): {$(VPATH)}internal/has/warning.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/array.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/class.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/error.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/file.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/io.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/load.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/object.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/process.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/random.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/range.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/re.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/select.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/string.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/time.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
encoding.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
encoding.$(OBJEXT): {$(VPATH)}internal/interpreter.h
encoding.$(OBJEXT): {$(VPATH)}internal/iterator.h
encoding.$(OBJEXT): {$(VPATH)}internal/memory.h
encoding.$(OBJEXT): {$(VPATH)}internal/method.h
encoding.$(OBJEXT): {$(VPATH)}internal/module.h
encoding.$(OBJEXT): {$(VPATH)}internal/newobj.h
encoding.$(OBJEXT): {$(VPATH)}internal/rgengc.h
encoding.$(OBJEXT): {$(VPATH)}internal/scan_args.h
encoding.$(OBJEXT): {$(VPATH)}internal/special_consts.h
encoding.$(OBJEXT): {$(VPATH)}internal/static_assert.h
encoding.$(OBJEXT): {$(VPATH)}internal/stdalign.h
encoding.$(OBJEXT): {$(VPATH)}internal/stdbool.h
encoding.$(OBJEXT): {$(VPATH)}internal/symbol.h
encoding.$(OBJEXT): {$(VPATH)}internal/value.h
encoding.$(OBJEXT): {$(VPATH)}internal/value_type.h
encoding.$(OBJEXT): {$(VPATH)}internal/variable.h
encoding.$(OBJEXT): {$(VPATH)}internal/warning_push.h
encoding.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
encoding.$(OBJEXT): {$(VPATH)}missing.h
encoding.$(OBJEXT): {$(VPATH)}onigmo.h
encoding.$(OBJEXT): {$(VPATH)}oniguruma.h
encoding.$(OBJEXT): {$(VPATH)}regenc.h
encoding.$(OBJEXT): {$(VPATH)}ruby_assert.h
encoding.$(OBJEXT): {$(VPATH)}shape.h
encoding.$(OBJEXT): {$(VPATH)}st.h
encoding.$(OBJEXT): {$(VPATH)}subst.h
encoding.$(OBJEXT): {$(VPATH)}util.h
encoding.$(OBJEXT): {$(VPATH)}vm_debug.h
encoding.$(OBJEXT): {$(VPATH)}vm_sync.h
enum.$(OBJEXT): $(hdrdir)/ruby/ruby.h
enum.$(OBJEXT): $(top_srcdir)/internal/array.h
enum.$(OBJEXT): $(top_srcdir)/internal/bignum.h
enum.$(OBJEXT): $(top_srcdir)/internal/bits.h
enum.$(OBJEXT): $(top_srcdir)/internal/class.h
enum.$(OBJEXT): $(top_srcdir)/internal/compar.h
enum.$(OBJEXT): $(top_srcdir)/internal/compilers.h
enum.$(OBJEXT): $(top_srcdir)/internal/enum.h
enum.$(OBJEXT): $(top_srcdir)/internal/fixnum.h
enum.$(OBJEXT): $(top_srcdir)/internal/gc.h
enum.$(OBJEXT): $(top_srcdir)/internal/hash.h
enum.$(OBJEXT): $(top_srcdir)/internal/imemo.h
enum.$(OBJEXT): $(top_srcdir)/internal/numeric.h
enum.$(OBJEXT): $(top_srcdir)/internal/object.h
enum.$(OBJEXT): $(top_srcdir)/internal/proc.h
enum.$(OBJEXT): $(top_srcdir)/internal/rational.h
enum.$(OBJEXT): $(top_srcdir)/internal/re.h
enum.$(OBJEXT): $(top_srcdir)/internal/serial.h
enum.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
enum.$(OBJEXT): $(top_srcdir)/internal/variable.h
enum.$(OBJEXT): $(top_srcdir)/internal/vm.h
enum.$(OBJEXT): $(top_srcdir)/internal/warnings.h
enum.$(OBJEXT): {$(VPATH)}assert.h
enum.$(OBJEXT): {$(VPATH)}backward/2/assume.h
enum.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
enum.$(OBJEXT): {$(VPATH)}backward/2/bool.h
enum.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
enum.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
enum.$(OBJEXT): {$(VPATH)}backward/2/limits.h
enum.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
enum.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
enum.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
enum.$(OBJEXT): {$(VPATH)}config.h
enum.$(OBJEXT): {$(VPATH)}constant.h
enum.$(OBJEXT): {$(VPATH)}defines.h
enum.$(OBJEXT): {$(VPATH)}encoding.h
enum.$(OBJEXT): {$(VPATH)}enum.c
enum.$(OBJEXT): {$(VPATH)}id.h
enum.$(OBJEXT): {$(VPATH)}id_table.h
enum.$(OBJEXT): {$(VPATH)}intern.h
enum.$(OBJEXT): {$(VPATH)}internal.h
enum.$(OBJEXT): {$(VPATH)}internal/abi.h
enum.$(OBJEXT): {$(VPATH)}internal/anyargs.h
enum.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
enum.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
enum.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
enum.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
enum.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
enum.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
enum.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
enum.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
enum.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
enum.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
enum.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
enum.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
enum.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
enum.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
enum.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
enum.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
enum.$(OBJEXT): {$(VPATH)}internal/assume.h
enum.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
enum.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
enum.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
enum.$(OBJEXT): {$(VPATH)}internal/attr/const.h
enum.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
enum.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
enum.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
enum.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
enum.$(OBJEXT): {$(VPATH)}internal/attr/error.h
enum.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
enum.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
enum.$(OBJEXT): {$(VPATH)}internal/attr/format.h
enum.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
enum.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
enum.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
enum.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
enum.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
enum.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
enum.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
enum.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
enum.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
enum.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
enum.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
enum.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
enum.$(OBJEXT): {$(VPATH)}internal/cast.h
enum.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
enum.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
enum.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
enum.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
enum.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
enum.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
enum.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
enum.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
enum.$(OBJEXT): {$(VPATH)}internal/config.h
enum.$(OBJEXT): {$(VPATH)}internal/constant_p.h
enum.$(OBJEXT): {$(VPATH)}internal/core.h
enum.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
enum.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
enum.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
enum.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
enum.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
enum.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
enum.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
enum.$(OBJEXT): {$(VPATH)}internal/core/robject.h
enum.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
enum.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
enum.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
enum.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
enum.$(OBJEXT): {$(VPATH)}internal/ctype.h
enum.$(OBJEXT): {$(VPATH)}internal/dllexport.h
enum.$(OBJEXT): {$(VPATH)}internal/dosish.h
enum.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
enum.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
enum.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
enum.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
enum.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
enum.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
enum.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
enum.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
enum.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
enum.$(OBJEXT): {$(VPATH)}internal/error.h
enum.$(OBJEXT): {$(VPATH)}internal/eval.h
enum.$(OBJEXT): {$(VPATH)}internal/event.h
enum.$(OBJEXT): {$(VPATH)}internal/fl_type.h
enum.$(OBJEXT): {$(VPATH)}internal/gc.h
enum.$(OBJEXT): {$(VPATH)}internal/glob.h
enum.$(OBJEXT): {$(VPATH)}internal/globals.h
enum.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
enum.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
enum.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
enum.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
enum.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
enum.$(OBJEXT): {$(VPATH)}internal/has/extension.h
enum.$(OBJEXT): {$(VPATH)}internal/has/feature.h
enum.$(OBJEXT): {$(VPATH)}internal/has/warning.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/array.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/class.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/error.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/file.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/io.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/load.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/object.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/process.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/random.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/range.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/re.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/select.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/string.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/time.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
enum.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
enum.$(OBJEXT): {$(VPATH)}internal/interpreter.h
enum.$(OBJEXT): {$(VPATH)}internal/iterator.h
enum.$(OBJEXT): {$(VPATH)}internal/memory.h
enum.$(OBJEXT): {$(VPATH)}internal/method.h
enum.$(OBJEXT): {$(VPATH)}internal/module.h
enum.$(OBJEXT): {$(VPATH)}internal/newobj.h
enum.$(OBJEXT): {$(VPATH)}internal/rgengc.h
enum.$(OBJEXT): {$(VPATH)}internal/scan_args.h
enum.$(OBJEXT): {$(VPATH)}internal/special_consts.h
enum.$(OBJEXT): {$(VPATH)}internal/static_assert.h
enum.$(OBJEXT): {$(VPATH)}internal/stdalign.h
enum.$(OBJEXT): {$(VPATH)}internal/stdbool.h
enum.$(OBJEXT): {$(VPATH)}internal/symbol.h
enum.$(OBJEXT): {$(VPATH)}internal/value.h
enum.$(OBJEXT): {$(VPATH)}internal/value_type.h
enum.$(OBJEXT): {$(VPATH)}internal/variable.h
enum.$(OBJEXT): {$(VPATH)}internal/warning_push.h
enum.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
enum.$(OBJEXT): {$(VPATH)}missing.h
enum.$(OBJEXT): {$(VPATH)}onigmo.h
enum.$(OBJEXT): {$(VPATH)}oniguruma.h
enum.$(OBJEXT): {$(VPATH)}ruby_assert.h
enum.$(OBJEXT): {$(VPATH)}shape.h
enum.$(OBJEXT): {$(VPATH)}st.h
enum.$(OBJEXT): {$(VPATH)}subst.h
enum.$(OBJEXT): {$(VPATH)}symbol.h
enum.$(OBJEXT): {$(VPATH)}util.h
enumerator.$(OBJEXT): $(hdrdir)/ruby/ruby.h
enumerator.$(OBJEXT): $(top_srcdir)/internal/array.h
enumerator.$(OBJEXT): $(top_srcdir)/internal/bignum.h
enumerator.$(OBJEXT): $(top_srcdir)/internal/bits.h
enumerator.$(OBJEXT): $(top_srcdir)/internal/compilers.h
enumerator.$(OBJEXT): $(top_srcdir)/internal/enumerator.h
enumerator.$(OBJEXT): $(top_srcdir)/internal/error.h
enumerator.$(OBJEXT): $(top_srcdir)/internal/fixnum.h
enumerator.$(OBJEXT): $(top_srcdir)/internal/gc.h
enumerator.$(OBJEXT): $(top_srcdir)/internal/hash.h
enumerator.$(OBJEXT): $(top_srcdir)/internal/imemo.h
enumerator.$(OBJEXT): $(top_srcdir)/internal/numeric.h
enumerator.$(OBJEXT): $(top_srcdir)/internal/range.h
enumerator.$(OBJEXT): $(top_srcdir)/internal/rational.h
enumerator.$(OBJEXT): $(top_srcdir)/internal/serial.h
enumerator.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
enumerator.$(OBJEXT): $(top_srcdir)/internal/string.h
enumerator.$(OBJEXT): $(top_srcdir)/internal/struct.h
enumerator.$(OBJEXT): $(top_srcdir)/internal/vm.h
enumerator.$(OBJEXT): $(top_srcdir)/internal/warnings.h
enumerator.$(OBJEXT): {$(VPATH)}assert.h
enumerator.$(OBJEXT): {$(VPATH)}backward/2/assume.h
enumerator.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
enumerator.$(OBJEXT): {$(VPATH)}backward/2/bool.h
enumerator.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
enumerator.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
enumerator.$(OBJEXT): {$(VPATH)}backward/2/limits.h
enumerator.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
enumerator.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
enumerator.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
enumerator.$(OBJEXT): {$(VPATH)}config.h
enumerator.$(OBJEXT): {$(VPATH)}defines.h
enumerator.$(OBJEXT): {$(VPATH)}encoding.h
enumerator.$(OBJEXT): {$(VPATH)}enumerator.c
enumerator.$(OBJEXT): {$(VPATH)}id.h
enumerator.$(OBJEXT): {$(VPATH)}intern.h
enumerator.$(OBJEXT): {$(VPATH)}internal.h
enumerator.$(OBJEXT): {$(VPATH)}internal/abi.h
enumerator.$(OBJEXT): {$(VPATH)}internal/anyargs.h
enumerator.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
enumerator.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
enumerator.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
enumerator.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
enumerator.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
enumerator.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
enumerator.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
enumerator.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
enumerator.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
enumerator.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
enumerator.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
enumerator.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
enumerator.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
enumerator.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
enumerator.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
enumerator.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
enumerator.$(OBJEXT): {$(VPATH)}internal/assume.h
enumerator.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
enumerator.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
enumerator.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
enumerator.$(OBJEXT): {$(VPATH)}internal/attr/const.h
enumerator.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
enumerator.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
enumerator.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
enumerator.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
enumerator.$(OBJEXT): {$(VPATH)}internal/attr/error.h
enumerator.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
enumerator.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
enumerator.$(OBJEXT): {$(VPATH)}internal/attr/format.h
enumerator.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
enumerator.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
enumerator.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
enumerator.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
enumerator.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
enumerator.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
enumerator.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
enumerator.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
enumerator.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
enumerator.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
enumerator.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
enumerator.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
enumerator.$(OBJEXT): {$(VPATH)}internal/cast.h
enumerator.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
enumerator.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
enumerator.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
enumerator.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
enumerator.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
enumerator.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
enumerator.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
enumerator.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
enumerator.$(OBJEXT): {$(VPATH)}internal/config.h
enumerator.$(OBJEXT): {$(VPATH)}internal/constant_p.h
enumerator.$(OBJEXT): {$(VPATH)}internal/core.h
enumerator.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
enumerator.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
enumerator.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
enumerator.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
enumerator.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
enumerator.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
enumerator.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
enumerator.$(OBJEXT): {$(VPATH)}internal/core/robject.h
enumerator.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
enumerator.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
enumerator.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
enumerator.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
enumerator.$(OBJEXT): {$(VPATH)}internal/ctype.h
enumerator.$(OBJEXT): {$(VPATH)}internal/dllexport.h
enumerator.$(OBJEXT): {$(VPATH)}internal/dosish.h
enumerator.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
enumerator.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
enumerator.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
enumerator.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
enumerator.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
enumerator.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
enumerator.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
enumerator.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
enumerator.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
enumerator.$(OBJEXT): {$(VPATH)}internal/error.h
enumerator.$(OBJEXT): {$(VPATH)}internal/eval.h
enumerator.$(OBJEXT): {$(VPATH)}internal/event.h
enumerator.$(OBJEXT): {$(VPATH)}internal/fl_type.h
enumerator.$(OBJEXT): {$(VPATH)}internal/gc.h
enumerator.$(OBJEXT): {$(VPATH)}internal/glob.h
enumerator.$(OBJEXT): {$(VPATH)}internal/globals.h
enumerator.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
enumerator.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
enumerator.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
enumerator.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
enumerator.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
enumerator.$(OBJEXT): {$(VPATH)}internal/has/extension.h
enumerator.$(OBJEXT): {$(VPATH)}internal/has/feature.h
enumerator.$(OBJEXT): {$(VPATH)}internal/has/warning.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/array.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/class.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/error.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/file.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/io.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/load.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/object.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/process.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/random.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/range.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/re.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/select.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/string.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/time.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
enumerator.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
enumerator.$(OBJEXT): {$(VPATH)}internal/interpreter.h
enumerator.$(OBJEXT): {$(VPATH)}internal/iterator.h
enumerator.$(OBJEXT): {$(VPATH)}internal/memory.h
enumerator.$(OBJEXT): {$(VPATH)}internal/method.h
enumerator.$(OBJEXT): {$(VPATH)}internal/module.h
enumerator.$(OBJEXT): {$(VPATH)}internal/newobj.h
enumerator.$(OBJEXT): {$(VPATH)}internal/rgengc.h
enumerator.$(OBJEXT): {$(VPATH)}internal/scan_args.h
enumerator.$(OBJEXT): {$(VPATH)}internal/special_consts.h
enumerator.$(OBJEXT): {$(VPATH)}internal/static_assert.h
enumerator.$(OBJEXT): {$(VPATH)}internal/stdalign.h
enumerator.$(OBJEXT): {$(VPATH)}internal/stdbool.h
enumerator.$(OBJEXT): {$(VPATH)}internal/symbol.h
enumerator.$(OBJEXT): {$(VPATH)}internal/value.h
enumerator.$(OBJEXT): {$(VPATH)}internal/value_type.h
enumerator.$(OBJEXT): {$(VPATH)}internal/variable.h
enumerator.$(OBJEXT): {$(VPATH)}internal/warning_push.h
enumerator.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
enumerator.$(OBJEXT): {$(VPATH)}missing.h
enumerator.$(OBJEXT): {$(VPATH)}onigmo.h
enumerator.$(OBJEXT): {$(VPATH)}oniguruma.h
enumerator.$(OBJEXT): {$(VPATH)}ruby_assert.h
enumerator.$(OBJEXT): {$(VPATH)}shape.h
enumerator.$(OBJEXT): {$(VPATH)}st.h
enumerator.$(OBJEXT): {$(VPATH)}subst.h
error.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
error.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
error.$(OBJEXT): $(CCAN_DIR)/list/list.h
error.$(OBJEXT): $(CCAN_DIR)/str/str.h
error.$(OBJEXT): $(hdrdir)/ruby/ruby.h
error.$(OBJEXT): $(top_srcdir)/internal/array.h
error.$(OBJEXT): $(top_srcdir)/internal/class.h
error.$(OBJEXT): $(top_srcdir)/internal/compilers.h
error.$(OBJEXT): $(top_srcdir)/internal/error.h
error.$(OBJEXT): $(top_srcdir)/internal/eval.h
error.$(OBJEXT): $(top_srcdir)/internal/gc.h
error.$(OBJEXT): $(top_srcdir)/internal/hash.h
error.$(OBJEXT): $(top_srcdir)/internal/imemo.h
error.$(OBJEXT): $(top_srcdir)/internal/io.h
error.$(OBJEXT): $(top_srcdir)/internal/load.h
error.$(OBJEXT): $(top_srcdir)/internal/object.h
error.$(OBJEXT): $(top_srcdir)/internal/serial.h
error.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
error.$(OBJEXT): $(top_srcdir)/internal/string.h
error.$(OBJEXT): $(top_srcdir)/internal/symbol.h
error.$(OBJEXT): $(top_srcdir)/internal/thread.h
error.$(OBJEXT): $(top_srcdir)/internal/variable.h
error.$(OBJEXT): $(top_srcdir)/internal/vm.h
error.$(OBJEXT): $(top_srcdir)/internal/warnings.h
error.$(OBJEXT): {$(VPATH)}assert.h
error.$(OBJEXT): {$(VPATH)}atomic.h
error.$(OBJEXT): {$(VPATH)}backward/2/assume.h
error.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
error.$(OBJEXT): {$(VPATH)}backward/2/bool.h
error.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
error.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
error.$(OBJEXT): {$(VPATH)}backward/2/limits.h
error.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
error.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
error.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
error.$(OBJEXT): {$(VPATH)}builtin.h
error.$(OBJEXT): {$(VPATH)}config.h
error.$(OBJEXT): {$(VPATH)}constant.h
error.$(OBJEXT): {$(VPATH)}defines.h
error.$(OBJEXT): {$(VPATH)}encoding.h
error.$(OBJEXT): {$(VPATH)}error.c
error.$(OBJEXT): {$(VPATH)}id.h
error.$(OBJEXT): {$(VPATH)}id_table.h
error.$(OBJEXT): {$(VPATH)}intern.h
error.$(OBJEXT): {$(VPATH)}internal.h
error.$(OBJEXT): {$(VPATH)}internal/abi.h
error.$(OBJEXT): {$(VPATH)}internal/anyargs.h
error.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
error.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
error.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
error.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
error.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
error.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
error.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
error.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
error.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
error.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
error.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
error.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
error.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
error.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
error.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
error.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
error.$(OBJEXT): {$(VPATH)}internal/assume.h
error.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
error.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
error.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
error.$(OBJEXT): {$(VPATH)}internal/attr/const.h
error.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
error.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
error.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
error.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
error.$(OBJEXT): {$(VPATH)}internal/attr/error.h
error.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
error.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
error.$(OBJEXT): {$(VPATH)}internal/attr/format.h
error.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
error.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
error.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
error.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
error.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
error.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
error.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
error.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
error.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
error.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
error.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
error.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
error.$(OBJEXT): {$(VPATH)}internal/cast.h
error.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
error.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
error.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
error.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
error.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
error.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
error.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
error.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
error.$(OBJEXT): {$(VPATH)}internal/config.h
error.$(OBJEXT): {$(VPATH)}internal/constant_p.h
error.$(OBJEXT): {$(VPATH)}internal/core.h
error.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
error.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
error.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
error.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
error.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
error.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
error.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
error.$(OBJEXT): {$(VPATH)}internal/core/robject.h
error.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
error.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
error.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
error.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
error.$(OBJEXT): {$(VPATH)}internal/ctype.h
error.$(OBJEXT): {$(VPATH)}internal/dllexport.h
error.$(OBJEXT): {$(VPATH)}internal/dosish.h
error.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
error.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
error.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
error.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
error.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
error.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
error.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
error.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
error.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
error.$(OBJEXT): {$(VPATH)}internal/error.h
error.$(OBJEXT): {$(VPATH)}internal/eval.h
error.$(OBJEXT): {$(VPATH)}internal/event.h
error.$(OBJEXT): {$(VPATH)}internal/fl_type.h
error.$(OBJEXT): {$(VPATH)}internal/gc.h
error.$(OBJEXT): {$(VPATH)}internal/glob.h
error.$(OBJEXT): {$(VPATH)}internal/globals.h
error.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
error.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
error.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
error.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
error.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
error.$(OBJEXT): {$(VPATH)}internal/has/extension.h
error.$(OBJEXT): {$(VPATH)}internal/has/feature.h
error.$(OBJEXT): {$(VPATH)}internal/has/warning.h
error.$(OBJEXT): {$(VPATH)}internal/intern/array.h
error.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
error.$(OBJEXT): {$(VPATH)}internal/intern/class.h
error.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
error.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
error.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
error.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
error.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
error.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
error.$(OBJEXT): {$(VPATH)}internal/intern/error.h
error.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
error.$(OBJEXT): {$(VPATH)}internal/intern/file.h
error.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
error.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
error.$(OBJEXT): {$(VPATH)}internal/intern/io.h
error.$(OBJEXT): {$(VPATH)}internal/intern/load.h
error.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
error.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
error.$(OBJEXT): {$(VPATH)}internal/intern/object.h
error.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
error.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
error.$(OBJEXT): {$(VPATH)}internal/intern/process.h
error.$(OBJEXT): {$(VPATH)}internal/intern/random.h
error.$(OBJEXT): {$(VPATH)}internal/intern/range.h
error.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
error.$(OBJEXT): {$(VPATH)}internal/intern/re.h
error.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
error.$(OBJEXT): {$(VPATH)}internal/intern/select.h
error.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
error.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
error.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
error.$(OBJEXT): {$(VPATH)}internal/intern/string.h
error.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
error.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
error.$(OBJEXT): {$(VPATH)}internal/intern/time.h
error.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
error.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
error.$(OBJEXT): {$(VPATH)}internal/interpreter.h
error.$(OBJEXT): {$(VPATH)}internal/iterator.h
error.$(OBJEXT): {$(VPATH)}internal/memory.h
error.$(OBJEXT): {$(VPATH)}internal/method.h
error.$(OBJEXT): {$(VPATH)}internal/module.h
error.$(OBJEXT): {$(VPATH)}internal/newobj.h
error.$(OBJEXT): {$(VPATH)}internal/rgengc.h
error.$(OBJEXT): {$(VPATH)}internal/scan_args.h
error.$(OBJEXT): {$(VPATH)}internal/special_consts.h
error.$(OBJEXT): {$(VPATH)}internal/static_assert.h
error.$(OBJEXT): {$(VPATH)}internal/stdalign.h
error.$(OBJEXT): {$(VPATH)}internal/stdbool.h
error.$(OBJEXT): {$(VPATH)}internal/symbol.h
error.$(OBJEXT): {$(VPATH)}internal/value.h
error.$(OBJEXT): {$(VPATH)}internal/value_type.h
error.$(OBJEXT): {$(VPATH)}internal/variable.h
error.$(OBJEXT): {$(VPATH)}internal/warning_push.h
error.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
error.$(OBJEXT): {$(VPATH)}io.h
error.$(OBJEXT): {$(VPATH)}known_errors.inc
error.$(OBJEXT): {$(VPATH)}method.h
error.$(OBJEXT): {$(VPATH)}missing.h
error.$(OBJEXT): {$(VPATH)}node.h
error.$(OBJEXT): {$(VPATH)}onigmo.h
error.$(OBJEXT): {$(VPATH)}oniguruma.h
error.$(OBJEXT): {$(VPATH)}ruby_assert.h
error.$(OBJEXT): {$(VPATH)}ruby_atomic.h
error.$(OBJEXT): {$(VPATH)}shape.h
error.$(OBJEXT): {$(VPATH)}st.h
error.$(OBJEXT): {$(VPATH)}subst.h
error.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
error.$(OBJEXT): {$(VPATH)}thread_native.h
error.$(OBJEXT): {$(VPATH)}vm_core.h
error.$(OBJEXT): {$(VPATH)}vm_opts.h
error.$(OBJEXT): {$(VPATH)}warning.rbinc
eval.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
eval.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
eval.$(OBJEXT): $(CCAN_DIR)/list/list.h
eval.$(OBJEXT): $(CCAN_DIR)/str/str.h
eval.$(OBJEXT): $(hdrdir)/ruby.h
eval.$(OBJEXT): $(hdrdir)/ruby/ruby.h
eval.$(OBJEXT): $(top_srcdir)/internal/array.h
eval.$(OBJEXT): $(top_srcdir)/internal/class.h
eval.$(OBJEXT): $(top_srcdir)/internal/compilers.h
eval.$(OBJEXT): $(top_srcdir)/internal/cont.h
eval.$(OBJEXT): $(top_srcdir)/internal/error.h
eval.$(OBJEXT): $(top_srcdir)/internal/eval.h
eval.$(OBJEXT): $(top_srcdir)/internal/gc.h
eval.$(OBJEXT): $(top_srcdir)/internal/hash.h
eval.$(OBJEXT): $(top_srcdir)/internal/imemo.h
eval.$(OBJEXT): $(top_srcdir)/internal/inits.h
eval.$(OBJEXT): $(top_srcdir)/internal/io.h
eval.$(OBJEXT): $(top_srcdir)/internal/object.h
eval.$(OBJEXT): $(top_srcdir)/internal/serial.h
eval.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
eval.$(OBJEXT): $(top_srcdir)/internal/string.h
eval.$(OBJEXT): $(top_srcdir)/internal/thread.h
eval.$(OBJEXT): $(top_srcdir)/internal/variable.h
eval.$(OBJEXT): $(top_srcdir)/internal/vm.h
eval.$(OBJEXT): $(top_srcdir)/internal/warnings.h
eval.$(OBJEXT): {$(VPATH)}assert.h
eval.$(OBJEXT): {$(VPATH)}atomic.h
eval.$(OBJEXT): {$(VPATH)}backward/2/assume.h
eval.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
eval.$(OBJEXT): {$(VPATH)}backward/2/bool.h
eval.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
eval.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
eval.$(OBJEXT): {$(VPATH)}backward/2/limits.h
eval.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
eval.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
eval.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
eval.$(OBJEXT): {$(VPATH)}config.h
eval.$(OBJEXT): {$(VPATH)}constant.h
eval.$(OBJEXT): {$(VPATH)}debug_counter.h
eval.$(OBJEXT): {$(VPATH)}defines.h
eval.$(OBJEXT): {$(VPATH)}encoding.h
eval.$(OBJEXT): {$(VPATH)}eval.c
eval.$(OBJEXT): {$(VPATH)}eval_error.c
eval.$(OBJEXT): {$(VPATH)}eval_intern.h
eval.$(OBJEXT): {$(VPATH)}eval_jump.c
eval.$(OBJEXT): {$(VPATH)}fiber/scheduler.h
eval.$(OBJEXT): {$(VPATH)}gc.h
eval.$(OBJEXT): {$(VPATH)}id.h
eval.$(OBJEXT): {$(VPATH)}id_table.h
eval.$(OBJEXT): {$(VPATH)}intern.h
eval.$(OBJEXT): {$(VPATH)}internal.h
eval.$(OBJEXT): {$(VPATH)}internal/abi.h
eval.$(OBJEXT): {$(VPATH)}internal/anyargs.h
eval.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
eval.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
eval.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
eval.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
eval.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
eval.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
eval.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
eval.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
eval.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
eval.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
eval.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
eval.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
eval.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
eval.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
eval.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
eval.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
eval.$(OBJEXT): {$(VPATH)}internal/assume.h
eval.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
eval.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
eval.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
eval.$(OBJEXT): {$(VPATH)}internal/attr/const.h
eval.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
eval.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
eval.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
eval.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
eval.$(OBJEXT): {$(VPATH)}internal/attr/error.h
eval.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
eval.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
eval.$(OBJEXT): {$(VPATH)}internal/attr/format.h
eval.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
eval.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
eval.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
eval.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
eval.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
eval.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
eval.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
eval.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
eval.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
eval.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
eval.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
eval.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
eval.$(OBJEXT): {$(VPATH)}internal/cast.h
eval.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
eval.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
eval.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
eval.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
eval.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
eval.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
eval.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
eval.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
eval.$(OBJEXT): {$(VPATH)}internal/config.h
eval.$(OBJEXT): {$(VPATH)}internal/constant_p.h
eval.$(OBJEXT): {$(VPATH)}internal/core.h
eval.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
eval.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
eval.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
eval.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
eval.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
eval.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
eval.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
eval.$(OBJEXT): {$(VPATH)}internal/core/robject.h
eval.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
eval.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
eval.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
eval.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
eval.$(OBJEXT): {$(VPATH)}internal/ctype.h
eval.$(OBJEXT): {$(VPATH)}internal/dllexport.h
eval.$(OBJEXT): {$(VPATH)}internal/dosish.h
eval.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
eval.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
eval.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
eval.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
eval.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
eval.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
eval.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
eval.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
eval.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
eval.$(OBJEXT): {$(VPATH)}internal/error.h
eval.$(OBJEXT): {$(VPATH)}internal/eval.h
eval.$(OBJEXT): {$(VPATH)}internal/event.h
eval.$(OBJEXT): {$(VPATH)}internal/fl_type.h
eval.$(OBJEXT): {$(VPATH)}internal/gc.h
eval.$(OBJEXT): {$(VPATH)}internal/glob.h
eval.$(OBJEXT): {$(VPATH)}internal/globals.h
eval.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
eval.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
eval.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
eval.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
eval.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
eval.$(OBJEXT): {$(VPATH)}internal/has/extension.h
eval.$(OBJEXT): {$(VPATH)}internal/has/feature.h
eval.$(OBJEXT): {$(VPATH)}internal/has/warning.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/array.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/class.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/error.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/file.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/io.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/load.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/object.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/process.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/random.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/range.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/re.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/select.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/string.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/time.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
eval.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
eval.$(OBJEXT): {$(VPATH)}internal/interpreter.h
eval.$(OBJEXT): {$(VPATH)}internal/iterator.h
eval.$(OBJEXT): {$(VPATH)}internal/memory.h
eval.$(OBJEXT): {$(VPATH)}internal/method.h
eval.$(OBJEXT): {$(VPATH)}internal/module.h
eval.$(OBJEXT): {$(VPATH)}internal/newobj.h
eval.$(OBJEXT): {$(VPATH)}internal/rgengc.h
eval.$(OBJEXT): {$(VPATH)}internal/scan_args.h
eval.$(OBJEXT): {$(VPATH)}internal/special_consts.h
eval.$(OBJEXT): {$(VPATH)}internal/static_assert.h
eval.$(OBJEXT): {$(VPATH)}internal/stdalign.h
eval.$(OBJEXT): {$(VPATH)}internal/stdbool.h
eval.$(OBJEXT): {$(VPATH)}internal/symbol.h
eval.$(OBJEXT): {$(VPATH)}internal/value.h
eval.$(OBJEXT): {$(VPATH)}internal/value_type.h
eval.$(OBJEXT): {$(VPATH)}internal/variable.h
eval.$(OBJEXT): {$(VPATH)}internal/warning_push.h
eval.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
eval.$(OBJEXT): {$(VPATH)}io.h
eval.$(OBJEXT): {$(VPATH)}iseq.h
eval.$(OBJEXT): {$(VPATH)}method.h
eval.$(OBJEXT): {$(VPATH)}missing.h
eval.$(OBJEXT): {$(VPATH)}mjit.h
eval.$(OBJEXT): {$(VPATH)}node.h
eval.$(OBJEXT): {$(VPATH)}onigmo.h
eval.$(OBJEXT): {$(VPATH)}oniguruma.h
eval.$(OBJEXT): {$(VPATH)}probes.dmyh
eval.$(OBJEXT): {$(VPATH)}probes.h
eval.$(OBJEXT): {$(VPATH)}probes_helper.h
eval.$(OBJEXT): {$(VPATH)}ractor.h
eval.$(OBJEXT): {$(VPATH)}ractor_core.h
eval.$(OBJEXT): {$(VPATH)}ruby_assert.h
eval.$(OBJEXT): {$(VPATH)}ruby_atomic.h
eval.$(OBJEXT): {$(VPATH)}shape.h
eval.$(OBJEXT): {$(VPATH)}st.h
eval.$(OBJEXT): {$(VPATH)}subst.h
eval.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
eval.$(OBJEXT): {$(VPATH)}thread_native.h
eval.$(OBJEXT): {$(VPATH)}vm.h
eval.$(OBJEXT): {$(VPATH)}vm_core.h
eval.$(OBJEXT): {$(VPATH)}vm_debug.h
eval.$(OBJEXT): {$(VPATH)}vm_opts.h
explicit_bzero.$(OBJEXT): {$(VPATH)}config.h
explicit_bzero.$(OBJEXT): {$(VPATH)}explicit_bzero.c
explicit_bzero.$(OBJEXT): {$(VPATH)}internal/attr/format.h
explicit_bzero.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
explicit_bzero.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
explicit_bzero.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
explicit_bzero.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
explicit_bzero.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
explicit_bzero.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
explicit_bzero.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
explicit_bzero.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
explicit_bzero.$(OBJEXT): {$(VPATH)}internal/config.h
explicit_bzero.$(OBJEXT): {$(VPATH)}internal/dllexport.h
explicit_bzero.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
explicit_bzero.$(OBJEXT): {$(VPATH)}missing.h
file.$(OBJEXT): $(hdrdir)/ruby/ruby.h
file.$(OBJEXT): $(top_srcdir)/internal/array.h
file.$(OBJEXT): $(top_srcdir)/internal/class.h
file.$(OBJEXT): $(top_srcdir)/internal/compilers.h
file.$(OBJEXT): $(top_srcdir)/internal/dir.h
file.$(OBJEXT): $(top_srcdir)/internal/error.h
file.$(OBJEXT): $(top_srcdir)/internal/file.h
file.$(OBJEXT): $(top_srcdir)/internal/gc.h
file.$(OBJEXT): $(top_srcdir)/internal/imemo.h
file.$(OBJEXT): $(top_srcdir)/internal/io.h
file.$(OBJEXT): $(top_srcdir)/internal/load.h
file.$(OBJEXT): $(top_srcdir)/internal/object.h
file.$(OBJEXT): $(top_srcdir)/internal/process.h
file.$(OBJEXT): $(top_srcdir)/internal/serial.h
file.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
file.$(OBJEXT): $(top_srcdir)/internal/string.h
file.$(OBJEXT): $(top_srcdir)/internal/thread.h
file.$(OBJEXT): $(top_srcdir)/internal/variable.h
file.$(OBJEXT): $(top_srcdir)/internal/vm.h
file.$(OBJEXT): $(top_srcdir)/internal/warnings.h
file.$(OBJEXT): {$(VPATH)}assert.h
file.$(OBJEXT): {$(VPATH)}backward/2/assume.h
file.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
file.$(OBJEXT): {$(VPATH)}backward/2/bool.h
file.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
file.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
file.$(OBJEXT): {$(VPATH)}backward/2/limits.h
file.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
file.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
file.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
file.$(OBJEXT): {$(VPATH)}config.h
file.$(OBJEXT): {$(VPATH)}constant.h
file.$(OBJEXT): {$(VPATH)}defines.h
file.$(OBJEXT): {$(VPATH)}dln.h
file.$(OBJEXT): {$(VPATH)}encindex.h
file.$(OBJEXT): {$(VPATH)}encoding.h
file.$(OBJEXT): {$(VPATH)}file.c
file.$(OBJEXT): {$(VPATH)}id.h
file.$(OBJEXT): {$(VPATH)}id_table.h
file.$(OBJEXT): {$(VPATH)}intern.h
file.$(OBJEXT): {$(VPATH)}internal.h
file.$(OBJEXT): {$(VPATH)}internal/abi.h
file.$(OBJEXT): {$(VPATH)}internal/anyargs.h
file.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
file.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
file.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
file.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
file.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
file.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
file.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
file.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
file.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
file.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
file.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
file.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
file.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
file.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
file.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
file.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
file.$(OBJEXT): {$(VPATH)}internal/assume.h
file.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
file.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
file.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
file.$(OBJEXT): {$(VPATH)}internal/attr/const.h
file.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
file.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
file.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
file.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
file.$(OBJEXT): {$(VPATH)}internal/attr/error.h
file.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
file.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
file.$(OBJEXT): {$(VPATH)}internal/attr/format.h
file.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
file.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
file.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
file.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
file.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
file.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
file.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
file.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
file.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
file.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
file.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
file.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
file.$(OBJEXT): {$(VPATH)}internal/cast.h
file.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
file.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
file.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
file.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
file.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
file.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
file.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
file.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
file.$(OBJEXT): {$(VPATH)}internal/config.h
file.$(OBJEXT): {$(VPATH)}internal/constant_p.h
file.$(OBJEXT): {$(VPATH)}internal/core.h
file.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
file.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
file.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
file.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
file.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
file.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
file.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
file.$(OBJEXT): {$(VPATH)}internal/core/robject.h
file.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
file.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
file.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
file.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
file.$(OBJEXT): {$(VPATH)}internal/ctype.h
file.$(OBJEXT): {$(VPATH)}internal/dllexport.h
file.$(OBJEXT): {$(VPATH)}internal/dosish.h
file.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
file.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
file.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
file.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
file.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
file.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
file.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
file.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
file.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
file.$(OBJEXT): {$(VPATH)}internal/error.h
file.$(OBJEXT): {$(VPATH)}internal/eval.h
file.$(OBJEXT): {$(VPATH)}internal/event.h
file.$(OBJEXT): {$(VPATH)}internal/fl_type.h
file.$(OBJEXT): {$(VPATH)}internal/gc.h
file.$(OBJEXT): {$(VPATH)}internal/glob.h
file.$(OBJEXT): {$(VPATH)}internal/globals.h
file.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
file.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
file.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
file.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
file.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
file.$(OBJEXT): {$(VPATH)}internal/has/extension.h
file.$(OBJEXT): {$(VPATH)}internal/has/feature.h
file.$(OBJEXT): {$(VPATH)}internal/has/warning.h
file.$(OBJEXT): {$(VPATH)}internal/intern/array.h
file.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
file.$(OBJEXT): {$(VPATH)}internal/intern/class.h
file.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
file.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
file.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
file.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
file.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
file.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
file.$(OBJEXT): {$(VPATH)}internal/intern/error.h
file.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
file.$(OBJEXT): {$(VPATH)}internal/intern/file.h
file.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
file.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
file.$(OBJEXT): {$(VPATH)}internal/intern/io.h
file.$(OBJEXT): {$(VPATH)}internal/intern/load.h
file.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
file.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
file.$(OBJEXT): {$(VPATH)}internal/intern/object.h
file.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
file.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
file.$(OBJEXT): {$(VPATH)}internal/intern/process.h
file.$(OBJEXT): {$(VPATH)}internal/intern/random.h
file.$(OBJEXT): {$(VPATH)}internal/intern/range.h
file.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
file.$(OBJEXT): {$(VPATH)}internal/intern/re.h
file.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
file.$(OBJEXT): {$(VPATH)}internal/intern/select.h
file.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
file.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
file.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
file.$(OBJEXT): {$(VPATH)}internal/intern/string.h
file.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
file.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
file.$(OBJEXT): {$(VPATH)}internal/intern/time.h
file.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
file.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
file.$(OBJEXT): {$(VPATH)}internal/interpreter.h
file.$(OBJEXT): {$(VPATH)}internal/iterator.h
file.$(OBJEXT): {$(VPATH)}internal/memory.h
file.$(OBJEXT): {$(VPATH)}internal/method.h
file.$(OBJEXT): {$(VPATH)}internal/module.h
file.$(OBJEXT): {$(VPATH)}internal/newobj.h
file.$(OBJEXT): {$(VPATH)}internal/rgengc.h
file.$(OBJEXT): {$(VPATH)}internal/scan_args.h
file.$(OBJEXT): {$(VPATH)}internal/special_consts.h
file.$(OBJEXT): {$(VPATH)}internal/static_assert.h
file.$(OBJEXT): {$(VPATH)}internal/stdalign.h
file.$(OBJEXT): {$(VPATH)}internal/stdbool.h
file.$(OBJEXT): {$(VPATH)}internal/symbol.h
file.$(OBJEXT): {$(VPATH)}internal/value.h
file.$(OBJEXT): {$(VPATH)}internal/value_type.h
file.$(OBJEXT): {$(VPATH)}internal/variable.h
file.$(OBJEXT): {$(VPATH)}internal/warning_push.h
file.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
file.$(OBJEXT): {$(VPATH)}io.h
file.$(OBJEXT): {$(VPATH)}missing.h
file.$(OBJEXT): {$(VPATH)}onigmo.h
file.$(OBJEXT): {$(VPATH)}oniguruma.h
file.$(OBJEXT): {$(VPATH)}shape.h
file.$(OBJEXT): {$(VPATH)}st.h
file.$(OBJEXT): {$(VPATH)}subst.h
file.$(OBJEXT): {$(VPATH)}thread.h
file.$(OBJEXT): {$(VPATH)}util.h
gc.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
gc.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
gc.$(OBJEXT): $(CCAN_DIR)/list/list.h
gc.$(OBJEXT): $(CCAN_DIR)/str/str.h
gc.$(OBJEXT): $(hdrdir)/ruby.h
gc.$(OBJEXT): $(hdrdir)/ruby/ruby.h
gc.$(OBJEXT): $(top_srcdir)/internal/array.h
gc.$(OBJEXT): $(top_srcdir)/internal/bignum.h
gc.$(OBJEXT): $(top_srcdir)/internal/bits.h
gc.$(OBJEXT): $(top_srcdir)/internal/class.h
gc.$(OBJEXT): $(top_srcdir)/internal/compilers.h
gc.$(OBJEXT): $(top_srcdir)/internal/complex.h
gc.$(OBJEXT): $(top_srcdir)/internal/cont.h
gc.$(OBJEXT): $(top_srcdir)/internal/error.h
gc.$(OBJEXT): $(top_srcdir)/internal/eval.h
gc.$(OBJEXT): $(top_srcdir)/internal/fixnum.h
gc.$(OBJEXT): $(top_srcdir)/internal/gc.h
gc.$(OBJEXT): $(top_srcdir)/internal/hash.h
gc.$(OBJEXT): $(top_srcdir)/internal/imemo.h
gc.$(OBJEXT): $(top_srcdir)/internal/io.h
gc.$(OBJEXT): $(top_srcdir)/internal/numeric.h
gc.$(OBJEXT): $(top_srcdir)/internal/object.h
gc.$(OBJEXT): $(top_srcdir)/internal/proc.h
gc.$(OBJEXT): $(top_srcdir)/internal/rational.h
gc.$(OBJEXT): $(top_srcdir)/internal/sanitizers.h
gc.$(OBJEXT): $(top_srcdir)/internal/serial.h
gc.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
gc.$(OBJEXT): $(top_srcdir)/internal/string.h
gc.$(OBJEXT): $(top_srcdir)/internal/struct.h
gc.$(OBJEXT): $(top_srcdir)/internal/symbol.h
gc.$(OBJEXT): $(top_srcdir)/internal/thread.h
gc.$(OBJEXT): $(top_srcdir)/internal/variable.h
gc.$(OBJEXT): $(top_srcdir)/internal/vm.h
gc.$(OBJEXT): $(top_srcdir)/internal/warnings.h
gc.$(OBJEXT): {$(VPATH)}assert.h
gc.$(OBJEXT): {$(VPATH)}atomic.h
gc.$(OBJEXT): {$(VPATH)}backward/2/assume.h
gc.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
gc.$(OBJEXT): {$(VPATH)}backward/2/bool.h
gc.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
gc.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
gc.$(OBJEXT): {$(VPATH)}backward/2/limits.h
gc.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
gc.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
gc.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
gc.$(OBJEXT): {$(VPATH)}builtin.h
gc.$(OBJEXT): {$(VPATH)}config.h
gc.$(OBJEXT): {$(VPATH)}constant.h
gc.$(OBJEXT): {$(VPATH)}debug.h
gc.$(OBJEXT): {$(VPATH)}debug_counter.h
gc.$(OBJEXT): {$(VPATH)}defines.h
gc.$(OBJEXT): {$(VPATH)}encoding.h
gc.$(OBJEXT): {$(VPATH)}eval_intern.h
gc.$(OBJEXT): {$(VPATH)}gc.c
gc.$(OBJEXT): {$(VPATH)}gc.h
gc.$(OBJEXT): {$(VPATH)}gc.rbinc
gc.$(OBJEXT): {$(VPATH)}id.h
gc.$(OBJEXT): {$(VPATH)}id_table.h
gc.$(OBJEXT): {$(VPATH)}intern.h
gc.$(OBJEXT): {$(VPATH)}internal.h
gc.$(OBJEXT): {$(VPATH)}internal/abi.h
gc.$(OBJEXT): {$(VPATH)}internal/anyargs.h
gc.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
gc.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
gc.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
gc.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
gc.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
gc.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
gc.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
gc.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
gc.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
gc.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
gc.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
gc.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
gc.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
gc.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
gc.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
gc.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
gc.$(OBJEXT): {$(VPATH)}internal/assume.h
gc.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
gc.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
gc.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
gc.$(OBJEXT): {$(VPATH)}internal/attr/const.h
gc.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
gc.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
gc.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
gc.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
gc.$(OBJEXT): {$(VPATH)}internal/attr/error.h
gc.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
gc.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
gc.$(OBJEXT): {$(VPATH)}internal/attr/format.h
gc.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
gc.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
gc.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
gc.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
gc.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
gc.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
gc.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
gc.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
gc.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
gc.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
gc.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
gc.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
gc.$(OBJEXT): {$(VPATH)}internal/cast.h
gc.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
gc.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
gc.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
gc.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
gc.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
gc.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
gc.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
gc.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
gc.$(OBJEXT): {$(VPATH)}internal/config.h
gc.$(OBJEXT): {$(VPATH)}internal/constant_p.h
gc.$(OBJEXT): {$(VPATH)}internal/core.h
gc.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
gc.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
gc.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
gc.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
gc.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
gc.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
gc.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
gc.$(OBJEXT): {$(VPATH)}internal/core/rmatch.h
gc.$(OBJEXT): {$(VPATH)}internal/core/robject.h
gc.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
gc.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
gc.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
gc.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
gc.$(OBJEXT): {$(VPATH)}internal/ctype.h
gc.$(OBJEXT): {$(VPATH)}internal/dllexport.h
gc.$(OBJEXT): {$(VPATH)}internal/dosish.h
gc.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
gc.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
gc.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
gc.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
gc.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
gc.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
gc.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
gc.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
gc.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
gc.$(OBJEXT): {$(VPATH)}internal/error.h
gc.$(OBJEXT): {$(VPATH)}internal/eval.h
gc.$(OBJEXT): {$(VPATH)}internal/event.h
gc.$(OBJEXT): {$(VPATH)}internal/fl_type.h
gc.$(OBJEXT): {$(VPATH)}internal/gc.h
gc.$(OBJEXT): {$(VPATH)}internal/glob.h
gc.$(OBJEXT): {$(VPATH)}internal/globals.h
gc.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
gc.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
gc.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
gc.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
gc.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
gc.$(OBJEXT): {$(VPATH)}internal/has/extension.h
gc.$(OBJEXT): {$(VPATH)}internal/has/feature.h
gc.$(OBJEXT): {$(VPATH)}internal/has/warning.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/array.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/class.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/error.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/file.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/io.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/load.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/object.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/process.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/random.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/range.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/re.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/select.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/string.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/time.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
gc.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
gc.$(OBJEXT): {$(VPATH)}internal/interpreter.h
gc.$(OBJEXT): {$(VPATH)}internal/iterator.h
gc.$(OBJEXT): {$(VPATH)}internal/memory.h
gc.$(OBJEXT): {$(VPATH)}internal/method.h
gc.$(OBJEXT): {$(VPATH)}internal/module.h
gc.$(OBJEXT): {$(VPATH)}internal/newobj.h
gc.$(OBJEXT): {$(VPATH)}internal/rgengc.h
gc.$(OBJEXT): {$(VPATH)}internal/scan_args.h
gc.$(OBJEXT): {$(VPATH)}internal/special_consts.h
gc.$(OBJEXT): {$(VPATH)}internal/static_assert.h
gc.$(OBJEXT): {$(VPATH)}internal/stdalign.h
gc.$(OBJEXT): {$(VPATH)}internal/stdbool.h
gc.$(OBJEXT): {$(VPATH)}internal/symbol.h
gc.$(OBJEXT): {$(VPATH)}internal/value.h
gc.$(OBJEXT): {$(VPATH)}internal/value_type.h
gc.$(OBJEXT): {$(VPATH)}internal/variable.h
gc.$(OBJEXT): {$(VPATH)}internal/warning_push.h
gc.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
gc.$(OBJEXT): {$(VPATH)}io.h
gc.$(OBJEXT): {$(VPATH)}iseq.h
gc.$(OBJEXT): {$(VPATH)}method.h
gc.$(OBJEXT): {$(VPATH)}missing.h
gc.$(OBJEXT): {$(VPATH)}mjit.h
gc.$(OBJEXT): {$(VPATH)}node.h
gc.$(OBJEXT): {$(VPATH)}onigmo.h
gc.$(OBJEXT): {$(VPATH)}oniguruma.h
gc.$(OBJEXT): {$(VPATH)}probes.dmyh
gc.$(OBJEXT): {$(VPATH)}probes.h
gc.$(OBJEXT): {$(VPATH)}ractor.h
gc.$(OBJEXT): {$(VPATH)}ractor_core.h
gc.$(OBJEXT): {$(VPATH)}re.h
gc.$(OBJEXT): {$(VPATH)}regenc.h
gc.$(OBJEXT): {$(VPATH)}regex.h
gc.$(OBJEXT): {$(VPATH)}regint.h
gc.$(OBJEXT): {$(VPATH)}ruby_assert.h
gc.$(OBJEXT): {$(VPATH)}ruby_atomic.h
gc.$(OBJEXT): {$(VPATH)}shape.h
gc.$(OBJEXT): {$(VPATH)}st.h
gc.$(OBJEXT): {$(VPATH)}subst.h
gc.$(OBJEXT): {$(VPATH)}symbol.h
gc.$(OBJEXT): {$(VPATH)}thread.h
gc.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
gc.$(OBJEXT): {$(VPATH)}thread_native.h
gc.$(OBJEXT): {$(VPATH)}transient_heap.h
gc.$(OBJEXT): {$(VPATH)}util.h
gc.$(OBJEXT): {$(VPATH)}vm_callinfo.h
gc.$(OBJEXT): {$(VPATH)}vm_core.h
gc.$(OBJEXT): {$(VPATH)}vm_debug.h
gc.$(OBJEXT): {$(VPATH)}vm_opts.h
gc.$(OBJEXT): {$(VPATH)}vm_sync.h
goruby.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
goruby.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
goruby.$(OBJEXT): $(CCAN_DIR)/list/list.h
goruby.$(OBJEXT): $(CCAN_DIR)/str/str.h
goruby.$(OBJEXT): $(hdrdir)/ruby.h
goruby.$(OBJEXT): $(hdrdir)/ruby/ruby.h
goruby.$(OBJEXT): $(top_srcdir)/internal/array.h
goruby.$(OBJEXT): $(top_srcdir)/internal/compilers.h
goruby.$(OBJEXT): $(top_srcdir)/internal/gc.h
goruby.$(OBJEXT): $(top_srcdir)/internal/imemo.h
goruby.$(OBJEXT): $(top_srcdir)/internal/serial.h
goruby.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
goruby.$(OBJEXT): $(top_srcdir)/internal/variable.h
goruby.$(OBJEXT): $(top_srcdir)/internal/vm.h
goruby.$(OBJEXT): $(top_srcdir)/internal/warnings.h
goruby.$(OBJEXT): {$(VPATH)}assert.h
goruby.$(OBJEXT): {$(VPATH)}atomic.h
goruby.$(OBJEXT): {$(VPATH)}backward.h
goruby.$(OBJEXT): {$(VPATH)}backward/2/assume.h
goruby.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
goruby.$(OBJEXT): {$(VPATH)}backward/2/bool.h
goruby.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
goruby.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
goruby.$(OBJEXT): {$(VPATH)}backward/2/limits.h
goruby.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
goruby.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
goruby.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
goruby.$(OBJEXT): {$(VPATH)}config.h
goruby.$(OBJEXT): {$(VPATH)}constant.h
goruby.$(OBJEXT): {$(VPATH)}defines.h
goruby.$(OBJEXT): {$(VPATH)}golf_prelude.c
goruby.$(OBJEXT): {$(VPATH)}goruby.c
goruby.$(OBJEXT): {$(VPATH)}id.h
goruby.$(OBJEXT): {$(VPATH)}id_table.h
goruby.$(OBJEXT): {$(VPATH)}intern.h
goruby.$(OBJEXT): {$(VPATH)}internal.h
goruby.$(OBJEXT): {$(VPATH)}internal/abi.h
goruby.$(OBJEXT): {$(VPATH)}internal/anyargs.h
goruby.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
goruby.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
goruby.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
goruby.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
goruby.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
goruby.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
goruby.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
goruby.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
goruby.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
goruby.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
goruby.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
goruby.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
goruby.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
goruby.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
goruby.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
goruby.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
goruby.$(OBJEXT): {$(VPATH)}internal/assume.h
goruby.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
goruby.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
goruby.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
goruby.$(OBJEXT): {$(VPATH)}internal/attr/const.h
goruby.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
goruby.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
goruby.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
goruby.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
goruby.$(OBJEXT): {$(VPATH)}internal/attr/error.h
goruby.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
goruby.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
goruby.$(OBJEXT): {$(VPATH)}internal/attr/format.h
goruby.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
goruby.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
goruby.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
goruby.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
goruby.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
goruby.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
goruby.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
goruby.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
goruby.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
goruby.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
goruby.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
goruby.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
goruby.$(OBJEXT): {$(VPATH)}internal/cast.h
goruby.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
goruby.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
goruby.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
goruby.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
goruby.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
goruby.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
goruby.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
goruby.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
goruby.$(OBJEXT): {$(VPATH)}internal/config.h
goruby.$(OBJEXT): {$(VPATH)}internal/constant_p.h
goruby.$(OBJEXT): {$(VPATH)}internal/core.h
goruby.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
goruby.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
goruby.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
goruby.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
goruby.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
goruby.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
goruby.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
goruby.$(OBJEXT): {$(VPATH)}internal/core/robject.h
goruby.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
goruby.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
goruby.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
goruby.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
goruby.$(OBJEXT): {$(VPATH)}internal/ctype.h
goruby.$(OBJEXT): {$(VPATH)}internal/dllexport.h
goruby.$(OBJEXT): {$(VPATH)}internal/dosish.h
goruby.$(OBJEXT): {$(VPATH)}internal/error.h
goruby.$(OBJEXT): {$(VPATH)}internal/eval.h
goruby.$(OBJEXT): {$(VPATH)}internal/event.h
goruby.$(OBJEXT): {$(VPATH)}internal/fl_type.h
goruby.$(OBJEXT): {$(VPATH)}internal/gc.h
goruby.$(OBJEXT): {$(VPATH)}internal/glob.h
goruby.$(OBJEXT): {$(VPATH)}internal/globals.h
goruby.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
goruby.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
goruby.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
goruby.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
goruby.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
goruby.$(OBJEXT): {$(VPATH)}internal/has/extension.h
goruby.$(OBJEXT): {$(VPATH)}internal/has/feature.h
goruby.$(OBJEXT): {$(VPATH)}internal/has/warning.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/array.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/class.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/error.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/file.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/io.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/load.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/object.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/process.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/random.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/range.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/re.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/select.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/string.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/time.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
goruby.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
goruby.$(OBJEXT): {$(VPATH)}internal/interpreter.h
goruby.$(OBJEXT): {$(VPATH)}internal/iterator.h
goruby.$(OBJEXT): {$(VPATH)}internal/memory.h
goruby.$(OBJEXT): {$(VPATH)}internal/method.h
goruby.$(OBJEXT): {$(VPATH)}internal/module.h
goruby.$(OBJEXT): {$(VPATH)}internal/newobj.h
goruby.$(OBJEXT): {$(VPATH)}internal/rgengc.h
goruby.$(OBJEXT): {$(VPATH)}internal/scan_args.h
goruby.$(OBJEXT): {$(VPATH)}internal/special_consts.h
goruby.$(OBJEXT): {$(VPATH)}internal/static_assert.h
goruby.$(OBJEXT): {$(VPATH)}internal/stdalign.h
goruby.$(OBJEXT): {$(VPATH)}internal/stdbool.h
goruby.$(OBJEXT): {$(VPATH)}internal/symbol.h
goruby.$(OBJEXT): {$(VPATH)}internal/value.h
goruby.$(OBJEXT): {$(VPATH)}internal/value_type.h
goruby.$(OBJEXT): {$(VPATH)}internal/variable.h
goruby.$(OBJEXT): {$(VPATH)}internal/warning_push.h
goruby.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
goruby.$(OBJEXT): {$(VPATH)}iseq.h
goruby.$(OBJEXT): {$(VPATH)}main.c
goruby.$(OBJEXT): {$(VPATH)}method.h
goruby.$(OBJEXT): {$(VPATH)}missing.h
goruby.$(OBJEXT): {$(VPATH)}node.h
goruby.$(OBJEXT): {$(VPATH)}ruby_assert.h
goruby.$(OBJEXT): {$(VPATH)}ruby_atomic.h
goruby.$(OBJEXT): {$(VPATH)}shape.h
goruby.$(OBJEXT): {$(VPATH)}st.h
goruby.$(OBJEXT): {$(VPATH)}subst.h
goruby.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
goruby.$(OBJEXT): {$(VPATH)}thread_native.h
goruby.$(OBJEXT): {$(VPATH)}vm_core.h
goruby.$(OBJEXT): {$(VPATH)}vm_debug.h
goruby.$(OBJEXT): {$(VPATH)}vm_opts.h
hash.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
hash.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
hash.$(OBJEXT): $(CCAN_DIR)/list/list.h
hash.$(OBJEXT): $(CCAN_DIR)/str/str.h
hash.$(OBJEXT): $(hdrdir)/ruby/ruby.h
hash.$(OBJEXT): $(top_srcdir)/internal/array.h
hash.$(OBJEXT): $(top_srcdir)/internal/bignum.h
hash.$(OBJEXT): $(top_srcdir)/internal/bits.h
hash.$(OBJEXT): $(top_srcdir)/internal/class.h
hash.$(OBJEXT): $(top_srcdir)/internal/compilers.h
hash.$(OBJEXT): $(top_srcdir)/internal/cont.h
hash.$(OBJEXT): $(top_srcdir)/internal/error.h
hash.$(OBJEXT): $(top_srcdir)/internal/gc.h
hash.$(OBJEXT): $(top_srcdir)/internal/hash.h
hash.$(OBJEXT): $(top_srcdir)/internal/imemo.h
hash.$(OBJEXT): $(top_srcdir)/internal/object.h
hash.$(OBJEXT): $(top_srcdir)/internal/proc.h
hash.$(OBJEXT): $(top_srcdir)/internal/serial.h
hash.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
hash.$(OBJEXT): $(top_srcdir)/internal/string.h
hash.$(OBJEXT): $(top_srcdir)/internal/symbol.h
hash.$(OBJEXT): $(top_srcdir)/internal/thread.h
hash.$(OBJEXT): $(top_srcdir)/internal/time.h
hash.$(OBJEXT): $(top_srcdir)/internal/variable.h
hash.$(OBJEXT): $(top_srcdir)/internal/vm.h
hash.$(OBJEXT): $(top_srcdir)/internal/warnings.h
hash.$(OBJEXT): {$(VPATH)}assert.h
hash.$(OBJEXT): {$(VPATH)}atomic.h
hash.$(OBJEXT): {$(VPATH)}backward/2/assume.h
hash.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
hash.$(OBJEXT): {$(VPATH)}backward/2/bool.h
hash.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
hash.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
hash.$(OBJEXT): {$(VPATH)}backward/2/limits.h
hash.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
hash.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
hash.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
hash.$(OBJEXT): {$(VPATH)}config.h
hash.$(OBJEXT): {$(VPATH)}constant.h
hash.$(OBJEXT): {$(VPATH)}debug_counter.h
hash.$(OBJEXT): {$(VPATH)}defines.h
hash.$(OBJEXT): {$(VPATH)}encoding.h
hash.$(OBJEXT): {$(VPATH)}hash.c
hash.$(OBJEXT): {$(VPATH)}id.h
hash.$(OBJEXT): {$(VPATH)}id_table.h
hash.$(OBJEXT): {$(VPATH)}intern.h
hash.$(OBJEXT): {$(VPATH)}internal.h
hash.$(OBJEXT): {$(VPATH)}internal/abi.h
hash.$(OBJEXT): {$(VPATH)}internal/anyargs.h
hash.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
hash.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
hash.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
hash.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
hash.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
hash.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
hash.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
hash.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
hash.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
hash.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
hash.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
hash.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
hash.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
hash.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
hash.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
hash.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
hash.$(OBJEXT): {$(VPATH)}internal/assume.h
hash.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
hash.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
hash.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
hash.$(OBJEXT): {$(VPATH)}internal/attr/const.h
hash.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
hash.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
hash.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
hash.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
hash.$(OBJEXT): {$(VPATH)}internal/attr/error.h
hash.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
hash.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
hash.$(OBJEXT): {$(VPATH)}internal/attr/format.h
hash.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
hash.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
hash.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
hash.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
hash.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
hash.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
hash.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
hash.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
hash.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
hash.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
hash.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
hash.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
hash.$(OBJEXT): {$(VPATH)}internal/cast.h
hash.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
hash.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
hash.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
hash.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
hash.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
hash.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
hash.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
hash.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
hash.$(OBJEXT): {$(VPATH)}internal/config.h
hash.$(OBJEXT): {$(VPATH)}internal/constant_p.h
hash.$(OBJEXT): {$(VPATH)}internal/core.h
hash.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
hash.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
hash.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
hash.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
hash.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
hash.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
hash.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
hash.$(OBJEXT): {$(VPATH)}internal/core/robject.h
hash.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
hash.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
hash.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
hash.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
hash.$(OBJEXT): {$(VPATH)}internal/ctype.h
hash.$(OBJEXT): {$(VPATH)}internal/dllexport.h
hash.$(OBJEXT): {$(VPATH)}internal/dosish.h
hash.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
hash.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
hash.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
hash.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
hash.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
hash.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
hash.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
hash.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
hash.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
hash.$(OBJEXT): {$(VPATH)}internal/error.h
hash.$(OBJEXT): {$(VPATH)}internal/eval.h
hash.$(OBJEXT): {$(VPATH)}internal/event.h
hash.$(OBJEXT): {$(VPATH)}internal/fl_type.h
hash.$(OBJEXT): {$(VPATH)}internal/gc.h
hash.$(OBJEXT): {$(VPATH)}internal/glob.h
hash.$(OBJEXT): {$(VPATH)}internal/globals.h
hash.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
hash.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
hash.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
hash.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
hash.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
hash.$(OBJEXT): {$(VPATH)}internal/has/extension.h
hash.$(OBJEXT): {$(VPATH)}internal/has/feature.h
hash.$(OBJEXT): {$(VPATH)}internal/has/warning.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/array.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/class.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/error.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/file.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/io.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/load.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/object.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/process.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/random.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/range.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/re.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/select.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/string.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/time.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
hash.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
hash.$(OBJEXT): {$(VPATH)}internal/interpreter.h
hash.$(OBJEXT): {$(VPATH)}internal/iterator.h
hash.$(OBJEXT): {$(VPATH)}internal/memory.h
hash.$(OBJEXT): {$(VPATH)}internal/method.h
hash.$(OBJEXT): {$(VPATH)}internal/module.h
hash.$(OBJEXT): {$(VPATH)}internal/newobj.h
hash.$(OBJEXT): {$(VPATH)}internal/rgengc.h
hash.$(OBJEXT): {$(VPATH)}internal/scan_args.h
hash.$(OBJEXT): {$(VPATH)}internal/special_consts.h
hash.$(OBJEXT): {$(VPATH)}internal/static_assert.h
hash.$(OBJEXT): {$(VPATH)}internal/stdalign.h
hash.$(OBJEXT): {$(VPATH)}internal/stdbool.h
hash.$(OBJEXT): {$(VPATH)}internal/symbol.h
hash.$(OBJEXT): {$(VPATH)}internal/value.h
hash.$(OBJEXT): {$(VPATH)}internal/value_type.h
hash.$(OBJEXT): {$(VPATH)}internal/variable.h
hash.$(OBJEXT): {$(VPATH)}internal/warning_push.h
hash.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
hash.$(OBJEXT): {$(VPATH)}iseq.h
hash.$(OBJEXT): {$(VPATH)}method.h
hash.$(OBJEXT): {$(VPATH)}missing.h
hash.$(OBJEXT): {$(VPATH)}node.h
hash.$(OBJEXT): {$(VPATH)}onigmo.h
hash.$(OBJEXT): {$(VPATH)}oniguruma.h
hash.$(OBJEXT): {$(VPATH)}probes.dmyh
hash.$(OBJEXT): {$(VPATH)}probes.h
hash.$(OBJEXT): {$(VPATH)}ractor.h
hash.$(OBJEXT): {$(VPATH)}ruby_assert.h
hash.$(OBJEXT): {$(VPATH)}ruby_atomic.h
hash.$(OBJEXT): {$(VPATH)}shape.h
hash.$(OBJEXT): {$(VPATH)}st.h
hash.$(OBJEXT): {$(VPATH)}subst.h
hash.$(OBJEXT): {$(VPATH)}symbol.h
hash.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
hash.$(OBJEXT): {$(VPATH)}thread_native.h
hash.$(OBJEXT): {$(VPATH)}transient_heap.h
hash.$(OBJEXT): {$(VPATH)}util.h
hash.$(OBJEXT): {$(VPATH)}vm_core.h
hash.$(OBJEXT): {$(VPATH)}vm_debug.h
hash.$(OBJEXT): {$(VPATH)}vm_opts.h
hash.$(OBJEXT): {$(VPATH)}vm_sync.h
inits.$(OBJEXT): $(hdrdir)/ruby.h
inits.$(OBJEXT): $(hdrdir)/ruby/ruby.h
inits.$(OBJEXT): $(top_srcdir)/internal/compilers.h
inits.$(OBJEXT): $(top_srcdir)/internal/inits.h
inits.$(OBJEXT): $(top_srcdir)/internal/warnings.h
inits.$(OBJEXT): {$(VPATH)}assert.h
inits.$(OBJEXT): {$(VPATH)}backward/2/assume.h
inits.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
inits.$(OBJEXT): {$(VPATH)}backward/2/bool.h
inits.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
inits.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
inits.$(OBJEXT): {$(VPATH)}backward/2/limits.h
inits.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
inits.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
inits.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
inits.$(OBJEXT): {$(VPATH)}builtin.h
inits.$(OBJEXT): {$(VPATH)}config.h
inits.$(OBJEXT): {$(VPATH)}defines.h
inits.$(OBJEXT): {$(VPATH)}inits.c
inits.$(OBJEXT): {$(VPATH)}intern.h
inits.$(OBJEXT): {$(VPATH)}internal/abi.h
inits.$(OBJEXT): {$(VPATH)}internal/anyargs.h
inits.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
inits.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
inits.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
inits.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
inits.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
inits.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
inits.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
inits.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
inits.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
inits.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
inits.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
inits.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
inits.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
inits.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
inits.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
inits.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
inits.$(OBJEXT): {$(VPATH)}internal/assume.h
inits.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
inits.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
inits.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
inits.$(OBJEXT): {$(VPATH)}internal/attr/const.h
inits.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
inits.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
inits.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
inits.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
inits.$(OBJEXT): {$(VPATH)}internal/attr/error.h
inits.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
inits.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
inits.$(OBJEXT): {$(VPATH)}internal/attr/format.h
inits.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
inits.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
inits.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
inits.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
inits.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
inits.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
inits.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
inits.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
inits.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
inits.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
inits.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
inits.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
inits.$(OBJEXT): {$(VPATH)}internal/cast.h
inits.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
inits.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
inits.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
inits.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
inits.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
inits.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
inits.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
inits.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
inits.$(OBJEXT): {$(VPATH)}internal/config.h
inits.$(OBJEXT): {$(VPATH)}internal/constant_p.h
inits.$(OBJEXT): {$(VPATH)}internal/core.h
inits.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
inits.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
inits.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
inits.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
inits.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
inits.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
inits.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
inits.$(OBJEXT): {$(VPATH)}internal/core/robject.h
inits.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
inits.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
inits.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
inits.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
inits.$(OBJEXT): {$(VPATH)}internal/ctype.h
inits.$(OBJEXT): {$(VPATH)}internal/dllexport.h
inits.$(OBJEXT): {$(VPATH)}internal/dosish.h
inits.$(OBJEXT): {$(VPATH)}internal/error.h
inits.$(OBJEXT): {$(VPATH)}internal/eval.h
inits.$(OBJEXT): {$(VPATH)}internal/event.h
inits.$(OBJEXT): {$(VPATH)}internal/fl_type.h
inits.$(OBJEXT): {$(VPATH)}internal/gc.h
inits.$(OBJEXT): {$(VPATH)}internal/glob.h
inits.$(OBJEXT): {$(VPATH)}internal/globals.h
inits.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
inits.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
inits.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
inits.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
inits.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
inits.$(OBJEXT): {$(VPATH)}internal/has/extension.h
inits.$(OBJEXT): {$(VPATH)}internal/has/feature.h
inits.$(OBJEXT): {$(VPATH)}internal/has/warning.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/array.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/class.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/error.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/file.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/io.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/load.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/object.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/process.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/random.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/range.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/re.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/select.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/string.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/time.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
inits.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
inits.$(OBJEXT): {$(VPATH)}internal/interpreter.h
inits.$(OBJEXT): {$(VPATH)}internal/iterator.h
inits.$(OBJEXT): {$(VPATH)}internal/memory.h
inits.$(OBJEXT): {$(VPATH)}internal/method.h
inits.$(OBJEXT): {$(VPATH)}internal/module.h
inits.$(OBJEXT): {$(VPATH)}internal/newobj.h
inits.$(OBJEXT): {$(VPATH)}internal/rgengc.h
inits.$(OBJEXT): {$(VPATH)}internal/scan_args.h
inits.$(OBJEXT): {$(VPATH)}internal/special_consts.h
inits.$(OBJEXT): {$(VPATH)}internal/static_assert.h
inits.$(OBJEXT): {$(VPATH)}internal/stdalign.h
inits.$(OBJEXT): {$(VPATH)}internal/stdbool.h
inits.$(OBJEXT): {$(VPATH)}internal/symbol.h
inits.$(OBJEXT): {$(VPATH)}internal/value.h
inits.$(OBJEXT): {$(VPATH)}internal/value_type.h
inits.$(OBJEXT): {$(VPATH)}internal/variable.h
inits.$(OBJEXT): {$(VPATH)}internal/warning_push.h
inits.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
inits.$(OBJEXT): {$(VPATH)}missing.h
inits.$(OBJEXT): {$(VPATH)}prelude.rbinc
inits.$(OBJEXT): {$(VPATH)}st.h
inits.$(OBJEXT): {$(VPATH)}subst.h
io.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
io.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
io.$(OBJEXT): $(CCAN_DIR)/list/list.h
io.$(OBJEXT): $(CCAN_DIR)/str/str.h
io.$(OBJEXT): $(hdrdir)/ruby/ruby.h
io.$(OBJEXT): $(top_srcdir)/internal/array.h
io.$(OBJEXT): $(top_srcdir)/internal/bignum.h
io.$(OBJEXT): $(top_srcdir)/internal/bits.h
io.$(OBJEXT): $(top_srcdir)/internal/class.h
io.$(OBJEXT): $(top_srcdir)/internal/compilers.h
io.$(OBJEXT): $(top_srcdir)/internal/encoding.h
io.$(OBJEXT): $(top_srcdir)/internal/error.h
io.$(OBJEXT): $(top_srcdir)/internal/fixnum.h
io.$(OBJEXT): $(top_srcdir)/internal/gc.h
io.$(OBJEXT): $(top_srcdir)/internal/imemo.h
io.$(OBJEXT): $(top_srcdir)/internal/inits.h
io.$(OBJEXT): $(top_srcdir)/internal/io.h
io.$(OBJEXT): $(top_srcdir)/internal/numeric.h
io.$(OBJEXT): $(top_srcdir)/internal/object.h
io.$(OBJEXT): $(top_srcdir)/internal/process.h
io.$(OBJEXT): $(top_srcdir)/internal/serial.h
io.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
io.$(OBJEXT): $(top_srcdir)/internal/string.h
io.$(OBJEXT): $(top_srcdir)/internal/thread.h
io.$(OBJEXT): $(top_srcdir)/internal/transcode.h
io.$(OBJEXT): $(top_srcdir)/internal/variable.h
io.$(OBJEXT): $(top_srcdir)/internal/vm.h
io.$(OBJEXT): $(top_srcdir)/internal/warnings.h
io.$(OBJEXT): {$(VPATH)}assert.h
io.$(OBJEXT): {$(VPATH)}atomic.h
io.$(OBJEXT): {$(VPATH)}backward/2/assume.h
io.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
io.$(OBJEXT): {$(VPATH)}backward/2/bool.h
io.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
io.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
io.$(OBJEXT): {$(VPATH)}backward/2/limits.h
io.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
io.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
io.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
io.$(OBJEXT): {$(VPATH)}builtin.h
io.$(OBJEXT): {$(VPATH)}config.h
io.$(OBJEXT): {$(VPATH)}constant.h
io.$(OBJEXT): {$(VPATH)}defines.h
io.$(OBJEXT): {$(VPATH)}dln.h
io.$(OBJEXT): {$(VPATH)}encindex.h
io.$(OBJEXT): {$(VPATH)}encoding.h
io.$(OBJEXT): {$(VPATH)}fiber/scheduler.h
io.$(OBJEXT): {$(VPATH)}id.h
io.$(OBJEXT): {$(VPATH)}id_table.h
io.$(OBJEXT): {$(VPATH)}intern.h
io.$(OBJEXT): {$(VPATH)}internal.h
io.$(OBJEXT): {$(VPATH)}internal/abi.h
io.$(OBJEXT): {$(VPATH)}internal/anyargs.h
io.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
io.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
io.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
io.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
io.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
io.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
io.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
io.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
io.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
io.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
io.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
io.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
io.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
io.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
io.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
io.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
io.$(OBJEXT): {$(VPATH)}internal/assume.h
io.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
io.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
io.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
io.$(OBJEXT): {$(VPATH)}internal/attr/const.h
io.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
io.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
io.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
io.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
io.$(OBJEXT): {$(VPATH)}internal/attr/error.h
io.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
io.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
io.$(OBJEXT): {$(VPATH)}internal/attr/format.h
io.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
io.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
io.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
io.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
io.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
io.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
io.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
io.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
io.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
io.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
io.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
io.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
io.$(OBJEXT): {$(VPATH)}internal/cast.h
io.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
io.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
io.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
io.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
io.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
io.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
io.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
io.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
io.$(OBJEXT): {$(VPATH)}internal/config.h
io.$(OBJEXT): {$(VPATH)}internal/constant_p.h
io.$(OBJEXT): {$(VPATH)}internal/core.h
io.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
io.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
io.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
io.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
io.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
io.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
io.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
io.$(OBJEXT): {$(VPATH)}internal/core/robject.h
io.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
io.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
io.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
io.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
io.$(OBJEXT): {$(VPATH)}internal/ctype.h
io.$(OBJEXT): {$(VPATH)}internal/dllexport.h
io.$(OBJEXT): {$(VPATH)}internal/dosish.h
io.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
io.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
io.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
io.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
io.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
io.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
io.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
io.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
io.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
io.$(OBJEXT): {$(VPATH)}internal/error.h
io.$(OBJEXT): {$(VPATH)}internal/eval.h
io.$(OBJEXT): {$(VPATH)}internal/event.h
io.$(OBJEXT): {$(VPATH)}internal/fl_type.h
io.$(OBJEXT): {$(VPATH)}internal/gc.h
io.$(OBJEXT): {$(VPATH)}internal/glob.h
io.$(OBJEXT): {$(VPATH)}internal/globals.h
io.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
io.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
io.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
io.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
io.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
io.$(OBJEXT): {$(VPATH)}internal/has/extension.h
io.$(OBJEXT): {$(VPATH)}internal/has/feature.h
io.$(OBJEXT): {$(VPATH)}internal/has/warning.h
io.$(OBJEXT): {$(VPATH)}internal/intern/array.h
io.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
io.$(OBJEXT): {$(VPATH)}internal/intern/class.h
io.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
io.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
io.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
io.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
io.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
io.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
io.$(OBJEXT): {$(VPATH)}internal/intern/error.h
io.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
io.$(OBJEXT): {$(VPATH)}internal/intern/file.h
io.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
io.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
io.$(OBJEXT): {$(VPATH)}internal/intern/io.h
io.$(OBJEXT): {$(VPATH)}internal/intern/load.h
io.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
io.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
io.$(OBJEXT): {$(VPATH)}internal/intern/object.h
io.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
io.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
io.$(OBJEXT): {$(VPATH)}internal/intern/process.h
io.$(OBJEXT): {$(VPATH)}internal/intern/random.h
io.$(OBJEXT): {$(VPATH)}internal/intern/range.h
io.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
io.$(OBJEXT): {$(VPATH)}internal/intern/re.h
io.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
io.$(OBJEXT): {$(VPATH)}internal/intern/select.h
io.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
io.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
io.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
io.$(OBJEXT): {$(VPATH)}internal/intern/string.h
io.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
io.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
io.$(OBJEXT): {$(VPATH)}internal/intern/time.h
io.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
io.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
io.$(OBJEXT): {$(VPATH)}internal/interpreter.h
io.$(OBJEXT): {$(VPATH)}internal/iterator.h
io.$(OBJEXT): {$(VPATH)}internal/memory.h
io.$(OBJEXT): {$(VPATH)}internal/method.h
io.$(OBJEXT): {$(VPATH)}internal/module.h
io.$(OBJEXT): {$(VPATH)}internal/newobj.h
io.$(OBJEXT): {$(VPATH)}internal/rgengc.h
io.$(OBJEXT): {$(VPATH)}internal/scan_args.h
io.$(OBJEXT): {$(VPATH)}internal/special_consts.h
io.$(OBJEXT): {$(VPATH)}internal/static_assert.h
io.$(OBJEXT): {$(VPATH)}internal/stdalign.h
io.$(OBJEXT): {$(VPATH)}internal/stdbool.h
io.$(OBJEXT): {$(VPATH)}internal/symbol.h
io.$(OBJEXT): {$(VPATH)}internal/value.h
io.$(OBJEXT): {$(VPATH)}internal/value_type.h
io.$(OBJEXT): {$(VPATH)}internal/variable.h
io.$(OBJEXT): {$(VPATH)}internal/warning_push.h
io.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
io.$(OBJEXT): {$(VPATH)}io.c
io.$(OBJEXT): {$(VPATH)}io.h
io.$(OBJEXT): {$(VPATH)}io.rbinc
io.$(OBJEXT): {$(VPATH)}io/buffer.h
io.$(OBJEXT): {$(VPATH)}method.h
io.$(OBJEXT): {$(VPATH)}missing.h
io.$(OBJEXT): {$(VPATH)}node.h
io.$(OBJEXT): {$(VPATH)}onigmo.h
io.$(OBJEXT): {$(VPATH)}oniguruma.h
io.$(OBJEXT): {$(VPATH)}ractor.h
io.$(OBJEXT): {$(VPATH)}ruby_assert.h
io.$(OBJEXT): {$(VPATH)}ruby_atomic.h
io.$(OBJEXT): {$(VPATH)}shape.h
io.$(OBJEXT): {$(VPATH)}st.h
io.$(OBJEXT): {$(VPATH)}subst.h
io.$(OBJEXT): {$(VPATH)}thread.h
io.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
io.$(OBJEXT): {$(VPATH)}thread_native.h
io.$(OBJEXT): {$(VPATH)}util.h
io.$(OBJEXT): {$(VPATH)}vm_core.h
io.$(OBJEXT): {$(VPATH)}vm_opts.h
io_buffer.$(OBJEXT): $(hdrdir)/ruby/ruby.h
io_buffer.$(OBJEXT): $(top_srcdir)/internal/array.h
io_buffer.$(OBJEXT): $(top_srcdir)/internal/bignum.h
io_buffer.$(OBJEXT): $(top_srcdir)/internal/bits.h
io_buffer.$(OBJEXT): $(top_srcdir)/internal/compilers.h
io_buffer.$(OBJEXT): $(top_srcdir)/internal/error.h
io_buffer.$(OBJEXT): $(top_srcdir)/internal/fixnum.h
io_buffer.$(OBJEXT): $(top_srcdir)/internal/numeric.h
io_buffer.$(OBJEXT): $(top_srcdir)/internal/serial.h
io_buffer.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
io_buffer.$(OBJEXT): $(top_srcdir)/internal/string.h
io_buffer.$(OBJEXT): $(top_srcdir)/internal/thread.h
io_buffer.$(OBJEXT): $(top_srcdir)/internal/vm.h
io_buffer.$(OBJEXT): {$(VPATH)}assert.h
io_buffer.$(OBJEXT): {$(VPATH)}backward/2/assume.h
io_buffer.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
io_buffer.$(OBJEXT): {$(VPATH)}backward/2/bool.h
io_buffer.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
io_buffer.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
io_buffer.$(OBJEXT): {$(VPATH)}backward/2/limits.h
io_buffer.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
io_buffer.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
io_buffer.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
io_buffer.$(OBJEXT): {$(VPATH)}config.h
io_buffer.$(OBJEXT): {$(VPATH)}defines.h
io_buffer.$(OBJEXT): {$(VPATH)}encoding.h
io_buffer.$(OBJEXT): {$(VPATH)}fiber/scheduler.h
io_buffer.$(OBJEXT): {$(VPATH)}intern.h
io_buffer.$(OBJEXT): {$(VPATH)}internal.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/abi.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/anyargs.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/assume.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/attr/const.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/attr/error.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/attr/format.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/cast.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/config.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/constant_p.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/core.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/core/robject.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/ctype.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/dllexport.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/dosish.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/error.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/eval.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/event.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/fl_type.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/gc.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/glob.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/globals.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/has/extension.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/has/feature.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/has/warning.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/array.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/class.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/error.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/file.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/io.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/load.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/object.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/process.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/random.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/range.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/re.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/select.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/string.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/time.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/interpreter.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/iterator.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/memory.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/method.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/module.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/newobj.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/rgengc.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/scan_args.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/special_consts.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/static_assert.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/stdalign.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/stdbool.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/symbol.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/value.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/value_type.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/variable.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/warning_push.h
io_buffer.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
io_buffer.$(OBJEXT): {$(VPATH)}io.h
io_buffer.$(OBJEXT): {$(VPATH)}io/buffer.h
io_buffer.$(OBJEXT): {$(VPATH)}io_buffer.c
io_buffer.$(OBJEXT): {$(VPATH)}missing.h
io_buffer.$(OBJEXT): {$(VPATH)}onigmo.h
io_buffer.$(OBJEXT): {$(VPATH)}oniguruma.h
io_buffer.$(OBJEXT): {$(VPATH)}st.h
io_buffer.$(OBJEXT): {$(VPATH)}subst.h
iseq.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
iseq.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
iseq.$(OBJEXT): $(CCAN_DIR)/list/list.h
iseq.$(OBJEXT): $(CCAN_DIR)/str/str.h
iseq.$(OBJEXT): $(hdrdir)/ruby.h
iseq.$(OBJEXT): $(hdrdir)/ruby/ruby.h
iseq.$(OBJEXT): $(top_srcdir)/internal/array.h
iseq.$(OBJEXT): $(top_srcdir)/internal/bits.h
iseq.$(OBJEXT): $(top_srcdir)/internal/class.h
iseq.$(OBJEXT): $(top_srcdir)/internal/compile.h
iseq.$(OBJEXT): $(top_srcdir)/internal/compilers.h
iseq.$(OBJEXT): $(top_srcdir)/internal/error.h
iseq.$(OBJEXT): $(top_srcdir)/internal/file.h
iseq.$(OBJEXT): $(top_srcdir)/internal/gc.h
iseq.$(OBJEXT): $(top_srcdir)/internal/hash.h
iseq.$(OBJEXT): $(top_srcdir)/internal/imemo.h
iseq.$(OBJEXT): $(top_srcdir)/internal/parse.h
iseq.$(OBJEXT): $(top_srcdir)/internal/sanitizers.h
iseq.$(OBJEXT): $(top_srcdir)/internal/serial.h
iseq.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
iseq.$(OBJEXT): $(top_srcdir)/internal/string.h
iseq.$(OBJEXT): $(top_srcdir)/internal/symbol.h
iseq.$(OBJEXT): $(top_srcdir)/internal/thread.h
iseq.$(OBJEXT): $(top_srcdir)/internal/variable.h
iseq.$(OBJEXT): $(top_srcdir)/internal/vm.h
iseq.$(OBJEXT): $(top_srcdir)/internal/warnings.h
iseq.$(OBJEXT): {$(VPATH)}assert.h
iseq.$(OBJEXT): {$(VPATH)}atomic.h
iseq.$(OBJEXT): {$(VPATH)}backward/2/assume.h
iseq.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
iseq.$(OBJEXT): {$(VPATH)}backward/2/bool.h
iseq.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
iseq.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
iseq.$(OBJEXT): {$(VPATH)}backward/2/limits.h
iseq.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
iseq.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
iseq.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
iseq.$(OBJEXT): {$(VPATH)}builtin.h
iseq.$(OBJEXT): {$(VPATH)}config.h
iseq.$(OBJEXT): {$(VPATH)}constant.h
iseq.$(OBJEXT): {$(VPATH)}debug_counter.h
iseq.$(OBJEXT): {$(VPATH)}defines.h
iseq.$(OBJEXT): {$(VPATH)}encoding.h
iseq.$(OBJEXT): {$(VPATH)}eval_intern.h
iseq.$(OBJEXT): {$(VPATH)}gc.h
iseq.$(OBJEXT): {$(VPATH)}id.h
iseq.$(OBJEXT): {$(VPATH)}id_table.h
iseq.$(OBJEXT): {$(VPATH)}insns.def
iseq.$(OBJEXT): {$(VPATH)}insns.inc
iseq.$(OBJEXT): {$(VPATH)}insns_info.inc
iseq.$(OBJEXT): {$(VPATH)}intern.h
iseq.$(OBJEXT): {$(VPATH)}internal.h
iseq.$(OBJEXT): {$(VPATH)}internal/abi.h
iseq.$(OBJEXT): {$(VPATH)}internal/anyargs.h
iseq.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
iseq.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
iseq.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
iseq.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
iseq.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
iseq.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
iseq.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
iseq.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
iseq.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
iseq.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
iseq.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
iseq.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
iseq.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
iseq.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
iseq.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
iseq.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
iseq.$(OBJEXT): {$(VPATH)}internal/assume.h
iseq.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
iseq.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
iseq.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
iseq.$(OBJEXT): {$(VPATH)}internal/attr/const.h
iseq.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
iseq.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
iseq.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
iseq.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
iseq.$(OBJEXT): {$(VPATH)}internal/attr/error.h
iseq.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
iseq.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
iseq.$(OBJEXT): {$(VPATH)}internal/attr/format.h
iseq.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
iseq.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
iseq.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
iseq.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
iseq.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
iseq.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
iseq.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
iseq.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
iseq.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
iseq.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
iseq.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
iseq.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
iseq.$(OBJEXT): {$(VPATH)}internal/cast.h
iseq.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
iseq.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
iseq.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
iseq.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
iseq.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
iseq.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
iseq.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
iseq.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
iseq.$(OBJEXT): {$(VPATH)}internal/config.h
iseq.$(OBJEXT): {$(VPATH)}internal/constant_p.h
iseq.$(OBJEXT): {$(VPATH)}internal/core.h
iseq.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
iseq.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
iseq.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
iseq.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
iseq.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
iseq.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
iseq.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
iseq.$(OBJEXT): {$(VPATH)}internal/core/robject.h
iseq.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
iseq.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
iseq.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
iseq.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
iseq.$(OBJEXT): {$(VPATH)}internal/ctype.h
iseq.$(OBJEXT): {$(VPATH)}internal/dllexport.h
iseq.$(OBJEXT): {$(VPATH)}internal/dosish.h
iseq.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
iseq.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
iseq.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
iseq.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
iseq.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
iseq.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
iseq.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
iseq.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
iseq.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
iseq.$(OBJEXT): {$(VPATH)}internal/error.h
iseq.$(OBJEXT): {$(VPATH)}internal/eval.h
iseq.$(OBJEXT): {$(VPATH)}internal/event.h
iseq.$(OBJEXT): {$(VPATH)}internal/fl_type.h
iseq.$(OBJEXT): {$(VPATH)}internal/gc.h
iseq.$(OBJEXT): {$(VPATH)}internal/glob.h
iseq.$(OBJEXT): {$(VPATH)}internal/globals.h
iseq.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
iseq.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
iseq.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
iseq.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
iseq.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
iseq.$(OBJEXT): {$(VPATH)}internal/has/extension.h
iseq.$(OBJEXT): {$(VPATH)}internal/has/feature.h
iseq.$(OBJEXT): {$(VPATH)}internal/has/warning.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/array.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/class.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/error.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/file.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/io.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/load.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/object.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/process.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/random.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/range.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/re.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/select.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/string.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/time.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
iseq.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
iseq.$(OBJEXT): {$(VPATH)}internal/interpreter.h
iseq.$(OBJEXT): {$(VPATH)}internal/iterator.h
iseq.$(OBJEXT): {$(VPATH)}internal/memory.h
iseq.$(OBJEXT): {$(VPATH)}internal/method.h
iseq.$(OBJEXT): {$(VPATH)}internal/module.h
iseq.$(OBJEXT): {$(VPATH)}internal/newobj.h
iseq.$(OBJEXT): {$(VPATH)}internal/rgengc.h
iseq.$(OBJEXT): {$(VPATH)}internal/scan_args.h
iseq.$(OBJEXT): {$(VPATH)}internal/special_consts.h
iseq.$(OBJEXT): {$(VPATH)}internal/static_assert.h
iseq.$(OBJEXT): {$(VPATH)}internal/stdalign.h
iseq.$(OBJEXT): {$(VPATH)}internal/stdbool.h
iseq.$(OBJEXT): {$(VPATH)}internal/symbol.h
iseq.$(OBJEXT): {$(VPATH)}internal/value.h
iseq.$(OBJEXT): {$(VPATH)}internal/value_type.h
iseq.$(OBJEXT): {$(VPATH)}internal/variable.h
iseq.$(OBJEXT): {$(VPATH)}internal/warning_push.h
iseq.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
iseq.$(OBJEXT): {$(VPATH)}iseq.c
iseq.$(OBJEXT): {$(VPATH)}iseq.h
iseq.$(OBJEXT): {$(VPATH)}method.h
iseq.$(OBJEXT): {$(VPATH)}missing.h
iseq.$(OBJEXT): {$(VPATH)}mjit.h
iseq.$(OBJEXT): {$(VPATH)}node.h
iseq.$(OBJEXT): {$(VPATH)}node_name.inc
iseq.$(OBJEXT): {$(VPATH)}onigmo.h
iseq.$(OBJEXT): {$(VPATH)}oniguruma.h
iseq.$(OBJEXT): {$(VPATH)}ractor.h
iseq.$(OBJEXT): {$(VPATH)}ruby_assert.h
iseq.$(OBJEXT): {$(VPATH)}ruby_atomic.h
iseq.$(OBJEXT): {$(VPATH)}shape.h
iseq.$(OBJEXT): {$(VPATH)}st.h
iseq.$(OBJEXT): {$(VPATH)}subst.h
iseq.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
iseq.$(OBJEXT): {$(VPATH)}thread_native.h
iseq.$(OBJEXT): {$(VPATH)}util.h
iseq.$(OBJEXT): {$(VPATH)}vm_callinfo.h
iseq.$(OBJEXT): {$(VPATH)}vm_core.h
iseq.$(OBJEXT): {$(VPATH)}vm_opts.h
iseq.$(OBJEXT): {$(VPATH)}yjit.h
load.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
load.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
load.$(OBJEXT): $(CCAN_DIR)/list/list.h
load.$(OBJEXT): $(CCAN_DIR)/str/str.h
load.$(OBJEXT): $(hdrdir)/ruby/ruby.h
load.$(OBJEXT): $(top_srcdir)/internal/array.h
load.$(OBJEXT): $(top_srcdir)/internal/compilers.h
load.$(OBJEXT): $(top_srcdir)/internal/dir.h
load.$(OBJEXT): $(top_srcdir)/internal/error.h
load.$(OBJEXT): $(top_srcdir)/internal/file.h
load.$(OBJEXT): $(top_srcdir)/internal/gc.h
load.$(OBJEXT): $(top_srcdir)/internal/imemo.h
load.$(OBJEXT): $(top_srcdir)/internal/load.h
load.$(OBJEXT): $(top_srcdir)/internal/parse.h
load.$(OBJEXT): $(top_srcdir)/internal/serial.h
load.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
load.$(OBJEXT): $(top_srcdir)/internal/string.h
load.$(OBJEXT): $(top_srcdir)/internal/thread.h
load.$(OBJEXT): $(top_srcdir)/internal/variable.h
load.$(OBJEXT): $(top_srcdir)/internal/vm.h
load.$(OBJEXT): $(top_srcdir)/internal/warnings.h
load.$(OBJEXT): {$(VPATH)}assert.h
load.$(OBJEXT): {$(VPATH)}atomic.h
load.$(OBJEXT): {$(VPATH)}backward/2/assume.h
load.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
load.$(OBJEXT): {$(VPATH)}backward/2/bool.h
load.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
load.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
load.$(OBJEXT): {$(VPATH)}backward/2/limits.h
load.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
load.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
load.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
load.$(OBJEXT): {$(VPATH)}config.h
load.$(OBJEXT): {$(VPATH)}constant.h
load.$(OBJEXT): {$(VPATH)}darray.h
load.$(OBJEXT): {$(VPATH)}defines.h
load.$(OBJEXT): {$(VPATH)}dln.h
load.$(OBJEXT): {$(VPATH)}encoding.h
load.$(OBJEXT): {$(VPATH)}eval_intern.h
load.$(OBJEXT): {$(VPATH)}id.h
load.$(OBJEXT): {$(VPATH)}id_table.h
load.$(OBJEXT): {$(VPATH)}intern.h
load.$(OBJEXT): {$(VPATH)}internal.h
load.$(OBJEXT): {$(VPATH)}internal/abi.h
load.$(OBJEXT): {$(VPATH)}internal/anyargs.h
load.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
load.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
load.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
load.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
load.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
load.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
load.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
load.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
load.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
load.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
load.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
load.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
load.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
load.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
load.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
load.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
load.$(OBJEXT): {$(VPATH)}internal/assume.h
load.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
load.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
load.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
load.$(OBJEXT): {$(VPATH)}internal/attr/const.h
load.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
load.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
load.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
load.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
load.$(OBJEXT): {$(VPATH)}internal/attr/error.h
load.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
load.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
load.$(OBJEXT): {$(VPATH)}internal/attr/format.h
load.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
load.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
load.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
load.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
load.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
load.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
load.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
load.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
load.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
load.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
load.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
load.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
load.$(OBJEXT): {$(VPATH)}internal/cast.h
load.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
load.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
load.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
load.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
load.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
load.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
load.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
load.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
load.$(OBJEXT): {$(VPATH)}internal/config.h
load.$(OBJEXT): {$(VPATH)}internal/constant_p.h
load.$(OBJEXT): {$(VPATH)}internal/core.h
load.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
load.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
load.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
load.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
load.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
load.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
load.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
load.$(OBJEXT): {$(VPATH)}internal/core/robject.h
load.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
load.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
load.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
load.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
load.$(OBJEXT): {$(VPATH)}internal/ctype.h
load.$(OBJEXT): {$(VPATH)}internal/dllexport.h
load.$(OBJEXT): {$(VPATH)}internal/dosish.h
load.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
load.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
load.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
load.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
load.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
load.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
load.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
load.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
load.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
load.$(OBJEXT): {$(VPATH)}internal/error.h
load.$(OBJEXT): {$(VPATH)}internal/eval.h
load.$(OBJEXT): {$(VPATH)}internal/event.h
load.$(OBJEXT): {$(VPATH)}internal/fl_type.h
load.$(OBJEXT): {$(VPATH)}internal/gc.h
load.$(OBJEXT): {$(VPATH)}internal/glob.h
load.$(OBJEXT): {$(VPATH)}internal/globals.h
load.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
load.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
load.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
load.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
load.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
load.$(OBJEXT): {$(VPATH)}internal/has/extension.h
load.$(OBJEXT): {$(VPATH)}internal/has/feature.h
load.$(OBJEXT): {$(VPATH)}internal/has/warning.h
load.$(OBJEXT): {$(VPATH)}internal/intern/array.h
load.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
load.$(OBJEXT): {$(VPATH)}internal/intern/class.h
load.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
load.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
load.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
load.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
load.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
load.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
load.$(OBJEXT): {$(VPATH)}internal/intern/error.h
load.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
load.$(OBJEXT): {$(VPATH)}internal/intern/file.h
load.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
load.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
load.$(OBJEXT): {$(VPATH)}internal/intern/io.h
load.$(OBJEXT): {$(VPATH)}internal/intern/load.h
load.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
load.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
load.$(OBJEXT): {$(VPATH)}internal/intern/object.h
load.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
load.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
load.$(OBJEXT): {$(VPATH)}internal/intern/process.h
load.$(OBJEXT): {$(VPATH)}internal/intern/random.h
load.$(OBJEXT): {$(VPATH)}internal/intern/range.h
load.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
load.$(OBJEXT): {$(VPATH)}internal/intern/re.h
load.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
load.$(OBJEXT): {$(VPATH)}internal/intern/select.h
load.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
load.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
load.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
load.$(OBJEXT): {$(VPATH)}internal/intern/string.h
load.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
load.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
load.$(OBJEXT): {$(VPATH)}internal/intern/time.h
load.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
load.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
load.$(OBJEXT): {$(VPATH)}internal/interpreter.h
load.$(OBJEXT): {$(VPATH)}internal/iterator.h
load.$(OBJEXT): {$(VPATH)}internal/memory.h
load.$(OBJEXT): {$(VPATH)}internal/method.h
load.$(OBJEXT): {$(VPATH)}internal/module.h
load.$(OBJEXT): {$(VPATH)}internal/newobj.h
load.$(OBJEXT): {$(VPATH)}internal/rgengc.h
load.$(OBJEXT): {$(VPATH)}internal/scan_args.h
load.$(OBJEXT): {$(VPATH)}internal/special_consts.h
load.$(OBJEXT): {$(VPATH)}internal/static_assert.h
load.$(OBJEXT): {$(VPATH)}internal/stdalign.h
load.$(OBJEXT): {$(VPATH)}internal/stdbool.h
load.$(OBJEXT): {$(VPATH)}internal/symbol.h
load.$(OBJEXT): {$(VPATH)}internal/value.h
load.$(OBJEXT): {$(VPATH)}internal/value_type.h
load.$(OBJEXT): {$(VPATH)}internal/variable.h
load.$(OBJEXT): {$(VPATH)}internal/warning_push.h
load.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
load.$(OBJEXT): {$(VPATH)}iseq.h
load.$(OBJEXT): {$(VPATH)}load.c
load.$(OBJEXT): {$(VPATH)}method.h
load.$(OBJEXT): {$(VPATH)}missing.h
load.$(OBJEXT): {$(VPATH)}node.h
load.$(OBJEXT): {$(VPATH)}onigmo.h
load.$(OBJEXT): {$(VPATH)}oniguruma.h
load.$(OBJEXT): {$(VPATH)}probes.dmyh
load.$(OBJEXT): {$(VPATH)}probes.h
load.$(OBJEXT): {$(VPATH)}ruby_assert.h
load.$(OBJEXT): {$(VPATH)}ruby_atomic.h
load.$(OBJEXT): {$(VPATH)}shape.h
load.$(OBJEXT): {$(VPATH)}st.h
load.$(OBJEXT): {$(VPATH)}subst.h
load.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
load.$(OBJEXT): {$(VPATH)}thread_native.h
load.$(OBJEXT): {$(VPATH)}util.h
load.$(OBJEXT): {$(VPATH)}vm_core.h
load.$(OBJEXT): {$(VPATH)}vm_opts.h
loadpath.$(OBJEXT): $(hdrdir)/ruby/ruby.h
loadpath.$(OBJEXT): $(hdrdir)/ruby/version.h
loadpath.$(OBJEXT): $(top_srcdir)/version.h
loadpath.$(OBJEXT): {$(VPATH)}assert.h
loadpath.$(OBJEXT): {$(VPATH)}backward/2/assume.h
loadpath.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
loadpath.$(OBJEXT): {$(VPATH)}backward/2/bool.h
loadpath.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
loadpath.$(OBJEXT): {$(VPATH)}backward/2/limits.h
loadpath.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
loadpath.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
loadpath.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
loadpath.$(OBJEXT): {$(VPATH)}config.h
loadpath.$(OBJEXT): {$(VPATH)}defines.h
loadpath.$(OBJEXT): {$(VPATH)}intern.h
loadpath.$(OBJEXT): {$(VPATH)}internal/abi.h
loadpath.$(OBJEXT): {$(VPATH)}internal/anyargs.h
loadpath.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
loadpath.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
loadpath.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
loadpath.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
loadpath.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
loadpath.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
loadpath.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
loadpath.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
loadpath.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
loadpath.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
loadpath.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
loadpath.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
loadpath.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
loadpath.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
loadpath.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
loadpath.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
loadpath.$(OBJEXT): {$(VPATH)}internal/assume.h
loadpath.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
loadpath.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
loadpath.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
loadpath.$(OBJEXT): {$(VPATH)}internal/attr/const.h
loadpath.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
loadpath.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
loadpath.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
loadpath.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
loadpath.$(OBJEXT): {$(VPATH)}internal/attr/error.h
loadpath.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
loadpath.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
loadpath.$(OBJEXT): {$(VPATH)}internal/attr/format.h
loadpath.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
loadpath.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
loadpath.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
loadpath.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
loadpath.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
loadpath.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
loadpath.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
loadpath.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
loadpath.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
loadpath.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
loadpath.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
loadpath.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
loadpath.$(OBJEXT): {$(VPATH)}internal/cast.h
loadpath.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
loadpath.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
loadpath.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
loadpath.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
loadpath.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
loadpath.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
loadpath.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
loadpath.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
loadpath.$(OBJEXT): {$(VPATH)}internal/config.h
loadpath.$(OBJEXT): {$(VPATH)}internal/constant_p.h
loadpath.$(OBJEXT): {$(VPATH)}internal/core.h
loadpath.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
loadpath.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
loadpath.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
loadpath.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
loadpath.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
loadpath.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
loadpath.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
loadpath.$(OBJEXT): {$(VPATH)}internal/core/robject.h
loadpath.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
loadpath.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
loadpath.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
loadpath.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
loadpath.$(OBJEXT): {$(VPATH)}internal/ctype.h
loadpath.$(OBJEXT): {$(VPATH)}internal/dllexport.h
loadpath.$(OBJEXT): {$(VPATH)}internal/dosish.h
loadpath.$(OBJEXT): {$(VPATH)}internal/error.h
loadpath.$(OBJEXT): {$(VPATH)}internal/eval.h
loadpath.$(OBJEXT): {$(VPATH)}internal/event.h
loadpath.$(OBJEXT): {$(VPATH)}internal/fl_type.h
loadpath.$(OBJEXT): {$(VPATH)}internal/gc.h
loadpath.$(OBJEXT): {$(VPATH)}internal/glob.h
loadpath.$(OBJEXT): {$(VPATH)}internal/globals.h
loadpath.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
loadpath.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
loadpath.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
loadpath.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
loadpath.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
loadpath.$(OBJEXT): {$(VPATH)}internal/has/extension.h
loadpath.$(OBJEXT): {$(VPATH)}internal/has/feature.h
loadpath.$(OBJEXT): {$(VPATH)}internal/has/warning.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/array.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/class.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/error.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/file.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/io.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/load.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/object.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/process.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/random.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/range.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/re.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/select.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/string.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/time.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
loadpath.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
loadpath.$(OBJEXT): {$(VPATH)}internal/interpreter.h
loadpath.$(OBJEXT): {$(VPATH)}internal/iterator.h
loadpath.$(OBJEXT): {$(VPATH)}internal/memory.h
loadpath.$(OBJEXT): {$(VPATH)}internal/method.h
loadpath.$(OBJEXT): {$(VPATH)}internal/module.h
loadpath.$(OBJEXT): {$(VPATH)}internal/newobj.h
loadpath.$(OBJEXT): {$(VPATH)}internal/rgengc.h
loadpath.$(OBJEXT): {$(VPATH)}internal/scan_args.h
loadpath.$(OBJEXT): {$(VPATH)}internal/special_consts.h
loadpath.$(OBJEXT): {$(VPATH)}internal/static_assert.h
loadpath.$(OBJEXT): {$(VPATH)}internal/stdalign.h
loadpath.$(OBJEXT): {$(VPATH)}internal/stdbool.h
loadpath.$(OBJEXT): {$(VPATH)}internal/symbol.h
loadpath.$(OBJEXT): {$(VPATH)}internal/value.h
loadpath.$(OBJEXT): {$(VPATH)}internal/value_type.h
loadpath.$(OBJEXT): {$(VPATH)}internal/variable.h
loadpath.$(OBJEXT): {$(VPATH)}internal/warning_push.h
loadpath.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
loadpath.$(OBJEXT): {$(VPATH)}loadpath.c
loadpath.$(OBJEXT): {$(VPATH)}missing.h
loadpath.$(OBJEXT): {$(VPATH)}revision.h
loadpath.$(OBJEXT): {$(VPATH)}st.h
loadpath.$(OBJEXT): {$(VPATH)}subst.h
loadpath.$(OBJEXT): {$(VPATH)}verconf.h
localeinit.$(OBJEXT): $(hdrdir)/ruby/ruby.h
localeinit.$(OBJEXT): {$(VPATH)}assert.h
localeinit.$(OBJEXT): {$(VPATH)}backward/2/assume.h
localeinit.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
localeinit.$(OBJEXT): {$(VPATH)}backward/2/bool.h
localeinit.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
localeinit.$(OBJEXT): {$(VPATH)}backward/2/limits.h
localeinit.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
localeinit.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
localeinit.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
localeinit.$(OBJEXT): {$(VPATH)}config.h
localeinit.$(OBJEXT): {$(VPATH)}defines.h
localeinit.$(OBJEXT): {$(VPATH)}encindex.h
localeinit.$(OBJEXT): {$(VPATH)}encoding.h
localeinit.$(OBJEXT): {$(VPATH)}intern.h
localeinit.$(OBJEXT): {$(VPATH)}internal.h
localeinit.$(OBJEXT): {$(VPATH)}internal/abi.h
localeinit.$(OBJEXT): {$(VPATH)}internal/anyargs.h
localeinit.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
localeinit.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
localeinit.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
localeinit.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
localeinit.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
localeinit.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
localeinit.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
localeinit.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
localeinit.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
localeinit.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
localeinit.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
localeinit.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
localeinit.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
localeinit.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
localeinit.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
localeinit.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
localeinit.$(OBJEXT): {$(VPATH)}internal/assume.h
localeinit.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
localeinit.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
localeinit.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
localeinit.$(OBJEXT): {$(VPATH)}internal/attr/const.h
localeinit.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
localeinit.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
localeinit.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
localeinit.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
localeinit.$(OBJEXT): {$(VPATH)}internal/attr/error.h
localeinit.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
localeinit.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
localeinit.$(OBJEXT): {$(VPATH)}internal/attr/format.h
localeinit.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
localeinit.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
localeinit.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
localeinit.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
localeinit.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
localeinit.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
localeinit.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
localeinit.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
localeinit.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
localeinit.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
localeinit.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
localeinit.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
localeinit.$(OBJEXT): {$(VPATH)}internal/cast.h
localeinit.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
localeinit.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
localeinit.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
localeinit.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
localeinit.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
localeinit.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
localeinit.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
localeinit.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
localeinit.$(OBJEXT): {$(VPATH)}internal/config.h
localeinit.$(OBJEXT): {$(VPATH)}internal/constant_p.h
localeinit.$(OBJEXT): {$(VPATH)}internal/core.h
localeinit.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
localeinit.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
localeinit.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
localeinit.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
localeinit.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
localeinit.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
localeinit.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
localeinit.$(OBJEXT): {$(VPATH)}internal/core/robject.h
localeinit.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
localeinit.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
localeinit.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
localeinit.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
localeinit.$(OBJEXT): {$(VPATH)}internal/ctype.h
localeinit.$(OBJEXT): {$(VPATH)}internal/dllexport.h
localeinit.$(OBJEXT): {$(VPATH)}internal/dosish.h
localeinit.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
localeinit.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
localeinit.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
localeinit.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
localeinit.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
localeinit.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
localeinit.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
localeinit.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
localeinit.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
localeinit.$(OBJEXT): {$(VPATH)}internal/error.h
localeinit.$(OBJEXT): {$(VPATH)}internal/eval.h
localeinit.$(OBJEXT): {$(VPATH)}internal/event.h
localeinit.$(OBJEXT): {$(VPATH)}internal/fl_type.h
localeinit.$(OBJEXT): {$(VPATH)}internal/gc.h
localeinit.$(OBJEXT): {$(VPATH)}internal/glob.h
localeinit.$(OBJEXT): {$(VPATH)}internal/globals.h
localeinit.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
localeinit.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
localeinit.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
localeinit.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
localeinit.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
localeinit.$(OBJEXT): {$(VPATH)}internal/has/extension.h
localeinit.$(OBJEXT): {$(VPATH)}internal/has/feature.h
localeinit.$(OBJEXT): {$(VPATH)}internal/has/warning.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/array.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/class.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/error.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/file.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/io.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/load.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/object.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/process.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/random.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/range.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/re.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/select.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/string.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/time.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
localeinit.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
localeinit.$(OBJEXT): {$(VPATH)}internal/interpreter.h
localeinit.$(OBJEXT): {$(VPATH)}internal/iterator.h
localeinit.$(OBJEXT): {$(VPATH)}internal/memory.h
localeinit.$(OBJEXT): {$(VPATH)}internal/method.h
localeinit.$(OBJEXT): {$(VPATH)}internal/module.h
localeinit.$(OBJEXT): {$(VPATH)}internal/newobj.h
localeinit.$(OBJEXT): {$(VPATH)}internal/rgengc.h
localeinit.$(OBJEXT): {$(VPATH)}internal/scan_args.h
localeinit.$(OBJEXT): {$(VPATH)}internal/special_consts.h
localeinit.$(OBJEXT): {$(VPATH)}internal/static_assert.h
localeinit.$(OBJEXT): {$(VPATH)}internal/stdalign.h
localeinit.$(OBJEXT): {$(VPATH)}internal/stdbool.h
localeinit.$(OBJEXT): {$(VPATH)}internal/symbol.h
localeinit.$(OBJEXT): {$(VPATH)}internal/value.h
localeinit.$(OBJEXT): {$(VPATH)}internal/value_type.h
localeinit.$(OBJEXT): {$(VPATH)}internal/variable.h
localeinit.$(OBJEXT): {$(VPATH)}internal/warning_push.h
localeinit.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
localeinit.$(OBJEXT): {$(VPATH)}localeinit.c
localeinit.$(OBJEXT): {$(VPATH)}missing.h
localeinit.$(OBJEXT): {$(VPATH)}onigmo.h
localeinit.$(OBJEXT): {$(VPATH)}oniguruma.h
localeinit.$(OBJEXT): {$(VPATH)}st.h
localeinit.$(OBJEXT): {$(VPATH)}subst.h
main.$(OBJEXT): $(hdrdir)/ruby.h
main.$(OBJEXT): $(hdrdir)/ruby/ruby.h
main.$(OBJEXT): {$(VPATH)}assert.h
main.$(OBJEXT): {$(VPATH)}backward.h
main.$(OBJEXT): {$(VPATH)}backward/2/assume.h
main.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
main.$(OBJEXT): {$(VPATH)}backward/2/bool.h
main.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
main.$(OBJEXT): {$(VPATH)}backward/2/limits.h
main.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
main.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
main.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
main.$(OBJEXT): {$(VPATH)}config.h
main.$(OBJEXT): {$(VPATH)}defines.h
main.$(OBJEXT): {$(VPATH)}intern.h
main.$(OBJEXT): {$(VPATH)}internal/abi.h
main.$(OBJEXT): {$(VPATH)}internal/anyargs.h
main.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
main.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
main.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
main.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
main.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
main.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
main.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
main.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
main.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
main.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
main.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
main.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
main.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
main.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
main.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
main.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
main.$(OBJEXT): {$(VPATH)}internal/assume.h
main.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
main.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
main.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
main.$(OBJEXT): {$(VPATH)}internal/attr/const.h
main.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
main.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
main.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
main.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
main.$(OBJEXT): {$(VPATH)}internal/attr/error.h
main.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
main.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
main.$(OBJEXT): {$(VPATH)}internal/attr/format.h
main.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
main.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
main.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
main.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
main.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
main.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
main.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
main.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
main.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
main.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
main.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
main.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
main.$(OBJEXT): {$(VPATH)}internal/cast.h
main.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
main.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
main.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
main.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
main.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
main.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
main.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
main.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
main.$(OBJEXT): {$(VPATH)}internal/config.h
main.$(OBJEXT): {$(VPATH)}internal/constant_p.h
main.$(OBJEXT): {$(VPATH)}internal/core.h
main.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
main.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
main.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
main.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
main.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
main.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
main.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
main.$(OBJEXT): {$(VPATH)}internal/core/robject.h
main.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
main.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
main.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
main.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
main.$(OBJEXT): {$(VPATH)}internal/ctype.h
main.$(OBJEXT): {$(VPATH)}internal/dllexport.h
main.$(OBJEXT): {$(VPATH)}internal/dosish.h
main.$(OBJEXT): {$(VPATH)}internal/error.h
main.$(OBJEXT): {$(VPATH)}internal/eval.h
main.$(OBJEXT): {$(VPATH)}internal/event.h
main.$(OBJEXT): {$(VPATH)}internal/fl_type.h
main.$(OBJEXT): {$(VPATH)}internal/gc.h
main.$(OBJEXT): {$(VPATH)}internal/glob.h
main.$(OBJEXT): {$(VPATH)}internal/globals.h
main.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
main.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
main.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
main.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
main.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
main.$(OBJEXT): {$(VPATH)}internal/has/extension.h
main.$(OBJEXT): {$(VPATH)}internal/has/feature.h
main.$(OBJEXT): {$(VPATH)}internal/has/warning.h
main.$(OBJEXT): {$(VPATH)}internal/intern/array.h
main.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
main.$(OBJEXT): {$(VPATH)}internal/intern/class.h
main.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
main.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
main.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
main.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
main.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
main.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
main.$(OBJEXT): {$(VPATH)}internal/intern/error.h
main.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
main.$(OBJEXT): {$(VPATH)}internal/intern/file.h
main.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
main.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
main.$(OBJEXT): {$(VPATH)}internal/intern/io.h
main.$(OBJEXT): {$(VPATH)}internal/intern/load.h
main.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
main.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
main.$(OBJEXT): {$(VPATH)}internal/intern/object.h
main.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
main.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
main.$(OBJEXT): {$(VPATH)}internal/intern/process.h
main.$(OBJEXT): {$(VPATH)}internal/intern/random.h
main.$(OBJEXT): {$(VPATH)}internal/intern/range.h
main.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
main.$(OBJEXT): {$(VPATH)}internal/intern/re.h
main.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
main.$(OBJEXT): {$(VPATH)}internal/intern/select.h
main.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
main.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
main.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
main.$(OBJEXT): {$(VPATH)}internal/intern/string.h
main.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
main.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
main.$(OBJEXT): {$(VPATH)}internal/intern/time.h
main.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
main.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
main.$(OBJEXT): {$(VPATH)}internal/interpreter.h
main.$(OBJEXT): {$(VPATH)}internal/iterator.h
main.$(OBJEXT): {$(VPATH)}internal/memory.h
main.$(OBJEXT): {$(VPATH)}internal/method.h
main.$(OBJEXT): {$(VPATH)}internal/module.h
main.$(OBJEXT): {$(VPATH)}internal/newobj.h
main.$(OBJEXT): {$(VPATH)}internal/rgengc.h
main.$(OBJEXT): {$(VPATH)}internal/scan_args.h
main.$(OBJEXT): {$(VPATH)}internal/special_consts.h
main.$(OBJEXT): {$(VPATH)}internal/static_assert.h
main.$(OBJEXT): {$(VPATH)}internal/stdalign.h
main.$(OBJEXT): {$(VPATH)}internal/stdbool.h
main.$(OBJEXT): {$(VPATH)}internal/symbol.h
main.$(OBJEXT): {$(VPATH)}internal/value.h
main.$(OBJEXT): {$(VPATH)}internal/value_type.h
main.$(OBJEXT): {$(VPATH)}internal/variable.h
main.$(OBJEXT): {$(VPATH)}internal/warning_push.h
main.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
main.$(OBJEXT): {$(VPATH)}main.c
main.$(OBJEXT): {$(VPATH)}missing.h
main.$(OBJEXT): {$(VPATH)}st.h
main.$(OBJEXT): {$(VPATH)}subst.h
main.$(OBJEXT): {$(VPATH)}vm_debug.h
marshal.$(OBJEXT): $(hdrdir)/ruby/ruby.h
marshal.$(OBJEXT): $(top_srcdir)/internal/array.h
marshal.$(OBJEXT): $(top_srcdir)/internal/bignum.h
marshal.$(OBJEXT): $(top_srcdir)/internal/bits.h
marshal.$(OBJEXT): $(top_srcdir)/internal/class.h
marshal.$(OBJEXT): $(top_srcdir)/internal/compilers.h
marshal.$(OBJEXT): $(top_srcdir)/internal/encoding.h
marshal.$(OBJEXT): $(top_srcdir)/internal/error.h
marshal.$(OBJEXT): $(top_srcdir)/internal/fixnum.h
marshal.$(OBJEXT): $(top_srcdir)/internal/gc.h
marshal.$(OBJEXT): $(top_srcdir)/internal/hash.h
marshal.$(OBJEXT): $(top_srcdir)/internal/numeric.h
marshal.$(OBJEXT): $(top_srcdir)/internal/object.h
marshal.$(OBJEXT): $(top_srcdir)/internal/serial.h
marshal.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
marshal.$(OBJEXT): $(top_srcdir)/internal/string.h
marshal.$(OBJEXT): $(top_srcdir)/internal/struct.h
marshal.$(OBJEXT): $(top_srcdir)/internal/symbol.h
marshal.$(OBJEXT): $(top_srcdir)/internal/util.h
marshal.$(OBJEXT): $(top_srcdir)/internal/variable.h
marshal.$(OBJEXT): $(top_srcdir)/internal/vm.h
marshal.$(OBJEXT): $(top_srcdir)/internal/warnings.h
marshal.$(OBJEXT): {$(VPATH)}assert.h
marshal.$(OBJEXT): {$(VPATH)}backward/2/assume.h
marshal.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
marshal.$(OBJEXT): {$(VPATH)}backward/2/bool.h
marshal.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
marshal.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
marshal.$(OBJEXT): {$(VPATH)}backward/2/limits.h
marshal.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
marshal.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
marshal.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
marshal.$(OBJEXT): {$(VPATH)}builtin.h
marshal.$(OBJEXT): {$(VPATH)}config.h
marshal.$(OBJEXT): {$(VPATH)}constant.h
marshal.$(OBJEXT): {$(VPATH)}defines.h
marshal.$(OBJEXT): {$(VPATH)}encindex.h
marshal.$(OBJEXT): {$(VPATH)}encoding.h
marshal.$(OBJEXT): {$(VPATH)}id_table.h
marshal.$(OBJEXT): {$(VPATH)}intern.h
marshal.$(OBJEXT): {$(VPATH)}internal.h
marshal.$(OBJEXT): {$(VPATH)}internal/abi.h
marshal.$(OBJEXT): {$(VPATH)}internal/anyargs.h
marshal.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
marshal.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
marshal.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
marshal.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
marshal.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
marshal.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
marshal.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
marshal.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
marshal.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
marshal.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
marshal.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
marshal.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
marshal.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
marshal.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
marshal.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
marshal.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
marshal.$(OBJEXT): {$(VPATH)}internal/assume.h
marshal.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
marshal.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
marshal.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
marshal.$(OBJEXT): {$(VPATH)}internal/attr/const.h
marshal.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
marshal.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
marshal.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
marshal.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
marshal.$(OBJEXT): {$(VPATH)}internal/attr/error.h
marshal.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
marshal.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
marshal.$(OBJEXT): {$(VPATH)}internal/attr/format.h
marshal.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
marshal.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
marshal.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
marshal.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
marshal.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
marshal.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
marshal.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
marshal.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
marshal.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
marshal.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
marshal.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
marshal.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
marshal.$(OBJEXT): {$(VPATH)}internal/cast.h
marshal.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
marshal.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
marshal.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
marshal.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
marshal.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
marshal.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
marshal.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
marshal.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
marshal.$(OBJEXT): {$(VPATH)}internal/config.h
marshal.$(OBJEXT): {$(VPATH)}internal/constant_p.h
marshal.$(OBJEXT): {$(VPATH)}internal/core.h
marshal.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
marshal.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
marshal.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
marshal.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
marshal.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
marshal.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
marshal.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
marshal.$(OBJEXT): {$(VPATH)}internal/core/robject.h
marshal.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
marshal.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
marshal.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
marshal.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
marshal.$(OBJEXT): {$(VPATH)}internal/ctype.h
marshal.$(OBJEXT): {$(VPATH)}internal/dllexport.h
marshal.$(OBJEXT): {$(VPATH)}internal/dosish.h
marshal.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
marshal.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
marshal.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
marshal.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
marshal.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
marshal.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
marshal.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
marshal.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
marshal.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
marshal.$(OBJEXT): {$(VPATH)}internal/error.h
marshal.$(OBJEXT): {$(VPATH)}internal/eval.h
marshal.$(OBJEXT): {$(VPATH)}internal/event.h
marshal.$(OBJEXT): {$(VPATH)}internal/fl_type.h
marshal.$(OBJEXT): {$(VPATH)}internal/gc.h
marshal.$(OBJEXT): {$(VPATH)}internal/glob.h
marshal.$(OBJEXT): {$(VPATH)}internal/globals.h
marshal.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
marshal.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
marshal.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
marshal.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
marshal.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
marshal.$(OBJEXT): {$(VPATH)}internal/has/extension.h
marshal.$(OBJEXT): {$(VPATH)}internal/has/feature.h
marshal.$(OBJEXT): {$(VPATH)}internal/has/warning.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/array.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/class.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/error.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/file.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/io.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/load.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/object.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/process.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/random.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/range.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/re.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/select.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/string.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/time.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
marshal.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
marshal.$(OBJEXT): {$(VPATH)}internal/interpreter.h
marshal.$(OBJEXT): {$(VPATH)}internal/iterator.h
marshal.$(OBJEXT): {$(VPATH)}internal/memory.h
marshal.$(OBJEXT): {$(VPATH)}internal/method.h
marshal.$(OBJEXT): {$(VPATH)}internal/module.h
marshal.$(OBJEXT): {$(VPATH)}internal/newobj.h
marshal.$(OBJEXT): {$(VPATH)}internal/rgengc.h
marshal.$(OBJEXT): {$(VPATH)}internal/scan_args.h
marshal.$(OBJEXT): {$(VPATH)}internal/special_consts.h
marshal.$(OBJEXT): {$(VPATH)}internal/static_assert.h
marshal.$(OBJEXT): {$(VPATH)}internal/stdalign.h
marshal.$(OBJEXT): {$(VPATH)}internal/stdbool.h
marshal.$(OBJEXT): {$(VPATH)}internal/symbol.h
marshal.$(OBJEXT): {$(VPATH)}internal/value.h
marshal.$(OBJEXT): {$(VPATH)}internal/value_type.h
marshal.$(OBJEXT): {$(VPATH)}internal/variable.h
marshal.$(OBJEXT): {$(VPATH)}internal/warning_push.h
marshal.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
marshal.$(OBJEXT): {$(VPATH)}io.h
marshal.$(OBJEXT): {$(VPATH)}marshal.c
marshal.$(OBJEXT): {$(VPATH)}marshal.rbinc
marshal.$(OBJEXT): {$(VPATH)}missing.h
marshal.$(OBJEXT): {$(VPATH)}onigmo.h
marshal.$(OBJEXT): {$(VPATH)}oniguruma.h
marshal.$(OBJEXT): {$(VPATH)}shape.h
marshal.$(OBJEXT): {$(VPATH)}st.h
marshal.$(OBJEXT): {$(VPATH)}subst.h
marshal.$(OBJEXT): {$(VPATH)}util.h
math.$(OBJEXT): $(hdrdir)/ruby/ruby.h
math.$(OBJEXT): $(top_srcdir)/internal/bignum.h
math.$(OBJEXT): $(top_srcdir)/internal/class.h
math.$(OBJEXT): $(top_srcdir)/internal/compilers.h
math.$(OBJEXT): $(top_srcdir)/internal/complex.h
math.$(OBJEXT): $(top_srcdir)/internal/gc.h
math.$(OBJEXT): $(top_srcdir)/internal/math.h
math.$(OBJEXT): $(top_srcdir)/internal/object.h
math.$(OBJEXT): $(top_srcdir)/internal/serial.h
math.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
math.$(OBJEXT): $(top_srcdir)/internal/variable.h
math.$(OBJEXT): $(top_srcdir)/internal/vm.h
math.$(OBJEXT): $(top_srcdir)/internal/warnings.h
math.$(OBJEXT): {$(VPATH)}assert.h
math.$(OBJEXT): {$(VPATH)}backward/2/assume.h
math.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
math.$(OBJEXT): {$(VPATH)}backward/2/bool.h
math.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
math.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
math.$(OBJEXT): {$(VPATH)}backward/2/limits.h
math.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
math.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
math.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
math.$(OBJEXT): {$(VPATH)}config.h
math.$(OBJEXT): {$(VPATH)}constant.h
math.$(OBJEXT): {$(VPATH)}defines.h
math.$(OBJEXT): {$(VPATH)}id_table.h
math.$(OBJEXT): {$(VPATH)}intern.h
math.$(OBJEXT): {$(VPATH)}internal.h
math.$(OBJEXT): {$(VPATH)}internal/abi.h
math.$(OBJEXT): {$(VPATH)}internal/anyargs.h
math.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
math.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
math.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
math.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
math.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
math.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
math.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
math.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
math.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
math.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
math.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
math.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
math.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
math.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
math.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
math.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
math.$(OBJEXT): {$(VPATH)}internal/assume.h
math.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
math.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
math.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
math.$(OBJEXT): {$(VPATH)}internal/attr/const.h
math.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
math.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
math.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
math.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
math.$(OBJEXT): {$(VPATH)}internal/attr/error.h
math.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
math.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
math.$(OBJEXT): {$(VPATH)}internal/attr/format.h
math.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
math.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
math.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
math.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
math.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
math.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
math.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
math.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
math.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
math.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
math.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
math.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
math.$(OBJEXT): {$(VPATH)}internal/cast.h
math.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
math.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
math.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
math.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
math.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
math.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
math.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
math.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
math.$(OBJEXT): {$(VPATH)}internal/config.h
math.$(OBJEXT): {$(VPATH)}internal/constant_p.h
math.$(OBJEXT): {$(VPATH)}internal/core.h
math.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
math.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
math.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
math.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
math.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
math.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
math.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
math.$(OBJEXT): {$(VPATH)}internal/core/robject.h
math.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
math.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
math.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
math.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
math.$(OBJEXT): {$(VPATH)}internal/ctype.h
math.$(OBJEXT): {$(VPATH)}internal/dllexport.h
math.$(OBJEXT): {$(VPATH)}internal/dosish.h
math.$(OBJEXT): {$(VPATH)}internal/error.h
math.$(OBJEXT): {$(VPATH)}internal/eval.h
math.$(OBJEXT): {$(VPATH)}internal/event.h
math.$(OBJEXT): {$(VPATH)}internal/fl_type.h
math.$(OBJEXT): {$(VPATH)}internal/gc.h
math.$(OBJEXT): {$(VPATH)}internal/glob.h
math.$(OBJEXT): {$(VPATH)}internal/globals.h
math.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
math.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
math.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
math.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
math.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
math.$(OBJEXT): {$(VPATH)}internal/has/extension.h
math.$(OBJEXT): {$(VPATH)}internal/has/feature.h
math.$(OBJEXT): {$(VPATH)}internal/has/warning.h
math.$(OBJEXT): {$(VPATH)}internal/intern/array.h
math.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
math.$(OBJEXT): {$(VPATH)}internal/intern/class.h
math.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
math.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
math.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
math.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
math.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
math.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
math.$(OBJEXT): {$(VPATH)}internal/intern/error.h
math.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
math.$(OBJEXT): {$(VPATH)}internal/intern/file.h
math.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
math.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
math.$(OBJEXT): {$(VPATH)}internal/intern/io.h
math.$(OBJEXT): {$(VPATH)}internal/intern/load.h
math.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
math.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
math.$(OBJEXT): {$(VPATH)}internal/intern/object.h
math.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
math.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
math.$(OBJEXT): {$(VPATH)}internal/intern/process.h
math.$(OBJEXT): {$(VPATH)}internal/intern/random.h
math.$(OBJEXT): {$(VPATH)}internal/intern/range.h
math.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
math.$(OBJEXT): {$(VPATH)}internal/intern/re.h
math.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
math.$(OBJEXT): {$(VPATH)}internal/intern/select.h
math.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
math.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
math.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
math.$(OBJEXT): {$(VPATH)}internal/intern/string.h
math.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
math.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
math.$(OBJEXT): {$(VPATH)}internal/intern/time.h
math.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
math.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
math.$(OBJEXT): {$(VPATH)}internal/interpreter.h
math.$(OBJEXT): {$(VPATH)}internal/iterator.h
math.$(OBJEXT): {$(VPATH)}internal/memory.h
math.$(OBJEXT): {$(VPATH)}internal/method.h
math.$(OBJEXT): {$(VPATH)}internal/module.h
math.$(OBJEXT): {$(VPATH)}internal/newobj.h
math.$(OBJEXT): {$(VPATH)}internal/rgengc.h
math.$(OBJEXT): {$(VPATH)}internal/scan_args.h
math.$(OBJEXT): {$(VPATH)}internal/special_consts.h
math.$(OBJEXT): {$(VPATH)}internal/static_assert.h
math.$(OBJEXT): {$(VPATH)}internal/stdalign.h
math.$(OBJEXT): {$(VPATH)}internal/stdbool.h
math.$(OBJEXT): {$(VPATH)}internal/symbol.h
math.$(OBJEXT): {$(VPATH)}internal/value.h
math.$(OBJEXT): {$(VPATH)}internal/value_type.h
math.$(OBJEXT): {$(VPATH)}internal/variable.h
math.$(OBJEXT): {$(VPATH)}internal/warning_push.h
math.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
math.$(OBJEXT): {$(VPATH)}math.c
math.$(OBJEXT): {$(VPATH)}missing.h
math.$(OBJEXT): {$(VPATH)}shape.h
math.$(OBJEXT): {$(VPATH)}st.h
math.$(OBJEXT): {$(VPATH)}subst.h
memory_view.$(OBJEXT): $(hdrdir)/ruby/ruby.h
memory_view.$(OBJEXT): $(top_srcdir)/internal/hash.h
memory_view.$(OBJEXT): $(top_srcdir)/internal/variable.h
memory_view.$(OBJEXT): {$(VPATH)}assert.h
memory_view.$(OBJEXT): {$(VPATH)}backward/2/assume.h
memory_view.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
memory_view.$(OBJEXT): {$(VPATH)}backward/2/bool.h
memory_view.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
memory_view.$(OBJEXT): {$(VPATH)}backward/2/limits.h
memory_view.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
memory_view.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
memory_view.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
memory_view.$(OBJEXT): {$(VPATH)}config.h
memory_view.$(OBJEXT): {$(VPATH)}constant.h
memory_view.$(OBJEXT): {$(VPATH)}debug_counter.h
memory_view.$(OBJEXT): {$(VPATH)}defines.h
memory_view.$(OBJEXT): {$(VPATH)}id_table.h
memory_view.$(OBJEXT): {$(VPATH)}intern.h
memory_view.$(OBJEXT): {$(VPATH)}internal.h
memory_view.$(OBJEXT): {$(VPATH)}internal/abi.h
memory_view.$(OBJEXT): {$(VPATH)}internal/anyargs.h
memory_view.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
memory_view.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
memory_view.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
memory_view.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
memory_view.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
memory_view.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
memory_view.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
memory_view.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
memory_view.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
memory_view.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
memory_view.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
memory_view.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
memory_view.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
memory_view.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
memory_view.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
memory_view.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
memory_view.$(OBJEXT): {$(VPATH)}internal/assume.h
memory_view.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
memory_view.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
memory_view.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
memory_view.$(OBJEXT): {$(VPATH)}internal/attr/const.h
memory_view.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
memory_view.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
memory_view.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
memory_view.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
memory_view.$(OBJEXT): {$(VPATH)}internal/attr/error.h
memory_view.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
memory_view.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
memory_view.$(OBJEXT): {$(VPATH)}internal/attr/format.h
memory_view.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
memory_view.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
memory_view.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
memory_view.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
memory_view.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
memory_view.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
memory_view.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
memory_view.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
memory_view.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
memory_view.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
memory_view.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
memory_view.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
memory_view.$(OBJEXT): {$(VPATH)}internal/cast.h
memory_view.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
memory_view.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
memory_view.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
memory_view.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
memory_view.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
memory_view.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
memory_view.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
memory_view.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
memory_view.$(OBJEXT): {$(VPATH)}internal/config.h
memory_view.$(OBJEXT): {$(VPATH)}internal/constant_p.h
memory_view.$(OBJEXT): {$(VPATH)}internal/core.h
memory_view.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
memory_view.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
memory_view.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
memory_view.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
memory_view.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
memory_view.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
memory_view.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
memory_view.$(OBJEXT): {$(VPATH)}internal/core/robject.h
memory_view.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
memory_view.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
memory_view.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
memory_view.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
memory_view.$(OBJEXT): {$(VPATH)}internal/ctype.h
memory_view.$(OBJEXT): {$(VPATH)}internal/dllexport.h
memory_view.$(OBJEXT): {$(VPATH)}internal/dosish.h
memory_view.$(OBJEXT): {$(VPATH)}internal/error.h
memory_view.$(OBJEXT): {$(VPATH)}internal/eval.h
memory_view.$(OBJEXT): {$(VPATH)}internal/event.h
memory_view.$(OBJEXT): {$(VPATH)}internal/fl_type.h
memory_view.$(OBJEXT): {$(VPATH)}internal/gc.h
memory_view.$(OBJEXT): {$(VPATH)}internal/glob.h
memory_view.$(OBJEXT): {$(VPATH)}internal/globals.h
memory_view.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
memory_view.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
memory_view.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
memory_view.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
memory_view.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
memory_view.$(OBJEXT): {$(VPATH)}internal/has/extension.h
memory_view.$(OBJEXT): {$(VPATH)}internal/has/feature.h
memory_view.$(OBJEXT): {$(VPATH)}internal/has/warning.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/array.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/class.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/error.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/file.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/io.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/load.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/object.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/process.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/random.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/range.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/re.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/select.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/string.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/time.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
memory_view.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
memory_view.$(OBJEXT): {$(VPATH)}internal/interpreter.h
memory_view.$(OBJEXT): {$(VPATH)}internal/iterator.h
memory_view.$(OBJEXT): {$(VPATH)}internal/memory.h
memory_view.$(OBJEXT): {$(VPATH)}internal/method.h
memory_view.$(OBJEXT): {$(VPATH)}internal/module.h
memory_view.$(OBJEXT): {$(VPATH)}internal/newobj.h
memory_view.$(OBJEXT): {$(VPATH)}internal/rgengc.h
memory_view.$(OBJEXT): {$(VPATH)}internal/scan_args.h
memory_view.$(OBJEXT): {$(VPATH)}internal/special_consts.h
memory_view.$(OBJEXT): {$(VPATH)}internal/static_assert.h
memory_view.$(OBJEXT): {$(VPATH)}internal/stdalign.h
memory_view.$(OBJEXT): {$(VPATH)}internal/stdbool.h
memory_view.$(OBJEXT): {$(VPATH)}internal/symbol.h
memory_view.$(OBJEXT): {$(VPATH)}internal/value.h
memory_view.$(OBJEXT): {$(VPATH)}internal/value_type.h
memory_view.$(OBJEXT): {$(VPATH)}internal/variable.h
memory_view.$(OBJEXT): {$(VPATH)}internal/warning_push.h
memory_view.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
memory_view.$(OBJEXT): {$(VPATH)}memory_view.c
memory_view.$(OBJEXT): {$(VPATH)}memory_view.h
memory_view.$(OBJEXT): {$(VPATH)}missing.h
memory_view.$(OBJEXT): {$(VPATH)}shape.h
memory_view.$(OBJEXT): {$(VPATH)}st.h
memory_view.$(OBJEXT): {$(VPATH)}subst.h
memory_view.$(OBJEXT): {$(VPATH)}util.h
memory_view.$(OBJEXT): {$(VPATH)}vm_debug.h
memory_view.$(OBJEXT): {$(VPATH)}vm_sync.h
miniinit.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
miniinit.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
miniinit.$(OBJEXT): $(CCAN_DIR)/list/list.h
miniinit.$(OBJEXT): $(CCAN_DIR)/str/str.h
miniinit.$(OBJEXT): $(hdrdir)/ruby/ruby.h
miniinit.$(OBJEXT): $(srcdir)/mjit_c.rb
miniinit.$(OBJEXT): $(top_srcdir)/internal/array.h
miniinit.$(OBJEXT): $(top_srcdir)/internal/compilers.h
miniinit.$(OBJEXT): $(top_srcdir)/internal/gc.h
miniinit.$(OBJEXT): $(top_srcdir)/internal/imemo.h
miniinit.$(OBJEXT): $(top_srcdir)/internal/serial.h
miniinit.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
miniinit.$(OBJEXT): $(top_srcdir)/internal/variable.h
miniinit.$(OBJEXT): $(top_srcdir)/internal/vm.h
miniinit.$(OBJEXT): $(top_srcdir)/internal/warnings.h
miniinit.$(OBJEXT): {$(VPATH)}array.rb
miniinit.$(OBJEXT): {$(VPATH)}assert.h
miniinit.$(OBJEXT): {$(VPATH)}ast.rb
miniinit.$(OBJEXT): {$(VPATH)}atomic.h
miniinit.$(OBJEXT): {$(VPATH)}backward/2/assume.h
miniinit.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
miniinit.$(OBJEXT): {$(VPATH)}backward/2/bool.h
miniinit.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
miniinit.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
miniinit.$(OBJEXT): {$(VPATH)}backward/2/limits.h
miniinit.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
miniinit.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
miniinit.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
miniinit.$(OBJEXT): {$(VPATH)}builtin.h
miniinit.$(OBJEXT): {$(VPATH)}config.h
miniinit.$(OBJEXT): {$(VPATH)}constant.h
miniinit.$(OBJEXT): {$(VPATH)}defines.h
miniinit.$(OBJEXT): {$(VPATH)}dir.rb
miniinit.$(OBJEXT): {$(VPATH)}encoding.h
miniinit.$(OBJEXT): {$(VPATH)}gc.rb
miniinit.$(OBJEXT): {$(VPATH)}gem_prelude.rb
miniinit.$(OBJEXT): {$(VPATH)}id.h
miniinit.$(OBJEXT): {$(VPATH)}id_table.h
miniinit.$(OBJEXT): {$(VPATH)}intern.h
miniinit.$(OBJEXT): {$(VPATH)}internal.h
miniinit.$(OBJEXT): {$(VPATH)}internal/abi.h
miniinit.$(OBJEXT): {$(VPATH)}internal/anyargs.h
miniinit.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
miniinit.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
miniinit.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
miniinit.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
miniinit.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
miniinit.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
miniinit.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
miniinit.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
miniinit.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
miniinit.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
miniinit.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
miniinit.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
miniinit.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
miniinit.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
miniinit.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
miniinit.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
miniinit.$(OBJEXT): {$(VPATH)}internal/assume.h
miniinit.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
miniinit.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
miniinit.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
miniinit.$(OBJEXT): {$(VPATH)}internal/attr/const.h
miniinit.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
miniinit.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
miniinit.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
miniinit.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
miniinit.$(OBJEXT): {$(VPATH)}internal/attr/error.h
miniinit.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
miniinit.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
miniinit.$(OBJEXT): {$(VPATH)}internal/attr/format.h
miniinit.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
miniinit.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
miniinit.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
miniinit.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
miniinit.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
miniinit.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
miniinit.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
miniinit.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
miniinit.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
miniinit.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
miniinit.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
miniinit.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
miniinit.$(OBJEXT): {$(VPATH)}internal/cast.h
miniinit.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
miniinit.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
miniinit.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
miniinit.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
miniinit.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
miniinit.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
miniinit.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
miniinit.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
miniinit.$(OBJEXT): {$(VPATH)}internal/config.h
miniinit.$(OBJEXT): {$(VPATH)}internal/constant_p.h
miniinit.$(OBJEXT): {$(VPATH)}internal/core.h
miniinit.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
miniinit.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
miniinit.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
miniinit.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
miniinit.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
miniinit.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
miniinit.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
miniinit.$(OBJEXT): {$(VPATH)}internal/core/robject.h
miniinit.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
miniinit.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
miniinit.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
miniinit.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
miniinit.$(OBJEXT): {$(VPATH)}internal/ctype.h
miniinit.$(OBJEXT): {$(VPATH)}internal/dllexport.h
miniinit.$(OBJEXT): {$(VPATH)}internal/dosish.h
miniinit.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
miniinit.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
miniinit.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
miniinit.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
miniinit.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
miniinit.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
miniinit.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
miniinit.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
miniinit.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
miniinit.$(OBJEXT): {$(VPATH)}internal/error.h
miniinit.$(OBJEXT): {$(VPATH)}internal/eval.h
miniinit.$(OBJEXT): {$(VPATH)}internal/event.h
miniinit.$(OBJEXT): {$(VPATH)}internal/fl_type.h
miniinit.$(OBJEXT): {$(VPATH)}internal/gc.h
miniinit.$(OBJEXT): {$(VPATH)}internal/glob.h
miniinit.$(OBJEXT): {$(VPATH)}internal/globals.h
miniinit.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
miniinit.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
miniinit.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
miniinit.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
miniinit.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
miniinit.$(OBJEXT): {$(VPATH)}internal/has/extension.h
miniinit.$(OBJEXT): {$(VPATH)}internal/has/feature.h
miniinit.$(OBJEXT): {$(VPATH)}internal/has/warning.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/array.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/class.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/error.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/file.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/io.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/load.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/object.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/process.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/random.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/range.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/re.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/select.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/string.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/time.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
miniinit.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
miniinit.$(OBJEXT): {$(VPATH)}internal/interpreter.h
miniinit.$(OBJEXT): {$(VPATH)}internal/iterator.h
miniinit.$(OBJEXT): {$(VPATH)}internal/memory.h
miniinit.$(OBJEXT): {$(VPATH)}internal/method.h
miniinit.$(OBJEXT): {$(VPATH)}internal/module.h
miniinit.$(OBJEXT): {$(VPATH)}internal/newobj.h
miniinit.$(OBJEXT): {$(VPATH)}internal/rgengc.h
miniinit.$(OBJEXT): {$(VPATH)}internal/scan_args.h
miniinit.$(OBJEXT): {$(VPATH)}internal/special_consts.h
miniinit.$(OBJEXT): {$(VPATH)}internal/static_assert.h
miniinit.$(OBJEXT): {$(VPATH)}internal/stdalign.h
miniinit.$(OBJEXT): {$(VPATH)}internal/stdbool.h
miniinit.$(OBJEXT): {$(VPATH)}internal/symbol.h
miniinit.$(OBJEXT): {$(VPATH)}internal/value.h
miniinit.$(OBJEXT): {$(VPATH)}internal/value_type.h
miniinit.$(OBJEXT): {$(VPATH)}internal/variable.h
miniinit.$(OBJEXT): {$(VPATH)}internal/warning_push.h
miniinit.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
miniinit.$(OBJEXT): {$(VPATH)}io.rb
miniinit.$(OBJEXT): {$(VPATH)}iseq.h
miniinit.$(OBJEXT): {$(VPATH)}kernel.rb
miniinit.$(OBJEXT): {$(VPATH)}marshal.rb
miniinit.$(OBJEXT): {$(VPATH)}method.h
miniinit.$(OBJEXT): {$(VPATH)}mini_builtin.c
miniinit.$(OBJEXT): {$(VPATH)}miniinit.c
miniinit.$(OBJEXT): {$(VPATH)}miniprelude.c
miniinit.$(OBJEXT): {$(VPATH)}missing.h
miniinit.$(OBJEXT): {$(VPATH)}mjit.rb
miniinit.$(OBJEXT): {$(VPATH)}mjit_c.rb
miniinit.$(OBJEXT): {$(VPATH)}nilclass.rb
miniinit.$(OBJEXT): {$(VPATH)}node.h
miniinit.$(OBJEXT): {$(VPATH)}numeric.rb
miniinit.$(OBJEXT): {$(VPATH)}onigmo.h
miniinit.$(OBJEXT): {$(VPATH)}oniguruma.h
miniinit.$(OBJEXT): {$(VPATH)}pack.rb
miniinit.$(OBJEXT): {$(VPATH)}prelude.rb
miniinit.$(OBJEXT): {$(VPATH)}ractor.rb
miniinit.$(OBJEXT): {$(VPATH)}ruby_assert.h
miniinit.$(OBJEXT): {$(VPATH)}ruby_atomic.h
miniinit.$(OBJEXT): {$(VPATH)}shape.h
miniinit.$(OBJEXT): {$(VPATH)}st.h
miniinit.$(OBJEXT): {$(VPATH)}subst.h
miniinit.$(OBJEXT): {$(VPATH)}symbol.rb
miniinit.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
miniinit.$(OBJEXT): {$(VPATH)}thread_native.h
miniinit.$(OBJEXT): {$(VPATH)}thread_sync.rb
miniinit.$(OBJEXT): {$(VPATH)}timev.rb
miniinit.$(OBJEXT): {$(VPATH)}trace_point.rb
miniinit.$(OBJEXT): {$(VPATH)}vm_core.h
miniinit.$(OBJEXT): {$(VPATH)}vm_opts.h
miniinit.$(OBJEXT): {$(VPATH)}warning.rb
miniinit.$(OBJEXT): {$(VPATH)}yjit.rb
mjit.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
mjit.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
mjit.$(OBJEXT): $(CCAN_DIR)/list/list.h
mjit.$(OBJEXT): $(CCAN_DIR)/str/str.h
mjit.$(OBJEXT): $(hdrdir)/ruby.h
mjit.$(OBJEXT): $(hdrdir)/ruby/ruby.h
mjit.$(OBJEXT): $(hdrdir)/ruby/version.h
mjit.$(OBJEXT): $(top_srcdir)/internal/array.h
mjit.$(OBJEXT): $(top_srcdir)/internal/class.h
mjit.$(OBJEXT): $(top_srcdir)/internal/cmdlineopt.h
mjit.$(OBJEXT): $(top_srcdir)/internal/compile.h
mjit.$(OBJEXT): $(top_srcdir)/internal/compilers.h
mjit.$(OBJEXT): $(top_srcdir)/internal/cont.h
mjit.$(OBJEXT): $(top_srcdir)/internal/file.h
mjit.$(OBJEXT): $(top_srcdir)/internal/gc.h
mjit.$(OBJEXT): $(top_srcdir)/internal/hash.h
mjit.$(OBJEXT): $(top_srcdir)/internal/imemo.h
mjit.$(OBJEXT): $(top_srcdir)/internal/process.h
mjit.$(OBJEXT): $(top_srcdir)/internal/serial.h
mjit.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
mjit.$(OBJEXT): $(top_srcdir)/internal/variable.h
mjit.$(OBJEXT): $(top_srcdir)/internal/vm.h
mjit.$(OBJEXT): $(top_srcdir)/internal/warnings.h
mjit.$(OBJEXT): {$(VPATH)}assert.h
mjit.$(OBJEXT): {$(VPATH)}atomic.h
mjit.$(OBJEXT): {$(VPATH)}backward/2/assume.h
mjit.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
mjit.$(OBJEXT): {$(VPATH)}backward/2/bool.h
mjit.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
mjit.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
mjit.$(OBJEXT): {$(VPATH)}backward/2/limits.h
mjit.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
mjit.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
mjit.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
mjit.$(OBJEXT): {$(VPATH)}builtin.h
mjit.$(OBJEXT): {$(VPATH)}config.h
mjit.$(OBJEXT): {$(VPATH)}constant.h
mjit.$(OBJEXT): {$(VPATH)}debug.h
mjit.$(OBJEXT): {$(VPATH)}debug_counter.h
mjit.$(OBJEXT): {$(VPATH)}defines.h
mjit.$(OBJEXT): {$(VPATH)}dln.h
mjit.$(OBJEXT): {$(VPATH)}encoding.h
mjit.$(OBJEXT): {$(VPATH)}gc.h
mjit.$(OBJEXT): {$(VPATH)}id.h
mjit.$(OBJEXT): {$(VPATH)}id_table.h
mjit.$(OBJEXT): {$(VPATH)}insns.def
mjit.$(OBJEXT): {$(VPATH)}insns.inc
mjit.$(OBJEXT): {$(VPATH)}insns_info.inc
mjit.$(OBJEXT): {$(VPATH)}intern.h
mjit.$(OBJEXT): {$(VPATH)}internal.h
mjit.$(OBJEXT): {$(VPATH)}internal/abi.h
mjit.$(OBJEXT): {$(VPATH)}internal/anyargs.h
mjit.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
mjit.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
mjit.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
mjit.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
mjit.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
mjit.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
mjit.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
mjit.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
mjit.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
mjit.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
mjit.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
mjit.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
mjit.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
mjit.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
mjit.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
mjit.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
mjit.$(OBJEXT): {$(VPATH)}internal/assume.h
mjit.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
mjit.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
mjit.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
mjit.$(OBJEXT): {$(VPATH)}internal/attr/const.h
mjit.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
mjit.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
mjit.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
mjit.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
mjit.$(OBJEXT): {$(VPATH)}internal/attr/error.h
mjit.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
mjit.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
mjit.$(OBJEXT): {$(VPATH)}internal/attr/format.h
mjit.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
mjit.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
mjit.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
mjit.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
mjit.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
mjit.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
mjit.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
mjit.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
mjit.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
mjit.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
mjit.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
mjit.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
mjit.$(OBJEXT): {$(VPATH)}internal/cast.h
mjit.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
mjit.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
mjit.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
mjit.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
mjit.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
mjit.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
mjit.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
mjit.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
mjit.$(OBJEXT): {$(VPATH)}internal/config.h
mjit.$(OBJEXT): {$(VPATH)}internal/constant_p.h
mjit.$(OBJEXT): {$(VPATH)}internal/core.h
mjit.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
mjit.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
mjit.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
mjit.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
mjit.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
mjit.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
mjit.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
mjit.$(OBJEXT): {$(VPATH)}internal/core/robject.h
mjit.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
mjit.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
mjit.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
mjit.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
mjit.$(OBJEXT): {$(VPATH)}internal/ctype.h
mjit.$(OBJEXT): {$(VPATH)}internal/dllexport.h
mjit.$(OBJEXT): {$(VPATH)}internal/dosish.h
mjit.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
mjit.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
mjit.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
mjit.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
mjit.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
mjit.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
mjit.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
mjit.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
mjit.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
mjit.$(OBJEXT): {$(VPATH)}internal/error.h
mjit.$(OBJEXT): {$(VPATH)}internal/eval.h
mjit.$(OBJEXT): {$(VPATH)}internal/event.h
mjit.$(OBJEXT): {$(VPATH)}internal/fl_type.h
mjit.$(OBJEXT): {$(VPATH)}internal/gc.h
mjit.$(OBJEXT): {$(VPATH)}internal/glob.h
mjit.$(OBJEXT): {$(VPATH)}internal/globals.h
mjit.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
mjit.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
mjit.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
mjit.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
mjit.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
mjit.$(OBJEXT): {$(VPATH)}internal/has/extension.h
mjit.$(OBJEXT): {$(VPATH)}internal/has/feature.h
mjit.$(OBJEXT): {$(VPATH)}internal/has/warning.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/array.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/class.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/error.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/file.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/io.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/load.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/object.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/process.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/random.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/range.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/re.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/select.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/string.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/time.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
mjit.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
mjit.$(OBJEXT): {$(VPATH)}internal/interpreter.h
mjit.$(OBJEXT): {$(VPATH)}internal/iterator.h
mjit.$(OBJEXT): {$(VPATH)}internal/memory.h
mjit.$(OBJEXT): {$(VPATH)}internal/method.h
mjit.$(OBJEXT): {$(VPATH)}internal/module.h
mjit.$(OBJEXT): {$(VPATH)}internal/newobj.h
mjit.$(OBJEXT): {$(VPATH)}internal/rgengc.h
mjit.$(OBJEXT): {$(VPATH)}internal/scan_args.h
mjit.$(OBJEXT): {$(VPATH)}internal/special_consts.h
mjit.$(OBJEXT): {$(VPATH)}internal/static_assert.h
mjit.$(OBJEXT): {$(VPATH)}internal/stdalign.h
mjit.$(OBJEXT): {$(VPATH)}internal/stdbool.h
mjit.$(OBJEXT): {$(VPATH)}internal/symbol.h
mjit.$(OBJEXT): {$(VPATH)}internal/value.h
mjit.$(OBJEXT): {$(VPATH)}internal/value_type.h
mjit.$(OBJEXT): {$(VPATH)}internal/variable.h
mjit.$(OBJEXT): {$(VPATH)}internal/warning_push.h
mjit.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
mjit.$(OBJEXT): {$(VPATH)}iseq.h
mjit.$(OBJEXT): {$(VPATH)}method.h
mjit.$(OBJEXT): {$(VPATH)}missing.h
mjit.$(OBJEXT): {$(VPATH)}mjit.c
mjit.$(OBJEXT): {$(VPATH)}mjit.h
mjit.$(OBJEXT): {$(VPATH)}mjit.rbinc
mjit.$(OBJEXT): {$(VPATH)}mjit_c.h
mjit.$(OBJEXT): {$(VPATH)}mjit_config.h
mjit.$(OBJEXT): {$(VPATH)}node.h
mjit.$(OBJEXT): {$(VPATH)}onigmo.h
mjit.$(OBJEXT): {$(VPATH)}oniguruma.h
mjit.$(OBJEXT): {$(VPATH)}ractor.h
mjit.$(OBJEXT): {$(VPATH)}ractor_core.h
mjit.$(OBJEXT): {$(VPATH)}ruby_assert.h
mjit.$(OBJEXT): {$(VPATH)}ruby_atomic.h
mjit.$(OBJEXT): {$(VPATH)}shape.h
mjit.$(OBJEXT): {$(VPATH)}st.h
mjit.$(OBJEXT): {$(VPATH)}subst.h
mjit.$(OBJEXT): {$(VPATH)}thread.h
mjit.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
mjit.$(OBJEXT): {$(VPATH)}thread_native.h
mjit.$(OBJEXT): {$(VPATH)}util.h
mjit.$(OBJEXT): {$(VPATH)}vm_callinfo.h
mjit.$(OBJEXT): {$(VPATH)}vm_core.h
mjit.$(OBJEXT): {$(VPATH)}vm_debug.h
mjit.$(OBJEXT): {$(VPATH)}vm_opts.h
mjit.$(OBJEXT): {$(VPATH)}vm_sync.h
mjit.$(OBJEXT): {$(VPATH)}yjit.h
mjit_c.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
mjit_c.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
mjit_c.$(OBJEXT): $(CCAN_DIR)/list/list.h
mjit_c.$(OBJEXT): $(CCAN_DIR)/str/str.h
mjit_c.$(OBJEXT): $(hdrdir)/ruby.h
mjit_c.$(OBJEXT): $(hdrdir)/ruby/ruby.h
mjit_c.$(OBJEXT): $(srcdir)/mjit_c.rb
mjit_c.$(OBJEXT): $(top_srcdir)/internal/array.h
mjit_c.$(OBJEXT): $(top_srcdir)/internal/class.h
mjit_c.$(OBJEXT): $(top_srcdir)/internal/compile.h
mjit_c.$(OBJEXT): $(top_srcdir)/internal/compilers.h
mjit_c.$(OBJEXT): $(top_srcdir)/internal/gc.h
mjit_c.$(OBJEXT): $(top_srcdir)/internal/hash.h
mjit_c.$(OBJEXT): $(top_srcdir)/internal/imemo.h
mjit_c.$(OBJEXT): $(top_srcdir)/internal/object.h
mjit_c.$(OBJEXT): $(top_srcdir)/internal/serial.h
mjit_c.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
mjit_c.$(OBJEXT): $(top_srcdir)/internal/variable.h
mjit_c.$(OBJEXT): $(top_srcdir)/internal/vm.h
mjit_c.$(OBJEXT): $(top_srcdir)/internal/warnings.h
mjit_c.$(OBJEXT): {$(VPATH)}assert.h
mjit_c.$(OBJEXT): {$(VPATH)}atomic.h
mjit_c.$(OBJEXT): {$(VPATH)}backward/2/assume.h
mjit_c.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
mjit_c.$(OBJEXT): {$(VPATH)}backward/2/bool.h
mjit_c.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
mjit_c.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
mjit_c.$(OBJEXT): {$(VPATH)}backward/2/limits.h
mjit_c.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
mjit_c.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
mjit_c.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
mjit_c.$(OBJEXT): {$(VPATH)}builtin.h
mjit_c.$(OBJEXT): {$(VPATH)}config.h
mjit_c.$(OBJEXT): {$(VPATH)}constant.h
mjit_c.$(OBJEXT): {$(VPATH)}debug_counter.h
mjit_c.$(OBJEXT): {$(VPATH)}defines.h
mjit_c.$(OBJEXT): {$(VPATH)}id.h
mjit_c.$(OBJEXT): {$(VPATH)}id_table.h
mjit_c.$(OBJEXT): {$(VPATH)}insns.def
mjit_c.$(OBJEXT): {$(VPATH)}insns.inc
mjit_c.$(OBJEXT): {$(VPATH)}insns_info.inc
mjit_c.$(OBJEXT): {$(VPATH)}intern.h
mjit_c.$(OBJEXT): {$(VPATH)}internal.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/abi.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/anyargs.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/assume.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/attr/const.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/attr/error.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/attr/format.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/cast.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/config.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/constant_p.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/core.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/core/robject.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/ctype.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/dllexport.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/dosish.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/error.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/eval.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/event.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/fl_type.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/gc.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/glob.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/globals.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/has/extension.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/has/feature.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/has/warning.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/array.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/class.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/error.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/file.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/io.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/load.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/object.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/process.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/random.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/range.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/re.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/select.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/string.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/time.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/interpreter.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/iterator.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/memory.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/method.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/module.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/newobj.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/rgengc.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/scan_args.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/special_consts.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/static_assert.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/stdalign.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/stdbool.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/symbol.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/value.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/value_type.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/variable.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/warning_push.h
mjit_c.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
mjit_c.$(OBJEXT): {$(VPATH)}iseq.h
mjit_c.$(OBJEXT): {$(VPATH)}method.h
mjit_c.$(OBJEXT): {$(VPATH)}missing.h
mjit_c.$(OBJEXT): {$(VPATH)}mjit.h
mjit_c.$(OBJEXT): {$(VPATH)}mjit_c.c
mjit_c.$(OBJEXT): {$(VPATH)}mjit_c.h
mjit_c.$(OBJEXT): {$(VPATH)}mjit_c.rb
mjit_c.$(OBJEXT): {$(VPATH)}mjit_c.rbinc
mjit_c.$(OBJEXT): {$(VPATH)}mjit_sp_inc.inc
mjit_c.$(OBJEXT): {$(VPATH)}node.h
mjit_c.$(OBJEXT): {$(VPATH)}ruby_assert.h
mjit_c.$(OBJEXT): {$(VPATH)}ruby_atomic.h
mjit_c.$(OBJEXT): {$(VPATH)}shape.h
mjit_c.$(OBJEXT): {$(VPATH)}st.h
mjit_c.$(OBJEXT): {$(VPATH)}subst.h
mjit_c.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
mjit_c.$(OBJEXT): {$(VPATH)}thread_native.h
mjit_c.$(OBJEXT): {$(VPATH)}vm_callinfo.h
mjit_c.$(OBJEXT): {$(VPATH)}vm_core.h
mjit_c.$(OBJEXT): {$(VPATH)}vm_exec.h
mjit_c.$(OBJEXT): {$(VPATH)}vm_insnhelper.h
mjit_c.$(OBJEXT): {$(VPATH)}vm_opts.h
mjit_c.$(OBJEXT): {$(VPATH)}yjit.h
node.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
node.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
node.$(OBJEXT): $(CCAN_DIR)/list/list.h
node.$(OBJEXT): $(CCAN_DIR)/str/str.h
node.$(OBJEXT): $(hdrdir)/ruby/ruby.h
node.$(OBJEXT): $(top_srcdir)/internal/array.h
node.$(OBJEXT): $(top_srcdir)/internal/compilers.h
node.$(OBJEXT): $(top_srcdir)/internal/gc.h
node.$(OBJEXT): $(top_srcdir)/internal/hash.h
node.$(OBJEXT): $(top_srcdir)/internal/imemo.h
node.$(OBJEXT): $(top_srcdir)/internal/serial.h
node.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
node.$(OBJEXT): $(top_srcdir)/internal/variable.h
node.$(OBJEXT): $(top_srcdir)/internal/vm.h
node.$(OBJEXT): $(top_srcdir)/internal/warnings.h
node.$(OBJEXT): {$(VPATH)}assert.h
node.$(OBJEXT): {$(VPATH)}atomic.h
node.$(OBJEXT): {$(VPATH)}backward/2/assume.h
node.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
node.$(OBJEXT): {$(VPATH)}backward/2/bool.h
node.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
node.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
node.$(OBJEXT): {$(VPATH)}backward/2/limits.h
node.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
node.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
node.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
node.$(OBJEXT): {$(VPATH)}config.h
node.$(OBJEXT): {$(VPATH)}constant.h
node.$(OBJEXT): {$(VPATH)}defines.h
node.$(OBJEXT): {$(VPATH)}id.h
node.$(OBJEXT): {$(VPATH)}id_table.h
node.$(OBJEXT): {$(VPATH)}intern.h
node.$(OBJEXT): {$(VPATH)}internal.h
node.$(OBJEXT): {$(VPATH)}internal/abi.h
node.$(OBJEXT): {$(VPATH)}internal/anyargs.h
node.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
node.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
node.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
node.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
node.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
node.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
node.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
node.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
node.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
node.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
node.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
node.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
node.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
node.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
node.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
node.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
node.$(OBJEXT): {$(VPATH)}internal/assume.h
node.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
node.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
node.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
node.$(OBJEXT): {$(VPATH)}internal/attr/const.h
node.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
node.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
node.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
node.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
node.$(OBJEXT): {$(VPATH)}internal/attr/error.h
node.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
node.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
node.$(OBJEXT): {$(VPATH)}internal/attr/format.h
node.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
node.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
node.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
node.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
node.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
node.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
node.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
node.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
node.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
node.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
node.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
node.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
node.$(OBJEXT): {$(VPATH)}internal/cast.h
node.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
node.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
node.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
node.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
node.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
node.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
node.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
node.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
node.$(OBJEXT): {$(VPATH)}internal/config.h
node.$(OBJEXT): {$(VPATH)}internal/constant_p.h
node.$(OBJEXT): {$(VPATH)}internal/core.h
node.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
node.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
node.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
node.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
node.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
node.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
node.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
node.$(OBJEXT): {$(VPATH)}internal/core/robject.h
node.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
node.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
node.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
node.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
node.$(OBJEXT): {$(VPATH)}internal/ctype.h
node.$(OBJEXT): {$(VPATH)}internal/dllexport.h
node.$(OBJEXT): {$(VPATH)}internal/dosish.h
node.$(OBJEXT): {$(VPATH)}internal/error.h
node.$(OBJEXT): {$(VPATH)}internal/eval.h
node.$(OBJEXT): {$(VPATH)}internal/event.h
node.$(OBJEXT): {$(VPATH)}internal/fl_type.h
node.$(OBJEXT): {$(VPATH)}internal/gc.h
node.$(OBJEXT): {$(VPATH)}internal/glob.h
node.$(OBJEXT): {$(VPATH)}internal/globals.h
node.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
node.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
node.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
node.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
node.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
node.$(OBJEXT): {$(VPATH)}internal/has/extension.h
node.$(OBJEXT): {$(VPATH)}internal/has/feature.h
node.$(OBJEXT): {$(VPATH)}internal/has/warning.h
node.$(OBJEXT): {$(VPATH)}internal/intern/array.h
node.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
node.$(OBJEXT): {$(VPATH)}internal/intern/class.h
node.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
node.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
node.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
node.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
node.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
node.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
node.$(OBJEXT): {$(VPATH)}internal/intern/error.h
node.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
node.$(OBJEXT): {$(VPATH)}internal/intern/file.h
node.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
node.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
node.$(OBJEXT): {$(VPATH)}internal/intern/io.h
node.$(OBJEXT): {$(VPATH)}internal/intern/load.h
node.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
node.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
node.$(OBJEXT): {$(VPATH)}internal/intern/object.h
node.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
node.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
node.$(OBJEXT): {$(VPATH)}internal/intern/process.h
node.$(OBJEXT): {$(VPATH)}internal/intern/random.h
node.$(OBJEXT): {$(VPATH)}internal/intern/range.h
node.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
node.$(OBJEXT): {$(VPATH)}internal/intern/re.h
node.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
node.$(OBJEXT): {$(VPATH)}internal/intern/select.h
node.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
node.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
node.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
node.$(OBJEXT): {$(VPATH)}internal/intern/string.h
node.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
node.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
node.$(OBJEXT): {$(VPATH)}internal/intern/time.h
node.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
node.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
node.$(OBJEXT): {$(VPATH)}internal/interpreter.h
node.$(OBJEXT): {$(VPATH)}internal/iterator.h
node.$(OBJEXT): {$(VPATH)}internal/memory.h
node.$(OBJEXT): {$(VPATH)}internal/method.h
node.$(OBJEXT): {$(VPATH)}internal/module.h
node.$(OBJEXT): {$(VPATH)}internal/newobj.h
node.$(OBJEXT): {$(VPATH)}internal/rgengc.h
node.$(OBJEXT): {$(VPATH)}internal/scan_args.h
node.$(OBJEXT): {$(VPATH)}internal/special_consts.h
node.$(OBJEXT): {$(VPATH)}internal/static_assert.h
node.$(OBJEXT): {$(VPATH)}internal/stdalign.h
node.$(OBJEXT): {$(VPATH)}internal/stdbool.h
node.$(OBJEXT): {$(VPATH)}internal/symbol.h
node.$(OBJEXT): {$(VPATH)}internal/value.h
node.$(OBJEXT): {$(VPATH)}internal/value_type.h
node.$(OBJEXT): {$(VPATH)}internal/variable.h
node.$(OBJEXT): {$(VPATH)}internal/warning_push.h
node.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
node.$(OBJEXT): {$(VPATH)}method.h
node.$(OBJEXT): {$(VPATH)}missing.h
node.$(OBJEXT): {$(VPATH)}node.c
node.$(OBJEXT): {$(VPATH)}node.h
node.$(OBJEXT): {$(VPATH)}ruby_assert.h
node.$(OBJEXT): {$(VPATH)}ruby_atomic.h
node.$(OBJEXT): {$(VPATH)}shape.h
node.$(OBJEXT): {$(VPATH)}st.h
node.$(OBJEXT): {$(VPATH)}subst.h
node.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
node.$(OBJEXT): {$(VPATH)}thread_native.h
node.$(OBJEXT): {$(VPATH)}vm_core.h
node.$(OBJEXT): {$(VPATH)}vm_opts.h
numeric.$(OBJEXT): $(hdrdir)/ruby/ruby.h
numeric.$(OBJEXT): $(top_srcdir)/internal/array.h
numeric.$(OBJEXT): $(top_srcdir)/internal/bignum.h
numeric.$(OBJEXT): $(top_srcdir)/internal/bits.h
numeric.$(OBJEXT): $(top_srcdir)/internal/class.h
numeric.$(OBJEXT): $(top_srcdir)/internal/compilers.h
numeric.$(OBJEXT): $(top_srcdir)/internal/complex.h
numeric.$(OBJEXT): $(top_srcdir)/internal/enumerator.h
numeric.$(OBJEXT): $(top_srcdir)/internal/fixnum.h
numeric.$(OBJEXT): $(top_srcdir)/internal/gc.h
numeric.$(OBJEXT): $(top_srcdir)/internal/hash.h
numeric.$(OBJEXT): $(top_srcdir)/internal/numeric.h
numeric.$(OBJEXT): $(top_srcdir)/internal/object.h
numeric.$(OBJEXT): $(top_srcdir)/internal/rational.h
numeric.$(OBJEXT): $(top_srcdir)/internal/serial.h
numeric.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
numeric.$(OBJEXT): $(top_srcdir)/internal/string.h
numeric.$(OBJEXT): $(top_srcdir)/internal/util.h
numeric.$(OBJEXT): $(top_srcdir)/internal/variable.h
numeric.$(OBJEXT): $(top_srcdir)/internal/vm.h
numeric.$(OBJEXT): $(top_srcdir)/internal/warnings.h
numeric.$(OBJEXT): {$(VPATH)}assert.h
numeric.$(OBJEXT): {$(VPATH)}backward/2/assume.h
numeric.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
numeric.$(OBJEXT): {$(VPATH)}backward/2/bool.h
numeric.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
numeric.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
numeric.$(OBJEXT): {$(VPATH)}backward/2/limits.h
numeric.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
numeric.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
numeric.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
numeric.$(OBJEXT): {$(VPATH)}builtin.h
numeric.$(OBJEXT): {$(VPATH)}config.h
numeric.$(OBJEXT): {$(VPATH)}constant.h
numeric.$(OBJEXT): {$(VPATH)}defines.h
numeric.$(OBJEXT): {$(VPATH)}encoding.h
numeric.$(OBJEXT): {$(VPATH)}id.h
numeric.$(OBJEXT): {$(VPATH)}id_table.h
numeric.$(OBJEXT): {$(VPATH)}intern.h
numeric.$(OBJEXT): {$(VPATH)}internal.h
numeric.$(OBJEXT): {$(VPATH)}internal/abi.h
numeric.$(OBJEXT): {$(VPATH)}internal/anyargs.h
numeric.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
numeric.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
numeric.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
numeric.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
numeric.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
numeric.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
numeric.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
numeric.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
numeric.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
numeric.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
numeric.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
numeric.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
numeric.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
numeric.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
numeric.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
numeric.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
numeric.$(OBJEXT): {$(VPATH)}internal/assume.h
numeric.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
numeric.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
numeric.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
numeric.$(OBJEXT): {$(VPATH)}internal/attr/const.h
numeric.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
numeric.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
numeric.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
numeric.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
numeric.$(OBJEXT): {$(VPATH)}internal/attr/error.h
numeric.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
numeric.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
numeric.$(OBJEXT): {$(VPATH)}internal/attr/format.h
numeric.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
numeric.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
numeric.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
numeric.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
numeric.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
numeric.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
numeric.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
numeric.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
numeric.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
numeric.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
numeric.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
numeric.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
numeric.$(OBJEXT): {$(VPATH)}internal/cast.h
numeric.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
numeric.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
numeric.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
numeric.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
numeric.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
numeric.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
numeric.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
numeric.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
numeric.$(OBJEXT): {$(VPATH)}internal/config.h
numeric.$(OBJEXT): {$(VPATH)}internal/constant_p.h
numeric.$(OBJEXT): {$(VPATH)}internal/core.h
numeric.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
numeric.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
numeric.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
numeric.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
numeric.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
numeric.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
numeric.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
numeric.$(OBJEXT): {$(VPATH)}internal/core/robject.h
numeric.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
numeric.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
numeric.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
numeric.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
numeric.$(OBJEXT): {$(VPATH)}internal/ctype.h
numeric.$(OBJEXT): {$(VPATH)}internal/dllexport.h
numeric.$(OBJEXT): {$(VPATH)}internal/dosish.h
numeric.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
numeric.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
numeric.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
numeric.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
numeric.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
numeric.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
numeric.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
numeric.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
numeric.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
numeric.$(OBJEXT): {$(VPATH)}internal/error.h
numeric.$(OBJEXT): {$(VPATH)}internal/eval.h
numeric.$(OBJEXT): {$(VPATH)}internal/event.h
numeric.$(OBJEXT): {$(VPATH)}internal/fl_type.h
numeric.$(OBJEXT): {$(VPATH)}internal/gc.h
numeric.$(OBJEXT): {$(VPATH)}internal/glob.h
numeric.$(OBJEXT): {$(VPATH)}internal/globals.h
numeric.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
numeric.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
numeric.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
numeric.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
numeric.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
numeric.$(OBJEXT): {$(VPATH)}internal/has/extension.h
numeric.$(OBJEXT): {$(VPATH)}internal/has/feature.h
numeric.$(OBJEXT): {$(VPATH)}internal/has/warning.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/array.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/class.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/error.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/file.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/io.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/load.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/object.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/process.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/random.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/range.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/re.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/select.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/string.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/time.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
numeric.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
numeric.$(OBJEXT): {$(VPATH)}internal/interpreter.h
numeric.$(OBJEXT): {$(VPATH)}internal/iterator.h
numeric.$(OBJEXT): {$(VPATH)}internal/memory.h
numeric.$(OBJEXT): {$(VPATH)}internal/method.h
numeric.$(OBJEXT): {$(VPATH)}internal/module.h
numeric.$(OBJEXT): {$(VPATH)}internal/newobj.h
numeric.$(OBJEXT): {$(VPATH)}internal/rgengc.h
numeric.$(OBJEXT): {$(VPATH)}internal/scan_args.h
numeric.$(OBJEXT): {$(VPATH)}internal/special_consts.h
numeric.$(OBJEXT): {$(VPATH)}internal/static_assert.h
numeric.$(OBJEXT): {$(VPATH)}internal/stdalign.h
numeric.$(OBJEXT): {$(VPATH)}internal/stdbool.h
numeric.$(OBJEXT): {$(VPATH)}internal/symbol.h
numeric.$(OBJEXT): {$(VPATH)}internal/value.h
numeric.$(OBJEXT): {$(VPATH)}internal/value_type.h
numeric.$(OBJEXT): {$(VPATH)}internal/variable.h
numeric.$(OBJEXT): {$(VPATH)}internal/warning_push.h
numeric.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
numeric.$(OBJEXT): {$(VPATH)}missing.h
numeric.$(OBJEXT): {$(VPATH)}numeric.c
numeric.$(OBJEXT): {$(VPATH)}numeric.rbinc
numeric.$(OBJEXT): {$(VPATH)}onigmo.h
numeric.$(OBJEXT): {$(VPATH)}oniguruma.h
numeric.$(OBJEXT): {$(VPATH)}ruby_assert.h
numeric.$(OBJEXT): {$(VPATH)}shape.h
numeric.$(OBJEXT): {$(VPATH)}st.h
numeric.$(OBJEXT): {$(VPATH)}subst.h
numeric.$(OBJEXT): {$(VPATH)}util.h
object.$(OBJEXT): $(hdrdir)/ruby/ruby.h
object.$(OBJEXT): $(top_srcdir)/internal/array.h
object.$(OBJEXT): $(top_srcdir)/internal/bignum.h
object.$(OBJEXT): $(top_srcdir)/internal/bits.h
object.$(OBJEXT): $(top_srcdir)/internal/class.h
object.$(OBJEXT): $(top_srcdir)/internal/compilers.h
object.$(OBJEXT): $(top_srcdir)/internal/error.h
object.$(OBJEXT): $(top_srcdir)/internal/eval.h
object.$(OBJEXT): $(top_srcdir)/internal/fixnum.h
object.$(OBJEXT): $(top_srcdir)/internal/gc.h
object.$(OBJEXT): $(top_srcdir)/internal/inits.h
object.$(OBJEXT): $(top_srcdir)/internal/numeric.h
object.$(OBJEXT): $(top_srcdir)/internal/object.h
object.$(OBJEXT): $(top_srcdir)/internal/serial.h
object.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
object.$(OBJEXT): $(top_srcdir)/internal/string.h
object.$(OBJEXT): $(top_srcdir)/internal/struct.h
object.$(OBJEXT): $(top_srcdir)/internal/symbol.h
object.$(OBJEXT): $(top_srcdir)/internal/variable.h
object.$(OBJEXT): $(top_srcdir)/internal/vm.h
object.$(OBJEXT): $(top_srcdir)/internal/warnings.h
object.$(OBJEXT): {$(VPATH)}assert.h
object.$(OBJEXT): {$(VPATH)}backward/2/assume.h
object.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
object.$(OBJEXT): {$(VPATH)}backward/2/bool.h
object.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
object.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
object.$(OBJEXT): {$(VPATH)}backward/2/limits.h
object.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
object.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
object.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
object.$(OBJEXT): {$(VPATH)}builtin.h
object.$(OBJEXT): {$(VPATH)}config.h
object.$(OBJEXT): {$(VPATH)}constant.h
object.$(OBJEXT): {$(VPATH)}defines.h
object.$(OBJEXT): {$(VPATH)}encoding.h
object.$(OBJEXT): {$(VPATH)}id.h
object.$(OBJEXT): {$(VPATH)}id_table.h
object.$(OBJEXT): {$(VPATH)}intern.h
object.$(OBJEXT): {$(VPATH)}internal.h
object.$(OBJEXT): {$(VPATH)}internal/abi.h
object.$(OBJEXT): {$(VPATH)}internal/anyargs.h
object.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
object.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
object.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
object.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
object.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
object.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
object.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
object.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
object.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
object.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
object.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
object.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
object.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
object.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
object.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
object.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
object.$(OBJEXT): {$(VPATH)}internal/assume.h
object.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
object.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
object.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
object.$(OBJEXT): {$(VPATH)}internal/attr/const.h
object.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
object.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
object.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
object.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
object.$(OBJEXT): {$(VPATH)}internal/attr/error.h
object.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
object.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
object.$(OBJEXT): {$(VPATH)}internal/attr/format.h
object.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
object.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
object.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
object.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
object.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
object.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
object.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
object.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
object.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
object.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
object.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
object.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
object.$(OBJEXT): {$(VPATH)}internal/cast.h
object.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
object.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
object.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
object.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
object.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
object.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
object.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
object.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
object.$(OBJEXT): {$(VPATH)}internal/config.h
object.$(OBJEXT): {$(VPATH)}internal/constant_p.h
object.$(OBJEXT): {$(VPATH)}internal/core.h
object.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
object.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
object.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
object.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
object.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
object.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
object.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
object.$(OBJEXT): {$(VPATH)}internal/core/robject.h
object.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
object.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
object.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
object.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
object.$(OBJEXT): {$(VPATH)}internal/ctype.h
object.$(OBJEXT): {$(VPATH)}internal/dllexport.h
object.$(OBJEXT): {$(VPATH)}internal/dosish.h
object.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
object.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
object.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
object.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
object.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
object.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
object.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
object.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
object.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
object.$(OBJEXT): {$(VPATH)}internal/error.h
object.$(OBJEXT): {$(VPATH)}internal/eval.h
object.$(OBJEXT): {$(VPATH)}internal/event.h
object.$(OBJEXT): {$(VPATH)}internal/fl_type.h
object.$(OBJEXT): {$(VPATH)}internal/gc.h
object.$(OBJEXT): {$(VPATH)}internal/glob.h
object.$(OBJEXT): {$(VPATH)}internal/globals.h
object.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
object.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
object.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
object.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
object.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
object.$(OBJEXT): {$(VPATH)}internal/has/extension.h
object.$(OBJEXT): {$(VPATH)}internal/has/feature.h
object.$(OBJEXT): {$(VPATH)}internal/has/warning.h
object.$(OBJEXT): {$(VPATH)}internal/intern/array.h
object.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
object.$(OBJEXT): {$(VPATH)}internal/intern/class.h
object.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
object.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
object.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
object.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
object.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
object.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
object.$(OBJEXT): {$(VPATH)}internal/intern/error.h
object.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
object.$(OBJEXT): {$(VPATH)}internal/intern/file.h
object.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
object.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
object.$(OBJEXT): {$(VPATH)}internal/intern/io.h
object.$(OBJEXT): {$(VPATH)}internal/intern/load.h
object.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
object.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
object.$(OBJEXT): {$(VPATH)}internal/intern/object.h
object.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
object.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
object.$(OBJEXT): {$(VPATH)}internal/intern/process.h
object.$(OBJEXT): {$(VPATH)}internal/intern/random.h
object.$(OBJEXT): {$(VPATH)}internal/intern/range.h
object.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
object.$(OBJEXT): {$(VPATH)}internal/intern/re.h
object.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
object.$(OBJEXT): {$(VPATH)}internal/intern/select.h
object.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
object.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
object.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
object.$(OBJEXT): {$(VPATH)}internal/intern/string.h
object.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
object.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
object.$(OBJEXT): {$(VPATH)}internal/intern/time.h
object.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
object.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
object.$(OBJEXT): {$(VPATH)}internal/interpreter.h
object.$(OBJEXT): {$(VPATH)}internal/iterator.h
object.$(OBJEXT): {$(VPATH)}internal/memory.h
object.$(OBJEXT): {$(VPATH)}internal/method.h
object.$(OBJEXT): {$(VPATH)}internal/module.h
object.$(OBJEXT): {$(VPATH)}internal/newobj.h
object.$(OBJEXT): {$(VPATH)}internal/rgengc.h
object.$(OBJEXT): {$(VPATH)}internal/scan_args.h
object.$(OBJEXT): {$(VPATH)}internal/special_consts.h
object.$(OBJEXT): {$(VPATH)}internal/static_assert.h
object.$(OBJEXT): {$(VPATH)}internal/stdalign.h
object.$(OBJEXT): {$(VPATH)}internal/stdbool.h
object.$(OBJEXT): {$(VPATH)}internal/symbol.h
object.$(OBJEXT): {$(VPATH)}internal/value.h
object.$(OBJEXT): {$(VPATH)}internal/value_type.h
object.$(OBJEXT): {$(VPATH)}internal/variable.h
object.$(OBJEXT): {$(VPATH)}internal/warning_push.h
object.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
object.$(OBJEXT): {$(VPATH)}kernel.rbinc
object.$(OBJEXT): {$(VPATH)}missing.h
object.$(OBJEXT): {$(VPATH)}nilclass.rbinc
object.$(OBJEXT): {$(VPATH)}object.c
object.$(OBJEXT): {$(VPATH)}onigmo.h
object.$(OBJEXT): {$(VPATH)}oniguruma.h
object.$(OBJEXT): {$(VPATH)}probes.dmyh
object.$(OBJEXT): {$(VPATH)}probes.h
object.$(OBJEXT): {$(VPATH)}shape.h
object.$(OBJEXT): {$(VPATH)}st.h
object.$(OBJEXT): {$(VPATH)}subst.h
object.$(OBJEXT): {$(VPATH)}util.h
object.$(OBJEXT): {$(VPATH)}variable.h
pack.$(OBJEXT): $(hdrdir)/ruby/ruby.h
pack.$(OBJEXT): $(top_srcdir)/internal/array.h
pack.$(OBJEXT): $(top_srcdir)/internal/bits.h
pack.$(OBJEXT): $(top_srcdir)/internal/compilers.h
pack.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
pack.$(OBJEXT): $(top_srcdir)/internal/string.h
pack.$(OBJEXT): $(top_srcdir)/internal/symbol.h
pack.$(OBJEXT): $(top_srcdir)/internal/variable.h
pack.$(OBJEXT): $(top_srcdir)/internal/warnings.h
pack.$(OBJEXT): {$(VPATH)}assert.h
pack.$(OBJEXT): {$(VPATH)}backward/2/assume.h
pack.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
pack.$(OBJEXT): {$(VPATH)}backward/2/bool.h
pack.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
pack.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
pack.$(OBJEXT): {$(VPATH)}backward/2/limits.h
pack.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
pack.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
pack.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
pack.$(OBJEXT): {$(VPATH)}builtin.h
pack.$(OBJEXT): {$(VPATH)}config.h
pack.$(OBJEXT): {$(VPATH)}constant.h
pack.$(OBJEXT): {$(VPATH)}defines.h
pack.$(OBJEXT): {$(VPATH)}encoding.h
pack.$(OBJEXT): {$(VPATH)}id_table.h
pack.$(OBJEXT): {$(VPATH)}intern.h
pack.$(OBJEXT): {$(VPATH)}internal.h
pack.$(OBJEXT): {$(VPATH)}internal/abi.h
pack.$(OBJEXT): {$(VPATH)}internal/anyargs.h
pack.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
pack.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
pack.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
pack.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
pack.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
pack.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
pack.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
pack.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
pack.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
pack.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
pack.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
pack.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
pack.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
pack.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
pack.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
pack.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
pack.$(OBJEXT): {$(VPATH)}internal/assume.h
pack.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
pack.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
pack.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
pack.$(OBJEXT): {$(VPATH)}internal/attr/const.h
pack.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
pack.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
pack.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
pack.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
pack.$(OBJEXT): {$(VPATH)}internal/attr/error.h
pack.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
pack.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
pack.$(OBJEXT): {$(VPATH)}internal/attr/format.h
pack.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
pack.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
pack.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
pack.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
pack.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
pack.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
pack.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
pack.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
pack.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
pack.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
pack.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
pack.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
pack.$(OBJEXT): {$(VPATH)}internal/cast.h
pack.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
pack.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
pack.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
pack.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
pack.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
pack.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
pack.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
pack.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
pack.$(OBJEXT): {$(VPATH)}internal/config.h
pack.$(OBJEXT): {$(VPATH)}internal/constant_p.h
pack.$(OBJEXT): {$(VPATH)}internal/core.h
pack.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
pack.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
pack.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
pack.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
pack.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
pack.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
pack.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
pack.$(OBJEXT): {$(VPATH)}internal/core/robject.h
pack.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
pack.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
pack.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
pack.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
pack.$(OBJEXT): {$(VPATH)}internal/ctype.h
pack.$(OBJEXT): {$(VPATH)}internal/dllexport.h
pack.$(OBJEXT): {$(VPATH)}internal/dosish.h
pack.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
pack.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
pack.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
pack.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
pack.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
pack.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
pack.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
pack.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
pack.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
pack.$(OBJEXT): {$(VPATH)}internal/error.h
pack.$(OBJEXT): {$(VPATH)}internal/eval.h
pack.$(OBJEXT): {$(VPATH)}internal/event.h
pack.$(OBJEXT): {$(VPATH)}internal/fl_type.h
pack.$(OBJEXT): {$(VPATH)}internal/gc.h
pack.$(OBJEXT): {$(VPATH)}internal/glob.h
pack.$(OBJEXT): {$(VPATH)}internal/globals.h
pack.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
pack.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
pack.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
pack.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
pack.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
pack.$(OBJEXT): {$(VPATH)}internal/has/extension.h
pack.$(OBJEXT): {$(VPATH)}internal/has/feature.h
pack.$(OBJEXT): {$(VPATH)}internal/has/warning.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/array.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/class.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/error.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/file.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/io.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/load.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/object.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/process.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/random.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/range.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/re.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/select.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/string.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/time.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
pack.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
pack.$(OBJEXT): {$(VPATH)}internal/interpreter.h
pack.$(OBJEXT): {$(VPATH)}internal/iterator.h
pack.$(OBJEXT): {$(VPATH)}internal/memory.h
pack.$(OBJEXT): {$(VPATH)}internal/method.h
pack.$(OBJEXT): {$(VPATH)}internal/module.h
pack.$(OBJEXT): {$(VPATH)}internal/newobj.h
pack.$(OBJEXT): {$(VPATH)}internal/rgengc.h
pack.$(OBJEXT): {$(VPATH)}internal/scan_args.h
pack.$(OBJEXT): {$(VPATH)}internal/special_consts.h
pack.$(OBJEXT): {$(VPATH)}internal/static_assert.h
pack.$(OBJEXT): {$(VPATH)}internal/stdalign.h
pack.$(OBJEXT): {$(VPATH)}internal/stdbool.h
pack.$(OBJEXT): {$(VPATH)}internal/symbol.h
pack.$(OBJEXT): {$(VPATH)}internal/value.h
pack.$(OBJEXT): {$(VPATH)}internal/value_type.h
pack.$(OBJEXT): {$(VPATH)}internal/variable.h
pack.$(OBJEXT): {$(VPATH)}internal/warning_push.h
pack.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
pack.$(OBJEXT): {$(VPATH)}missing.h
pack.$(OBJEXT): {$(VPATH)}onigmo.h
pack.$(OBJEXT): {$(VPATH)}oniguruma.h
pack.$(OBJEXT): {$(VPATH)}pack.c
pack.$(OBJEXT): {$(VPATH)}pack.rbinc
pack.$(OBJEXT): {$(VPATH)}shape.h
pack.$(OBJEXT): {$(VPATH)}st.h
pack.$(OBJEXT): {$(VPATH)}subst.h
pack.$(OBJEXT): {$(VPATH)}util.h
parse.$(OBJEXT): $(hdrdir)/ruby.h
parse.$(OBJEXT): $(hdrdir)/ruby/ruby.h
parse.$(OBJEXT): $(top_srcdir)/internal/array.h
parse.$(OBJEXT): $(top_srcdir)/internal/bignum.h
parse.$(OBJEXT): $(top_srcdir)/internal/bits.h
parse.$(OBJEXT): $(top_srcdir)/internal/compile.h
parse.$(OBJEXT): $(top_srcdir)/internal/compilers.h
parse.$(OBJEXT): $(top_srcdir)/internal/complex.h
parse.$(OBJEXT): $(top_srcdir)/internal/encoding.h
parse.$(OBJEXT): $(top_srcdir)/internal/error.h
parse.$(OBJEXT): $(top_srcdir)/internal/fixnum.h
parse.$(OBJEXT): $(top_srcdir)/internal/gc.h
parse.$(OBJEXT): $(top_srcdir)/internal/hash.h
parse.$(OBJEXT): $(top_srcdir)/internal/imemo.h
parse.$(OBJEXT): $(top_srcdir)/internal/io.h
parse.$(OBJEXT): $(top_srcdir)/internal/numeric.h
parse.$(OBJEXT): $(top_srcdir)/internal/parse.h
parse.$(OBJEXT): $(top_srcdir)/internal/rational.h
parse.$(OBJEXT): $(top_srcdir)/internal/re.h
parse.$(OBJEXT): $(top_srcdir)/internal/serial.h
parse.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
parse.$(OBJEXT): $(top_srcdir)/internal/string.h
parse.$(OBJEXT): $(top_srcdir)/internal/symbol.h
parse.$(OBJEXT): $(top_srcdir)/internal/thread.h
parse.$(OBJEXT): $(top_srcdir)/internal/variable.h
parse.$(OBJEXT): $(top_srcdir)/internal/vm.h
parse.$(OBJEXT): $(top_srcdir)/internal/warnings.h
parse.$(OBJEXT): {$(VPATH)}assert.h
parse.$(OBJEXT): {$(VPATH)}backward/2/assume.h
parse.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
parse.$(OBJEXT): {$(VPATH)}backward/2/bool.h
parse.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
parse.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
parse.$(OBJEXT): {$(VPATH)}backward/2/limits.h
parse.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
parse.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
parse.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
parse.$(OBJEXT): {$(VPATH)}config.h
parse.$(OBJEXT): {$(VPATH)}constant.h
parse.$(OBJEXT): {$(VPATH)}defines.h
parse.$(OBJEXT): {$(VPATH)}defs/keywords
parse.$(OBJEXT): {$(VPATH)}encoding.h
parse.$(OBJEXT): {$(VPATH)}id.h
parse.$(OBJEXT): {$(VPATH)}id_table.h
parse.$(OBJEXT): {$(VPATH)}intern.h
parse.$(OBJEXT): {$(VPATH)}internal.h
parse.$(OBJEXT): {$(VPATH)}internal/abi.h
parse.$(OBJEXT): {$(VPATH)}internal/anyargs.h
parse.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
parse.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
parse.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
parse.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
parse.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
parse.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
parse.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
parse.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
parse.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
parse.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
parse.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
parse.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
parse.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
parse.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
parse.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
parse.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
parse.$(OBJEXT): {$(VPATH)}internal/assume.h
parse.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
parse.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
parse.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
parse.$(OBJEXT): {$(VPATH)}internal/attr/const.h
parse.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
parse.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
parse.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
parse.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
parse.$(OBJEXT): {$(VPATH)}internal/attr/error.h
parse.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
parse.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
parse.$(OBJEXT): {$(VPATH)}internal/attr/format.h
parse.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
parse.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
parse.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
parse.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
parse.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
parse.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
parse.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
parse.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
parse.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
parse.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
parse.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
parse.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
parse.$(OBJEXT): {$(VPATH)}internal/cast.h
parse.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
parse.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
parse.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
parse.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
parse.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
parse.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
parse.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
parse.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
parse.$(OBJEXT): {$(VPATH)}internal/config.h
parse.$(OBJEXT): {$(VPATH)}internal/constant_p.h
parse.$(OBJEXT): {$(VPATH)}internal/core.h
parse.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
parse.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
parse.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
parse.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
parse.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
parse.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
parse.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
parse.$(OBJEXT): {$(VPATH)}internal/core/robject.h
parse.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
parse.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
parse.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
parse.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
parse.$(OBJEXT): {$(VPATH)}internal/ctype.h
parse.$(OBJEXT): {$(VPATH)}internal/dllexport.h
parse.$(OBJEXT): {$(VPATH)}internal/dosish.h
parse.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
parse.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
parse.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
parse.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
parse.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
parse.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
parse.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
parse.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
parse.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
parse.$(OBJEXT): {$(VPATH)}internal/error.h
parse.$(OBJEXT): {$(VPATH)}internal/eval.h
parse.$(OBJEXT): {$(VPATH)}internal/event.h
parse.$(OBJEXT): {$(VPATH)}internal/fl_type.h
parse.$(OBJEXT): {$(VPATH)}internal/gc.h
parse.$(OBJEXT): {$(VPATH)}internal/glob.h
parse.$(OBJEXT): {$(VPATH)}internal/globals.h
parse.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
parse.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
parse.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
parse.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
parse.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
parse.$(OBJEXT): {$(VPATH)}internal/has/extension.h
parse.$(OBJEXT): {$(VPATH)}internal/has/feature.h
parse.$(OBJEXT): {$(VPATH)}internal/has/warning.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/array.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/class.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/error.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/file.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/io.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/load.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/object.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/process.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/random.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/range.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/re.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/select.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/string.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/time.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
parse.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
parse.$(OBJEXT): {$(VPATH)}internal/interpreter.h
parse.$(OBJEXT): {$(VPATH)}internal/iterator.h
parse.$(OBJEXT): {$(VPATH)}internal/memory.h
parse.$(OBJEXT): {$(VPATH)}internal/method.h
parse.$(OBJEXT): {$(VPATH)}internal/module.h
parse.$(OBJEXT): {$(VPATH)}internal/newobj.h
parse.$(OBJEXT): {$(VPATH)}internal/rgengc.h
parse.$(OBJEXT): {$(VPATH)}internal/scan_args.h
parse.$(OBJEXT): {$(VPATH)}internal/special_consts.h
parse.$(OBJEXT): {$(VPATH)}internal/static_assert.h
parse.$(OBJEXT): {$(VPATH)}internal/stdalign.h
parse.$(OBJEXT): {$(VPATH)}internal/stdbool.h
parse.$(OBJEXT): {$(VPATH)}internal/symbol.h
parse.$(OBJEXT): {$(VPATH)}internal/value.h
parse.$(OBJEXT): {$(VPATH)}internal/value_type.h
parse.$(OBJEXT): {$(VPATH)}internal/variable.h
parse.$(OBJEXT): {$(VPATH)}internal/warning_push.h
parse.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
parse.$(OBJEXT): {$(VPATH)}io.h
parse.$(OBJEXT): {$(VPATH)}lex.c
parse.$(OBJEXT): {$(VPATH)}missing.h
parse.$(OBJEXT): {$(VPATH)}node.h
parse.$(OBJEXT): {$(VPATH)}onigmo.h
parse.$(OBJEXT): {$(VPATH)}oniguruma.h
parse.$(OBJEXT): {$(VPATH)}parse.c
parse.$(OBJEXT): {$(VPATH)}parse.h
parse.$(OBJEXT): {$(VPATH)}parse.y
parse.$(OBJEXT): {$(VPATH)}probes.dmyh
parse.$(OBJEXT): {$(VPATH)}probes.h
parse.$(OBJEXT): {$(VPATH)}ractor.h
parse.$(OBJEXT): {$(VPATH)}regenc.h
parse.$(OBJEXT): {$(VPATH)}regex.h
parse.$(OBJEXT): {$(VPATH)}ruby_assert.h
parse.$(OBJEXT): {$(VPATH)}shape.h
parse.$(OBJEXT): {$(VPATH)}st.h
parse.$(OBJEXT): {$(VPATH)}subst.h
parse.$(OBJEXT): {$(VPATH)}symbol.h
parse.$(OBJEXT): {$(VPATH)}util.h
proc.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
proc.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
proc.$(OBJEXT): $(CCAN_DIR)/list/list.h
proc.$(OBJEXT): $(CCAN_DIR)/str/str.h
proc.$(OBJEXT): $(hdrdir)/ruby/ruby.h
proc.$(OBJEXT): $(top_srcdir)/internal/array.h
proc.$(OBJEXT): $(top_srcdir)/internal/class.h
proc.$(OBJEXT): $(top_srcdir)/internal/compilers.h
proc.$(OBJEXT): $(top_srcdir)/internal/error.h
proc.$(OBJEXT): $(top_srcdir)/internal/eval.h
proc.$(OBJEXT): $(top_srcdir)/internal/gc.h
proc.$(OBJEXT): $(top_srcdir)/internal/imemo.h
proc.$(OBJEXT): $(top_srcdir)/internal/object.h
proc.$(OBJEXT): $(top_srcdir)/internal/proc.h
proc.$(OBJEXT): $(top_srcdir)/internal/serial.h
proc.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
proc.$(OBJEXT): $(top_srcdir)/internal/string.h
proc.$(OBJEXT): $(top_srcdir)/internal/symbol.h
proc.$(OBJEXT): $(top_srcdir)/internal/variable.h
proc.$(OBJEXT): $(top_srcdir)/internal/vm.h
proc.$(OBJEXT): $(top_srcdir)/internal/warnings.h
proc.$(OBJEXT): {$(VPATH)}assert.h
proc.$(OBJEXT): {$(VPATH)}atomic.h
proc.$(OBJEXT): {$(VPATH)}backward/2/assume.h
proc.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
proc.$(OBJEXT): {$(VPATH)}backward/2/bool.h
proc.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
proc.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
proc.$(OBJEXT): {$(VPATH)}backward/2/limits.h
proc.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
proc.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
proc.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
proc.$(OBJEXT): {$(VPATH)}config.h
proc.$(OBJEXT): {$(VPATH)}constant.h
proc.$(OBJEXT): {$(VPATH)}defines.h
proc.$(OBJEXT): {$(VPATH)}encoding.h
proc.$(OBJEXT): {$(VPATH)}eval_intern.h
proc.$(OBJEXT): {$(VPATH)}gc.h
proc.$(OBJEXT): {$(VPATH)}id.h
proc.$(OBJEXT): {$(VPATH)}id_table.h
proc.$(OBJEXT): {$(VPATH)}intern.h
proc.$(OBJEXT): {$(VPATH)}internal.h
proc.$(OBJEXT): {$(VPATH)}internal/abi.h
proc.$(OBJEXT): {$(VPATH)}internal/anyargs.h
proc.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
proc.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
proc.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
proc.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
proc.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
proc.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
proc.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
proc.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
proc.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
proc.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
proc.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
proc.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
proc.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
proc.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
proc.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
proc.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
proc.$(OBJEXT): {$(VPATH)}internal/assume.h
proc.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
proc.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
proc.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
proc.$(OBJEXT): {$(VPATH)}internal/attr/const.h
proc.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
proc.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
proc.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
proc.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
proc.$(OBJEXT): {$(VPATH)}internal/attr/error.h
proc.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
proc.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
proc.$(OBJEXT): {$(VPATH)}internal/attr/format.h
proc.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
proc.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
proc.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
proc.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
proc.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
proc.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
proc.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
proc.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
proc.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
proc.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
proc.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
proc.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
proc.$(OBJEXT): {$(VPATH)}internal/cast.h
proc.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
proc.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
proc.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
proc.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
proc.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
proc.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
proc.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
proc.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
proc.$(OBJEXT): {$(VPATH)}internal/config.h
proc.$(OBJEXT): {$(VPATH)}internal/constant_p.h
proc.$(OBJEXT): {$(VPATH)}internal/core.h
proc.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
proc.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
proc.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
proc.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
proc.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
proc.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
proc.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
proc.$(OBJEXT): {$(VPATH)}internal/core/robject.h
proc.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
proc.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
proc.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
proc.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
proc.$(OBJEXT): {$(VPATH)}internal/ctype.h
proc.$(OBJEXT): {$(VPATH)}internal/dllexport.h
proc.$(OBJEXT): {$(VPATH)}internal/dosish.h
proc.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
proc.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
proc.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
proc.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
proc.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
proc.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
proc.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
proc.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
proc.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
proc.$(OBJEXT): {$(VPATH)}internal/error.h
proc.$(OBJEXT): {$(VPATH)}internal/eval.h
proc.$(OBJEXT): {$(VPATH)}internal/event.h
proc.$(OBJEXT): {$(VPATH)}internal/fl_type.h
proc.$(OBJEXT): {$(VPATH)}internal/gc.h
proc.$(OBJEXT): {$(VPATH)}internal/glob.h
proc.$(OBJEXT): {$(VPATH)}internal/globals.h
proc.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
proc.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
proc.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
proc.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
proc.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
proc.$(OBJEXT): {$(VPATH)}internal/has/extension.h
proc.$(OBJEXT): {$(VPATH)}internal/has/feature.h
proc.$(OBJEXT): {$(VPATH)}internal/has/warning.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/array.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/class.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/error.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/file.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/io.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/load.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/object.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/process.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/random.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/range.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/re.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/select.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/string.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/time.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
proc.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
proc.$(OBJEXT): {$(VPATH)}internal/interpreter.h
proc.$(OBJEXT): {$(VPATH)}internal/iterator.h
proc.$(OBJEXT): {$(VPATH)}internal/memory.h
proc.$(OBJEXT): {$(VPATH)}internal/method.h
proc.$(OBJEXT): {$(VPATH)}internal/module.h
proc.$(OBJEXT): {$(VPATH)}internal/newobj.h
proc.$(OBJEXT): {$(VPATH)}internal/rgengc.h
proc.$(OBJEXT): {$(VPATH)}internal/scan_args.h
proc.$(OBJEXT): {$(VPATH)}internal/special_consts.h
proc.$(OBJEXT): {$(VPATH)}internal/static_assert.h
proc.$(OBJEXT): {$(VPATH)}internal/stdalign.h
proc.$(OBJEXT): {$(VPATH)}internal/stdbool.h
proc.$(OBJEXT): {$(VPATH)}internal/symbol.h
proc.$(OBJEXT): {$(VPATH)}internal/value.h
proc.$(OBJEXT): {$(VPATH)}internal/value_type.h
proc.$(OBJEXT): {$(VPATH)}internal/variable.h
proc.$(OBJEXT): {$(VPATH)}internal/warning_push.h
proc.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
proc.$(OBJEXT): {$(VPATH)}iseq.h
proc.$(OBJEXT): {$(VPATH)}method.h
proc.$(OBJEXT): {$(VPATH)}missing.h
proc.$(OBJEXT): {$(VPATH)}node.h
proc.$(OBJEXT): {$(VPATH)}onigmo.h
proc.$(OBJEXT): {$(VPATH)}oniguruma.h
proc.$(OBJEXT): {$(VPATH)}proc.c
proc.$(OBJEXT): {$(VPATH)}ruby_assert.h
proc.$(OBJEXT): {$(VPATH)}ruby_atomic.h
proc.$(OBJEXT): {$(VPATH)}shape.h
proc.$(OBJEXT): {$(VPATH)}st.h
proc.$(OBJEXT): {$(VPATH)}subst.h
proc.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
proc.$(OBJEXT): {$(VPATH)}thread_native.h
proc.$(OBJEXT): {$(VPATH)}vm_core.h
proc.$(OBJEXT): {$(VPATH)}vm_opts.h
proc.$(OBJEXT): {$(VPATH)}yjit.h
process.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
process.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
process.$(OBJEXT): $(CCAN_DIR)/list/list.h
process.$(OBJEXT): $(CCAN_DIR)/str/str.h
process.$(OBJEXT): $(hdrdir)/ruby.h
process.$(OBJEXT): $(hdrdir)/ruby/ruby.h
process.$(OBJEXT): $(top_srcdir)/internal/array.h
process.$(OBJEXT): $(top_srcdir)/internal/bignum.h
process.$(OBJEXT): $(top_srcdir)/internal/bits.h
process.$(OBJEXT): $(top_srcdir)/internal/class.h
process.$(OBJEXT): $(top_srcdir)/internal/compilers.h
process.$(OBJEXT): $(top_srcdir)/internal/dir.h
process.$(OBJEXT): $(top_srcdir)/internal/error.h
process.$(OBJEXT): $(top_srcdir)/internal/eval.h
process.$(OBJEXT): $(top_srcdir)/internal/fixnum.h
process.$(OBJEXT): $(top_srcdir)/internal/gc.h
process.$(OBJEXT): $(top_srcdir)/internal/hash.h
process.$(OBJEXT): $(top_srcdir)/internal/imemo.h
process.$(OBJEXT): $(top_srcdir)/internal/numeric.h
process.$(OBJEXT): $(top_srcdir)/internal/object.h
process.$(OBJEXT): $(top_srcdir)/internal/process.h
process.$(OBJEXT): $(top_srcdir)/internal/serial.h
process.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
process.$(OBJEXT): $(top_srcdir)/internal/string.h
process.$(OBJEXT): $(top_srcdir)/internal/thread.h
process.$(OBJEXT): $(top_srcdir)/internal/time.h
process.$(OBJEXT): $(top_srcdir)/internal/variable.h
process.$(OBJEXT): $(top_srcdir)/internal/vm.h
process.$(OBJEXT): $(top_srcdir)/internal/warnings.h
process.$(OBJEXT): {$(VPATH)}assert.h
process.$(OBJEXT): {$(VPATH)}atomic.h
process.$(OBJEXT): {$(VPATH)}backward/2/assume.h
process.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
process.$(OBJEXT): {$(VPATH)}backward/2/bool.h
process.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
process.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
process.$(OBJEXT): {$(VPATH)}backward/2/limits.h
process.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
process.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
process.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
process.$(OBJEXT): {$(VPATH)}config.h
process.$(OBJEXT): {$(VPATH)}constant.h
process.$(OBJEXT): {$(VPATH)}debug_counter.h
process.$(OBJEXT): {$(VPATH)}defines.h
process.$(OBJEXT): {$(VPATH)}dln.h
process.$(OBJEXT): {$(VPATH)}encoding.h
process.$(OBJEXT): {$(VPATH)}fiber/scheduler.h
process.$(OBJEXT): {$(VPATH)}hrtime.h
process.$(OBJEXT): {$(VPATH)}id.h
process.$(OBJEXT): {$(VPATH)}id_table.h
process.$(OBJEXT): {$(VPATH)}intern.h
process.$(OBJEXT): {$(VPATH)}internal.h
process.$(OBJEXT): {$(VPATH)}internal/abi.h
process.$(OBJEXT): {$(VPATH)}internal/anyargs.h
process.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
process.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
process.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
process.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
process.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
process.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
process.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
process.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
process.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
process.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
process.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
process.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
process.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
process.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
process.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
process.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
process.$(OBJEXT): {$(VPATH)}internal/assume.h
process.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
process.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
process.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
process.$(OBJEXT): {$(VPATH)}internal/attr/const.h
process.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
process.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
process.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
process.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
process.$(OBJEXT): {$(VPATH)}internal/attr/error.h
process.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
process.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
process.$(OBJEXT): {$(VPATH)}internal/attr/format.h
process.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
process.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
process.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
process.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
process.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
process.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
process.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
process.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
process.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
process.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
process.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
process.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
process.$(OBJEXT): {$(VPATH)}internal/cast.h
process.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
process.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
process.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
process.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
process.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
process.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
process.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
process.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
process.$(OBJEXT): {$(VPATH)}internal/config.h
process.$(OBJEXT): {$(VPATH)}internal/constant_p.h
process.$(OBJEXT): {$(VPATH)}internal/core.h
process.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
process.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
process.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
process.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
process.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
process.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
process.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
process.$(OBJEXT): {$(VPATH)}internal/core/robject.h
process.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
process.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
process.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
process.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
process.$(OBJEXT): {$(VPATH)}internal/ctype.h
process.$(OBJEXT): {$(VPATH)}internal/dllexport.h
process.$(OBJEXT): {$(VPATH)}internal/dosish.h
process.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
process.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
process.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
process.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
process.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
process.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
process.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
process.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
process.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
process.$(OBJEXT): {$(VPATH)}internal/error.h
process.$(OBJEXT): {$(VPATH)}internal/eval.h
process.$(OBJEXT): {$(VPATH)}internal/event.h
process.$(OBJEXT): {$(VPATH)}internal/fl_type.h
process.$(OBJEXT): {$(VPATH)}internal/gc.h
process.$(OBJEXT): {$(VPATH)}internal/glob.h
process.$(OBJEXT): {$(VPATH)}internal/globals.h
process.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
process.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
process.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
process.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
process.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
process.$(OBJEXT): {$(VPATH)}internal/has/extension.h
process.$(OBJEXT): {$(VPATH)}internal/has/feature.h
process.$(OBJEXT): {$(VPATH)}internal/has/warning.h
process.$(OBJEXT): {$(VPATH)}internal/intern/array.h
process.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
process.$(OBJEXT): {$(VPATH)}internal/intern/class.h
process.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
process.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
process.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
process.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
process.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
process.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
process.$(OBJEXT): {$(VPATH)}internal/intern/error.h
process.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
process.$(OBJEXT): {$(VPATH)}internal/intern/file.h
process.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
process.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
process.$(OBJEXT): {$(VPATH)}internal/intern/io.h
process.$(OBJEXT): {$(VPATH)}internal/intern/load.h
process.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
process.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
process.$(OBJEXT): {$(VPATH)}internal/intern/object.h
process.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
process.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
process.$(OBJEXT): {$(VPATH)}internal/intern/process.h
process.$(OBJEXT): {$(VPATH)}internal/intern/random.h
process.$(OBJEXT): {$(VPATH)}internal/intern/range.h
process.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
process.$(OBJEXT): {$(VPATH)}internal/intern/re.h
process.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
process.$(OBJEXT): {$(VPATH)}internal/intern/select.h
process.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
process.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
process.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
process.$(OBJEXT): {$(VPATH)}internal/intern/string.h
process.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
process.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
process.$(OBJEXT): {$(VPATH)}internal/intern/time.h
process.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
process.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
process.$(OBJEXT): {$(VPATH)}internal/interpreter.h
process.$(OBJEXT): {$(VPATH)}internal/iterator.h
process.$(OBJEXT): {$(VPATH)}internal/memory.h
process.$(OBJEXT): {$(VPATH)}internal/method.h
process.$(OBJEXT): {$(VPATH)}internal/module.h
process.$(OBJEXT): {$(VPATH)}internal/newobj.h
process.$(OBJEXT): {$(VPATH)}internal/rgengc.h
process.$(OBJEXT): {$(VPATH)}internal/scan_args.h
process.$(OBJEXT): {$(VPATH)}internal/special_consts.h
process.$(OBJEXT): {$(VPATH)}internal/static_assert.h
process.$(OBJEXT): {$(VPATH)}internal/stdalign.h
process.$(OBJEXT): {$(VPATH)}internal/stdbool.h
process.$(OBJEXT): {$(VPATH)}internal/symbol.h
process.$(OBJEXT): {$(VPATH)}internal/value.h
process.$(OBJEXT): {$(VPATH)}internal/value_type.h
process.$(OBJEXT): {$(VPATH)}internal/variable.h
process.$(OBJEXT): {$(VPATH)}internal/warning_push.h
process.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
process.$(OBJEXT): {$(VPATH)}io.h
process.$(OBJEXT): {$(VPATH)}method.h
process.$(OBJEXT): {$(VPATH)}missing.h
process.$(OBJEXT): {$(VPATH)}mjit.h
process.$(OBJEXT): {$(VPATH)}node.h
process.$(OBJEXT): {$(VPATH)}onigmo.h
process.$(OBJEXT): {$(VPATH)}oniguruma.h
process.$(OBJEXT): {$(VPATH)}process.c
process.$(OBJEXT): {$(VPATH)}ractor.h
process.$(OBJEXT): {$(VPATH)}ruby_assert.h
process.$(OBJEXT): {$(VPATH)}ruby_atomic.h
process.$(OBJEXT): {$(VPATH)}shape.h
process.$(OBJEXT): {$(VPATH)}st.h
process.$(OBJEXT): {$(VPATH)}subst.h
process.$(OBJEXT): {$(VPATH)}thread.h
process.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
process.$(OBJEXT): {$(VPATH)}thread_native.h
process.$(OBJEXT): {$(VPATH)}util.h
process.$(OBJEXT): {$(VPATH)}vm_core.h
process.$(OBJEXT): {$(VPATH)}vm_opts.h
ractor.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
ractor.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
ractor.$(OBJEXT): $(CCAN_DIR)/list/list.h
ractor.$(OBJEXT): $(CCAN_DIR)/str/str.h
ractor.$(OBJEXT): $(hdrdir)/ruby/ruby.h
ractor.$(OBJEXT): $(top_srcdir)/internal/array.h
ractor.$(OBJEXT): $(top_srcdir)/internal/bignum.h
ractor.$(OBJEXT): $(top_srcdir)/internal/bits.h
ractor.$(OBJEXT): $(top_srcdir)/internal/compilers.h
ractor.$(OBJEXT): $(top_srcdir)/internal/complex.h
ractor.$(OBJEXT): $(top_srcdir)/internal/error.h
ractor.$(OBJEXT): $(top_srcdir)/internal/fixnum.h
ractor.$(OBJEXT): $(top_srcdir)/internal/gc.h
ractor.$(OBJEXT): $(top_srcdir)/internal/hash.h
ractor.$(OBJEXT): $(top_srcdir)/internal/imemo.h
ractor.$(OBJEXT): $(top_srcdir)/internal/numeric.h
ractor.$(OBJEXT): $(top_srcdir)/internal/rational.h
ractor.$(OBJEXT): $(top_srcdir)/internal/serial.h
ractor.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
ractor.$(OBJEXT): $(top_srcdir)/internal/string.h
ractor.$(OBJEXT): $(top_srcdir)/internal/struct.h
ractor.$(OBJEXT): $(top_srcdir)/internal/thread.h
ractor.$(OBJEXT): $(top_srcdir)/internal/variable.h
ractor.$(OBJEXT): $(top_srcdir)/internal/vm.h
ractor.$(OBJEXT): $(top_srcdir)/internal/warnings.h
ractor.$(OBJEXT): {$(VPATH)}assert.h
ractor.$(OBJEXT): {$(VPATH)}atomic.h
ractor.$(OBJEXT): {$(VPATH)}backward/2/assume.h
ractor.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
ractor.$(OBJEXT): {$(VPATH)}backward/2/bool.h
ractor.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
ractor.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
ractor.$(OBJEXT): {$(VPATH)}backward/2/limits.h
ractor.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
ractor.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
ractor.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
ractor.$(OBJEXT): {$(VPATH)}builtin.h
ractor.$(OBJEXT): {$(VPATH)}config.h
ractor.$(OBJEXT): {$(VPATH)}constant.h
ractor.$(OBJEXT): {$(VPATH)}debug_counter.h
ractor.$(OBJEXT): {$(VPATH)}defines.h
ractor.$(OBJEXT): {$(VPATH)}encoding.h
ractor.$(OBJEXT): {$(VPATH)}gc.h
ractor.$(OBJEXT): {$(VPATH)}id.h
ractor.$(OBJEXT): {$(VPATH)}id_table.h
ractor.$(OBJEXT): {$(VPATH)}intern.h
ractor.$(OBJEXT): {$(VPATH)}internal.h
ractor.$(OBJEXT): {$(VPATH)}internal/abi.h
ractor.$(OBJEXT): {$(VPATH)}internal/anyargs.h
ractor.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
ractor.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
ractor.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
ractor.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
ractor.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
ractor.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
ractor.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
ractor.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
ractor.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
ractor.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
ractor.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
ractor.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
ractor.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
ractor.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
ractor.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
ractor.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
ractor.$(OBJEXT): {$(VPATH)}internal/assume.h
ractor.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
ractor.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
ractor.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
ractor.$(OBJEXT): {$(VPATH)}internal/attr/const.h
ractor.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
ractor.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
ractor.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
ractor.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
ractor.$(OBJEXT): {$(VPATH)}internal/attr/error.h
ractor.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
ractor.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
ractor.$(OBJEXT): {$(VPATH)}internal/attr/format.h
ractor.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
ractor.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
ractor.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
ractor.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
ractor.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
ractor.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
ractor.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
ractor.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
ractor.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
ractor.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
ractor.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
ractor.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
ractor.$(OBJEXT): {$(VPATH)}internal/cast.h
ractor.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
ractor.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
ractor.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
ractor.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
ractor.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
ractor.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
ractor.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
ractor.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
ractor.$(OBJEXT): {$(VPATH)}internal/config.h
ractor.$(OBJEXT): {$(VPATH)}internal/constant_p.h
ractor.$(OBJEXT): {$(VPATH)}internal/core.h
ractor.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
ractor.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
ractor.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
ractor.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
ractor.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
ractor.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
ractor.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
ractor.$(OBJEXT): {$(VPATH)}internal/core/robject.h
ractor.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
ractor.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
ractor.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
ractor.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
ractor.$(OBJEXT): {$(VPATH)}internal/ctype.h
ractor.$(OBJEXT): {$(VPATH)}internal/dllexport.h
ractor.$(OBJEXT): {$(VPATH)}internal/dosish.h
ractor.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
ractor.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
ractor.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
ractor.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
ractor.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
ractor.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
ractor.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
ractor.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
ractor.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
ractor.$(OBJEXT): {$(VPATH)}internal/error.h
ractor.$(OBJEXT): {$(VPATH)}internal/eval.h
ractor.$(OBJEXT): {$(VPATH)}internal/event.h
ractor.$(OBJEXT): {$(VPATH)}internal/fl_type.h
ractor.$(OBJEXT): {$(VPATH)}internal/gc.h
ractor.$(OBJEXT): {$(VPATH)}internal/glob.h
ractor.$(OBJEXT): {$(VPATH)}internal/globals.h
ractor.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
ractor.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
ractor.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
ractor.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
ractor.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
ractor.$(OBJEXT): {$(VPATH)}internal/has/extension.h
ractor.$(OBJEXT): {$(VPATH)}internal/has/feature.h
ractor.$(OBJEXT): {$(VPATH)}internal/has/warning.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/array.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/class.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/error.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/file.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/io.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/load.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/object.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/process.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/random.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/range.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/re.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/select.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/string.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/time.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
ractor.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
ractor.$(OBJEXT): {$(VPATH)}internal/interpreter.h
ractor.$(OBJEXT): {$(VPATH)}internal/iterator.h
ractor.$(OBJEXT): {$(VPATH)}internal/memory.h
ractor.$(OBJEXT): {$(VPATH)}internal/method.h
ractor.$(OBJEXT): {$(VPATH)}internal/module.h
ractor.$(OBJEXT): {$(VPATH)}internal/newobj.h
ractor.$(OBJEXT): {$(VPATH)}internal/rgengc.h
ractor.$(OBJEXT): {$(VPATH)}internal/scan_args.h
ractor.$(OBJEXT): {$(VPATH)}internal/special_consts.h
ractor.$(OBJEXT): {$(VPATH)}internal/static_assert.h
ractor.$(OBJEXT): {$(VPATH)}internal/stdalign.h
ractor.$(OBJEXT): {$(VPATH)}internal/stdbool.h
ractor.$(OBJEXT): {$(VPATH)}internal/symbol.h
ractor.$(OBJEXT): {$(VPATH)}internal/value.h
ractor.$(OBJEXT): {$(VPATH)}internal/value_type.h
ractor.$(OBJEXT): {$(VPATH)}internal/variable.h
ractor.$(OBJEXT): {$(VPATH)}internal/warning_push.h
ractor.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
ractor.$(OBJEXT): {$(VPATH)}method.h
ractor.$(OBJEXT): {$(VPATH)}missing.h
ractor.$(OBJEXT): {$(VPATH)}node.h
ractor.$(OBJEXT): {$(VPATH)}onigmo.h
ractor.$(OBJEXT): {$(VPATH)}oniguruma.h
ractor.$(OBJEXT): {$(VPATH)}ractor.c
ractor.$(OBJEXT): {$(VPATH)}ractor.h
ractor.$(OBJEXT): {$(VPATH)}ractor.rbinc
ractor.$(OBJEXT): {$(VPATH)}ractor_core.h
ractor.$(OBJEXT): {$(VPATH)}ruby_assert.h
ractor.$(OBJEXT): {$(VPATH)}ruby_atomic.h
ractor.$(OBJEXT): {$(VPATH)}shape.h
ractor.$(OBJEXT): {$(VPATH)}st.h
ractor.$(OBJEXT): {$(VPATH)}subst.h
ractor.$(OBJEXT): {$(VPATH)}thread.h
ractor.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
ractor.$(OBJEXT): {$(VPATH)}thread_native.h
ractor.$(OBJEXT): {$(VPATH)}transient_heap.h
ractor.$(OBJEXT): {$(VPATH)}variable.h
ractor.$(OBJEXT): {$(VPATH)}vm_core.h
ractor.$(OBJEXT): {$(VPATH)}vm_debug.h
ractor.$(OBJEXT): {$(VPATH)}vm_opts.h
ractor.$(OBJEXT): {$(VPATH)}vm_sync.h
ractor.$(OBJEXT): {$(VPATH)}yjit.h
random.$(OBJEXT): $(hdrdir)/ruby/ruby.h
random.$(OBJEXT): $(top_srcdir)/internal/array.h
random.$(OBJEXT): $(top_srcdir)/internal/bignum.h
random.$(OBJEXT): $(top_srcdir)/internal/bits.h
random.$(OBJEXT): $(top_srcdir)/internal/compilers.h
random.$(OBJEXT): $(top_srcdir)/internal/fixnum.h
random.$(OBJEXT): $(top_srcdir)/internal/numeric.h
random.$(OBJEXT): $(top_srcdir)/internal/random.h
random.$(OBJEXT): $(top_srcdir)/internal/sanitizers.h
random.$(OBJEXT): $(top_srcdir)/internal/serial.h
random.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
random.$(OBJEXT): $(top_srcdir)/internal/variable.h
random.$(OBJEXT): $(top_srcdir)/internal/vm.h
random.$(OBJEXT): $(top_srcdir)/internal/warnings.h
random.$(OBJEXT): {$(VPATH)}assert.h
random.$(OBJEXT): {$(VPATH)}atomic.h
random.$(OBJEXT): {$(VPATH)}backward/2/assume.h
random.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
random.$(OBJEXT): {$(VPATH)}backward/2/bool.h
random.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
random.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
random.$(OBJEXT): {$(VPATH)}backward/2/limits.h
random.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
random.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
random.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
random.$(OBJEXT): {$(VPATH)}config.h
random.$(OBJEXT): {$(VPATH)}constant.h
random.$(OBJEXT): {$(VPATH)}defines.h
random.$(OBJEXT): {$(VPATH)}id_table.h
random.$(OBJEXT): {$(VPATH)}intern.h
random.$(OBJEXT): {$(VPATH)}internal.h
random.$(OBJEXT): {$(VPATH)}internal/abi.h
random.$(OBJEXT): {$(VPATH)}internal/anyargs.h
random.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
random.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
random.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
random.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
random.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
random.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
random.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
random.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
random.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
random.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
random.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
random.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
random.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
random.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
random.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
random.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
random.$(OBJEXT): {$(VPATH)}internal/assume.h
random.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
random.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
random.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
random.$(OBJEXT): {$(VPATH)}internal/attr/const.h
random.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
random.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
random.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
random.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
random.$(OBJEXT): {$(VPATH)}internal/attr/error.h
random.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
random.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
random.$(OBJEXT): {$(VPATH)}internal/attr/format.h
random.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
random.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
random.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
random.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
random.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
random.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
random.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
random.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
random.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
random.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
random.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
random.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
random.$(OBJEXT): {$(VPATH)}internal/cast.h
random.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
random.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
random.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
random.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
random.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
random.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
random.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
random.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
random.$(OBJEXT): {$(VPATH)}internal/config.h
random.$(OBJEXT): {$(VPATH)}internal/constant_p.h
random.$(OBJEXT): {$(VPATH)}internal/core.h
random.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
random.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
random.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
random.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
random.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
random.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
random.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
random.$(OBJEXT): {$(VPATH)}internal/core/robject.h
random.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
random.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
random.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
random.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
random.$(OBJEXT): {$(VPATH)}internal/ctype.h
random.$(OBJEXT): {$(VPATH)}internal/dllexport.h
random.$(OBJEXT): {$(VPATH)}internal/dosish.h
random.$(OBJEXT): {$(VPATH)}internal/error.h
random.$(OBJEXT): {$(VPATH)}internal/eval.h
random.$(OBJEXT): {$(VPATH)}internal/event.h
random.$(OBJEXT): {$(VPATH)}internal/fl_type.h
random.$(OBJEXT): {$(VPATH)}internal/gc.h
random.$(OBJEXT): {$(VPATH)}internal/glob.h
random.$(OBJEXT): {$(VPATH)}internal/globals.h
random.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
random.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
random.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
random.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
random.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
random.$(OBJEXT): {$(VPATH)}internal/has/extension.h
random.$(OBJEXT): {$(VPATH)}internal/has/feature.h
random.$(OBJEXT): {$(VPATH)}internal/has/warning.h
random.$(OBJEXT): {$(VPATH)}internal/intern/array.h
random.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
random.$(OBJEXT): {$(VPATH)}internal/intern/class.h
random.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
random.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
random.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
random.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
random.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
random.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
random.$(OBJEXT): {$(VPATH)}internal/intern/error.h
random.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
random.$(OBJEXT): {$(VPATH)}internal/intern/file.h
random.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
random.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
random.$(OBJEXT): {$(VPATH)}internal/intern/io.h
random.$(OBJEXT): {$(VPATH)}internal/intern/load.h
random.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
random.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
random.$(OBJEXT): {$(VPATH)}internal/intern/object.h
random.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
random.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
random.$(OBJEXT): {$(VPATH)}internal/intern/process.h
random.$(OBJEXT): {$(VPATH)}internal/intern/random.h
random.$(OBJEXT): {$(VPATH)}internal/intern/range.h
random.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
random.$(OBJEXT): {$(VPATH)}internal/intern/re.h
random.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
random.$(OBJEXT): {$(VPATH)}internal/intern/select.h
random.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
random.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
random.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
random.$(OBJEXT): {$(VPATH)}internal/intern/string.h
random.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
random.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
random.$(OBJEXT): {$(VPATH)}internal/intern/time.h
random.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
random.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
random.$(OBJEXT): {$(VPATH)}internal/interpreter.h
random.$(OBJEXT): {$(VPATH)}internal/iterator.h
random.$(OBJEXT): {$(VPATH)}internal/memory.h
random.$(OBJEXT): {$(VPATH)}internal/method.h
random.$(OBJEXT): {$(VPATH)}internal/module.h
random.$(OBJEXT): {$(VPATH)}internal/newobj.h
random.$(OBJEXT): {$(VPATH)}internal/rgengc.h
random.$(OBJEXT): {$(VPATH)}internal/scan_args.h
random.$(OBJEXT): {$(VPATH)}internal/special_consts.h
random.$(OBJEXT): {$(VPATH)}internal/static_assert.h
random.$(OBJEXT): {$(VPATH)}internal/stdalign.h
random.$(OBJEXT): {$(VPATH)}internal/stdbool.h
random.$(OBJEXT): {$(VPATH)}internal/symbol.h
random.$(OBJEXT): {$(VPATH)}internal/value.h
random.$(OBJEXT): {$(VPATH)}internal/value_type.h
random.$(OBJEXT): {$(VPATH)}internal/variable.h
random.$(OBJEXT): {$(VPATH)}internal/warning_push.h
random.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
random.$(OBJEXT): {$(VPATH)}missing.h
random.$(OBJEXT): {$(VPATH)}mt19937.c
random.$(OBJEXT): {$(VPATH)}ractor.h
random.$(OBJEXT): {$(VPATH)}random.c
random.$(OBJEXT): {$(VPATH)}random.h
random.$(OBJEXT): {$(VPATH)}ruby_atomic.h
random.$(OBJEXT): {$(VPATH)}shape.h
random.$(OBJEXT): {$(VPATH)}siphash.c
random.$(OBJEXT): {$(VPATH)}siphash.h
random.$(OBJEXT): {$(VPATH)}st.h
random.$(OBJEXT): {$(VPATH)}subst.h
range.$(OBJEXT): $(hdrdir)/ruby/ruby.h
range.$(OBJEXT): $(top_srcdir)/internal/array.h
range.$(OBJEXT): $(top_srcdir)/internal/bignum.h
range.$(OBJEXT): $(top_srcdir)/internal/bits.h
range.$(OBJEXT): $(top_srcdir)/internal/compar.h
range.$(OBJEXT): $(top_srcdir)/internal/compilers.h
range.$(OBJEXT): $(top_srcdir)/internal/enum.h
range.$(OBJEXT): $(top_srcdir)/internal/enumerator.h
range.$(OBJEXT): $(top_srcdir)/internal/error.h
range.$(OBJEXT): $(top_srcdir)/internal/fixnum.h
range.$(OBJEXT): $(top_srcdir)/internal/gc.h
range.$(OBJEXT): $(top_srcdir)/internal/numeric.h
range.$(OBJEXT): $(top_srcdir)/internal/range.h
range.$(OBJEXT): $(top_srcdir)/internal/serial.h
range.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
range.$(OBJEXT): $(top_srcdir)/internal/string.h
range.$(OBJEXT): $(top_srcdir)/internal/struct.h
range.$(OBJEXT): $(top_srcdir)/internal/vm.h
range.$(OBJEXT): $(top_srcdir)/internal/warnings.h
range.$(OBJEXT): {$(VPATH)}assert.h
range.$(OBJEXT): {$(VPATH)}backward/2/assume.h
range.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
range.$(OBJEXT): {$(VPATH)}backward/2/bool.h
range.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
range.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
range.$(OBJEXT): {$(VPATH)}backward/2/limits.h
range.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
range.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
range.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
range.$(OBJEXT): {$(VPATH)}config.h
range.$(OBJEXT): {$(VPATH)}defines.h
range.$(OBJEXT): {$(VPATH)}encoding.h
range.$(OBJEXT): {$(VPATH)}id.h
range.$(OBJEXT): {$(VPATH)}intern.h
range.$(OBJEXT): {$(VPATH)}internal.h
range.$(OBJEXT): {$(VPATH)}internal/abi.h
range.$(OBJEXT): {$(VPATH)}internal/anyargs.h
range.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
range.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
range.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
range.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
range.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
range.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
range.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
range.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
range.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
range.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
range.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
range.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
range.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
range.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
range.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
range.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
range.$(OBJEXT): {$(VPATH)}internal/assume.h
range.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
range.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
range.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
range.$(OBJEXT): {$(VPATH)}internal/attr/const.h
range.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
range.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
range.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
range.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
range.$(OBJEXT): {$(VPATH)}internal/attr/error.h
range.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
range.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
range.$(OBJEXT): {$(VPATH)}internal/attr/format.h
range.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
range.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
range.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
range.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
range.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
range.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
range.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
range.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
range.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
range.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
range.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
range.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
range.$(OBJEXT): {$(VPATH)}internal/cast.h
range.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
range.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
range.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
range.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
range.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
range.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
range.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
range.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
range.$(OBJEXT): {$(VPATH)}internal/config.h
range.$(OBJEXT): {$(VPATH)}internal/constant_p.h
range.$(OBJEXT): {$(VPATH)}internal/core.h
range.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
range.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
range.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
range.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
range.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
range.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
range.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
range.$(OBJEXT): {$(VPATH)}internal/core/robject.h
range.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
range.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
range.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
range.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
range.$(OBJEXT): {$(VPATH)}internal/ctype.h
range.$(OBJEXT): {$(VPATH)}internal/dllexport.h
range.$(OBJEXT): {$(VPATH)}internal/dosish.h
range.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
range.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
range.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
range.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
range.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
range.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
range.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
range.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
range.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
range.$(OBJEXT): {$(VPATH)}internal/error.h
range.$(OBJEXT): {$(VPATH)}internal/eval.h
range.$(OBJEXT): {$(VPATH)}internal/event.h
range.$(OBJEXT): {$(VPATH)}internal/fl_type.h
range.$(OBJEXT): {$(VPATH)}internal/gc.h
range.$(OBJEXT): {$(VPATH)}internal/glob.h
range.$(OBJEXT): {$(VPATH)}internal/globals.h
range.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
range.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
range.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
range.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
range.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
range.$(OBJEXT): {$(VPATH)}internal/has/extension.h
range.$(OBJEXT): {$(VPATH)}internal/has/feature.h
range.$(OBJEXT): {$(VPATH)}internal/has/warning.h
range.$(OBJEXT): {$(VPATH)}internal/intern/array.h
range.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
range.$(OBJEXT): {$(VPATH)}internal/intern/class.h
range.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
range.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
range.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
range.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
range.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
range.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
range.$(OBJEXT): {$(VPATH)}internal/intern/error.h
range.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
range.$(OBJEXT): {$(VPATH)}internal/intern/file.h
range.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
range.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
range.$(OBJEXT): {$(VPATH)}internal/intern/io.h
range.$(OBJEXT): {$(VPATH)}internal/intern/load.h
range.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
range.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
range.$(OBJEXT): {$(VPATH)}internal/intern/object.h
range.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
range.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
range.$(OBJEXT): {$(VPATH)}internal/intern/process.h
range.$(OBJEXT): {$(VPATH)}internal/intern/random.h
range.$(OBJEXT): {$(VPATH)}internal/intern/range.h
range.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
range.$(OBJEXT): {$(VPATH)}internal/intern/re.h
range.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
range.$(OBJEXT): {$(VPATH)}internal/intern/select.h
range.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
range.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
range.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
range.$(OBJEXT): {$(VPATH)}internal/intern/string.h
range.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
range.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
range.$(OBJEXT): {$(VPATH)}internal/intern/time.h
range.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
range.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
range.$(OBJEXT): {$(VPATH)}internal/interpreter.h
range.$(OBJEXT): {$(VPATH)}internal/iterator.h
range.$(OBJEXT): {$(VPATH)}internal/memory.h
range.$(OBJEXT): {$(VPATH)}internal/method.h
range.$(OBJEXT): {$(VPATH)}internal/module.h
range.$(OBJEXT): {$(VPATH)}internal/newobj.h
range.$(OBJEXT): {$(VPATH)}internal/rgengc.h
range.$(OBJEXT): {$(VPATH)}internal/scan_args.h
range.$(OBJEXT): {$(VPATH)}internal/special_consts.h
range.$(OBJEXT): {$(VPATH)}internal/static_assert.h
range.$(OBJEXT): {$(VPATH)}internal/stdalign.h
range.$(OBJEXT): {$(VPATH)}internal/stdbool.h
range.$(OBJEXT): {$(VPATH)}internal/symbol.h
range.$(OBJEXT): {$(VPATH)}internal/value.h
range.$(OBJEXT): {$(VPATH)}internal/value_type.h
range.$(OBJEXT): {$(VPATH)}internal/variable.h
range.$(OBJEXT): {$(VPATH)}internal/warning_push.h
range.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
range.$(OBJEXT): {$(VPATH)}missing.h
range.$(OBJEXT): {$(VPATH)}onigmo.h
range.$(OBJEXT): {$(VPATH)}oniguruma.h
range.$(OBJEXT): {$(VPATH)}range.c
range.$(OBJEXT): {$(VPATH)}shape.h
range.$(OBJEXT): {$(VPATH)}st.h
range.$(OBJEXT): {$(VPATH)}subst.h
rational.$(OBJEXT): $(hdrdir)/ruby/ruby.h
rational.$(OBJEXT): $(top_srcdir)/internal/array.h
rational.$(OBJEXT): $(top_srcdir)/internal/bignum.h
rational.$(OBJEXT): $(top_srcdir)/internal/bits.h
rational.$(OBJEXT): $(top_srcdir)/internal/class.h
rational.$(OBJEXT): $(top_srcdir)/internal/compilers.h
rational.$(OBJEXT): $(top_srcdir)/internal/complex.h
rational.$(OBJEXT): $(top_srcdir)/internal/fixnum.h
rational.$(OBJEXT): $(top_srcdir)/internal/gc.h
rational.$(OBJEXT): $(top_srcdir)/internal/numeric.h
rational.$(OBJEXT): $(top_srcdir)/internal/object.h
rational.$(OBJEXT): $(top_srcdir)/internal/rational.h
rational.$(OBJEXT): $(top_srcdir)/internal/serial.h
rational.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
rational.$(OBJEXT): $(top_srcdir)/internal/variable.h
rational.$(OBJEXT): $(top_srcdir)/internal/vm.h
rational.$(OBJEXT): $(top_srcdir)/internal/warnings.h
rational.$(OBJEXT): {$(VPATH)}assert.h
rational.$(OBJEXT): {$(VPATH)}backward/2/assume.h
rational.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
rational.$(OBJEXT): {$(VPATH)}backward/2/bool.h
rational.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
rational.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
rational.$(OBJEXT): {$(VPATH)}backward/2/limits.h
rational.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
rational.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
rational.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
rational.$(OBJEXT): {$(VPATH)}config.h
rational.$(OBJEXT): {$(VPATH)}constant.h
rational.$(OBJEXT): {$(VPATH)}defines.h
rational.$(OBJEXT): {$(VPATH)}id.h
rational.$(OBJEXT): {$(VPATH)}id_table.h
rational.$(OBJEXT): {$(VPATH)}intern.h
rational.$(OBJEXT): {$(VPATH)}internal.h
rational.$(OBJEXT): {$(VPATH)}internal/abi.h
rational.$(OBJEXT): {$(VPATH)}internal/anyargs.h
rational.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
rational.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
rational.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
rational.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
rational.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
rational.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
rational.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
rational.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
rational.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
rational.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
rational.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
rational.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
rational.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
rational.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
rational.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
rational.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
rational.$(OBJEXT): {$(VPATH)}internal/assume.h
rational.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
rational.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
rational.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
rational.$(OBJEXT): {$(VPATH)}internal/attr/const.h
rational.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
rational.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
rational.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
rational.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
rational.$(OBJEXT): {$(VPATH)}internal/attr/error.h
rational.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
rational.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
rational.$(OBJEXT): {$(VPATH)}internal/attr/format.h
rational.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
rational.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
rational.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
rational.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
rational.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
rational.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
rational.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
rational.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
rational.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
rational.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
rational.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
rational.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
rational.$(OBJEXT): {$(VPATH)}internal/cast.h
rational.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
rational.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
rational.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
rational.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
rational.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
rational.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
rational.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
rational.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
rational.$(OBJEXT): {$(VPATH)}internal/config.h
rational.$(OBJEXT): {$(VPATH)}internal/constant_p.h
rational.$(OBJEXT): {$(VPATH)}internal/core.h
rational.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
rational.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
rational.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
rational.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
rational.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
rational.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
rational.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
rational.$(OBJEXT): {$(VPATH)}internal/core/robject.h
rational.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
rational.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
rational.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
rational.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
rational.$(OBJEXT): {$(VPATH)}internal/ctype.h
rational.$(OBJEXT): {$(VPATH)}internal/dllexport.h
rational.$(OBJEXT): {$(VPATH)}internal/dosish.h
rational.$(OBJEXT): {$(VPATH)}internal/error.h
rational.$(OBJEXT): {$(VPATH)}internal/eval.h
rational.$(OBJEXT): {$(VPATH)}internal/event.h
rational.$(OBJEXT): {$(VPATH)}internal/fl_type.h
rational.$(OBJEXT): {$(VPATH)}internal/gc.h
rational.$(OBJEXT): {$(VPATH)}internal/glob.h
rational.$(OBJEXT): {$(VPATH)}internal/globals.h
rational.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
rational.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
rational.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
rational.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
rational.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
rational.$(OBJEXT): {$(VPATH)}internal/has/extension.h
rational.$(OBJEXT): {$(VPATH)}internal/has/feature.h
rational.$(OBJEXT): {$(VPATH)}internal/has/warning.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/array.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/class.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/error.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/file.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/io.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/load.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/object.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/process.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/random.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/range.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/re.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/select.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/string.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/time.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
rational.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
rational.$(OBJEXT): {$(VPATH)}internal/interpreter.h
rational.$(OBJEXT): {$(VPATH)}internal/iterator.h
rational.$(OBJEXT): {$(VPATH)}internal/memory.h
rational.$(OBJEXT): {$(VPATH)}internal/method.h
rational.$(OBJEXT): {$(VPATH)}internal/module.h
rational.$(OBJEXT): {$(VPATH)}internal/newobj.h
rational.$(OBJEXT): {$(VPATH)}internal/rgengc.h
rational.$(OBJEXT): {$(VPATH)}internal/scan_args.h
rational.$(OBJEXT): {$(VPATH)}internal/special_consts.h
rational.$(OBJEXT): {$(VPATH)}internal/static_assert.h
rational.$(OBJEXT): {$(VPATH)}internal/stdalign.h
rational.$(OBJEXT): {$(VPATH)}internal/stdbool.h
rational.$(OBJEXT): {$(VPATH)}internal/symbol.h
rational.$(OBJEXT): {$(VPATH)}internal/value.h
rational.$(OBJEXT): {$(VPATH)}internal/value_type.h
rational.$(OBJEXT): {$(VPATH)}internal/variable.h
rational.$(OBJEXT): {$(VPATH)}internal/warning_push.h
rational.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
rational.$(OBJEXT): {$(VPATH)}missing.h
rational.$(OBJEXT): {$(VPATH)}rational.c
rational.$(OBJEXT): {$(VPATH)}ruby_assert.h
rational.$(OBJEXT): {$(VPATH)}shape.h
rational.$(OBJEXT): {$(VPATH)}st.h
rational.$(OBJEXT): {$(VPATH)}subst.h
re.$(OBJEXT): $(hdrdir)/ruby.h
re.$(OBJEXT): $(hdrdir)/ruby/ruby.h
re.$(OBJEXT): $(top_srcdir)/internal/array.h
re.$(OBJEXT): $(top_srcdir)/internal/bits.h
re.$(OBJEXT): $(top_srcdir)/internal/class.h
re.$(OBJEXT): $(top_srcdir)/internal/compilers.h
re.$(OBJEXT): $(top_srcdir)/internal/encoding.h
re.$(OBJEXT): $(top_srcdir)/internal/gc.h
re.$(OBJEXT): $(top_srcdir)/internal/hash.h
re.$(OBJEXT): $(top_srcdir)/internal/imemo.h
re.$(OBJEXT): $(top_srcdir)/internal/object.h
re.$(OBJEXT): $(top_srcdir)/internal/ractor.h
re.$(OBJEXT): $(top_srcdir)/internal/re.h
re.$(OBJEXT): $(top_srcdir)/internal/serial.h
re.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
re.$(OBJEXT): $(top_srcdir)/internal/string.h
re.$(OBJEXT): $(top_srcdir)/internal/time.h
re.$(OBJEXT): $(top_srcdir)/internal/variable.h
re.$(OBJEXT): $(top_srcdir)/internal/warnings.h
re.$(OBJEXT): {$(VPATH)}assert.h
re.$(OBJEXT): {$(VPATH)}backward/2/assume.h
re.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
re.$(OBJEXT): {$(VPATH)}backward/2/bool.h
re.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
re.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
re.$(OBJEXT): {$(VPATH)}backward/2/limits.h
re.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
re.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
re.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
re.$(OBJEXT): {$(VPATH)}config.h
re.$(OBJEXT): {$(VPATH)}constant.h
re.$(OBJEXT): {$(VPATH)}defines.h
re.$(OBJEXT): {$(VPATH)}encindex.h
re.$(OBJEXT): {$(VPATH)}encoding.h
re.$(OBJEXT): {$(VPATH)}hrtime.h
re.$(OBJEXT): {$(VPATH)}id_table.h
re.$(OBJEXT): {$(VPATH)}intern.h
re.$(OBJEXT): {$(VPATH)}internal.h
re.$(OBJEXT): {$(VPATH)}internal/abi.h
re.$(OBJEXT): {$(VPATH)}internal/anyargs.h
re.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
re.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
re.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
re.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
re.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
re.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
re.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
re.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
re.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
re.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
re.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
re.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
re.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
re.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
re.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
re.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
re.$(OBJEXT): {$(VPATH)}internal/assume.h
re.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
re.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
re.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
re.$(OBJEXT): {$(VPATH)}internal/attr/const.h
re.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
re.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
re.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
re.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
re.$(OBJEXT): {$(VPATH)}internal/attr/error.h
re.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
re.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
re.$(OBJEXT): {$(VPATH)}internal/attr/format.h
re.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
re.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
re.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
re.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
re.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
re.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
re.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
re.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
re.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
re.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
re.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
re.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
re.$(OBJEXT): {$(VPATH)}internal/cast.h
re.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
re.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
re.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
re.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
re.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
re.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
re.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
re.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
re.$(OBJEXT): {$(VPATH)}internal/config.h
re.$(OBJEXT): {$(VPATH)}internal/constant_p.h
re.$(OBJEXT): {$(VPATH)}internal/core.h
re.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
re.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
re.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
re.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
re.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
re.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
re.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
re.$(OBJEXT): {$(VPATH)}internal/core/rmatch.h
re.$(OBJEXT): {$(VPATH)}internal/core/robject.h
re.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
re.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
re.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
re.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
re.$(OBJEXT): {$(VPATH)}internal/ctype.h
re.$(OBJEXT): {$(VPATH)}internal/dllexport.h
re.$(OBJEXT): {$(VPATH)}internal/dosish.h
re.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
re.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
re.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
re.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
re.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
re.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
re.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
re.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
re.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
re.$(OBJEXT): {$(VPATH)}internal/error.h
re.$(OBJEXT): {$(VPATH)}internal/eval.h
re.$(OBJEXT): {$(VPATH)}internal/event.h
re.$(OBJEXT): {$(VPATH)}internal/fl_type.h
re.$(OBJEXT): {$(VPATH)}internal/gc.h
re.$(OBJEXT): {$(VPATH)}internal/glob.h
re.$(OBJEXT): {$(VPATH)}internal/globals.h
re.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
re.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
re.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
re.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
re.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
re.$(OBJEXT): {$(VPATH)}internal/has/extension.h
re.$(OBJEXT): {$(VPATH)}internal/has/feature.h
re.$(OBJEXT): {$(VPATH)}internal/has/warning.h
re.$(OBJEXT): {$(VPATH)}internal/intern/array.h
re.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
re.$(OBJEXT): {$(VPATH)}internal/intern/class.h
re.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
re.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
re.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
re.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
re.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
re.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
re.$(OBJEXT): {$(VPATH)}internal/intern/error.h
re.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
re.$(OBJEXT): {$(VPATH)}internal/intern/file.h
re.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
re.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
re.$(OBJEXT): {$(VPATH)}internal/intern/io.h
re.$(OBJEXT): {$(VPATH)}internal/intern/load.h
re.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
re.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
re.$(OBJEXT): {$(VPATH)}internal/intern/object.h
re.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
re.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
re.$(OBJEXT): {$(VPATH)}internal/intern/process.h
re.$(OBJEXT): {$(VPATH)}internal/intern/random.h
re.$(OBJEXT): {$(VPATH)}internal/intern/range.h
re.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
re.$(OBJEXT): {$(VPATH)}internal/intern/re.h
re.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
re.$(OBJEXT): {$(VPATH)}internal/intern/select.h
re.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
re.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
re.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
re.$(OBJEXT): {$(VPATH)}internal/intern/string.h
re.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
re.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
re.$(OBJEXT): {$(VPATH)}internal/intern/time.h
re.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
re.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
re.$(OBJEXT): {$(VPATH)}internal/interpreter.h
re.$(OBJEXT): {$(VPATH)}internal/iterator.h
re.$(OBJEXT): {$(VPATH)}internal/memory.h
re.$(OBJEXT): {$(VPATH)}internal/method.h
re.$(OBJEXT): {$(VPATH)}internal/module.h
re.$(OBJEXT): {$(VPATH)}internal/newobj.h
re.$(OBJEXT): {$(VPATH)}internal/rgengc.h
re.$(OBJEXT): {$(VPATH)}internal/scan_args.h
re.$(OBJEXT): {$(VPATH)}internal/special_consts.h
re.$(OBJEXT): {$(VPATH)}internal/static_assert.h
re.$(OBJEXT): {$(VPATH)}internal/stdalign.h
re.$(OBJEXT): {$(VPATH)}internal/stdbool.h
re.$(OBJEXT): {$(VPATH)}internal/symbol.h
re.$(OBJEXT): {$(VPATH)}internal/value.h
re.$(OBJEXT): {$(VPATH)}internal/value_type.h
re.$(OBJEXT): {$(VPATH)}internal/variable.h
re.$(OBJEXT): {$(VPATH)}internal/warning_push.h
re.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
re.$(OBJEXT): {$(VPATH)}missing.h
re.$(OBJEXT): {$(VPATH)}onigmo.h
re.$(OBJEXT): {$(VPATH)}oniguruma.h
re.$(OBJEXT): {$(VPATH)}re.c
re.$(OBJEXT): {$(VPATH)}re.h
re.$(OBJEXT): {$(VPATH)}regenc.h
re.$(OBJEXT): {$(VPATH)}regex.h
re.$(OBJEXT): {$(VPATH)}regint.h
re.$(OBJEXT): {$(VPATH)}shape.h
re.$(OBJEXT): {$(VPATH)}st.h
re.$(OBJEXT): {$(VPATH)}subst.h
re.$(OBJEXT): {$(VPATH)}util.h
regcomp.$(OBJEXT): $(hdrdir)/ruby.h
regcomp.$(OBJEXT): $(hdrdir)/ruby/ruby.h
regcomp.$(OBJEXT): {$(VPATH)}assert.h
regcomp.$(OBJEXT): {$(VPATH)}backward/2/assume.h
regcomp.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
regcomp.$(OBJEXT): {$(VPATH)}backward/2/bool.h
regcomp.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
regcomp.$(OBJEXT): {$(VPATH)}backward/2/limits.h
regcomp.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
regcomp.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
regcomp.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
regcomp.$(OBJEXT): {$(VPATH)}config.h
regcomp.$(OBJEXT): {$(VPATH)}defines.h
regcomp.$(OBJEXT): {$(VPATH)}intern.h
regcomp.$(OBJEXT): {$(VPATH)}internal/abi.h
regcomp.$(OBJEXT): {$(VPATH)}internal/anyargs.h
regcomp.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
regcomp.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
regcomp.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
regcomp.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
regcomp.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
regcomp.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
regcomp.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
regcomp.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
regcomp.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
regcomp.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
regcomp.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
regcomp.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
regcomp.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
regcomp.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
regcomp.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
regcomp.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
regcomp.$(OBJEXT): {$(VPATH)}internal/assume.h
regcomp.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
regcomp.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
regcomp.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
regcomp.$(OBJEXT): {$(VPATH)}internal/attr/const.h
regcomp.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
regcomp.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
regcomp.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
regcomp.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
regcomp.$(OBJEXT): {$(VPATH)}internal/attr/error.h
regcomp.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
regcomp.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
regcomp.$(OBJEXT): {$(VPATH)}internal/attr/format.h
regcomp.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
regcomp.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
regcomp.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
regcomp.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
regcomp.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
regcomp.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
regcomp.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
regcomp.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
regcomp.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
regcomp.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
regcomp.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
regcomp.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
regcomp.$(OBJEXT): {$(VPATH)}internal/cast.h
regcomp.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
regcomp.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
regcomp.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
regcomp.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
regcomp.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
regcomp.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
regcomp.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
regcomp.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
regcomp.$(OBJEXT): {$(VPATH)}internal/config.h
regcomp.$(OBJEXT): {$(VPATH)}internal/constant_p.h
regcomp.$(OBJEXT): {$(VPATH)}internal/core.h
regcomp.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
regcomp.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
regcomp.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
regcomp.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
regcomp.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
regcomp.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
regcomp.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
regcomp.$(OBJEXT): {$(VPATH)}internal/core/robject.h
regcomp.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
regcomp.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
regcomp.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
regcomp.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
regcomp.$(OBJEXT): {$(VPATH)}internal/ctype.h
regcomp.$(OBJEXT): {$(VPATH)}internal/dllexport.h
regcomp.$(OBJEXT): {$(VPATH)}internal/dosish.h
regcomp.$(OBJEXT): {$(VPATH)}internal/error.h
regcomp.$(OBJEXT): {$(VPATH)}internal/eval.h
regcomp.$(OBJEXT): {$(VPATH)}internal/event.h
regcomp.$(OBJEXT): {$(VPATH)}internal/fl_type.h
regcomp.$(OBJEXT): {$(VPATH)}internal/gc.h
regcomp.$(OBJEXT): {$(VPATH)}internal/glob.h
regcomp.$(OBJEXT): {$(VPATH)}internal/globals.h
regcomp.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
regcomp.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
regcomp.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
regcomp.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
regcomp.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
regcomp.$(OBJEXT): {$(VPATH)}internal/has/extension.h
regcomp.$(OBJEXT): {$(VPATH)}internal/has/feature.h
regcomp.$(OBJEXT): {$(VPATH)}internal/has/warning.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/array.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/class.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/error.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/file.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/io.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/load.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/object.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/process.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/random.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/range.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/re.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/select.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/string.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/time.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
regcomp.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
regcomp.$(OBJEXT): {$(VPATH)}internal/interpreter.h
regcomp.$(OBJEXT): {$(VPATH)}internal/iterator.h
regcomp.$(OBJEXT): {$(VPATH)}internal/memory.h
regcomp.$(OBJEXT): {$(VPATH)}internal/method.h
regcomp.$(OBJEXT): {$(VPATH)}internal/module.h
regcomp.$(OBJEXT): {$(VPATH)}internal/newobj.h
regcomp.$(OBJEXT): {$(VPATH)}internal/rgengc.h
regcomp.$(OBJEXT): {$(VPATH)}internal/scan_args.h
regcomp.$(OBJEXT): {$(VPATH)}internal/special_consts.h
regcomp.$(OBJEXT): {$(VPATH)}internal/static_assert.h
regcomp.$(OBJEXT): {$(VPATH)}internal/stdalign.h
regcomp.$(OBJEXT): {$(VPATH)}internal/stdbool.h
regcomp.$(OBJEXT): {$(VPATH)}internal/symbol.h
regcomp.$(OBJEXT): {$(VPATH)}internal/value.h
regcomp.$(OBJEXT): {$(VPATH)}internal/value_type.h
regcomp.$(OBJEXT): {$(VPATH)}internal/variable.h
regcomp.$(OBJEXT): {$(VPATH)}internal/warning_push.h
regcomp.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
regcomp.$(OBJEXT): {$(VPATH)}missing.h
regcomp.$(OBJEXT): {$(VPATH)}onigmo.h
regcomp.$(OBJEXT): {$(VPATH)}regcomp.c
regcomp.$(OBJEXT): {$(VPATH)}regenc.h
regcomp.$(OBJEXT): {$(VPATH)}regint.h
regcomp.$(OBJEXT): {$(VPATH)}regparse.h
regcomp.$(OBJEXT): {$(VPATH)}st.h
regcomp.$(OBJEXT): {$(VPATH)}subst.h
regenc.$(OBJEXT): $(hdrdir)/ruby.h
regenc.$(OBJEXT): $(hdrdir)/ruby/ruby.h
regenc.$(OBJEXT): {$(VPATH)}assert.h
regenc.$(OBJEXT): {$(VPATH)}backward/2/assume.h
regenc.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
regenc.$(OBJEXT): {$(VPATH)}backward/2/bool.h
regenc.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
regenc.$(OBJEXT): {$(VPATH)}backward/2/limits.h
regenc.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
regenc.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
regenc.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
regenc.$(OBJEXT): {$(VPATH)}config.h
regenc.$(OBJEXT): {$(VPATH)}defines.h
regenc.$(OBJEXT): {$(VPATH)}intern.h
regenc.$(OBJEXT): {$(VPATH)}internal/abi.h
regenc.$(OBJEXT): {$(VPATH)}internal/anyargs.h
regenc.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
regenc.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
regenc.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
regenc.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
regenc.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
regenc.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
regenc.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
regenc.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
regenc.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
regenc.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
regenc.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
regenc.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
regenc.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
regenc.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
regenc.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
regenc.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
regenc.$(OBJEXT): {$(VPATH)}internal/assume.h
regenc.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
regenc.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
regenc.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
regenc.$(OBJEXT): {$(VPATH)}internal/attr/const.h
regenc.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
regenc.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
regenc.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
regenc.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
regenc.$(OBJEXT): {$(VPATH)}internal/attr/error.h
regenc.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
regenc.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
regenc.$(OBJEXT): {$(VPATH)}internal/attr/format.h
regenc.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
regenc.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
regenc.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
regenc.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
regenc.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
regenc.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
regenc.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
regenc.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
regenc.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
regenc.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
regenc.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
regenc.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
regenc.$(OBJEXT): {$(VPATH)}internal/cast.h
regenc.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
regenc.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
regenc.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
regenc.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
regenc.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
regenc.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
regenc.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
regenc.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
regenc.$(OBJEXT): {$(VPATH)}internal/config.h
regenc.$(OBJEXT): {$(VPATH)}internal/constant_p.h
regenc.$(OBJEXT): {$(VPATH)}internal/core.h
regenc.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
regenc.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
regenc.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
regenc.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
regenc.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
regenc.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
regenc.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
regenc.$(OBJEXT): {$(VPATH)}internal/core/robject.h
regenc.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
regenc.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
regenc.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
regenc.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
regenc.$(OBJEXT): {$(VPATH)}internal/ctype.h
regenc.$(OBJEXT): {$(VPATH)}internal/dllexport.h
regenc.$(OBJEXT): {$(VPATH)}internal/dosish.h
regenc.$(OBJEXT): {$(VPATH)}internal/error.h
regenc.$(OBJEXT): {$(VPATH)}internal/eval.h
regenc.$(OBJEXT): {$(VPATH)}internal/event.h
regenc.$(OBJEXT): {$(VPATH)}internal/fl_type.h
regenc.$(OBJEXT): {$(VPATH)}internal/gc.h
regenc.$(OBJEXT): {$(VPATH)}internal/glob.h
regenc.$(OBJEXT): {$(VPATH)}internal/globals.h
regenc.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
regenc.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
regenc.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
regenc.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
regenc.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
regenc.$(OBJEXT): {$(VPATH)}internal/has/extension.h
regenc.$(OBJEXT): {$(VPATH)}internal/has/feature.h
regenc.$(OBJEXT): {$(VPATH)}internal/has/warning.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/array.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/class.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/error.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/file.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/io.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/load.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/object.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/process.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/random.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/range.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/re.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/select.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/string.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/time.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
regenc.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
regenc.$(OBJEXT): {$(VPATH)}internal/interpreter.h
regenc.$(OBJEXT): {$(VPATH)}internal/iterator.h
regenc.$(OBJEXT): {$(VPATH)}internal/memory.h
regenc.$(OBJEXT): {$(VPATH)}internal/method.h
regenc.$(OBJEXT): {$(VPATH)}internal/module.h
regenc.$(OBJEXT): {$(VPATH)}internal/newobj.h
regenc.$(OBJEXT): {$(VPATH)}internal/rgengc.h
regenc.$(OBJEXT): {$(VPATH)}internal/scan_args.h
regenc.$(OBJEXT): {$(VPATH)}internal/special_consts.h
regenc.$(OBJEXT): {$(VPATH)}internal/static_assert.h
regenc.$(OBJEXT): {$(VPATH)}internal/stdalign.h
regenc.$(OBJEXT): {$(VPATH)}internal/stdbool.h
regenc.$(OBJEXT): {$(VPATH)}internal/symbol.h
regenc.$(OBJEXT): {$(VPATH)}internal/value.h
regenc.$(OBJEXT): {$(VPATH)}internal/value_type.h
regenc.$(OBJEXT): {$(VPATH)}internal/variable.h
regenc.$(OBJEXT): {$(VPATH)}internal/warning_push.h
regenc.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
regenc.$(OBJEXT): {$(VPATH)}missing.h
regenc.$(OBJEXT): {$(VPATH)}onigmo.h
regenc.$(OBJEXT): {$(VPATH)}regenc.c
regenc.$(OBJEXT): {$(VPATH)}regenc.h
regenc.$(OBJEXT): {$(VPATH)}regint.h
regenc.$(OBJEXT): {$(VPATH)}st.h
regenc.$(OBJEXT): {$(VPATH)}subst.h
regerror.$(OBJEXT): $(hdrdir)/ruby.h
regerror.$(OBJEXT): $(hdrdir)/ruby/ruby.h
regerror.$(OBJEXT): {$(VPATH)}assert.h
regerror.$(OBJEXT): {$(VPATH)}backward/2/assume.h
regerror.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
regerror.$(OBJEXT): {$(VPATH)}backward/2/bool.h
regerror.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
regerror.$(OBJEXT): {$(VPATH)}backward/2/limits.h
regerror.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
regerror.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
regerror.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
regerror.$(OBJEXT): {$(VPATH)}config.h
regerror.$(OBJEXT): {$(VPATH)}defines.h
regerror.$(OBJEXT): {$(VPATH)}intern.h
regerror.$(OBJEXT): {$(VPATH)}internal/abi.h
regerror.$(OBJEXT): {$(VPATH)}internal/anyargs.h
regerror.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
regerror.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
regerror.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
regerror.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
regerror.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
regerror.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
regerror.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
regerror.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
regerror.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
regerror.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
regerror.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
regerror.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
regerror.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
regerror.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
regerror.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
regerror.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
regerror.$(OBJEXT): {$(VPATH)}internal/assume.h
regerror.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
regerror.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
regerror.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
regerror.$(OBJEXT): {$(VPATH)}internal/attr/const.h
regerror.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
regerror.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
regerror.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
regerror.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
regerror.$(OBJEXT): {$(VPATH)}internal/attr/error.h
regerror.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
regerror.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
regerror.$(OBJEXT): {$(VPATH)}internal/attr/format.h
regerror.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
regerror.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
regerror.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
regerror.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
regerror.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
regerror.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
regerror.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
regerror.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
regerror.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
regerror.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
regerror.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
regerror.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
regerror.$(OBJEXT): {$(VPATH)}internal/cast.h
regerror.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
regerror.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
regerror.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
regerror.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
regerror.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
regerror.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
regerror.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
regerror.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
regerror.$(OBJEXT): {$(VPATH)}internal/config.h
regerror.$(OBJEXT): {$(VPATH)}internal/constant_p.h
regerror.$(OBJEXT): {$(VPATH)}internal/core.h
regerror.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
regerror.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
regerror.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
regerror.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
regerror.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
regerror.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
regerror.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
regerror.$(OBJEXT): {$(VPATH)}internal/core/robject.h
regerror.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
regerror.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
regerror.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
regerror.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
regerror.$(OBJEXT): {$(VPATH)}internal/ctype.h
regerror.$(OBJEXT): {$(VPATH)}internal/dllexport.h
regerror.$(OBJEXT): {$(VPATH)}internal/dosish.h
regerror.$(OBJEXT): {$(VPATH)}internal/error.h
regerror.$(OBJEXT): {$(VPATH)}internal/eval.h
regerror.$(OBJEXT): {$(VPATH)}internal/event.h
regerror.$(OBJEXT): {$(VPATH)}internal/fl_type.h
regerror.$(OBJEXT): {$(VPATH)}internal/gc.h
regerror.$(OBJEXT): {$(VPATH)}internal/glob.h
regerror.$(OBJEXT): {$(VPATH)}internal/globals.h
regerror.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
regerror.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
regerror.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
regerror.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
regerror.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
regerror.$(OBJEXT): {$(VPATH)}internal/has/extension.h
regerror.$(OBJEXT): {$(VPATH)}internal/has/feature.h
regerror.$(OBJEXT): {$(VPATH)}internal/has/warning.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/array.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/class.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/error.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/file.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/io.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/load.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/object.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/process.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/random.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/range.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/re.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/select.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/string.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/time.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
regerror.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
regerror.$(OBJEXT): {$(VPATH)}internal/interpreter.h
regerror.$(OBJEXT): {$(VPATH)}internal/iterator.h
regerror.$(OBJEXT): {$(VPATH)}internal/memory.h
regerror.$(OBJEXT): {$(VPATH)}internal/method.h
regerror.$(OBJEXT): {$(VPATH)}internal/module.h
regerror.$(OBJEXT): {$(VPATH)}internal/newobj.h
regerror.$(OBJEXT): {$(VPATH)}internal/rgengc.h
regerror.$(OBJEXT): {$(VPATH)}internal/scan_args.h
regerror.$(OBJEXT): {$(VPATH)}internal/special_consts.h
regerror.$(OBJEXT): {$(VPATH)}internal/static_assert.h
regerror.$(OBJEXT): {$(VPATH)}internal/stdalign.h
regerror.$(OBJEXT): {$(VPATH)}internal/stdbool.h
regerror.$(OBJEXT): {$(VPATH)}internal/symbol.h
regerror.$(OBJEXT): {$(VPATH)}internal/value.h
regerror.$(OBJEXT): {$(VPATH)}internal/value_type.h
regerror.$(OBJEXT): {$(VPATH)}internal/variable.h
regerror.$(OBJEXT): {$(VPATH)}internal/warning_push.h
regerror.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
regerror.$(OBJEXT): {$(VPATH)}missing.h
regerror.$(OBJEXT): {$(VPATH)}onigmo.h
regerror.$(OBJEXT): {$(VPATH)}regenc.h
regerror.$(OBJEXT): {$(VPATH)}regerror.c
regerror.$(OBJEXT): {$(VPATH)}regint.h
regerror.$(OBJEXT): {$(VPATH)}st.h
regerror.$(OBJEXT): {$(VPATH)}subst.h
regexec.$(OBJEXT): $(hdrdir)/ruby.h
regexec.$(OBJEXT): $(hdrdir)/ruby/ruby.h
regexec.$(OBJEXT): {$(VPATH)}assert.h
regexec.$(OBJEXT): {$(VPATH)}backward/2/assume.h
regexec.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
regexec.$(OBJEXT): {$(VPATH)}backward/2/bool.h
regexec.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
regexec.$(OBJEXT): {$(VPATH)}backward/2/limits.h
regexec.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
regexec.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
regexec.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
regexec.$(OBJEXT): {$(VPATH)}config.h
regexec.$(OBJEXT): {$(VPATH)}defines.h
regexec.$(OBJEXT): {$(VPATH)}intern.h
regexec.$(OBJEXT): {$(VPATH)}internal/abi.h
regexec.$(OBJEXT): {$(VPATH)}internal/anyargs.h
regexec.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
regexec.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
regexec.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
regexec.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
regexec.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
regexec.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
regexec.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
regexec.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
regexec.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
regexec.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
regexec.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
regexec.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
regexec.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
regexec.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
regexec.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
regexec.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
regexec.$(OBJEXT): {$(VPATH)}internal/assume.h
regexec.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
regexec.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
regexec.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
regexec.$(OBJEXT): {$(VPATH)}internal/attr/const.h
regexec.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
regexec.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
regexec.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
regexec.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
regexec.$(OBJEXT): {$(VPATH)}internal/attr/error.h
regexec.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
regexec.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
regexec.$(OBJEXT): {$(VPATH)}internal/attr/format.h
regexec.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
regexec.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
regexec.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
regexec.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
regexec.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
regexec.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
regexec.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
regexec.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
regexec.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
regexec.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
regexec.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
regexec.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
regexec.$(OBJEXT): {$(VPATH)}internal/cast.h
regexec.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
regexec.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
regexec.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
regexec.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
regexec.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
regexec.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
regexec.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
regexec.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
regexec.$(OBJEXT): {$(VPATH)}internal/config.h
regexec.$(OBJEXT): {$(VPATH)}internal/constant_p.h
regexec.$(OBJEXT): {$(VPATH)}internal/core.h
regexec.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
regexec.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
regexec.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
regexec.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
regexec.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
regexec.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
regexec.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
regexec.$(OBJEXT): {$(VPATH)}internal/core/robject.h
regexec.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
regexec.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
regexec.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
regexec.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
regexec.$(OBJEXT): {$(VPATH)}internal/ctype.h
regexec.$(OBJEXT): {$(VPATH)}internal/dllexport.h
regexec.$(OBJEXT): {$(VPATH)}internal/dosish.h
regexec.$(OBJEXT): {$(VPATH)}internal/error.h
regexec.$(OBJEXT): {$(VPATH)}internal/eval.h
regexec.$(OBJEXT): {$(VPATH)}internal/event.h
regexec.$(OBJEXT): {$(VPATH)}internal/fl_type.h
regexec.$(OBJEXT): {$(VPATH)}internal/gc.h
regexec.$(OBJEXT): {$(VPATH)}internal/glob.h
regexec.$(OBJEXT): {$(VPATH)}internal/globals.h
regexec.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
regexec.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
regexec.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
regexec.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
regexec.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
regexec.$(OBJEXT): {$(VPATH)}internal/has/extension.h
regexec.$(OBJEXT): {$(VPATH)}internal/has/feature.h
regexec.$(OBJEXT): {$(VPATH)}internal/has/warning.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/array.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/class.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/error.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/file.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/io.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/load.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/object.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/process.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/random.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/range.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/re.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/select.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/string.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/time.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
regexec.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
regexec.$(OBJEXT): {$(VPATH)}internal/interpreter.h
regexec.$(OBJEXT): {$(VPATH)}internal/iterator.h
regexec.$(OBJEXT): {$(VPATH)}internal/memory.h
regexec.$(OBJEXT): {$(VPATH)}internal/method.h
regexec.$(OBJEXT): {$(VPATH)}internal/module.h
regexec.$(OBJEXT): {$(VPATH)}internal/newobj.h
regexec.$(OBJEXT): {$(VPATH)}internal/rgengc.h
regexec.$(OBJEXT): {$(VPATH)}internal/scan_args.h
regexec.$(OBJEXT): {$(VPATH)}internal/special_consts.h
regexec.$(OBJEXT): {$(VPATH)}internal/static_assert.h
regexec.$(OBJEXT): {$(VPATH)}internal/stdalign.h
regexec.$(OBJEXT): {$(VPATH)}internal/stdbool.h
regexec.$(OBJEXT): {$(VPATH)}internal/symbol.h
regexec.$(OBJEXT): {$(VPATH)}internal/value.h
regexec.$(OBJEXT): {$(VPATH)}internal/value_type.h
regexec.$(OBJEXT): {$(VPATH)}internal/variable.h
regexec.$(OBJEXT): {$(VPATH)}internal/warning_push.h
regexec.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
regexec.$(OBJEXT): {$(VPATH)}missing.h
regexec.$(OBJEXT): {$(VPATH)}onigmo.h
regexec.$(OBJEXT): {$(VPATH)}regenc.h
regexec.$(OBJEXT): {$(VPATH)}regexec.c
regexec.$(OBJEXT): {$(VPATH)}regint.h
regexec.$(OBJEXT): {$(VPATH)}st.h
regexec.$(OBJEXT): {$(VPATH)}subst.h
regparse.$(OBJEXT): $(hdrdir)/ruby.h
regparse.$(OBJEXT): $(hdrdir)/ruby/ruby.h
regparse.$(OBJEXT): $(top_srcdir)/internal/compilers.h
regparse.$(OBJEXT): $(top_srcdir)/internal/sanitizers.h
regparse.$(OBJEXT): $(top_srcdir)/internal/warnings.h
regparse.$(OBJEXT): {$(VPATH)}assert.h
regparse.$(OBJEXT): {$(VPATH)}backward/2/assume.h
regparse.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
regparse.$(OBJEXT): {$(VPATH)}backward/2/bool.h
regparse.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
regparse.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
regparse.$(OBJEXT): {$(VPATH)}backward/2/limits.h
regparse.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
regparse.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
regparse.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
regparse.$(OBJEXT): {$(VPATH)}config.h
regparse.$(OBJEXT): {$(VPATH)}defines.h
regparse.$(OBJEXT): {$(VPATH)}intern.h
regparse.$(OBJEXT): {$(VPATH)}internal/abi.h
regparse.$(OBJEXT): {$(VPATH)}internal/anyargs.h
regparse.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
regparse.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
regparse.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
regparse.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
regparse.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
regparse.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
regparse.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
regparse.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
regparse.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
regparse.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
regparse.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
regparse.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
regparse.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
regparse.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
regparse.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
regparse.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
regparse.$(OBJEXT): {$(VPATH)}internal/assume.h
regparse.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
regparse.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
regparse.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
regparse.$(OBJEXT): {$(VPATH)}internal/attr/const.h
regparse.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
regparse.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
regparse.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
regparse.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
regparse.$(OBJEXT): {$(VPATH)}internal/attr/error.h
regparse.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
regparse.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
regparse.$(OBJEXT): {$(VPATH)}internal/attr/format.h
regparse.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
regparse.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
regparse.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
regparse.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
regparse.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
regparse.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
regparse.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
regparse.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
regparse.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
regparse.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
regparse.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
regparse.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
regparse.$(OBJEXT): {$(VPATH)}internal/cast.h
regparse.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
regparse.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
regparse.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
regparse.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
regparse.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
regparse.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
regparse.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
regparse.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
regparse.$(OBJEXT): {$(VPATH)}internal/config.h
regparse.$(OBJEXT): {$(VPATH)}internal/constant_p.h
regparse.$(OBJEXT): {$(VPATH)}internal/core.h
regparse.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
regparse.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
regparse.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
regparse.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
regparse.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
regparse.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
regparse.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
regparse.$(OBJEXT): {$(VPATH)}internal/core/robject.h
regparse.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
regparse.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
regparse.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
regparse.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
regparse.$(OBJEXT): {$(VPATH)}internal/ctype.h
regparse.$(OBJEXT): {$(VPATH)}internal/dllexport.h
regparse.$(OBJEXT): {$(VPATH)}internal/dosish.h
regparse.$(OBJEXT): {$(VPATH)}internal/error.h
regparse.$(OBJEXT): {$(VPATH)}internal/eval.h
regparse.$(OBJEXT): {$(VPATH)}internal/event.h
regparse.$(OBJEXT): {$(VPATH)}internal/fl_type.h
regparse.$(OBJEXT): {$(VPATH)}internal/gc.h
regparse.$(OBJEXT): {$(VPATH)}internal/glob.h
regparse.$(OBJEXT): {$(VPATH)}internal/globals.h
regparse.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
regparse.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
regparse.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
regparse.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
regparse.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
regparse.$(OBJEXT): {$(VPATH)}internal/has/extension.h
regparse.$(OBJEXT): {$(VPATH)}internal/has/feature.h
regparse.$(OBJEXT): {$(VPATH)}internal/has/warning.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/array.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/class.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/error.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/file.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/io.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/load.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/object.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/process.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/random.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/range.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/re.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/select.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/string.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/time.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
regparse.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
regparse.$(OBJEXT): {$(VPATH)}internal/interpreter.h
regparse.$(OBJEXT): {$(VPATH)}internal/iterator.h
regparse.$(OBJEXT): {$(VPATH)}internal/memory.h
regparse.$(OBJEXT): {$(VPATH)}internal/method.h
regparse.$(OBJEXT): {$(VPATH)}internal/module.h
regparse.$(OBJEXT): {$(VPATH)}internal/newobj.h
regparse.$(OBJEXT): {$(VPATH)}internal/rgengc.h
regparse.$(OBJEXT): {$(VPATH)}internal/scan_args.h
regparse.$(OBJEXT): {$(VPATH)}internal/special_consts.h
regparse.$(OBJEXT): {$(VPATH)}internal/static_assert.h
regparse.$(OBJEXT): {$(VPATH)}internal/stdalign.h
regparse.$(OBJEXT): {$(VPATH)}internal/stdbool.h
regparse.$(OBJEXT): {$(VPATH)}internal/symbol.h
regparse.$(OBJEXT): {$(VPATH)}internal/value.h
regparse.$(OBJEXT): {$(VPATH)}internal/value_type.h
regparse.$(OBJEXT): {$(VPATH)}internal/variable.h
regparse.$(OBJEXT): {$(VPATH)}internal/warning_push.h
regparse.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
regparse.$(OBJEXT): {$(VPATH)}missing.h
regparse.$(OBJEXT): {$(VPATH)}onigmo.h
regparse.$(OBJEXT): {$(VPATH)}regenc.h
regparse.$(OBJEXT): {$(VPATH)}regint.h
regparse.$(OBJEXT): {$(VPATH)}regparse.c
regparse.$(OBJEXT): {$(VPATH)}regparse.h
regparse.$(OBJEXT): {$(VPATH)}st.h
regparse.$(OBJEXT): {$(VPATH)}subst.h
regsyntax.$(OBJEXT): $(hdrdir)/ruby.h
regsyntax.$(OBJEXT): $(hdrdir)/ruby/ruby.h
regsyntax.$(OBJEXT): {$(VPATH)}assert.h
regsyntax.$(OBJEXT): {$(VPATH)}backward/2/assume.h
regsyntax.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
regsyntax.$(OBJEXT): {$(VPATH)}backward/2/bool.h
regsyntax.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
regsyntax.$(OBJEXT): {$(VPATH)}backward/2/limits.h
regsyntax.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
regsyntax.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
regsyntax.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
regsyntax.$(OBJEXT): {$(VPATH)}config.h
regsyntax.$(OBJEXT): {$(VPATH)}defines.h
regsyntax.$(OBJEXT): {$(VPATH)}intern.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/abi.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/anyargs.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/assume.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/attr/const.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/attr/error.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/attr/format.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/cast.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/config.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/constant_p.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/core.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/core/robject.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/ctype.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/dllexport.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/dosish.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/error.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/eval.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/event.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/fl_type.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/gc.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/glob.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/globals.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/has/extension.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/has/feature.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/has/warning.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/array.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/class.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/error.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/file.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/io.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/load.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/object.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/process.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/random.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/range.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/re.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/select.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/string.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/time.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/interpreter.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/iterator.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/memory.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/method.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/module.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/newobj.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/rgengc.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/scan_args.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/special_consts.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/static_assert.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/stdalign.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/stdbool.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/symbol.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/value.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/value_type.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/variable.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/warning_push.h
regsyntax.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
regsyntax.$(OBJEXT): {$(VPATH)}missing.h
regsyntax.$(OBJEXT): {$(VPATH)}onigmo.h
regsyntax.$(OBJEXT): {$(VPATH)}regenc.h
regsyntax.$(OBJEXT): {$(VPATH)}regint.h
regsyntax.$(OBJEXT): {$(VPATH)}regsyntax.c
regsyntax.$(OBJEXT): {$(VPATH)}st.h
regsyntax.$(OBJEXT): {$(VPATH)}subst.h
ruby-runner.$(OBJEXT): {$(VPATH)}config.h
ruby-runner.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
ruby-runner.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
ruby-runner.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
ruby-runner.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
ruby-runner.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
ruby-runner.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
ruby-runner.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
ruby-runner.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
ruby-runner.$(OBJEXT): {$(VPATH)}internal/config.h
ruby-runner.$(OBJEXT): {$(VPATH)}ruby-runner.c
ruby-runner.$(OBJEXT): {$(VPATH)}ruby-runner.h
ruby.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
ruby.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
ruby.$(OBJEXT): $(CCAN_DIR)/list/list.h
ruby.$(OBJEXT): $(CCAN_DIR)/str/str.h
ruby.$(OBJEXT): $(hdrdir)/ruby.h
ruby.$(OBJEXT): $(hdrdir)/ruby/ruby.h
ruby.$(OBJEXT): $(hdrdir)/ruby/version.h
ruby.$(OBJEXT): $(top_srcdir)/internal/array.h
ruby.$(OBJEXT): $(top_srcdir)/internal/class.h
ruby.$(OBJEXT): $(top_srcdir)/internal/cmdlineopt.h
ruby.$(OBJEXT): $(top_srcdir)/internal/compilers.h
ruby.$(OBJEXT): $(top_srcdir)/internal/cont.h
ruby.$(OBJEXT): $(top_srcdir)/internal/error.h
ruby.$(OBJEXT): $(top_srcdir)/internal/file.h
ruby.$(OBJEXT): $(top_srcdir)/internal/gc.h
ruby.$(OBJEXT): $(top_srcdir)/internal/imemo.h
ruby.$(OBJEXT): $(top_srcdir)/internal/inits.h
ruby.$(OBJEXT): $(top_srcdir)/internal/io.h
ruby.$(OBJEXT): $(top_srcdir)/internal/load.h
ruby.$(OBJEXT): $(top_srcdir)/internal/loadpath.h
ruby.$(OBJEXT): $(top_srcdir)/internal/missing.h
ruby.$(OBJEXT): $(top_srcdir)/internal/object.h
ruby.$(OBJEXT): $(top_srcdir)/internal/parse.h
ruby.$(OBJEXT): $(top_srcdir)/internal/process.h
ruby.$(OBJEXT): $(top_srcdir)/internal/serial.h
ruby.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
ruby.$(OBJEXT): $(top_srcdir)/internal/string.h
ruby.$(OBJEXT): $(top_srcdir)/internal/variable.h
ruby.$(OBJEXT): $(top_srcdir)/internal/vm.h
ruby.$(OBJEXT): $(top_srcdir)/internal/warnings.h
ruby.$(OBJEXT): {$(VPATH)}assert.h
ruby.$(OBJEXT): {$(VPATH)}atomic.h
ruby.$(OBJEXT): {$(VPATH)}backward/2/assume.h
ruby.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
ruby.$(OBJEXT): {$(VPATH)}backward/2/bool.h
ruby.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
ruby.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
ruby.$(OBJEXT): {$(VPATH)}backward/2/limits.h
ruby.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
ruby.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
ruby.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
ruby.$(OBJEXT): {$(VPATH)}config.h
ruby.$(OBJEXT): {$(VPATH)}constant.h
ruby.$(OBJEXT): {$(VPATH)}debug_counter.h
ruby.$(OBJEXT): {$(VPATH)}defines.h
ruby.$(OBJEXT): {$(VPATH)}dln.h
ruby.$(OBJEXT): {$(VPATH)}encoding.h
ruby.$(OBJEXT): {$(VPATH)}eval_intern.h
ruby.$(OBJEXT): {$(VPATH)}id.h
ruby.$(OBJEXT): {$(VPATH)}id_table.h
ruby.$(OBJEXT): {$(VPATH)}intern.h
ruby.$(OBJEXT): {$(VPATH)}internal.h
ruby.$(OBJEXT): {$(VPATH)}internal/abi.h
ruby.$(OBJEXT): {$(VPATH)}internal/anyargs.h
ruby.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
ruby.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
ruby.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
ruby.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
ruby.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
ruby.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
ruby.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
ruby.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
ruby.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
ruby.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
ruby.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
ruby.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
ruby.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
ruby.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
ruby.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
ruby.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
ruby.$(OBJEXT): {$(VPATH)}internal/assume.h
ruby.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
ruby.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
ruby.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
ruby.$(OBJEXT): {$(VPATH)}internal/attr/const.h
ruby.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
ruby.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
ruby.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
ruby.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
ruby.$(OBJEXT): {$(VPATH)}internal/attr/error.h
ruby.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
ruby.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
ruby.$(OBJEXT): {$(VPATH)}internal/attr/format.h
ruby.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
ruby.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
ruby.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
ruby.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
ruby.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
ruby.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
ruby.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
ruby.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
ruby.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
ruby.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
ruby.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
ruby.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
ruby.$(OBJEXT): {$(VPATH)}internal/cast.h
ruby.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
ruby.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
ruby.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
ruby.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
ruby.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
ruby.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
ruby.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
ruby.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
ruby.$(OBJEXT): {$(VPATH)}internal/config.h
ruby.$(OBJEXT): {$(VPATH)}internal/constant_p.h
ruby.$(OBJEXT): {$(VPATH)}internal/core.h
ruby.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
ruby.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
ruby.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
ruby.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
ruby.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
ruby.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
ruby.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
ruby.$(OBJEXT): {$(VPATH)}internal/core/robject.h
ruby.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
ruby.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
ruby.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
ruby.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
ruby.$(OBJEXT): {$(VPATH)}internal/ctype.h
ruby.$(OBJEXT): {$(VPATH)}internal/dllexport.h
ruby.$(OBJEXT): {$(VPATH)}internal/dosish.h
ruby.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
ruby.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
ruby.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
ruby.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
ruby.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
ruby.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
ruby.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
ruby.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
ruby.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
ruby.$(OBJEXT): {$(VPATH)}internal/error.h
ruby.$(OBJEXT): {$(VPATH)}internal/eval.h
ruby.$(OBJEXT): {$(VPATH)}internal/event.h
ruby.$(OBJEXT): {$(VPATH)}internal/fl_type.h
ruby.$(OBJEXT): {$(VPATH)}internal/gc.h
ruby.$(OBJEXT): {$(VPATH)}internal/glob.h
ruby.$(OBJEXT): {$(VPATH)}internal/globals.h
ruby.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
ruby.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
ruby.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
ruby.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
ruby.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
ruby.$(OBJEXT): {$(VPATH)}internal/has/extension.h
ruby.$(OBJEXT): {$(VPATH)}internal/has/feature.h
ruby.$(OBJEXT): {$(VPATH)}internal/has/warning.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/array.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/class.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/error.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/file.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/io.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/load.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/object.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/process.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/random.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/range.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/re.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/select.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/string.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/time.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
ruby.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
ruby.$(OBJEXT): {$(VPATH)}internal/interpreter.h
ruby.$(OBJEXT): {$(VPATH)}internal/iterator.h
ruby.$(OBJEXT): {$(VPATH)}internal/memory.h
ruby.$(OBJEXT): {$(VPATH)}internal/method.h
ruby.$(OBJEXT): {$(VPATH)}internal/module.h
ruby.$(OBJEXT): {$(VPATH)}internal/newobj.h
ruby.$(OBJEXT): {$(VPATH)}internal/rgengc.h
ruby.$(OBJEXT): {$(VPATH)}internal/scan_args.h
ruby.$(OBJEXT): {$(VPATH)}internal/special_consts.h
ruby.$(OBJEXT): {$(VPATH)}internal/static_assert.h
ruby.$(OBJEXT): {$(VPATH)}internal/stdalign.h
ruby.$(OBJEXT): {$(VPATH)}internal/stdbool.h
ruby.$(OBJEXT): {$(VPATH)}internal/symbol.h
ruby.$(OBJEXT): {$(VPATH)}internal/value.h
ruby.$(OBJEXT): {$(VPATH)}internal/value_type.h
ruby.$(OBJEXT): {$(VPATH)}internal/variable.h
ruby.$(OBJEXT): {$(VPATH)}internal/warning_push.h
ruby.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
ruby.$(OBJEXT): {$(VPATH)}io.h
ruby.$(OBJEXT): {$(VPATH)}iseq.h
ruby.$(OBJEXT): {$(VPATH)}method.h
ruby.$(OBJEXT): {$(VPATH)}missing.h
ruby.$(OBJEXT): {$(VPATH)}mjit.h
ruby.$(OBJEXT): {$(VPATH)}node.h
ruby.$(OBJEXT): {$(VPATH)}onigmo.h
ruby.$(OBJEXT): {$(VPATH)}oniguruma.h
ruby.$(OBJEXT): {$(VPATH)}ruby.c
ruby.$(OBJEXT): {$(VPATH)}ruby_assert.h
ruby.$(OBJEXT): {$(VPATH)}ruby_atomic.h
ruby.$(OBJEXT): {$(VPATH)}shape.h
ruby.$(OBJEXT): {$(VPATH)}st.h
ruby.$(OBJEXT): {$(VPATH)}subst.h
ruby.$(OBJEXT): {$(VPATH)}thread.h
ruby.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
ruby.$(OBJEXT): {$(VPATH)}thread_native.h
ruby.$(OBJEXT): {$(VPATH)}util.h
ruby.$(OBJEXT): {$(VPATH)}vm_core.h
ruby.$(OBJEXT): {$(VPATH)}vm_opts.h
ruby.$(OBJEXT): {$(VPATH)}yjit.h
scheduler.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
scheduler.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
scheduler.$(OBJEXT): $(CCAN_DIR)/list/list.h
scheduler.$(OBJEXT): $(CCAN_DIR)/str/str.h
scheduler.$(OBJEXT): $(hdrdir)/ruby/ruby.h
scheduler.$(OBJEXT): $(top_srcdir)/internal/array.h
scheduler.$(OBJEXT): $(top_srcdir)/internal/compilers.h
scheduler.$(OBJEXT): $(top_srcdir)/internal/gc.h
scheduler.$(OBJEXT): $(top_srcdir)/internal/imemo.h
scheduler.$(OBJEXT): $(top_srcdir)/internal/serial.h
scheduler.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
scheduler.$(OBJEXT): $(top_srcdir)/internal/thread.h
scheduler.$(OBJEXT): $(top_srcdir)/internal/variable.h
scheduler.$(OBJEXT): $(top_srcdir)/internal/vm.h
scheduler.$(OBJEXT): $(top_srcdir)/internal/warnings.h
scheduler.$(OBJEXT): {$(VPATH)}assert.h
scheduler.$(OBJEXT): {$(VPATH)}atomic.h
scheduler.$(OBJEXT): {$(VPATH)}backward/2/assume.h
scheduler.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
scheduler.$(OBJEXT): {$(VPATH)}backward/2/bool.h
scheduler.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
scheduler.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
scheduler.$(OBJEXT): {$(VPATH)}backward/2/limits.h
scheduler.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
scheduler.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
scheduler.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
scheduler.$(OBJEXT): {$(VPATH)}config.h
scheduler.$(OBJEXT): {$(VPATH)}constant.h
scheduler.$(OBJEXT): {$(VPATH)}defines.h
scheduler.$(OBJEXT): {$(VPATH)}encoding.h
scheduler.$(OBJEXT): {$(VPATH)}fiber/scheduler.h
scheduler.$(OBJEXT): {$(VPATH)}id.h
scheduler.$(OBJEXT): {$(VPATH)}id_table.h
scheduler.$(OBJEXT): {$(VPATH)}intern.h
scheduler.$(OBJEXT): {$(VPATH)}internal.h
scheduler.$(OBJEXT): {$(VPATH)}internal/abi.h
scheduler.$(OBJEXT): {$(VPATH)}internal/anyargs.h
scheduler.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
scheduler.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
scheduler.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
scheduler.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
scheduler.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
scheduler.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
scheduler.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
scheduler.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
scheduler.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
scheduler.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
scheduler.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
scheduler.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
scheduler.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
scheduler.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
scheduler.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
scheduler.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
scheduler.$(OBJEXT): {$(VPATH)}internal/assume.h
scheduler.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
scheduler.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
scheduler.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
scheduler.$(OBJEXT): {$(VPATH)}internal/attr/const.h
scheduler.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
scheduler.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
scheduler.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
scheduler.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
scheduler.$(OBJEXT): {$(VPATH)}internal/attr/error.h
scheduler.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
scheduler.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
scheduler.$(OBJEXT): {$(VPATH)}internal/attr/format.h
scheduler.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
scheduler.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
scheduler.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
scheduler.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
scheduler.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
scheduler.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
scheduler.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
scheduler.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
scheduler.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
scheduler.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
scheduler.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
scheduler.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
scheduler.$(OBJEXT): {$(VPATH)}internal/cast.h
scheduler.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
scheduler.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
scheduler.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
scheduler.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
scheduler.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
scheduler.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
scheduler.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
scheduler.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
scheduler.$(OBJEXT): {$(VPATH)}internal/config.h
scheduler.$(OBJEXT): {$(VPATH)}internal/constant_p.h
scheduler.$(OBJEXT): {$(VPATH)}internal/core.h
scheduler.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
scheduler.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
scheduler.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
scheduler.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
scheduler.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
scheduler.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
scheduler.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
scheduler.$(OBJEXT): {$(VPATH)}internal/core/robject.h
scheduler.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
scheduler.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
scheduler.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
scheduler.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
scheduler.$(OBJEXT): {$(VPATH)}internal/ctype.h
scheduler.$(OBJEXT): {$(VPATH)}internal/dllexport.h
scheduler.$(OBJEXT): {$(VPATH)}internal/dosish.h
scheduler.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
scheduler.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
scheduler.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
scheduler.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
scheduler.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
scheduler.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
scheduler.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
scheduler.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
scheduler.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
scheduler.$(OBJEXT): {$(VPATH)}internal/error.h
scheduler.$(OBJEXT): {$(VPATH)}internal/eval.h
scheduler.$(OBJEXT): {$(VPATH)}internal/event.h
scheduler.$(OBJEXT): {$(VPATH)}internal/fl_type.h
scheduler.$(OBJEXT): {$(VPATH)}internal/gc.h
scheduler.$(OBJEXT): {$(VPATH)}internal/glob.h
scheduler.$(OBJEXT): {$(VPATH)}internal/globals.h
scheduler.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
scheduler.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
scheduler.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
scheduler.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
scheduler.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
scheduler.$(OBJEXT): {$(VPATH)}internal/has/extension.h
scheduler.$(OBJEXT): {$(VPATH)}internal/has/feature.h
scheduler.$(OBJEXT): {$(VPATH)}internal/has/warning.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/array.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/class.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/error.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/file.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/io.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/load.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/object.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/process.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/random.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/range.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/re.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/select.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/string.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/time.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
scheduler.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
scheduler.$(OBJEXT): {$(VPATH)}internal/interpreter.h
scheduler.$(OBJEXT): {$(VPATH)}internal/iterator.h
scheduler.$(OBJEXT): {$(VPATH)}internal/memory.h
scheduler.$(OBJEXT): {$(VPATH)}internal/method.h
scheduler.$(OBJEXT): {$(VPATH)}internal/module.h
scheduler.$(OBJEXT): {$(VPATH)}internal/newobj.h
scheduler.$(OBJEXT): {$(VPATH)}internal/rgengc.h
scheduler.$(OBJEXT): {$(VPATH)}internal/scan_args.h
scheduler.$(OBJEXT): {$(VPATH)}internal/special_consts.h
scheduler.$(OBJEXT): {$(VPATH)}internal/static_assert.h
scheduler.$(OBJEXT): {$(VPATH)}internal/stdalign.h
scheduler.$(OBJEXT): {$(VPATH)}internal/stdbool.h
scheduler.$(OBJEXT): {$(VPATH)}internal/symbol.h
scheduler.$(OBJEXT): {$(VPATH)}internal/value.h
scheduler.$(OBJEXT): {$(VPATH)}internal/value_type.h
scheduler.$(OBJEXT): {$(VPATH)}internal/variable.h
scheduler.$(OBJEXT): {$(VPATH)}internal/warning_push.h
scheduler.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
scheduler.$(OBJEXT): {$(VPATH)}io.h
scheduler.$(OBJEXT): {$(VPATH)}io/buffer.h
scheduler.$(OBJEXT): {$(VPATH)}method.h
scheduler.$(OBJEXT): {$(VPATH)}missing.h
scheduler.$(OBJEXT): {$(VPATH)}node.h
scheduler.$(OBJEXT): {$(VPATH)}onigmo.h
scheduler.$(OBJEXT): {$(VPATH)}oniguruma.h
scheduler.$(OBJEXT): {$(VPATH)}ruby_assert.h
scheduler.$(OBJEXT): {$(VPATH)}ruby_atomic.h
scheduler.$(OBJEXT): {$(VPATH)}scheduler.c
scheduler.$(OBJEXT): {$(VPATH)}shape.h
scheduler.$(OBJEXT): {$(VPATH)}st.h
scheduler.$(OBJEXT): {$(VPATH)}subst.h
scheduler.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
scheduler.$(OBJEXT): {$(VPATH)}thread_native.h
scheduler.$(OBJEXT): {$(VPATH)}vm_core.h
scheduler.$(OBJEXT): {$(VPATH)}vm_opts.h
setproctitle.$(OBJEXT): $(hdrdir)/ruby.h
setproctitle.$(OBJEXT): $(hdrdir)/ruby/ruby.h
setproctitle.$(OBJEXT): {$(VPATH)}assert.h
setproctitle.$(OBJEXT): {$(VPATH)}backward/2/assume.h
setproctitle.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
setproctitle.$(OBJEXT): {$(VPATH)}backward/2/bool.h
setproctitle.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
setproctitle.$(OBJEXT): {$(VPATH)}backward/2/limits.h
setproctitle.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
setproctitle.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
setproctitle.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
setproctitle.$(OBJEXT): {$(VPATH)}config.h
setproctitle.$(OBJEXT): {$(VPATH)}defines.h
setproctitle.$(OBJEXT): {$(VPATH)}intern.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/abi.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/anyargs.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/assume.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/attr/const.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/attr/error.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/attr/format.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/cast.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/config.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/constant_p.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/core.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/core/robject.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/ctype.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/dllexport.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/dosish.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/error.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/eval.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/event.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/fl_type.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/gc.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/glob.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/globals.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/has/extension.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/has/feature.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/has/warning.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/array.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/class.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/error.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/file.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/io.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/load.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/object.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/process.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/random.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/range.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/re.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/select.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/string.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/time.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/interpreter.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/iterator.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/memory.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/method.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/module.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/newobj.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/rgengc.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/scan_args.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/special_consts.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/static_assert.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/stdalign.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/stdbool.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/symbol.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/value.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/value_type.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/variable.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/warning_push.h
setproctitle.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
setproctitle.$(OBJEXT): {$(VPATH)}missing.h
setproctitle.$(OBJEXT): {$(VPATH)}setproctitle.c
setproctitle.$(OBJEXT): {$(VPATH)}st.h
setproctitle.$(OBJEXT): {$(VPATH)}subst.h
setproctitle.$(OBJEXT): {$(VPATH)}util.h
shape.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
shape.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
shape.$(OBJEXT): $(CCAN_DIR)/list/list.h
shape.$(OBJEXT): $(CCAN_DIR)/str/str.h
shape.$(OBJEXT): $(hdrdir)/ruby/ruby.h
shape.$(OBJEXT): $(top_srcdir)/internal/array.h
shape.$(OBJEXT): $(top_srcdir)/internal/class.h
shape.$(OBJEXT): $(top_srcdir)/internal/compilers.h
shape.$(OBJEXT): $(top_srcdir)/internal/gc.h
shape.$(OBJEXT): $(top_srcdir)/internal/imemo.h
shape.$(OBJEXT): $(top_srcdir)/internal/serial.h
shape.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
shape.$(OBJEXT): $(top_srcdir)/internal/symbol.h
shape.$(OBJEXT): $(top_srcdir)/internal/variable.h
shape.$(OBJEXT): $(top_srcdir)/internal/vm.h
shape.$(OBJEXT): $(top_srcdir)/internal/warnings.h
shape.$(OBJEXT): {$(VPATH)}assert.h
shape.$(OBJEXT): {$(VPATH)}atomic.h
shape.$(OBJEXT): {$(VPATH)}backward/2/assume.h
shape.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
shape.$(OBJEXT): {$(VPATH)}backward/2/bool.h
shape.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
shape.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
shape.$(OBJEXT): {$(VPATH)}backward/2/limits.h
shape.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
shape.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
shape.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
shape.$(OBJEXT): {$(VPATH)}config.h
shape.$(OBJEXT): {$(VPATH)}constant.h
shape.$(OBJEXT): {$(VPATH)}debug_counter.h
shape.$(OBJEXT): {$(VPATH)}defines.h
shape.$(OBJEXT): {$(VPATH)}encoding.h
shape.$(OBJEXT): {$(VPATH)}gc.h
shape.$(OBJEXT): {$(VPATH)}id.h
shape.$(OBJEXT): {$(VPATH)}id_table.h
shape.$(OBJEXT): {$(VPATH)}intern.h
shape.$(OBJEXT): {$(VPATH)}internal.h
shape.$(OBJEXT): {$(VPATH)}internal/abi.h
shape.$(OBJEXT): {$(VPATH)}internal/anyargs.h
shape.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
shape.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
shape.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
shape.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
shape.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
shape.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
shape.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
shape.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
shape.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
shape.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
shape.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
shape.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
shape.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
shape.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
shape.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
shape.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
shape.$(OBJEXT): {$(VPATH)}internal/assume.h
shape.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
shape.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
shape.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
shape.$(OBJEXT): {$(VPATH)}internal/attr/const.h
shape.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
shape.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
shape.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
shape.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
shape.$(OBJEXT): {$(VPATH)}internal/attr/error.h
shape.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
shape.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
shape.$(OBJEXT): {$(VPATH)}internal/attr/format.h
shape.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
shape.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
shape.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
shape.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
shape.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
shape.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
shape.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
shape.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
shape.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
shape.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
shape.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
shape.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
shape.$(OBJEXT): {$(VPATH)}internal/cast.h
shape.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
shape.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
shape.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
shape.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
shape.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
shape.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
shape.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
shape.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
shape.$(OBJEXT): {$(VPATH)}internal/config.h
shape.$(OBJEXT): {$(VPATH)}internal/constant_p.h
shape.$(OBJEXT): {$(VPATH)}internal/core.h
shape.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
shape.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
shape.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
shape.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
shape.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
shape.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
shape.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
shape.$(OBJEXT): {$(VPATH)}internal/core/robject.h
shape.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
shape.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
shape.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
shape.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
shape.$(OBJEXT): {$(VPATH)}internal/ctype.h
shape.$(OBJEXT): {$(VPATH)}internal/dllexport.h
shape.$(OBJEXT): {$(VPATH)}internal/dosish.h
shape.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
shape.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
shape.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
shape.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
shape.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
shape.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
shape.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
shape.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
shape.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
shape.$(OBJEXT): {$(VPATH)}internal/error.h
shape.$(OBJEXT): {$(VPATH)}internal/eval.h
shape.$(OBJEXT): {$(VPATH)}internal/event.h
shape.$(OBJEXT): {$(VPATH)}internal/fl_type.h
shape.$(OBJEXT): {$(VPATH)}internal/gc.h
shape.$(OBJEXT): {$(VPATH)}internal/glob.h
shape.$(OBJEXT): {$(VPATH)}internal/globals.h
shape.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
shape.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
shape.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
shape.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
shape.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
shape.$(OBJEXT): {$(VPATH)}internal/has/extension.h
shape.$(OBJEXT): {$(VPATH)}internal/has/feature.h
shape.$(OBJEXT): {$(VPATH)}internal/has/warning.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/array.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/class.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/error.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/file.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/io.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/load.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/object.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/process.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/random.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/range.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/re.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/select.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/string.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/time.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
shape.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
shape.$(OBJEXT): {$(VPATH)}internal/interpreter.h
shape.$(OBJEXT): {$(VPATH)}internal/iterator.h
shape.$(OBJEXT): {$(VPATH)}internal/memory.h
shape.$(OBJEXT): {$(VPATH)}internal/method.h
shape.$(OBJEXT): {$(VPATH)}internal/module.h
shape.$(OBJEXT): {$(VPATH)}internal/newobj.h
shape.$(OBJEXT): {$(VPATH)}internal/rgengc.h
shape.$(OBJEXT): {$(VPATH)}internal/scan_args.h
shape.$(OBJEXT): {$(VPATH)}internal/special_consts.h
shape.$(OBJEXT): {$(VPATH)}internal/static_assert.h
shape.$(OBJEXT): {$(VPATH)}internal/stdalign.h
shape.$(OBJEXT): {$(VPATH)}internal/stdbool.h
shape.$(OBJEXT): {$(VPATH)}internal/symbol.h
shape.$(OBJEXT): {$(VPATH)}internal/value.h
shape.$(OBJEXT): {$(VPATH)}internal/value_type.h
shape.$(OBJEXT): {$(VPATH)}internal/variable.h
shape.$(OBJEXT): {$(VPATH)}internal/warning_push.h
shape.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
shape.$(OBJEXT): {$(VPATH)}method.h
shape.$(OBJEXT): {$(VPATH)}missing.h
shape.$(OBJEXT): {$(VPATH)}node.h
shape.$(OBJEXT): {$(VPATH)}onigmo.h
shape.$(OBJEXT): {$(VPATH)}oniguruma.h
shape.$(OBJEXT): {$(VPATH)}ruby_assert.h
shape.$(OBJEXT): {$(VPATH)}ruby_atomic.h
shape.$(OBJEXT): {$(VPATH)}shape.c
shape.$(OBJEXT): {$(VPATH)}shape.h
shape.$(OBJEXT): {$(VPATH)}st.h
shape.$(OBJEXT): {$(VPATH)}subst.h
shape.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
shape.$(OBJEXT): {$(VPATH)}thread_native.h
shape.$(OBJEXT): {$(VPATH)}vm_core.h
shape.$(OBJEXT): {$(VPATH)}vm_debug.h
shape.$(OBJEXT): {$(VPATH)}vm_opts.h
shape.$(OBJEXT): {$(VPATH)}vm_sync.h
signal.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
signal.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
signal.$(OBJEXT): $(CCAN_DIR)/list/list.h
signal.$(OBJEXT): $(CCAN_DIR)/str/str.h
signal.$(OBJEXT): $(hdrdir)/ruby/ruby.h
signal.$(OBJEXT): $(top_srcdir)/internal/array.h
signal.$(OBJEXT): $(top_srcdir)/internal/compilers.h
signal.$(OBJEXT): $(top_srcdir)/internal/eval.h
signal.$(OBJEXT): $(top_srcdir)/internal/gc.h
signal.$(OBJEXT): $(top_srcdir)/internal/imemo.h
signal.$(OBJEXT): $(top_srcdir)/internal/sanitizers.h
signal.$(OBJEXT): $(top_srcdir)/internal/serial.h
signal.$(OBJEXT): $(top_srcdir)/internal/signal.h
signal.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
signal.$(OBJEXT): $(top_srcdir)/internal/string.h
signal.$(OBJEXT): $(top_srcdir)/internal/thread.h
signal.$(OBJEXT): $(top_srcdir)/internal/variable.h
signal.$(OBJEXT): $(top_srcdir)/internal/vm.h
signal.$(OBJEXT): $(top_srcdir)/internal/warnings.h
signal.$(OBJEXT): {$(VPATH)}assert.h
signal.$(OBJEXT): {$(VPATH)}atomic.h
signal.$(OBJEXT): {$(VPATH)}backward/2/assume.h
signal.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
signal.$(OBJEXT): {$(VPATH)}backward/2/bool.h
signal.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
signal.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
signal.$(OBJEXT): {$(VPATH)}backward/2/limits.h
signal.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
signal.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
signal.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
signal.$(OBJEXT): {$(VPATH)}config.h
signal.$(OBJEXT): {$(VPATH)}constant.h
signal.$(OBJEXT): {$(VPATH)}debug_counter.h
signal.$(OBJEXT): {$(VPATH)}defines.h
signal.$(OBJEXT): {$(VPATH)}encoding.h
signal.$(OBJEXT): {$(VPATH)}eval_intern.h
signal.$(OBJEXT): {$(VPATH)}id.h
signal.$(OBJEXT): {$(VPATH)}id_table.h
signal.$(OBJEXT): {$(VPATH)}intern.h
signal.$(OBJEXT): {$(VPATH)}internal.h
signal.$(OBJEXT): {$(VPATH)}internal/abi.h
signal.$(OBJEXT): {$(VPATH)}internal/anyargs.h
signal.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
signal.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
signal.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
signal.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
signal.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
signal.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
signal.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
signal.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
signal.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
signal.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
signal.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
signal.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
signal.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
signal.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
signal.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
signal.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
signal.$(OBJEXT): {$(VPATH)}internal/assume.h
signal.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
signal.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
signal.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
signal.$(OBJEXT): {$(VPATH)}internal/attr/const.h
signal.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
signal.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
signal.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
signal.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
signal.$(OBJEXT): {$(VPATH)}internal/attr/error.h
signal.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
signal.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
signal.$(OBJEXT): {$(VPATH)}internal/attr/format.h
signal.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
signal.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
signal.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
signal.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
signal.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
signal.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
signal.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
signal.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
signal.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
signal.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
signal.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
signal.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
signal.$(OBJEXT): {$(VPATH)}internal/cast.h
signal.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
signal.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
signal.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
signal.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
signal.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
signal.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
signal.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
signal.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
signal.$(OBJEXT): {$(VPATH)}internal/config.h
signal.$(OBJEXT): {$(VPATH)}internal/constant_p.h
signal.$(OBJEXT): {$(VPATH)}internal/core.h
signal.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
signal.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
signal.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
signal.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
signal.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
signal.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
signal.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
signal.$(OBJEXT): {$(VPATH)}internal/core/robject.h
signal.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
signal.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
signal.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
signal.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
signal.$(OBJEXT): {$(VPATH)}internal/ctype.h
signal.$(OBJEXT): {$(VPATH)}internal/dllexport.h
signal.$(OBJEXT): {$(VPATH)}internal/dosish.h
signal.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
signal.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
signal.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
signal.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
signal.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
signal.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
signal.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
signal.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
signal.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
signal.$(OBJEXT): {$(VPATH)}internal/error.h
signal.$(OBJEXT): {$(VPATH)}internal/eval.h
signal.$(OBJEXT): {$(VPATH)}internal/event.h
signal.$(OBJEXT): {$(VPATH)}internal/fl_type.h
signal.$(OBJEXT): {$(VPATH)}internal/gc.h
signal.$(OBJEXT): {$(VPATH)}internal/glob.h
signal.$(OBJEXT): {$(VPATH)}internal/globals.h
signal.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
signal.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
signal.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
signal.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
signal.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
signal.$(OBJEXT): {$(VPATH)}internal/has/extension.h
signal.$(OBJEXT): {$(VPATH)}internal/has/feature.h
signal.$(OBJEXT): {$(VPATH)}internal/has/warning.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/array.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/class.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/error.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/file.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/io.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/load.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/object.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/process.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/random.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/range.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/re.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/select.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/string.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/time.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
signal.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
signal.$(OBJEXT): {$(VPATH)}internal/interpreter.h
signal.$(OBJEXT): {$(VPATH)}internal/iterator.h
signal.$(OBJEXT): {$(VPATH)}internal/memory.h
signal.$(OBJEXT): {$(VPATH)}internal/method.h
signal.$(OBJEXT): {$(VPATH)}internal/module.h
signal.$(OBJEXT): {$(VPATH)}internal/newobj.h
signal.$(OBJEXT): {$(VPATH)}internal/rgengc.h
signal.$(OBJEXT): {$(VPATH)}internal/scan_args.h
signal.$(OBJEXT): {$(VPATH)}internal/special_consts.h
signal.$(OBJEXT): {$(VPATH)}internal/static_assert.h
signal.$(OBJEXT): {$(VPATH)}internal/stdalign.h
signal.$(OBJEXT): {$(VPATH)}internal/stdbool.h
signal.$(OBJEXT): {$(VPATH)}internal/symbol.h
signal.$(OBJEXT): {$(VPATH)}internal/value.h
signal.$(OBJEXT): {$(VPATH)}internal/value_type.h
signal.$(OBJEXT): {$(VPATH)}internal/variable.h
signal.$(OBJEXT): {$(VPATH)}internal/warning_push.h
signal.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
signal.$(OBJEXT): {$(VPATH)}method.h
signal.$(OBJEXT): {$(VPATH)}missing.h
signal.$(OBJEXT): {$(VPATH)}node.h
signal.$(OBJEXT): {$(VPATH)}onigmo.h
signal.$(OBJEXT): {$(VPATH)}oniguruma.h
signal.$(OBJEXT): {$(VPATH)}ractor.h
signal.$(OBJEXT): {$(VPATH)}ractor_core.h
signal.$(OBJEXT): {$(VPATH)}ruby_assert.h
signal.$(OBJEXT): {$(VPATH)}ruby_atomic.h
signal.$(OBJEXT): {$(VPATH)}shape.h
signal.$(OBJEXT): {$(VPATH)}signal.c
signal.$(OBJEXT): {$(VPATH)}st.h
signal.$(OBJEXT): {$(VPATH)}subst.h
signal.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
signal.$(OBJEXT): {$(VPATH)}thread_native.h
signal.$(OBJEXT): {$(VPATH)}vm_core.h
signal.$(OBJEXT): {$(VPATH)}vm_debug.h
signal.$(OBJEXT): {$(VPATH)}vm_opts.h
sprintf.$(OBJEXT): $(hdrdir)/ruby/ruby.h
sprintf.$(OBJEXT): $(top_srcdir)/internal/bignum.h
sprintf.$(OBJEXT): $(top_srcdir)/internal/bits.h
sprintf.$(OBJEXT): $(top_srcdir)/internal/class.h
sprintf.$(OBJEXT): $(top_srcdir)/internal/compilers.h
sprintf.$(OBJEXT): $(top_srcdir)/internal/error.h
sprintf.$(OBJEXT): $(top_srcdir)/internal/fixnum.h
sprintf.$(OBJEXT): $(top_srcdir)/internal/gc.h
sprintf.$(OBJEXT): $(top_srcdir)/internal/hash.h
sprintf.$(OBJEXT): $(top_srcdir)/internal/numeric.h
sprintf.$(OBJEXT): $(top_srcdir)/internal/object.h
sprintf.$(OBJEXT): $(top_srcdir)/internal/sanitizers.h
sprintf.$(OBJEXT): $(top_srcdir)/internal/serial.h
sprintf.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
sprintf.$(OBJEXT): $(top_srcdir)/internal/string.h
sprintf.$(OBJEXT): $(top_srcdir)/internal/symbol.h
sprintf.$(OBJEXT): $(top_srcdir)/internal/variable.h
sprintf.$(OBJEXT): $(top_srcdir)/internal/vm.h
sprintf.$(OBJEXT): $(top_srcdir)/internal/warnings.h
sprintf.$(OBJEXT): {$(VPATH)}assert.h
sprintf.$(OBJEXT): {$(VPATH)}backward/2/assume.h
sprintf.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
sprintf.$(OBJEXT): {$(VPATH)}backward/2/bool.h
sprintf.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
sprintf.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
sprintf.$(OBJEXT): {$(VPATH)}backward/2/limits.h
sprintf.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
sprintf.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
sprintf.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
sprintf.$(OBJEXT): {$(VPATH)}config.h
sprintf.$(OBJEXT): {$(VPATH)}constant.h
sprintf.$(OBJEXT): {$(VPATH)}defines.h
sprintf.$(OBJEXT): {$(VPATH)}encoding.h
sprintf.$(OBJEXT): {$(VPATH)}id.h
sprintf.$(OBJEXT): {$(VPATH)}id_table.h
sprintf.$(OBJEXT): {$(VPATH)}intern.h
sprintf.$(OBJEXT): {$(VPATH)}internal.h
sprintf.$(OBJEXT): {$(VPATH)}internal/abi.h
sprintf.$(OBJEXT): {$(VPATH)}internal/anyargs.h
sprintf.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
sprintf.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
sprintf.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
sprintf.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
sprintf.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
sprintf.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
sprintf.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
sprintf.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
sprintf.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
sprintf.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
sprintf.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
sprintf.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
sprintf.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
sprintf.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
sprintf.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
sprintf.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
sprintf.$(OBJEXT): {$(VPATH)}internal/assume.h
sprintf.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
sprintf.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
sprintf.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
sprintf.$(OBJEXT): {$(VPATH)}internal/attr/const.h
sprintf.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
sprintf.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
sprintf.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
sprintf.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
sprintf.$(OBJEXT): {$(VPATH)}internal/attr/error.h
sprintf.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
sprintf.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
sprintf.$(OBJEXT): {$(VPATH)}internal/attr/format.h
sprintf.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
sprintf.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
sprintf.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
sprintf.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
sprintf.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
sprintf.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
sprintf.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
sprintf.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
sprintf.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
sprintf.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
sprintf.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
sprintf.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
sprintf.$(OBJEXT): {$(VPATH)}internal/cast.h
sprintf.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
sprintf.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
sprintf.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
sprintf.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
sprintf.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
sprintf.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
sprintf.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
sprintf.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
sprintf.$(OBJEXT): {$(VPATH)}internal/config.h
sprintf.$(OBJEXT): {$(VPATH)}internal/constant_p.h
sprintf.$(OBJEXT): {$(VPATH)}internal/core.h
sprintf.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
sprintf.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
sprintf.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
sprintf.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
sprintf.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
sprintf.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
sprintf.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
sprintf.$(OBJEXT): {$(VPATH)}internal/core/rmatch.h
sprintf.$(OBJEXT): {$(VPATH)}internal/core/robject.h
sprintf.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
sprintf.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
sprintf.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
sprintf.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
sprintf.$(OBJEXT): {$(VPATH)}internal/ctype.h
sprintf.$(OBJEXT): {$(VPATH)}internal/dllexport.h
sprintf.$(OBJEXT): {$(VPATH)}internal/dosish.h
sprintf.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
sprintf.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
sprintf.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
sprintf.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
sprintf.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
sprintf.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
sprintf.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
sprintf.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
sprintf.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
sprintf.$(OBJEXT): {$(VPATH)}internal/error.h
sprintf.$(OBJEXT): {$(VPATH)}internal/eval.h
sprintf.$(OBJEXT): {$(VPATH)}internal/event.h
sprintf.$(OBJEXT): {$(VPATH)}internal/fl_type.h
sprintf.$(OBJEXT): {$(VPATH)}internal/gc.h
sprintf.$(OBJEXT): {$(VPATH)}internal/glob.h
sprintf.$(OBJEXT): {$(VPATH)}internal/globals.h
sprintf.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
sprintf.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
sprintf.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
sprintf.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
sprintf.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
sprintf.$(OBJEXT): {$(VPATH)}internal/has/extension.h
sprintf.$(OBJEXT): {$(VPATH)}internal/has/feature.h
sprintf.$(OBJEXT): {$(VPATH)}internal/has/warning.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/array.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/class.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/error.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/file.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/io.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/load.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/object.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/process.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/random.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/range.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/re.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/select.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/string.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/time.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
sprintf.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
sprintf.$(OBJEXT): {$(VPATH)}internal/interpreter.h
sprintf.$(OBJEXT): {$(VPATH)}internal/iterator.h
sprintf.$(OBJEXT): {$(VPATH)}internal/memory.h
sprintf.$(OBJEXT): {$(VPATH)}internal/method.h
sprintf.$(OBJEXT): {$(VPATH)}internal/module.h
sprintf.$(OBJEXT): {$(VPATH)}internal/newobj.h
sprintf.$(OBJEXT): {$(VPATH)}internal/rgengc.h
sprintf.$(OBJEXT): {$(VPATH)}internal/scan_args.h
sprintf.$(OBJEXT): {$(VPATH)}internal/special_consts.h
sprintf.$(OBJEXT): {$(VPATH)}internal/static_assert.h
sprintf.$(OBJEXT): {$(VPATH)}internal/stdalign.h
sprintf.$(OBJEXT): {$(VPATH)}internal/stdbool.h
sprintf.$(OBJEXT): {$(VPATH)}internal/symbol.h
sprintf.$(OBJEXT): {$(VPATH)}internal/value.h
sprintf.$(OBJEXT): {$(VPATH)}internal/value_type.h
sprintf.$(OBJEXT): {$(VPATH)}internal/variable.h
sprintf.$(OBJEXT): {$(VPATH)}internal/warning_push.h
sprintf.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
sprintf.$(OBJEXT): {$(VPATH)}missing.h
sprintf.$(OBJEXT): {$(VPATH)}onigmo.h
sprintf.$(OBJEXT): {$(VPATH)}oniguruma.h
sprintf.$(OBJEXT): {$(VPATH)}re.h
sprintf.$(OBJEXT): {$(VPATH)}regex.h
sprintf.$(OBJEXT): {$(VPATH)}shape.h
sprintf.$(OBJEXT): {$(VPATH)}sprintf.c
sprintf.$(OBJEXT): {$(VPATH)}st.h
sprintf.$(OBJEXT): {$(VPATH)}subst.h
sprintf.$(OBJEXT): {$(VPATH)}util.h
sprintf.$(OBJEXT): {$(VPATH)}vsnprintf.c
st.$(OBJEXT): $(hdrdir)/ruby/ruby.h
st.$(OBJEXT): $(top_srcdir)/internal/bits.h
st.$(OBJEXT): $(top_srcdir)/internal/compilers.h
st.$(OBJEXT): $(top_srcdir)/internal/hash.h
st.$(OBJEXT): $(top_srcdir)/internal/sanitizers.h
st.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
st.$(OBJEXT): $(top_srcdir)/internal/warnings.h
st.$(OBJEXT): {$(VPATH)}assert.h
st.$(OBJEXT): {$(VPATH)}backward/2/assume.h
st.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
st.$(OBJEXT): {$(VPATH)}backward/2/bool.h
st.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
st.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
st.$(OBJEXT): {$(VPATH)}backward/2/limits.h
st.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
st.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
st.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
st.$(OBJEXT): {$(VPATH)}config.h
st.$(OBJEXT): {$(VPATH)}defines.h
st.$(OBJEXT): {$(VPATH)}intern.h
st.$(OBJEXT): {$(VPATH)}internal.h
st.$(OBJEXT): {$(VPATH)}internal/abi.h
st.$(OBJEXT): {$(VPATH)}internal/anyargs.h
st.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
st.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
st.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
st.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
st.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
st.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
st.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
st.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
st.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
st.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
st.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
st.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
st.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
st.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
st.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
st.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
st.$(OBJEXT): {$(VPATH)}internal/assume.h
st.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
st.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
st.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
st.$(OBJEXT): {$(VPATH)}internal/attr/const.h
st.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
st.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
st.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
st.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
st.$(OBJEXT): {$(VPATH)}internal/attr/error.h
st.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
st.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
st.$(OBJEXT): {$(VPATH)}internal/attr/format.h
st.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
st.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
st.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
st.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
st.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
st.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
st.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
st.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
st.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
st.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
st.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
st.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
st.$(OBJEXT): {$(VPATH)}internal/cast.h
st.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
st.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
st.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
st.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
st.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
st.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
st.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
st.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
st.$(OBJEXT): {$(VPATH)}internal/config.h
st.$(OBJEXT): {$(VPATH)}internal/constant_p.h
st.$(OBJEXT): {$(VPATH)}internal/core.h
st.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
st.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
st.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
st.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
st.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
st.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
st.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
st.$(OBJEXT): {$(VPATH)}internal/core/robject.h
st.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
st.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
st.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
st.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
st.$(OBJEXT): {$(VPATH)}internal/ctype.h
st.$(OBJEXT): {$(VPATH)}internal/dllexport.h
st.$(OBJEXT): {$(VPATH)}internal/dosish.h
st.$(OBJEXT): {$(VPATH)}internal/error.h
st.$(OBJEXT): {$(VPATH)}internal/eval.h
st.$(OBJEXT): {$(VPATH)}internal/event.h
st.$(OBJEXT): {$(VPATH)}internal/fl_type.h
st.$(OBJEXT): {$(VPATH)}internal/gc.h
st.$(OBJEXT): {$(VPATH)}internal/glob.h
st.$(OBJEXT): {$(VPATH)}internal/globals.h
st.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
st.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
st.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
st.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
st.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
st.$(OBJEXT): {$(VPATH)}internal/has/extension.h
st.$(OBJEXT): {$(VPATH)}internal/has/feature.h
st.$(OBJEXT): {$(VPATH)}internal/has/warning.h
st.$(OBJEXT): {$(VPATH)}internal/intern/array.h
st.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
st.$(OBJEXT): {$(VPATH)}internal/intern/class.h
st.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
st.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
st.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
st.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
st.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
st.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
st.$(OBJEXT): {$(VPATH)}internal/intern/error.h
st.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
st.$(OBJEXT): {$(VPATH)}internal/intern/file.h
st.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
st.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
st.$(OBJEXT): {$(VPATH)}internal/intern/io.h
st.$(OBJEXT): {$(VPATH)}internal/intern/load.h
st.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
st.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
st.$(OBJEXT): {$(VPATH)}internal/intern/object.h
st.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
st.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
st.$(OBJEXT): {$(VPATH)}internal/intern/process.h
st.$(OBJEXT): {$(VPATH)}internal/intern/random.h
st.$(OBJEXT): {$(VPATH)}internal/intern/range.h
st.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
st.$(OBJEXT): {$(VPATH)}internal/intern/re.h
st.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
st.$(OBJEXT): {$(VPATH)}internal/intern/select.h
st.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
st.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
st.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
st.$(OBJEXT): {$(VPATH)}internal/intern/string.h
st.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
st.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
st.$(OBJEXT): {$(VPATH)}internal/intern/time.h
st.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
st.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
st.$(OBJEXT): {$(VPATH)}internal/interpreter.h
st.$(OBJEXT): {$(VPATH)}internal/iterator.h
st.$(OBJEXT): {$(VPATH)}internal/memory.h
st.$(OBJEXT): {$(VPATH)}internal/method.h
st.$(OBJEXT): {$(VPATH)}internal/module.h
st.$(OBJEXT): {$(VPATH)}internal/newobj.h
st.$(OBJEXT): {$(VPATH)}internal/rgengc.h
st.$(OBJEXT): {$(VPATH)}internal/scan_args.h
st.$(OBJEXT): {$(VPATH)}internal/special_consts.h
st.$(OBJEXT): {$(VPATH)}internal/static_assert.h
st.$(OBJEXT): {$(VPATH)}internal/stdalign.h
st.$(OBJEXT): {$(VPATH)}internal/stdbool.h
st.$(OBJEXT): {$(VPATH)}internal/symbol.h
st.$(OBJEXT): {$(VPATH)}internal/value.h
st.$(OBJEXT): {$(VPATH)}internal/value_type.h
st.$(OBJEXT): {$(VPATH)}internal/variable.h
st.$(OBJEXT): {$(VPATH)}internal/warning_push.h
st.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
st.$(OBJEXT): {$(VPATH)}missing.h
st.$(OBJEXT): {$(VPATH)}st.c
st.$(OBJEXT): {$(VPATH)}st.h
st.$(OBJEXT): {$(VPATH)}subst.h
strftime.$(OBJEXT): $(hdrdir)/ruby/ruby.h
strftime.$(OBJEXT): $(top_srcdir)/internal/compilers.h
strftime.$(OBJEXT): $(top_srcdir)/internal/encoding.h
strftime.$(OBJEXT): $(top_srcdir)/internal/serial.h
strftime.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
strftime.$(OBJEXT): $(top_srcdir)/internal/string.h
strftime.$(OBJEXT): $(top_srcdir)/internal/vm.h
strftime.$(OBJEXT): {$(VPATH)}assert.h
strftime.$(OBJEXT): {$(VPATH)}backward/2/assume.h
strftime.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
strftime.$(OBJEXT): {$(VPATH)}backward/2/bool.h
strftime.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
strftime.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
strftime.$(OBJEXT): {$(VPATH)}backward/2/limits.h
strftime.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
strftime.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
strftime.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
strftime.$(OBJEXT): {$(VPATH)}config.h
strftime.$(OBJEXT): {$(VPATH)}defines.h
strftime.$(OBJEXT): {$(VPATH)}encoding.h
strftime.$(OBJEXT): {$(VPATH)}intern.h
strftime.$(OBJEXT): {$(VPATH)}internal.h
strftime.$(OBJEXT): {$(VPATH)}internal/abi.h
strftime.$(OBJEXT): {$(VPATH)}internal/anyargs.h
strftime.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
strftime.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
strftime.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
strftime.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
strftime.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
strftime.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
strftime.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
strftime.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
strftime.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
strftime.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
strftime.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
strftime.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
strftime.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
strftime.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
strftime.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
strftime.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
strftime.$(OBJEXT): {$(VPATH)}internal/assume.h
strftime.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
strftime.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
strftime.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
strftime.$(OBJEXT): {$(VPATH)}internal/attr/const.h
strftime.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
strftime.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
strftime.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
strftime.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
strftime.$(OBJEXT): {$(VPATH)}internal/attr/error.h
strftime.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
strftime.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
strftime.$(OBJEXT): {$(VPATH)}internal/attr/format.h
strftime.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
strftime.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
strftime.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
strftime.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
strftime.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
strftime.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
strftime.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
strftime.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
strftime.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
strftime.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
strftime.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
strftime.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
strftime.$(OBJEXT): {$(VPATH)}internal/cast.h
strftime.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
strftime.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
strftime.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
strftime.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
strftime.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
strftime.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
strftime.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
strftime.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
strftime.$(OBJEXT): {$(VPATH)}internal/config.h
strftime.$(OBJEXT): {$(VPATH)}internal/constant_p.h
strftime.$(OBJEXT): {$(VPATH)}internal/core.h
strftime.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
strftime.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
strftime.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
strftime.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
strftime.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
strftime.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
strftime.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
strftime.$(OBJEXT): {$(VPATH)}internal/core/robject.h
strftime.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
strftime.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
strftime.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
strftime.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
strftime.$(OBJEXT): {$(VPATH)}internal/ctype.h
strftime.$(OBJEXT): {$(VPATH)}internal/dllexport.h
strftime.$(OBJEXT): {$(VPATH)}internal/dosish.h
strftime.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
strftime.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
strftime.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
strftime.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
strftime.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
strftime.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
strftime.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
strftime.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
strftime.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
strftime.$(OBJEXT): {$(VPATH)}internal/error.h
strftime.$(OBJEXT): {$(VPATH)}internal/eval.h
strftime.$(OBJEXT): {$(VPATH)}internal/event.h
strftime.$(OBJEXT): {$(VPATH)}internal/fl_type.h
strftime.$(OBJEXT): {$(VPATH)}internal/gc.h
strftime.$(OBJEXT): {$(VPATH)}internal/glob.h
strftime.$(OBJEXT): {$(VPATH)}internal/globals.h
strftime.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
strftime.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
strftime.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
strftime.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
strftime.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
strftime.$(OBJEXT): {$(VPATH)}internal/has/extension.h
strftime.$(OBJEXT): {$(VPATH)}internal/has/feature.h
strftime.$(OBJEXT): {$(VPATH)}internal/has/warning.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/array.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/class.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/error.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/file.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/io.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/load.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/object.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/process.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/random.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/range.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/re.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/select.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/string.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/time.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
strftime.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
strftime.$(OBJEXT): {$(VPATH)}internal/interpreter.h
strftime.$(OBJEXT): {$(VPATH)}internal/iterator.h
strftime.$(OBJEXT): {$(VPATH)}internal/memory.h
strftime.$(OBJEXT): {$(VPATH)}internal/method.h
strftime.$(OBJEXT): {$(VPATH)}internal/module.h
strftime.$(OBJEXT): {$(VPATH)}internal/newobj.h
strftime.$(OBJEXT): {$(VPATH)}internal/rgengc.h
strftime.$(OBJEXT): {$(VPATH)}internal/scan_args.h
strftime.$(OBJEXT): {$(VPATH)}internal/special_consts.h
strftime.$(OBJEXT): {$(VPATH)}internal/static_assert.h
strftime.$(OBJEXT): {$(VPATH)}internal/stdalign.h
strftime.$(OBJEXT): {$(VPATH)}internal/stdbool.h
strftime.$(OBJEXT): {$(VPATH)}internal/symbol.h
strftime.$(OBJEXT): {$(VPATH)}internal/value.h
strftime.$(OBJEXT): {$(VPATH)}internal/value_type.h
strftime.$(OBJEXT): {$(VPATH)}internal/variable.h
strftime.$(OBJEXT): {$(VPATH)}internal/warning_push.h
strftime.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
strftime.$(OBJEXT): {$(VPATH)}missing.h
strftime.$(OBJEXT): {$(VPATH)}onigmo.h
strftime.$(OBJEXT): {$(VPATH)}oniguruma.h
strftime.$(OBJEXT): {$(VPATH)}st.h
strftime.$(OBJEXT): {$(VPATH)}strftime.c
strftime.$(OBJEXT): {$(VPATH)}subst.h
strftime.$(OBJEXT): {$(VPATH)}timev.h
strftime.$(OBJEXT): {$(VPATH)}util.h
string.$(OBJEXT): $(hdrdir)/ruby/ruby.h
string.$(OBJEXT): $(top_srcdir)/internal/array.h
string.$(OBJEXT): $(top_srcdir)/internal/bignum.h
string.$(OBJEXT): $(top_srcdir)/internal/bits.h
string.$(OBJEXT): $(top_srcdir)/internal/class.h
string.$(OBJEXT): $(top_srcdir)/internal/compar.h
string.$(OBJEXT): $(top_srcdir)/internal/compilers.h
string.$(OBJEXT): $(top_srcdir)/internal/encoding.h
string.$(OBJEXT): $(top_srcdir)/internal/error.h
string.$(OBJEXT): $(top_srcdir)/internal/fixnum.h
string.$(OBJEXT): $(top_srcdir)/internal/gc.h
string.$(OBJEXT): $(top_srcdir)/internal/numeric.h
string.$(OBJEXT): $(top_srcdir)/internal/object.h
string.$(OBJEXT): $(top_srcdir)/internal/proc.h
string.$(OBJEXT): $(top_srcdir)/internal/re.h
string.$(OBJEXT): $(top_srcdir)/internal/sanitizers.h
string.$(OBJEXT): $(top_srcdir)/internal/serial.h
string.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
string.$(OBJEXT): $(top_srcdir)/internal/string.h
string.$(OBJEXT): $(top_srcdir)/internal/transcode.h
string.$(OBJEXT): $(top_srcdir)/internal/variable.h
string.$(OBJEXT): $(top_srcdir)/internal/vm.h
string.$(OBJEXT): $(top_srcdir)/internal/warnings.h
string.$(OBJEXT): {$(VPATH)}assert.h
string.$(OBJEXT): {$(VPATH)}atomic.h
string.$(OBJEXT): {$(VPATH)}backward/2/assume.h
string.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
string.$(OBJEXT): {$(VPATH)}backward/2/bool.h
string.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
string.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
string.$(OBJEXT): {$(VPATH)}backward/2/limits.h
string.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
string.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
string.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
string.$(OBJEXT): {$(VPATH)}config.h
string.$(OBJEXT): {$(VPATH)}constant.h
string.$(OBJEXT): {$(VPATH)}debug_counter.h
string.$(OBJEXT): {$(VPATH)}defines.h
string.$(OBJEXT): {$(VPATH)}encindex.h
string.$(OBJEXT): {$(VPATH)}encoding.h
string.$(OBJEXT): {$(VPATH)}gc.h
string.$(OBJEXT): {$(VPATH)}id.h
string.$(OBJEXT): {$(VPATH)}id_table.h
string.$(OBJEXT): {$(VPATH)}intern.h
string.$(OBJEXT): {$(VPATH)}internal.h
string.$(OBJEXT): {$(VPATH)}internal/abi.h
string.$(OBJEXT): {$(VPATH)}internal/anyargs.h
string.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
string.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
string.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
string.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
string.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
string.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
string.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
string.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
string.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
string.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
string.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
string.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
string.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
string.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
string.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
string.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
string.$(OBJEXT): {$(VPATH)}internal/assume.h
string.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
string.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
string.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
string.$(OBJEXT): {$(VPATH)}internal/attr/const.h
string.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
string.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
string.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
string.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
string.$(OBJEXT): {$(VPATH)}internal/attr/error.h
string.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
string.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
string.$(OBJEXT): {$(VPATH)}internal/attr/format.h
string.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
string.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
string.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
string.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
string.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
string.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
string.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
string.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
string.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
string.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
string.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
string.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
string.$(OBJEXT): {$(VPATH)}internal/cast.h
string.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
string.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
string.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
string.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
string.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
string.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
string.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
string.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
string.$(OBJEXT): {$(VPATH)}internal/config.h
string.$(OBJEXT): {$(VPATH)}internal/constant_p.h
string.$(OBJEXT): {$(VPATH)}internal/core.h
string.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
string.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
string.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
string.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
string.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
string.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
string.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
string.$(OBJEXT): {$(VPATH)}internal/core/rmatch.h
string.$(OBJEXT): {$(VPATH)}internal/core/robject.h
string.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
string.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
string.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
string.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
string.$(OBJEXT): {$(VPATH)}internal/ctype.h
string.$(OBJEXT): {$(VPATH)}internal/dllexport.h
string.$(OBJEXT): {$(VPATH)}internal/dosish.h
string.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
string.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
string.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
string.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
string.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
string.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
string.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
string.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
string.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
string.$(OBJEXT): {$(VPATH)}internal/error.h
string.$(OBJEXT): {$(VPATH)}internal/eval.h
string.$(OBJEXT): {$(VPATH)}internal/event.h
string.$(OBJEXT): {$(VPATH)}internal/fl_type.h
string.$(OBJEXT): {$(VPATH)}internal/gc.h
string.$(OBJEXT): {$(VPATH)}internal/glob.h
string.$(OBJEXT): {$(VPATH)}internal/globals.h
string.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
string.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
string.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
string.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
string.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
string.$(OBJEXT): {$(VPATH)}internal/has/extension.h
string.$(OBJEXT): {$(VPATH)}internal/has/feature.h
string.$(OBJEXT): {$(VPATH)}internal/has/warning.h
string.$(OBJEXT): {$(VPATH)}internal/intern/array.h
string.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
string.$(OBJEXT): {$(VPATH)}internal/intern/class.h
string.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
string.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
string.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
string.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
string.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
string.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
string.$(OBJEXT): {$(VPATH)}internal/intern/error.h
string.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
string.$(OBJEXT): {$(VPATH)}internal/intern/file.h
string.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
string.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
string.$(OBJEXT): {$(VPATH)}internal/intern/io.h
string.$(OBJEXT): {$(VPATH)}internal/intern/load.h
string.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
string.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
string.$(OBJEXT): {$(VPATH)}internal/intern/object.h
string.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
string.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
string.$(OBJEXT): {$(VPATH)}internal/intern/process.h
string.$(OBJEXT): {$(VPATH)}internal/intern/random.h
string.$(OBJEXT): {$(VPATH)}internal/intern/range.h
string.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
string.$(OBJEXT): {$(VPATH)}internal/intern/re.h
string.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
string.$(OBJEXT): {$(VPATH)}internal/intern/select.h
string.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
string.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
string.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
string.$(OBJEXT): {$(VPATH)}internal/intern/string.h
string.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
string.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
string.$(OBJEXT): {$(VPATH)}internal/intern/time.h
string.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
string.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
string.$(OBJEXT): {$(VPATH)}internal/interpreter.h
string.$(OBJEXT): {$(VPATH)}internal/iterator.h
string.$(OBJEXT): {$(VPATH)}internal/memory.h
string.$(OBJEXT): {$(VPATH)}internal/method.h
string.$(OBJEXT): {$(VPATH)}internal/module.h
string.$(OBJEXT): {$(VPATH)}internal/newobj.h
string.$(OBJEXT): {$(VPATH)}internal/rgengc.h
string.$(OBJEXT): {$(VPATH)}internal/scan_args.h
string.$(OBJEXT): {$(VPATH)}internal/special_consts.h
string.$(OBJEXT): {$(VPATH)}internal/static_assert.h
string.$(OBJEXT): {$(VPATH)}internal/stdalign.h
string.$(OBJEXT): {$(VPATH)}internal/stdbool.h
string.$(OBJEXT): {$(VPATH)}internal/symbol.h
string.$(OBJEXT): {$(VPATH)}internal/value.h
string.$(OBJEXT): {$(VPATH)}internal/value_type.h
string.$(OBJEXT): {$(VPATH)}internal/variable.h
string.$(OBJEXT): {$(VPATH)}internal/warning_push.h
string.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
string.$(OBJEXT): {$(VPATH)}missing.h
string.$(OBJEXT): {$(VPATH)}onigmo.h
string.$(OBJEXT): {$(VPATH)}oniguruma.h
string.$(OBJEXT): {$(VPATH)}probes.dmyh
string.$(OBJEXT): {$(VPATH)}probes.h
string.$(OBJEXT): {$(VPATH)}re.h
string.$(OBJEXT): {$(VPATH)}regex.h
string.$(OBJEXT): {$(VPATH)}ruby_assert.h
string.$(OBJEXT): {$(VPATH)}shape.h
string.$(OBJEXT): {$(VPATH)}st.h
string.$(OBJEXT): {$(VPATH)}string.c
string.$(OBJEXT): {$(VPATH)}subst.h
string.$(OBJEXT): {$(VPATH)}thread_native.h
string.$(OBJEXT): {$(VPATH)}util.h
string.$(OBJEXT): {$(VPATH)}vm_debug.h
string.$(OBJEXT): {$(VPATH)}vm_sync.h
strlcat.$(OBJEXT): {$(VPATH)}config.h
strlcat.$(OBJEXT): {$(VPATH)}internal/attr/format.h
strlcat.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
strlcat.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
strlcat.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
strlcat.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
strlcat.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
strlcat.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
strlcat.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
strlcat.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
strlcat.$(OBJEXT): {$(VPATH)}internal/config.h
strlcat.$(OBJEXT): {$(VPATH)}internal/dllexport.h
strlcat.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
strlcat.$(OBJEXT): {$(VPATH)}missing.h
strlcat.$(OBJEXT): {$(VPATH)}strlcat.c
strlcpy.$(OBJEXT): {$(VPATH)}config.h
strlcpy.$(OBJEXT): {$(VPATH)}internal/attr/format.h
strlcpy.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
strlcpy.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
strlcpy.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
strlcpy.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
strlcpy.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
strlcpy.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
strlcpy.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
strlcpy.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
strlcpy.$(OBJEXT): {$(VPATH)}internal/config.h
strlcpy.$(OBJEXT): {$(VPATH)}internal/dllexport.h
strlcpy.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
strlcpy.$(OBJEXT): {$(VPATH)}missing.h
strlcpy.$(OBJEXT): {$(VPATH)}strlcpy.c
struct.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
struct.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
struct.$(OBJEXT): $(CCAN_DIR)/list/list.h
struct.$(OBJEXT): $(CCAN_DIR)/str/str.h
struct.$(OBJEXT): $(hdrdir)/ruby/ruby.h
struct.$(OBJEXT): $(top_srcdir)/internal/array.h
struct.$(OBJEXT): $(top_srcdir)/internal/class.h
struct.$(OBJEXT): $(top_srcdir)/internal/compilers.h
struct.$(OBJEXT): $(top_srcdir)/internal/error.h
struct.$(OBJEXT): $(top_srcdir)/internal/gc.h
struct.$(OBJEXT): $(top_srcdir)/internal/hash.h
struct.$(OBJEXT): $(top_srcdir)/internal/imemo.h
struct.$(OBJEXT): $(top_srcdir)/internal/object.h
struct.$(OBJEXT): $(top_srcdir)/internal/proc.h
struct.$(OBJEXT): $(top_srcdir)/internal/serial.h
struct.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
struct.$(OBJEXT): $(top_srcdir)/internal/string.h
struct.$(OBJEXT): $(top_srcdir)/internal/struct.h
struct.$(OBJEXT): $(top_srcdir)/internal/symbol.h
struct.$(OBJEXT): $(top_srcdir)/internal/variable.h
struct.$(OBJEXT): $(top_srcdir)/internal/vm.h
struct.$(OBJEXT): $(top_srcdir)/internal/warnings.h
struct.$(OBJEXT): {$(VPATH)}assert.h
struct.$(OBJEXT): {$(VPATH)}atomic.h
struct.$(OBJEXT): {$(VPATH)}backward/2/assume.h
struct.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
struct.$(OBJEXT): {$(VPATH)}backward/2/bool.h
struct.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
struct.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
struct.$(OBJEXT): {$(VPATH)}backward/2/limits.h
struct.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
struct.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
struct.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
struct.$(OBJEXT): {$(VPATH)}builtin.h
struct.$(OBJEXT): {$(VPATH)}config.h
struct.$(OBJEXT): {$(VPATH)}constant.h
struct.$(OBJEXT): {$(VPATH)}defines.h
struct.$(OBJEXT): {$(VPATH)}encoding.h
struct.$(OBJEXT): {$(VPATH)}id.h
struct.$(OBJEXT): {$(VPATH)}id_table.h
struct.$(OBJEXT): {$(VPATH)}intern.h
struct.$(OBJEXT): {$(VPATH)}internal.h
struct.$(OBJEXT): {$(VPATH)}internal/abi.h
struct.$(OBJEXT): {$(VPATH)}internal/anyargs.h
struct.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
struct.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
struct.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
struct.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
struct.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
struct.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
struct.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
struct.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
struct.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
struct.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
struct.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
struct.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
struct.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
struct.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
struct.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
struct.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
struct.$(OBJEXT): {$(VPATH)}internal/assume.h
struct.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
struct.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
struct.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
struct.$(OBJEXT): {$(VPATH)}internal/attr/const.h
struct.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
struct.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
struct.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
struct.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
struct.$(OBJEXT): {$(VPATH)}internal/attr/error.h
struct.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
struct.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
struct.$(OBJEXT): {$(VPATH)}internal/attr/format.h
struct.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
struct.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
struct.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
struct.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
struct.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
struct.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
struct.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
struct.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
struct.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
struct.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
struct.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
struct.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
struct.$(OBJEXT): {$(VPATH)}internal/cast.h
struct.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
struct.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
struct.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
struct.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
struct.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
struct.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
struct.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
struct.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
struct.$(OBJEXT): {$(VPATH)}internal/config.h
struct.$(OBJEXT): {$(VPATH)}internal/constant_p.h
struct.$(OBJEXT): {$(VPATH)}internal/core.h
struct.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
struct.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
struct.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
struct.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
struct.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
struct.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
struct.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
struct.$(OBJEXT): {$(VPATH)}internal/core/robject.h
struct.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
struct.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
struct.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
struct.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
struct.$(OBJEXT): {$(VPATH)}internal/ctype.h
struct.$(OBJEXT): {$(VPATH)}internal/dllexport.h
struct.$(OBJEXT): {$(VPATH)}internal/dosish.h
struct.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
struct.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
struct.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
struct.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
struct.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
struct.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
struct.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
struct.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
struct.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
struct.$(OBJEXT): {$(VPATH)}internal/error.h
struct.$(OBJEXT): {$(VPATH)}internal/eval.h
struct.$(OBJEXT): {$(VPATH)}internal/event.h
struct.$(OBJEXT): {$(VPATH)}internal/fl_type.h
struct.$(OBJEXT): {$(VPATH)}internal/gc.h
struct.$(OBJEXT): {$(VPATH)}internal/glob.h
struct.$(OBJEXT): {$(VPATH)}internal/globals.h
struct.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
struct.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
struct.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
struct.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
struct.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
struct.$(OBJEXT): {$(VPATH)}internal/has/extension.h
struct.$(OBJEXT): {$(VPATH)}internal/has/feature.h
struct.$(OBJEXT): {$(VPATH)}internal/has/warning.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/array.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/class.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/error.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/file.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/io.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/load.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/object.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/process.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/random.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/range.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/re.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/select.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/string.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/time.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
struct.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
struct.$(OBJEXT): {$(VPATH)}internal/interpreter.h
struct.$(OBJEXT): {$(VPATH)}internal/iterator.h
struct.$(OBJEXT): {$(VPATH)}internal/memory.h
struct.$(OBJEXT): {$(VPATH)}internal/method.h
struct.$(OBJEXT): {$(VPATH)}internal/module.h
struct.$(OBJEXT): {$(VPATH)}internal/newobj.h
struct.$(OBJEXT): {$(VPATH)}internal/rgengc.h
struct.$(OBJEXT): {$(VPATH)}internal/scan_args.h
struct.$(OBJEXT): {$(VPATH)}internal/special_consts.h
struct.$(OBJEXT): {$(VPATH)}internal/static_assert.h
struct.$(OBJEXT): {$(VPATH)}internal/stdalign.h
struct.$(OBJEXT): {$(VPATH)}internal/stdbool.h
struct.$(OBJEXT): {$(VPATH)}internal/symbol.h
struct.$(OBJEXT): {$(VPATH)}internal/value.h
struct.$(OBJEXT): {$(VPATH)}internal/value_type.h
struct.$(OBJEXT): {$(VPATH)}internal/variable.h
struct.$(OBJEXT): {$(VPATH)}internal/warning_push.h
struct.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
struct.$(OBJEXT): {$(VPATH)}method.h
struct.$(OBJEXT): {$(VPATH)}missing.h
struct.$(OBJEXT): {$(VPATH)}node.h
struct.$(OBJEXT): {$(VPATH)}onigmo.h
struct.$(OBJEXT): {$(VPATH)}oniguruma.h
struct.$(OBJEXT): {$(VPATH)}ruby_assert.h
struct.$(OBJEXT): {$(VPATH)}ruby_atomic.h
struct.$(OBJEXT): {$(VPATH)}shape.h
struct.$(OBJEXT): {$(VPATH)}st.h
struct.$(OBJEXT): {$(VPATH)}struct.c
struct.$(OBJEXT): {$(VPATH)}subst.h
struct.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
struct.$(OBJEXT): {$(VPATH)}thread_native.h
struct.$(OBJEXT): {$(VPATH)}transient_heap.h
struct.$(OBJEXT): {$(VPATH)}vm_core.h
struct.$(OBJEXT): {$(VPATH)}vm_opts.h
symbol.$(OBJEXT): $(hdrdir)/ruby/ruby.h
symbol.$(OBJEXT): $(top_srcdir)/internal/class.h
symbol.$(OBJEXT): $(top_srcdir)/internal/compilers.h
symbol.$(OBJEXT): $(top_srcdir)/internal/error.h
symbol.$(OBJEXT): $(top_srcdir)/internal/gc.h
symbol.$(OBJEXT): $(top_srcdir)/internal/hash.h
symbol.$(OBJEXT): $(top_srcdir)/internal/object.h
symbol.$(OBJEXT): $(top_srcdir)/internal/serial.h
symbol.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
symbol.$(OBJEXT): $(top_srcdir)/internal/string.h
symbol.$(OBJEXT): $(top_srcdir)/internal/symbol.h
symbol.$(OBJEXT): $(top_srcdir)/internal/variable.h
symbol.$(OBJEXT): $(top_srcdir)/internal/vm.h
symbol.$(OBJEXT): $(top_srcdir)/internal/warnings.h
symbol.$(OBJEXT): {$(VPATH)}assert.h
symbol.$(OBJEXT): {$(VPATH)}backward/2/assume.h
symbol.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
symbol.$(OBJEXT): {$(VPATH)}backward/2/bool.h
symbol.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
symbol.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
symbol.$(OBJEXT): {$(VPATH)}backward/2/limits.h
symbol.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
symbol.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
symbol.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
symbol.$(OBJEXT): {$(VPATH)}builtin.h
symbol.$(OBJEXT): {$(VPATH)}config.h
symbol.$(OBJEXT): {$(VPATH)}constant.h
symbol.$(OBJEXT): {$(VPATH)}debug_counter.h
symbol.$(OBJEXT): {$(VPATH)}defines.h
symbol.$(OBJEXT): {$(VPATH)}encoding.h
symbol.$(OBJEXT): {$(VPATH)}gc.h
symbol.$(OBJEXT): {$(VPATH)}id.c
symbol.$(OBJEXT): {$(VPATH)}id.h
symbol.$(OBJEXT): {$(VPATH)}id_table.c
symbol.$(OBJEXT): {$(VPATH)}id_table.h
symbol.$(OBJEXT): {$(VPATH)}intern.h
symbol.$(OBJEXT): {$(VPATH)}internal.h
symbol.$(OBJEXT): {$(VPATH)}internal/abi.h
symbol.$(OBJEXT): {$(VPATH)}internal/anyargs.h
symbol.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
symbol.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
symbol.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
symbol.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
symbol.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
symbol.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
symbol.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
symbol.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
symbol.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
symbol.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
symbol.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
symbol.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
symbol.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
symbol.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
symbol.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
symbol.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
symbol.$(OBJEXT): {$(VPATH)}internal/assume.h
symbol.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
symbol.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
symbol.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
symbol.$(OBJEXT): {$(VPATH)}internal/attr/const.h
symbol.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
symbol.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
symbol.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
symbol.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
symbol.$(OBJEXT): {$(VPATH)}internal/attr/error.h
symbol.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
symbol.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
symbol.$(OBJEXT): {$(VPATH)}internal/attr/format.h
symbol.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
symbol.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
symbol.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
symbol.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
symbol.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
symbol.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
symbol.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
symbol.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
symbol.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
symbol.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
symbol.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
symbol.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
symbol.$(OBJEXT): {$(VPATH)}internal/cast.h
symbol.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
symbol.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
symbol.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
symbol.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
symbol.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
symbol.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
symbol.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
symbol.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
symbol.$(OBJEXT): {$(VPATH)}internal/config.h
symbol.$(OBJEXT): {$(VPATH)}internal/constant_p.h
symbol.$(OBJEXT): {$(VPATH)}internal/core.h
symbol.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
symbol.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
symbol.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
symbol.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
symbol.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
symbol.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
symbol.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
symbol.$(OBJEXT): {$(VPATH)}internal/core/robject.h
symbol.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
symbol.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
symbol.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
symbol.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
symbol.$(OBJEXT): {$(VPATH)}internal/ctype.h
symbol.$(OBJEXT): {$(VPATH)}internal/dllexport.h
symbol.$(OBJEXT): {$(VPATH)}internal/dosish.h
symbol.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
symbol.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
symbol.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
symbol.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
symbol.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
symbol.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
symbol.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
symbol.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
symbol.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
symbol.$(OBJEXT): {$(VPATH)}internal/error.h
symbol.$(OBJEXT): {$(VPATH)}internal/eval.h
symbol.$(OBJEXT): {$(VPATH)}internal/event.h
symbol.$(OBJEXT): {$(VPATH)}internal/fl_type.h
symbol.$(OBJEXT): {$(VPATH)}internal/gc.h
symbol.$(OBJEXT): {$(VPATH)}internal/glob.h
symbol.$(OBJEXT): {$(VPATH)}internal/globals.h
symbol.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
symbol.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
symbol.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
symbol.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
symbol.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
symbol.$(OBJEXT): {$(VPATH)}internal/has/extension.h
symbol.$(OBJEXT): {$(VPATH)}internal/has/feature.h
symbol.$(OBJEXT): {$(VPATH)}internal/has/warning.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/array.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/class.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/error.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/file.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/io.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/load.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/object.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/process.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/random.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/range.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/re.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/select.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/string.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/time.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
symbol.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
symbol.$(OBJEXT): {$(VPATH)}internal/interpreter.h
symbol.$(OBJEXT): {$(VPATH)}internal/iterator.h
symbol.$(OBJEXT): {$(VPATH)}internal/memory.h
symbol.$(OBJEXT): {$(VPATH)}internal/method.h
symbol.$(OBJEXT): {$(VPATH)}internal/module.h
symbol.$(OBJEXT): {$(VPATH)}internal/newobj.h
symbol.$(OBJEXT): {$(VPATH)}internal/rgengc.h
symbol.$(OBJEXT): {$(VPATH)}internal/scan_args.h
symbol.$(OBJEXT): {$(VPATH)}internal/special_consts.h
symbol.$(OBJEXT): {$(VPATH)}internal/static_assert.h
symbol.$(OBJEXT): {$(VPATH)}internal/stdalign.h
symbol.$(OBJEXT): {$(VPATH)}internal/stdbool.h
symbol.$(OBJEXT): {$(VPATH)}internal/symbol.h
symbol.$(OBJEXT): {$(VPATH)}internal/value.h
symbol.$(OBJEXT): {$(VPATH)}internal/value_type.h
symbol.$(OBJEXT): {$(VPATH)}internal/variable.h
symbol.$(OBJEXT): {$(VPATH)}internal/warning_push.h
symbol.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
symbol.$(OBJEXT): {$(VPATH)}missing.h
symbol.$(OBJEXT): {$(VPATH)}onigmo.h
symbol.$(OBJEXT): {$(VPATH)}oniguruma.h
symbol.$(OBJEXT): {$(VPATH)}probes.dmyh
symbol.$(OBJEXT): {$(VPATH)}probes.h
symbol.$(OBJEXT): {$(VPATH)}ruby_assert.h
symbol.$(OBJEXT): {$(VPATH)}shape.h
symbol.$(OBJEXT): {$(VPATH)}st.h
symbol.$(OBJEXT): {$(VPATH)}subst.h
symbol.$(OBJEXT): {$(VPATH)}symbol.c
symbol.$(OBJEXT): {$(VPATH)}symbol.h
symbol.$(OBJEXT): {$(VPATH)}symbol.rb
symbol.$(OBJEXT): {$(VPATH)}symbol.rbinc
symbol.$(OBJEXT): {$(VPATH)}vm_debug.h
symbol.$(OBJEXT): {$(VPATH)}vm_sync.h
thread.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
thread.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
thread.$(OBJEXT): $(CCAN_DIR)/list/list.h
thread.$(OBJEXT): $(CCAN_DIR)/str/str.h
thread.$(OBJEXT): $(hdrdir)/ruby.h
thread.$(OBJEXT): $(hdrdir)/ruby/ruby.h
thread.$(OBJEXT): $(top_srcdir)/internal/array.h
thread.$(OBJEXT): $(top_srcdir)/internal/bits.h
thread.$(OBJEXT): $(top_srcdir)/internal/class.h
thread.$(OBJEXT): $(top_srcdir)/internal/compilers.h
thread.$(OBJEXT): $(top_srcdir)/internal/cont.h
thread.$(OBJEXT): $(top_srcdir)/internal/error.h
thread.$(OBJEXT): $(top_srcdir)/internal/gc.h
thread.$(OBJEXT): $(top_srcdir)/internal/hash.h
thread.$(OBJEXT): $(top_srcdir)/internal/imemo.h
thread.$(OBJEXT): $(top_srcdir)/internal/io.h
thread.$(OBJEXT): $(top_srcdir)/internal/object.h
thread.$(OBJEXT): $(top_srcdir)/internal/proc.h
thread.$(OBJEXT): $(top_srcdir)/internal/serial.h
thread.$(OBJEXT): $(top_srcdir)/internal/signal.h
thread.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
thread.$(OBJEXT): $(top_srcdir)/internal/string.h
thread.$(OBJEXT): $(top_srcdir)/internal/thread.h
thread.$(OBJEXT): $(top_srcdir)/internal/time.h
thread.$(OBJEXT): $(top_srcdir)/internal/variable.h
thread.$(OBJEXT): $(top_srcdir)/internal/vm.h
thread.$(OBJEXT): $(top_srcdir)/internal/warnings.h
thread.$(OBJEXT): {$(VPATH)}assert.h
thread.$(OBJEXT): {$(VPATH)}atomic.h
thread.$(OBJEXT): {$(VPATH)}backward/2/assume.h
thread.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
thread.$(OBJEXT): {$(VPATH)}backward/2/bool.h
thread.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
thread.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
thread.$(OBJEXT): {$(VPATH)}backward/2/limits.h
thread.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
thread.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
thread.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
thread.$(OBJEXT): {$(VPATH)}builtin.h
thread.$(OBJEXT): {$(VPATH)}config.h
thread.$(OBJEXT): {$(VPATH)}constant.h
thread.$(OBJEXT): {$(VPATH)}debug.h
thread.$(OBJEXT): {$(VPATH)}debug_counter.h
thread.$(OBJEXT): {$(VPATH)}defines.h
thread.$(OBJEXT): {$(VPATH)}encoding.h
thread.$(OBJEXT): {$(VPATH)}eval_intern.h
thread.$(OBJEXT): {$(VPATH)}fiber/scheduler.h
thread.$(OBJEXT): {$(VPATH)}gc.h
thread.$(OBJEXT): {$(VPATH)}hrtime.h
thread.$(OBJEXT): {$(VPATH)}id.h
thread.$(OBJEXT): {$(VPATH)}id_table.h
thread.$(OBJEXT): {$(VPATH)}intern.h
thread.$(OBJEXT): {$(VPATH)}internal.h
thread.$(OBJEXT): {$(VPATH)}internal/abi.h
thread.$(OBJEXT): {$(VPATH)}internal/anyargs.h
thread.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
thread.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
thread.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
thread.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
thread.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
thread.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
thread.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
thread.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
thread.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
thread.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
thread.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
thread.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
thread.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
thread.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
thread.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
thread.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
thread.$(OBJEXT): {$(VPATH)}internal/assume.h
thread.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
thread.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
thread.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
thread.$(OBJEXT): {$(VPATH)}internal/attr/const.h
thread.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
thread.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
thread.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
thread.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
thread.$(OBJEXT): {$(VPATH)}internal/attr/error.h
thread.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
thread.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
thread.$(OBJEXT): {$(VPATH)}internal/attr/format.h
thread.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
thread.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
thread.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
thread.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
thread.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
thread.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
thread.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
thread.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
thread.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
thread.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
thread.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
thread.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
thread.$(OBJEXT): {$(VPATH)}internal/cast.h
thread.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
thread.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
thread.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
thread.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
thread.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
thread.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
thread.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
thread.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
thread.$(OBJEXT): {$(VPATH)}internal/config.h
thread.$(OBJEXT): {$(VPATH)}internal/constant_p.h
thread.$(OBJEXT): {$(VPATH)}internal/core.h
thread.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
thread.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
thread.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
thread.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
thread.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
thread.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
thread.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
thread.$(OBJEXT): {$(VPATH)}internal/core/robject.h
thread.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
thread.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
thread.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
thread.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
thread.$(OBJEXT): {$(VPATH)}internal/ctype.h
thread.$(OBJEXT): {$(VPATH)}internal/dllexport.h
thread.$(OBJEXT): {$(VPATH)}internal/dosish.h
thread.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
thread.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
thread.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
thread.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
thread.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
thread.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
thread.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
thread.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
thread.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
thread.$(OBJEXT): {$(VPATH)}internal/error.h
thread.$(OBJEXT): {$(VPATH)}internal/eval.h
thread.$(OBJEXT): {$(VPATH)}internal/event.h
thread.$(OBJEXT): {$(VPATH)}internal/fl_type.h
thread.$(OBJEXT): {$(VPATH)}internal/gc.h
thread.$(OBJEXT): {$(VPATH)}internal/glob.h
thread.$(OBJEXT): {$(VPATH)}internal/globals.h
thread.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
thread.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
thread.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
thread.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
thread.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
thread.$(OBJEXT): {$(VPATH)}internal/has/extension.h
thread.$(OBJEXT): {$(VPATH)}internal/has/feature.h
thread.$(OBJEXT): {$(VPATH)}internal/has/warning.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/array.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/class.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/error.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/file.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/io.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/load.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/object.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/process.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/random.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/range.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/re.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/select.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/string.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/time.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
thread.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
thread.$(OBJEXT): {$(VPATH)}internal/interpreter.h
thread.$(OBJEXT): {$(VPATH)}internal/iterator.h
thread.$(OBJEXT): {$(VPATH)}internal/memory.h
thread.$(OBJEXT): {$(VPATH)}internal/method.h
thread.$(OBJEXT): {$(VPATH)}internal/module.h
thread.$(OBJEXT): {$(VPATH)}internal/newobj.h
thread.$(OBJEXT): {$(VPATH)}internal/rgengc.h
thread.$(OBJEXT): {$(VPATH)}internal/scan_args.h
thread.$(OBJEXT): {$(VPATH)}internal/special_consts.h
thread.$(OBJEXT): {$(VPATH)}internal/static_assert.h
thread.$(OBJEXT): {$(VPATH)}internal/stdalign.h
thread.$(OBJEXT): {$(VPATH)}internal/stdbool.h
thread.$(OBJEXT): {$(VPATH)}internal/symbol.h
thread.$(OBJEXT): {$(VPATH)}internal/value.h
thread.$(OBJEXT): {$(VPATH)}internal/value_type.h
thread.$(OBJEXT): {$(VPATH)}internal/variable.h
thread.$(OBJEXT): {$(VPATH)}internal/warning_push.h
thread.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
thread.$(OBJEXT): {$(VPATH)}io.h
thread.$(OBJEXT): {$(VPATH)}iseq.h
thread.$(OBJEXT): {$(VPATH)}method.h
thread.$(OBJEXT): {$(VPATH)}missing.h
thread.$(OBJEXT): {$(VPATH)}mjit.h
thread.$(OBJEXT): {$(VPATH)}node.h
thread.$(OBJEXT): {$(VPATH)}onigmo.h
thread.$(OBJEXT): {$(VPATH)}oniguruma.h
thread.$(OBJEXT): {$(VPATH)}ractor.h
thread.$(OBJEXT): {$(VPATH)}ractor_core.h
thread.$(OBJEXT): {$(VPATH)}ruby_assert.h
thread.$(OBJEXT): {$(VPATH)}ruby_atomic.h
thread.$(OBJEXT): {$(VPATH)}shape.h
thread.$(OBJEXT): {$(VPATH)}st.h
thread.$(OBJEXT): {$(VPATH)}subst.h
thread.$(OBJEXT): {$(VPATH)}thread.c
thread.$(OBJEXT): {$(VPATH)}thread.h
thread.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).c
thread.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
thread.$(OBJEXT): {$(VPATH)}thread_native.h
thread.$(OBJEXT): {$(VPATH)}thread_sync.c
thread.$(OBJEXT): {$(VPATH)}thread_sync.rbinc
thread.$(OBJEXT): {$(VPATH)}timev.h
thread.$(OBJEXT): {$(VPATH)}vm_core.h
thread.$(OBJEXT): {$(VPATH)}vm_debug.h
thread.$(OBJEXT): {$(VPATH)}vm_opts.h
thread.$(OBJEXT): {$(VPATH)}vm_sync.h
time.$(OBJEXT): $(hdrdir)/ruby/ruby.h
time.$(OBJEXT): $(top_srcdir)/internal/array.h
time.$(OBJEXT): $(top_srcdir)/internal/bignum.h
time.$(OBJEXT): $(top_srcdir)/internal/bits.h
time.$(OBJEXT): $(top_srcdir)/internal/compar.h
time.$(OBJEXT): $(top_srcdir)/internal/compilers.h
time.$(OBJEXT): $(top_srcdir)/internal/fixnum.h
time.$(OBJEXT): $(top_srcdir)/internal/gc.h
time.$(OBJEXT): $(top_srcdir)/internal/hash.h
time.$(OBJEXT): $(top_srcdir)/internal/numeric.h
time.$(OBJEXT): $(top_srcdir)/internal/rational.h
time.$(OBJEXT): $(top_srcdir)/internal/serial.h
time.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
time.$(OBJEXT): $(top_srcdir)/internal/string.h
time.$(OBJEXT): $(top_srcdir)/internal/time.h
time.$(OBJEXT): $(top_srcdir)/internal/variable.h
time.$(OBJEXT): $(top_srcdir)/internal/vm.h
time.$(OBJEXT): $(top_srcdir)/internal/warnings.h
time.$(OBJEXT): {$(VPATH)}assert.h
time.$(OBJEXT): {$(VPATH)}backward/2/assume.h
time.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
time.$(OBJEXT): {$(VPATH)}backward/2/bool.h
time.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
time.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
time.$(OBJEXT): {$(VPATH)}backward/2/limits.h
time.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
time.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
time.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
time.$(OBJEXT): {$(VPATH)}builtin.h
time.$(OBJEXT): {$(VPATH)}config.h
time.$(OBJEXT): {$(VPATH)}constant.h
time.$(OBJEXT): {$(VPATH)}defines.h
time.$(OBJEXT): {$(VPATH)}encoding.h
time.$(OBJEXT): {$(VPATH)}id.h
time.$(OBJEXT): {$(VPATH)}id_table.h
time.$(OBJEXT): {$(VPATH)}intern.h
time.$(OBJEXT): {$(VPATH)}internal.h
time.$(OBJEXT): {$(VPATH)}internal/abi.h
time.$(OBJEXT): {$(VPATH)}internal/anyargs.h
time.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
time.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
time.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
time.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
time.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
time.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
time.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
time.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
time.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
time.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
time.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
time.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
time.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
time.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
time.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
time.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
time.$(OBJEXT): {$(VPATH)}internal/assume.h
time.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
time.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
time.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
time.$(OBJEXT): {$(VPATH)}internal/attr/const.h
time.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
time.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
time.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
time.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
time.$(OBJEXT): {$(VPATH)}internal/attr/error.h
time.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
time.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
time.$(OBJEXT): {$(VPATH)}internal/attr/format.h
time.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
time.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
time.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
time.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
time.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
time.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
time.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
time.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
time.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
time.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
time.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
time.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
time.$(OBJEXT): {$(VPATH)}internal/cast.h
time.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
time.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
time.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
time.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
time.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
time.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
time.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
time.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
time.$(OBJEXT): {$(VPATH)}internal/config.h
time.$(OBJEXT): {$(VPATH)}internal/constant_p.h
time.$(OBJEXT): {$(VPATH)}internal/core.h
time.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
time.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
time.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
time.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
time.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
time.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
time.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
time.$(OBJEXT): {$(VPATH)}internal/core/robject.h
time.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
time.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
time.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
time.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
time.$(OBJEXT): {$(VPATH)}internal/ctype.h
time.$(OBJEXT): {$(VPATH)}internal/dllexport.h
time.$(OBJEXT): {$(VPATH)}internal/dosish.h
time.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
time.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
time.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
time.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
time.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
time.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
time.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
time.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
time.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
time.$(OBJEXT): {$(VPATH)}internal/error.h
time.$(OBJEXT): {$(VPATH)}internal/eval.h
time.$(OBJEXT): {$(VPATH)}internal/event.h
time.$(OBJEXT): {$(VPATH)}internal/fl_type.h
time.$(OBJEXT): {$(VPATH)}internal/gc.h
time.$(OBJEXT): {$(VPATH)}internal/glob.h
time.$(OBJEXT): {$(VPATH)}internal/globals.h
time.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
time.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
time.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
time.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
time.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
time.$(OBJEXT): {$(VPATH)}internal/has/extension.h
time.$(OBJEXT): {$(VPATH)}internal/has/feature.h
time.$(OBJEXT): {$(VPATH)}internal/has/warning.h
time.$(OBJEXT): {$(VPATH)}internal/intern/array.h
time.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
time.$(OBJEXT): {$(VPATH)}internal/intern/class.h
time.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
time.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
time.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
time.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
time.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
time.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
time.$(OBJEXT): {$(VPATH)}internal/intern/error.h
time.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
time.$(OBJEXT): {$(VPATH)}internal/intern/file.h
time.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
time.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
time.$(OBJEXT): {$(VPATH)}internal/intern/io.h
time.$(OBJEXT): {$(VPATH)}internal/intern/load.h
time.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
time.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
time.$(OBJEXT): {$(VPATH)}internal/intern/object.h
time.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
time.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
time.$(OBJEXT): {$(VPATH)}internal/intern/process.h
time.$(OBJEXT): {$(VPATH)}internal/intern/random.h
time.$(OBJEXT): {$(VPATH)}internal/intern/range.h
time.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
time.$(OBJEXT): {$(VPATH)}internal/intern/re.h
time.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
time.$(OBJEXT): {$(VPATH)}internal/intern/select.h
time.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
time.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
time.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
time.$(OBJEXT): {$(VPATH)}internal/intern/string.h
time.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
time.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
time.$(OBJEXT): {$(VPATH)}internal/intern/time.h
time.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
time.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
time.$(OBJEXT): {$(VPATH)}internal/interpreter.h
time.$(OBJEXT): {$(VPATH)}internal/iterator.h
time.$(OBJEXT): {$(VPATH)}internal/memory.h
time.$(OBJEXT): {$(VPATH)}internal/method.h
time.$(OBJEXT): {$(VPATH)}internal/module.h
time.$(OBJEXT): {$(VPATH)}internal/newobj.h
time.$(OBJEXT): {$(VPATH)}internal/rgengc.h
time.$(OBJEXT): {$(VPATH)}internal/scan_args.h
time.$(OBJEXT): {$(VPATH)}internal/special_consts.h
time.$(OBJEXT): {$(VPATH)}internal/static_assert.h
time.$(OBJEXT): {$(VPATH)}internal/stdalign.h
time.$(OBJEXT): {$(VPATH)}internal/stdbool.h
time.$(OBJEXT): {$(VPATH)}internal/symbol.h
time.$(OBJEXT): {$(VPATH)}internal/value.h
time.$(OBJEXT): {$(VPATH)}internal/value_type.h
time.$(OBJEXT): {$(VPATH)}internal/variable.h
time.$(OBJEXT): {$(VPATH)}internal/warning_push.h
time.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
time.$(OBJEXT): {$(VPATH)}missing.h
time.$(OBJEXT): {$(VPATH)}onigmo.h
time.$(OBJEXT): {$(VPATH)}oniguruma.h
time.$(OBJEXT): {$(VPATH)}ruby_assert.h
time.$(OBJEXT): {$(VPATH)}shape.h
time.$(OBJEXT): {$(VPATH)}st.h
time.$(OBJEXT): {$(VPATH)}subst.h
time.$(OBJEXT): {$(VPATH)}time.c
time.$(OBJEXT): {$(VPATH)}timev.h
time.$(OBJEXT): {$(VPATH)}timev.rbinc
transcode.$(OBJEXT): $(hdrdir)/ruby/ruby.h
transcode.$(OBJEXT): $(top_srcdir)/internal/array.h
transcode.$(OBJEXT): $(top_srcdir)/internal/class.h
transcode.$(OBJEXT): $(top_srcdir)/internal/compilers.h
transcode.$(OBJEXT): $(top_srcdir)/internal/gc.h
transcode.$(OBJEXT): $(top_srcdir)/internal/inits.h
transcode.$(OBJEXT): $(top_srcdir)/internal/object.h
transcode.$(OBJEXT): $(top_srcdir)/internal/serial.h
transcode.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
transcode.$(OBJEXT): $(top_srcdir)/internal/string.h
transcode.$(OBJEXT): $(top_srcdir)/internal/transcode.h
transcode.$(OBJEXT): $(top_srcdir)/internal/variable.h
transcode.$(OBJEXT): $(top_srcdir)/internal/warnings.h
transcode.$(OBJEXT): {$(VPATH)}assert.h
transcode.$(OBJEXT): {$(VPATH)}backward/2/assume.h
transcode.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
transcode.$(OBJEXT): {$(VPATH)}backward/2/bool.h
transcode.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
transcode.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
transcode.$(OBJEXT): {$(VPATH)}backward/2/limits.h
transcode.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
transcode.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
transcode.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
transcode.$(OBJEXT): {$(VPATH)}config.h
transcode.$(OBJEXT): {$(VPATH)}constant.h
transcode.$(OBJEXT): {$(VPATH)}defines.h
transcode.$(OBJEXT): {$(VPATH)}encoding.h
transcode.$(OBJEXT): {$(VPATH)}id.h
transcode.$(OBJEXT): {$(VPATH)}id_table.h
transcode.$(OBJEXT): {$(VPATH)}intern.h
transcode.$(OBJEXT): {$(VPATH)}internal.h
transcode.$(OBJEXT): {$(VPATH)}internal/abi.h
transcode.$(OBJEXT): {$(VPATH)}internal/anyargs.h
transcode.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
transcode.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
transcode.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
transcode.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
transcode.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
transcode.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
transcode.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
transcode.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
transcode.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
transcode.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
transcode.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
transcode.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
transcode.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
transcode.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
transcode.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
transcode.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
transcode.$(OBJEXT): {$(VPATH)}internal/assume.h
transcode.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
transcode.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
transcode.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
transcode.$(OBJEXT): {$(VPATH)}internal/attr/const.h
transcode.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
transcode.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
transcode.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
transcode.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
transcode.$(OBJEXT): {$(VPATH)}internal/attr/error.h
transcode.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
transcode.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
transcode.$(OBJEXT): {$(VPATH)}internal/attr/format.h
transcode.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
transcode.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
transcode.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
transcode.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
transcode.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
transcode.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
transcode.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
transcode.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
transcode.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
transcode.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
transcode.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
transcode.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
transcode.$(OBJEXT): {$(VPATH)}internal/cast.h
transcode.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
transcode.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
transcode.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
transcode.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
transcode.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
transcode.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
transcode.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
transcode.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
transcode.$(OBJEXT): {$(VPATH)}internal/config.h
transcode.$(OBJEXT): {$(VPATH)}internal/constant_p.h
transcode.$(OBJEXT): {$(VPATH)}internal/core.h
transcode.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
transcode.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
transcode.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
transcode.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
transcode.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
transcode.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
transcode.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
transcode.$(OBJEXT): {$(VPATH)}internal/core/robject.h
transcode.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
transcode.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
transcode.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
transcode.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
transcode.$(OBJEXT): {$(VPATH)}internal/ctype.h
transcode.$(OBJEXT): {$(VPATH)}internal/dllexport.h
transcode.$(OBJEXT): {$(VPATH)}internal/dosish.h
transcode.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
transcode.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
transcode.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
transcode.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
transcode.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
transcode.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
transcode.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
transcode.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
transcode.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
transcode.$(OBJEXT): {$(VPATH)}internal/error.h
transcode.$(OBJEXT): {$(VPATH)}internal/eval.h
transcode.$(OBJEXT): {$(VPATH)}internal/event.h
transcode.$(OBJEXT): {$(VPATH)}internal/fl_type.h
transcode.$(OBJEXT): {$(VPATH)}internal/gc.h
transcode.$(OBJEXT): {$(VPATH)}internal/glob.h
transcode.$(OBJEXT): {$(VPATH)}internal/globals.h
transcode.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
transcode.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
transcode.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
transcode.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
transcode.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
transcode.$(OBJEXT): {$(VPATH)}internal/has/extension.h
transcode.$(OBJEXT): {$(VPATH)}internal/has/feature.h
transcode.$(OBJEXT): {$(VPATH)}internal/has/warning.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/array.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/class.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/error.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/file.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/io.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/load.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/object.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/process.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/random.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/range.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/re.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/select.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/string.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/time.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
transcode.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
transcode.$(OBJEXT): {$(VPATH)}internal/interpreter.h
transcode.$(OBJEXT): {$(VPATH)}internal/iterator.h
transcode.$(OBJEXT): {$(VPATH)}internal/memory.h
transcode.$(OBJEXT): {$(VPATH)}internal/method.h
transcode.$(OBJEXT): {$(VPATH)}internal/module.h
transcode.$(OBJEXT): {$(VPATH)}internal/newobj.h
transcode.$(OBJEXT): {$(VPATH)}internal/rgengc.h
transcode.$(OBJEXT): {$(VPATH)}internal/scan_args.h
transcode.$(OBJEXT): {$(VPATH)}internal/special_consts.h
transcode.$(OBJEXT): {$(VPATH)}internal/static_assert.h
transcode.$(OBJEXT): {$(VPATH)}internal/stdalign.h
transcode.$(OBJEXT): {$(VPATH)}internal/stdbool.h
transcode.$(OBJEXT): {$(VPATH)}internal/symbol.h
transcode.$(OBJEXT): {$(VPATH)}internal/value.h
transcode.$(OBJEXT): {$(VPATH)}internal/value_type.h
transcode.$(OBJEXT): {$(VPATH)}internal/variable.h
transcode.$(OBJEXT): {$(VPATH)}internal/warning_push.h
transcode.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
transcode.$(OBJEXT): {$(VPATH)}missing.h
transcode.$(OBJEXT): {$(VPATH)}onigmo.h
transcode.$(OBJEXT): {$(VPATH)}oniguruma.h
transcode.$(OBJEXT): {$(VPATH)}shape.h
transcode.$(OBJEXT): {$(VPATH)}st.h
transcode.$(OBJEXT): {$(VPATH)}subst.h
transcode.$(OBJEXT): {$(VPATH)}transcode.c
transcode.$(OBJEXT): {$(VPATH)}transcode_data.h
transient_heap.$(OBJEXT): $(hdrdir)/ruby/ruby.h
transient_heap.$(OBJEXT): $(top_srcdir)/internal/array.h
transient_heap.$(OBJEXT): $(top_srcdir)/internal/compilers.h
transient_heap.$(OBJEXT): $(top_srcdir)/internal/gc.h
transient_heap.$(OBJEXT): $(top_srcdir)/internal/hash.h
transient_heap.$(OBJEXT): $(top_srcdir)/internal/sanitizers.h
transient_heap.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
transient_heap.$(OBJEXT): $(top_srcdir)/internal/struct.h
transient_heap.$(OBJEXT): $(top_srcdir)/internal/variable.h
transient_heap.$(OBJEXT): $(top_srcdir)/internal/warnings.h
transient_heap.$(OBJEXT): {$(VPATH)}assert.h
transient_heap.$(OBJEXT): {$(VPATH)}backward/2/assume.h
transient_heap.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
transient_heap.$(OBJEXT): {$(VPATH)}backward/2/bool.h
transient_heap.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
transient_heap.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
transient_heap.$(OBJEXT): {$(VPATH)}backward/2/limits.h
transient_heap.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
transient_heap.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
transient_heap.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
transient_heap.$(OBJEXT): {$(VPATH)}config.h
transient_heap.$(OBJEXT): {$(VPATH)}constant.h
transient_heap.$(OBJEXT): {$(VPATH)}debug.h
transient_heap.$(OBJEXT): {$(VPATH)}debug_counter.h
transient_heap.$(OBJEXT): {$(VPATH)}defines.h
transient_heap.$(OBJEXT): {$(VPATH)}gc.h
transient_heap.$(OBJEXT): {$(VPATH)}id_table.h
transient_heap.$(OBJEXT): {$(VPATH)}intern.h
transient_heap.$(OBJEXT): {$(VPATH)}internal.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/abi.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/anyargs.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/assume.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/attr/const.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/attr/error.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/attr/format.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/cast.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/config.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/constant_p.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/core.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/core/robject.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/ctype.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/dllexport.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/dosish.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/error.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/eval.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/event.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/fl_type.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/gc.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/glob.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/globals.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/has/extension.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/has/feature.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/has/warning.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/array.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/class.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/error.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/file.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/io.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/load.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/object.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/process.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/random.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/range.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/re.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/select.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/string.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/time.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/interpreter.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/iterator.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/memory.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/method.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/module.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/newobj.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/rgengc.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/scan_args.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/special_consts.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/static_assert.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/stdalign.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/stdbool.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/symbol.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/value.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/value_type.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/variable.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/warning_push.h
transient_heap.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
transient_heap.$(OBJEXT): {$(VPATH)}missing.h
transient_heap.$(OBJEXT): {$(VPATH)}ruby_assert.h
transient_heap.$(OBJEXT): {$(VPATH)}shape.h
transient_heap.$(OBJEXT): {$(VPATH)}st.h
transient_heap.$(OBJEXT): {$(VPATH)}subst.h
transient_heap.$(OBJEXT): {$(VPATH)}transient_heap.c
transient_heap.$(OBJEXT): {$(VPATH)}transient_heap.h
transient_heap.$(OBJEXT): {$(VPATH)}vm_debug.h
transient_heap.$(OBJEXT): {$(VPATH)}vm_sync.h
util.$(OBJEXT): $(hdrdir)/ruby/ruby.h
util.$(OBJEXT): $(top_srcdir)/internal/compilers.h
util.$(OBJEXT): $(top_srcdir)/internal/sanitizers.h
util.$(OBJEXT): $(top_srcdir)/internal/util.h
util.$(OBJEXT): $(top_srcdir)/internal/warnings.h
util.$(OBJEXT): {$(VPATH)}assert.h
util.$(OBJEXT): {$(VPATH)}atomic.h
util.$(OBJEXT): {$(VPATH)}backward/2/assume.h
util.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
util.$(OBJEXT): {$(VPATH)}backward/2/bool.h
util.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
util.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
util.$(OBJEXT): {$(VPATH)}backward/2/limits.h
util.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
util.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
util.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
util.$(OBJEXT): {$(VPATH)}config.h
util.$(OBJEXT): {$(VPATH)}defines.h
util.$(OBJEXT): {$(VPATH)}dtoa.c
util.$(OBJEXT): {$(VPATH)}intern.h
util.$(OBJEXT): {$(VPATH)}internal.h
util.$(OBJEXT): {$(VPATH)}internal/abi.h
util.$(OBJEXT): {$(VPATH)}internal/anyargs.h
util.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
util.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
util.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
util.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
util.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
util.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
util.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
util.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
util.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
util.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
util.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
util.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
util.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
util.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
util.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
util.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
util.$(OBJEXT): {$(VPATH)}internal/assume.h
util.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
util.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
util.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
util.$(OBJEXT): {$(VPATH)}internal/attr/const.h
util.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
util.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
util.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
util.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
util.$(OBJEXT): {$(VPATH)}internal/attr/error.h
util.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
util.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
util.$(OBJEXT): {$(VPATH)}internal/attr/format.h
util.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
util.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
util.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
util.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
util.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
util.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
util.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
util.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
util.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
util.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
util.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
util.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
util.$(OBJEXT): {$(VPATH)}internal/cast.h
util.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
util.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
util.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
util.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
util.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
util.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
util.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
util.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
util.$(OBJEXT): {$(VPATH)}internal/config.h
util.$(OBJEXT): {$(VPATH)}internal/constant_p.h
util.$(OBJEXT): {$(VPATH)}internal/core.h
util.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
util.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
util.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
util.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
util.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
util.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
util.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
util.$(OBJEXT): {$(VPATH)}internal/core/robject.h
util.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
util.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
util.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
util.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
util.$(OBJEXT): {$(VPATH)}internal/ctype.h
util.$(OBJEXT): {$(VPATH)}internal/dllexport.h
util.$(OBJEXT): {$(VPATH)}internal/dosish.h
util.$(OBJEXT): {$(VPATH)}internal/error.h
util.$(OBJEXT): {$(VPATH)}internal/eval.h
util.$(OBJEXT): {$(VPATH)}internal/event.h
util.$(OBJEXT): {$(VPATH)}internal/fl_type.h
util.$(OBJEXT): {$(VPATH)}internal/gc.h
util.$(OBJEXT): {$(VPATH)}internal/glob.h
util.$(OBJEXT): {$(VPATH)}internal/globals.h
util.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
util.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
util.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
util.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
util.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
util.$(OBJEXT): {$(VPATH)}internal/has/extension.h
util.$(OBJEXT): {$(VPATH)}internal/has/feature.h
util.$(OBJEXT): {$(VPATH)}internal/has/warning.h
util.$(OBJEXT): {$(VPATH)}internal/intern/array.h
util.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
util.$(OBJEXT): {$(VPATH)}internal/intern/class.h
util.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
util.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
util.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
util.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
util.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
util.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
util.$(OBJEXT): {$(VPATH)}internal/intern/error.h
util.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
util.$(OBJEXT): {$(VPATH)}internal/intern/file.h
util.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
util.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
util.$(OBJEXT): {$(VPATH)}internal/intern/io.h
util.$(OBJEXT): {$(VPATH)}internal/intern/load.h
util.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
util.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
util.$(OBJEXT): {$(VPATH)}internal/intern/object.h
util.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
util.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
util.$(OBJEXT): {$(VPATH)}internal/intern/process.h
util.$(OBJEXT): {$(VPATH)}internal/intern/random.h
util.$(OBJEXT): {$(VPATH)}internal/intern/range.h
util.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
util.$(OBJEXT): {$(VPATH)}internal/intern/re.h
util.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
util.$(OBJEXT): {$(VPATH)}internal/intern/select.h
util.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
util.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
util.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
util.$(OBJEXT): {$(VPATH)}internal/intern/string.h
util.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
util.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
util.$(OBJEXT): {$(VPATH)}internal/intern/time.h
util.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
util.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
util.$(OBJEXT): {$(VPATH)}internal/interpreter.h
util.$(OBJEXT): {$(VPATH)}internal/iterator.h
util.$(OBJEXT): {$(VPATH)}internal/memory.h
util.$(OBJEXT): {$(VPATH)}internal/method.h
util.$(OBJEXT): {$(VPATH)}internal/module.h
util.$(OBJEXT): {$(VPATH)}internal/newobj.h
util.$(OBJEXT): {$(VPATH)}internal/rgengc.h
util.$(OBJEXT): {$(VPATH)}internal/scan_args.h
util.$(OBJEXT): {$(VPATH)}internal/special_consts.h
util.$(OBJEXT): {$(VPATH)}internal/static_assert.h
util.$(OBJEXT): {$(VPATH)}internal/stdalign.h
util.$(OBJEXT): {$(VPATH)}internal/stdbool.h
util.$(OBJEXT): {$(VPATH)}internal/symbol.h
util.$(OBJEXT): {$(VPATH)}internal/value.h
util.$(OBJEXT): {$(VPATH)}internal/value_type.h
util.$(OBJEXT): {$(VPATH)}internal/variable.h
util.$(OBJEXT): {$(VPATH)}internal/warning_push.h
util.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
util.$(OBJEXT): {$(VPATH)}missing.h
util.$(OBJEXT): {$(VPATH)}ruby_atomic.h
util.$(OBJEXT): {$(VPATH)}st.h
util.$(OBJEXT): {$(VPATH)}subst.h
util.$(OBJEXT): {$(VPATH)}util.c
util.$(OBJEXT): {$(VPATH)}util.h
variable.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
variable.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
variable.$(OBJEXT): $(CCAN_DIR)/list/list.h
variable.$(OBJEXT): $(CCAN_DIR)/str/str.h
variable.$(OBJEXT): $(hdrdir)/ruby/ruby.h
variable.$(OBJEXT): $(top_srcdir)/internal/array.h
variable.$(OBJEXT): $(top_srcdir)/internal/class.h
variable.$(OBJEXT): $(top_srcdir)/internal/compilers.h
variable.$(OBJEXT): $(top_srcdir)/internal/error.h
variable.$(OBJEXT): $(top_srcdir)/internal/eval.h
variable.$(OBJEXT): $(top_srcdir)/internal/gc.h
variable.$(OBJEXT): $(top_srcdir)/internal/hash.h
variable.$(OBJEXT): $(top_srcdir)/internal/imemo.h
variable.$(OBJEXT): $(top_srcdir)/internal/object.h
variable.$(OBJEXT): $(top_srcdir)/internal/re.h
variable.$(OBJEXT): $(top_srcdir)/internal/serial.h
variable.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
variable.$(OBJEXT): $(top_srcdir)/internal/string.h
variable.$(OBJEXT): $(top_srcdir)/internal/symbol.h
variable.$(OBJEXT): $(top_srcdir)/internal/thread.h
variable.$(OBJEXT): $(top_srcdir)/internal/variable.h
variable.$(OBJEXT): $(top_srcdir)/internal/vm.h
variable.$(OBJEXT): $(top_srcdir)/internal/warnings.h
variable.$(OBJEXT): {$(VPATH)}assert.h
variable.$(OBJEXT): {$(VPATH)}atomic.h
variable.$(OBJEXT): {$(VPATH)}backward/2/assume.h
variable.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
variable.$(OBJEXT): {$(VPATH)}backward/2/bool.h
variable.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
variable.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
variable.$(OBJEXT): {$(VPATH)}backward/2/limits.h
variable.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
variable.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
variable.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
variable.$(OBJEXT): {$(VPATH)}config.h
variable.$(OBJEXT): {$(VPATH)}constant.h
variable.$(OBJEXT): {$(VPATH)}debug_counter.h
variable.$(OBJEXT): {$(VPATH)}defines.h
variable.$(OBJEXT): {$(VPATH)}encoding.h
variable.$(OBJEXT): {$(VPATH)}id.h
variable.$(OBJEXT): {$(VPATH)}id_table.h
variable.$(OBJEXT): {$(VPATH)}intern.h
variable.$(OBJEXT): {$(VPATH)}internal.h
variable.$(OBJEXT): {$(VPATH)}internal/abi.h
variable.$(OBJEXT): {$(VPATH)}internal/anyargs.h
variable.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
variable.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
variable.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
variable.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
variable.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
variable.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
variable.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
variable.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
variable.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
variable.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
variable.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
variable.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
variable.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
variable.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
variable.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
variable.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
variable.$(OBJEXT): {$(VPATH)}internal/assume.h
variable.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
variable.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
variable.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
variable.$(OBJEXT): {$(VPATH)}internal/attr/const.h
variable.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
variable.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
variable.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
variable.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
variable.$(OBJEXT): {$(VPATH)}internal/attr/error.h
variable.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
variable.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
variable.$(OBJEXT): {$(VPATH)}internal/attr/format.h
variable.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
variable.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
variable.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
variable.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
variable.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
variable.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
variable.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
variable.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
variable.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
variable.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
variable.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
variable.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
variable.$(OBJEXT): {$(VPATH)}internal/cast.h
variable.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
variable.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
variable.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
variable.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
variable.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
variable.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
variable.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
variable.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
variable.$(OBJEXT): {$(VPATH)}internal/config.h
variable.$(OBJEXT): {$(VPATH)}internal/constant_p.h
variable.$(OBJEXT): {$(VPATH)}internal/core.h
variable.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
variable.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
variable.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
variable.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
variable.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
variable.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
variable.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
variable.$(OBJEXT): {$(VPATH)}internal/core/robject.h
variable.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
variable.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
variable.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
variable.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
variable.$(OBJEXT): {$(VPATH)}internal/ctype.h
variable.$(OBJEXT): {$(VPATH)}internal/dllexport.h
variable.$(OBJEXT): {$(VPATH)}internal/dosish.h
variable.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
variable.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
variable.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
variable.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
variable.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
variable.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
variable.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
variable.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
variable.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
variable.$(OBJEXT): {$(VPATH)}internal/error.h
variable.$(OBJEXT): {$(VPATH)}internal/eval.h
variable.$(OBJEXT): {$(VPATH)}internal/event.h
variable.$(OBJEXT): {$(VPATH)}internal/fl_type.h
variable.$(OBJEXT): {$(VPATH)}internal/gc.h
variable.$(OBJEXT): {$(VPATH)}internal/glob.h
variable.$(OBJEXT): {$(VPATH)}internal/globals.h
variable.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
variable.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
variable.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
variable.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
variable.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
variable.$(OBJEXT): {$(VPATH)}internal/has/extension.h
variable.$(OBJEXT): {$(VPATH)}internal/has/feature.h
variable.$(OBJEXT): {$(VPATH)}internal/has/warning.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/array.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/class.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/error.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/file.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/io.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/load.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/object.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/process.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/random.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/range.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/re.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/select.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/string.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/time.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
variable.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
variable.$(OBJEXT): {$(VPATH)}internal/interpreter.h
variable.$(OBJEXT): {$(VPATH)}internal/iterator.h
variable.$(OBJEXT): {$(VPATH)}internal/memory.h
variable.$(OBJEXT): {$(VPATH)}internal/method.h
variable.$(OBJEXT): {$(VPATH)}internal/module.h
variable.$(OBJEXT): {$(VPATH)}internal/newobj.h
variable.$(OBJEXT): {$(VPATH)}internal/rgengc.h
variable.$(OBJEXT): {$(VPATH)}internal/scan_args.h
variable.$(OBJEXT): {$(VPATH)}internal/special_consts.h
variable.$(OBJEXT): {$(VPATH)}internal/static_assert.h
variable.$(OBJEXT): {$(VPATH)}internal/stdalign.h
variable.$(OBJEXT): {$(VPATH)}internal/stdbool.h
variable.$(OBJEXT): {$(VPATH)}internal/symbol.h
variable.$(OBJEXT): {$(VPATH)}internal/value.h
variable.$(OBJEXT): {$(VPATH)}internal/value_type.h
variable.$(OBJEXT): {$(VPATH)}internal/variable.h
variable.$(OBJEXT): {$(VPATH)}internal/warning_push.h
variable.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
variable.$(OBJEXT): {$(VPATH)}method.h
variable.$(OBJEXT): {$(VPATH)}missing.h
variable.$(OBJEXT): {$(VPATH)}node.h
variable.$(OBJEXT): {$(VPATH)}onigmo.h
variable.$(OBJEXT): {$(VPATH)}oniguruma.h
variable.$(OBJEXT): {$(VPATH)}ractor.h
variable.$(OBJEXT): {$(VPATH)}ractor_core.h
variable.$(OBJEXT): {$(VPATH)}ruby_assert.h
variable.$(OBJEXT): {$(VPATH)}ruby_atomic.h
variable.$(OBJEXT): {$(VPATH)}shape.h
variable.$(OBJEXT): {$(VPATH)}st.h
variable.$(OBJEXT): {$(VPATH)}subst.h
variable.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
variable.$(OBJEXT): {$(VPATH)}thread_native.h
variable.$(OBJEXT): {$(VPATH)}transient_heap.h
variable.$(OBJEXT): {$(VPATH)}util.h
variable.$(OBJEXT): {$(VPATH)}variable.c
variable.$(OBJEXT): {$(VPATH)}variable.h
variable.$(OBJEXT): {$(VPATH)}vm_core.h
variable.$(OBJEXT): {$(VPATH)}vm_debug.h
variable.$(OBJEXT): {$(VPATH)}vm_opts.h
variable.$(OBJEXT): {$(VPATH)}vm_sync.h
version.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
version.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
version.$(OBJEXT): $(CCAN_DIR)/list/list.h
version.$(OBJEXT): $(CCAN_DIR)/str/str.h
version.$(OBJEXT): $(hdrdir)/ruby.h
version.$(OBJEXT): $(hdrdir)/ruby/ruby.h
version.$(OBJEXT): $(hdrdir)/ruby/version.h
version.$(OBJEXT): $(top_srcdir)/internal/array.h
version.$(OBJEXT): $(top_srcdir)/internal/cmdlineopt.h
version.$(OBJEXT): $(top_srcdir)/internal/compilers.h
version.$(OBJEXT): $(top_srcdir)/internal/gc.h
version.$(OBJEXT): $(top_srcdir)/internal/imemo.h
version.$(OBJEXT): $(top_srcdir)/internal/serial.h
version.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
version.$(OBJEXT): $(top_srcdir)/internal/variable.h
version.$(OBJEXT): $(top_srcdir)/internal/vm.h
version.$(OBJEXT): $(top_srcdir)/internal/warnings.h
version.$(OBJEXT): $(top_srcdir)/version.h
version.$(OBJEXT): {$(VPATH)}assert.h
version.$(OBJEXT): {$(VPATH)}atomic.h
version.$(OBJEXT): {$(VPATH)}backward/2/assume.h
version.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
version.$(OBJEXT): {$(VPATH)}backward/2/bool.h
version.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
version.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
version.$(OBJEXT): {$(VPATH)}backward/2/limits.h
version.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
version.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
version.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
version.$(OBJEXT): {$(VPATH)}config.h
version.$(OBJEXT): {$(VPATH)}constant.h
version.$(OBJEXT): {$(VPATH)}debug_counter.h
version.$(OBJEXT): {$(VPATH)}defines.h
version.$(OBJEXT): {$(VPATH)}id.h
version.$(OBJEXT): {$(VPATH)}id_table.h
version.$(OBJEXT): {$(VPATH)}intern.h
version.$(OBJEXT): {$(VPATH)}internal.h
version.$(OBJEXT): {$(VPATH)}internal/abi.h
version.$(OBJEXT): {$(VPATH)}internal/anyargs.h
version.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
version.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
version.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
version.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
version.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
version.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
version.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
version.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
version.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
version.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
version.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
version.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
version.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
version.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
version.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
version.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
version.$(OBJEXT): {$(VPATH)}internal/assume.h
version.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
version.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
version.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
version.$(OBJEXT): {$(VPATH)}internal/attr/const.h
version.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
version.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
version.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
version.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
version.$(OBJEXT): {$(VPATH)}internal/attr/error.h
version.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
version.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
version.$(OBJEXT): {$(VPATH)}internal/attr/format.h
version.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
version.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
version.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
version.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
version.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
version.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
version.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
version.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
version.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
version.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
version.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
version.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
version.$(OBJEXT): {$(VPATH)}internal/cast.h
version.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
version.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
version.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
version.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
version.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
version.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
version.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
version.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
version.$(OBJEXT): {$(VPATH)}internal/config.h
version.$(OBJEXT): {$(VPATH)}internal/constant_p.h
version.$(OBJEXT): {$(VPATH)}internal/core.h
version.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
version.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
version.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
version.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
version.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
version.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
version.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
version.$(OBJEXT): {$(VPATH)}internal/core/robject.h
version.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
version.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
version.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
version.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
version.$(OBJEXT): {$(VPATH)}internal/ctype.h
version.$(OBJEXT): {$(VPATH)}internal/dllexport.h
version.$(OBJEXT): {$(VPATH)}internal/dosish.h
version.$(OBJEXT): {$(VPATH)}internal/error.h
version.$(OBJEXT): {$(VPATH)}internal/eval.h
version.$(OBJEXT): {$(VPATH)}internal/event.h
version.$(OBJEXT): {$(VPATH)}internal/fl_type.h
version.$(OBJEXT): {$(VPATH)}internal/gc.h
version.$(OBJEXT): {$(VPATH)}internal/glob.h
version.$(OBJEXT): {$(VPATH)}internal/globals.h
version.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
version.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
version.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
version.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
version.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
version.$(OBJEXT): {$(VPATH)}internal/has/extension.h
version.$(OBJEXT): {$(VPATH)}internal/has/feature.h
version.$(OBJEXT): {$(VPATH)}internal/has/warning.h
version.$(OBJEXT): {$(VPATH)}internal/intern/array.h
version.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
version.$(OBJEXT): {$(VPATH)}internal/intern/class.h
version.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
version.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
version.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
version.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
version.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
version.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
version.$(OBJEXT): {$(VPATH)}internal/intern/error.h
version.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
version.$(OBJEXT): {$(VPATH)}internal/intern/file.h
version.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
version.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
version.$(OBJEXT): {$(VPATH)}internal/intern/io.h
version.$(OBJEXT): {$(VPATH)}internal/intern/load.h
version.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
version.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
version.$(OBJEXT): {$(VPATH)}internal/intern/object.h
version.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
version.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
version.$(OBJEXT): {$(VPATH)}internal/intern/process.h
version.$(OBJEXT): {$(VPATH)}internal/intern/random.h
version.$(OBJEXT): {$(VPATH)}internal/intern/range.h
version.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
version.$(OBJEXT): {$(VPATH)}internal/intern/re.h
version.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
version.$(OBJEXT): {$(VPATH)}internal/intern/select.h
version.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
version.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
version.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
version.$(OBJEXT): {$(VPATH)}internal/intern/string.h
version.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
version.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
version.$(OBJEXT): {$(VPATH)}internal/intern/time.h
version.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
version.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
version.$(OBJEXT): {$(VPATH)}internal/interpreter.h
version.$(OBJEXT): {$(VPATH)}internal/iterator.h
version.$(OBJEXT): {$(VPATH)}internal/memory.h
version.$(OBJEXT): {$(VPATH)}internal/method.h
version.$(OBJEXT): {$(VPATH)}internal/module.h
version.$(OBJEXT): {$(VPATH)}internal/newobj.h
version.$(OBJEXT): {$(VPATH)}internal/rgengc.h
version.$(OBJEXT): {$(VPATH)}internal/scan_args.h
version.$(OBJEXT): {$(VPATH)}internal/special_consts.h
version.$(OBJEXT): {$(VPATH)}internal/static_assert.h
version.$(OBJEXT): {$(VPATH)}internal/stdalign.h
version.$(OBJEXT): {$(VPATH)}internal/stdbool.h
version.$(OBJEXT): {$(VPATH)}internal/symbol.h
version.$(OBJEXT): {$(VPATH)}internal/value.h
version.$(OBJEXT): {$(VPATH)}internal/value_type.h
version.$(OBJEXT): {$(VPATH)}internal/variable.h
version.$(OBJEXT): {$(VPATH)}internal/warning_push.h
version.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
version.$(OBJEXT): {$(VPATH)}method.h
version.$(OBJEXT): {$(VPATH)}missing.h
version.$(OBJEXT): {$(VPATH)}mjit.h
version.$(OBJEXT): {$(VPATH)}node.h
version.$(OBJEXT): {$(VPATH)}revision.h
version.$(OBJEXT): {$(VPATH)}ruby_assert.h
version.$(OBJEXT): {$(VPATH)}ruby_atomic.h
version.$(OBJEXT): {$(VPATH)}shape.h
version.$(OBJEXT): {$(VPATH)}st.h
version.$(OBJEXT): {$(VPATH)}subst.h
version.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
version.$(OBJEXT): {$(VPATH)}thread_native.h
version.$(OBJEXT): {$(VPATH)}version.c
version.$(OBJEXT): {$(VPATH)}vm_core.h
version.$(OBJEXT): {$(VPATH)}vm_opts.h
version.$(OBJEXT): {$(VPATH)}yjit.h
vm.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
vm.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
vm.$(OBJEXT): $(CCAN_DIR)/list/list.h
vm.$(OBJEXT): $(CCAN_DIR)/str/str.h
vm.$(OBJEXT): $(hdrdir)/ruby.h
vm.$(OBJEXT): $(hdrdir)/ruby/ruby.h
vm.$(OBJEXT): $(top_srcdir)/internal/array.h
vm.$(OBJEXT): $(top_srcdir)/internal/bignum.h
vm.$(OBJEXT): $(top_srcdir)/internal/bits.h
vm.$(OBJEXT): $(top_srcdir)/internal/class.h
vm.$(OBJEXT): $(top_srcdir)/internal/compar.h
vm.$(OBJEXT): $(top_srcdir)/internal/compile.h
vm.$(OBJEXT): $(top_srcdir)/internal/compilers.h
vm.$(OBJEXT): $(top_srcdir)/internal/cont.h
vm.$(OBJEXT): $(top_srcdir)/internal/error.h
vm.$(OBJEXT): $(top_srcdir)/internal/eval.h
vm.$(OBJEXT): $(top_srcdir)/internal/fixnum.h
vm.$(OBJEXT): $(top_srcdir)/internal/gc.h
vm.$(OBJEXT): $(top_srcdir)/internal/hash.h
vm.$(OBJEXT): $(top_srcdir)/internal/imemo.h
vm.$(OBJEXT): $(top_srcdir)/internal/inits.h
vm.$(OBJEXT): $(top_srcdir)/internal/numeric.h
vm.$(OBJEXT): $(top_srcdir)/internal/object.h
vm.$(OBJEXT): $(top_srcdir)/internal/parse.h
vm.$(OBJEXT): $(top_srcdir)/internal/proc.h
vm.$(OBJEXT): $(top_srcdir)/internal/random.h
vm.$(OBJEXT): $(top_srcdir)/internal/re.h
vm.$(OBJEXT): $(top_srcdir)/internal/sanitizers.h
vm.$(OBJEXT): $(top_srcdir)/internal/serial.h
vm.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
vm.$(OBJEXT): $(top_srcdir)/internal/string.h
vm.$(OBJEXT): $(top_srcdir)/internal/struct.h
vm.$(OBJEXT): $(top_srcdir)/internal/symbol.h
vm.$(OBJEXT): $(top_srcdir)/internal/thread.h
vm.$(OBJEXT): $(top_srcdir)/internal/variable.h
vm.$(OBJEXT): $(top_srcdir)/internal/vm.h
vm.$(OBJEXT): $(top_srcdir)/internal/warnings.h
vm.$(OBJEXT): {$(VPATH)}assert.h
vm.$(OBJEXT): {$(VPATH)}atomic.h
vm.$(OBJEXT): {$(VPATH)}backward/2/assume.h
vm.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
vm.$(OBJEXT): {$(VPATH)}backward/2/bool.h
vm.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
vm.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
vm.$(OBJEXT): {$(VPATH)}backward/2/limits.h
vm.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
vm.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
vm.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
vm.$(OBJEXT): {$(VPATH)}builtin.h
vm.$(OBJEXT): {$(VPATH)}config.h
vm.$(OBJEXT): {$(VPATH)}constant.h
vm.$(OBJEXT): {$(VPATH)}debug_counter.h
vm.$(OBJEXT): {$(VPATH)}defines.h
vm.$(OBJEXT): {$(VPATH)}defs/opt_operand.def
vm.$(OBJEXT): {$(VPATH)}encoding.h
vm.$(OBJEXT): {$(VPATH)}eval_intern.h
vm.$(OBJEXT): {$(VPATH)}gc.h
vm.$(OBJEXT): {$(VPATH)}id.h
vm.$(OBJEXT): {$(VPATH)}id_table.h
vm.$(OBJEXT): {$(VPATH)}insns.def
vm.$(OBJEXT): {$(VPATH)}insns.inc
vm.$(OBJEXT): {$(VPATH)}insns_info.inc
vm.$(OBJEXT): {$(VPATH)}intern.h
vm.$(OBJEXT): {$(VPATH)}internal.h
vm.$(OBJEXT): {$(VPATH)}internal/abi.h
vm.$(OBJEXT): {$(VPATH)}internal/anyargs.h
vm.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
vm.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
vm.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
vm.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
vm.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
vm.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
vm.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
vm.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
vm.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
vm.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
vm.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
vm.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
vm.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
vm.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
vm.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
vm.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
vm.$(OBJEXT): {$(VPATH)}internal/assume.h
vm.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
vm.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
vm.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
vm.$(OBJEXT): {$(VPATH)}internal/attr/const.h
vm.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
vm.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
vm.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
vm.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
vm.$(OBJEXT): {$(VPATH)}internal/attr/error.h
vm.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
vm.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
vm.$(OBJEXT): {$(VPATH)}internal/attr/format.h
vm.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
vm.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
vm.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
vm.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
vm.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
vm.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
vm.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
vm.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
vm.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
vm.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
vm.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
vm.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
vm.$(OBJEXT): {$(VPATH)}internal/cast.h
vm.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
vm.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
vm.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
vm.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
vm.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
vm.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
vm.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
vm.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
vm.$(OBJEXT): {$(VPATH)}internal/config.h
vm.$(OBJEXT): {$(VPATH)}internal/constant_p.h
vm.$(OBJEXT): {$(VPATH)}internal/core.h
vm.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
vm.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
vm.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
vm.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
vm.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
vm.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
vm.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
vm.$(OBJEXT): {$(VPATH)}internal/core/robject.h
vm.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
vm.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
vm.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
vm.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
vm.$(OBJEXT): {$(VPATH)}internal/ctype.h
vm.$(OBJEXT): {$(VPATH)}internal/dllexport.h
vm.$(OBJEXT): {$(VPATH)}internal/dosish.h
vm.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
vm.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
vm.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
vm.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
vm.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
vm.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
vm.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
vm.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
vm.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
vm.$(OBJEXT): {$(VPATH)}internal/error.h
vm.$(OBJEXT): {$(VPATH)}internal/eval.h
vm.$(OBJEXT): {$(VPATH)}internal/event.h
vm.$(OBJEXT): {$(VPATH)}internal/fl_type.h
vm.$(OBJEXT): {$(VPATH)}internal/gc.h
vm.$(OBJEXT): {$(VPATH)}internal/glob.h
vm.$(OBJEXT): {$(VPATH)}internal/globals.h
vm.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
vm.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
vm.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
vm.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
vm.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
vm.$(OBJEXT): {$(VPATH)}internal/has/extension.h
vm.$(OBJEXT): {$(VPATH)}internal/has/feature.h
vm.$(OBJEXT): {$(VPATH)}internal/has/warning.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/array.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/class.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/error.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/file.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/io.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/load.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/object.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/process.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/random.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/range.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/re.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/select.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/string.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/time.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
vm.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
vm.$(OBJEXT): {$(VPATH)}internal/interpreter.h
vm.$(OBJEXT): {$(VPATH)}internal/iterator.h
vm.$(OBJEXT): {$(VPATH)}internal/memory.h
vm.$(OBJEXT): {$(VPATH)}internal/method.h
vm.$(OBJEXT): {$(VPATH)}internal/module.h
vm.$(OBJEXT): {$(VPATH)}internal/newobj.h
vm.$(OBJEXT): {$(VPATH)}internal/rgengc.h
vm.$(OBJEXT): {$(VPATH)}internal/scan_args.h
vm.$(OBJEXT): {$(VPATH)}internal/special_consts.h
vm.$(OBJEXT): {$(VPATH)}internal/static_assert.h
vm.$(OBJEXT): {$(VPATH)}internal/stdalign.h
vm.$(OBJEXT): {$(VPATH)}internal/stdbool.h
vm.$(OBJEXT): {$(VPATH)}internal/symbol.h
vm.$(OBJEXT): {$(VPATH)}internal/value.h
vm.$(OBJEXT): {$(VPATH)}internal/value_type.h
vm.$(OBJEXT): {$(VPATH)}internal/variable.h
vm.$(OBJEXT): {$(VPATH)}internal/warning_push.h
vm.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
vm.$(OBJEXT): {$(VPATH)}iseq.h
vm.$(OBJEXT): {$(VPATH)}method.h
vm.$(OBJEXT): {$(VPATH)}missing.h
vm.$(OBJEXT): {$(VPATH)}mjit.h
vm.$(OBJEXT): {$(VPATH)}node.h
vm.$(OBJEXT): {$(VPATH)}onigmo.h
vm.$(OBJEXT): {$(VPATH)}oniguruma.h
vm.$(OBJEXT): {$(VPATH)}probes.dmyh
vm.$(OBJEXT): {$(VPATH)}probes.h
vm.$(OBJEXT): {$(VPATH)}probes_helper.h
vm.$(OBJEXT): {$(VPATH)}ractor.h
vm.$(OBJEXT): {$(VPATH)}ractor_core.h
vm.$(OBJEXT): {$(VPATH)}ruby_assert.h
vm.$(OBJEXT): {$(VPATH)}ruby_atomic.h
vm.$(OBJEXT): {$(VPATH)}shape.h
vm.$(OBJEXT): {$(VPATH)}st.h
vm.$(OBJEXT): {$(VPATH)}subst.h
vm.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
vm.$(OBJEXT): {$(VPATH)}thread_native.h
vm.$(OBJEXT): {$(VPATH)}variable.h
vm.$(OBJEXT): {$(VPATH)}vm.c
vm.$(OBJEXT): {$(VPATH)}vm.h
vm.$(OBJEXT): {$(VPATH)}vm.inc
vm.$(OBJEXT): {$(VPATH)}vm_args.c
vm.$(OBJEXT): {$(VPATH)}vm_call_iseq_optimized.inc
vm.$(OBJEXT): {$(VPATH)}vm_callinfo.h
vm.$(OBJEXT): {$(VPATH)}vm_core.h
vm.$(OBJEXT): {$(VPATH)}vm_debug.h
vm.$(OBJEXT): {$(VPATH)}vm_eval.c
vm.$(OBJEXT): {$(VPATH)}vm_exec.c
vm.$(OBJEXT): {$(VPATH)}vm_exec.h
vm.$(OBJEXT): {$(VPATH)}vm_insnhelper.c
vm.$(OBJEXT): {$(VPATH)}vm_insnhelper.h
vm.$(OBJEXT): {$(VPATH)}vm_method.c
vm.$(OBJEXT): {$(VPATH)}vm_opts.h
vm.$(OBJEXT): {$(VPATH)}vm_sync.h
vm.$(OBJEXT): {$(VPATH)}vmtc.inc
vm.$(OBJEXT): {$(VPATH)}yjit.h
vm_backtrace.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
vm_backtrace.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
vm_backtrace.$(OBJEXT): $(CCAN_DIR)/list/list.h
vm_backtrace.$(OBJEXT): $(CCAN_DIR)/str/str.h
vm_backtrace.$(OBJEXT): $(hdrdir)/ruby/ruby.h
vm_backtrace.$(OBJEXT): $(top_srcdir)/internal/array.h
vm_backtrace.$(OBJEXT): $(top_srcdir)/internal/compilers.h
vm_backtrace.$(OBJEXT): $(top_srcdir)/internal/error.h
vm_backtrace.$(OBJEXT): $(top_srcdir)/internal/gc.h
vm_backtrace.$(OBJEXT): $(top_srcdir)/internal/imemo.h
vm_backtrace.$(OBJEXT): $(top_srcdir)/internal/serial.h
vm_backtrace.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
vm_backtrace.$(OBJEXT): $(top_srcdir)/internal/string.h
vm_backtrace.$(OBJEXT): $(top_srcdir)/internal/variable.h
vm_backtrace.$(OBJEXT): $(top_srcdir)/internal/vm.h
vm_backtrace.$(OBJEXT): $(top_srcdir)/internal/warnings.h
vm_backtrace.$(OBJEXT): {$(VPATH)}assert.h
vm_backtrace.$(OBJEXT): {$(VPATH)}atomic.h
vm_backtrace.$(OBJEXT): {$(VPATH)}backward/2/assume.h
vm_backtrace.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
vm_backtrace.$(OBJEXT): {$(VPATH)}backward/2/bool.h
vm_backtrace.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
vm_backtrace.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
vm_backtrace.$(OBJEXT): {$(VPATH)}backward/2/limits.h
vm_backtrace.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
vm_backtrace.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
vm_backtrace.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
vm_backtrace.$(OBJEXT): {$(VPATH)}config.h
vm_backtrace.$(OBJEXT): {$(VPATH)}constant.h
vm_backtrace.$(OBJEXT): {$(VPATH)}debug.h
vm_backtrace.$(OBJEXT): {$(VPATH)}defines.h
vm_backtrace.$(OBJEXT): {$(VPATH)}encoding.h
vm_backtrace.$(OBJEXT): {$(VPATH)}eval_intern.h
vm_backtrace.$(OBJEXT): {$(VPATH)}id.h
vm_backtrace.$(OBJEXT): {$(VPATH)}id_table.h
vm_backtrace.$(OBJEXT): {$(VPATH)}intern.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/abi.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/anyargs.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/assume.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/attr/const.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/attr/error.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/attr/format.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/cast.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/config.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/constant_p.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/core.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/core/robject.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/ctype.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/dllexport.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/dosish.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/error.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/eval.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/event.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/fl_type.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/gc.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/glob.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/globals.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/has/extension.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/has/feature.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/has/warning.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/array.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/class.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/error.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/file.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/io.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/load.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/object.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/process.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/random.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/range.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/re.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/select.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/string.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/time.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/interpreter.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/iterator.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/memory.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/method.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/module.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/newobj.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/rgengc.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/scan_args.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/special_consts.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/static_assert.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/stdalign.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/stdbool.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/symbol.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/value.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/value_type.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/variable.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/warning_push.h
vm_backtrace.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
vm_backtrace.$(OBJEXT): {$(VPATH)}iseq.h
vm_backtrace.$(OBJEXT): {$(VPATH)}method.h
vm_backtrace.$(OBJEXT): {$(VPATH)}missing.h
vm_backtrace.$(OBJEXT): {$(VPATH)}node.h
vm_backtrace.$(OBJEXT): {$(VPATH)}onigmo.h
vm_backtrace.$(OBJEXT): {$(VPATH)}oniguruma.h
vm_backtrace.$(OBJEXT): {$(VPATH)}ruby_assert.h
vm_backtrace.$(OBJEXT): {$(VPATH)}ruby_atomic.h
vm_backtrace.$(OBJEXT): {$(VPATH)}shape.h
vm_backtrace.$(OBJEXT): {$(VPATH)}st.h
vm_backtrace.$(OBJEXT): {$(VPATH)}subst.h
vm_backtrace.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
vm_backtrace.$(OBJEXT): {$(VPATH)}thread_native.h
vm_backtrace.$(OBJEXT): {$(VPATH)}vm_backtrace.c
vm_backtrace.$(OBJEXT): {$(VPATH)}vm_core.h
vm_backtrace.$(OBJEXT): {$(VPATH)}vm_opts.h
vm_dump.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
vm_dump.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
vm_dump.$(OBJEXT): $(CCAN_DIR)/list/list.h
vm_dump.$(OBJEXT): $(CCAN_DIR)/str/str.h
vm_dump.$(OBJEXT): $(hdrdir)/ruby/ruby.h
vm_dump.$(OBJEXT): $(top_srcdir)/internal/array.h
vm_dump.$(OBJEXT): $(top_srcdir)/internal/compilers.h
vm_dump.$(OBJEXT): $(top_srcdir)/internal/gc.h
vm_dump.$(OBJEXT): $(top_srcdir)/internal/imemo.h
vm_dump.$(OBJEXT): $(top_srcdir)/internal/serial.h
vm_dump.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
vm_dump.$(OBJEXT): $(top_srcdir)/internal/variable.h
vm_dump.$(OBJEXT): $(top_srcdir)/internal/vm.h
vm_dump.$(OBJEXT): $(top_srcdir)/internal/warnings.h
vm_dump.$(OBJEXT): {$(VPATH)}addr2line.h
vm_dump.$(OBJEXT): {$(VPATH)}assert.h
vm_dump.$(OBJEXT): {$(VPATH)}atomic.h
vm_dump.$(OBJEXT): {$(VPATH)}backward/2/assume.h
vm_dump.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
vm_dump.$(OBJEXT): {$(VPATH)}backward/2/bool.h
vm_dump.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
vm_dump.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
vm_dump.$(OBJEXT): {$(VPATH)}backward/2/limits.h
vm_dump.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
vm_dump.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
vm_dump.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
vm_dump.$(OBJEXT): {$(VPATH)}config.h
vm_dump.$(OBJEXT): {$(VPATH)}constant.h
vm_dump.$(OBJEXT): {$(VPATH)}defines.h
vm_dump.$(OBJEXT): {$(VPATH)}gc.h
vm_dump.$(OBJEXT): {$(VPATH)}id.h
vm_dump.$(OBJEXT): {$(VPATH)}id_table.h
vm_dump.$(OBJEXT): {$(VPATH)}intern.h
vm_dump.$(OBJEXT): {$(VPATH)}internal.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/abi.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/anyargs.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/assume.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/attr/const.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/attr/error.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/attr/format.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/cast.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/config.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/constant_p.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/core.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/core/robject.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/ctype.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/dllexport.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/dosish.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/error.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/eval.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/event.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/fl_type.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/gc.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/glob.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/globals.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/has/extension.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/has/feature.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/has/warning.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/array.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/class.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/error.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/file.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/io.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/load.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/object.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/process.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/random.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/range.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/re.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/select.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/string.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/time.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/interpreter.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/iterator.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/memory.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/method.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/module.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/newobj.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/rgengc.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/scan_args.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/special_consts.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/static_assert.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/stdalign.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/stdbool.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/symbol.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/value.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/value_type.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/variable.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/warning_push.h
vm_dump.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
vm_dump.$(OBJEXT): {$(VPATH)}iseq.h
vm_dump.$(OBJEXT): {$(VPATH)}method.h
vm_dump.$(OBJEXT): {$(VPATH)}missing.h
vm_dump.$(OBJEXT): {$(VPATH)}node.h
vm_dump.$(OBJEXT): {$(VPATH)}procstat_vm.c
vm_dump.$(OBJEXT): {$(VPATH)}ractor.h
vm_dump.$(OBJEXT): {$(VPATH)}ractor_core.h
vm_dump.$(OBJEXT): {$(VPATH)}ruby_assert.h
vm_dump.$(OBJEXT): {$(VPATH)}ruby_atomic.h
vm_dump.$(OBJEXT): {$(VPATH)}shape.h
vm_dump.$(OBJEXT): {$(VPATH)}st.h
vm_dump.$(OBJEXT): {$(VPATH)}subst.h
vm_dump.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
vm_dump.$(OBJEXT): {$(VPATH)}thread_native.h
vm_dump.$(OBJEXT): {$(VPATH)}vm_core.h
vm_dump.$(OBJEXT): {$(VPATH)}vm_debug.h
vm_dump.$(OBJEXT): {$(VPATH)}vm_dump.c
vm_dump.$(OBJEXT): {$(VPATH)}vm_opts.h
vm_sync.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
vm_sync.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
vm_sync.$(OBJEXT): $(CCAN_DIR)/list/list.h
vm_sync.$(OBJEXT): $(CCAN_DIR)/str/str.h
vm_sync.$(OBJEXT): $(hdrdir)/ruby/ruby.h
vm_sync.$(OBJEXT): $(top_srcdir)/internal/array.h
vm_sync.$(OBJEXT): $(top_srcdir)/internal/compilers.h
vm_sync.$(OBJEXT): $(top_srcdir)/internal/gc.h
vm_sync.$(OBJEXT): $(top_srcdir)/internal/imemo.h
vm_sync.$(OBJEXT): $(top_srcdir)/internal/serial.h
vm_sync.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
vm_sync.$(OBJEXT): $(top_srcdir)/internal/variable.h
vm_sync.$(OBJEXT): $(top_srcdir)/internal/vm.h
vm_sync.$(OBJEXT): $(top_srcdir)/internal/warnings.h
vm_sync.$(OBJEXT): {$(VPATH)}assert.h
vm_sync.$(OBJEXT): {$(VPATH)}atomic.h
vm_sync.$(OBJEXT): {$(VPATH)}backward/2/assume.h
vm_sync.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
vm_sync.$(OBJEXT): {$(VPATH)}backward/2/bool.h
vm_sync.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
vm_sync.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
vm_sync.$(OBJEXT): {$(VPATH)}backward/2/limits.h
vm_sync.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
vm_sync.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
vm_sync.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
vm_sync.$(OBJEXT): {$(VPATH)}config.h
vm_sync.$(OBJEXT): {$(VPATH)}constant.h
vm_sync.$(OBJEXT): {$(VPATH)}debug_counter.h
vm_sync.$(OBJEXT): {$(VPATH)}defines.h
vm_sync.$(OBJEXT): {$(VPATH)}gc.h
vm_sync.$(OBJEXT): {$(VPATH)}id.h
vm_sync.$(OBJEXT): {$(VPATH)}id_table.h
vm_sync.$(OBJEXT): {$(VPATH)}intern.h
vm_sync.$(OBJEXT): {$(VPATH)}internal.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/abi.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/anyargs.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/assume.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/attr/const.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/attr/error.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/attr/format.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/cast.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/config.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/constant_p.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/core.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/core/robject.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/ctype.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/dllexport.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/dosish.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/error.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/eval.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/event.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/fl_type.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/gc.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/glob.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/globals.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/has/extension.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/has/feature.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/has/warning.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/array.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/class.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/error.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/file.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/io.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/load.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/object.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/process.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/random.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/range.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/re.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/select.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/string.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/time.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/interpreter.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/iterator.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/memory.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/method.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/module.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/newobj.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/rgengc.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/scan_args.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/special_consts.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/static_assert.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/stdalign.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/stdbool.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/symbol.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/value.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/value_type.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/variable.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/warning_push.h
vm_sync.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
vm_sync.$(OBJEXT): {$(VPATH)}method.h
vm_sync.$(OBJEXT): {$(VPATH)}missing.h
vm_sync.$(OBJEXT): {$(VPATH)}node.h
vm_sync.$(OBJEXT): {$(VPATH)}ractor.h
vm_sync.$(OBJEXT): {$(VPATH)}ractor_core.h
vm_sync.$(OBJEXT): {$(VPATH)}ruby_assert.h
vm_sync.$(OBJEXT): {$(VPATH)}ruby_atomic.h
vm_sync.$(OBJEXT): {$(VPATH)}shape.h
vm_sync.$(OBJEXT): {$(VPATH)}st.h
vm_sync.$(OBJEXT): {$(VPATH)}subst.h
vm_sync.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
vm_sync.$(OBJEXT): {$(VPATH)}thread_native.h
vm_sync.$(OBJEXT): {$(VPATH)}vm_core.h
vm_sync.$(OBJEXT): {$(VPATH)}vm_debug.h
vm_sync.$(OBJEXT): {$(VPATH)}vm_opts.h
vm_sync.$(OBJEXT): {$(VPATH)}vm_sync.c
vm_sync.$(OBJEXT): {$(VPATH)}vm_sync.h
vm_trace.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
vm_trace.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
vm_trace.$(OBJEXT): $(CCAN_DIR)/list/list.h
vm_trace.$(OBJEXT): $(CCAN_DIR)/str/str.h
vm_trace.$(OBJEXT): $(hdrdir)/ruby.h
vm_trace.$(OBJEXT): $(hdrdir)/ruby/ruby.h
vm_trace.$(OBJEXT): $(top_srcdir)/internal/array.h
vm_trace.$(OBJEXT): $(top_srcdir)/internal/compilers.h
vm_trace.$(OBJEXT): $(top_srcdir)/internal/gc.h
vm_trace.$(OBJEXT): $(top_srcdir)/internal/hash.h
vm_trace.$(OBJEXT): $(top_srcdir)/internal/imemo.h
vm_trace.$(OBJEXT): $(top_srcdir)/internal/serial.h
vm_trace.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
vm_trace.$(OBJEXT): $(top_srcdir)/internal/symbol.h
vm_trace.$(OBJEXT): $(top_srcdir)/internal/variable.h
vm_trace.$(OBJEXT): $(top_srcdir)/internal/vm.h
vm_trace.$(OBJEXT): $(top_srcdir)/internal/warnings.h
vm_trace.$(OBJEXT): {$(VPATH)}assert.h
vm_trace.$(OBJEXT): {$(VPATH)}atomic.h
vm_trace.$(OBJEXT): {$(VPATH)}backward/2/assume.h
vm_trace.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
vm_trace.$(OBJEXT): {$(VPATH)}backward/2/bool.h
vm_trace.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
vm_trace.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
vm_trace.$(OBJEXT): {$(VPATH)}backward/2/limits.h
vm_trace.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
vm_trace.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
vm_trace.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
vm_trace.$(OBJEXT): {$(VPATH)}builtin.h
vm_trace.$(OBJEXT): {$(VPATH)}config.h
vm_trace.$(OBJEXT): {$(VPATH)}constant.h
vm_trace.$(OBJEXT): {$(VPATH)}debug.h
vm_trace.$(OBJEXT): {$(VPATH)}debug_counter.h
vm_trace.$(OBJEXT): {$(VPATH)}defines.h
vm_trace.$(OBJEXT): {$(VPATH)}encoding.h
vm_trace.$(OBJEXT): {$(VPATH)}eval_intern.h
vm_trace.$(OBJEXT): {$(VPATH)}id.h
vm_trace.$(OBJEXT): {$(VPATH)}id_table.h
vm_trace.$(OBJEXT): {$(VPATH)}intern.h
vm_trace.$(OBJEXT): {$(VPATH)}internal.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/abi.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/anyargs.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/assume.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/attr/const.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/attr/error.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/attr/format.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/cast.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/config.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/constant_p.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/core.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/core/robject.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/ctype.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/dllexport.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/dosish.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/error.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/eval.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/event.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/fl_type.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/gc.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/glob.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/globals.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/has/extension.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/has/feature.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/has/warning.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/array.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/class.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/error.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/file.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/io.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/load.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/object.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/process.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/random.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/range.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/re.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/select.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/string.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/time.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/interpreter.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/iterator.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/memory.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/method.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/module.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/newobj.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/rgengc.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/scan_args.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/special_consts.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/static_assert.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/stdalign.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/stdbool.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/symbol.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/value.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/value_type.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/variable.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/warning_push.h
vm_trace.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
vm_trace.$(OBJEXT): {$(VPATH)}iseq.h
vm_trace.$(OBJEXT): {$(VPATH)}method.h
vm_trace.$(OBJEXT): {$(VPATH)}missing.h
vm_trace.$(OBJEXT): {$(VPATH)}mjit.h
vm_trace.$(OBJEXT): {$(VPATH)}node.h
vm_trace.$(OBJEXT): {$(VPATH)}onigmo.h
vm_trace.$(OBJEXT): {$(VPATH)}oniguruma.h
vm_trace.$(OBJEXT): {$(VPATH)}ractor.h
vm_trace.$(OBJEXT): {$(VPATH)}ruby_assert.h
vm_trace.$(OBJEXT): {$(VPATH)}ruby_atomic.h
vm_trace.$(OBJEXT): {$(VPATH)}shape.h
vm_trace.$(OBJEXT): {$(VPATH)}st.h
vm_trace.$(OBJEXT): {$(VPATH)}subst.h
vm_trace.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
vm_trace.$(OBJEXT): {$(VPATH)}thread_native.h
vm_trace.$(OBJEXT): {$(VPATH)}trace_point.rbinc
vm_trace.$(OBJEXT): {$(VPATH)}vm_core.h
vm_trace.$(OBJEXT): {$(VPATH)}vm_opts.h
vm_trace.$(OBJEXT): {$(VPATH)}vm_trace.c
vm_trace.$(OBJEXT): {$(VPATH)}yjit.h
yjit.$(OBJEXT): $(CCAN_DIR)/check_type/check_type.h
yjit.$(OBJEXT): $(CCAN_DIR)/container_of/container_of.h
yjit.$(OBJEXT): $(CCAN_DIR)/list/list.h
yjit.$(OBJEXT): $(CCAN_DIR)/str/str.h
yjit.$(OBJEXT): $(hdrdir)/ruby/ruby.h
yjit.$(OBJEXT): $(top_srcdir)/internal/array.h
yjit.$(OBJEXT): $(top_srcdir)/internal/class.h
yjit.$(OBJEXT): $(top_srcdir)/internal/compile.h
yjit.$(OBJEXT): $(top_srcdir)/internal/compilers.h
yjit.$(OBJEXT): $(top_srcdir)/internal/cont.h
yjit.$(OBJEXT): $(top_srcdir)/internal/fixnum.h
yjit.$(OBJEXT): $(top_srcdir)/internal/gc.h
yjit.$(OBJEXT): $(top_srcdir)/internal/hash.h
yjit.$(OBJEXT): $(top_srcdir)/internal/imemo.h
yjit.$(OBJEXT): $(top_srcdir)/internal/sanitizers.h
yjit.$(OBJEXT): $(top_srcdir)/internal/serial.h
yjit.$(OBJEXT): $(top_srcdir)/internal/static_assert.h
yjit.$(OBJEXT): $(top_srcdir)/internal/string.h
yjit.$(OBJEXT): $(top_srcdir)/internal/variable.h
yjit.$(OBJEXT): $(top_srcdir)/internal/vm.h
yjit.$(OBJEXT): $(top_srcdir)/internal/warnings.h
yjit.$(OBJEXT): {$(VPATH)}assert.h
yjit.$(OBJEXT): {$(VPATH)}atomic.h
yjit.$(OBJEXT): {$(VPATH)}backward/2/assume.h
yjit.$(OBJEXT): {$(VPATH)}backward/2/attributes.h
yjit.$(OBJEXT): {$(VPATH)}backward/2/bool.h
yjit.$(OBJEXT): {$(VPATH)}backward/2/gcc_version_since.h
yjit.$(OBJEXT): {$(VPATH)}backward/2/inttypes.h
yjit.$(OBJEXT): {$(VPATH)}backward/2/limits.h
yjit.$(OBJEXT): {$(VPATH)}backward/2/long_long.h
yjit.$(OBJEXT): {$(VPATH)}backward/2/stdalign.h
yjit.$(OBJEXT): {$(VPATH)}backward/2/stdarg.h
yjit.$(OBJEXT): {$(VPATH)}builtin.h
yjit.$(OBJEXT): {$(VPATH)}config.h
yjit.$(OBJEXT): {$(VPATH)}constant.h
yjit.$(OBJEXT): {$(VPATH)}debug.h
yjit.$(OBJEXT): {$(VPATH)}debug_counter.h
yjit.$(OBJEXT): {$(VPATH)}defines.h
yjit.$(OBJEXT): {$(VPATH)}encoding.h
yjit.$(OBJEXT): {$(VPATH)}gc.h
yjit.$(OBJEXT): {$(VPATH)}id.h
yjit.$(OBJEXT): {$(VPATH)}id_table.h
yjit.$(OBJEXT): {$(VPATH)}insns.def
yjit.$(OBJEXT): {$(VPATH)}insns.inc
yjit.$(OBJEXT): {$(VPATH)}insns_info.inc
yjit.$(OBJEXT): {$(VPATH)}intern.h
yjit.$(OBJEXT): {$(VPATH)}internal.h
yjit.$(OBJEXT): {$(VPATH)}internal/abi.h
yjit.$(OBJEXT): {$(VPATH)}internal/anyargs.h
yjit.$(OBJEXT): {$(VPATH)}internal/arithmetic.h
yjit.$(OBJEXT): {$(VPATH)}internal/arithmetic/char.h
yjit.$(OBJEXT): {$(VPATH)}internal/arithmetic/double.h
yjit.$(OBJEXT): {$(VPATH)}internal/arithmetic/fixnum.h
yjit.$(OBJEXT): {$(VPATH)}internal/arithmetic/gid_t.h
yjit.$(OBJEXT): {$(VPATH)}internal/arithmetic/int.h
yjit.$(OBJEXT): {$(VPATH)}internal/arithmetic/intptr_t.h
yjit.$(OBJEXT): {$(VPATH)}internal/arithmetic/long.h
yjit.$(OBJEXT): {$(VPATH)}internal/arithmetic/long_long.h
yjit.$(OBJEXT): {$(VPATH)}internal/arithmetic/mode_t.h
yjit.$(OBJEXT): {$(VPATH)}internal/arithmetic/off_t.h
yjit.$(OBJEXT): {$(VPATH)}internal/arithmetic/pid_t.h
yjit.$(OBJEXT): {$(VPATH)}internal/arithmetic/short.h
yjit.$(OBJEXT): {$(VPATH)}internal/arithmetic/size_t.h
yjit.$(OBJEXT): {$(VPATH)}internal/arithmetic/st_data_t.h
yjit.$(OBJEXT): {$(VPATH)}internal/arithmetic/uid_t.h
yjit.$(OBJEXT): {$(VPATH)}internal/assume.h
yjit.$(OBJEXT): {$(VPATH)}internal/attr/alloc_size.h
yjit.$(OBJEXT): {$(VPATH)}internal/attr/artificial.h
yjit.$(OBJEXT): {$(VPATH)}internal/attr/cold.h
yjit.$(OBJEXT): {$(VPATH)}internal/attr/const.h
yjit.$(OBJEXT): {$(VPATH)}internal/attr/constexpr.h
yjit.$(OBJEXT): {$(VPATH)}internal/attr/deprecated.h
yjit.$(OBJEXT): {$(VPATH)}internal/attr/diagnose_if.h
yjit.$(OBJEXT): {$(VPATH)}internal/attr/enum_extensibility.h
yjit.$(OBJEXT): {$(VPATH)}internal/attr/error.h
yjit.$(OBJEXT): {$(VPATH)}internal/attr/flag_enum.h
yjit.$(OBJEXT): {$(VPATH)}internal/attr/forceinline.h
yjit.$(OBJEXT): {$(VPATH)}internal/attr/format.h
yjit.$(OBJEXT): {$(VPATH)}internal/attr/maybe_unused.h
yjit.$(OBJEXT): {$(VPATH)}internal/attr/noalias.h
yjit.$(OBJEXT): {$(VPATH)}internal/attr/nodiscard.h
yjit.$(OBJEXT): {$(VPATH)}internal/attr/noexcept.h
yjit.$(OBJEXT): {$(VPATH)}internal/attr/noinline.h
yjit.$(OBJEXT): {$(VPATH)}internal/attr/nonnull.h
yjit.$(OBJEXT): {$(VPATH)}internal/attr/noreturn.h
yjit.$(OBJEXT): {$(VPATH)}internal/attr/pure.h
yjit.$(OBJEXT): {$(VPATH)}internal/attr/restrict.h
yjit.$(OBJEXT): {$(VPATH)}internal/attr/returns_nonnull.h
yjit.$(OBJEXT): {$(VPATH)}internal/attr/warning.h
yjit.$(OBJEXT): {$(VPATH)}internal/attr/weakref.h
yjit.$(OBJEXT): {$(VPATH)}internal/cast.h
yjit.$(OBJEXT): {$(VPATH)}internal/compiler_is.h
yjit.$(OBJEXT): {$(VPATH)}internal/compiler_is/apple.h
yjit.$(OBJEXT): {$(VPATH)}internal/compiler_is/clang.h
yjit.$(OBJEXT): {$(VPATH)}internal/compiler_is/gcc.h
yjit.$(OBJEXT): {$(VPATH)}internal/compiler_is/intel.h
yjit.$(OBJEXT): {$(VPATH)}internal/compiler_is/msvc.h
yjit.$(OBJEXT): {$(VPATH)}internal/compiler_is/sunpro.h
yjit.$(OBJEXT): {$(VPATH)}internal/compiler_since.h
yjit.$(OBJEXT): {$(VPATH)}internal/config.h
yjit.$(OBJEXT): {$(VPATH)}internal/constant_p.h
yjit.$(OBJEXT): {$(VPATH)}internal/core.h
yjit.$(OBJEXT): {$(VPATH)}internal/core/rarray.h
yjit.$(OBJEXT): {$(VPATH)}internal/core/rbasic.h
yjit.$(OBJEXT): {$(VPATH)}internal/core/rbignum.h
yjit.$(OBJEXT): {$(VPATH)}internal/core/rclass.h
yjit.$(OBJEXT): {$(VPATH)}internal/core/rdata.h
yjit.$(OBJEXT): {$(VPATH)}internal/core/rfile.h
yjit.$(OBJEXT): {$(VPATH)}internal/core/rhash.h
yjit.$(OBJEXT): {$(VPATH)}internal/core/robject.h
yjit.$(OBJEXT): {$(VPATH)}internal/core/rregexp.h
yjit.$(OBJEXT): {$(VPATH)}internal/core/rstring.h
yjit.$(OBJEXT): {$(VPATH)}internal/core/rstruct.h
yjit.$(OBJEXT): {$(VPATH)}internal/core/rtypeddata.h
yjit.$(OBJEXT): {$(VPATH)}internal/ctype.h
yjit.$(OBJEXT): {$(VPATH)}internal/dllexport.h
yjit.$(OBJEXT): {$(VPATH)}internal/dosish.h
yjit.$(OBJEXT): {$(VPATH)}internal/encoding/coderange.h
yjit.$(OBJEXT): {$(VPATH)}internal/encoding/ctype.h
yjit.$(OBJEXT): {$(VPATH)}internal/encoding/encoding.h
yjit.$(OBJEXT): {$(VPATH)}internal/encoding/pathname.h
yjit.$(OBJEXT): {$(VPATH)}internal/encoding/re.h
yjit.$(OBJEXT): {$(VPATH)}internal/encoding/sprintf.h
yjit.$(OBJEXT): {$(VPATH)}internal/encoding/string.h
yjit.$(OBJEXT): {$(VPATH)}internal/encoding/symbol.h
yjit.$(OBJEXT): {$(VPATH)}internal/encoding/transcode.h
yjit.$(OBJEXT): {$(VPATH)}internal/error.h
yjit.$(OBJEXT): {$(VPATH)}internal/eval.h
yjit.$(OBJEXT): {$(VPATH)}internal/event.h
yjit.$(OBJEXT): {$(VPATH)}internal/fl_type.h
yjit.$(OBJEXT): {$(VPATH)}internal/gc.h
yjit.$(OBJEXT): {$(VPATH)}internal/glob.h
yjit.$(OBJEXT): {$(VPATH)}internal/globals.h
yjit.$(OBJEXT): {$(VPATH)}internal/has/attribute.h
yjit.$(OBJEXT): {$(VPATH)}internal/has/builtin.h
yjit.$(OBJEXT): {$(VPATH)}internal/has/c_attribute.h
yjit.$(OBJEXT): {$(VPATH)}internal/has/cpp_attribute.h
yjit.$(OBJEXT): {$(VPATH)}internal/has/declspec_attribute.h
yjit.$(OBJEXT): {$(VPATH)}internal/has/extension.h
yjit.$(OBJEXT): {$(VPATH)}internal/has/feature.h
yjit.$(OBJEXT): {$(VPATH)}internal/has/warning.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/array.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/bignum.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/class.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/compar.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/complex.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/cont.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/dir.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/enum.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/enumerator.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/error.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/eval.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/file.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/gc.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/hash.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/io.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/load.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/marshal.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/numeric.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/object.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/parse.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/proc.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/process.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/random.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/range.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/rational.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/re.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/ruby.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/select.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/select/largesize.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/signal.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/sprintf.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/string.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/struct.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/thread.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/time.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/variable.h
yjit.$(OBJEXT): {$(VPATH)}internal/intern/vm.h
yjit.$(OBJEXT): {$(VPATH)}internal/interpreter.h
yjit.$(OBJEXT): {$(VPATH)}internal/iterator.h
yjit.$(OBJEXT): {$(VPATH)}internal/memory.h
yjit.$(OBJEXT): {$(VPATH)}internal/method.h
yjit.$(OBJEXT): {$(VPATH)}internal/module.h
yjit.$(OBJEXT): {$(VPATH)}internal/newobj.h
yjit.$(OBJEXT): {$(VPATH)}internal/rgengc.h
yjit.$(OBJEXT): {$(VPATH)}internal/scan_args.h
yjit.$(OBJEXT): {$(VPATH)}internal/special_consts.h
yjit.$(OBJEXT): {$(VPATH)}internal/static_assert.h
yjit.$(OBJEXT): {$(VPATH)}internal/stdalign.h
yjit.$(OBJEXT): {$(VPATH)}internal/stdbool.h
yjit.$(OBJEXT): {$(VPATH)}internal/symbol.h
yjit.$(OBJEXT): {$(VPATH)}internal/value.h
yjit.$(OBJEXT): {$(VPATH)}internal/value_type.h
yjit.$(OBJEXT): {$(VPATH)}internal/variable.h
yjit.$(OBJEXT): {$(VPATH)}internal/warning_push.h
yjit.$(OBJEXT): {$(VPATH)}internal/xmalloc.h
yjit.$(OBJEXT): {$(VPATH)}iseq.h
yjit.$(OBJEXT): {$(VPATH)}method.h
yjit.$(OBJEXT): {$(VPATH)}missing.h
yjit.$(OBJEXT): {$(VPATH)}node.h
yjit.$(OBJEXT): {$(VPATH)}onigmo.h
yjit.$(OBJEXT): {$(VPATH)}oniguruma.h
yjit.$(OBJEXT): {$(VPATH)}probes.dmyh
yjit.$(OBJEXT): {$(VPATH)}probes.h
yjit.$(OBJEXT): {$(VPATH)}probes_helper.h
yjit.$(OBJEXT): {$(VPATH)}ruby_assert.h
yjit.$(OBJEXT): {$(VPATH)}ruby_atomic.h
yjit.$(OBJEXT): {$(VPATH)}shape.h
yjit.$(OBJEXT): {$(VPATH)}st.h
yjit.$(OBJEXT): {$(VPATH)}subst.h
yjit.$(OBJEXT): {$(VPATH)}thread_$(THREAD_MODEL).h
yjit.$(OBJEXT): {$(VPATH)}thread_native.h
yjit.$(OBJEXT): {$(VPATH)}vm_callinfo.h
yjit.$(OBJEXT): {$(VPATH)}vm_core.h
yjit.$(OBJEXT): {$(VPATH)}vm_debug.h
yjit.$(OBJEXT): {$(VPATH)}vm_insnhelper.h
yjit.$(OBJEXT): {$(VPATH)}vm_opts.h
yjit.$(OBJEXT): {$(VPATH)}vm_sync.h
yjit.$(OBJEXT): {$(VPATH)}yjit.c
yjit.$(OBJEXT): {$(VPATH)}yjit.h
yjit.$(OBJEXT): {$(VPATH)}yjit.rbinc
# AUTOGENERATED DEPENDENCIES END
