/************************************************

  class.c -

  $Author: matz $
  $Date: 1996/12/25 08:54:44 $
  created at: Tue Aug 10 15:05:44 JST 1993

  Copyright (C) 1993-1995 Yukihiro Matsumoto

************************************************/

#include "ruby.h"
#include "node.h"
#include "st.h"

struct st_table *new_idhash();
extern st_table *rb_class_tbl;

extern VALUE cClass;
extern VALUE cModule;

VALUE
class_new(super)
    VALUE super;
{
    NEWOBJ(cls, struct RClass);
    OBJSETUP(cls, cClass, T_CLASS);

    cls->super = super;
    cls->iv_tbl = 0;
    cls->m_tbl = 0;		/* safe GC */
    cls->m_tbl = new_idhash();

    return (VALUE)cls;
}

VALUE
singleton_class_new(super)
    VALUE super;
{
    struct RClass *cls = RCLASS(class_new(super));

    FL_SET(cls, FL_SINGLETON);

    return (VALUE)cls;
}

static int
clone_method(mid, body, tbl)
    ID mid;
    NODE *body;
    st_table *tbl;
{
    st_insert(tbl, mid, NEW_METHOD(body->nd_body, body->nd_noex));
    return ST_CONTINUE;
}

VALUE
singleton_class_clone(class)
    VALUE class;
{
    if (!FL_TEST(class, FL_SINGLETON))
	return class;
    else {
	/* copy singleton(unnamed) class */
	NEWOBJ(clone, struct RClass);
	CLONESETUP(clone, class);

	clone->super = RCLASS(class)->super;
	clone->iv_tbl = 0;
	clone->m_tbl = 0;
	clone->m_tbl = new_idhash();
	st_foreach(RCLASS(class)->m_tbl, clone_method, clone->m_tbl);
	FL_SET(clone, FL_SINGLETON);
	return (VALUE)clone;
    }
}

VALUE
rb_define_class_id(id, super)
    ID id;
    VALUE super;
{
    VALUE cls;

    if (!super) super = cObject;
    cls = class_new(super);
    rb_name_class(cls, id);
    /* make metaclass */
    RBASIC(cls)->class = singleton_class_new(RBASIC(super)->class);
    rb_funcall(super, rb_intern("inherited"), 1, cls);

    return (VALUE)cls;
}

VALUE
rb_define_class(name, super)
    char *name;
    VALUE super;
{
    VALUE class;
    ID id;

    id = rb_intern(name);
    class = rb_define_class_id(id, super);
    st_add_direct(rb_class_tbl, id, class);

    return class;
}

VALUE
rb_define_class_under(under, name, super)
    VALUE under;
    char *name;
    VALUE super;
{
    VALUE class;
    ID id;

    id = rb_intern(name);
    class = rb_define_class_id(id, super);
    rb_const_set(under, id, class);
    rb_set_class_path(class, under, name);

    return class;
}

VALUE
module_new()
{
    NEWOBJ(mdl, struct RClass);
    OBJSETUP(mdl, cModule, T_MODULE);

    mdl->super = 0;
    mdl->iv_tbl = 0;
    mdl->m_tbl = 0;
    mdl->m_tbl = new_idhash();

    return (VALUE)mdl;
}

VALUE
rb_define_module_id(id)
    ID id;
{
    extern st_table *rb_class_tbl;
    VALUE mdl = module_new();

    rb_name_class(mdl, id);

    return mdl;
}

VALUE
rb_define_module(name)
    char *name;
{
    VALUE module;
    ID id;

    id = rb_intern(name);
    module = rb_define_module_id(id);
    st_add_direct(rb_class_tbl, id, module);

    return module;
}

VALUE
rb_define_module_under(under, name)
    VALUE under;
    char *name;
{
    VALUE module;
    ID id;

    id = rb_intern(name);
    module = rb_define_module_id(id);
    rb_const_set(under, id, module);
    rb_set_class_path(module, under, name);

    return module;
}

static VALUE
include_class_new(module, super)
    VALUE module, super;
{
    NEWOBJ(cls, struct RClass);
    OBJSETUP(cls, cClass, T_ICLASS);

    cls->m_tbl = RCLASS(module)->m_tbl;
    cls->iv_tbl = RCLASS(module)->iv_tbl;
    cls->super = super;
    if (TYPE(module) == T_ICLASS) {
	RBASIC(cls)->class = RBASIC(module)->class;
    }
    else {
	RBASIC(cls)->class = module;
    }

    return (VALUE)cls;
}

void
rb_include_module(class, module)
    VALUE class, module;
{
    VALUE p;

    if (NIL_P(module)) return;

    switch (TYPE(module)) {
      case T_MODULE:
      case T_CLASS:
	break;
      default:
	Check_Type(module, T_MODULE);
    }

    if (class == module) return;
    rb_clear_cache();
 
    while (module) {
	/* ignore if the module included already in superclasses */
	for (p = RCLASS(class)->super; p; p = RCLASS(p)->super) {
	    if (BUILTIN_TYPE(p) == T_ICLASS &&
		RCLASS(p)->m_tbl == RCLASS(module)->m_tbl)
		return;
	}

	RCLASS(class)->super =
	    include_class_new(module, RCLASS(class)->super);
	class = RCLASS(class)->super;
	module = RCLASS(module)->super;
    }
}

VALUE
mod_included_modules(mod)
    VALUE mod;
{
    VALUE ary = ary_new();
    VALUE p;

    for (p = RCLASS(mod)->super; p; p = RCLASS(p)->super) {
	if (BUILTIN_TYPE(p) == T_ICLASS) {
	    ary_push(ary, RBASIC(p)->class);
	}
    }
    return ary;
}

VALUE
mod_ancestors(mod)
    VALUE mod;
{
    VALUE ary = ary_new();
    VALUE p;

    for (p = mod; p; p = RCLASS(p)->super) {
	if (BUILTIN_TYPE(p) == T_ICLASS) {
	    ary_push(ary, RBASIC(p)->class);
	}
	else {
	    ary_push(ary, p);
	}
    }
    return ary;
}

static int
ins_methods_i(key, body, ary)
    ID key;
    NODE *body;
    VALUE ary;
{
    if (!body->nd_noex) {
	VALUE name = str_new2(rb_id2name(key));

	if (!ary_includes(ary, name)) {
	    if (!body->nd_body) {
		ary_push(ary, Qnil);
	    }
	    ary_push(ary, name);
	}
    }
    else if (nd_type(body->nd_body) == NODE_ZSUPER) {
	ary_push(ary, Qnil);
	ary_push(ary, str_new2(rb_id2name(key)));
    }
    return ST_CONTINUE;
}

static int
ins_methods_priv_i(key, body, ary)
    ID key;
    NODE *body;
    VALUE ary;
{
    if (!body->nd_body) {
	ary_push(ary, Qnil);
	ary_push(ary, str_new2(rb_id2name(key)));
    }
    else if (body->nd_noex) {
	VALUE name = str_new2(rb_id2name(key));

	if (!ary_includes(ary, name)) {
	    ary_push(ary, name);
	}
    }
    else if (nd_type(body->nd_body) == NODE_ZSUPER) {
	ary_push(ary, Qnil);
	ary_push(ary, str_new2(rb_id2name(key)));
    }
    return ST_CONTINUE;
}

static VALUE
method_list(mod, option, func)
    VALUE mod;
    int option;
    int (*func)();
{
    VALUE ary;
    VALUE cl;
    VALUE *p, *q, *pend;

    ary = ary_new();
    for (cl = mod; cl; cl = RCLASS(cl)->super) {
	st_foreach(RCLASS(cl)->m_tbl, func, ary);
	if (!option) break;
    }
    p = q = RARRAY(ary)->ptr; pend = p + RARRAY(ary)->len;
    while (p < pend) {
	if (*p == Qnil) {
	    p+=2;
	    continue;
	}
	*q++ = *p++;
    }
    RARRAY(ary)->len = q - RARRAY(ary)->ptr;
    return ary;
}

VALUE
class_instance_methods(argc, argv, mod)
    int argc;
    VALUE *argv;
    VALUE mod;
{
    VALUE option;

    rb_scan_args(argc, argv, "01", &option);
    return method_list(mod, RTEST(option), ins_methods_i);
}

VALUE
class_private_instance_methods(argc, argv, mod)
    int argc;
    VALUE *argv;
    VALUE mod;
{
    VALUE option;

    rb_scan_args(argc, argv, "01", &option);
    return method_list(mod, RTEST(option), ins_methods_priv_i);
}

VALUE
obj_singleton_methods(obj)
    VALUE obj;
{
    VALUE ary;
    VALUE cl;
    VALUE *p, *q, *pend;

    ary = ary_new();
    cl = CLASS_OF(obj);
    while (cl && FL_TEST(cl, FL_SINGLETON)) {
	st_foreach(RCLASS(cl)->m_tbl, ins_methods_i, ary);
	cl = RCLASS(cl)->super;
    }
    p = q = RARRAY(ary)->ptr; pend = p + RARRAY(ary)->len;
    while (p < pend) {
	if (*p == Qnil) {
	    p+=2;
	    continue;
	}
	*q++ = *p++;
    }
    RARRAY(ary)->len = q - RARRAY(ary)->ptr;

    return ary;
}

void
rb_define_method_id(class, name, func, argc)
    VALUE class;
    ID name;
    VALUE (*func)();
    int argc;
{
    rb_add_method(class, name, NEW_CFUNC(func, argc), NOEX_PUBLIC);
}

void
rb_define_method(class, name, func, argc)
    VALUE class;
    char *name;
    VALUE (*func)();
    int argc;
{
    rb_add_method(class, rb_intern(name), NEW_CFUNC(func, argc), NOEX_PUBLIC);
}

void
rb_undef_method(class, name)
    VALUE class;
    char *name;
{
    rb_add_method(class, rb_intern(name), 0, NOEX_PUBLIC);
}

void
rb_define_private_method(class, name, func, argc)
    VALUE class;
    char *name;
    VALUE (*func)();
    int argc;
{
    rb_add_method(class, rb_intern(name), NEW_CFUNC(func, argc), NOEX_PRIVATE);
}

void
rb_define_function(class, name, func, argc)
    VALUE class;
    char *name;
    VALUE (*func)();
    int argc;
{
    rb_add_method(class, rb_intern(name), NEW_CFUNC(func, argc), NOEX_FUNCTION);
}

VALUE
rb_singleton_class(obj)
    VALUE obj;
{
    if (rb_special_const_p(obj)) {
	TypeError("cannot define singleton");
    }
    if (FL_TEST(RBASIC(obj)->class, FL_SINGLETON)) {
	return (VALUE)RBASIC(obj)->class;
    }
    return RBASIC(obj)->class = singleton_class_new(RBASIC(obj)->class);
}

void
rb_define_singleton_method(obj, name, func, argc)
    VALUE obj;
    char *name;
    VALUE (*func)();
    int argc;
{
    rb_define_method(rb_singleton_class(obj), name, func, argc);
}

void
rb_define_module_function(module, name, func, argc)
    VALUE module;
    char *name;
    VALUE (*func)();
    int argc;
{
    rb_define_function(module, name, func, argc);
    rb_define_singleton_method(module, name, func, argc);
}

VALUE mKernel;

void
rb_define_global_function(name, func, argc)
    char *name;
    VALUE (*func)();
    int argc;
{
    rb_define_function(mKernel, name, func, argc);
}

void
rb_define_alias(class, name1, name2)
    VALUE class;
    char *name1, *name2;
{
    rb_alias(class, rb_intern(name1), rb_intern(name2));
}

void
rb_define_attr(class, id, read, write)
    VALUE class;
    ID id;
    int read, write;
{
    char *name;
    char *buf;
    ID attr, attreq, attriv;

    name = rb_id2name(id);
    attr = rb_intern(name);
    buf = ALLOCA_N(char,strlen(name)+2);
    sprintf(buf, "%s=", name);
    attreq = rb_intern(buf);
    sprintf(buf, "@%s", name);
    attriv = rb_intern(buf);
    if (read) {
	rb_add_method(class, attr, NEW_IVAR(attriv), 0);
    }
    if (write) {
	rb_add_method(class, attreq, NEW_ATTRSET(attriv), 0);
    }
}

#include <varargs.h>
#include <ctype.h>

int
rb_scan_args(argc, argv, fmt, va_alist)
    int argc;
    VALUE *argv;
    char *fmt;
    va_dcl
{
    int n, i;
    char *p = fmt;
    VALUE *var;
    va_list vargs;

    va_start(vargs);

    if (*p == '*') {
	var = va_arg(vargs, VALUE*);
	*var = ary_new4(argc, argv);
	return argc;
    }

    if (isdigit(*p)) {
	n = *p - '0';
	if (n > argc)
	    ArgError("Wrong # of arguments (%d for %d)", argc, n);
	for (i=0; i<n; i++) {
	    var = va_arg(vargs, VALUE*);
	    *var = argv[i];
	}
	p++;
    }
    else {
	goto error;
    }

    if (isdigit(*p)) {
	n = i + *p - '0';
	for (; i<n; i++) {
	    var = va_arg(vargs, VALUE*);
	    if (argc > i) {
		*var = argv[i];
	    }
	    else {
		*var = Qnil;
	    }
	}
	p++;
    }

    if(*p == '*') {
	var = va_arg(vargs, VALUE*);
	if (argc > i) {
	    *var = ary_new4(argc-i, argv+i);
	}
	else {
	    *var = ary_new();
	}
    }
    else if (*p == '\0') {
	if (argc > i) {
	    ArgError("Wrong # of arguments(%d for %d)", argc, i);
	}
    }
    else {
	goto error;
    }

    va_end(vargs);
    return argc;

  error:
    Fatal("bad scan arg format: %s", fmt);
    return 0;
}
