#
#   synchronizer.rb - 2-եå饹
#   	$Release Version: 0.1$
#   	$Revision: 1.1 $
#   	$Date: 1997/04/03 05:57:15 $
#   	by Keiju ISHITSUKA
#
# --
#  Usage:
#   sync = Synchronizer.new
#   Synchronizer#mode
#   Synchronizer#locked?
#   Synchronizer#shared?
#   Synchronizer#exclusive?
#   Synchronizer#try_lock(mode) -- mode = :EX, :SH, :UN
#   Synchronizer#lock(mode)     -- mode = :EX, :SH, :UN
#   Synchronizer#unlock
#   Synchronizer#synchronize(mode) {...}
#   
#

unless defined? Thread
  fail "Thread not available for this ruby interpreter"
end

class Synchronizer
  RCS_ID='-$Header: /home/keiju/var/src/var.lib/ruby/RCS/synchronizer.rb,v 1.1 1997/04/03 05:57:15 keiju Exp keiju $-'
  
  class Err < Exception
    def Err.Fail(*opt)
      fail self, sprintf(self::Message, *opt)
    end
    
    class UnknownLocker < Err
      Message = "Thread(%s) not locked."
      def UnknownLocker.Fail(th)
	super(th.inspect)
      end
    end
    
    class LockModeFailer < Err
      Message = "Unknown lock mode(%s)"
      def LockModeFailer.Fail(mode)
	if mode.id2name
	  mode = id2name
	end
	super(mode)
      end
    end
  end
  
  def initialize
    @mode = :UN
    @waiting = []
    @upgrade_waiting = []
    @sh_locker = Hash.new
    @ex_locker = nil
    @ex_count = 0
  end
  
  attr :mode
  
  def locked?
    @mode != :UN
  end
  
  def shared?
    @mode == :SH
  end
  
  def exclusive?
    @mode == :EX
  end
  
  def try_lock(mode = :EX)
    return unlock if mode == :UN
    
    Thread.critical = TRUE
    ret = try_lock_sub(mode)
    Thread.critical = FALSE
    ret
  end

  def lock(mode = :EX)
    return unlock if mode == :UN

    until (Thread.critical = TRUE; try_lock_sub(mode))
      if @sh_locker[Thread.current]
	@upgrade_waiting.push [Thread.current, @sh_locker[Thread.current]]
	@sh_locker.delete(Thread.current)
      else
	@waiting.push Thread.current
      end
      Thread.stop
    end
    Thread.critical = FALSE
    self
  end

  def unlock()
    Thread.critical = TRUE
    runnable = FALSE
    case @mode
    when :UN
      Thread.critical = FALSE
      Err::UnknownLocker.Fail(Thread.current)
      
    when :EX
      if @ex_locker == Thread.current
	if (@ex_count -= 1) == 0
	  @ex_locker = nil
	  if @sh_locker.include?(Thread.current)
	    @mode = :SH
	  else
	    @mode = :UN
	  end
	  runnable = TRUE
	end
      else
	Err::UnknownLocker.Fail(Thread.current)
      end
      
    when :SH
      if (count = @sh_locker[Thread.current]).nil?
	Err::UnknownLocker.Fail(Thread.current)
      else
	if (@sh_locker[Thread.current] = count - 1) == 0 
	  @sh_locker.delete(Thread.current)
	  if @sh_locker.empty?
	    @mode = :UN
	    runnable = TRUE
	  end
	end
      end
    end
    
    if runnable
      if @upgrade_waiting.size > 0
	for k, v in @upgrade_waiting
	  @sh_locker[k] = v
	end
	wait = @upgrade_waiting
	@upgrade_waiting = []
	Thread.critical = FALSE
	
	for w, v in wait
	  w.run
	end
      else
	wait = @waiting
	@waiting = []
	Thread.critical = FALSE
	for w in wait
	  w.run
	end
      end
    end
    
    Thread.critical = FALSE
    self
  end
  

  def try_lock_sub(mode)
    case mode
    when :SH
      case @mode
      when :UN
	@mode = mode
	@sh_locker[Thread.current] = 1
	ret = TRUE
      when :SH
	count = 0 unless count = @sh_locker[Thread.current]
	@sh_locker[Thread.current] = count + 1
	ret = TRUE
      when :EX
	# , ⡼ɤEXǤ, ɬEXåȤʤ.
	if @ex_locker == Thread.current
	  @ex_count += 1
	  ret = TRUE
	else
	  ret = FALSE
	end
      end
    when :EX
      if @mode == :UN or
	@mode == :SH && @sh_locker.size == 1 && @sh_locker.include?(Thread.current) 
	@mode = mode
	@ex_locker = Thread.current
	@ex_count = 1
	ret = TRUE
      elsif @mode == :EX && @ex_locker == Thread.current
	@ex_count += 1
	ret = TRUE
      else
	ret = FALSE
      end
    else
      Thread.critical = FALSE
      Err::LockModeFailer.Fail mode
    end
  end
  private :try_lock_sub
  
  def synchronize(mode = :EX)
    begin
      lock(mode)
      yield
    ensure
      unlock
    end
  end
  
end
