/******************************************************************************
 * NOTE: This file has been modified for use with MSDOS and the WATCOM C/386
 * compiler.  Darryl Okahata, March 1993.
 *****************************************************************************/

/*
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#if defined(LIBC_SCCS) && !defined(lint)
static char sccsid[] = "@(#)tempnam.c	5.1 (Berkeley) 2/22/91";
#endif /* LIBC_SCCS and not lint */

#ifndef __WATCOMC__
# include <sys/param.h>
#endif
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#ifdef __WATCOMC__
# define MAXPATHLEN	257	/* a bit large, but what the hey? */
extern char	*mktemp(char *path);
#else
# include <unistd.h>
# include <paths.h>
#endif
#include <sys/stat.h>


#ifdef MSDOS

static char *tmpdirs[] = {
    "TMP",
    "TEMP",
    "TMPDIR",
    NULL
};

static char *get_tmpdir()
{
    int			i;
    char		*dir;
    struct stat		statbuf;
    static char		*tmpdir;
    static int		initialized;

    if (!initialized) {
	for (i = 0; tmpdirs[i] != NULL; ++i) {
	    if ((dir = getenv(tmpdirs[i])) == NULL) {
		continue;
	    }
	    if (stat(dir, &statbuf) == 0) {
		/*
		 * Found directory
		 */
		break;
	    }
	}
	if (tmpdirs[i] == NULL) {
	    tmpdir = NULL;
	} else {
	    if ((tmpdir = malloc(strlen(dir) + 1)) != NULL) {
		strcpy(tmpdir, dir);
	    }
	}
	initialized = 1;
    }
    return (tmpdir);
}
#endif	/* MSDOS */


char *
tempnam(dir, pfx)
	const char *dir, *pfx;
{
	int sverrno;
	char *f, *name;

	if (!(name = malloc(MAXPATHLEN + 1)))
		return(NULL);

	if (!pfx)
#ifdef MSDOS
		pfx = "tm";
#else
		pfx = "tmp.";
#endif

#ifdef MSDOS
	if ((f = get_tmpdir()) != NULL) {
		char	*cptr, *cptr2, last_was_backslash;

		(void)sprintf(name, "%s\\%sXXXXXX", f, pfx);
		last_was_backslash = 0;
		for (cptr = cptr2 = name; *cptr; ++cptr) {
			/*
			 * Force the use of backslashes, just in case the
			 * user is using a shell that doesn't like
			 * forward slashes (one that treats a forward
			 * slash like the end of a filename and the
			 * beginning of an option).
			 */
			if (*cptr == '/') {
				*cptr = '\\';
			}
			/*
			 * Compress adjacent backslashes into one backslash.
			 */
			if (!(last_was_backslash && *cptr == '\\')) {
				if ((*cptr2++ = *cptr) == '\\') {
					last_was_backslash = 1;
				} else {
					last_was_backslash = 0;
				}
			}
		}
		*cptr2 = '\0';
#else
	if (f = getenv("TMPDIR")) {
		(void)snprintf(name, MAXPATHLEN, "%s/%sXXXXXX", f, pfx);
#endif
		if (f = mktemp(name))
			return(f);
	}

	if (f = (char *)dir) {
#ifdef MSDOS
		(void)sprintf(name, "%s\\%sXXXXXX", f, pfx);
#else
		(void)snprintf(name, MAXPATHLEN, "%s/%sXXXXXX", f, pfx);
#endif
		if (f = mktemp(name))
			return(f);
	}

#ifdef MSDOS
	(void)sprintf(name, "\\%sXXXXXX", pfx);
#else
	f = P_tmpdir;
	(void)snprintf(name, MAXPATHLEN, "%s/%sXXXXXX", f, pfx);
#endif
	if (f = mktemp(name))
		return(f);

#ifndef MSDOS
	f = _PATH_TMP;
	(void)snprintf(name, MAXPATHLEN, "%s/%sXXXXXX", f, pfx);
	if (f = mktemp(name))
		return(f);
#endif

	sverrno = errno;
	free(name);
	errno = sverrno;
	return(NULL);
}
