package RISCOS::DrawFile::Options;

use strict;
use vars qw ($VERSION @ISA);

require RISCOS::DrawFile::OpaqueObject;

$VERSION = 0.02;
# 0.02 adds Translate

@ISA = 'RISCOS::DrawFile::OpaqueObject';

sub BBox { 0 }	# For the purpose of BBox merging we have none.
*BBox_Calc = \&BBox;
sub Translate { () };

1;
__END__

=head1 NAME

RISCOS::DrawFile::Options

=head1 SYNOPSIS

Class to handle options objects in DrawFiles

=head1 DESCRIPTION

C<RISCOS::DrawFile::Options> provides a class that stores objects used by
Draw and DrawPlus to save program options in a DrawFile. The only difference
between this class and its superclass C<RISCOS::DrawFile::OpaqueObject> is that
C<BBox> and C<BBox_Calc> return C<0> to signify that the object doesn't have a
bounding box for the purpose of file bounding box calculations.

=head1 BUGS

None known.

=head1 AUTHOR

Nicholas Clark <F<nick@unfortu.net>>
