#!/usr/bin/perl

package eBay::API::XML::DataType::BotBlockResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. BotBlockResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::BotBlockResponseType

=head1 DESCRIPTION

Container of token and image URL and Audio URL.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::BotBlockResponseType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'BotBlockAudioUrl', 'xs:string', '', '', '' ]
	, [ 'BotBlockToken', 'xs:string', '', '', '' ]
	, [ 'BotBlockUrl', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setBotBlockAudioUrl()

The URL of the audio-clip that your application should provide for sight-impaired users.
The BotBlockAudioUrl audio-clip corresponds to the BotBlockUrl image.

#    Argument: 'xs:string'

=cut

sub setBotBlockAudioUrl {
  my $self = shift;
  $self->{'BotBlockAudioUrl'} = shift
}

=head2 getBotBlockAudioUrl()

  Calls: PlaceOffer
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getBotBlockAudioUrl {
  my $self = shift;
  return $self->{'BotBlockAudioUrl'};
}


=head2 setBotBlockToken()

An encrypted token generated by eBay when the botblock
mechanism is triggered. This token is mapped to BotBlockUrl 
and BotBlockAudioUrl.

#    Argument: 'xs:string'

=cut

sub setBotBlockToken {
  my $self = shift;
  $self->{'BotBlockToken'} = shift
}

=head2 getBotBlockToken()

  Calls: PlaceOffer
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getBotBlockToken {
  my $self = shift;
  return $self->{'BotBlockToken'};
}


=head2 setBotBlockUrl()

The URL of the image that your application should display to
the user for a botblock challenge.

#    Argument: 'xs:string'

=cut

sub setBotBlockUrl {
  my $self = shift;
  $self->{'BotBlockUrl'} = shift
}

=head2 getBotBlockUrl()

  Calls: PlaceOffer
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getBotBlockUrl {
  my $self = shift;
  return $self->{'BotBlockUrl'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
