/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.operator.MaxFilterShape;

abstract class MaxFilterOpImage
extends AreaOpImage {
    protected MaxFilterShape maskType;
    protected int maskSize;

    public MaxFilterOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, MaxFilterShape maxFilterShape, int n) {
        super(renderedImage, imageLayout, map, true, borderExtender, (n - 1) / 2, (n - 1) / 2, n / 2, n / 2);
        this.maskType = maxFilterShape;
        this.maskSize = n;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rasterAccessor2, this.maskSize);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rasterAccessor2, this.maskSize);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rasterAccessor2, this.maskSize);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rasterAccessor2, this.maskSize);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rasterAccessor2, this.maskSize);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rasterAccessor2, this.maskSize);
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    protected abstract void byteLoop(RasterAccessor var1, RasterAccessor var2, int var3);

    protected abstract void shortLoop(RasterAccessor var1, RasterAccessor var2, int var3);

    protected abstract void ushortLoop(RasterAccessor var1, RasterAccessor var2, int var3);

    protected abstract void intLoop(RasterAccessor var1, RasterAccessor var2, int var3);

    protected abstract void floatLoop(RasterAccessor var1, RasterAccessor var2, int var3);

    protected abstract void doubleLoop(RasterAccessor var1, RasterAccessor var2, int var3);

    static final int maxFilter(int[] nArray) {
        if (nArray.length == 3) {
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = nArray[2];
            if (n < n2) {
                return n2 < n3 ? n3 : n2;
            }
            return n < n3 ? n3 : n;
        }
        int n = nArray[0];
        int n4 = 1;
        while (n4 < nArray.length) {
            if (n < nArray[n4]) {
                n = nArray[n4];
            }
            ++n4;
        }
        return n;
    }

    static final float maxFilterFloat(float[] fArray) {
        if (fArray.length == 3) {
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            if (f < f2) {
                return f2 < f3 ? f3 : f2;
            }
            return f < f3 ? f3 : f;
        }
        float f = fArray[0];
        int n = 1;
        while (n < fArray.length) {
            if (f < fArray[n]) {
                f = fArray[n];
            }
            ++n;
        }
        return f;
    }

    static final double maxFilterDouble(double[] dArray) {
        if (dArray.length == 3) {
            double d = dArray[0];
            double d2 = dArray[1];
            double d3 = dArray[2];
            if (d < d2) {
                return d2 < d3 ? d3 : d2;
            }
            return d < d3 ? d3 : d;
        }
        double d = dArray[0];
        int n = 1;
        while (n < dArray.length) {
            if (d < dArray[n]) {
                d = dArray[n];
            }
            ++n;
        }
        return d;
    }
}

