/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.core.symbol.trie;

import java.util.HashMap;
import org.maltparser.core.symbol.SymbolException;
import org.maltparser.core.symbol.trie.TrieEntry;
import org.maltparser.core.symbol.trie.TrieSymbolTable;

public class TrieNode {
    private static final int INITIAL_CAPACITY = 2;
    private char character;
    private HashMap<TrieSymbolTable, TrieEntry> entries;
    private TrieSymbolTable cachedKeyEntry;
    private TrieEntry cachedValueEntry;
    private HashMap<Character, TrieNode> children;
    private char cachedKeyChar;
    private TrieNode cachedValueTrieNode;
    private TrieNode parent;

    public TrieNode(char character, TrieNode parent) {
        this.character = character;
        this.parent = parent;
    }

    public TrieNode getOrAddChild(boolean isWord, char c, TrieSymbolTable table, int code) throws SymbolException {
        if (this.cachedValueTrieNode == null) {
            this.cachedValueTrieNode = new TrieNode(c, this);
            this.cachedKeyChar = c;
            if (isWord) {
                this.cachedValueTrieNode.addEntry(table, code);
            }
            return this.cachedValueTrieNode;
        }
        if (this.cachedKeyChar == c) {
            if (isWord) {
                this.cachedValueTrieNode.addEntry(table, code);
            }
            return this.cachedValueTrieNode;
        }
        TrieNode child = null;
        if (this.children == null) {
            this.children = new HashMap(2);
            child = new TrieNode(c, this);
            this.children.put(Character.valueOf(c), child);
        } else {
            child = this.children.get(Character.valueOf(c));
            if (child == null) {
                child = new TrieNode(c, this);
                this.children.put(Character.valueOf(c), child);
            }
        }
        if (isWord) {
            child.addEntry(table, code);
        }
        return child;
    }

    private void addEntry(TrieSymbolTable table, int code) throws SymbolException {
        if (table == null) {
            throw new SymbolException("Symbol table cannot be found. ");
        }
        if (this.cachedValueEntry == null) {
            if (code != -1) {
                this.cachedValueEntry = new TrieEntry(code, true);
                table.updateValueCounter(code);
            } else {
                this.cachedValueEntry = new TrieEntry(table.increaseValueCounter(), false);
            }
            this.cachedKeyEntry = table;
        } else if (!table.equals(this.cachedKeyEntry)) {
            if (this.entries == null) {
                this.entries = new HashMap(2);
            }
            if (!this.entries.containsKey(table)) {
                if (code != -1) {
                    this.entries.put(table, new TrieEntry(code, true));
                    table.updateValueCounter(code);
                } else {
                    this.entries.put(table, new TrieEntry(table.increaseValueCounter(), false));
                }
            }
        }
    }

    public TrieNode getChild(char c) {
        if (this.cachedKeyChar == c) {
            return this.cachedValueTrieNode;
        }
        if (this.children != null) {
            return this.children.get(Character.valueOf(c));
        }
        return null;
    }

    public TrieEntry getEntry(TrieSymbolTable table) {
        if (table != null) {
            if (table.equals(this.cachedKeyEntry)) {
                return this.cachedValueEntry;
            }
            if (this.entries != null) {
                return this.entries.get(table);
            }
        }
        return null;
    }

    public char getCharacter() {
        return this.character;
    }

    public TrieNode getParent() {
        return this.parent;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.character);
        return sb.toString();
    }
}

