/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.internal.referencing.provider.GeodeticOperation;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.referencing.operation.transform.EllipsoidToCentricTransform;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;

public final class GeographicToGeocentric
extends GeodeticOperation {
    private static final long serialVersionUID = -5690807111952562344L;
    public static final String NAME = "Ellipsoid_To_Geocentric";
    public static final ParameterDescriptor<Integer> DIMENSION;
    public static final ParameterDescriptorGroup PARAMETERS;

    public GeographicToGeocentric() {
        this(3, new GeographicToGeocentric[4]);
        this.redimensioned[1] = new GeographicToGeocentric(2, this.redimensioned);
        this.redimensioned[3] = this;
    }

    private GeographicToGeocentric(int n, GeodeticOperation[] geodeticOperationArray) {
        super(n, 3, PARAMETERS, geodeticOperationArray);
    }

    public Class<Conversion> getOperationType() {
        return Conversion.class;
    }

    @Override
    public String resolveAmbiguity(DefaultMathTransformFactory.Context context) {
        if (context.getSourceCS() instanceof CartesianCS && context.getTargetCS() instanceof EllipsoidalCS) {
            return "Geocentric_To_Ellipsoid";
        }
        return super.resolveAmbiguity(context);
    }

    @Override
    public int getEllipsoidsMask() {
        return 1;
    }

    @Override
    public boolean isInvertible() {
        return false;
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory mathTransformFactory, ParameterValueGroup parameterValueGroup) throws FactoryException {
        return GeographicToGeocentric.create(mathTransformFactory, Parameters.castOrWrap(parameterValueGroup));
    }

    static MathTransform create(MathTransformFactory mathTransformFactory, Parameters parameters) throws FactoryException {
        ParameterValue<?> parameterValue = parameters.parameter("semi_major");
        Unit<Length> unit = parameterValue.getUnit().asType(Length.class);
        return EllipsoidToCentricTransform.createGeodeticConversion(mathTransformFactory, parameterValue.doubleValue(), parameters.parameter("semi_minor").doubleValue(unit), unit, parameters.intValue(DIMENSION) >= 3, EllipsoidToCentricTransform.TargetType.CARTESIAN);
    }

    static {
        ParameterBuilder parameterBuilder = GeographicToGeocentric.builder();
        DIMENSION = ((ParameterBuilder)parameterBuilder.addName(Citations.SIS, "dim")).setRequired(false).createBounded(Integer.class, Integer.valueOf(2), Integer.valueOf(3), 3);
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("9602")).addName("Geographic/geocentric conversions")).addName(Citations.OGC, NAME)).createGroupForMapProjection(DIMENSION);
    }
}

