/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.FeatureOperations;
import org.apache.sis.feature.LinkOperation;
import org.apache.sis.feature.Property;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.feature.AttributeConvention;
import org.apache.sis.internal.feature.FeatureUtilities;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.referencing.CRS;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class EnvelopeOperation
extends AbstractOperation {
    private static final long serialVersionUID = 6250548001562807671L;
    private static final ParameterDescriptorGroup EMPTY_PARAMS = FeatureUtilities.parameters("Envelope", new ParameterDescriptor[0]);
    private final String[] attributeNames;
    final CoordinateReferenceSystem crs;
    private final CoordinateOperation[] attributeToCRS;
    private transient Set<String> dependencies;
    private final DefaultAttributeType<Envelope> resultType;

    EnvelopeOperation(Map<String, ?> map, CoordinateReferenceSystem object, AbstractIdentifiedType[] abstractIdentifiedTypeArray) throws FactoryException {
        super(map);
        Object object2;
        Object object3;
        String string = null;
        String string2 = AttributeConvention.CRS_CHARACTERISTIC.toString();
        boolean bl = false;
        LinkedHashMap linkedHashMap = new LinkedHashMap(4);
        for (AbstractIdentifiedType abstractIdentifiedType : abstractIdentifiedTypeArray) {
            if (!AttributeConvention.isGeometryAttribute(abstractIdentifiedType)) continue;
            object3 = abstractIdentifiedType.getName();
            object2 = abstractIdentifiedType instanceof LinkOperation ? ((LinkOperation)abstractIdentifiedType).referentName : object3.toString();
            boolean bl2 = AttributeConvention.GEOMETRY_PROPERTY.equals(object3);
            if (bl2) {
                string = object2;
            }
            CoordinateReferenceSystem coordinateReferenceSystem = null;
            while (abstractIdentifiedType instanceof AbstractOperation) {
                abstractIdentifiedType = ((AbstractOperation)abstractIdentifiedType).getResult();
            }
            DefaultAttributeType<?> defaultAttributeType = ((DefaultAttributeType)abstractIdentifiedType).characteristics().get(string2);
            if (defaultAttributeType != null && CoordinateReferenceSystem.class.isAssignableFrom(defaultAttributeType.getValueClass())) {
                coordinateReferenceSystem = (CoordinateReferenceSystem)defaultAttributeType.getDefaultValue();
                if (object == null && bl2) {
                    object = coordinateReferenceSystem;
                }
                bl = true;
            }
            JDK8.putIfAbsent(linkedHashMap, object2, coordinateReferenceSystem);
        }
        linkedHashMap.remove(null);
        this.attributeNames = new String[linkedHashMap.size()];
        this.attributeToCRS = bl ? new CoordinateOperation[this.attributeNames.length] : null;
        int n = string == null ? 0 : 1;
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            CoordinateOperation coordinateOperation;
            int n2;
            object3 = (String)entry.getKey();
            if (((String)object3).equals(string)) {
                string = null;
                n2 = 0;
            } else {
                n2 = n++;
            }
            this.attributeNames[n2] = object3;
            if (!bl || (object2 = (CoordinateReferenceSystem)entry.getValue()) == null) continue;
            if (object == null) {
                object = object2;
            }
            if ((coordinateOperation = CRS.findOperation((CoordinateReferenceSystem)object2, (CoordinateReferenceSystem)object, null)).getMathTransform().isIdentity()) continue;
            this.attributeToCRS[n2] = coordinateOperation;
        }
        this.resultType = FeatureOperations.POOL.unique(new DefaultAttributeType<Object>(this.resultIdentification(map), Envelope.class, 1, 1, null, new DefaultAttributeType[0]));
        this.crs = object;
    }

    @Override
    public ParameterDescriptorGroup getParameters() {
        return EMPTY_PARAMS;
    }

    @Override
    public AbstractIdentifiedType getResult() {
        return this.resultType;
    }

    @Override
    public synchronized Set<String> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = CollectionsExt.immutableSet(true, this.attributeNames);
        }
        return this.dependencies;
    }

    @Override
    public Property apply(AbstractFeature abstractFeature, ParameterValueGroup parameterValueGroup) {
        return new Result(abstractFeature);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Arrays.hashCode(this.attributeNames) + Arrays.hashCode(this.attributeToCRS);
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            EnvelopeOperation envelopeOperation = (EnvelopeOperation)object;
            return Arrays.equals(this.attributeNames, envelopeOperation.attributeNames) && Arrays.equals(this.attributeToCRS, envelopeOperation.attributeToCRS) && Objects.equals(this.crs, envelopeOperation.crs);
        }
        return false;
    }

    private final class Result
    extends AbstractAttribute<Envelope> {
        private static final long serialVersionUID = 926172863066901618L;
        private final AbstractFeature feature;

        Result(AbstractFeature abstractFeature) {
            super(EnvelopeOperation.this.resultType);
            this.feature = abstractFeature;
        }

        @Override
        public Envelope getValue() throws IllegalStateException {
            String[] stringArray = EnvelopeOperation.this.attributeNames;
            GeneralEnvelope generalEnvelope = null;
            for (int i = 0; i < stringArray.length; ++i) {
                Envelope envelope;
                String string = stringArray[i];
                if (EnvelopeOperation.this.attributeToCRS == null) {
                    envelope = Geometries.getEnvelope(this.feature.getPropertyValue(string));
                    if (envelope == null) {
                        continue;
                    }
                } else {
                    Property property = (Property)this.feature.getProperty(string);
                    envelope = Geometries.getEnvelope(property.getValue());
                    if (envelope == null) continue;
                    AbstractAttribute<?> abstractAttribute = ((AbstractAttribute)property).characteristics().get(AttributeConvention.CRS_CHARACTERISTIC.toString());
                    try {
                        Object object;
                        if (abstractAttribute == null) {
                            object = EnvelopeOperation.this.attributeToCRS[i];
                            if (object != null) {
                                envelope = Envelopes.transform(object, envelope);
                            }
                        } else {
                            object = abstractAttribute.getValue();
                            if (!(object instanceof CoordinateReferenceSystem)) {
                                throw new IllegalStateException(Errors.format((short)157));
                            }
                            envelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)object);
                            envelope = Envelopes.transform(envelope, EnvelopeOperation.this.crs);
                        }
                    }
                    catch (TransformException transformException) {
                        throw new IllegalStateException(Errors.format((short)16), transformException);
                    }
                }
                if (generalEnvelope == null) {
                    generalEnvelope = GeneralEnvelope.castOrCopy(envelope);
                    continue;
                }
                generalEnvelope.add(envelope);
            }
            return generalEnvelope;
        }

        @Override
        public void setValue(Envelope envelope) {
            throw new UnsupportedOperationException(Errors.format((short)153, AbstractAttribute.class));
        }
    }
}

