/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.hslf.exceptions.CorruptPowerPointFileException;
import org.apache.poi.hslf.exceptions.OldPowerPointFormatException;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.util.StringUtil;

public class CurrentUserAtom {
    private static final POILogger logger = POILogFactory.getLogger(CurrentUserAtom.class);
    public static final byte[] atomHeader = new byte[]{0, 0, -10, 15};
    public static final byte[] headerToken = new byte[]{95, -64, -111, -29};
    public static final byte[] encHeaderToken = new byte[]{-33, -60, -47, -13};
    public static final byte[] ppt97FileVer = new byte[]{8, 0, -13, 3, 3, 0};
    private int docFinalVersion;
    private byte docMajorNo;
    private byte docMinorNo;
    private long currentEditOffset;
    private String lastEditUser;
    private long releaseVersion;
    private byte[] _contents;
    private boolean isEncrypted;

    public int getDocFinalVersion() {
        return this.docFinalVersion;
    }

    public byte getDocMajorNo() {
        return this.docMajorNo;
    }

    public byte getDocMinorNo() {
        return this.docMinorNo;
    }

    public long getReleaseVersion() {
        return this.releaseVersion;
    }

    public void setReleaseVersion(long rv) {
        this.releaseVersion = rv;
    }

    public long getCurrentEditOffset() {
        return this.currentEditOffset;
    }

    public void setCurrentEditOffset(long id) {
        this.currentEditOffset = id;
    }

    public String getLastEditUsername() {
        return this.lastEditUser;
    }

    public void setLastEditUsername(String u) {
        this.lastEditUser = u;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public void setEncrypted(boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
    }

    public CurrentUserAtom() {
        this._contents = new byte[0];
        this.docFinalVersion = 1012;
        this.docMajorNo = (byte)3;
        this.docMinorNo = 0;
        this.releaseVersion = 8L;
        this.currentEditOffset = 0L;
        this.lastEditUser = "Apache POI";
        this.isEncrypted = false;
    }

    public CurrentUserAtom(DirectoryNode dir) throws IOException {
        DocumentEntry docProps = (DocumentEntry)dir.getEntry("Current User");
        if (docProps.getSize() > 131072) {
            throw new CorruptPowerPointFileException("The Current User stream is implausably long. It's normally 28-200 bytes long, but was " + docProps.getSize() + " bytes");
        }
        int len = docProps.getSize();
        this._contents = new byte[len];
        DocumentInputStream in = dir.createDocumentInputStream("Current User");
        int readLen = ((InputStream)in).read(this._contents);
        ((InputStream)in).close();
        if (len != readLen) {
            throw new IOException("Current User input stream ended prematurely - expected " + len + " bytes - received " + readLen + " bytes");
        }
        if (this._contents.length < 28) {
            boolean isPP95 = dir.hasEntry("PP40");
            if (!isPP95 && this._contents.length >= 4) {
                int size = LittleEndian.getInt(this._contents);
                boolean bl = isPP95 = size + 4 == this._contents.length;
            }
            if (isPP95) {
                throw new OldPowerPointFormatException("Based on the Current User stream, you seem to have supplied a PowerPoint95 file, which isn't supported");
            }
            throw new CorruptPowerPointFileException("The Current User stream must be at least 28 bytes long, but was only " + this._contents.length);
        }
        this.init();
    }

    private void init() {
        this.isEncrypted = LittleEndian.getInt(encHeaderToken) == LittleEndian.getInt(this._contents, 12);
        this.currentEditOffset = LittleEndian.getUInt(this._contents, 16);
        this.docFinalVersion = LittleEndian.getUShort(this._contents, 22);
        this.docMajorNo = this._contents[24];
        this.docMinorNo = this._contents[25];
        long usernameLen = LittleEndian.getUShort(this._contents, 20);
        if (usernameLen > 512L) {
            logger.log(5, "Warning - invalid username length " + usernameLen + " found, treating as if there was no username set");
            usernameLen = 0L;
        }
        this.releaseVersion = this._contents.length >= 28 + (int)usernameLen + 4 ? LittleEndian.getUInt(this._contents, 28 + (int)usernameLen) : 0L;
        int start = 28 + (int)usernameLen + 4;
        int len = 2 * (int)usernameLen;
        if (this._contents.length >= start + len) {
            byte[] textBytes = new byte[len];
            System.arraycopy(this._contents, start, textBytes, 0, len);
            this.lastEditUser = StringUtil.getFromUnicodeLE(textBytes);
        } else {
            byte[] textBytes = new byte[(int)usernameLen];
            System.arraycopy(this._contents, 28, textBytes, 0, (int)usernameLen);
            this.lastEditUser = StringUtil.getFromCompressedUnicode(textBytes, 0, (int)usernameLen);
        }
    }

    public void writeOut(OutputStream out) throws IOException {
        int size = 32 + 3 * this.lastEditUser.length();
        this._contents = new byte[size];
        System.arraycopy(atomHeader, 0, this._contents, 0, 4);
        int atomSize = 24 + this.lastEditUser.length();
        LittleEndian.putInt(this._contents, 4, atomSize);
        LittleEndian.putInt(this._contents, 8, 20);
        System.arraycopy(this.isEncrypted ? encHeaderToken : headerToken, 0, this._contents, 12, 4);
        LittleEndian.putInt(this._contents, 16, (int)this.currentEditOffset);
        byte[] asciiUN = new byte[this.lastEditUser.length()];
        StringUtil.putCompressedUnicode(this.lastEditUser, asciiUN, 0);
        LittleEndian.putShort(this._contents, 20, (short)asciiUN.length);
        LittleEndian.putShort(this._contents, 22, (short)this.docFinalVersion);
        this._contents[24] = this.docMajorNo;
        this._contents[25] = this.docMinorNo;
        this._contents[26] = 0;
        this._contents[27] = 0;
        System.arraycopy(asciiUN, 0, this._contents, 28, asciiUN.length);
        LittleEndian.putInt(this._contents, 28 + asciiUN.length, (int)this.releaseVersion);
        byte[] ucUN = new byte[this.lastEditUser.length() * 2];
        StringUtil.putUnicodeLE(this.lastEditUser, ucUN, 0);
        System.arraycopy(ucUN, 0, this._contents, 28 + asciiUN.length + 4, ucUN.length);
        out.write(this._contents);
    }

    public void writeToFS(NPOIFSFileSystem fs) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeOut(baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        fs.createOrUpdateDocument(bais, "Current User");
    }
}

